<!-- when editing this file also update https://github.com/flutter/.github/blob/main/CONTRIBUTING.md -->

Contributing to Flutter
=======================

_tl;dr: join [Discord](https://github.com/flutter/flutter/wiki/Chat), be [courteous](CODE_OF_CONDUCT.md), follow the steps below to set up a development environment; if you stick around and contribute, you can [join the team](https://github.com/flutter/flutter/wiki/Contributor-access) and get commit access._

Welcome
-------

We invite you to join our team! Everyone is welcome to contribute code
via pull requests, to file issues on GitHub, to help people asking for
help on our mailing lists, our chat channels, or on Stack Overflow, to
help triage, reproduce, or fix bugs that people have filed, to add to our
documentation, or to help out in any other way.

We grant commit access (which includes full rights to the issue
database, such as being able to edit labels) to people who have gained
our trust and demonstrated a commitment to Flutter. For more details
see the [Contributor access](https://github.com/flutter/flutter/wiki/Contributor-access)
page on our wiki.

We communicate primarily over GitHub and [Discord](https://github.com/flutter/flutter/wiki/Chat).

_See also: [Flutter's code of conduct](CODE_OF_CONDUCT.md)_

Helping out in the issue database
---------------------------------

If you want to help us triage, you are very welcome to do so!

1. Join the #hackers-triage [Discord channel](https://github.com/flutter/flutter/wiki/Chat).

2. Read [our code of conduct](CODE_OF_CONDUCT.md), which stipulates explicitly
   that everyone must be gracious, respectful, and professional. If you're helping out
   with triage, you are representing the Flutter team, and so you want to make sure to
   make a good impression!

3. Help out as described in our wiki: https://github.com/flutter/flutter/wiki/Triage
   You won't be able to add labels at first, so instead start by trying to
   do the other steps, e.g. trying to reproduce the problem and asking for people to
   provide enough details that you can reproduce the problem, pointing out duplicates,
   and so on. Chat on the #hackers-triage channel to let us know what you're up to!

4. Familiarize yourself with our
   [issue hygiene](https://github.com/flutter/flutter/wiki/Issue-hygiene) wiki page,
   which covers the meanings of some important GitHub labels and
   milestones.

5. Once you've been doing this for a while, someone will invite you to the flutter-hackers
   team on GitHub and you'll be able to add labels too. See the
   [contributor access](https://github.com/flutter/flutter/wiki/Contributor-access) wiki
   page for details.

Developing for Flutter
----------------------

If you would prefer to write code, you may wish to start with our list of [good first contributions](https://github.com/flutter/flutter/issues?q=is%3Aopen+is%3Aissue+label%3A%22good+first+contribution%22).

To develop for Flutter, you will eventually need to become familiar
with our processes and conventions. This section lists the documents
that describe these methodologies. The following list is ordered: you
are strongly recommended to go through these documents in the order
presented.

1. [Our code of conduct](CODE_OF_CONDUCT.md), which stipulates explicitly
   that everyone must be gracious, respectful, and professional. This
   also documents our conflict resolution policy and encourages people
   to ask questions.

2. [Values](https://github.com/flutter/flutter/wiki/Values),
   which talks about what we care most about.

3. [Setting up your engine development environment](https://github.com/flutter/flutter/wiki/Setting-up-the-Engine-development-environment),
   which describes the steps you need to configure your computer to
   work on Flutter's engine. If you only want to write code for the
   Flutter framework, you can skip this step. Flutter's engine mainly
   uses C++, Java, and Objective-C.

4. [Setting up your framework development environment](https://github.com/flutter/flutter/wiki/Setting-up-the-Framework-development-environment),
   which describes the steps you need to configure your computer to
   work on Flutter's framework. Flutter's framework mainly uses Dart.

5. [Tree hygiene](https://github.com/flutter/flutter/wiki/Tree-hygiene),
   which covers how to land a PR, how to do code review, how to
   handle breaking changes, how to handle regressions, and how to
   handle post-commit test failures.

6. [Issue hygiene](https://github.com/flutter/flutter/wiki/Issue-hygiene),
   which covers our processes around triaging bugs, escalating high
   priority bugs, assigning bugs, and our GitHub labels and
   milestones.

7. [Our style guide](https://github.com/flutter/flutter/wiki/Style-guide-for-Flutter-repo),
   which includes advice for designing APIs for Flutter, and how to
   format code in the framework.

8. [Flutter design doc template](https://flutter.dev/go/template),
   which should be used when proposing a new technical design.  This is a good
   practice to do before coding more intricate changes.

[![How to contribute to Flutter](https://img.youtube.com/vi/4yBgOBAOx_A/0.jpg)](https://www.youtube.com/watch?v=4yBgOBAOx_A)

In addition to the documents, there is a video linked above on **How to contribute to Flutter**
from the [Flutter](https://youtube.com/c/flutterdev) YouTube channel,
there are many pages on [our Wiki](https://github.com/flutter/flutter/wiki/),
and an article [Contributing to Flutter: Getting Started](https://medium.com/@ayushbherwani/contributing-to-flutter-getting-started-a0db68cbcd5b)
on Medium that may be of interest. For a curated list of pages see the sidebar
on the wiki's home page. They are more or less listed in order of importance.
