/*
 * Copyright (C) 2012 Michael Brown <mbrown@fensystems.co.uk>.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

FILE_LICENCE ( GPL2_OR_LATER );

/** @file
 *
 * Linux time source
 *
 */

#include <stdint.h>
#include <stddef.h>
#include <errno.h>
#include <linux_api.h>
#include <ipxe/time.h>

/**
 * Get current time in seconds
 *
 * @ret time		Time, in seconds
 */
static time_t linux_now ( void ) {
	struct timeval now;

	linux_gettimeofday ( &now, NULL );
	return now.tv_sec;
}

PROVIDE_TIME ( linux, time_now, linux_now );
