/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2015  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD_SET_ACCENT_PHRASE_RULE_H
#define NJD_SET_ACCENT_PHRASE_RULE_H

#ifdef __cplusplus
#define NJD_SET_ACCENT_PHRASE_RULE_H_START extern "C" {
#define NJD_SET_ACCENT_PHRASE_RULE_H_END   }
#else
#define NJD_SET_ACCENT_PHRASE_RULE_H_START
#define NJD_SET_ACCENT_PHRASE_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD_SET_ACCENT_PHRASE_RULE_H_START;

/*
  Rule 01 ftHg͂
  Rule 02 uv̘A͂
  Rule 03 u`ev̌Ɂuvʂ̃ANZg
  Rule 04 u,`eꊲv̌Ɂuvʂ̃ANZg
  Rule 05 uv̌Ɂu`evoruvʂ̃ANZg
  Rule 06 uvCuڑvCuA̎v͒PƂ̃ANZg
  Rule 07 u,\viׂāCȂǁj͒PƂ̃ANZg
  Rule 08 uvoruvitj͑Oɂ
  Rule 09 uvoruvitǰ́uvCuvȊOij͕ʂ̃ANZg
  Rule 10 u*,ڔv̌́uv͕ʂ̃ANZg
  Rule 11 u`e,񎩗v́u,Ap*voru`e,Ap*voru,ڑ,āvoru,ڑ,ŁvɐڑꍇɑOɂ
  Rule 12 u,񎩗v́u,Ap*voru,TϐڑvɐڑꍇɑOɂ
  Rule 13 uv̌Ɂuvoru`evoru,`eꊲvʂ̃ANZg
  Rule 14 uLv͒PƂ̃ANZg
  Rule 15 uړv͒PƂ̃ANZg
  Rule 16 u*,*,*,v̌́uv͕ʂ̃ANZg
  Rule 17 uv̌́u*,*,*,v͕ʂ̃ANZg
  Rule 18 u*,ڔv͑Oɂ
*/

#define NJD_SET_ACCENT_PHRASE_MEISHI ""
#define NJD_SET_ACCENT_PHRASE_KEIYOUSHI "`e"
#define NJD_SET_ACCENT_PHRASE_DOUSHI ""
#define NJD_SET_ACCENT_PHRASE_FUKUSHI ""
#define NJD_SET_ACCENT_PHRASE_SETSUZOKUSHI "ڑ"
#define NJD_SET_ACCENT_PHRASE_RENTAISHI "A̎"
#define NJD_SET_ACCENT_PHRASE_JODOUSHI ""
#define NJD_SET_ACCENT_PHRASE_JOSHI ""
#define NJD_SET_ACCENT_PHRASE_KIGOU "L"
#define NJD_SET_ACCENT_PHRASE_KEIYOUDOUSHI_GOKAN "`eꊲ"
#define NJD_SET_ACCENT_PHRASE_FUKUSHI_KANOU "\"
#define NJD_SET_ACCENT_PHRASE_SETSUBI "ڔ"
#define NJD_SET_ACCENT_PHRASE_HIJIRITSU "񎩗"
#define NJD_SET_ACCENT_PHRASE_RENYOU "Ap"
#define NJD_SET_ACCENT_PHRASE_SETSUZOKUJOSHI "ڑ"
#define NJD_SET_ACCENT_PHRASE_SAHEN_SETSUZOKU "Tϐڑ"
#define NJD_SET_ACCENT_PHRASE_TE ""
#define NJD_SET_ACCENT_PHRASE_DE ""
#define NJD_SET_ACCENT_PHRASE_SETTOUSHI "ړ"
#define NJD_SET_ACCENT_PHRASE_SEI ""
#define NJD_SET_ACCENT_PHRASE_MEI ""

NJD_SET_ACCENT_PHRASE_RULE_H_END;

#endif                          /* !NJD_SET_ACCENT_PHRASE_RULE_H */
