/*
 * cve-check-tool.h
 *
 * Copyright (C) 2015 Intel Corporation
 *
 * cve-check-tool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#pragma once

#include <stdbool.h>
#include <stdint.h>
#include <glib.h>

#include "common.h"

#include "core.h"

/**
 * Distro implementations need to add packages to the interest list
 * before we will check them for CVEs. This will actually call back to
 * the self->examine function, and add the parsed package into the
 * current list.
 *
 * @param path Full legal path to the source package
 */
 
typedef void (*cve_add_callback)(const char *);

/**
 * Instance tracking
 */
typedef struct CveCheckTool {
    int64_t modified;                   /**<Upper limit of CVE's to monitor, or -1 */
    bool hide_patched;                  /**<Whether to hide patches or not */
    bool show_unaffected;               /**<Whether to show unaffected items or not */
    GHashTable *db;                     /**<Mapping of packages */
    CveDB* cve_db;                      /**<Mapping of CVEs */
    GHashTable *bdb;                    /**<Mapping of bugs */
    bool bugs;                          /**<Whether bug tracking is enabled */
    GHashTable *mapping;                /**<CVE Mapping */
    const char *output_file;            /**<Output file, if any */
} CveCheckTool;

/**
 * Exploitable only via local/physical access
 */
#define ACCESS_VECTOR_LOCAL     "LOCAL"

/**
 * Locally exploitable via network (collision or local subnet)
 */
#define ACCESS_VECTOR_ADJACENT  "ADJACENT_NETWORK"

/**
 * Remotely exploitable
 */
#define ACCESS_VECTOR_NETWORK   "NETWORK"

/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=8 tabstop=8 expandtab:
 * :indentSize=8:tabSize=8:noTabs=true:
 */
