/*
 * rpm.c - Generic RPM support
 *
 * Copyright (C) 2015 Intel Corporation
 *
 * cve-check-tool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
#define _GNU_SOURCE
#include <glib.h>
#include <libxml/xmlreader.h>
#include <libgen.h>
#include <sys/stat.h>
#include <limits.h>
#include <stdlib.h>

#include "rpm.h"
#include "util.h"
#include "cve-check-tool.h"


static inline gchar *firstword(gchar *input)
{
    autofree(gstrv) *splits = NULL;

    splits = g_strsplit(input, " ", 2);
    return g_strdup(splits[0]);
}

/**
 * Determine if strings are equal, but ignore case sensitivity.
 */
static inline bool str_iequal(const gchar *inp, const gchar *cmp)
{
        autofree(gchar) *left = g_ascii_strdown(inp, -1);
        autofree(gchar) *right = g_ascii_strdown(cmp, -1);

        if (g_str_equal(left, right)) {
                return true;
        }
        return false;
}

/**
 * Utility method: Determine if string has the given prefix, case insensitive.
 */
static inline bool str_has_iprefix(const gchar *inp, const gchar *cmp)
{
        autofree(gchar) *left = g_ascii_strdown(inp, -1);
        autofree(gchar) *right = g_ascii_strdown(cmp, -1);

        if (g_str_has_prefix(left, right)) {
                return true;
        }
        return false;
}

/**
 * Utility method: Determine if string has the given suffix, case insensitive.
 */
static inline bool str_has_isuffix(const gchar *inp, const gchar *cmp)
{
        autofree(gchar) *left = g_ascii_strdown(inp, -1);
        autofree(gchar) *right = g_ascii_strdown(cmp, -1);

        if (g_str_has_suffix(left, right)) {
                return true;
        }
        return false;
}


/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=8 tabstop=8 expandtab:
 * :indentSize=8:tabSize=8:noTabs=true:
 */
