/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        const char *name;
        unsigned mask;
        unsigned num_values;
        const char **values;
};

struct si_reg {
        const char *name;
        unsigned offset;
        unsigned num_fields;
        const struct si_field *fields;
};

struct si_packet3 {
        const char *name;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{"NOP", PKT3_NOP},
	{"SET_BASE", PKT3_SET_BASE},
	{"CLEAR_STATE", PKT3_CLEAR_STATE},
	{"INDEX_BUFFER_SIZE", PKT3_INDEX_BUFFER_SIZE},
	{"DISPATCH_DIRECT", PKT3_DISPATCH_DIRECT},
	{"DISPATCH_INDIRECT", PKT3_DISPATCH_INDIRECT},
	{"OCCLUSION_QUERY", PKT3_OCCLUSION_QUERY},
	{"SET_PREDICATION", PKT3_SET_PREDICATION},
	{"COND_EXEC", PKT3_COND_EXEC},
	{"PRED_EXEC", PKT3_PRED_EXEC},
	{"DRAW_INDIRECT", PKT3_DRAW_INDIRECT},
	{"DRAW_INDEX_INDIRECT", PKT3_DRAW_INDEX_INDIRECT},
	{"INDEX_BASE", PKT3_INDEX_BASE},
	{"DRAW_INDEX_2", PKT3_DRAW_INDEX_2},
	{"CONTEXT_CONTROL", PKT3_CONTEXT_CONTROL},
	{"INDEX_TYPE", PKT3_INDEX_TYPE},
	{"DRAW_INDIRECT_MULTI", PKT3_DRAW_INDIRECT_MULTI},
	{"DRAW_INDEX_AUTO", PKT3_DRAW_INDEX_AUTO},
	{"DRAW_INDEX_IMMD", PKT3_DRAW_INDEX_IMMD},
	{"NUM_INSTANCES", PKT3_NUM_INSTANCES},
	{"DRAW_INDEX_MULTI_AUTO", PKT3_DRAW_INDEX_MULTI_AUTO},
	{"INDIRECT_BUFFER_SI", PKT3_INDIRECT_BUFFER_SI},
	{"STRMOUT_BUFFER_UPDATE", PKT3_STRMOUT_BUFFER_UPDATE},
	{"DRAW_INDEX_OFFSET_2", PKT3_DRAW_INDEX_OFFSET_2},
	{"DRAW_PREAMBLE", PKT3_DRAW_PREAMBLE},
	{"WRITE_DATA", PKT3_WRITE_DATA},
	{"DRAW_INDEX_INDIRECT_MULTI", PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{"MEM_SEMAPHORE", PKT3_MEM_SEMAPHORE},
	{"MPEG_INDEX", PKT3_MPEG_INDEX},
	{"WAIT_REG_MEM", PKT3_WAIT_REG_MEM},
	{"MEM_WRITE", PKT3_MEM_WRITE},
	{"INDIRECT_BUFFER_CIK", PKT3_INDIRECT_BUFFER_CIK},
	{"COPY_DATA", PKT3_COPY_DATA},
	{"SURFACE_SYNC", PKT3_SURFACE_SYNC},
	{"ME_INITIALIZE", PKT3_ME_INITIALIZE},
	{"COND_WRITE", PKT3_COND_WRITE},
	{"EVENT_WRITE", PKT3_EVENT_WRITE},
	{"EVENT_WRITE_EOP", PKT3_EVENT_WRITE_EOP},
	{"EVENT_WRITE_EOS", PKT3_EVENT_WRITE_EOS},
	{"ONE_REG_WRITE", PKT3_ONE_REG_WRITE},
	{"ACQUIRE_MEM", PKT3_ACQUIRE_MEM},
	{"SET_CONFIG_REG", PKT3_SET_CONFIG_REG},
	{"SET_CONTEXT_REG", PKT3_SET_CONTEXT_REG},
	{"SET_SH_REG", PKT3_SET_SH_REG},
	{"SET_SH_REG_OFFSET", PKT3_SET_SH_REG_OFFSET},
	{"SET_UCONFIG_REG", PKT3_SET_UCONFIG_REG},
	{"IT_OPCODE_C", PKT3_IT_OPCODE_C},
	{"CP_DMA", PKT3_CP_DMA},
	{"DMA_DATA", PKT3_DMA_DATA},
};

static const char *r_370_control__engine_sel__values[] = {
	[V_370_ME] = "ME",
	[V_370_PFP] = "PFP",
	[V_370_CE] = "CE",
	[V_370_DE] = "DE",
};

static const char *r_370_control__dst_sel__values[] = {
	[V_370_MEM_MAPPED_REGISTER] = "MEM_MAPPED_REGISTER",
	[V_370_MEMORY_SYNC] = "MEMORY_SYNC",
	[V_370_TC_L2] = "TC_L2",
	[V_370_GDS] = "GDS",
	[V_370_RESERVED] = "RESERVED",
	[V_370_MEM_ASYNC] = "MEM_ASYNC",
};

static const struct si_field r_370_control__fields[] = {
	{"ENGINE_SEL", S_370_ENGINE_SEL(~0u), ARRAY_SIZE(r_370_control__engine_sel__values), r_370_control__engine_sel__values},
	{"WR_CONFIRM", S_370_WR_CONFIRM(~0u)},
	{"WR_ONE_ADDR", S_370_WR_ONE_ADDR(~0u)},
	{"DST_SEL", S_370_DST_SEL(~0u), ARRAY_SIZE(r_370_control__dst_sel__values), r_370_control__dst_sel__values},
};

static const struct si_field r_410_cp_dma_word0__fields[] = {
	{"SRC_ADDR_LO", S_410_SRC_ADDR_LO(~0u)},
};

static const char *r_411_cp_dma_word1__src_sel__values[] = {
	[V_411_SRC_ADDR] = "SRC_ADDR",
	[V_411_GDS] = "GDS",
	[V_411_DATA] = "DATA",
	[V_411_SRC_ADDR_TC_L2] = "SRC_ADDR_TC_L2",
};

static const char *r_411_cp_dma_word1__engine__values[] = {
	[V_411_ME] = "ME",
	[V_411_PFP] = "PFP",
};

static const char *r_411_cp_dma_word1__dsl_sel__values[] = {
	[V_411_DST_ADDR] = "DST_ADDR",
	[V_411_GDS] = "GDS",
	[V_411_DST_ADDR_TC_L2] = "DST_ADDR_TC_L2",
};

static const struct si_field r_411_cp_dma_word1__fields[] = {
	{"CP_SYNC", S_411_CP_SYNC(~0u)},
	{"SRC_SEL", S_411_SRC_SEL(~0u), ARRAY_SIZE(r_411_cp_dma_word1__src_sel__values), r_411_cp_dma_word1__src_sel__values},
	{"ENGINE", S_411_ENGINE(~0u), ARRAY_SIZE(r_411_cp_dma_word1__engine__values), r_411_cp_dma_word1__engine__values},
	{"DSL_SEL", S_411_DSL_SEL(~0u), ARRAY_SIZE(r_411_cp_dma_word1__dsl_sel__values), r_411_cp_dma_word1__dsl_sel__values},
	{"SRC_ADDR_HI", S_411_SRC_ADDR_HI(~0u)},
};

static const struct si_field r_412_cp_dma_word2__fields[] = {
	{"DST_ADDR_LO", S_412_DST_ADDR_LO(~0u)},
};

static const struct si_field r_413_cp_dma_word3__fields[] = {
	{"DST_ADDR_HI", S_413_DST_ADDR_HI(~0u)},
};

static const char *r_414_command__src_swap__values[] = {
	[V_414_NONE] = "NONE",
	[V_414_8_IN_16] = "8_IN_16",
	[V_414_8_IN_32] = "8_IN_32",
	[V_414_8_IN_64] = "8_IN_64",
};

static const char *r_414_command__dst_swap__values[] = {
	[V_414_NONE] = "NONE",
	[V_414_8_IN_16] = "8_IN_16",
	[V_414_8_IN_32] = "8_IN_32",
	[V_414_8_IN_64] = "8_IN_64",
};

static const char *r_414_command__sas__values[] = {
	[V_414_MEMORY] = "MEMORY",
	[V_414_REGISTER] = "REGISTER",
};

static const char *r_414_command__das__values[] = {
	[V_414_MEMORY] = "MEMORY",
	[V_414_REGISTER] = "REGISTER",
};

static const char *r_414_command__saic__values[] = {
	[V_414_INCREMENT] = "INCREMENT",
	[V_414_NO_INCREMENT] = "NO_INCREMENT",
};

static const char *r_414_command__daic__values[] = {
	[V_414_INCREMENT] = "INCREMENT",
	[V_414_NO_INCREMENT] = "NO_INCREMENT",
};

static const struct si_field r_414_command__fields[] = {
	{"BYTE_COUNT", S_414_BYTE_COUNT(~0u)},
	{"DISABLE_WR_CONFIRM", S_414_DISABLE_WR_CONFIRM(~0u)},
	{"SRC_SWAP", S_414_SRC_SWAP(~0u), ARRAY_SIZE(r_414_command__src_swap__values), r_414_command__src_swap__values},
	{"DST_SWAP", S_414_DST_SWAP(~0u), ARRAY_SIZE(r_414_command__dst_swap__values), r_414_command__dst_swap__values},
	{"SAS", S_414_SAS(~0u), ARRAY_SIZE(r_414_command__sas__values), r_414_command__sas__values},
	{"DAS", S_414_DAS(~0u), ARRAY_SIZE(r_414_command__das__values), r_414_command__das__values},
	{"SAIC", S_414_SAIC(~0u), ARRAY_SIZE(r_414_command__saic__values), r_414_command__saic__values},
	{"DAIC", S_414_DAIC(~0u), ARRAY_SIZE(r_414_command__daic__values), r_414_command__daic__values},
	{"RAW_WAIT", S_414_RAW_WAIT(~0u)},
};

static const char *r_500_dma_data_word0__src_sel__values[] = {
	[V_500_SRC_ADDR] = "SRC_ADDR",
	[V_500_GDS] = "GDS",
	[V_500_DATA] = "DATA",
	[V_500_SRC_ADDR_TC_L2] = "SRC_ADDR_TC_L2",
};

static const char *r_500_dma_data_word0__dsl_sel__values[] = {
	[V_500_DST_ADDR] = "DST_ADDR",
	[V_500_GDS] = "GDS",
	[V_500_DST_ADDR_TC_L2] = "DST_ADDR_TC_L2",
};

static const char *r_500_dma_data_word0__engine__values[] = {
	[V_500_ME] = "ME",
	[V_500_PFP] = "PFP",
};

static const struct si_field r_500_dma_data_word0__fields[] = {
	{"CP_SYNC", S_500_CP_SYNC(~0u)},
	{"SRC_SEL", S_500_SRC_SEL(~0u), ARRAY_SIZE(r_500_dma_data_word0__src_sel__values), r_500_dma_data_word0__src_sel__values},
	{"DSL_SEL", S_500_DSL_SEL(~0u), ARRAY_SIZE(r_500_dma_data_word0__dsl_sel__values), r_500_dma_data_word0__dsl_sel__values},
	{"ENGINE", S_500_ENGINE(~0u), ARRAY_SIZE(r_500_dma_data_word0__engine__values), r_500_dma_data_word0__engine__values},
};

static const struct si_field r_000e4c_srbm_status2__fields[] = {
	{"SDMA_RQ_PENDING", S_000E4C_SDMA_RQ_PENDING(~0u)},
	{"TST_RQ_PENDING", S_000E4C_TST_RQ_PENDING(~0u)},
	{"SDMA1_RQ_PENDING", S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{"VCE0_RQ_PENDING", S_000E4C_VCE0_RQ_PENDING(~0u)},
	{"VP8_BUSY", S_000E4C_VP8_BUSY(~0u)},
	{"SDMA_BUSY", S_000E4C_SDMA_BUSY(~0u)},
	{"SDMA1_BUSY", S_000E4C_SDMA1_BUSY(~0u)},
	{"VCE0_BUSY", S_000E4C_VCE0_BUSY(~0u)},
	{"XDMA_BUSY", S_000E4C_XDMA_BUSY(~0u)},
	{"CHUB_BUSY", S_000E4C_CHUB_BUSY(~0u)},
	{"SDMA2_BUSY", S_000E4C_SDMA2_BUSY(~0u)},
	{"SDMA3_BUSY", S_000E4C_SDMA3_BUSY(~0u)},
	{"SAMSCP_BUSY", S_000E4C_SAMSCP_BUSY(~0u)},
	{"ISP_BUSY", S_000E4C_ISP_BUSY(~0u)},
	{"VCE1_BUSY", S_000E4C_VCE1_BUSY(~0u)},
	{"ODE_BUSY", S_000E4C_ODE_BUSY(~0u)},
	{"SDMA2_RQ_PENDING", S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{"SDMA3_RQ_PENDING", S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{"SAMSCP_RQ_PENDING", S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{"ISP_RQ_PENDING", S_000E4C_ISP_RQ_PENDING(~0u)},
	{"VCE1_RQ_PENDING", S_000E4C_VCE1_RQ_PENDING(~0u)},
};

static const struct si_field r_000e50_srbm_status__fields[] = {
	{"UVD_RQ_PENDING", S_000E50_UVD_RQ_PENDING(~0u)},
	{"SAMMSP_RQ_PENDING", S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{"ACP_RQ_PENDING", S_000E50_ACP_RQ_PENDING(~0u)},
	{"SMU_RQ_PENDING", S_000E50_SMU_RQ_PENDING(~0u)},
	{"GRBM_RQ_PENDING", S_000E50_GRBM_RQ_PENDING(~0u)},
	{"HI_RQ_PENDING", S_000E50_HI_RQ_PENDING(~0u)},
	{"VMC_BUSY", S_000E50_VMC_BUSY(~0u)},
	{"MCB_BUSY", S_000E50_MCB_BUSY(~0u)},
	{"MCB_NON_DISPLAY_BUSY", S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{"MCC_BUSY", S_000E50_MCC_BUSY(~0u)},
	{"MCD_BUSY", S_000E50_MCD_BUSY(~0u)},
	{"VMC1_BUSY", S_000E50_VMC1_BUSY(~0u)},
	{"SEM_BUSY", S_000E50_SEM_BUSY(~0u)},
	{"ACP_BUSY", S_000E50_ACP_BUSY(~0u)},
	{"IH_BUSY", S_000E50_IH_BUSY(~0u)},
	{"UVD_BUSY", S_000E50_UVD_BUSY(~0u)},
	{"SAMMSP_BUSY", S_000E50_SAMMSP_BUSY(~0u)},
	{"GCATCL2_BUSY", S_000E50_GCATCL2_BUSY(~0u)},
	{"OSATCL2_BUSY", S_000E50_OSATCL2_BUSY(~0u)},
	{"BIF_BUSY", S_000E50_BIF_BUSY(~0u)},
};

static const struct si_field r_000e54_srbm_status3__fields[] = {
	{"MCC0_BUSY", S_000E54_MCC0_BUSY(~0u)},
	{"MCC1_BUSY", S_000E54_MCC1_BUSY(~0u)},
	{"MCC2_BUSY", S_000E54_MCC2_BUSY(~0u)},
	{"MCC3_BUSY", S_000E54_MCC3_BUSY(~0u)},
	{"MCC4_BUSY", S_000E54_MCC4_BUSY(~0u)},
	{"MCC5_BUSY", S_000E54_MCC5_BUSY(~0u)},
	{"MCC6_BUSY", S_000E54_MCC6_BUSY(~0u)},
	{"MCC7_BUSY", S_000E54_MCC7_BUSY(~0u)},
	{"MCD0_BUSY", S_000E54_MCD0_BUSY(~0u)},
	{"MCD1_BUSY", S_000E54_MCD1_BUSY(~0u)},
	{"MCD2_BUSY", S_000E54_MCD2_BUSY(~0u)},
	{"MCD3_BUSY", S_000E54_MCD3_BUSY(~0u)},
	{"MCD4_BUSY", S_000E54_MCD4_BUSY(~0u)},
	{"MCD5_BUSY", S_000E54_MCD5_BUSY(~0u)},
	{"MCD6_BUSY", S_000E54_MCD6_BUSY(~0u)},
	{"MCD7_BUSY", S_000E54_MCD7_BUSY(~0u)},
};

static const struct si_field r_00d034_sdma0_status_reg__fields[] = {
	{"IDLE", S_00D034_IDLE(~0u)},
	{"REG_IDLE", S_00D034_REG_IDLE(~0u)},
	{"RB_EMPTY", S_00D034_RB_EMPTY(~0u)},
	{"RB_FULL", S_00D034_RB_FULL(~0u)},
	{"RB_CMD_IDLE", S_00D034_RB_CMD_IDLE(~0u)},
	{"RB_CMD_FULL", S_00D034_RB_CMD_FULL(~0u)},
	{"IB_CMD_IDLE", S_00D034_IB_CMD_IDLE(~0u)},
	{"IB_CMD_FULL", S_00D034_IB_CMD_FULL(~0u)},
	{"BLOCK_IDLE", S_00D034_BLOCK_IDLE(~0u)},
	{"INSIDE_IB", S_00D034_INSIDE_IB(~0u)},
	{"EX_IDLE", S_00D034_EX_IDLE(~0u)},
	{"EX_IDLE_POLL_TIMER_EXPIRE", S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{"PACKET_READY", S_00D034_PACKET_READY(~0u)},
	{"MC_WR_IDLE", S_00D034_MC_WR_IDLE(~0u)},
	{"SRBM_IDLE", S_00D034_SRBM_IDLE(~0u)},
	{"CONTEXT_EMPTY", S_00D034_CONTEXT_EMPTY(~0u)},
	{"DELTA_RPTR_FULL", S_00D034_DELTA_RPTR_FULL(~0u)},
	{"RB_MC_RREQ_IDLE", S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{"IB_MC_RREQ_IDLE", S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{"MC_RD_IDLE", S_00D034_MC_RD_IDLE(~0u)},
	{"DELTA_RPTR_EMPTY", S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{"MC_RD_RET_STALL", S_00D034_MC_RD_RET_STALL(~0u)},
	{"MC_RD_NO_POLL_IDLE", S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{"PREV_CMD_IDLE", S_00D034_PREV_CMD_IDLE(~0u)},
	{"SEM_IDLE", S_00D034_SEM_IDLE(~0u)},
	{"SEM_REQ_STALL", S_00D034_SEM_REQ_STALL(~0u)},
	{"SEM_RESP_STATE", S_00D034_SEM_RESP_STATE(~0u)},
	{"INT_IDLE", S_00D034_INT_IDLE(~0u)},
	{"INT_REQ_STALL", S_00D034_INT_REQ_STALL(~0u)},
};

static const struct si_field r_008008_grbm_status2__fields[] = {
	{"ME0PIPE1_CMDFIFO_AVAIL", S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{"ME0PIPE1_CF_RQ_PENDING", S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{"ME0PIPE1_PF_RQ_PENDING", S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{"ME1PIPE0_RQ_PENDING", S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{"ME1PIPE1_RQ_PENDING", S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{"ME1PIPE2_RQ_PENDING", S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{"ME1PIPE3_RQ_PENDING", S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{"ME2PIPE0_RQ_PENDING", S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{"ME2PIPE1_RQ_PENDING", S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{"ME2PIPE2_RQ_PENDING", S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{"ME2PIPE3_RQ_PENDING", S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{"RLC_RQ_PENDING", S_008008_RLC_RQ_PENDING(~0u)},
	{"RLC_BUSY", S_008008_RLC_BUSY(~0u)},
	{"TC_BUSY", S_008008_TC_BUSY(~0u)},
	{"TCC_CC_RESIDENT", S_008008_TCC_CC_RESIDENT(~0u)},
	{"CPF_BUSY", S_008008_CPF_BUSY(~0u)},
	{"CPC_BUSY", S_008008_CPC_BUSY(~0u)},
	{"CPG_BUSY", S_008008_CPG_BUSY(~0u)},
};

static const struct si_field r_008010_grbm_status__fields[] = {
	{"ME0PIPE0_CMDFIFO_AVAIL", S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{"SRBM_RQ_PENDING", S_008010_SRBM_RQ_PENDING(~0u)},
	{"ME0PIPE0_CF_RQ_PENDING", S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{"ME0PIPE0_PF_RQ_PENDING", S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{"GDS_DMA_RQ_PENDING", S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{"DB_CLEAN", S_008010_DB_CLEAN(~0u)},
	{"CB_CLEAN", S_008010_CB_CLEAN(~0u)},
	{"TA_BUSY", S_008010_TA_BUSY(~0u)},
	{"GDS_BUSY", S_008010_GDS_BUSY(~0u)},
	{"WD_BUSY_NO_DMA", S_008010_WD_BUSY_NO_DMA(~0u)},
	{"VGT_BUSY", S_008010_VGT_BUSY(~0u)},
	{"IA_BUSY_NO_DMA", S_008010_IA_BUSY_NO_DMA(~0u)},
	{"IA_BUSY", S_008010_IA_BUSY(~0u)},
	{"SX_BUSY", S_008010_SX_BUSY(~0u)},
	{"WD_BUSY", S_008010_WD_BUSY(~0u)},
	{"SPI_BUSY", S_008010_SPI_BUSY(~0u)},
	{"BCI_BUSY", S_008010_BCI_BUSY(~0u)},
	{"SC_BUSY", S_008010_SC_BUSY(~0u)},
	{"PA_BUSY", S_008010_PA_BUSY(~0u)},
	{"DB_BUSY", S_008010_DB_BUSY(~0u)},
	{"CP_COHERENCY_BUSY", S_008010_CP_COHERENCY_BUSY(~0u)},
	{"CP_BUSY", S_008010_CP_BUSY(~0u)},
	{"CB_BUSY", S_008010_CB_BUSY(~0u)},
	{"GUI_ACTIVE", S_008010_GUI_ACTIVE(~0u)},
};

static const struct si_field r_0084fc_cp_strmout_cntl__fields[] = {
	{"OFFSET_UPDATE_DONE", S_0084FC_OFFSET_UPDATE_DONE(~0u)},
};

static const struct si_field r_0085f0_cp_coher_cntl__fields[] = {
	{"DEST_BASE_0_ENA", S_0085F0_DEST_BASE_0_ENA(~0u)},
	{"DEST_BASE_1_ENA", S_0085F0_DEST_BASE_1_ENA(~0u)},
	{"CB0_DEST_BASE_ENA", S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{"CB1_DEST_BASE_ENA", S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{"CB2_DEST_BASE_ENA", S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{"CB3_DEST_BASE_ENA", S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{"CB4_DEST_BASE_ENA", S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{"CB5_DEST_BASE_ENA", S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{"CB6_DEST_BASE_ENA", S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{"CB7_DEST_BASE_ENA", S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{"DB_DEST_BASE_ENA", S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{"DEST_BASE_2_ENA", S_0085F0_DEST_BASE_2_ENA(~0u)},
	{"DEST_BASE_3_ENA", S_0085F0_DEST_BASE_3_ENA(~0u)},
	{"TCL1_ACTION_ENA", S_0085F0_TCL1_ACTION_ENA(~0u)},
	{"TC_ACTION_ENA", S_0085F0_TC_ACTION_ENA(~0u)},
	{"CB_ACTION_ENA", S_0085F0_CB_ACTION_ENA(~0u)},
	{"DB_ACTION_ENA", S_0085F0_DB_ACTION_ENA(~0u)},
	{"SH_KCACHE_ACTION_ENA", S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{"SH_ICACHE_ACTION_ENA", S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
};

static const struct si_field r_008014_grbm_status_se0__fields[] = {
	{"DB_CLEAN", S_008014_DB_CLEAN(~0u)},
	{"CB_CLEAN", S_008014_CB_CLEAN(~0u)},
	{"BCI_BUSY", S_008014_BCI_BUSY(~0u)},
	{"VGT_BUSY", S_008014_VGT_BUSY(~0u)},
	{"PA_BUSY", S_008014_PA_BUSY(~0u)},
	{"TA_BUSY", S_008014_TA_BUSY(~0u)},
	{"SX_BUSY", S_008014_SX_BUSY(~0u)},
	{"SPI_BUSY", S_008014_SPI_BUSY(~0u)},
	{"SC_BUSY", S_008014_SC_BUSY(~0u)},
	{"DB_BUSY", S_008014_DB_BUSY(~0u)},
	{"CB_BUSY", S_008014_CB_BUSY(~0u)},
};

static const struct si_field r_008018_grbm_status_se1__fields[] = {
	{"DB_CLEAN", S_008018_DB_CLEAN(~0u)},
	{"CB_CLEAN", S_008018_CB_CLEAN(~0u)},
	{"BCI_BUSY", S_008018_BCI_BUSY(~0u)},
	{"VGT_BUSY", S_008018_VGT_BUSY(~0u)},
	{"PA_BUSY", S_008018_PA_BUSY(~0u)},
	{"TA_BUSY", S_008018_TA_BUSY(~0u)},
	{"SX_BUSY", S_008018_SX_BUSY(~0u)},
	{"SPI_BUSY", S_008018_SPI_BUSY(~0u)},
	{"SC_BUSY", S_008018_SC_BUSY(~0u)},
	{"DB_BUSY", S_008018_DB_BUSY(~0u)},
	{"CB_BUSY", S_008018_CB_BUSY(~0u)},
};

static const struct si_field r_008038_grbm_status_se2__fields[] = {
	{"DB_CLEAN", S_008038_DB_CLEAN(~0u)},
	{"CB_CLEAN", S_008038_CB_CLEAN(~0u)},
	{"BCI_BUSY", S_008038_BCI_BUSY(~0u)},
	{"VGT_BUSY", S_008038_VGT_BUSY(~0u)},
	{"PA_BUSY", S_008038_PA_BUSY(~0u)},
	{"TA_BUSY", S_008038_TA_BUSY(~0u)},
	{"SX_BUSY", S_008038_SX_BUSY(~0u)},
	{"SPI_BUSY", S_008038_SPI_BUSY(~0u)},
	{"SC_BUSY", S_008038_SC_BUSY(~0u)},
	{"DB_BUSY", S_008038_DB_BUSY(~0u)},
	{"CB_BUSY", S_008038_CB_BUSY(~0u)},
};

static const struct si_field r_00803c_grbm_status_se3__fields[] = {
	{"DB_CLEAN", S_00803C_DB_CLEAN(~0u)},
	{"CB_CLEAN", S_00803C_CB_CLEAN(~0u)},
	{"BCI_BUSY", S_00803C_BCI_BUSY(~0u)},
	{"VGT_BUSY", S_00803C_VGT_BUSY(~0u)},
	{"PA_BUSY", S_00803C_PA_BUSY(~0u)},
	{"TA_BUSY", S_00803C_TA_BUSY(~0u)},
	{"SX_BUSY", S_00803C_SX_BUSY(~0u)},
	{"SPI_BUSY", S_00803C_SPI_BUSY(~0u)},
	{"SC_BUSY", S_00803C_SC_BUSY(~0u)},
	{"DB_BUSY", S_00803C_DB_BUSY(~0u)},
	{"CB_BUSY", S_00803C_CB_BUSY(~0u)},
};

static const struct si_field r_0300fc_cp_strmout_cntl__fields[] = {
	{"OFFSET_UPDATE_DONE", S_0300FC_OFFSET_UPDATE_DONE(~0u)},
};

static const struct si_field r_0301e4_cp_coher_base_hi__fields[] = {
	{"COHER_BASE_HI_256B", S_0301E4_COHER_BASE_HI_256B(~0u)},
};

static const struct si_field r_0301ec_cp_coher_start_delay__fields[] = {
	{"START_DELAY_COUNT", S_0301EC_START_DELAY_COUNT(~0u)},
};

static const struct si_field r_0301f0_cp_coher_cntl__fields[] = {
	{"DEST_BASE_0_ENA", S_0301F0_DEST_BASE_0_ENA(~0u)},
	{"DEST_BASE_1_ENA", S_0301F0_DEST_BASE_1_ENA(~0u)},
	{"TC_SD_ACTION_ENA", S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{"TC_NC_ACTION_ENA", S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{"CB0_DEST_BASE_ENA", S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{"CB1_DEST_BASE_ENA", S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{"CB2_DEST_BASE_ENA", S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{"CB3_DEST_BASE_ENA", S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{"CB4_DEST_BASE_ENA", S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{"CB5_DEST_BASE_ENA", S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{"CB6_DEST_BASE_ENA", S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{"CB7_DEST_BASE_ENA", S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{"DB_DEST_BASE_ENA", S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{"TCL1_VOL_ACTION_ENA", S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{"TC_VOL_ACTION_ENA", S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{"TC_WB_ACTION_ENA", S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{"DEST_BASE_2_ENA", S_0301F0_DEST_BASE_2_ENA(~0u)},
	{"DEST_BASE_3_ENA", S_0301F0_DEST_BASE_3_ENA(~0u)},
	{"TCL1_ACTION_ENA", S_0301F0_TCL1_ACTION_ENA(~0u)},
	{"TC_ACTION_ENA", S_0301F0_TC_ACTION_ENA(~0u)},
	{"CB_ACTION_ENA", S_0301F0_CB_ACTION_ENA(~0u)},
	{"DB_ACTION_ENA", S_0301F0_DB_ACTION_ENA(~0u)},
	{"SH_KCACHE_ACTION_ENA", S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{"SH_KCACHE_VOL_ACTION_ENA", S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{"SH_ICACHE_ACTION_ENA", S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{"SH_KCACHE_WB_ACTION_ENA", S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{"SH_SD_ACTION_ENA", S_0301F0_SH_SD_ACTION_ENA(~0u)},
};

static const struct si_field r_0301fc_cp_coher_status__fields[] = {
	{"MATCHING_GFX_CNTX", S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{"MEID", S_0301FC_MEID(~0u)},
	{"PHASE1_STATUS", S_0301FC_PHASE1_STATUS(~0u)},
	{"STATUS", S_0301FC_STATUS(~0u)},
};

static const struct si_field r_008210_cp_cpc_status__fields[] = {
	{"MEC1_BUSY", S_008210_MEC1_BUSY(~0u)},
	{"MEC2_BUSY", S_008210_MEC2_BUSY(~0u)},
	{"DC0_BUSY", S_008210_DC0_BUSY(~0u)},
	{"DC1_BUSY", S_008210_DC1_BUSY(~0u)},
	{"RCIU1_BUSY", S_008210_RCIU1_BUSY(~0u)},
	{"RCIU2_BUSY", S_008210_RCIU2_BUSY(~0u)},
	{"ROQ1_BUSY", S_008210_ROQ1_BUSY(~0u)},
	{"ROQ2_BUSY", S_008210_ROQ2_BUSY(~0u)},
	{"TCIU_BUSY", S_008210_TCIU_BUSY(~0u)},
	{"SCRATCH_RAM_BUSY", S_008210_SCRATCH_RAM_BUSY(~0u)},
	{"QU_BUSY", S_008210_QU_BUSY(~0u)},
	{"ATCL2IU_BUSY", S_008210_ATCL2IU_BUSY(~0u)},
	{"CPG_CPC_BUSY", S_008210_CPG_CPC_BUSY(~0u)},
	{"CPF_CPC_BUSY", S_008210_CPF_CPC_BUSY(~0u)},
	{"CPC_BUSY", S_008210_CPC_BUSY(~0u)},
};

static const struct si_field r_008214_cp_cpc_busy_stat__fields[] = {
	{"MEC1_LOAD_BUSY", S_008214_MEC1_LOAD_BUSY(~0u)},
	{"MEC1_SEMAPOHRE_BUSY", S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{"MEC1_MUTEX_BUSY", S_008214_MEC1_MUTEX_BUSY(~0u)},
	{"MEC1_MESSAGE_BUSY", S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{"MEC1_EOP_QUEUE_BUSY", S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{"MEC1_IQ_QUEUE_BUSY", S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{"MEC1_IB_QUEUE_BUSY", S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{"MEC1_TC_BUSY", S_008214_MEC1_TC_BUSY(~0u)},
	{"MEC1_DMA_BUSY", S_008214_MEC1_DMA_BUSY(~0u)},
	{"MEC1_PARTIAL_FLUSH_BUSY", S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{"MEC1_PIPE0_BUSY", S_008214_MEC1_PIPE0_BUSY(~0u)},
	{"MEC1_PIPE1_BUSY", S_008214_MEC1_PIPE1_BUSY(~0u)},
	{"MEC1_PIPE2_BUSY", S_008214_MEC1_PIPE2_BUSY(~0u)},
	{"MEC1_PIPE3_BUSY", S_008214_MEC1_PIPE3_BUSY(~0u)},
	{"MEC2_LOAD_BUSY", S_008214_MEC2_LOAD_BUSY(~0u)},
	{"MEC2_SEMAPOHRE_BUSY", S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{"MEC2_MUTEX_BUSY", S_008214_MEC2_MUTEX_BUSY(~0u)},
	{"MEC2_MESSAGE_BUSY", S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{"MEC2_EOP_QUEUE_BUSY", S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{"MEC2_IQ_QUEUE_BUSY", S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{"MEC2_IB_QUEUE_BUSY", S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{"MEC2_TC_BUSY", S_008214_MEC2_TC_BUSY(~0u)},
	{"MEC2_DMA_BUSY", S_008214_MEC2_DMA_BUSY(~0u)},
	{"MEC2_PARTIAL_FLUSH_BUSY", S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{"MEC2_PIPE0_BUSY", S_008214_MEC2_PIPE0_BUSY(~0u)},
	{"MEC2_PIPE1_BUSY", S_008214_MEC2_PIPE1_BUSY(~0u)},
	{"MEC2_PIPE2_BUSY", S_008214_MEC2_PIPE2_BUSY(~0u)},
	{"MEC2_PIPE3_BUSY", S_008214_MEC2_PIPE3_BUSY(~0u)},
};

static const struct si_field r_008218_cp_cpc_stalled_stat1__fields[] = {
	{"RCIU_TX_FREE_STALL", S_008218_RCIU_TX_FREE_STALL(~0u)},
	{"RCIU_PRIV_VIOLATION", S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{"TCIU_TX_FREE_STALL", S_008218_TCIU_TX_FREE_STALL(~0u)},
	{"MEC1_DECODING_PACKET", S_008218_MEC1_DECODING_PACKET(~0u)},
	{"MEC1_WAIT_ON_RCIU", S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{"MEC1_WAIT_ON_RCIU_READ", S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{"MEC1_WAIT_ON_ROQ_DATA", S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{"MEC2_DECODING_PACKET", S_008218_MEC2_DECODING_PACKET(~0u)},
	{"MEC2_WAIT_ON_RCIU", S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{"MEC2_WAIT_ON_RCIU_READ", S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{"MEC2_WAIT_ON_ROQ_DATA", S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{"ATCL2IU_WAITING_ON_FREE", S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{"ATCL2IU_WAITING_ON_TAGS", S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{"ATCL1_WAITING_ON_TRANS", S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
};

static const struct si_field r_00821c_cp_cpf_status__fields[] = {
	{"POST_WPTR_GFX_BUSY", S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{"CSF_BUSY", S_00821C_CSF_BUSY(~0u)},
	{"ROQ_ALIGN_BUSY", S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{"ROQ_RING_BUSY", S_00821C_ROQ_RING_BUSY(~0u)},
	{"ROQ_INDIRECT1_BUSY", S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{"ROQ_INDIRECT2_BUSY", S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{"ROQ_STATE_BUSY", S_00821C_ROQ_STATE_BUSY(~0u)},
	{"ROQ_CE_RING_BUSY", S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{"ROQ_CE_INDIRECT1_BUSY", S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{"ROQ_CE_INDIRECT2_BUSY", S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{"SEMAPHORE_BUSY", S_00821C_SEMAPHORE_BUSY(~0u)},
	{"INTERRUPT_BUSY", S_00821C_INTERRUPT_BUSY(~0u)},
	{"TCIU_BUSY", S_00821C_TCIU_BUSY(~0u)},
	{"HQD_BUSY", S_00821C_HQD_BUSY(~0u)},
	{"PRT_BUSY", S_00821C_PRT_BUSY(~0u)},
	{"ATCL2IU_BUSY", S_00821C_ATCL2IU_BUSY(~0u)},
	{"CPF_GFX_BUSY", S_00821C_CPF_GFX_BUSY(~0u)},
	{"CPF_CMP_BUSY", S_00821C_CPF_CMP_BUSY(~0u)},
	{"GRBM_CPF_STAT_BUSY", S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{"CPC_CPF_BUSY", S_00821C_CPC_CPF_BUSY(~0u)},
	{"CPF_BUSY", S_00821C_CPF_BUSY(~0u)},
};

static const struct si_field r_008220_cp_cpf_busy_stat__fields[] = {
	{"REG_BUS_FIFO_BUSY", S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{"CSF_RING_BUSY", S_008220_CSF_RING_BUSY(~0u)},
	{"CSF_INDIRECT1_BUSY", S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{"CSF_INDIRECT2_BUSY", S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{"CSF_STATE_BUSY", S_008220_CSF_STATE_BUSY(~0u)},
	{"CSF_CE_INDR1_BUSY", S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{"CSF_CE_INDR2_BUSY", S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{"CSF_ARBITER_BUSY", S_008220_CSF_ARBITER_BUSY(~0u)},
	{"CSF_INPUT_BUSY", S_008220_CSF_INPUT_BUSY(~0u)},
	{"OUTSTANDING_READ_TAGS", S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{"HPD_PROCESSING_EOP_BUSY", S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{"HQD_DISPATCH_BUSY", S_008220_HQD_DISPATCH_BUSY(~0u)},
	{"HQD_IQ_TIMER_BUSY", S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{"HQD_DMA_OFFLOAD_BUSY", S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{"HQD_WAIT_SEMAPHORE_BUSY", S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{"HQD_SIGNAL_SEMAPHORE_BUSY", S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{"HQD_MESSAGE_BUSY", S_008220_HQD_MESSAGE_BUSY(~0u)},
	{"HQD_PQ_FETCHER_BUSY", S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{"HQD_IB_FETCHER_BUSY", S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{"HQD_IQ_FETCHER_BUSY", S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{"HQD_EOP_FETCHER_BUSY", S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{"HQD_CONSUMED_RPTR_BUSY", S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{"HQD_FETCHER_ARB_BUSY", S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{"HQD_ROQ_ALIGN_BUSY", S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{"HQD_ROQ_EOP_BUSY", S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{"HQD_ROQ_IQ_BUSY", S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{"HQD_ROQ_PQ_BUSY", S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{"HQD_ROQ_IB_BUSY", S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{"HQD_WPTR_POLL_BUSY", S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{"HQD_PQ_BUSY", S_008220_HQD_PQ_BUSY(~0u)},
	{"HQD_IB_BUSY", S_008220_HQD_IB_BUSY(~0u)},
};

static const struct si_field r_008224_cp_cpf_stalled_stat1__fields[] = {
	{"RING_FETCHING_DATA", S_008224_RING_FETCHING_DATA(~0u)},
	{"INDR1_FETCHING_DATA", S_008224_INDR1_FETCHING_DATA(~0u)},
	{"INDR2_FETCHING_DATA", S_008224_INDR2_FETCHING_DATA(~0u)},
	{"STATE_FETCHING_DATA", S_008224_STATE_FETCHING_DATA(~0u)},
	{"TCIU_WAITING_ON_FREE", S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{"TCIU_WAITING_ON_TAGS", S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{"ATCL2IU_WAITING_ON_FREE", S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{"ATCL2IU_WAITING_ON_TAGS", S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{"ATCL1_WAITING_ON_TRANS", S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
};

static const struct si_field r_030230_cp_coher_size_hi__fields[] = {
	{"COHER_SIZE_HI_256B", S_030230_COHER_SIZE_HI_256B(~0u)},
};

static const struct si_field r_0088b0_vgt_vtx_vect_eject_reg__fields[] = {
	{"PRIM_COUNT", S_0088B0_PRIM_COUNT(~0u)},
};

static const struct si_field r_0088c4_vgt_cache_invalidation__fields[] = {
	{"VS_NO_EXTRA_BUFFER", S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{"STREAMOUT_FULL_FLUSH", S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{"ES_LIMIT", S_0088C4_ES_LIMIT(~0u)},
};

static const struct si_field r_0088d4_vgt_gs_vertex_reuse__fields[] = {
	{"VERT_REUSE", S_0088D4_VERT_REUSE(~0u)},
};

static const char *r_008958_vgt_primitive_type__prim_type__values[] = {
	[V_008958_DI_PT_NONE] = "DI_PT_NONE",
	[V_008958_DI_PT_POINTLIST] = "DI_PT_POINTLIST",
	[V_008958_DI_PT_LINELIST] = "DI_PT_LINELIST",
	[V_008958_DI_PT_LINESTRIP] = "DI_PT_LINESTRIP",
	[V_008958_DI_PT_TRILIST] = "DI_PT_TRILIST",
	[V_008958_DI_PT_TRIFAN] = "DI_PT_TRIFAN",
	[V_008958_DI_PT_TRISTRIP] = "DI_PT_TRISTRIP",
	[V_008958_DI_PT_UNUSED_0] = "DI_PT_UNUSED_0",
	[V_008958_DI_PT_UNUSED_1] = "DI_PT_UNUSED_1",
	[V_008958_DI_PT_PATCH] = "DI_PT_PATCH",
	[V_008958_DI_PT_LINELIST_ADJ] = "DI_PT_LINELIST_ADJ",
	[V_008958_DI_PT_LINESTRIP_ADJ] = "DI_PT_LINESTRIP_ADJ",
	[V_008958_DI_PT_TRILIST_ADJ] = "DI_PT_TRILIST_ADJ",
	[V_008958_DI_PT_TRISTRIP_ADJ] = "DI_PT_TRISTRIP_ADJ",
	[V_008958_DI_PT_UNUSED_3] = "DI_PT_UNUSED_3",
	[V_008958_DI_PT_UNUSED_4] = "DI_PT_UNUSED_4",
	[V_008958_DI_PT_TRI_WITH_WFLAGS] = "DI_PT_TRI_WITH_WFLAGS",
	[V_008958_DI_PT_RECTLIST] = "DI_PT_RECTLIST",
	[V_008958_DI_PT_LINELOOP] = "DI_PT_LINELOOP",
	[V_008958_DI_PT_QUADLIST] = "DI_PT_QUADLIST",
	[V_008958_DI_PT_QUADSTRIP] = "DI_PT_QUADSTRIP",
	[V_008958_DI_PT_POLYGON] = "DI_PT_POLYGON",
	[V_008958_DI_PT_2D_COPY_RECT_LIST_V0] = "DI_PT_2D_COPY_RECT_LIST_V0",
	[V_008958_DI_PT_2D_COPY_RECT_LIST_V1] = "DI_PT_2D_COPY_RECT_LIST_V1",
	[V_008958_DI_PT_2D_COPY_RECT_LIST_V2] = "DI_PT_2D_COPY_RECT_LIST_V2",
	[V_008958_DI_PT_2D_COPY_RECT_LIST_V3] = "DI_PT_2D_COPY_RECT_LIST_V3",
	[V_008958_DI_PT_2D_FILL_RECT_LIST] = "DI_PT_2D_FILL_RECT_LIST",
	[V_008958_DI_PT_2D_LINE_STRIP] = "DI_PT_2D_LINE_STRIP",
	[V_008958_DI_PT_2D_TRI_STRIP] = "DI_PT_2D_TRI_STRIP",
};

static const struct si_field r_008958_vgt_primitive_type__fields[] = {
	{"PRIM_TYPE", S_008958_PRIM_TYPE(~0u), ARRAY_SIZE(r_008958_vgt_primitive_type__prim_type__values), r_008958_vgt_primitive_type__prim_type__values},
};

static const char *r_00895c_vgt_index_type__index_type__values[] = {
	[V_00895C_DI_INDEX_SIZE_16_BIT] = "DI_INDEX_SIZE_16_BIT",
	[V_00895C_DI_INDEX_SIZE_32_BIT] = "DI_INDEX_SIZE_32_BIT",
};

static const struct si_field r_00895c_vgt_index_type__fields[] = {
	{"INDEX_TYPE", S_00895C_INDEX_TYPE(~0u), ARRAY_SIZE(r_00895c_vgt_index_type__index_type__values), r_00895c_vgt_index_type__index_type__values},
};

static const struct si_field r_008988_vgt_tf_ring_size__fields[] = {
	{"SIZE", S_008988_SIZE(~0u)},
};

static const struct si_field r_0089b0_vgt_hs_offchip_param__fields[] = {
	{"OFFCHIP_BUFFERING", S_0089B0_OFFCHIP_BUFFERING(~0u)},
};

static const struct si_field r_008a14_pa_cl_enhance__fields[] = {
	{"CLIP_VTX_REORDER_ENA", S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{"NUM_CLIP_SEQ", S_008A14_NUM_CLIP_SEQ(~0u)},
	{"CLIPPED_PRIM_SEQ_STALL", S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{"VE_NAN_PROC_DISABLE", S_008A14_VE_NAN_PROC_DISABLE(~0u)},
};

static const struct si_field r_008a60_pa_su_line_stipple_value__fields[] = {
	{"LINE_STIPPLE_VALUE", S_008A60_LINE_STIPPLE_VALUE(~0u)},
};

static const struct si_field r_008b10_pa_sc_line_stipple_state__fields[] = {
	{"CURRENT_PTR", S_008B10_CURRENT_PTR(~0u)},
	{"CURRENT_COUNT", S_008B10_CURRENT_COUNT(~0u)},
};

static const struct si_field r_008670_cp_stalled_stat3__fields[] = {
	{"CE_TO_CSF_NOT_RDY_TO_RCV", S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV", S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER", S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{"CE_TO_RAM_INIT_NOT_RDY", S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{"CE_TO_RAM_DUMP_NOT_RDY", S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{"CE_TO_RAM_WRITE_NOT_RDY", S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{"CE_TO_INC_FIFO_NOT_RDY_TO_RCV", S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{"CE_TO_WR_FIFO_NOT_RDY_TO_RCV", S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{"CE_WAITING_ON_BUFFER_DATA", S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{"CE_WAITING_ON_CE_BUFFER_FLAG", S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{"CE_WAITING_ON_DE_COUNTER", S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{"CE_WAITING_ON_DE_COUNTER_UNDERFLOW", S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{"TCIU_WAITING_ON_FREE", S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{"TCIU_WAITING_ON_TAGS", S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{"CE_STALLED_ON_TC_WR_CONFIRM", S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{"CE_STALLED_ON_ATOMIC_RTN_DATA", S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{"ATCL2IU_WAITING_ON_FREE", S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{"ATCL2IU_WAITING_ON_TAGS", S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{"ATCL1_WAITING_ON_TRANS", S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
};

static const struct si_field r_008674_cp_stalled_stat1__fields[] = {
	{"RBIU_TO_DMA_NOT_RDY_TO_RCV", S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{"RBIU_TO_SEM_NOT_RDY_TO_RCV", S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{"RBIU_TO_MEMWR_NOT_RDY_TO_RCV", S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{"ME_HAS_ACTIVE_CE_BUFFER_FLAG", S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{"ME_HAS_ACTIVE_DE_BUFFER_FLAG", S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{"ME_STALLED_ON_TC_WR_CONFIRM", S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{"ME_STALLED_ON_ATOMIC_RTN_DATA", S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{"ME_WAITING_ON_TC_READ_DATA", S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{"ME_WAITING_ON_REG_READ_DATA", S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{"RCIU_WAITING_ON_GDS_FREE", S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{"RCIU_WAITING_ON_GRBM_FREE", S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{"RCIU_WAITING_ON_VGT_FREE", S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{"RCIU_STALLED_ON_ME_READ", S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{"RCIU_STALLED_ON_DMA_READ", S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{"RCIU_STALLED_ON_APPEND_READ", S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{"RCIU_HALTED_BY_REG_VIOLATION", S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
};

static const struct si_field r_008678_cp_stalled_stat2__fields[] = {
	{"PFP_TO_CSF_NOT_RDY_TO_RCV", S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{"PFP_TO_MEQ_NOT_RDY_TO_RCV", S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{"PFP_TO_RCIU_NOT_RDY_TO_RCV", S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{"PFP_TO_VGT_WRITES_PENDING", S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{"PFP_RCIU_READ_PENDING", S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{"PFP_WAITING_ON_BUFFER_DATA", S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{"ME_WAIT_ON_CE_COUNTER", S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{"ME_WAIT_ON_AVAIL_BUFFER", S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{"GFX_CNTX_NOT_AVAIL_TO_ME", S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{"ME_RCIU_NOT_RDY_TO_RCV", S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{"ME_TO_CONST_NOT_RDY_TO_RCV", S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{"ME_WAITING_DATA_FROM_PFP", S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{"ME_WAITING_ON_PARTIAL_FLUSH", S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{"MEQ_TO_ME_NOT_RDY_TO_RCV", S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{"STQ_TO_ME_NOT_RDY_TO_RCV", S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{"ME_WAITING_DATA_FROM_STQ", S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{"PFP_STALLED_ON_TC_WR_CONFIRM", S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{"PFP_STALLED_ON_ATOMIC_RTN_DATA", S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{"EOPD_FIFO_NEEDS_SC_EOP_DONE", S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{"EOPD_FIFO_NEEDS_WR_CONFIRM", S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{"STRMO_WR_OF_PRIM_DATA_PENDING", S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{"PIPE_STATS_WR_DATA_PENDING", S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{"APPEND_RDY_WAIT_ON_CS_DONE", S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{"APPEND_RDY_WAIT_ON_PS_DONE", S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{"APPEND_WAIT_ON_WR_CONFIRM", S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{"APPEND_ACTIVE_PARTITION", S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{"APPEND_WAITING_TO_SEND_MEMWRITE", S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{"SURF_SYNC_NEEDS_IDLE_CNTXS", S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{"SURF_SYNC_NEEDS_ALL_CLEAN", S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
};

static const struct si_field r_008680_cp_stat__fields[] = {
	{"ROQ_RING_BUSY", S_008680_ROQ_RING_BUSY(~0u)},
	{"ROQ_INDIRECT1_BUSY", S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{"ROQ_INDIRECT2_BUSY", S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{"ROQ_STATE_BUSY", S_008680_ROQ_STATE_BUSY(~0u)},
	{"DC_BUSY", S_008680_DC_BUSY(~0u)},
	{"ATCL2IU_BUSY", S_008680_ATCL2IU_BUSY(~0u)},
	{"PFP_BUSY", S_008680_PFP_BUSY(~0u)},
	{"MEQ_BUSY", S_008680_MEQ_BUSY(~0u)},
	{"ME_BUSY", S_008680_ME_BUSY(~0u)},
	{"QUERY_BUSY", S_008680_QUERY_BUSY(~0u)},
	{"SEMAPHORE_BUSY", S_008680_SEMAPHORE_BUSY(~0u)},
	{"INTERRUPT_BUSY", S_008680_INTERRUPT_BUSY(~0u)},
	{"SURFACE_SYNC_BUSY", S_008680_SURFACE_SYNC_BUSY(~0u)},
	{"DMA_BUSY", S_008680_DMA_BUSY(~0u)},
	{"RCIU_BUSY", S_008680_RCIU_BUSY(~0u)},
	{"SCRATCH_RAM_BUSY", S_008680_SCRATCH_RAM_BUSY(~0u)},
	{"CPC_CPG_BUSY", S_008680_CPC_CPG_BUSY(~0u)},
	{"CE_BUSY", S_008680_CE_BUSY(~0u)},
	{"TCIU_BUSY", S_008680_TCIU_BUSY(~0u)},
	{"ROQ_CE_RING_BUSY", S_008680_ROQ_CE_RING_BUSY(~0u)},
	{"ROQ_CE_INDIRECT1_BUSY", S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{"ROQ_CE_INDIRECT2_BUSY", S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{"CP_BUSY", S_008680_CP_BUSY(~0u)},
};

static const struct si_field r_030800_grbm_gfx_index__fields[] = {
	{"INSTANCE_INDEX", S_030800_INSTANCE_INDEX(~0u)},
	{"SH_INDEX", S_030800_SH_INDEX(~0u)},
	{"SE_INDEX", S_030800_SE_INDEX(~0u)},
	{"SH_BROADCAST_WRITES", S_030800_SH_BROADCAST_WRITES(~0u)},
	{"INSTANCE_BROADCAST_WRITES", S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{"SE_BROADCAST_WRITES", S_030800_SE_BROADCAST_WRITES(~0u)},
};

static const char *r_030908_vgt_primitive_type__prim_type__values[] = {
	[V_030908_DI_PT_NONE] = "DI_PT_NONE",
	[V_030908_DI_PT_POINTLIST] = "DI_PT_POINTLIST",
	[V_030908_DI_PT_LINELIST] = "DI_PT_LINELIST",
	[V_030908_DI_PT_LINESTRIP] = "DI_PT_LINESTRIP",
	[V_030908_DI_PT_TRILIST] = "DI_PT_TRILIST",
	[V_030908_DI_PT_TRIFAN] = "DI_PT_TRIFAN",
	[V_030908_DI_PT_TRISTRIP] = "DI_PT_TRISTRIP",
	[V_030908_DI_PT_PATCH] = "DI_PT_PATCH",
	[V_030908_DI_PT_LINELIST_ADJ] = "DI_PT_LINELIST_ADJ",
	[V_030908_DI_PT_LINESTRIP_ADJ] = "DI_PT_LINESTRIP_ADJ",
	[V_030908_DI_PT_TRILIST_ADJ] = "DI_PT_TRILIST_ADJ",
	[V_030908_DI_PT_TRISTRIP_ADJ] = "DI_PT_TRISTRIP_ADJ",
	[V_030908_DI_PT_TRI_WITH_WFLAGS] = "DI_PT_TRI_WITH_WFLAGS",
	[V_030908_DI_PT_RECTLIST] = "DI_PT_RECTLIST",
	[V_030908_DI_PT_LINELOOP] = "DI_PT_LINELOOP",
	[V_030908_DI_PT_QUADLIST] = "DI_PT_QUADLIST",
	[V_030908_DI_PT_QUADSTRIP] = "DI_PT_QUADSTRIP",
	[V_030908_DI_PT_POLYGON] = "DI_PT_POLYGON",
	[V_030908_DI_PT_2D_COPY_RECT_LIST_V0] = "DI_PT_2D_COPY_RECT_LIST_V0",
	[V_030908_DI_PT_2D_COPY_RECT_LIST_V1] = "DI_PT_2D_COPY_RECT_LIST_V1",
	[V_030908_DI_PT_2D_COPY_RECT_LIST_V2] = "DI_PT_2D_COPY_RECT_LIST_V2",
	[V_030908_DI_PT_2D_COPY_RECT_LIST_V3] = "DI_PT_2D_COPY_RECT_LIST_V3",
	[V_030908_DI_PT_2D_FILL_RECT_LIST] = "DI_PT_2D_FILL_RECT_LIST",
	[V_030908_DI_PT_2D_LINE_STRIP] = "DI_PT_2D_LINE_STRIP",
	[V_030908_DI_PT_2D_TRI_STRIP] = "DI_PT_2D_TRI_STRIP",
};

static const struct si_field r_030908_vgt_primitive_type__fields[] = {
	{"PRIM_TYPE", S_030908_PRIM_TYPE(~0u), ARRAY_SIZE(r_030908_vgt_primitive_type__prim_type__values), r_030908_vgt_primitive_type__prim_type__values},
};

static const char *r_03090c_vgt_index_type__index_type__values[] = {
	[V_03090C_DI_INDEX_SIZE_16_BIT] = "DI_INDEX_SIZE_16_BIT",
	[V_03090C_DI_INDEX_SIZE_32_BIT] = "DI_INDEX_SIZE_32_BIT",
};

static const struct si_field r_03090c_vgt_index_type__fields[] = {
	{"INDEX_TYPE", S_03090C_INDEX_TYPE(~0u), ARRAY_SIZE(r_03090c_vgt_index_type__index_type__values), r_03090c_vgt_index_type__index_type__values},
};

static const struct si_field r_030938_vgt_tf_ring_size__fields[] = {
	{"SIZE", S_030938_SIZE(~0u)},
};

static const char *r_03093c_vgt_hs_offchip_param__offchip_granularity__values[] = {
	[V_03093C_X_8K_DWORDS] = "X_8K_DWORDS",
	[V_03093C_X_4K_DWORDS] = "X_4K_DWORDS",
	[V_03093C_X_2K_DWORDS] = "X_2K_DWORDS",
	[V_03093C_X_1K_DWORDS] = "X_1K_DWORDS",
};

static const struct si_field r_03093c_vgt_hs_offchip_param__fields[] = {
	{"OFFCHIP_BUFFERING", S_03093C_OFFCHIP_BUFFERING(~0u)},
	{"OFFCHIP_GRANULARITY", S_03093C_OFFCHIP_GRANULARITY(~0u), ARRAY_SIZE(r_03093c_vgt_hs_offchip_param__offchip_granularity__values), r_03093c_vgt_hs_offchip_param__offchip_granularity__values},
};

static const struct si_field r_030a00_pa_su_line_stipple_value__fields[] = {
	{"LINE_STIPPLE_VALUE", S_030A00_LINE_STIPPLE_VALUE(~0u)},
};

static const struct si_field r_030a04_pa_sc_line_stipple_state__fields[] = {
	{"CURRENT_PTR", S_030A04_CURRENT_PTR(~0u)},
	{"CURRENT_COUNT", S_030A04_CURRENT_COUNT(~0u)},
};

static const struct si_field r_030a10_pa_sc_screen_extent_min_0__fields[] = {
	{"X", S_030A10_X(~0u)},
	{"Y", S_030A10_Y(~0u)},
};

static const struct si_field r_030a14_pa_sc_screen_extent_max_0__fields[] = {
	{"X", S_030A14_X(~0u)},
	{"Y", S_030A14_Y(~0u)},
};

static const struct si_field r_030a18_pa_sc_screen_extent_min_1__fields[] = {
	{"X", S_030A18_X(~0u)},
	{"Y", S_030A18_Y(~0u)},
};

static const struct si_field r_030a2c_pa_sc_screen_extent_max_1__fields[] = {
	{"X", S_030A2C_X(~0u)},
	{"Y", S_030A2C_Y(~0u)},
};

static const struct si_field r_008bf0_pa_sc_enhance__fields[] = {
	{"ENABLE_PA_SC_OUT_OF_ORDER", S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{"DISABLE_SC_DB_TILE_FIX", S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{"DISABLE_AA_MASK_FULL_FIX", S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{"ENABLE_1XMSAA_SAMPLE_LOCATIONS", S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID", S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{"DISABLE_SCISSOR_FIX", S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{"DISABLE_PW_BUBBLE_COLLAPSE", S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{"SEND_UNLIT_STILES_TO_PACKER", S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{"DISABLE_DUALGRAD_PERF_OPTIMIZATION", S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
};

static const struct si_field r_008c08_sqc_caches__fields[] = {
	{"INST_INVALIDATE", S_008C08_INST_INVALIDATE(~0u)},
	{"DATA_INVALIDATE", S_008C08_DATA_INVALIDATE(~0u)},
};

static const struct si_field r_030d20_sqc_caches__fields[] = {
	{"INST_INVALIDATE", S_030D20_INST_INVALIDATE(~0u)},
	{"DATA_INVALIDATE", S_030D20_DATA_INVALIDATE(~0u)},
	{"INVALIDATE_VOLATILE", S_030D20_INVALIDATE_VOLATILE(~0u)},
};

static const struct si_field r_008c0c_sq_random_wave_pri__fields[] = {
	{"RET", S_008C0C_RET(~0u)},
	{"RUI", S_008C0C_RUI(~0u)},
	{"RNG", S_008C0C_RNG(~0u)},
};

static const char *r_008dfc_sq_exp_0__tgt__values[] = {
	[V_008DFC_SQ_EXP_MRT] = "SQ_EXP_MRT",
	[V_008DFC_SQ_EXP_MRTZ] = "SQ_EXP_MRTZ",
	[V_008DFC_SQ_EXP_NULL] = "SQ_EXP_NULL",
	[V_008DFC_SQ_EXP_POS] = "SQ_EXP_POS",
	[V_008DFC_SQ_EXP_PARAM] = "SQ_EXP_PARAM",
};

static const char *r_008dfc_sq_exp_0__encoding__values[] = {
	[V_008DFC_SQ_ENC_EXP_FIELD] = "SQ_ENC_EXP_FIELD",
};

static const struct si_field r_008dfc_sq_exp_0__fields[] = {
	{"EN", S_008DFC_EN(~0u)},
	{"TGT", S_008DFC_TGT(~0u), ARRAY_SIZE(r_008dfc_sq_exp_0__tgt__values), r_008dfc_sq_exp_0__tgt__values},
	{"COMPR", S_008DFC_COMPR(~0u)},
	{"DONE", S_008DFC_DONE(~0u)},
	{"VM", S_008DFC_VM(~0u)},
	{"ENCODING", S_008DFC_ENCODING(~0u), ARRAY_SIZE(r_008dfc_sq_exp_0__encoding__values), r_008dfc_sq_exp_0__encoding__values},
};

static const struct si_field r_030e04_ta_cs_bc_base_addr_hi__fields[] = {
	{"ADDRESS", S_030E04_ADDRESS(~0u)},
};

static const struct si_field r_030f04_db_occlusion_count0_hi__fields[] = {
	{"COUNT_HI", S_030F04_COUNT_HI(~0u)},
};

static const struct si_field r_008f04_sq_buf_rsrc_word1__fields[] = {
	{"BASE_ADDRESS_HI", S_008F04_BASE_ADDRESS_HI(~0u)},
	{"STRIDE", S_008F04_STRIDE(~0u)},
	{"CACHE_SWIZZLE", S_008F04_CACHE_SWIZZLE(~0u)},
	{"SWIZZLE_ENABLE", S_008F04_SWIZZLE_ENABLE(~0u)},
};

static const struct si_field r_030f0c_db_occlusion_count1_hi__fields[] = {
	{"COUNT_HI", S_030F0C_COUNT_HI(~0u)},
};

static const char *r_008f0c_sq_buf_rsrc_word3__dst_sel_x__values[] = {
	[V_008F0C_SQ_SEL_0] = "SQ_SEL_0",
	[V_008F0C_SQ_SEL_1] = "SQ_SEL_1",
	[V_008F0C_SQ_SEL_RESERVED_0] = "SQ_SEL_RESERVED_0",
	[V_008F0C_SQ_SEL_RESERVED_1] = "SQ_SEL_RESERVED_1",
	[V_008F0C_SQ_SEL_X] = "SQ_SEL_X",
	[V_008F0C_SQ_SEL_Y] = "SQ_SEL_Y",
	[V_008F0C_SQ_SEL_Z] = "SQ_SEL_Z",
	[V_008F0C_SQ_SEL_W] = "SQ_SEL_W",
};

static const char *r_008f0c_sq_buf_rsrc_word3__dst_sel_y__values[] = {
	[V_008F0C_SQ_SEL_0] = "SQ_SEL_0",
	[V_008F0C_SQ_SEL_1] = "SQ_SEL_1",
	[V_008F0C_SQ_SEL_RESERVED_0] = "SQ_SEL_RESERVED_0",
	[V_008F0C_SQ_SEL_RESERVED_1] = "SQ_SEL_RESERVED_1",
	[V_008F0C_SQ_SEL_X] = "SQ_SEL_X",
	[V_008F0C_SQ_SEL_Y] = "SQ_SEL_Y",
	[V_008F0C_SQ_SEL_Z] = "SQ_SEL_Z",
	[V_008F0C_SQ_SEL_W] = "SQ_SEL_W",
};

static const char *r_008f0c_sq_buf_rsrc_word3__dst_sel_z__values[] = {
	[V_008F0C_SQ_SEL_0] = "SQ_SEL_0",
	[V_008F0C_SQ_SEL_1] = "SQ_SEL_1",
	[V_008F0C_SQ_SEL_RESERVED_0] = "SQ_SEL_RESERVED_0",
	[V_008F0C_SQ_SEL_RESERVED_1] = "SQ_SEL_RESERVED_1",
	[V_008F0C_SQ_SEL_X] = "SQ_SEL_X",
	[V_008F0C_SQ_SEL_Y] = "SQ_SEL_Y",
	[V_008F0C_SQ_SEL_Z] = "SQ_SEL_Z",
	[V_008F0C_SQ_SEL_W] = "SQ_SEL_W",
};

static const char *r_008f0c_sq_buf_rsrc_word3__dst_sel_w__values[] = {
	[V_008F0C_SQ_SEL_0] = "SQ_SEL_0",
	[V_008F0C_SQ_SEL_1] = "SQ_SEL_1",
	[V_008F0C_SQ_SEL_RESERVED_0] = "SQ_SEL_RESERVED_0",
	[V_008F0C_SQ_SEL_RESERVED_1] = "SQ_SEL_RESERVED_1",
	[V_008F0C_SQ_SEL_X] = "SQ_SEL_X",
	[V_008F0C_SQ_SEL_Y] = "SQ_SEL_Y",
	[V_008F0C_SQ_SEL_Z] = "SQ_SEL_Z",
	[V_008F0C_SQ_SEL_W] = "SQ_SEL_W",
};

static const char *r_008f0c_sq_buf_rsrc_word3__num_format__values[] = {
	[V_008F0C_BUF_NUM_FORMAT_UNORM] = "BUF_NUM_FORMAT_UNORM",
	[V_008F0C_BUF_NUM_FORMAT_SNORM] = "BUF_NUM_FORMAT_SNORM",
	[V_008F0C_BUF_NUM_FORMAT_USCALED] = "BUF_NUM_FORMAT_USCALED",
	[V_008F0C_BUF_NUM_FORMAT_SSCALED] = "BUF_NUM_FORMAT_SSCALED",
	[V_008F0C_BUF_NUM_FORMAT_UINT] = "BUF_NUM_FORMAT_UINT",
	[V_008F0C_BUF_NUM_FORMAT_SINT] = "BUF_NUM_FORMAT_SINT",
	[V_008F0C_BUF_NUM_FORMAT_SNORM_OGL] = "BUF_NUM_FORMAT_SNORM_OGL",
	[V_008F0C_BUF_NUM_FORMAT_FLOAT] = "BUF_NUM_FORMAT_FLOAT",
};

static const char *r_008f0c_sq_buf_rsrc_word3__data_format__values[] = {
	[V_008F0C_BUF_DATA_FORMAT_INVALID] = "BUF_DATA_FORMAT_INVALID",
	[V_008F0C_BUF_DATA_FORMAT_8] = "BUF_DATA_FORMAT_8",
	[V_008F0C_BUF_DATA_FORMAT_16] = "BUF_DATA_FORMAT_16",
	[V_008F0C_BUF_DATA_FORMAT_8_8] = "BUF_DATA_FORMAT_8_8",
	[V_008F0C_BUF_DATA_FORMAT_32] = "BUF_DATA_FORMAT_32",
	[V_008F0C_BUF_DATA_FORMAT_16_16] = "BUF_DATA_FORMAT_16_16",
	[V_008F0C_BUF_DATA_FORMAT_10_11_11] = "BUF_DATA_FORMAT_10_11_11",
	[V_008F0C_BUF_DATA_FORMAT_11_11_10] = "BUF_DATA_FORMAT_11_11_10",
	[V_008F0C_BUF_DATA_FORMAT_10_10_10_2] = "BUF_DATA_FORMAT_10_10_10_2",
	[V_008F0C_BUF_DATA_FORMAT_2_10_10_10] = "BUF_DATA_FORMAT_2_10_10_10",
	[V_008F0C_BUF_DATA_FORMAT_8_8_8_8] = "BUF_DATA_FORMAT_8_8_8_8",
	[V_008F0C_BUF_DATA_FORMAT_32_32] = "BUF_DATA_FORMAT_32_32",
	[V_008F0C_BUF_DATA_FORMAT_16_16_16_16] = "BUF_DATA_FORMAT_16_16_16_16",
	[V_008F0C_BUF_DATA_FORMAT_32_32_32] = "BUF_DATA_FORMAT_32_32_32",
	[V_008F0C_BUF_DATA_FORMAT_32_32_32_32] = "BUF_DATA_FORMAT_32_32_32_32",
	[V_008F0C_BUF_DATA_FORMAT_RESERVED_15] = "BUF_DATA_FORMAT_RESERVED_15",
};

static const char *r_008f0c_sq_buf_rsrc_word3__type__values[] = {
	[V_008F0C_SQ_RSRC_BUF] = "SQ_RSRC_BUF",
	[V_008F0C_SQ_RSRC_BUF_RSVD_1] = "SQ_RSRC_BUF_RSVD_1",
	[V_008F0C_SQ_RSRC_BUF_RSVD_2] = "SQ_RSRC_BUF_RSVD_2",
	[V_008F0C_SQ_RSRC_BUF_RSVD_3] = "SQ_RSRC_BUF_RSVD_3",
};

static const struct si_field r_008f0c_sq_buf_rsrc_word3__fields[] = {
	{"DST_SEL_X", S_008F0C_DST_SEL_X(~0u), ARRAY_SIZE(r_008f0c_sq_buf_rsrc_word3__dst_sel_x__values), r_008f0c_sq_buf_rsrc_word3__dst_sel_x__values},
	{"DST_SEL_Y", S_008F0C_DST_SEL_Y(~0u), ARRAY_SIZE(r_008f0c_sq_buf_rsrc_word3__dst_sel_y__values), r_008f0c_sq_buf_rsrc_word3__dst_sel_y__values},
	{"DST_SEL_Z", S_008F0C_DST_SEL_Z(~0u), ARRAY_SIZE(r_008f0c_sq_buf_rsrc_word3__dst_sel_z__values), r_008f0c_sq_buf_rsrc_word3__dst_sel_z__values},
	{"DST_SEL_W", S_008F0C_DST_SEL_W(~0u), ARRAY_SIZE(r_008f0c_sq_buf_rsrc_word3__dst_sel_w__values), r_008f0c_sq_buf_rsrc_word3__dst_sel_w__values},
	{"NUM_FORMAT", S_008F0C_NUM_FORMAT(~0u), ARRAY_SIZE(r_008f0c_sq_buf_rsrc_word3__num_format__values), r_008f0c_sq_buf_rsrc_word3__num_format__values},
	{"DATA_FORMAT", S_008F0C_DATA_FORMAT(~0u), ARRAY_SIZE(r_008f0c_sq_buf_rsrc_word3__data_format__values), r_008f0c_sq_buf_rsrc_word3__data_format__values},
	{"ELEMENT_SIZE", S_008F0C_ELEMENT_SIZE(~0u)},
	{"INDEX_STRIDE", S_008F0C_INDEX_STRIDE(~0u)},
	{"ADD_TID_ENABLE", S_008F0C_ADD_TID_ENABLE(~0u)},
	{"ATC", S_008F0C_ATC(~0u)},
	{"HASH_ENABLE", S_008F0C_HASH_ENABLE(~0u)},
	{"HEAP", S_008F0C_HEAP(~0u)},
	{"MTYPE", S_008F0C_MTYPE(~0u)},
	{"TYPE", S_008F0C_TYPE(~0u), ARRAY_SIZE(r_008f0c_sq_buf_rsrc_word3__type__values), r_008f0c_sq_buf_rsrc_word3__type__values},
};

static const struct si_field r_030f14_db_occlusion_count2_hi__fields[] = {
	{"COUNT_HI", S_030F14_COUNT_HI(~0u)},
};

static const char *r_008f14_sq_img_rsrc_word1__data_format__values[] = {
	[V_008F14_IMG_DATA_FORMAT_INVALID] = "IMG_DATA_FORMAT_INVALID",
	[V_008F14_IMG_DATA_FORMAT_8] = "IMG_DATA_FORMAT_8",
	[V_008F14_IMG_DATA_FORMAT_16] = "IMG_DATA_FORMAT_16",
	[V_008F14_IMG_DATA_FORMAT_8_8] = "IMG_DATA_FORMAT_8_8",
	[V_008F14_IMG_DATA_FORMAT_32] = "IMG_DATA_FORMAT_32",
	[V_008F14_IMG_DATA_FORMAT_16_16] = "IMG_DATA_FORMAT_16_16",
	[V_008F14_IMG_DATA_FORMAT_10_11_11] = "IMG_DATA_FORMAT_10_11_11",
	[V_008F14_IMG_DATA_FORMAT_11_11_10] = "IMG_DATA_FORMAT_11_11_10",
	[V_008F14_IMG_DATA_FORMAT_10_10_10_2] = "IMG_DATA_FORMAT_10_10_10_2",
	[V_008F14_IMG_DATA_FORMAT_2_10_10_10] = "IMG_DATA_FORMAT_2_10_10_10",
	[V_008F14_IMG_DATA_FORMAT_8_8_8_8] = "IMG_DATA_FORMAT_8_8_8_8",
	[V_008F14_IMG_DATA_FORMAT_32_32] = "IMG_DATA_FORMAT_32_32",
	[V_008F14_IMG_DATA_FORMAT_16_16_16_16] = "IMG_DATA_FORMAT_16_16_16_16",
	[V_008F14_IMG_DATA_FORMAT_32_32_32] = "IMG_DATA_FORMAT_32_32_32",
	[V_008F14_IMG_DATA_FORMAT_32_32_32_32] = "IMG_DATA_FORMAT_32_32_32_32",
	[V_008F14_IMG_DATA_FORMAT_RESERVED_15] = "IMG_DATA_FORMAT_RESERVED_15",
	[V_008F14_IMG_DATA_FORMAT_5_6_5] = "IMG_DATA_FORMAT_5_6_5",
	[V_008F14_IMG_DATA_FORMAT_1_5_5_5] = "IMG_DATA_FORMAT_1_5_5_5",
	[V_008F14_IMG_DATA_FORMAT_5_5_5_1] = "IMG_DATA_FORMAT_5_5_5_1",
	[V_008F14_IMG_DATA_FORMAT_4_4_4_4] = "IMG_DATA_FORMAT_4_4_4_4",
	[V_008F14_IMG_DATA_FORMAT_8_24] = "IMG_DATA_FORMAT_8_24",
	[V_008F14_IMG_DATA_FORMAT_24_8] = "IMG_DATA_FORMAT_24_8",
	[V_008F14_IMG_DATA_FORMAT_X24_8_32] = "IMG_DATA_FORMAT_X24_8_32",
	[V_008F14_IMG_DATA_FORMAT_RESERVED_23] = "IMG_DATA_FORMAT_RESERVED_23",
	[V_008F14_IMG_DATA_FORMAT_RESERVED_24] = "IMG_DATA_FORMAT_RESERVED_24",
	[V_008F14_IMG_DATA_FORMAT_RESERVED_25] = "IMG_DATA_FORMAT_RESERVED_25",
	[V_008F14_IMG_DATA_FORMAT_RESERVED_26] = "IMG_DATA_FORMAT_RESERVED_26",
	[V_008F14_IMG_DATA_FORMAT_RESERVED_27] = "IMG_DATA_FORMAT_RESERVED_27",
	[V_008F14_IMG_DATA_FORMAT_RESERVED_28] = "IMG_DATA_FORMAT_RESERVED_28",
	[V_008F14_IMG_DATA_FORMAT_RESERVED_29] = "IMG_DATA_FORMAT_RESERVED_29",
	[V_008F14_IMG_DATA_FORMAT_RESERVED_30] = "IMG_DATA_FORMAT_RESERVED_30",
	[V_008F14_IMG_DATA_FORMAT_RESERVED_31] = "IMG_DATA_FORMAT_RESERVED_31",
	[V_008F14_IMG_DATA_FORMAT_GB_GR] = "IMG_DATA_FORMAT_GB_GR",
	[V_008F14_IMG_DATA_FORMAT_BG_RG] = "IMG_DATA_FORMAT_BG_RG",
	[V_008F14_IMG_DATA_FORMAT_5_9_9_9] = "IMG_DATA_FORMAT_5_9_9_9",
	[V_008F14_IMG_DATA_FORMAT_BC1] = "IMG_DATA_FORMAT_BC1",
	[V_008F14_IMG_DATA_FORMAT_BC2] = "IMG_DATA_FORMAT_BC2",
	[V_008F14_IMG_DATA_FORMAT_BC3] = "IMG_DATA_FORMAT_BC3",
	[V_008F14_IMG_DATA_FORMAT_BC4] = "IMG_DATA_FORMAT_BC4",
	[V_008F14_IMG_DATA_FORMAT_BC5] = "IMG_DATA_FORMAT_BC5",
	[V_008F14_IMG_DATA_FORMAT_BC6] = "IMG_DATA_FORMAT_BC6",
	[V_008F14_IMG_DATA_FORMAT_BC7] = "IMG_DATA_FORMAT_BC7",
	[V_008F14_IMG_DATA_FORMAT_RESERVED_42] = "IMG_DATA_FORMAT_RESERVED_42",
	[V_008F14_IMG_DATA_FORMAT_RESERVED_43] = "IMG_DATA_FORMAT_RESERVED_43",
	[V_008F14_IMG_DATA_FORMAT_FMASK8_S2_F1] = "IMG_DATA_FORMAT_FMASK8_S2_F1",
	[V_008F14_IMG_DATA_FORMAT_FMASK8_S4_F1] = "IMG_DATA_FORMAT_FMASK8_S4_F1",
	[V_008F14_IMG_DATA_FORMAT_FMASK8_S8_F1] = "IMG_DATA_FORMAT_FMASK8_S8_F1",
	[V_008F14_IMG_DATA_FORMAT_FMASK8_S2_F2] = "IMG_DATA_FORMAT_FMASK8_S2_F2",
	[V_008F14_IMG_DATA_FORMAT_FMASK8_S4_F2] = "IMG_DATA_FORMAT_FMASK8_S4_F2",
	[V_008F14_IMG_DATA_FORMAT_FMASK8_S4_F4] = "IMG_DATA_FORMAT_FMASK8_S4_F4",
	[V_008F14_IMG_DATA_FORMAT_FMASK16_S16_F1] = "IMG_DATA_FORMAT_FMASK16_S16_F1",
	[V_008F14_IMG_DATA_FORMAT_FMASK16_S8_F2] = "IMG_DATA_FORMAT_FMASK16_S8_F2",
	[V_008F14_IMG_DATA_FORMAT_FMASK32_S16_F2] = "IMG_DATA_FORMAT_FMASK32_S16_F2",
	[V_008F14_IMG_DATA_FORMAT_FMASK32_S8_F4] = "IMG_DATA_FORMAT_FMASK32_S8_F4",
	[V_008F14_IMG_DATA_FORMAT_FMASK32_S8_F8] = "IMG_DATA_FORMAT_FMASK32_S8_F8",
	[V_008F14_IMG_DATA_FORMAT_FMASK64_S16_F4] = "IMG_DATA_FORMAT_FMASK64_S16_F4",
	[V_008F14_IMG_DATA_FORMAT_FMASK64_S16_F8] = "IMG_DATA_FORMAT_FMASK64_S16_F8",
	[V_008F14_IMG_DATA_FORMAT_4_4] = "IMG_DATA_FORMAT_4_4",
	[V_008F14_IMG_DATA_FORMAT_6_5_5] = "IMG_DATA_FORMAT_6_5_5",
	[V_008F14_IMG_DATA_FORMAT_1] = "IMG_DATA_FORMAT_1",
	[V_008F14_IMG_DATA_FORMAT_1_REVERSED] = "IMG_DATA_FORMAT_1_REVERSED",
	[V_008F14_IMG_DATA_FORMAT_32_AS_8] = "IMG_DATA_FORMAT_32_AS_8",
	[V_008F14_IMG_DATA_FORMAT_32_AS_8_8] = "IMG_DATA_FORMAT_32_AS_8_8",
	[V_008F14_IMG_DATA_FORMAT_32_AS_32_32_32_32] = "IMG_DATA_FORMAT_32_AS_32_32_32_32",
};

static const char *r_008f14_sq_img_rsrc_word1__num_format__values[] = {
	[V_008F14_IMG_NUM_FORMAT_UNORM] = "IMG_NUM_FORMAT_UNORM",
	[V_008F14_IMG_NUM_FORMAT_SNORM] = "IMG_NUM_FORMAT_SNORM",
	[V_008F14_IMG_NUM_FORMAT_USCALED] = "IMG_NUM_FORMAT_USCALED",
	[V_008F14_IMG_NUM_FORMAT_SSCALED] = "IMG_NUM_FORMAT_SSCALED",
	[V_008F14_IMG_NUM_FORMAT_UINT] = "IMG_NUM_FORMAT_UINT",
	[V_008F14_IMG_NUM_FORMAT_SINT] = "IMG_NUM_FORMAT_SINT",
	[V_008F14_IMG_NUM_FORMAT_SNORM_OGL] = "IMG_NUM_FORMAT_SNORM_OGL",
	[V_008F14_IMG_NUM_FORMAT_FLOAT] = "IMG_NUM_FORMAT_FLOAT",
	[V_008F14_IMG_NUM_FORMAT_RESERVED_8] = "IMG_NUM_FORMAT_RESERVED_8",
	[V_008F14_IMG_NUM_FORMAT_SRGB] = "IMG_NUM_FORMAT_SRGB",
	[V_008F14_IMG_NUM_FORMAT_UBNORM] = "IMG_NUM_FORMAT_UBNORM",
	[V_008F14_IMG_NUM_FORMAT_UBNORM_OGL] = "IMG_NUM_FORMAT_UBNORM_OGL",
	[V_008F14_IMG_NUM_FORMAT_UBINT] = "IMG_NUM_FORMAT_UBINT",
	[V_008F14_IMG_NUM_FORMAT_UBSCALED] = "IMG_NUM_FORMAT_UBSCALED",
	[V_008F14_IMG_NUM_FORMAT_RESERVED_14] = "IMG_NUM_FORMAT_RESERVED_14",
	[V_008F14_IMG_NUM_FORMAT_RESERVED_15] = "IMG_NUM_FORMAT_RESERVED_15",
};

static const struct si_field r_008f14_sq_img_rsrc_word1__fields[] = {
	{"BASE_ADDRESS_HI", S_008F14_BASE_ADDRESS_HI(~0u)},
	{"MIN_LOD", S_008F14_MIN_LOD(~0u)},
	{"DATA_FORMAT", S_008F14_DATA_FORMAT(~0u), ARRAY_SIZE(r_008f14_sq_img_rsrc_word1__data_format__values), r_008f14_sq_img_rsrc_word1__data_format__values},
	{"NUM_FORMAT", S_008F14_NUM_FORMAT(~0u), ARRAY_SIZE(r_008f14_sq_img_rsrc_word1__num_format__values), r_008f14_sq_img_rsrc_word1__num_format__values},
	{"MTYPE", S_008F14_MTYPE(~0u)},
};

static const struct si_field r_008f18_sq_img_rsrc_word2__fields[] = {
	{"WIDTH", S_008F18_WIDTH(~0u)},
	{"HEIGHT", S_008F18_HEIGHT(~0u)},
	{"PERF_MOD", S_008F18_PERF_MOD(~0u)},
	{"INTERLACED", S_008F18_INTERLACED(~0u)},
};

static const struct si_field r_030f1c_db_occlusion_count3_hi__fields[] = {
	{"COUNT_HI", S_030F1C_COUNT_HI(~0u)},
};

static const char *r_008f1c_sq_img_rsrc_word3__dst_sel_x__values[] = {
	[V_008F1C_SQ_SEL_0] = "SQ_SEL_0",
	[V_008F1C_SQ_SEL_1] = "SQ_SEL_1",
	[V_008F1C_SQ_SEL_RESERVED_0] = "SQ_SEL_RESERVED_0",
	[V_008F1C_SQ_SEL_RESERVED_1] = "SQ_SEL_RESERVED_1",
	[V_008F1C_SQ_SEL_X] = "SQ_SEL_X",
	[V_008F1C_SQ_SEL_Y] = "SQ_SEL_Y",
	[V_008F1C_SQ_SEL_Z] = "SQ_SEL_Z",
	[V_008F1C_SQ_SEL_W] = "SQ_SEL_W",
};

static const char *r_008f1c_sq_img_rsrc_word3__dst_sel_y__values[] = {
	[V_008F1C_SQ_SEL_0] = "SQ_SEL_0",
	[V_008F1C_SQ_SEL_1] = "SQ_SEL_1",
	[V_008F1C_SQ_SEL_RESERVED_0] = "SQ_SEL_RESERVED_0",
	[V_008F1C_SQ_SEL_RESERVED_1] = "SQ_SEL_RESERVED_1",
	[V_008F1C_SQ_SEL_X] = "SQ_SEL_X",
	[V_008F1C_SQ_SEL_Y] = "SQ_SEL_Y",
	[V_008F1C_SQ_SEL_Z] = "SQ_SEL_Z",
	[V_008F1C_SQ_SEL_W] = "SQ_SEL_W",
};

static const char *r_008f1c_sq_img_rsrc_word3__dst_sel_z__values[] = {
	[V_008F1C_SQ_SEL_0] = "SQ_SEL_0",
	[V_008F1C_SQ_SEL_1] = "SQ_SEL_1",
	[V_008F1C_SQ_SEL_RESERVED_0] = "SQ_SEL_RESERVED_0",
	[V_008F1C_SQ_SEL_RESERVED_1] = "SQ_SEL_RESERVED_1",
	[V_008F1C_SQ_SEL_X] = "SQ_SEL_X",
	[V_008F1C_SQ_SEL_Y] = "SQ_SEL_Y",
	[V_008F1C_SQ_SEL_Z] = "SQ_SEL_Z",
	[V_008F1C_SQ_SEL_W] = "SQ_SEL_W",
};

static const char *r_008f1c_sq_img_rsrc_word3__dst_sel_w__values[] = {
	[V_008F1C_SQ_SEL_0] = "SQ_SEL_0",
	[V_008F1C_SQ_SEL_1] = "SQ_SEL_1",
	[V_008F1C_SQ_SEL_RESERVED_0] = "SQ_SEL_RESERVED_0",
	[V_008F1C_SQ_SEL_RESERVED_1] = "SQ_SEL_RESERVED_1",
	[V_008F1C_SQ_SEL_X] = "SQ_SEL_X",
	[V_008F1C_SQ_SEL_Y] = "SQ_SEL_Y",
	[V_008F1C_SQ_SEL_Z] = "SQ_SEL_Z",
	[V_008F1C_SQ_SEL_W] = "SQ_SEL_W",
};

static const char *r_008f1c_sq_img_rsrc_word3__type__values[] = {
	[V_008F1C_SQ_RSRC_IMG_RSVD_0] = "SQ_RSRC_IMG_RSVD_0",
	[V_008F1C_SQ_RSRC_IMG_RSVD_1] = "SQ_RSRC_IMG_RSVD_1",
	[V_008F1C_SQ_RSRC_IMG_RSVD_2] = "SQ_RSRC_IMG_RSVD_2",
	[V_008F1C_SQ_RSRC_IMG_RSVD_3] = "SQ_RSRC_IMG_RSVD_3",
	[V_008F1C_SQ_RSRC_IMG_RSVD_4] = "SQ_RSRC_IMG_RSVD_4",
	[V_008F1C_SQ_RSRC_IMG_RSVD_5] = "SQ_RSRC_IMG_RSVD_5",
	[V_008F1C_SQ_RSRC_IMG_RSVD_6] = "SQ_RSRC_IMG_RSVD_6",
	[V_008F1C_SQ_RSRC_IMG_RSVD_7] = "SQ_RSRC_IMG_RSVD_7",
	[V_008F1C_SQ_RSRC_IMG_1D] = "SQ_RSRC_IMG_1D",
	[V_008F1C_SQ_RSRC_IMG_2D] = "SQ_RSRC_IMG_2D",
	[V_008F1C_SQ_RSRC_IMG_3D] = "SQ_RSRC_IMG_3D",
	[V_008F1C_SQ_RSRC_IMG_CUBE] = "SQ_RSRC_IMG_CUBE",
	[V_008F1C_SQ_RSRC_IMG_1D_ARRAY] = "SQ_RSRC_IMG_1D_ARRAY",
	[V_008F1C_SQ_RSRC_IMG_2D_ARRAY] = "SQ_RSRC_IMG_2D_ARRAY",
	[V_008F1C_SQ_RSRC_IMG_2D_MSAA] = "SQ_RSRC_IMG_2D_MSAA",
	[V_008F1C_SQ_RSRC_IMG_2D_MSAA_ARRAY] = "SQ_RSRC_IMG_2D_MSAA_ARRAY",
};

static const struct si_field r_008f1c_sq_img_rsrc_word3__fields[] = {
	{"DST_SEL_X", S_008F1C_DST_SEL_X(~0u), ARRAY_SIZE(r_008f1c_sq_img_rsrc_word3__dst_sel_x__values), r_008f1c_sq_img_rsrc_word3__dst_sel_x__values},
	{"DST_SEL_Y", S_008F1C_DST_SEL_Y(~0u), ARRAY_SIZE(r_008f1c_sq_img_rsrc_word3__dst_sel_y__values), r_008f1c_sq_img_rsrc_word3__dst_sel_y__values},
	{"DST_SEL_Z", S_008F1C_DST_SEL_Z(~0u), ARRAY_SIZE(r_008f1c_sq_img_rsrc_word3__dst_sel_z__values), r_008f1c_sq_img_rsrc_word3__dst_sel_z__values},
	{"DST_SEL_W", S_008F1C_DST_SEL_W(~0u), ARRAY_SIZE(r_008f1c_sq_img_rsrc_word3__dst_sel_w__values), r_008f1c_sq_img_rsrc_word3__dst_sel_w__values},
	{"BASE_LEVEL", S_008F1C_BASE_LEVEL(~0u)},
	{"LAST_LEVEL", S_008F1C_LAST_LEVEL(~0u)},
	{"TILING_INDEX", S_008F1C_TILING_INDEX(~0u)},
	{"POW2_PAD", S_008F1C_POW2_PAD(~0u)},
	{"MTYPE", S_008F1C_MTYPE(~0u)},
	{"ATC", S_008F1C_ATC(~0u)},
	{"TYPE", S_008F1C_TYPE(~0u), ARRAY_SIZE(r_008f1c_sq_img_rsrc_word3__type__values), r_008f1c_sq_img_rsrc_word3__type__values},
};

static const struct si_field r_008f20_sq_img_rsrc_word4__fields[] = {
	{"DEPTH", S_008F20_DEPTH(~0u)},
	{"PITCH", S_008F20_PITCH(~0u)},
};

static const struct si_field r_008f24_sq_img_rsrc_word5__fields[] = {
	{"BASE_ARRAY", S_008F24_BASE_ARRAY(~0u)},
	{"LAST_ARRAY", S_008F24_LAST_ARRAY(~0u)},
};

static const struct si_field r_008f28_sq_img_rsrc_word6__fields[] = {
	{"MIN_LOD_WARN", S_008F28_MIN_LOD_WARN(~0u)},
	{"COUNTER_BANK_ID", S_008F28_COUNTER_BANK_ID(~0u)},
	{"LOD_HDW_CNT_EN", S_008F28_LOD_HDW_CNT_EN(~0u)},
	{"COMPRESSION_EN", S_008F28_COMPRESSION_EN(~0u)},
	{"ALPHA_IS_ON_MSB", S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{"COLOR_TRANSFORM", S_008F28_COLOR_TRANSFORM(~0u)},
	{"LOST_ALPHA_BITS", S_008F28_LOST_ALPHA_BITS(~0u)},
	{"LOST_COLOR_BITS", S_008F28_LOST_COLOR_BITS(~0u)},
};

static const char *r_008f30_sq_img_samp_word0__clamp_x__values[] = {
	[V_008F30_SQ_TEX_WRAP] = "SQ_TEX_WRAP",
	[V_008F30_SQ_TEX_MIRROR] = "SQ_TEX_MIRROR",
	[V_008F30_SQ_TEX_CLAMP_LAST_TEXEL] = "SQ_TEX_CLAMP_LAST_TEXEL",
	[V_008F30_SQ_TEX_MIRROR_ONCE_LAST_TEXEL] = "SQ_TEX_MIRROR_ONCE_LAST_TEXEL",
	[V_008F30_SQ_TEX_CLAMP_HALF_BORDER] = "SQ_TEX_CLAMP_HALF_BORDER",
	[V_008F30_SQ_TEX_MIRROR_ONCE_HALF_BORDER] = "SQ_TEX_MIRROR_ONCE_HALF_BORDER",
	[V_008F30_SQ_TEX_CLAMP_BORDER] = "SQ_TEX_CLAMP_BORDER",
	[V_008F30_SQ_TEX_MIRROR_ONCE_BORDER] = "SQ_TEX_MIRROR_ONCE_BORDER",
};

static const char *r_008f30_sq_img_samp_word0__clamp_y__values[] = {
	[V_008F30_SQ_TEX_WRAP] = "SQ_TEX_WRAP",
	[V_008F30_SQ_TEX_MIRROR] = "SQ_TEX_MIRROR",
	[V_008F30_SQ_TEX_CLAMP_LAST_TEXEL] = "SQ_TEX_CLAMP_LAST_TEXEL",
	[V_008F30_SQ_TEX_MIRROR_ONCE_LAST_TEXEL] = "SQ_TEX_MIRROR_ONCE_LAST_TEXEL",
	[V_008F30_SQ_TEX_CLAMP_HALF_BORDER] = "SQ_TEX_CLAMP_HALF_BORDER",
	[V_008F30_SQ_TEX_MIRROR_ONCE_HALF_BORDER] = "SQ_TEX_MIRROR_ONCE_HALF_BORDER",
	[V_008F30_SQ_TEX_CLAMP_BORDER] = "SQ_TEX_CLAMP_BORDER",
	[V_008F30_SQ_TEX_MIRROR_ONCE_BORDER] = "SQ_TEX_MIRROR_ONCE_BORDER",
};

static const char *r_008f30_sq_img_samp_word0__clamp_z__values[] = {
	[V_008F30_SQ_TEX_WRAP] = "SQ_TEX_WRAP",
	[V_008F30_SQ_TEX_MIRROR] = "SQ_TEX_MIRROR",
	[V_008F30_SQ_TEX_CLAMP_LAST_TEXEL] = "SQ_TEX_CLAMP_LAST_TEXEL",
	[V_008F30_SQ_TEX_MIRROR_ONCE_LAST_TEXEL] = "SQ_TEX_MIRROR_ONCE_LAST_TEXEL",
	[V_008F30_SQ_TEX_CLAMP_HALF_BORDER] = "SQ_TEX_CLAMP_HALF_BORDER",
	[V_008F30_SQ_TEX_MIRROR_ONCE_HALF_BORDER] = "SQ_TEX_MIRROR_ONCE_HALF_BORDER",
	[V_008F30_SQ_TEX_CLAMP_BORDER] = "SQ_TEX_CLAMP_BORDER",
	[V_008F30_SQ_TEX_MIRROR_ONCE_BORDER] = "SQ_TEX_MIRROR_ONCE_BORDER",
};

static const char *r_008f30_sq_img_samp_word0__depth_compare_func__values[] = {
	[V_008F30_SQ_TEX_DEPTH_COMPARE_NEVER] = "SQ_TEX_DEPTH_COMPARE_NEVER",
	[V_008F30_SQ_TEX_DEPTH_COMPARE_LESS] = "SQ_TEX_DEPTH_COMPARE_LESS",
	[V_008F30_SQ_TEX_DEPTH_COMPARE_EQUAL] = "SQ_TEX_DEPTH_COMPARE_EQUAL",
	[V_008F30_SQ_TEX_DEPTH_COMPARE_LESSEQUAL] = "SQ_TEX_DEPTH_COMPARE_LESSEQUAL",
	[V_008F30_SQ_TEX_DEPTH_COMPARE_GREATER] = "SQ_TEX_DEPTH_COMPARE_GREATER",
	[V_008F30_SQ_TEX_DEPTH_COMPARE_NOTEQUAL] = "SQ_TEX_DEPTH_COMPARE_NOTEQUAL",
	[V_008F30_SQ_TEX_DEPTH_COMPARE_GREATEREQUAL] = "SQ_TEX_DEPTH_COMPARE_GREATEREQUAL",
	[V_008F30_SQ_TEX_DEPTH_COMPARE_ALWAYS] = "SQ_TEX_DEPTH_COMPARE_ALWAYS",
};

static const struct si_field r_008f30_sq_img_samp_word0__fields[] = {
	{"CLAMP_X", S_008F30_CLAMP_X(~0u), ARRAY_SIZE(r_008f30_sq_img_samp_word0__clamp_x__values), r_008f30_sq_img_samp_word0__clamp_x__values},
	{"CLAMP_Y", S_008F30_CLAMP_Y(~0u), ARRAY_SIZE(r_008f30_sq_img_samp_word0__clamp_y__values), r_008f30_sq_img_samp_word0__clamp_y__values},
	{"CLAMP_Z", S_008F30_CLAMP_Z(~0u), ARRAY_SIZE(r_008f30_sq_img_samp_word0__clamp_z__values), r_008f30_sq_img_samp_word0__clamp_z__values},
	{"DEPTH_COMPARE_FUNC", S_008F30_DEPTH_COMPARE_FUNC(~0u), ARRAY_SIZE(r_008f30_sq_img_samp_word0__depth_compare_func__values), r_008f30_sq_img_samp_word0__depth_compare_func__values},
	{"FORCE_UNNORMALIZED", S_008F30_FORCE_UNNORMALIZED(~0u)},
	{"MC_COORD_TRUNC", S_008F30_MC_COORD_TRUNC(~0u)},
	{"FORCE_DEGAMMA", S_008F30_FORCE_DEGAMMA(~0u)},
	{"TRUNC_COORD", S_008F30_TRUNC_COORD(~0u)},
	{"DISABLE_CUBE_WRAP", S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{"FILTER_MODE", S_008F30_FILTER_MODE(~0u)},
	{"COMPAT_MODE", S_008F30_COMPAT_MODE(~0u)},
};

static const struct si_field r_008f34_sq_img_samp_word1__fields[] = {
	{"MIN_LOD", S_008F34_MIN_LOD(~0u)},
	{"MAX_LOD", S_008F34_MAX_LOD(~0u)},
	{"PERF_MIP", S_008F34_PERF_MIP(~0u)},
	{"PERF_Z", S_008F34_PERF_Z(~0u)},
};

static const char *r_008f38_sq_img_samp_word2__xy_mag_filter__values[] = {
	[V_008F38_SQ_TEX_XY_FILTER_POINT] = "SQ_TEX_XY_FILTER_POINT",
	[V_008F38_SQ_TEX_XY_FILTER_BILINEAR] = "SQ_TEX_XY_FILTER_BILINEAR",
};

static const char *r_008f38_sq_img_samp_word2__xy_min_filter__values[] = {
	[V_008F38_SQ_TEX_XY_FILTER_POINT] = "SQ_TEX_XY_FILTER_POINT",
	[V_008F38_SQ_TEX_XY_FILTER_BILINEAR] = "SQ_TEX_XY_FILTER_BILINEAR",
};

static const char *r_008f38_sq_img_samp_word2__z_filter__values[] = {
	[V_008F38_SQ_TEX_Z_FILTER_NONE] = "SQ_TEX_Z_FILTER_NONE",
	[V_008F38_SQ_TEX_Z_FILTER_POINT] = "SQ_TEX_Z_FILTER_POINT",
	[V_008F38_SQ_TEX_Z_FILTER_LINEAR] = "SQ_TEX_Z_FILTER_LINEAR",
};

static const char *r_008f38_sq_img_samp_word2__mip_filter__values[] = {
	[V_008F38_SQ_TEX_Z_FILTER_NONE] = "SQ_TEX_Z_FILTER_NONE",
	[V_008F38_SQ_TEX_Z_FILTER_POINT] = "SQ_TEX_Z_FILTER_POINT",
	[V_008F38_SQ_TEX_Z_FILTER_LINEAR] = "SQ_TEX_Z_FILTER_LINEAR",
};

static const struct si_field r_008f38_sq_img_samp_word2__fields[] = {
	{"LOD_BIAS", S_008F38_LOD_BIAS(~0u)},
	{"LOD_BIAS_SEC", S_008F38_LOD_BIAS_SEC(~0u)},
	{"XY_MAG_FILTER", S_008F38_XY_MAG_FILTER(~0u), ARRAY_SIZE(r_008f38_sq_img_samp_word2__xy_mag_filter__values), r_008f38_sq_img_samp_word2__xy_mag_filter__values},
	{"XY_MIN_FILTER", S_008F38_XY_MIN_FILTER(~0u), ARRAY_SIZE(r_008f38_sq_img_samp_word2__xy_min_filter__values), r_008f38_sq_img_samp_word2__xy_min_filter__values},
	{"Z_FILTER", S_008F38_Z_FILTER(~0u), ARRAY_SIZE(r_008f38_sq_img_samp_word2__z_filter__values), r_008f38_sq_img_samp_word2__z_filter__values},
	{"MIP_FILTER", S_008F38_MIP_FILTER(~0u), ARRAY_SIZE(r_008f38_sq_img_samp_word2__mip_filter__values), r_008f38_sq_img_samp_word2__mip_filter__values},
	{"MIP_POINT_PRECLAMP", S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{"DISABLE_LSB_CEIL", S_008F38_DISABLE_LSB_CEIL(~0u)},
	{"FILTER_PREC_FIX", S_008F38_FILTER_PREC_FIX(~0u)},
};

static const char *r_008f3c_sq_img_samp_word3__border_color_type__values[] = {
	[V_008F3C_SQ_TEX_BORDER_COLOR_TRANS_BLACK] = "SQ_TEX_BORDER_COLOR_TRANS_BLACK",
	[V_008F3C_SQ_TEX_BORDER_COLOR_OPAQUE_BLACK] = "SQ_TEX_BORDER_COLOR_OPAQUE_BLACK",
	[V_008F3C_SQ_TEX_BORDER_COLOR_OPAQUE_WHITE] = "SQ_TEX_BORDER_COLOR_OPAQUE_WHITE",
	[V_008F3C_SQ_TEX_BORDER_COLOR_REGISTER] = "SQ_TEX_BORDER_COLOR_REGISTER",
};

static const struct si_field r_008f3c_sq_img_samp_word3__fields[] = {
	{"BORDER_COLOR_PTR", S_008F3C_BORDER_COLOR_PTR(~0u)},
	{"BORDER_COLOR_TYPE", S_008F3C_BORDER_COLOR_TYPE(~0u), ARRAY_SIZE(r_008f3c_sq_img_samp_word3__border_color_type__values), r_008f3c_sq_img_samp_word3__border_color_type__values},
};

static const struct si_field r_0090dc_spi_dyn_gpr_lock_en__fields[] = {
	{"VS_LOW_THRESHOLD", S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{"GS_LOW_THRESHOLD", S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{"ES_LOW_THRESHOLD", S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{"HS_LOW_THRESHOLD", S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{"LS_LOW_THRESHOLD", S_0090DC_LS_LOW_THRESHOLD(~0u)},
};

static const struct si_field r_0090e0_spi_static_thread_mgmt_1__fields[] = {
	{"PS_CU_EN", S_0090E0_PS_CU_EN(~0u)},
	{"VS_CU_EN", S_0090E0_VS_CU_EN(~0u)},
};

static const struct si_field r_0090e4_spi_static_thread_mgmt_2__fields[] = {
	{"GS_CU_EN", S_0090E4_GS_CU_EN(~0u)},
	{"ES_CU_EN", S_0090E4_ES_CU_EN(~0u)},
};

static const struct si_field r_0090e8_spi_static_thread_mgmt_3__fields[] = {
	{"LSHS_CU_EN", S_0090E8_LSHS_CU_EN(~0u)},
};

static const struct si_field r_0090ec_spi_ps_max_wave_id__fields[] = {
	{"MAX_WAVE_ID", S_0090EC_MAX_WAVE_ID(~0u)},
};

static const struct si_field r_0090e8_spi_ps_max_wave_id__fields[] = {
	{"MAX_WAVE_ID", S_0090E8_MAX_WAVE_ID(~0u)},
};

static const char *r_0090f0_spi_arb_priority__ring_order_ts0__values[] = {
	[V_0090F0_X_R0] = "X_R0",
};

static const struct si_field r_0090f0_spi_arb_priority__fields[] = {
	{"RING_ORDER_TS0", S_0090F0_RING_ORDER_TS0(~0u), ARRAY_SIZE(r_0090f0_spi_arb_priority__ring_order_ts0__values), r_0090f0_spi_arb_priority__ring_order_ts0__values},
	{"RING_ORDER_TS1", S_0090F0_RING_ORDER_TS1(~0u)},
	{"RING_ORDER_TS2", S_0090F0_RING_ORDER_TS2(~0u)},
};

static const struct si_field r_00c700_spi_arb_priority__fields[] = {
	{"PIPE_ORDER_TS0", S_00C700_PIPE_ORDER_TS0(~0u)},
	{"PIPE_ORDER_TS1", S_00C700_PIPE_ORDER_TS1(~0u)},
	{"PIPE_ORDER_TS2", S_00C700_PIPE_ORDER_TS2(~0u)},
	{"PIPE_ORDER_TS3", S_00C700_PIPE_ORDER_TS3(~0u)},
	{"TS0_DUR_MULT", S_00C700_TS0_DUR_MULT(~0u)},
	{"TS1_DUR_MULT", S_00C700_TS1_DUR_MULT(~0u)},
	{"TS2_DUR_MULT", S_00C700_TS2_DUR_MULT(~0u)},
	{"TS3_DUR_MULT", S_00C700_TS3_DUR_MULT(~0u)},
};

static const struct si_field r_0090f4_spi_arb_cycles_0__fields[] = {
	{"TS0_DURATION", S_0090F4_TS0_DURATION(~0u)},
	{"TS1_DURATION", S_0090F4_TS1_DURATION(~0u)},
};

static const struct si_field r_0090f8_spi_arb_cycles_1__fields[] = {
	{"TS2_DURATION", S_0090F8_TS2_DURATION(~0u)},
};

static const struct si_field r_008f40_sq_flat_scratch_word0__fields[] = {
	{"SIZE", S_008F40_SIZE(~0u)},
};

static const struct si_field r_008f44_sq_flat_scratch_word1__fields[] = {
	{"OFFSET", S_008F44_OFFSET(~0u)},
};

static const struct si_field r_030ffc_db_zpass_count_hi__fields[] = {
	{"COUNT_HI", S_030FFC_COUNT_HI(~0u)},
};

static const struct si_field r_009100_spi_config_cntl__fields[] = {
	{"GPR_WRITE_PRIORITY", S_009100_GPR_WRITE_PRIORITY(~0u)},
	{"EXP_PRIORITY_ORDER", S_009100_EXP_PRIORITY_ORDER(~0u)},
	{"ENABLE_SQG_TOP_EVENTS", S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{"ENABLE_SQG_BOP_EVENTS", S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{"RSRC_MGMT_RESET", S_009100_RSRC_MGMT_RESET(~0u)},
};

static const char *r_00913c_spi_config_cntl_1__vtx_done_delay__values[] = {
	[V_00913C_X_DELAY_14_CLKS] = "X_DELAY_14_CLKS",
	[V_00913C_X_DELAY_16_CLKS] = "X_DELAY_16_CLKS",
	[V_00913C_X_DELAY_18_CLKS] = "X_DELAY_18_CLKS",
	[V_00913C_X_DELAY_20_CLKS] = "X_DELAY_20_CLKS",
	[V_00913C_X_DELAY_22_CLKS] = "X_DELAY_22_CLKS",
	[V_00913C_X_DELAY_24_CLKS] = "X_DELAY_24_CLKS",
	[V_00913C_X_DELAY_26_CLKS] = "X_DELAY_26_CLKS",
	[V_00913C_X_DELAY_28_CLKS] = "X_DELAY_28_CLKS",
	[V_00913C_X_DELAY_30_CLKS] = "X_DELAY_30_CLKS",
	[V_00913C_X_DELAY_32_CLKS] = "X_DELAY_32_CLKS",
	[V_00913C_X_DELAY_34_CLKS] = "X_DELAY_34_CLKS",
	[V_00913C_X_DELAY_4_CLKS] = "X_DELAY_4_CLKS",
	[V_00913C_X_DELAY_6_CLKS] = "X_DELAY_6_CLKS",
	[V_00913C_X_DELAY_8_CLKS] = "X_DELAY_8_CLKS",
	[V_00913C_X_DELAY_10_CLKS] = "X_DELAY_10_CLKS",
	[V_00913C_X_DELAY_12_CLKS] = "X_DELAY_12_CLKS",
};

static const struct si_field r_00913c_spi_config_cntl_1__fields[] = {
	{"VTX_DONE_DELAY", S_00913C_VTX_DONE_DELAY(~0u), ARRAY_SIZE(r_00913c_spi_config_cntl_1__vtx_done_delay__values), r_00913c_spi_config_cntl_1__vtx_done_delay__values},
	{"INTERP_ONE_PRIM_PER_ROW", S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{"PC_LIMIT_ENABLE", S_00913C_PC_LIMIT_ENABLE(~0u)},
	{"PC_LIMIT_STRICT", S_00913C_PC_LIMIT_STRICT(~0u)},
	{"PC_LIMIT_SIZE", S_00913C_PC_LIMIT_SIZE(~0u)},
};

static const struct si_field r_00936c_spi_resource_reserve_cu_ab_0__fields[] = {
	{"TYPE_A", S_00936C_TYPE_A(~0u)},
	{"VGPR_A", S_00936C_VGPR_A(~0u)},
	{"SGPR_A", S_00936C_SGPR_A(~0u)},
	{"LDS_A", S_00936C_LDS_A(~0u)},
	{"WAVES_A", S_00936C_WAVES_A(~0u)},
	{"EN_A", S_00936C_EN_A(~0u)},
	{"TYPE_B", S_00936C_TYPE_B(~0u)},
	{"VGPR_B", S_00936C_VGPR_B(~0u)},
	{"SGPR_B", S_00936C_SGPR_B(~0u)},
	{"LDS_B", S_00936C_LDS_B(~0u)},
	{"WAVES_B", S_00936C_WAVES_B(~0u)},
	{"EN_B", S_00936C_EN_B(~0u)},
};

static const struct si_field r_009858_db_subtile_control__fields[] = {
	{"MSAA1_X", S_009858_MSAA1_X(~0u)},
	{"MSAA1_Y", S_009858_MSAA1_Y(~0u)},
	{"MSAA2_X", S_009858_MSAA2_X(~0u)},
	{"MSAA2_Y", S_009858_MSAA2_Y(~0u)},
	{"MSAA4_X", S_009858_MSAA4_X(~0u)},
	{"MSAA4_Y", S_009858_MSAA4_Y(~0u)},
	{"MSAA8_X", S_009858_MSAA8_X(~0u)},
	{"MSAA8_Y", S_009858_MSAA8_Y(~0u)},
	{"MSAA16_X", S_009858_MSAA16_X(~0u)},
	{"MSAA16_Y", S_009858_MSAA16_Y(~0u)},
};

static const struct si_field r_0098f8_gb_addr_config__fields[] = {
	{"NUM_PIPES", S_0098F8_NUM_PIPES(~0u)},
	{"PIPE_INTERLEAVE_SIZE", S_0098F8_PIPE_INTERLEAVE_SIZE(~0u)},
	{"BANK_INTERLEAVE_SIZE", S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{"NUM_SHADER_ENGINES", S_0098F8_NUM_SHADER_ENGINES(~0u)},
	{"SHADER_ENGINE_TILE_SIZE", S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{"NUM_GPUS", S_0098F8_NUM_GPUS(~0u)},
	{"MULTI_GPU_TILE_SIZE", S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{"ROW_SIZE", S_0098F8_ROW_SIZE(~0u)},
	{"NUM_LOWER_PIPES", S_0098F8_NUM_LOWER_PIPES(~0u)},
};

static const char *r_009910_gb_tile_mode0__micro_tile_mode__values[] = {
	[V_009910_ADDR_SURF_DISPLAY_MICRO_TILING] = "ADDR_SURF_DISPLAY_MICRO_TILING",
	[V_009910_ADDR_SURF_THIN_MICRO_TILING] = "ADDR_SURF_THIN_MICRO_TILING",
	[V_009910_ADDR_SURF_DEPTH_MICRO_TILING] = "ADDR_SURF_DEPTH_MICRO_TILING",
	[V_009910_ADDR_SURF_THICK_MICRO_TILING] = "ADDR_SURF_THICK_MICRO_TILING",
};

static const char *r_009910_gb_tile_mode0__array_mode__values[] = {
	[V_009910_ARRAY_LINEAR_GENERAL] = "ARRAY_LINEAR_GENERAL",
	[V_009910_ARRAY_LINEAR_ALIGNED] = "ARRAY_LINEAR_ALIGNED",
	[V_009910_ARRAY_1D_TILED_THIN1] = "ARRAY_1D_TILED_THIN1",
	[V_009910_ARRAY_1D_TILED_THICK] = "ARRAY_1D_TILED_THICK",
	[V_009910_ARRAY_2D_TILED_THIN1] = "ARRAY_2D_TILED_THIN1",
	[V_009910_ARRAY_2D_TILED_THICK] = "ARRAY_2D_TILED_THICK",
	[V_009910_ARRAY_2D_TILED_XTHICK] = "ARRAY_2D_TILED_XTHICK",
	[V_009910_ARRAY_3D_TILED_THIN1] = "ARRAY_3D_TILED_THIN1",
	[V_009910_ARRAY_3D_TILED_THICK] = "ARRAY_3D_TILED_THICK",
	[V_009910_ARRAY_3D_TILED_XTHICK] = "ARRAY_3D_TILED_XTHICK",
	[V_009910_ARRAY_POWER_SAVE] = "ARRAY_POWER_SAVE",
};

static const char *r_009910_gb_tile_mode0__pipe_config__values[] = {
	[V_009910_ADDR_SURF_P2] = "ADDR_SURF_P2",
	[V_009910_ADDR_SURF_P2_RESERVED0] = "ADDR_SURF_P2_RESERVED0",
	[V_009910_ADDR_SURF_P2_RESERVED1] = "ADDR_SURF_P2_RESERVED1",
	[V_009910_ADDR_SURF_P2_RESERVED2] = "ADDR_SURF_P2_RESERVED2",
	[V_009910_X_ADDR_SURF_P4_8X16] = "X_ADDR_SURF_P4_8X16",
	[V_009910_X_ADDR_SURF_P4_16X16] = "X_ADDR_SURF_P4_16X16",
	[V_009910_X_ADDR_SURF_P4_16X32] = "X_ADDR_SURF_P4_16X32",
	[V_009910_X_ADDR_SURF_P4_32X32] = "X_ADDR_SURF_P4_32X32",
	[V_009910_X_ADDR_SURF_P8_16X16_8X16] = "X_ADDR_SURF_P8_16X16_8X16",
	[V_009910_X_ADDR_SURF_P8_16X32_8X16] = "X_ADDR_SURF_P8_16X32_8X16",
	[V_009910_X_ADDR_SURF_P8_32X32_8X16] = "X_ADDR_SURF_P8_32X32_8X16",
	[V_009910_X_ADDR_SURF_P8_16X32_16X16] = "X_ADDR_SURF_P8_16X32_16X16",
	[V_009910_X_ADDR_SURF_P8_32X32_16X16] = "X_ADDR_SURF_P8_32X32_16X16",
	[V_009910_X_ADDR_SURF_P8_32X32_16X32] = "X_ADDR_SURF_P8_32X32_16X32",
	[V_009910_X_ADDR_SURF_P8_32X64_32X32] = "X_ADDR_SURF_P8_32X64_32X32",
};

static const char *r_009910_gb_tile_mode0__tile_split__values[] = {
	[V_009910_ADDR_SURF_TILE_SPLIT_64B] = "ADDR_SURF_TILE_SPLIT_64B",
	[V_009910_ADDR_SURF_TILE_SPLIT_128B] = "ADDR_SURF_TILE_SPLIT_128B",
	[V_009910_ADDR_SURF_TILE_SPLIT_256B] = "ADDR_SURF_TILE_SPLIT_256B",
	[V_009910_ADDR_SURF_TILE_SPLIT_512B] = "ADDR_SURF_TILE_SPLIT_512B",
	[V_009910_ADDR_SURF_TILE_SPLIT_1KB] = "ADDR_SURF_TILE_SPLIT_1KB",
	[V_009910_ADDR_SURF_TILE_SPLIT_2KB] = "ADDR_SURF_TILE_SPLIT_2KB",
	[V_009910_ADDR_SURF_TILE_SPLIT_4KB] = "ADDR_SURF_TILE_SPLIT_4KB",
};

static const char *r_009910_gb_tile_mode0__bank_width__values[] = {
	[V_009910_ADDR_SURF_BANK_WIDTH_1] = "ADDR_SURF_BANK_WIDTH_1",
	[V_009910_ADDR_SURF_BANK_WIDTH_2] = "ADDR_SURF_BANK_WIDTH_2",
	[V_009910_ADDR_SURF_BANK_WIDTH_4] = "ADDR_SURF_BANK_WIDTH_4",
	[V_009910_ADDR_SURF_BANK_WIDTH_8] = "ADDR_SURF_BANK_WIDTH_8",
};

static const char *r_009910_gb_tile_mode0__bank_height__values[] = {
	[V_009910_ADDR_SURF_BANK_HEIGHT_1] = "ADDR_SURF_BANK_HEIGHT_1",
	[V_009910_ADDR_SURF_BANK_HEIGHT_2] = "ADDR_SURF_BANK_HEIGHT_2",
	[V_009910_ADDR_SURF_BANK_HEIGHT_4] = "ADDR_SURF_BANK_HEIGHT_4",
	[V_009910_ADDR_SURF_BANK_HEIGHT_8] = "ADDR_SURF_BANK_HEIGHT_8",
};

static const char *r_009910_gb_tile_mode0__macro_tile_aspect__values[] = {
	[V_009910_ADDR_SURF_MACRO_ASPECT_1] = "ADDR_SURF_MACRO_ASPECT_1",
	[V_009910_ADDR_SURF_MACRO_ASPECT_2] = "ADDR_SURF_MACRO_ASPECT_2",
	[V_009910_ADDR_SURF_MACRO_ASPECT_4] = "ADDR_SURF_MACRO_ASPECT_4",
	[V_009910_ADDR_SURF_MACRO_ASPECT_8] = "ADDR_SURF_MACRO_ASPECT_8",
};

static const char *r_009910_gb_tile_mode0__num_banks__values[] = {
	[V_009910_ADDR_SURF_2_BANK] = "ADDR_SURF_2_BANK",
	[V_009910_ADDR_SURF_4_BANK] = "ADDR_SURF_4_BANK",
	[V_009910_ADDR_SURF_8_BANK] = "ADDR_SURF_8_BANK",
	[V_009910_ADDR_SURF_16_BANK] = "ADDR_SURF_16_BANK",
};

static const char *r_009910_gb_tile_mode0__micro_tile_mode_new__values[] = {
	[V_009910_ADDR_SURF_DISPLAY_MICRO_TILING] = "ADDR_SURF_DISPLAY_MICRO_TILING",
	[V_009910_ADDR_SURF_THIN_MICRO_TILING] = "ADDR_SURF_THIN_MICRO_TILING",
	[V_009910_ADDR_SURF_DEPTH_MICRO_TILING] = "ADDR_SURF_DEPTH_MICRO_TILING",
	[V_009910_ADDR_SURF_ROTATED_MICRO_TILING] = "ADDR_SURF_ROTATED_MICRO_TILING",
};

static const struct si_field r_009910_gb_tile_mode0__fields[] = {
	{"MICRO_TILE_MODE", S_009910_MICRO_TILE_MODE(~0u), ARRAY_SIZE(r_009910_gb_tile_mode0__micro_tile_mode__values), r_009910_gb_tile_mode0__micro_tile_mode__values},
	{"ARRAY_MODE", S_009910_ARRAY_MODE(~0u), ARRAY_SIZE(r_009910_gb_tile_mode0__array_mode__values), r_009910_gb_tile_mode0__array_mode__values},
	{"PIPE_CONFIG", S_009910_PIPE_CONFIG(~0u), ARRAY_SIZE(r_009910_gb_tile_mode0__pipe_config__values), r_009910_gb_tile_mode0__pipe_config__values},
	{"TILE_SPLIT", S_009910_TILE_SPLIT(~0u), ARRAY_SIZE(r_009910_gb_tile_mode0__tile_split__values), r_009910_gb_tile_mode0__tile_split__values},
	{"BANK_WIDTH", S_009910_BANK_WIDTH(~0u), ARRAY_SIZE(r_009910_gb_tile_mode0__bank_width__values), r_009910_gb_tile_mode0__bank_width__values},
	{"BANK_HEIGHT", S_009910_BANK_HEIGHT(~0u), ARRAY_SIZE(r_009910_gb_tile_mode0__bank_height__values), r_009910_gb_tile_mode0__bank_height__values},
	{"MACRO_TILE_ASPECT", S_009910_MACRO_TILE_ASPECT(~0u), ARRAY_SIZE(r_009910_gb_tile_mode0__macro_tile_aspect__values), r_009910_gb_tile_mode0__macro_tile_aspect__values},
	{"NUM_BANKS", S_009910_NUM_BANKS(~0u), ARRAY_SIZE(r_009910_gb_tile_mode0__num_banks__values), r_009910_gb_tile_mode0__num_banks__values},
	{"MICRO_TILE_MODE_NEW", S_009910_MICRO_TILE_MODE_NEW(~0u), ARRAY_SIZE(r_009910_gb_tile_mode0__micro_tile_mode_new__values), r_009910_gb_tile_mode0__micro_tile_mode_new__values},
	{"SAMPLE_SPLIT", S_009910_SAMPLE_SPLIT(~0u)},
};

static const struct si_field r_009990_gb_macrotile_mode0__fields[] = {
	{"BANK_WIDTH", S_009990_BANK_WIDTH(~0u)},
	{"BANK_HEIGHT", S_009990_BANK_HEIGHT(~0u)},
	{"MACRO_TILE_ASPECT", S_009990_MACRO_TILE_ASPECT(~0u)},
	{"NUM_BANKS", S_009990_NUM_BANKS(~0u)},
};

static const struct si_field r_00b004_spi_shader_tba_hi_ps__fields[] = {
	{"MEM_BASE", S_00B004_MEM_BASE(~0u)},
};

static const struct si_field r_00b00c_spi_shader_tma_hi_ps__fields[] = {
	{"MEM_BASE", S_00B00C_MEM_BASE(~0u)},
};

static const struct si_field r_00b01c_spi_shader_pgm_rsrc3_ps__fields[] = {
	{"CU_EN", S_00B01C_CU_EN(~0u)},
	{"WAVE_LIMIT", S_00B01C_WAVE_LIMIT(~0u)},
	{"LOCK_LOW_THRESHOLD", S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
};

static const struct si_field r_00b024_spi_shader_pgm_hi_ps__fields[] = {
	{"MEM_BASE", S_00B024_MEM_BASE(~0u)},
};

static const struct si_field r_00b028_spi_shader_pgm_rsrc1_ps__fields[] = {
	{"VGPRS", S_00B028_VGPRS(~0u)},
	{"SGPRS", S_00B028_SGPRS(~0u)},
	{"PRIORITY", S_00B028_PRIORITY(~0u)},
	{"FLOAT_MODE", S_00B028_FLOAT_MODE(~0u)},
	{"PRIV", S_00B028_PRIV(~0u)},
	{"DX10_CLAMP", S_00B028_DX10_CLAMP(~0u)},
	{"DEBUG_MODE", S_00B028_DEBUG_MODE(~0u)},
	{"IEEE_MODE", S_00B028_IEEE_MODE(~0u)},
	{"CU_GROUP_DISABLE", S_00B028_CU_GROUP_DISABLE(~0u)},
	{"CACHE_CTL", S_00B028_CACHE_CTL(~0u)},
	{"CDBG_USER", S_00B028_CDBG_USER(~0u)},
};

static const struct si_field r_00b02c_spi_shader_pgm_rsrc2_ps__fields[] = {
	{"SCRATCH_EN", S_00B02C_SCRATCH_EN(~0u)},
	{"USER_SGPR", S_00B02C_USER_SGPR(~0u)},
	{"TRAP_PRESENT", S_00B02C_TRAP_PRESENT(~0u)},
	{"WAVE_CNT_EN", S_00B02C_WAVE_CNT_EN(~0u)},
	{"EXTRA_LDS_SIZE", S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{"EXCP_EN", S_00B02C_EXCP_EN(~0u)},
	{"EXCP_EN_CIK", S_00B02C_EXCP_EN_CIK(~0u)},
};

static const struct si_field r_00b104_spi_shader_tba_hi_vs__fields[] = {
	{"MEM_BASE", S_00B104_MEM_BASE(~0u)},
};

static const struct si_field r_00b10c_spi_shader_tma_hi_vs__fields[] = {
	{"MEM_BASE", S_00B10C_MEM_BASE(~0u)},
};

static const struct si_field r_00b118_spi_shader_pgm_rsrc3_vs__fields[] = {
	{"CU_EN", S_00B118_CU_EN(~0u)},
	{"WAVE_LIMIT", S_00B118_WAVE_LIMIT(~0u)},
	{"LOCK_LOW_THRESHOLD", S_00B118_LOCK_LOW_THRESHOLD(~0u)},
};

static const struct si_field r_00b11c_spi_shader_late_alloc_vs__fields[] = {
	{"LIMIT", S_00B11C_LIMIT(~0u)},
};

static const struct si_field r_00b124_spi_shader_pgm_hi_vs__fields[] = {
	{"MEM_BASE", S_00B124_MEM_BASE(~0u)},
};

static const struct si_field r_00b128_spi_shader_pgm_rsrc1_vs__fields[] = {
	{"VGPRS", S_00B128_VGPRS(~0u)},
	{"SGPRS", S_00B128_SGPRS(~0u)},
	{"PRIORITY", S_00B128_PRIORITY(~0u)},
	{"FLOAT_MODE", S_00B128_FLOAT_MODE(~0u)},
	{"PRIV", S_00B128_PRIV(~0u)},
	{"DX10_CLAMP", S_00B128_DX10_CLAMP(~0u)},
	{"DEBUG_MODE", S_00B128_DEBUG_MODE(~0u)},
	{"IEEE_MODE", S_00B128_IEEE_MODE(~0u)},
	{"VGPR_COMP_CNT", S_00B128_VGPR_COMP_CNT(~0u)},
	{"CU_GROUP_ENABLE", S_00B128_CU_GROUP_ENABLE(~0u)},
	{"CACHE_CTL", S_00B128_CACHE_CTL(~0u)},
	{"CDBG_USER", S_00B128_CDBG_USER(~0u)},
};

static const struct si_field r_00b12c_spi_shader_pgm_rsrc2_vs__fields[] = {
	{"SCRATCH_EN", S_00B12C_SCRATCH_EN(~0u)},
	{"USER_SGPR", S_00B12C_USER_SGPR(~0u)},
	{"TRAP_PRESENT", S_00B12C_TRAP_PRESENT(~0u)},
	{"OC_LDS_EN", S_00B12C_OC_LDS_EN(~0u)},
	{"SO_BASE0_EN", S_00B12C_SO_BASE0_EN(~0u)},
	{"SO_BASE1_EN", S_00B12C_SO_BASE1_EN(~0u)},
	{"SO_BASE2_EN", S_00B12C_SO_BASE2_EN(~0u)},
	{"SO_BASE3_EN", S_00B12C_SO_BASE3_EN(~0u)},
	{"SO_EN", S_00B12C_SO_EN(~0u)},
	{"EXCP_EN", S_00B12C_EXCP_EN(~0u)},
	{"EXCP_EN_CIK", S_00B12C_EXCP_EN_CIK(~0u)},
	{"DISPATCH_DRAW_EN", S_00B12C_DISPATCH_DRAW_EN(~0u)},
};

static const struct si_field r_00b204_spi_shader_tba_hi_gs__fields[] = {
	{"MEM_BASE", S_00B204_MEM_BASE(~0u)},
};

static const struct si_field r_00b20c_spi_shader_tma_hi_gs__fields[] = {
	{"MEM_BASE", S_00B20C_MEM_BASE(~0u)},
};

static const struct si_field r_00b21c_spi_shader_pgm_rsrc3_gs__fields[] = {
	{"CU_EN", S_00B21C_CU_EN(~0u)},
	{"WAVE_LIMIT", S_00B21C_WAVE_LIMIT(~0u)},
	{"LOCK_LOW_THRESHOLD", S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{"GROUP_FIFO_DEPTH", S_00B21C_GROUP_FIFO_DEPTH(~0u)},
};

static const struct si_field r_00b224_spi_shader_pgm_hi_gs__fields[] = {
	{"MEM_BASE", S_00B224_MEM_BASE(~0u)},
};

static const struct si_field r_00b228_spi_shader_pgm_rsrc1_gs__fields[] = {
	{"VGPRS", S_00B228_VGPRS(~0u)},
	{"SGPRS", S_00B228_SGPRS(~0u)},
	{"PRIORITY", S_00B228_PRIORITY(~0u)},
	{"FLOAT_MODE", S_00B228_FLOAT_MODE(~0u)},
	{"PRIV", S_00B228_PRIV(~0u)},
	{"DX10_CLAMP", S_00B228_DX10_CLAMP(~0u)},
	{"DEBUG_MODE", S_00B228_DEBUG_MODE(~0u)},
	{"IEEE_MODE", S_00B228_IEEE_MODE(~0u)},
	{"CU_GROUP_ENABLE", S_00B228_CU_GROUP_ENABLE(~0u)},
	{"CACHE_CTL", S_00B228_CACHE_CTL(~0u)},
	{"CDBG_USER", S_00B228_CDBG_USER(~0u)},
};

static const struct si_field r_00b22c_spi_shader_pgm_rsrc2_gs__fields[] = {
	{"SCRATCH_EN", S_00B22C_SCRATCH_EN(~0u)},
	{"USER_SGPR", S_00B22C_USER_SGPR(~0u)},
	{"TRAP_PRESENT", S_00B22C_TRAP_PRESENT(~0u)},
	{"EXCP_EN", S_00B22C_EXCP_EN(~0u)},
	{"EXCP_EN_CIK", S_00B22C_EXCP_EN_CIK(~0u)},
};

static const struct si_field r_00b304_spi_shader_tba_hi_es__fields[] = {
	{"MEM_BASE", S_00B304_MEM_BASE(~0u)},
};

static const struct si_field r_00b30c_spi_shader_tma_hi_es__fields[] = {
	{"MEM_BASE", S_00B30C_MEM_BASE(~0u)},
};

static const struct si_field r_00b31c_spi_shader_pgm_rsrc3_es__fields[] = {
	{"CU_EN", S_00B31C_CU_EN(~0u)},
	{"WAVE_LIMIT", S_00B31C_WAVE_LIMIT(~0u)},
	{"LOCK_LOW_THRESHOLD", S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{"GROUP_FIFO_DEPTH", S_00B31C_GROUP_FIFO_DEPTH(~0u)},
};

static const struct si_field r_00b324_spi_shader_pgm_hi_es__fields[] = {
	{"MEM_BASE", S_00B324_MEM_BASE(~0u)},
};

static const struct si_field r_00b328_spi_shader_pgm_rsrc1_es__fields[] = {
	{"VGPRS", S_00B328_VGPRS(~0u)},
	{"SGPRS", S_00B328_SGPRS(~0u)},
	{"PRIORITY", S_00B328_PRIORITY(~0u)},
	{"FLOAT_MODE", S_00B328_FLOAT_MODE(~0u)},
	{"PRIV", S_00B328_PRIV(~0u)},
	{"DX10_CLAMP", S_00B328_DX10_CLAMP(~0u)},
	{"DEBUG_MODE", S_00B328_DEBUG_MODE(~0u)},
	{"IEEE_MODE", S_00B328_IEEE_MODE(~0u)},
	{"VGPR_COMP_CNT", S_00B328_VGPR_COMP_CNT(~0u)},
	{"CU_GROUP_ENABLE", S_00B328_CU_GROUP_ENABLE(~0u)},
	{"CACHE_CTL", S_00B328_CACHE_CTL(~0u)},
	{"CDBG_USER", S_00B328_CDBG_USER(~0u)},
};

static const struct si_field r_00b32c_spi_shader_pgm_rsrc2_es__fields[] = {
	{"SCRATCH_EN", S_00B32C_SCRATCH_EN(~0u)},
	{"USER_SGPR", S_00B32C_USER_SGPR(~0u)},
	{"TRAP_PRESENT", S_00B32C_TRAP_PRESENT(~0u)},
	{"OC_LDS_EN", S_00B32C_OC_LDS_EN(~0u)},
	{"EXCP_EN", S_00B32C_EXCP_EN(~0u)},
	{"LDS_SIZE", S_00B32C_LDS_SIZE(~0u)},
};

static const struct si_field r_00b404_spi_shader_tba_hi_hs__fields[] = {
	{"MEM_BASE", S_00B404_MEM_BASE(~0u)},
};

static const struct si_field r_00b40c_spi_shader_tma_hi_hs__fields[] = {
	{"MEM_BASE", S_00B40C_MEM_BASE(~0u)},
};

static const struct si_field r_00b41c_spi_shader_pgm_rsrc3_hs__fields[] = {
	{"WAVE_LIMIT", S_00B41C_WAVE_LIMIT(~0u)},
	{"LOCK_LOW_THRESHOLD", S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{"GROUP_FIFO_DEPTH", S_00B41C_GROUP_FIFO_DEPTH(~0u)},
};

static const struct si_field r_00b424_spi_shader_pgm_hi_hs__fields[] = {
	{"MEM_BASE", S_00B424_MEM_BASE(~0u)},
};

static const struct si_field r_00b428_spi_shader_pgm_rsrc1_hs__fields[] = {
	{"VGPRS", S_00B428_VGPRS(~0u)},
	{"SGPRS", S_00B428_SGPRS(~0u)},
	{"PRIORITY", S_00B428_PRIORITY(~0u)},
	{"FLOAT_MODE", S_00B428_FLOAT_MODE(~0u)},
	{"PRIV", S_00B428_PRIV(~0u)},
	{"DX10_CLAMP", S_00B428_DX10_CLAMP(~0u)},
	{"DEBUG_MODE", S_00B428_DEBUG_MODE(~0u)},
	{"IEEE_MODE", S_00B428_IEEE_MODE(~0u)},
	{"CACHE_CTL", S_00B428_CACHE_CTL(~0u)},
	{"CDBG_USER", S_00B428_CDBG_USER(~0u)},
};

static const struct si_field r_00b42c_spi_shader_pgm_rsrc2_hs__fields[] = {
	{"SCRATCH_EN", S_00B42C_SCRATCH_EN(~0u)},
	{"USER_SGPR", S_00B42C_USER_SGPR(~0u)},
	{"TRAP_PRESENT", S_00B42C_TRAP_PRESENT(~0u)},
	{"OC_LDS_EN", S_00B42C_OC_LDS_EN(~0u)},
	{"TG_SIZE_EN", S_00B42C_TG_SIZE_EN(~0u)},
	{"EXCP_EN", S_00B42C_EXCP_EN(~0u)},
};

static const struct si_field r_00b504_spi_shader_tba_hi_ls__fields[] = {
	{"MEM_BASE", S_00B504_MEM_BASE(~0u)},
};

static const struct si_field r_00b50c_spi_shader_tma_hi_ls__fields[] = {
	{"MEM_BASE", S_00B50C_MEM_BASE(~0u)},
};

static const struct si_field r_00b51c_spi_shader_pgm_rsrc3_ls__fields[] = {
	{"CU_EN", S_00B51C_CU_EN(~0u)},
	{"WAVE_LIMIT", S_00B51C_WAVE_LIMIT(~0u)},
	{"LOCK_LOW_THRESHOLD", S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{"GROUP_FIFO_DEPTH", S_00B51C_GROUP_FIFO_DEPTH(~0u)},
};

static const struct si_field r_00b524_spi_shader_pgm_hi_ls__fields[] = {
	{"MEM_BASE", S_00B524_MEM_BASE(~0u)},
};

static const struct si_field r_00b528_spi_shader_pgm_rsrc1_ls__fields[] = {
	{"VGPRS", S_00B528_VGPRS(~0u)},
	{"SGPRS", S_00B528_SGPRS(~0u)},
	{"PRIORITY", S_00B528_PRIORITY(~0u)},
	{"FLOAT_MODE", S_00B528_FLOAT_MODE(~0u)},
	{"PRIV", S_00B528_PRIV(~0u)},
	{"DX10_CLAMP", S_00B528_DX10_CLAMP(~0u)},
	{"DEBUG_MODE", S_00B528_DEBUG_MODE(~0u)},
	{"IEEE_MODE", S_00B528_IEEE_MODE(~0u)},
	{"VGPR_COMP_CNT", S_00B528_VGPR_COMP_CNT(~0u)},
	{"CACHE_CTL", S_00B528_CACHE_CTL(~0u)},
	{"CDBG_USER", S_00B528_CDBG_USER(~0u)},
};

static const struct si_field r_00b52c_spi_shader_pgm_rsrc2_ls__fields[] = {
	{"SCRATCH_EN", S_00B52C_SCRATCH_EN(~0u)},
	{"USER_SGPR", S_00B52C_USER_SGPR(~0u)},
	{"TRAP_PRESENT", S_00B52C_TRAP_PRESENT(~0u)},
	{"LDS_SIZE", S_00B52C_LDS_SIZE(~0u)},
	{"EXCP_EN", S_00B52C_EXCP_EN(~0u)},
};

static const struct si_field r_00b800_compute_dispatch_initiator__fields[] = {
	{"COMPUTE_SHADER_EN", S_00B800_COMPUTE_SHADER_EN(~0u)},
	{"PARTIAL_TG_EN", S_00B800_PARTIAL_TG_EN(~0u)},
	{"FORCE_START_AT_000", S_00B800_FORCE_START_AT_000(~0u)},
	{"ORDERED_APPEND_ENBL", S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{"ORDERED_APPEND_MODE", S_00B800_ORDERED_APPEND_MODE(~0u)},
	{"USE_THREAD_DIMENSIONS", S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{"ORDER_MODE", S_00B800_ORDER_MODE(~0u)},
	{"DISPATCH_CACHE_CNTL", S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{"SCALAR_L1_INV_VOL", S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{"VECTOR_L1_INV_VOL", S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{"DATA_ATC", S_00B800_DATA_ATC(~0u)},
	{"RESTORE", S_00B800_RESTORE(~0u)},
};

static const struct si_field r_00b81c_compute_num_thread_x__fields[] = {
	{"NUM_THREAD_FULL", S_00B81C_NUM_THREAD_FULL(~0u)},
	{"NUM_THREAD_PARTIAL", S_00B81C_NUM_THREAD_PARTIAL(~0u)},
};

static const struct si_field r_00b820_compute_num_thread_y__fields[] = {
	{"NUM_THREAD_FULL", S_00B820_NUM_THREAD_FULL(~0u)},
	{"NUM_THREAD_PARTIAL", S_00B820_NUM_THREAD_PARTIAL(~0u)},
};

static const struct si_field r_00b824_compute_num_thread_z__fields[] = {
	{"NUM_THREAD_FULL", S_00B824_NUM_THREAD_FULL(~0u)},
	{"NUM_THREAD_PARTIAL", S_00B824_NUM_THREAD_PARTIAL(~0u)},
};

static const struct si_field r_00b82c_compute_max_wave_id__fields[] = {
	{"MAX_WAVE_ID", S_00B82C_MAX_WAVE_ID(~0u)},
};

static const struct si_field r_00b828_compute_pipelinestat_enable__fields[] = {
	{"PIPELINESTAT_ENABLE", S_00B828_PIPELINESTAT_ENABLE(~0u)},
};

static const struct si_field r_00b82c_compute_perfcount_enable__fields[] = {
	{"PERFCOUNT_ENABLE", S_00B82C_PERFCOUNT_ENABLE(~0u)},
};

static const struct si_field r_00b834_compute_pgm_hi__fields[] = {
	{"DATA", S_00B834_DATA(~0u)},
	{"INST_ATC", S_00B834_INST_ATC(~0u)},
};

static const struct si_field r_00b83c_compute_tba_hi__fields[] = {
	{"DATA", S_00B83C_DATA(~0u)},
};

static const struct si_field r_00b844_compute_tma_hi__fields[] = {
	{"DATA", S_00B844_DATA(~0u)},
};

static const struct si_field r_00b848_compute_pgm_rsrc1__fields[] = {
	{"VGPRS", S_00B848_VGPRS(~0u)},
	{"SGPRS", S_00B848_SGPRS(~0u)},
	{"PRIORITY", S_00B848_PRIORITY(~0u)},
	{"FLOAT_MODE", S_00B848_FLOAT_MODE(~0u)},
	{"PRIV", S_00B848_PRIV(~0u)},
	{"DX10_CLAMP", S_00B848_DX10_CLAMP(~0u)},
	{"DEBUG_MODE", S_00B848_DEBUG_MODE(~0u)},
	{"IEEE_MODE", S_00B848_IEEE_MODE(~0u)},
	{"BULKY", S_00B848_BULKY(~0u)},
	{"CDBG_USER", S_00B848_CDBG_USER(~0u)},
};

static const struct si_field r_00b84c_compute_pgm_rsrc2__fields[] = {
	{"SCRATCH_EN", S_00B84C_SCRATCH_EN(~0u)},
	{"USER_SGPR", S_00B84C_USER_SGPR(~0u)},
	{"TRAP_PRESENT", S_00B84C_TRAP_PRESENT(~0u)},
	{"TGID_X_EN", S_00B84C_TGID_X_EN(~0u)},
	{"TGID_Y_EN", S_00B84C_TGID_Y_EN(~0u)},
	{"TGID_Z_EN", S_00B84C_TGID_Z_EN(~0u)},
	{"TG_SIZE_EN", S_00B84C_TG_SIZE_EN(~0u)},
	{"TIDIG_COMP_CNT", S_00B84C_TIDIG_COMP_CNT(~0u)},
	{"EXCP_EN_MSB", S_00B84C_EXCP_EN_MSB(~0u)},
	{"LDS_SIZE", S_00B84C_LDS_SIZE(~0u)},
	{"EXCP_EN", S_00B84C_EXCP_EN(~0u)},
};

static const struct si_field r_00b850_compute_vmid__fields[] = {
	{"DATA", S_00B850_DATA(~0u)},
};

static const struct si_field r_00b854_compute_resource_limits__fields[] = {
	{"WAVES_PER_SH", S_00B854_WAVES_PER_SH(~0u)},
	{"WAVES_PER_SH_CIK", S_00B854_WAVES_PER_SH_CIK(~0u)},
	{"TG_PER_CU", S_00B854_TG_PER_CU(~0u)},
	{"LOCK_THRESHOLD", S_00B854_LOCK_THRESHOLD(~0u)},
	{"SIMD_DEST_CNTL", S_00B854_SIMD_DEST_CNTL(~0u)},
	{"FORCE_SIMD_DIST", S_00B854_FORCE_SIMD_DIST(~0u)},
	{"CU_GROUP_COUNT", S_00B854_CU_GROUP_COUNT(~0u)},
};

static const struct si_field r_00b858_compute_static_thread_mgmt_se0__fields[] = {
	{"SH0_CU_EN", S_00B858_SH0_CU_EN(~0u)},
	{"SH1_CU_EN", S_00B858_SH1_CU_EN(~0u)},
};

static const struct si_field r_00b85c_compute_static_thread_mgmt_se1__fields[] = {
	{"SH0_CU_EN", S_00B85C_SH0_CU_EN(~0u)},
	{"SH1_CU_EN", S_00B85C_SH1_CU_EN(~0u)},
};

static const struct si_field r_00b860_compute_tmpring_size__fields[] = {
	{"WAVES", S_00B860_WAVES(~0u)},
	{"WAVESIZE", S_00B860_WAVESIZE(~0u)},
};

static const struct si_field r_00b864_compute_static_thread_mgmt_se2__fields[] = {
	{"SH0_CU_EN", S_00B864_SH0_CU_EN(~0u)},
	{"SH1_CU_EN", S_00B864_SH1_CU_EN(~0u)},
};

static const struct si_field r_00b868_compute_static_thread_mgmt_se3__fields[] = {
	{"SH0_CU_EN", S_00B868_SH0_CU_EN(~0u)},
	{"SH1_CU_EN", S_00B868_SH1_CU_EN(~0u)},
};

static const struct si_field r_00b87c_compute_misc_reserved__fields[] = {
	{"SEND_SEID", S_00B87C_SEND_SEID(~0u)},
	{"RESERVED2", S_00B87C_RESERVED2(~0u)},
	{"RESERVED3", S_00B87C_RESERVED3(~0u)},
	{"RESERVED4", S_00B87C_RESERVED4(~0u)},
	{"WAVE_ID_BASE", S_00B87C_WAVE_ID_BASE(~0u)},
};

static const struct si_field r_00b888_compute_relaunch__fields[] = {
	{"PAYLOAD", S_00B888_PAYLOAD(~0u)},
	{"IS_EVENT", S_00B888_IS_EVENT(~0u)},
	{"IS_STATE", S_00B888_IS_STATE(~0u)},
};

static const struct si_field r_00b890_compute_wave_restore_addr_hi__fields[] = {
	{"ADDR", S_00B890_ADDR(~0u)},
};

static const struct si_field r_00b894_compute_wave_restore_control__fields[] = {
	{"ATC", S_00B894_ATC(~0u)},
	{"MTYPE", S_00B894_MTYPE(~0u)},
};

static const struct si_field r_028000_db_render_control__fields[] = {
	{"DEPTH_CLEAR_ENABLE", S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{"STENCIL_CLEAR_ENABLE", S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{"DEPTH_COPY", S_028000_DEPTH_COPY(~0u)},
	{"STENCIL_COPY", S_028000_STENCIL_COPY(~0u)},
	{"RESUMMARIZE_ENABLE", S_028000_RESUMMARIZE_ENABLE(~0u)},
	{"STENCIL_COMPRESS_DISABLE", S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{"DEPTH_COMPRESS_DISABLE", S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{"COPY_CENTROID", S_028000_COPY_CENTROID(~0u)},
	{"COPY_SAMPLE", S_028000_COPY_SAMPLE(~0u)},
	{"DECOMPRESS_ENABLE", S_028000_DECOMPRESS_ENABLE(~0u)},
};

static const struct si_field r_028004_db_count_control__fields[] = {
	{"ZPASS_INCREMENT_DISABLE", S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{"PERFECT_ZPASS_COUNTS", S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{"SAMPLE_RATE", S_028004_SAMPLE_RATE(~0u)},
	{"ZPASS_ENABLE", S_028004_ZPASS_ENABLE(~0u)},
	{"ZFAIL_ENABLE", S_028004_ZFAIL_ENABLE(~0u)},
	{"SFAIL_ENABLE", S_028004_SFAIL_ENABLE(~0u)},
	{"DBFAIL_ENABLE", S_028004_DBFAIL_ENABLE(~0u)},
	{"SLICE_EVEN_ENABLE", S_028004_SLICE_EVEN_ENABLE(~0u)},
	{"SLICE_ODD_ENABLE", S_028004_SLICE_ODD_ENABLE(~0u)},
};

static const struct si_field r_028008_db_depth_view__fields[] = {
	{"SLICE_START", S_028008_SLICE_START(~0u)},
	{"SLICE_MAX", S_028008_SLICE_MAX(~0u)},
	{"Z_READ_ONLY", S_028008_Z_READ_ONLY(~0u)},
	{"STENCIL_READ_ONLY", S_028008_STENCIL_READ_ONLY(~0u)},
};

static const char *r_02800c_db_render_override__force_hiz_enable__values[] = {
	[V_02800C_FORCE_OFF] = "FORCE_OFF",
	[V_02800C_FORCE_ENABLE] = "FORCE_ENABLE",
	[V_02800C_FORCE_DISABLE] = "FORCE_DISABLE",
	[V_02800C_FORCE_RESERVED] = "FORCE_RESERVED",
};

static const char *r_02800c_db_render_override__force_his_enable0__values[] = {
	[V_02800C_FORCE_OFF] = "FORCE_OFF",
	[V_02800C_FORCE_ENABLE] = "FORCE_ENABLE",
	[V_02800C_FORCE_DISABLE] = "FORCE_DISABLE",
	[V_02800C_FORCE_RESERVED] = "FORCE_RESERVED",
};

static const char *r_02800c_db_render_override__force_his_enable1__values[] = {
	[V_02800C_FORCE_OFF] = "FORCE_OFF",
	[V_02800C_FORCE_ENABLE] = "FORCE_ENABLE",
	[V_02800C_FORCE_DISABLE] = "FORCE_DISABLE",
	[V_02800C_FORCE_RESERVED] = "FORCE_RESERVED",
};

static const char *r_02800c_db_render_override__force_full_z_range__values[] = {
	[V_02800C_FORCE_OFF] = "FORCE_OFF",
	[V_02800C_FORCE_ENABLE] = "FORCE_ENABLE",
	[V_02800C_FORCE_DISABLE] = "FORCE_DISABLE",
	[V_02800C_FORCE_RESERVED] = "FORCE_RESERVED",
};

static const char *r_02800c_db_render_override__force_z_limit_summ__values[] = {
	[V_02800C_FORCE_SUMM_OFF] = "FORCE_SUMM_OFF",
	[V_02800C_FORCE_SUMM_MINZ] = "FORCE_SUMM_MINZ",
	[V_02800C_FORCE_SUMM_MAXZ] = "FORCE_SUMM_MAXZ",
	[V_02800C_FORCE_SUMM_BOTH] = "FORCE_SUMM_BOTH",
};

static const struct si_field r_02800c_db_render_override__fields[] = {
	{"FORCE_HIZ_ENABLE", S_02800C_FORCE_HIZ_ENABLE(~0u), ARRAY_SIZE(r_02800c_db_render_override__force_hiz_enable__values), r_02800c_db_render_override__force_hiz_enable__values},
	{"FORCE_HIS_ENABLE0", S_02800C_FORCE_HIS_ENABLE0(~0u), ARRAY_SIZE(r_02800c_db_render_override__force_his_enable0__values), r_02800c_db_render_override__force_his_enable0__values},
	{"FORCE_HIS_ENABLE1", S_02800C_FORCE_HIS_ENABLE1(~0u), ARRAY_SIZE(r_02800c_db_render_override__force_his_enable1__values), r_02800c_db_render_override__force_his_enable1__values},
	{"FORCE_SHADER_Z_ORDER", S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{"FAST_Z_DISABLE", S_02800C_FAST_Z_DISABLE(~0u)},
	{"FAST_STENCIL_DISABLE", S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{"NOOP_CULL_DISABLE", S_02800C_NOOP_CULL_DISABLE(~0u)},
	{"FORCE_COLOR_KILL", S_02800C_FORCE_COLOR_KILL(~0u)},
	{"FORCE_Z_READ", S_02800C_FORCE_Z_READ(~0u)},
	{"FORCE_STENCIL_READ", S_02800C_FORCE_STENCIL_READ(~0u)},
	{"FORCE_FULL_Z_RANGE", S_02800C_FORCE_FULL_Z_RANGE(~0u), ARRAY_SIZE(r_02800c_db_render_override__force_full_z_range__values), r_02800c_db_render_override__force_full_z_range__values},
	{"FORCE_QC_SMASK_CONFLICT", S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{"DISABLE_VIEWPORT_CLAMP", S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{"IGNORE_SC_ZRANGE", S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{"DISABLE_FULLY_COVERED", S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{"FORCE_Z_LIMIT_SUMM", S_02800C_FORCE_Z_LIMIT_SUMM(~0u), ARRAY_SIZE(r_02800c_db_render_override__force_z_limit_summ__values), r_02800c_db_render_override__force_z_limit_summ__values},
	{"MAX_TILES_IN_DTT", S_02800C_MAX_TILES_IN_DTT(~0u)},
	{"DISABLE_TILE_RATE_TILES", S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{"FORCE_Z_DIRTY", S_02800C_FORCE_Z_DIRTY(~0u)},
	{"FORCE_STENCIL_DIRTY", S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{"FORCE_Z_VALID", S_02800C_FORCE_Z_VALID(~0u)},
	{"FORCE_STENCIL_VALID", S_02800C_FORCE_STENCIL_VALID(~0u)},
	{"PRESERVE_COMPRESSION", S_02800C_PRESERVE_COMPRESSION(~0u)},
};

static const char *r_028010_db_render_override2__partial_squad_launch_control__values[] = {
	[V_028010_PSLC_AUTO] = "PSLC_AUTO",
	[V_028010_PSLC_ON_HANG_ONLY] = "PSLC_ON_HANG_ONLY",
	[V_028010_PSLC_ASAP] = "PSLC_ASAP",
	[V_028010_PSLC_COUNTDOWN] = "PSLC_COUNTDOWN",
};

static const struct si_field r_028010_db_render_override2__fields[] = {
	{"PARTIAL_SQUAD_LAUNCH_CONTROL", S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), ARRAY_SIZE(r_028010_db_render_override2__partial_squad_launch_control__values), r_028010_db_render_override2__partial_squad_launch_control__values},
	{"PARTIAL_SQUAD_LAUNCH_COUNTDOWN", S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION", S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION", S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{"DISABLE_COLOR_ON_VALIDATION", S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{"DECOMPRESS_Z_ON_FLUSH", S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{"DISABLE_REG_SNOOP", S_028010_DISABLE_REG_SNOOP(~0u)},
	{"DEPTH_BOUNDS_HIER_DEPTH_DISABLE", S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{"SEPARATE_HIZS_FUNC_ENABLE", S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{"HIZ_ZFUNC", S_028010_HIZ_ZFUNC(~0u)},
	{"HIS_SFUNC_FF", S_028010_HIS_SFUNC_FF(~0u)},
	{"HIS_SFUNC_BF", S_028010_HIS_SFUNC_BF(~0u)},
	{"PRESERVE_ZRANGE", S_028010_PRESERVE_ZRANGE(~0u)},
	{"PRESERVE_SRESULTS", S_028010_PRESERVE_SRESULTS(~0u)},
	{"DISABLE_FAST_PASS", S_028010_DISABLE_FAST_PASS(~0u)},
};

static const struct si_field r_028028_db_stencil_clear__fields[] = {
	{"CLEAR", S_028028_CLEAR(~0u)},
};

static const struct si_field r_028030_pa_sc_screen_scissor_tl__fields[] = {
	{"TL_X", S_028030_TL_X(~0u)},
	{"TL_Y", S_028030_TL_Y(~0u)},
};

static const struct si_field r_028034_pa_sc_screen_scissor_br__fields[] = {
	{"BR_X", S_028034_BR_X(~0u)},
	{"BR_Y", S_028034_BR_Y(~0u)},
};

static const char *r_02803c_db_depth_info__array_mode__values[] = {
	[V_02803C_ARRAY_LINEAR_GENERAL] = "ARRAY_LINEAR_GENERAL",
	[V_02803C_ARRAY_LINEAR_ALIGNED] = "ARRAY_LINEAR_ALIGNED",
	[V_02803C_ARRAY_1D_TILED_THIN1] = "ARRAY_1D_TILED_THIN1",
	[V_02803C_ARRAY_2D_TILED_THIN1] = "ARRAY_2D_TILED_THIN1",
	[V_02803C_ARRAY_PRT_TILED_THIN1] = "ARRAY_PRT_TILED_THIN1",
	[V_02803C_ARRAY_PRT_2D_TILED_THIN1] = "ARRAY_PRT_2D_TILED_THIN1",
};

static const char *r_02803c_db_depth_info__pipe_config__values[] = {
	[V_02803C_ADDR_SURF_P2] = "ADDR_SURF_P2",
	[V_02803C_X_ADDR_SURF_P4_8X16] = "X_ADDR_SURF_P4_8X16",
	[V_02803C_X_ADDR_SURF_P4_16X16] = "X_ADDR_SURF_P4_16X16",
	[V_02803C_X_ADDR_SURF_P4_16X32] = "X_ADDR_SURF_P4_16X32",
	[V_02803C_X_ADDR_SURF_P4_32X32] = "X_ADDR_SURF_P4_32X32",
	[V_02803C_X_ADDR_SURF_P8_16X16_8X16] = "X_ADDR_SURF_P8_16X16_8X16",
	[V_02803C_X_ADDR_SURF_P8_16X32_8X16] = "X_ADDR_SURF_P8_16X32_8X16",
	[V_02803C_X_ADDR_SURF_P8_32X32_8X16] = "X_ADDR_SURF_P8_32X32_8X16",
	[V_02803C_X_ADDR_SURF_P8_16X32_16X16] = "X_ADDR_SURF_P8_16X32_16X16",
	[V_02803C_X_ADDR_SURF_P8_32X32_16X16] = "X_ADDR_SURF_P8_32X32_16X16",
	[V_02803C_X_ADDR_SURF_P8_32X32_16X32] = "X_ADDR_SURF_P8_32X32_16X32",
	[V_02803C_X_ADDR_SURF_P8_32X64_32X32] = "X_ADDR_SURF_P8_32X64_32X32",
	[V_02803C_X_ADDR_SURF_P16_32X32_8X16] = "X_ADDR_SURF_P16_32X32_8X16",
	[V_02803C_X_ADDR_SURF_P16_32X32_16X16] = "X_ADDR_SURF_P16_32X32_16X16",
};

static const char *r_02803c_db_depth_info__bank_width__values[] = {
	[V_02803C_ADDR_SURF_BANK_WIDTH_1] = "ADDR_SURF_BANK_WIDTH_1",
	[V_02803C_ADDR_SURF_BANK_WIDTH_2] = "ADDR_SURF_BANK_WIDTH_2",
	[V_02803C_ADDR_SURF_BANK_WIDTH_4] = "ADDR_SURF_BANK_WIDTH_4",
	[V_02803C_ADDR_SURF_BANK_WIDTH_8] = "ADDR_SURF_BANK_WIDTH_8",
};

static const char *r_02803c_db_depth_info__bank_height__values[] = {
	[V_02803C_ADDR_SURF_BANK_HEIGHT_1] = "ADDR_SURF_BANK_HEIGHT_1",
	[V_02803C_ADDR_SURF_BANK_HEIGHT_2] = "ADDR_SURF_BANK_HEIGHT_2",
	[V_02803C_ADDR_SURF_BANK_HEIGHT_4] = "ADDR_SURF_BANK_HEIGHT_4",
	[V_02803C_ADDR_SURF_BANK_HEIGHT_8] = "ADDR_SURF_BANK_HEIGHT_8",
};

static const char *r_02803c_db_depth_info__macro_tile_aspect__values[] = {
	[V_02803C_ADDR_SURF_MACRO_ASPECT_1] = "ADDR_SURF_MACRO_ASPECT_1",
	[V_02803C_ADDR_SURF_MACRO_ASPECT_2] = "ADDR_SURF_MACRO_ASPECT_2",
	[V_02803C_ADDR_SURF_MACRO_ASPECT_4] = "ADDR_SURF_MACRO_ASPECT_4",
	[V_02803C_ADDR_SURF_MACRO_ASPECT_8] = "ADDR_SURF_MACRO_ASPECT_8",
};

static const char *r_02803c_db_depth_info__num_banks__values[] = {
	[V_02803C_ADDR_SURF_2_BANK] = "ADDR_SURF_2_BANK",
	[V_02803C_ADDR_SURF_4_BANK] = "ADDR_SURF_4_BANK",
	[V_02803C_ADDR_SURF_8_BANK] = "ADDR_SURF_8_BANK",
	[V_02803C_ADDR_SURF_16_BANK] = "ADDR_SURF_16_BANK",
};

static const struct si_field r_02803c_db_depth_info__fields[] = {
	{"ADDR5_SWIZZLE_MASK", S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{"ARRAY_MODE", S_02803C_ARRAY_MODE(~0u), ARRAY_SIZE(r_02803c_db_depth_info__array_mode__values), r_02803c_db_depth_info__array_mode__values},
	{"PIPE_CONFIG", S_02803C_PIPE_CONFIG(~0u), ARRAY_SIZE(r_02803c_db_depth_info__pipe_config__values), r_02803c_db_depth_info__pipe_config__values},
	{"BANK_WIDTH", S_02803C_BANK_WIDTH(~0u), ARRAY_SIZE(r_02803c_db_depth_info__bank_width__values), r_02803c_db_depth_info__bank_width__values},
	{"BANK_HEIGHT", S_02803C_BANK_HEIGHT(~0u), ARRAY_SIZE(r_02803c_db_depth_info__bank_height__values), r_02803c_db_depth_info__bank_height__values},
	{"MACRO_TILE_ASPECT", S_02803C_MACRO_TILE_ASPECT(~0u), ARRAY_SIZE(r_02803c_db_depth_info__macro_tile_aspect__values), r_02803c_db_depth_info__macro_tile_aspect__values},
	{"NUM_BANKS", S_02803C_NUM_BANKS(~0u), ARRAY_SIZE(r_02803c_db_depth_info__num_banks__values), r_02803c_db_depth_info__num_banks__values},
};

static const char *r_028040_db_z_info__format__values[] = {
	[V_028040_Z_INVALID] = "Z_INVALID",
	[V_028040_Z_16] = "Z_16",
	[V_028040_Z_24] = "Z_24",
	[V_028040_Z_32_FLOAT] = "Z_32_FLOAT",
};

static const char *r_028040_db_z_info__tile_split__values[] = {
	[V_028040_ADDR_SURF_TILE_SPLIT_64B] = "ADDR_SURF_TILE_SPLIT_64B",
	[V_028040_ADDR_SURF_TILE_SPLIT_128B] = "ADDR_SURF_TILE_SPLIT_128B",
	[V_028040_ADDR_SURF_TILE_SPLIT_256B] = "ADDR_SURF_TILE_SPLIT_256B",
	[V_028040_ADDR_SURF_TILE_SPLIT_512B] = "ADDR_SURF_TILE_SPLIT_512B",
	[V_028040_ADDR_SURF_TILE_SPLIT_1KB] = "ADDR_SURF_TILE_SPLIT_1KB",
	[V_028040_ADDR_SURF_TILE_SPLIT_2KB] = "ADDR_SURF_TILE_SPLIT_2KB",
	[V_028040_ADDR_SURF_TILE_SPLIT_4KB] = "ADDR_SURF_TILE_SPLIT_4KB",
};

static const struct si_field r_028040_db_z_info__fields[] = {
	{"FORMAT", S_028040_FORMAT(~0u), ARRAY_SIZE(r_028040_db_z_info__format__values), r_028040_db_z_info__format__values},
	{"NUM_SAMPLES", S_028040_NUM_SAMPLES(~0u)},
	{"TILE_SPLIT", S_028040_TILE_SPLIT(~0u), ARRAY_SIZE(r_028040_db_z_info__tile_split__values), r_028040_db_z_info__tile_split__values},
	{"TILE_MODE_INDEX", S_028040_TILE_MODE_INDEX(~0u)},
	{"DECOMPRESS_ON_N_ZPLANES", S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{"ALLOW_EXPCLEAR", S_028040_ALLOW_EXPCLEAR(~0u)},
	{"READ_SIZE", S_028040_READ_SIZE(~0u)},
	{"TILE_SURFACE_ENABLE", S_028040_TILE_SURFACE_ENABLE(~0u)},
	{"CLEAR_DISALLOWED", S_028040_CLEAR_DISALLOWED(~0u)},
	{"ZRANGE_PRECISION", S_028040_ZRANGE_PRECISION(~0u)},
};

static const char *r_028044_db_stencil_info__format__values[] = {
	[V_028044_STENCIL_INVALID] = "STENCIL_INVALID",
	[V_028044_STENCIL_8] = "STENCIL_8",
};

static const char *r_028044_db_stencil_info__tile_split__values[] = {
	[V_028044_ADDR_SURF_TILE_SPLIT_64B] = "ADDR_SURF_TILE_SPLIT_64B",
	[V_028044_ADDR_SURF_TILE_SPLIT_128B] = "ADDR_SURF_TILE_SPLIT_128B",
	[V_028044_ADDR_SURF_TILE_SPLIT_256B] = "ADDR_SURF_TILE_SPLIT_256B",
	[V_028044_ADDR_SURF_TILE_SPLIT_512B] = "ADDR_SURF_TILE_SPLIT_512B",
	[V_028044_ADDR_SURF_TILE_SPLIT_1KB] = "ADDR_SURF_TILE_SPLIT_1KB",
	[V_028044_ADDR_SURF_TILE_SPLIT_2KB] = "ADDR_SURF_TILE_SPLIT_2KB",
	[V_028044_ADDR_SURF_TILE_SPLIT_4KB] = "ADDR_SURF_TILE_SPLIT_4KB",
};

static const struct si_field r_028044_db_stencil_info__fields[] = {
	{"FORMAT", S_028044_FORMAT(~0u), ARRAY_SIZE(r_028044_db_stencil_info__format__values), r_028044_db_stencil_info__format__values},
	{"TILE_SPLIT", S_028044_TILE_SPLIT(~0u), ARRAY_SIZE(r_028044_db_stencil_info__tile_split__values), r_028044_db_stencil_info__tile_split__values},
	{"TILE_MODE_INDEX", S_028044_TILE_MODE_INDEX(~0u)},
	{"ALLOW_EXPCLEAR", S_028044_ALLOW_EXPCLEAR(~0u)},
	{"TILE_STENCIL_DISABLE", S_028044_TILE_STENCIL_DISABLE(~0u)},
	{"CLEAR_DISALLOWED", S_028044_CLEAR_DISALLOWED(~0u)},
};

static const struct si_field r_028058_db_depth_size__fields[] = {
	{"PITCH_TILE_MAX", S_028058_PITCH_TILE_MAX(~0u)},
	{"HEIGHT_TILE_MAX", S_028058_HEIGHT_TILE_MAX(~0u)},
};

static const struct si_field r_02805c_db_depth_slice__fields[] = {
	{"SLICE_TILE_MAX", S_02805C_SLICE_TILE_MAX(~0u)},
};

static const struct si_field r_028084_ta_bc_base_addr_hi__fields[] = {
	{"ADDRESS", S_028084_ADDRESS(~0u)},
};

static const struct si_field r_028200_pa_sc_window_offset__fields[] = {
	{"WINDOW_X_OFFSET", S_028200_WINDOW_X_OFFSET(~0u)},
	{"WINDOW_Y_OFFSET", S_028200_WINDOW_Y_OFFSET(~0u)},
};

static const struct si_field r_028204_pa_sc_window_scissor_tl__fields[] = {
	{"TL_X", S_028204_TL_X(~0u)},
	{"TL_Y", S_028204_TL_Y(~0u)},
	{"WINDOW_OFFSET_DISABLE", S_028204_WINDOW_OFFSET_DISABLE(~0u)},
};

static const struct si_field r_028208_pa_sc_window_scissor_br__fields[] = {
	{"BR_X", S_028208_BR_X(~0u)},
	{"BR_Y", S_028208_BR_Y(~0u)},
};

static const struct si_field r_02820c_pa_sc_cliprect_rule__fields[] = {
	{"CLIP_RULE", S_02820C_CLIP_RULE(~0u)},
};

static const struct si_field r_028210_pa_sc_cliprect_0_tl__fields[] = {
	{"TL_X", S_028210_TL_X(~0u)},
	{"TL_Y", S_028210_TL_Y(~0u)},
};

static const struct si_field r_028214_pa_sc_cliprect_0_br__fields[] = {
	{"BR_X", S_028214_BR_X(~0u)},
	{"BR_Y", S_028214_BR_Y(~0u)},
};

static const struct si_field r_028230_pa_sc_edgerule__fields[] = {
	{"ER_TRI", S_028230_ER_TRI(~0u)},
	{"ER_POINT", S_028230_ER_POINT(~0u)},
	{"ER_RECT", S_028230_ER_RECT(~0u)},
	{"ER_LINE_LR", S_028230_ER_LINE_LR(~0u)},
	{"ER_LINE_RL", S_028230_ER_LINE_RL(~0u)},
	{"ER_LINE_TB", S_028230_ER_LINE_TB(~0u)},
	{"ER_LINE_BT", S_028230_ER_LINE_BT(~0u)},
};

static const struct si_field r_028234_pa_su_hardware_screen_offset__fields[] = {
	{"HW_SCREEN_OFFSET_X", S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{"HW_SCREEN_OFFSET_Y", S_028234_HW_SCREEN_OFFSET_Y(~0u)},
};

static const struct si_field r_028238_cb_target_mask__fields[] = {
	{"TARGET0_ENABLE", S_028238_TARGET0_ENABLE(~0u)},
	{"TARGET1_ENABLE", S_028238_TARGET1_ENABLE(~0u)},
	{"TARGET2_ENABLE", S_028238_TARGET2_ENABLE(~0u)},
	{"TARGET3_ENABLE", S_028238_TARGET3_ENABLE(~0u)},
	{"TARGET4_ENABLE", S_028238_TARGET4_ENABLE(~0u)},
	{"TARGET5_ENABLE", S_028238_TARGET5_ENABLE(~0u)},
	{"TARGET6_ENABLE", S_028238_TARGET6_ENABLE(~0u)},
	{"TARGET7_ENABLE", S_028238_TARGET7_ENABLE(~0u)},
};

static const struct si_field r_02823c_cb_shader_mask__fields[] = {
	{"OUTPUT0_ENABLE", S_02823C_OUTPUT0_ENABLE(~0u)},
	{"OUTPUT1_ENABLE", S_02823C_OUTPUT1_ENABLE(~0u)},
	{"OUTPUT2_ENABLE", S_02823C_OUTPUT2_ENABLE(~0u)},
	{"OUTPUT3_ENABLE", S_02823C_OUTPUT3_ENABLE(~0u)},
	{"OUTPUT4_ENABLE", S_02823C_OUTPUT4_ENABLE(~0u)},
	{"OUTPUT5_ENABLE", S_02823C_OUTPUT5_ENABLE(~0u)},
	{"OUTPUT6_ENABLE", S_02823C_OUTPUT6_ENABLE(~0u)},
	{"OUTPUT7_ENABLE", S_02823C_OUTPUT7_ENABLE(~0u)},
};

static const struct si_field r_028240_pa_sc_generic_scissor_tl__fields[] = {
	{"TL_X", S_028240_TL_X(~0u)},
	{"TL_Y", S_028240_TL_Y(~0u)},
	{"WINDOW_OFFSET_DISABLE", S_028240_WINDOW_OFFSET_DISABLE(~0u)},
};

static const struct si_field r_028244_pa_sc_generic_scissor_br__fields[] = {
	{"BR_X", S_028244_BR_X(~0u)},
	{"BR_Y", S_028244_BR_Y(~0u)},
};

static const struct si_field r_028250_pa_sc_vport_scissor_0_tl__fields[] = {
	{"TL_X", S_028250_TL_X(~0u)},
	{"TL_Y", S_028250_TL_Y(~0u)},
	{"WINDOW_OFFSET_DISABLE", S_028250_WINDOW_OFFSET_DISABLE(~0u)},
};

static const struct si_field r_028254_pa_sc_vport_scissor_0_br__fields[] = {
	{"BR_X", S_028254_BR_X(~0u)},
	{"BR_Y", S_028254_BR_Y(~0u)},
};

static const char *r_028350_pa_sc_raster_config__rb_map_pkr0__values[] = {
	[V_028350_RASTER_CONFIG_RB_MAP_0] = "RASTER_CONFIG_RB_MAP_0",
	[V_028350_RASTER_CONFIG_RB_MAP_1] = "RASTER_CONFIG_RB_MAP_1",
	[V_028350_RASTER_CONFIG_RB_MAP_2] = "RASTER_CONFIG_RB_MAP_2",
	[V_028350_RASTER_CONFIG_RB_MAP_3] = "RASTER_CONFIG_RB_MAP_3",
};

static const char *r_028350_pa_sc_raster_config__rb_map_pkr1__values[] = {
	[V_028350_RASTER_CONFIG_RB_MAP_0] = "RASTER_CONFIG_RB_MAP_0",
	[V_028350_RASTER_CONFIG_RB_MAP_1] = "RASTER_CONFIG_RB_MAP_1",
	[V_028350_RASTER_CONFIG_RB_MAP_2] = "RASTER_CONFIG_RB_MAP_2",
	[V_028350_RASTER_CONFIG_RB_MAP_3] = "RASTER_CONFIG_RB_MAP_3",
};

static const char *r_028350_pa_sc_raster_config__rb_xsel2__values[] = {
	[V_028350_RASTER_CONFIG_RB_XSEL2_0] = "RASTER_CONFIG_RB_XSEL2_0",
	[V_028350_RASTER_CONFIG_RB_XSEL2_1] = "RASTER_CONFIG_RB_XSEL2_1",
	[V_028350_RASTER_CONFIG_RB_XSEL2_2] = "RASTER_CONFIG_RB_XSEL2_2",
	[V_028350_RASTER_CONFIG_RB_XSEL2_3] = "RASTER_CONFIG_RB_XSEL2_3",
};

static const char *r_028350_pa_sc_raster_config__pkr_map__values[] = {
	[V_028350_RASTER_CONFIG_PKR_MAP_0] = "RASTER_CONFIG_PKR_MAP_0",
	[V_028350_RASTER_CONFIG_PKR_MAP_1] = "RASTER_CONFIG_PKR_MAP_1",
	[V_028350_RASTER_CONFIG_PKR_MAP_2] = "RASTER_CONFIG_PKR_MAP_2",
	[V_028350_RASTER_CONFIG_PKR_MAP_3] = "RASTER_CONFIG_PKR_MAP_3",
};

static const char *r_028350_pa_sc_raster_config__pkr_xsel__values[] = {
	[V_028350_RASTER_CONFIG_PKR_XSEL_0] = "RASTER_CONFIG_PKR_XSEL_0",
	[V_028350_RASTER_CONFIG_PKR_XSEL_1] = "RASTER_CONFIG_PKR_XSEL_1",
	[V_028350_RASTER_CONFIG_PKR_XSEL_2] = "RASTER_CONFIG_PKR_XSEL_2",
	[V_028350_RASTER_CONFIG_PKR_XSEL_3] = "RASTER_CONFIG_PKR_XSEL_3",
};

static const char *r_028350_pa_sc_raster_config__pkr_ysel__values[] = {
	[V_028350_RASTER_CONFIG_PKR_YSEL_0] = "RASTER_CONFIG_PKR_YSEL_0",
	[V_028350_RASTER_CONFIG_PKR_YSEL_1] = "RASTER_CONFIG_PKR_YSEL_1",
	[V_028350_RASTER_CONFIG_PKR_YSEL_2] = "RASTER_CONFIG_PKR_YSEL_2",
	[V_028350_RASTER_CONFIG_PKR_YSEL_3] = "RASTER_CONFIG_PKR_YSEL_3",
};

static const char *r_028350_pa_sc_raster_config__pkr_xsel2__values[] = {
	[V_028350_RASTER_CONFIG_PKR_XSEL2_0] = "RASTER_CONFIG_PKR_XSEL2_0",
	[V_028350_RASTER_CONFIG_PKR_XSEL2_1] = "RASTER_CONFIG_PKR_XSEL2_1",
	[V_028350_RASTER_CONFIG_PKR_XSEL2_2] = "RASTER_CONFIG_PKR_XSEL2_2",
	[V_028350_RASTER_CONFIG_PKR_XSEL2_3] = "RASTER_CONFIG_PKR_XSEL2_3",
};

static const char *r_028350_pa_sc_raster_config__sc_map__values[] = {
	[V_028350_RASTER_CONFIG_SC_MAP_0] = "RASTER_CONFIG_SC_MAP_0",
	[V_028350_RASTER_CONFIG_SC_MAP_1] = "RASTER_CONFIG_SC_MAP_1",
	[V_028350_RASTER_CONFIG_SC_MAP_2] = "RASTER_CONFIG_SC_MAP_2",
	[V_028350_RASTER_CONFIG_SC_MAP_3] = "RASTER_CONFIG_SC_MAP_3",
};

static const char *r_028350_pa_sc_raster_config__sc_xsel__values[] = {
	[V_028350_RASTER_CONFIG_SC_XSEL_8_WIDE_TILE] = "RASTER_CONFIG_SC_XSEL_8_WIDE_TILE",
	[V_028350_RASTER_CONFIG_SC_XSEL_16_WIDE_TILE] = "RASTER_CONFIG_SC_XSEL_16_WIDE_TILE",
	[V_028350_RASTER_CONFIG_SC_XSEL_32_WIDE_TILE] = "RASTER_CONFIG_SC_XSEL_32_WIDE_TILE",
	[V_028350_RASTER_CONFIG_SC_XSEL_64_WIDE_TILE] = "RASTER_CONFIG_SC_XSEL_64_WIDE_TILE",
};

static const char *r_028350_pa_sc_raster_config__sc_ysel__values[] = {
	[V_028350_RASTER_CONFIG_SC_YSEL_8_WIDE_TILE] = "RASTER_CONFIG_SC_YSEL_8_WIDE_TILE",
	[V_028350_RASTER_CONFIG_SC_YSEL_16_WIDE_TILE] = "RASTER_CONFIG_SC_YSEL_16_WIDE_TILE",
	[V_028350_RASTER_CONFIG_SC_YSEL_32_WIDE_TILE] = "RASTER_CONFIG_SC_YSEL_32_WIDE_TILE",
	[V_028350_RASTER_CONFIG_SC_YSEL_64_WIDE_TILE] = "RASTER_CONFIG_SC_YSEL_64_WIDE_TILE",
};

static const char *r_028350_pa_sc_raster_config__se_map__values[] = {
	[V_028350_RASTER_CONFIG_SE_MAP_0] = "RASTER_CONFIG_SE_MAP_0",
	[V_028350_RASTER_CONFIG_SE_MAP_1] = "RASTER_CONFIG_SE_MAP_1",
	[V_028350_RASTER_CONFIG_SE_MAP_2] = "RASTER_CONFIG_SE_MAP_2",
	[V_028350_RASTER_CONFIG_SE_MAP_3] = "RASTER_CONFIG_SE_MAP_3",
};

static const char *r_028350_pa_sc_raster_config__se_xsel__values[] = {
	[V_028350_RASTER_CONFIG_SE_XSEL_8_WIDE_TILE] = "RASTER_CONFIG_SE_XSEL_8_WIDE_TILE",
	[V_028350_RASTER_CONFIG_SE_XSEL_16_WIDE_TILE] = "RASTER_CONFIG_SE_XSEL_16_WIDE_TILE",
	[V_028350_RASTER_CONFIG_SE_XSEL_32_WIDE_TILE] = "RASTER_CONFIG_SE_XSEL_32_WIDE_TILE",
	[V_028350_RASTER_CONFIG_SE_XSEL_64_WIDE_TILE] = "RASTER_CONFIG_SE_XSEL_64_WIDE_TILE",
};

static const char *r_028350_pa_sc_raster_config__se_ysel__values[] = {
	[V_028350_RASTER_CONFIG_SE_YSEL_8_WIDE_TILE] = "RASTER_CONFIG_SE_YSEL_8_WIDE_TILE",
	[V_028350_RASTER_CONFIG_SE_YSEL_16_WIDE_TILE] = "RASTER_CONFIG_SE_YSEL_16_WIDE_TILE",
	[V_028350_RASTER_CONFIG_SE_YSEL_32_WIDE_TILE] = "RASTER_CONFIG_SE_YSEL_32_WIDE_TILE",
	[V_028350_RASTER_CONFIG_SE_YSEL_64_WIDE_TILE] = "RASTER_CONFIG_SE_YSEL_64_WIDE_TILE",
};

static const struct si_field r_028350_pa_sc_raster_config__fields[] = {
	{"RB_MAP_PKR0", S_028350_RB_MAP_PKR0(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__rb_map_pkr0__values), r_028350_pa_sc_raster_config__rb_map_pkr0__values},
	{"RB_MAP_PKR1", S_028350_RB_MAP_PKR1(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__rb_map_pkr1__values), r_028350_pa_sc_raster_config__rb_map_pkr1__values},
	{"RB_XSEL2", S_028350_RB_XSEL2(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__rb_xsel2__values), r_028350_pa_sc_raster_config__rb_xsel2__values},
	{"RB_XSEL", S_028350_RB_XSEL(~0u)},
	{"RB_YSEL", S_028350_RB_YSEL(~0u)},
	{"PKR_MAP", S_028350_PKR_MAP(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__pkr_map__values), r_028350_pa_sc_raster_config__pkr_map__values},
	{"PKR_XSEL", S_028350_PKR_XSEL(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__pkr_xsel__values), r_028350_pa_sc_raster_config__pkr_xsel__values},
	{"PKR_YSEL", S_028350_PKR_YSEL(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__pkr_ysel__values), r_028350_pa_sc_raster_config__pkr_ysel__values},
	{"PKR_XSEL2", S_028350_PKR_XSEL2(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__pkr_xsel2__values), r_028350_pa_sc_raster_config__pkr_xsel2__values},
	{"SC_MAP", S_028350_SC_MAP(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__sc_map__values), r_028350_pa_sc_raster_config__sc_map__values},
	{"SC_XSEL", S_028350_SC_XSEL(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__sc_xsel__values), r_028350_pa_sc_raster_config__sc_xsel__values},
	{"SC_YSEL", S_028350_SC_YSEL(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__sc_ysel__values), r_028350_pa_sc_raster_config__sc_ysel__values},
	{"SE_MAP", S_028350_SE_MAP(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__se_map__values), r_028350_pa_sc_raster_config__se_map__values},
	{"SE_XSEL", S_028350_SE_XSEL(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__se_xsel__values), r_028350_pa_sc_raster_config__se_xsel__values},
	{"SE_YSEL", S_028350_SE_YSEL(~0u), ARRAY_SIZE(r_028350_pa_sc_raster_config__se_ysel__values), r_028350_pa_sc_raster_config__se_ysel__values},
};

static const char *r_028354_pa_sc_raster_config_1__se_pair_map__values[] = {
	[V_028354_RASTER_CONFIG_SE_PAIR_MAP_0] = "RASTER_CONFIG_SE_PAIR_MAP_0",
	[V_028354_RASTER_CONFIG_SE_PAIR_MAP_1] = "RASTER_CONFIG_SE_PAIR_MAP_1",
	[V_028354_RASTER_CONFIG_SE_PAIR_MAP_2] = "RASTER_CONFIG_SE_PAIR_MAP_2",
	[V_028354_RASTER_CONFIG_SE_PAIR_MAP_3] = "RASTER_CONFIG_SE_PAIR_MAP_3",
};

static const char *r_028354_pa_sc_raster_config_1__se_pair_xsel__values[] = {
	[V_028354_RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE] = "RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE",
	[V_028354_RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE] = "RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE",
	[V_028354_RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE] = "RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE",
	[V_028354_RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE] = "RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE",
};

static const char *r_028354_pa_sc_raster_config_1__se_pair_ysel__values[] = {
	[V_028354_RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE] = "RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE",
	[V_028354_RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE] = "RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE",
	[V_028354_RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE] = "RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE",
	[V_028354_RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE] = "RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE",
};

static const struct si_field r_028354_pa_sc_raster_config_1__fields[] = {
	{"SE_PAIR_MAP", S_028354_SE_PAIR_MAP(~0u), ARRAY_SIZE(r_028354_pa_sc_raster_config_1__se_pair_map__values), r_028354_pa_sc_raster_config_1__se_pair_map__values},
	{"SE_PAIR_XSEL", S_028354_SE_PAIR_XSEL(~0u), ARRAY_SIZE(r_028354_pa_sc_raster_config_1__se_pair_xsel__values), r_028354_pa_sc_raster_config_1__se_pair_xsel__values},
	{"SE_PAIR_YSEL", S_028354_SE_PAIR_YSEL(~0u), ARRAY_SIZE(r_028354_pa_sc_raster_config_1__se_pair_ysel__values), r_028354_pa_sc_raster_config_1__se_pair_ysel__values},
};

static const struct si_field r_028358_pa_sc_screen_extent_control__fields[] = {
	{"SLICE_EVEN_ENABLE", S_028358_SLICE_EVEN_ENABLE(~0u)},
	{"SLICE_ODD_ENABLE", S_028358_SLICE_ODD_ENABLE(~0u)},
};

static const struct si_field r_028424_cb_dcc_control__fields[] = {
	{"OVERWRITE_COMBINER_DISABLE", S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{"OVERWRITE_COMBINER_MRT_SHARING_DISABLE", S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{"OVERWRITE_COMBINER_WATERMARK", S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
};

static const char *r_02842c_db_stencil_control__stencilfail__values[] = {
	[V_02842C_STENCIL_KEEP] = "STENCIL_KEEP",
	[V_02842C_STENCIL_ZERO] = "STENCIL_ZERO",
	[V_02842C_STENCIL_ONES] = "STENCIL_ONES",
	[V_02842C_STENCIL_REPLACE_TEST] = "STENCIL_REPLACE_TEST",
	[V_02842C_STENCIL_REPLACE_OP] = "STENCIL_REPLACE_OP",
	[V_02842C_STENCIL_ADD_CLAMP] = "STENCIL_ADD_CLAMP",
	[V_02842C_STENCIL_SUB_CLAMP] = "STENCIL_SUB_CLAMP",
	[V_02842C_STENCIL_INVERT] = "STENCIL_INVERT",
	[V_02842C_STENCIL_ADD_WRAP] = "STENCIL_ADD_WRAP",
	[V_02842C_STENCIL_SUB_WRAP] = "STENCIL_SUB_WRAP",
	[V_02842C_STENCIL_AND] = "STENCIL_AND",
	[V_02842C_STENCIL_OR] = "STENCIL_OR",
	[V_02842C_STENCIL_XOR] = "STENCIL_XOR",
	[V_02842C_STENCIL_NAND] = "STENCIL_NAND",
	[V_02842C_STENCIL_NOR] = "STENCIL_NOR",
	[V_02842C_STENCIL_XNOR] = "STENCIL_XNOR",
};

static const char *r_02842c_db_stencil_control__stencilzpass__values[] = {
	[V_02842C_STENCIL_KEEP] = "STENCIL_KEEP",
	[V_02842C_STENCIL_ZERO] = "STENCIL_ZERO",
	[V_02842C_STENCIL_ONES] = "STENCIL_ONES",
	[V_02842C_STENCIL_REPLACE_TEST] = "STENCIL_REPLACE_TEST",
	[V_02842C_STENCIL_REPLACE_OP] = "STENCIL_REPLACE_OP",
	[V_02842C_STENCIL_ADD_CLAMP] = "STENCIL_ADD_CLAMP",
	[V_02842C_STENCIL_SUB_CLAMP] = "STENCIL_SUB_CLAMP",
	[V_02842C_STENCIL_INVERT] = "STENCIL_INVERT",
	[V_02842C_STENCIL_ADD_WRAP] = "STENCIL_ADD_WRAP",
	[V_02842C_STENCIL_SUB_WRAP] = "STENCIL_SUB_WRAP",
	[V_02842C_STENCIL_AND] = "STENCIL_AND",
	[V_02842C_STENCIL_OR] = "STENCIL_OR",
	[V_02842C_STENCIL_XOR] = "STENCIL_XOR",
	[V_02842C_STENCIL_NAND] = "STENCIL_NAND",
	[V_02842C_STENCIL_NOR] = "STENCIL_NOR",
	[V_02842C_STENCIL_XNOR] = "STENCIL_XNOR",
};

static const char *r_02842c_db_stencil_control__stencilzfail__values[] = {
	[V_02842C_STENCIL_KEEP] = "STENCIL_KEEP",
	[V_02842C_STENCIL_ZERO] = "STENCIL_ZERO",
	[V_02842C_STENCIL_ONES] = "STENCIL_ONES",
	[V_02842C_STENCIL_REPLACE_TEST] = "STENCIL_REPLACE_TEST",
	[V_02842C_STENCIL_REPLACE_OP] = "STENCIL_REPLACE_OP",
	[V_02842C_STENCIL_ADD_CLAMP] = "STENCIL_ADD_CLAMP",
	[V_02842C_STENCIL_SUB_CLAMP] = "STENCIL_SUB_CLAMP",
	[V_02842C_STENCIL_INVERT] = "STENCIL_INVERT",
	[V_02842C_STENCIL_ADD_WRAP] = "STENCIL_ADD_WRAP",
	[V_02842C_STENCIL_SUB_WRAP] = "STENCIL_SUB_WRAP",
	[V_02842C_STENCIL_AND] = "STENCIL_AND",
	[V_02842C_STENCIL_OR] = "STENCIL_OR",
	[V_02842C_STENCIL_XOR] = "STENCIL_XOR",
	[V_02842C_STENCIL_NAND] = "STENCIL_NAND",
	[V_02842C_STENCIL_NOR] = "STENCIL_NOR",
	[V_02842C_STENCIL_XNOR] = "STENCIL_XNOR",
};

static const char *r_02842c_db_stencil_control__stencilfail_bf__values[] = {
	[V_02842C_STENCIL_KEEP] = "STENCIL_KEEP",
	[V_02842C_STENCIL_ZERO] = "STENCIL_ZERO",
	[V_02842C_STENCIL_ONES] = "STENCIL_ONES",
	[V_02842C_STENCIL_REPLACE_TEST] = "STENCIL_REPLACE_TEST",
	[V_02842C_STENCIL_REPLACE_OP] = "STENCIL_REPLACE_OP",
	[V_02842C_STENCIL_ADD_CLAMP] = "STENCIL_ADD_CLAMP",
	[V_02842C_STENCIL_SUB_CLAMP] = "STENCIL_SUB_CLAMP",
	[V_02842C_STENCIL_INVERT] = "STENCIL_INVERT",
	[V_02842C_STENCIL_ADD_WRAP] = "STENCIL_ADD_WRAP",
	[V_02842C_STENCIL_SUB_WRAP] = "STENCIL_SUB_WRAP",
	[V_02842C_STENCIL_AND] = "STENCIL_AND",
	[V_02842C_STENCIL_OR] = "STENCIL_OR",
	[V_02842C_STENCIL_XOR] = "STENCIL_XOR",
	[V_02842C_STENCIL_NAND] = "STENCIL_NAND",
	[V_02842C_STENCIL_NOR] = "STENCIL_NOR",
	[V_02842C_STENCIL_XNOR] = "STENCIL_XNOR",
};

static const char *r_02842c_db_stencil_control__stencilzpass_bf__values[] = {
	[V_02842C_STENCIL_KEEP] = "STENCIL_KEEP",
	[V_02842C_STENCIL_ZERO] = "STENCIL_ZERO",
	[V_02842C_STENCIL_ONES] = "STENCIL_ONES",
	[V_02842C_STENCIL_REPLACE_TEST] = "STENCIL_REPLACE_TEST",
	[V_02842C_STENCIL_REPLACE_OP] = "STENCIL_REPLACE_OP",
	[V_02842C_STENCIL_ADD_CLAMP] = "STENCIL_ADD_CLAMP",
	[V_02842C_STENCIL_SUB_CLAMP] = "STENCIL_SUB_CLAMP",
	[V_02842C_STENCIL_INVERT] = "STENCIL_INVERT",
	[V_02842C_STENCIL_ADD_WRAP] = "STENCIL_ADD_WRAP",
	[V_02842C_STENCIL_SUB_WRAP] = "STENCIL_SUB_WRAP",
	[V_02842C_STENCIL_AND] = "STENCIL_AND",
	[V_02842C_STENCIL_OR] = "STENCIL_OR",
	[V_02842C_STENCIL_XOR] = "STENCIL_XOR",
	[V_02842C_STENCIL_NAND] = "STENCIL_NAND",
	[V_02842C_STENCIL_NOR] = "STENCIL_NOR",
	[V_02842C_STENCIL_XNOR] = "STENCIL_XNOR",
};

static const char *r_02842c_db_stencil_control__stencilzfail_bf__values[] = {
	[V_02842C_STENCIL_KEEP] = "STENCIL_KEEP",
	[V_02842C_STENCIL_ZERO] = "STENCIL_ZERO",
	[V_02842C_STENCIL_ONES] = "STENCIL_ONES",
	[V_02842C_STENCIL_REPLACE_TEST] = "STENCIL_REPLACE_TEST",
	[V_02842C_STENCIL_REPLACE_OP] = "STENCIL_REPLACE_OP",
	[V_02842C_STENCIL_ADD_CLAMP] = "STENCIL_ADD_CLAMP",
	[V_02842C_STENCIL_SUB_CLAMP] = "STENCIL_SUB_CLAMP",
	[V_02842C_STENCIL_INVERT] = "STENCIL_INVERT",
	[V_02842C_STENCIL_ADD_WRAP] = "STENCIL_ADD_WRAP",
	[V_02842C_STENCIL_SUB_WRAP] = "STENCIL_SUB_WRAP",
	[V_02842C_STENCIL_AND] = "STENCIL_AND",
	[V_02842C_STENCIL_OR] = "STENCIL_OR",
	[V_02842C_STENCIL_XOR] = "STENCIL_XOR",
	[V_02842C_STENCIL_NAND] = "STENCIL_NAND",
	[V_02842C_STENCIL_NOR] = "STENCIL_NOR",
	[V_02842C_STENCIL_XNOR] = "STENCIL_XNOR",
};

static const struct si_field r_02842c_db_stencil_control__fields[] = {
	{"STENCILFAIL", S_02842C_STENCILFAIL(~0u), ARRAY_SIZE(r_02842c_db_stencil_control__stencilfail__values), r_02842c_db_stencil_control__stencilfail__values},
	{"STENCILZPASS", S_02842C_STENCILZPASS(~0u), ARRAY_SIZE(r_02842c_db_stencil_control__stencilzpass__values), r_02842c_db_stencil_control__stencilzpass__values},
	{"STENCILZFAIL", S_02842C_STENCILZFAIL(~0u), ARRAY_SIZE(r_02842c_db_stencil_control__stencilzfail__values), r_02842c_db_stencil_control__stencilzfail__values},
	{"STENCILFAIL_BF", S_02842C_STENCILFAIL_BF(~0u), ARRAY_SIZE(r_02842c_db_stencil_control__stencilfail_bf__values), r_02842c_db_stencil_control__stencilfail_bf__values},
	{"STENCILZPASS_BF", S_02842C_STENCILZPASS_BF(~0u), ARRAY_SIZE(r_02842c_db_stencil_control__stencilzpass_bf__values), r_02842c_db_stencil_control__stencilzpass_bf__values},
	{"STENCILZFAIL_BF", S_02842C_STENCILZFAIL_BF(~0u), ARRAY_SIZE(r_02842c_db_stencil_control__stencilzfail_bf__values), r_02842c_db_stencil_control__stencilzfail_bf__values},
};

static const struct si_field r_028430_db_stencilrefmask__fields[] = {
	{"STENCILTESTVAL", S_028430_STENCILTESTVAL(~0u)},
	{"STENCILMASK", S_028430_STENCILMASK(~0u)},
	{"STENCILWRITEMASK", S_028430_STENCILWRITEMASK(~0u)},
	{"STENCILOPVAL", S_028430_STENCILOPVAL(~0u)},
};

static const struct si_field r_028434_db_stencilrefmask_bf__fields[] = {
	{"STENCILTESTVAL_BF", S_028434_STENCILTESTVAL_BF(~0u)},
	{"STENCILMASK_BF", S_028434_STENCILMASK_BF(~0u)},
	{"STENCILWRITEMASK_BF", S_028434_STENCILWRITEMASK_BF(~0u)},
	{"STENCILOPVAL_BF", S_028434_STENCILOPVAL_BF(~0u)},
};

static const char *r_028644_spi_ps_input_cntl_0__default_val__values[] = {
	[V_028644_X_0_0F] = "X_0_0F",
};

static const struct si_field r_028644_spi_ps_input_cntl_0__fields[] = {
	{"OFFSET", S_028644_OFFSET(~0u)},
	{"DEFAULT_VAL", S_028644_DEFAULT_VAL(~0u), ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__default_val__values), r_028644_spi_ps_input_cntl_0__default_val__values},
	{"FLAT_SHADE", S_028644_FLAT_SHADE(~0u)},
	{"CYL_WRAP", S_028644_CYL_WRAP(~0u)},
	{"PT_SPRITE_TEX", S_028644_PT_SPRITE_TEX(~0u)},
	{"DUP", S_028644_DUP(~0u)},
	{"FP16_INTERP_MODE", S_028644_FP16_INTERP_MODE(~0u)},
	{"USE_DEFAULT_ATTR1", S_028644_USE_DEFAULT_ATTR1(~0u)},
	{"DEFAULT_VAL_ATTR1", S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{"PT_SPRITE_TEX_ATTR1", S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{"ATTR0_VALID", S_028644_ATTR0_VALID(~0u)},
	{"ATTR1_VALID", S_028644_ATTR1_VALID(~0u)},
};

static const struct si_field r_0286c4_spi_vs_out_config__fields[] = {
	{"VS_EXPORT_COUNT", S_0286C4_VS_EXPORT_COUNT(~0u)},
	{"VS_HALF_PACK", S_0286C4_VS_HALF_PACK(~0u)},
	{"VS_EXPORTS_FOG", S_0286C4_VS_EXPORTS_FOG(~0u)},
	{"VS_OUT_FOG_VEC_ADDR", S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
};

static const struct si_field r_0286cc_spi_ps_input_ena__fields[] = {
	{"PERSP_SAMPLE_ENA", S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{"PERSP_CENTER_ENA", S_0286CC_PERSP_CENTER_ENA(~0u)},
	{"PERSP_CENTROID_ENA", S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{"PERSP_PULL_MODEL_ENA", S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{"LINEAR_SAMPLE_ENA", S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{"LINEAR_CENTER_ENA", S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{"LINEAR_CENTROID_ENA", S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{"LINE_STIPPLE_TEX_ENA", S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{"POS_X_FLOAT_ENA", S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{"POS_Y_FLOAT_ENA", S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{"POS_Z_FLOAT_ENA", S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{"POS_W_FLOAT_ENA", S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{"FRONT_FACE_ENA", S_0286CC_FRONT_FACE_ENA(~0u)},
	{"ANCILLARY_ENA", S_0286CC_ANCILLARY_ENA(~0u)},
	{"SAMPLE_COVERAGE_ENA", S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{"POS_FIXED_PT_ENA", S_0286CC_POS_FIXED_PT_ENA(~0u)},
};

static const struct si_field r_0286d0_spi_ps_input_addr__fields[] = {
	{"PERSP_SAMPLE_ENA", S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{"PERSP_CENTER_ENA", S_0286D0_PERSP_CENTER_ENA(~0u)},
	{"PERSP_CENTROID_ENA", S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{"PERSP_PULL_MODEL_ENA", S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{"LINEAR_SAMPLE_ENA", S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{"LINEAR_CENTER_ENA", S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{"LINEAR_CENTROID_ENA", S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{"LINE_STIPPLE_TEX_ENA", S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{"POS_X_FLOAT_ENA", S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{"POS_Y_FLOAT_ENA", S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{"POS_Z_FLOAT_ENA", S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{"POS_W_FLOAT_ENA", S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{"FRONT_FACE_ENA", S_0286D0_FRONT_FACE_ENA(~0u)},
	{"ANCILLARY_ENA", S_0286D0_ANCILLARY_ENA(~0u)},
	{"SAMPLE_COVERAGE_ENA", S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{"POS_FIXED_PT_ENA", S_0286D0_POS_FIXED_PT_ENA(~0u)},
};

static const char *r_0286d4_spi_interp_control_0__pnt_sprite_ovrd_x__values[] = {
	[V_0286D4_SPI_PNT_SPRITE_SEL_0] = "SPI_PNT_SPRITE_SEL_0",
	[V_0286D4_SPI_PNT_SPRITE_SEL_1] = "SPI_PNT_SPRITE_SEL_1",
	[V_0286D4_SPI_PNT_SPRITE_SEL_S] = "SPI_PNT_SPRITE_SEL_S",
	[V_0286D4_SPI_PNT_SPRITE_SEL_T] = "SPI_PNT_SPRITE_SEL_T",
	[V_0286D4_SPI_PNT_SPRITE_SEL_NONE] = "SPI_PNT_SPRITE_SEL_NONE",
};

static const char *r_0286d4_spi_interp_control_0__pnt_sprite_ovrd_y__values[] = {
	[V_0286D4_SPI_PNT_SPRITE_SEL_0] = "SPI_PNT_SPRITE_SEL_0",
	[V_0286D4_SPI_PNT_SPRITE_SEL_1] = "SPI_PNT_SPRITE_SEL_1",
	[V_0286D4_SPI_PNT_SPRITE_SEL_S] = "SPI_PNT_SPRITE_SEL_S",
	[V_0286D4_SPI_PNT_SPRITE_SEL_T] = "SPI_PNT_SPRITE_SEL_T",
	[V_0286D4_SPI_PNT_SPRITE_SEL_NONE] = "SPI_PNT_SPRITE_SEL_NONE",
};

static const char *r_0286d4_spi_interp_control_0__pnt_sprite_ovrd_z__values[] = {
	[V_0286D4_SPI_PNT_SPRITE_SEL_0] = "SPI_PNT_SPRITE_SEL_0",
	[V_0286D4_SPI_PNT_SPRITE_SEL_1] = "SPI_PNT_SPRITE_SEL_1",
	[V_0286D4_SPI_PNT_SPRITE_SEL_S] = "SPI_PNT_SPRITE_SEL_S",
	[V_0286D4_SPI_PNT_SPRITE_SEL_T] = "SPI_PNT_SPRITE_SEL_T",
	[V_0286D4_SPI_PNT_SPRITE_SEL_NONE] = "SPI_PNT_SPRITE_SEL_NONE",
};

static const char *r_0286d4_spi_interp_control_0__pnt_sprite_ovrd_w__values[] = {
	[V_0286D4_SPI_PNT_SPRITE_SEL_0] = "SPI_PNT_SPRITE_SEL_0",
	[V_0286D4_SPI_PNT_SPRITE_SEL_1] = "SPI_PNT_SPRITE_SEL_1",
	[V_0286D4_SPI_PNT_SPRITE_SEL_S] = "SPI_PNT_SPRITE_SEL_S",
	[V_0286D4_SPI_PNT_SPRITE_SEL_T] = "SPI_PNT_SPRITE_SEL_T",
	[V_0286D4_SPI_PNT_SPRITE_SEL_NONE] = "SPI_PNT_SPRITE_SEL_NONE",
};

static const struct si_field r_0286d4_spi_interp_control_0__fields[] = {
	{"FLAT_SHADE_ENA", S_0286D4_FLAT_SHADE_ENA(~0u)},
	{"PNT_SPRITE_ENA", S_0286D4_PNT_SPRITE_ENA(~0u)},
	{"PNT_SPRITE_OVRD_X", S_0286D4_PNT_SPRITE_OVRD_X(~0u), ARRAY_SIZE(r_0286d4_spi_interp_control_0__pnt_sprite_ovrd_x__values), r_0286d4_spi_interp_control_0__pnt_sprite_ovrd_x__values},
	{"PNT_SPRITE_OVRD_Y", S_0286D4_PNT_SPRITE_OVRD_Y(~0u), ARRAY_SIZE(r_0286d4_spi_interp_control_0__pnt_sprite_ovrd_y__values), r_0286d4_spi_interp_control_0__pnt_sprite_ovrd_y__values},
	{"PNT_SPRITE_OVRD_Z", S_0286D4_PNT_SPRITE_OVRD_Z(~0u), ARRAY_SIZE(r_0286d4_spi_interp_control_0__pnt_sprite_ovrd_z__values), r_0286d4_spi_interp_control_0__pnt_sprite_ovrd_z__values},
	{"PNT_SPRITE_OVRD_W", S_0286D4_PNT_SPRITE_OVRD_W(~0u), ARRAY_SIZE(r_0286d4_spi_interp_control_0__pnt_sprite_ovrd_w__values), r_0286d4_spi_interp_control_0__pnt_sprite_ovrd_w__values},
	{"PNT_SPRITE_TOP_1", S_0286D4_PNT_SPRITE_TOP_1(~0u)},
};

static const struct si_field r_0286d8_spi_ps_in_control__fields[] = {
	{"NUM_INTERP", S_0286D8_NUM_INTERP(~0u)},
	{"PARAM_GEN", S_0286D8_PARAM_GEN(~0u)},
	{"FOG_ADDR", S_0286D8_FOG_ADDR(~0u)},
	{"BC_OPTIMIZE_DISABLE", S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{"PASS_FOG_THROUGH_PS", S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
};

static const char *r_0286e0_spi_baryc_cntl__pos_float_location__values[] = {
	[V_0286E0_X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT] = "X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT",
};

static const struct si_field r_0286e0_spi_baryc_cntl__fields[] = {
	{"PERSP_CENTER_CNTL", S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{"PERSP_CENTROID_CNTL", S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{"LINEAR_CENTER_CNTL", S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{"LINEAR_CENTROID_CNTL", S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{"POS_FLOAT_LOCATION", S_0286E0_POS_FLOAT_LOCATION(~0u), ARRAY_SIZE(r_0286e0_spi_baryc_cntl__pos_float_location__values), r_0286e0_spi_baryc_cntl__pos_float_location__values},
	{"POS_FLOAT_ULC", S_0286E0_POS_FLOAT_ULC(~0u)},
	{"FRONT_FACE_ALL_BITS", S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
};

static const struct si_field r_0286e8_spi_tmpring_size__fields[] = {
	{"WAVES", S_0286E8_WAVES(~0u)},
	{"WAVESIZE", S_0286E8_WAVESIZE(~0u)},
};

static const struct si_field r_028704_spi_wave_mgmt_1__fields[] = {
	{"NUM_PS_WAVES", S_028704_NUM_PS_WAVES(~0u)},
	{"NUM_VS_WAVES", S_028704_NUM_VS_WAVES(~0u)},
	{"NUM_GS_WAVES", S_028704_NUM_GS_WAVES(~0u)},
	{"NUM_ES_WAVES", S_028704_NUM_ES_WAVES(~0u)},
	{"NUM_HS_WAVES", S_028704_NUM_HS_WAVES(~0u)},
};

static const struct si_field r_028708_spi_wave_mgmt_2__fields[] = {
	{"NUM_LS_WAVES", S_028708_NUM_LS_WAVES(~0u)},
};

static const char *r_02870c_spi_shader_pos_format__pos0_export_format__values[] = {
	[V_02870C_SPI_SHADER_NONE] = "SPI_SHADER_NONE",
	[V_02870C_SPI_SHADER_1COMP] = "SPI_SHADER_1COMP",
	[V_02870C_SPI_SHADER_2COMP] = "SPI_SHADER_2COMP",
	[V_02870C_SPI_SHADER_4COMPRESS] = "SPI_SHADER_4COMPRESS",
	[V_02870C_SPI_SHADER_4COMP] = "SPI_SHADER_4COMP",
};

static const char *r_02870c_spi_shader_pos_format__pos1_export_format__values[] = {
	[V_02870C_SPI_SHADER_NONE] = "SPI_SHADER_NONE",
	[V_02870C_SPI_SHADER_1COMP] = "SPI_SHADER_1COMP",
	[V_02870C_SPI_SHADER_2COMP] = "SPI_SHADER_2COMP",
	[V_02870C_SPI_SHADER_4COMPRESS] = "SPI_SHADER_4COMPRESS",
	[V_02870C_SPI_SHADER_4COMP] = "SPI_SHADER_4COMP",
};

static const char *r_02870c_spi_shader_pos_format__pos2_export_format__values[] = {
	[V_02870C_SPI_SHADER_NONE] = "SPI_SHADER_NONE",
	[V_02870C_SPI_SHADER_1COMP] = "SPI_SHADER_1COMP",
	[V_02870C_SPI_SHADER_2COMP] = "SPI_SHADER_2COMP",
	[V_02870C_SPI_SHADER_4COMPRESS] = "SPI_SHADER_4COMPRESS",
	[V_02870C_SPI_SHADER_4COMP] = "SPI_SHADER_4COMP",
};

static const char *r_02870c_spi_shader_pos_format__pos3_export_format__values[] = {
	[V_02870C_SPI_SHADER_NONE] = "SPI_SHADER_NONE",
	[V_02870C_SPI_SHADER_1COMP] = "SPI_SHADER_1COMP",
	[V_02870C_SPI_SHADER_2COMP] = "SPI_SHADER_2COMP",
	[V_02870C_SPI_SHADER_4COMPRESS] = "SPI_SHADER_4COMPRESS",
	[V_02870C_SPI_SHADER_4COMP] = "SPI_SHADER_4COMP",
};

static const struct si_field r_02870c_spi_shader_pos_format__fields[] = {
	{"POS0_EXPORT_FORMAT", S_02870C_POS0_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_02870c_spi_shader_pos_format__pos0_export_format__values), r_02870c_spi_shader_pos_format__pos0_export_format__values},
	{"POS1_EXPORT_FORMAT", S_02870C_POS1_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_02870c_spi_shader_pos_format__pos1_export_format__values), r_02870c_spi_shader_pos_format__pos1_export_format__values},
	{"POS2_EXPORT_FORMAT", S_02870C_POS2_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_02870c_spi_shader_pos_format__pos2_export_format__values), r_02870c_spi_shader_pos_format__pos2_export_format__values},
	{"POS3_EXPORT_FORMAT", S_02870C_POS3_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_02870c_spi_shader_pos_format__pos3_export_format__values), r_02870c_spi_shader_pos_format__pos3_export_format__values},
};

static const char *r_028710_spi_shader_z_format__z_export_format__values[] = {
	[V_028710_SPI_SHADER_ZERO] = "SPI_SHADER_ZERO",
	[V_028710_SPI_SHADER_32_R] = "SPI_SHADER_32_R",
	[V_028710_SPI_SHADER_32_GR] = "SPI_SHADER_32_GR",
	[V_028710_SPI_SHADER_32_AR] = "SPI_SHADER_32_AR",
	[V_028710_SPI_SHADER_FP16_ABGR] = "SPI_SHADER_FP16_ABGR",
	[V_028710_SPI_SHADER_UNORM16_ABGR] = "SPI_SHADER_UNORM16_ABGR",
	[V_028710_SPI_SHADER_SNORM16_ABGR] = "SPI_SHADER_SNORM16_ABGR",
	[V_028710_SPI_SHADER_UINT16_ABGR] = "SPI_SHADER_UINT16_ABGR",
	[V_028710_SPI_SHADER_SINT16_ABGR] = "SPI_SHADER_SINT16_ABGR",
	[V_028710_SPI_SHADER_32_ABGR] = "SPI_SHADER_32_ABGR",
};

static const struct si_field r_028710_spi_shader_z_format__fields[] = {
	{"Z_EXPORT_FORMAT", S_028710_Z_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_028710_spi_shader_z_format__z_export_format__values), r_028710_spi_shader_z_format__z_export_format__values},
};

static const char *r_028714_spi_shader_col_format__col0_export_format__values[] = {
	[V_028714_SPI_SHADER_ZERO] = "SPI_SHADER_ZERO",
	[V_028714_SPI_SHADER_32_R] = "SPI_SHADER_32_R",
	[V_028714_SPI_SHADER_32_GR] = "SPI_SHADER_32_GR",
	[V_028714_SPI_SHADER_32_AR] = "SPI_SHADER_32_AR",
	[V_028714_SPI_SHADER_FP16_ABGR] = "SPI_SHADER_FP16_ABGR",
	[V_028714_SPI_SHADER_UNORM16_ABGR] = "SPI_SHADER_UNORM16_ABGR",
	[V_028714_SPI_SHADER_SNORM16_ABGR] = "SPI_SHADER_SNORM16_ABGR",
	[V_028714_SPI_SHADER_UINT16_ABGR] = "SPI_SHADER_UINT16_ABGR",
	[V_028714_SPI_SHADER_SINT16_ABGR] = "SPI_SHADER_SINT16_ABGR",
	[V_028714_SPI_SHADER_32_ABGR] = "SPI_SHADER_32_ABGR",
};

static const char *r_028714_spi_shader_col_format__col1_export_format__values[] = {
	[V_028714_SPI_SHADER_ZERO] = "SPI_SHADER_ZERO",
	[V_028714_SPI_SHADER_32_R] = "SPI_SHADER_32_R",
	[V_028714_SPI_SHADER_32_GR] = "SPI_SHADER_32_GR",
	[V_028714_SPI_SHADER_32_AR] = "SPI_SHADER_32_AR",
	[V_028714_SPI_SHADER_FP16_ABGR] = "SPI_SHADER_FP16_ABGR",
	[V_028714_SPI_SHADER_UNORM16_ABGR] = "SPI_SHADER_UNORM16_ABGR",
	[V_028714_SPI_SHADER_SNORM16_ABGR] = "SPI_SHADER_SNORM16_ABGR",
	[V_028714_SPI_SHADER_UINT16_ABGR] = "SPI_SHADER_UINT16_ABGR",
	[V_028714_SPI_SHADER_SINT16_ABGR] = "SPI_SHADER_SINT16_ABGR",
	[V_028714_SPI_SHADER_32_ABGR] = "SPI_SHADER_32_ABGR",
};

static const char *r_028714_spi_shader_col_format__col2_export_format__values[] = {
	[V_028714_SPI_SHADER_ZERO] = "SPI_SHADER_ZERO",
	[V_028714_SPI_SHADER_32_R] = "SPI_SHADER_32_R",
	[V_028714_SPI_SHADER_32_GR] = "SPI_SHADER_32_GR",
	[V_028714_SPI_SHADER_32_AR] = "SPI_SHADER_32_AR",
	[V_028714_SPI_SHADER_FP16_ABGR] = "SPI_SHADER_FP16_ABGR",
	[V_028714_SPI_SHADER_UNORM16_ABGR] = "SPI_SHADER_UNORM16_ABGR",
	[V_028714_SPI_SHADER_SNORM16_ABGR] = "SPI_SHADER_SNORM16_ABGR",
	[V_028714_SPI_SHADER_UINT16_ABGR] = "SPI_SHADER_UINT16_ABGR",
	[V_028714_SPI_SHADER_SINT16_ABGR] = "SPI_SHADER_SINT16_ABGR",
	[V_028714_SPI_SHADER_32_ABGR] = "SPI_SHADER_32_ABGR",
};

static const char *r_028714_spi_shader_col_format__col3_export_format__values[] = {
	[V_028714_SPI_SHADER_ZERO] = "SPI_SHADER_ZERO",
	[V_028714_SPI_SHADER_32_R] = "SPI_SHADER_32_R",
	[V_028714_SPI_SHADER_32_GR] = "SPI_SHADER_32_GR",
	[V_028714_SPI_SHADER_32_AR] = "SPI_SHADER_32_AR",
	[V_028714_SPI_SHADER_FP16_ABGR] = "SPI_SHADER_FP16_ABGR",
	[V_028714_SPI_SHADER_UNORM16_ABGR] = "SPI_SHADER_UNORM16_ABGR",
	[V_028714_SPI_SHADER_SNORM16_ABGR] = "SPI_SHADER_SNORM16_ABGR",
	[V_028714_SPI_SHADER_UINT16_ABGR] = "SPI_SHADER_UINT16_ABGR",
	[V_028714_SPI_SHADER_SINT16_ABGR] = "SPI_SHADER_SINT16_ABGR",
	[V_028714_SPI_SHADER_32_ABGR] = "SPI_SHADER_32_ABGR",
};

static const char *r_028714_spi_shader_col_format__col4_export_format__values[] = {
	[V_028714_SPI_SHADER_ZERO] = "SPI_SHADER_ZERO",
	[V_028714_SPI_SHADER_32_R] = "SPI_SHADER_32_R",
	[V_028714_SPI_SHADER_32_GR] = "SPI_SHADER_32_GR",
	[V_028714_SPI_SHADER_32_AR] = "SPI_SHADER_32_AR",
	[V_028714_SPI_SHADER_FP16_ABGR] = "SPI_SHADER_FP16_ABGR",
	[V_028714_SPI_SHADER_UNORM16_ABGR] = "SPI_SHADER_UNORM16_ABGR",
	[V_028714_SPI_SHADER_SNORM16_ABGR] = "SPI_SHADER_SNORM16_ABGR",
	[V_028714_SPI_SHADER_UINT16_ABGR] = "SPI_SHADER_UINT16_ABGR",
	[V_028714_SPI_SHADER_SINT16_ABGR] = "SPI_SHADER_SINT16_ABGR",
	[V_028714_SPI_SHADER_32_ABGR] = "SPI_SHADER_32_ABGR",
};

static const char *r_028714_spi_shader_col_format__col5_export_format__values[] = {
	[V_028714_SPI_SHADER_ZERO] = "SPI_SHADER_ZERO",
	[V_028714_SPI_SHADER_32_R] = "SPI_SHADER_32_R",
	[V_028714_SPI_SHADER_32_GR] = "SPI_SHADER_32_GR",
	[V_028714_SPI_SHADER_32_AR] = "SPI_SHADER_32_AR",
	[V_028714_SPI_SHADER_FP16_ABGR] = "SPI_SHADER_FP16_ABGR",
	[V_028714_SPI_SHADER_UNORM16_ABGR] = "SPI_SHADER_UNORM16_ABGR",
	[V_028714_SPI_SHADER_SNORM16_ABGR] = "SPI_SHADER_SNORM16_ABGR",
	[V_028714_SPI_SHADER_UINT16_ABGR] = "SPI_SHADER_UINT16_ABGR",
	[V_028714_SPI_SHADER_SINT16_ABGR] = "SPI_SHADER_SINT16_ABGR",
	[V_028714_SPI_SHADER_32_ABGR] = "SPI_SHADER_32_ABGR",
};

static const char *r_028714_spi_shader_col_format__col6_export_format__values[] = {
	[V_028714_SPI_SHADER_ZERO] = "SPI_SHADER_ZERO",
	[V_028714_SPI_SHADER_32_R] = "SPI_SHADER_32_R",
	[V_028714_SPI_SHADER_32_GR] = "SPI_SHADER_32_GR",
	[V_028714_SPI_SHADER_32_AR] = "SPI_SHADER_32_AR",
	[V_028714_SPI_SHADER_FP16_ABGR] = "SPI_SHADER_FP16_ABGR",
	[V_028714_SPI_SHADER_UNORM16_ABGR] = "SPI_SHADER_UNORM16_ABGR",
	[V_028714_SPI_SHADER_SNORM16_ABGR] = "SPI_SHADER_SNORM16_ABGR",
	[V_028714_SPI_SHADER_UINT16_ABGR] = "SPI_SHADER_UINT16_ABGR",
	[V_028714_SPI_SHADER_SINT16_ABGR] = "SPI_SHADER_SINT16_ABGR",
	[V_028714_SPI_SHADER_32_ABGR] = "SPI_SHADER_32_ABGR",
};

static const char *r_028714_spi_shader_col_format__col7_export_format__values[] = {
	[V_028714_SPI_SHADER_ZERO] = "SPI_SHADER_ZERO",
	[V_028714_SPI_SHADER_32_R] = "SPI_SHADER_32_R",
	[V_028714_SPI_SHADER_32_GR] = "SPI_SHADER_32_GR",
	[V_028714_SPI_SHADER_32_AR] = "SPI_SHADER_32_AR",
	[V_028714_SPI_SHADER_FP16_ABGR] = "SPI_SHADER_FP16_ABGR",
	[V_028714_SPI_SHADER_UNORM16_ABGR] = "SPI_SHADER_UNORM16_ABGR",
	[V_028714_SPI_SHADER_SNORM16_ABGR] = "SPI_SHADER_SNORM16_ABGR",
	[V_028714_SPI_SHADER_UINT16_ABGR] = "SPI_SHADER_UINT16_ABGR",
	[V_028714_SPI_SHADER_SINT16_ABGR] = "SPI_SHADER_SINT16_ABGR",
	[V_028714_SPI_SHADER_32_ABGR] = "SPI_SHADER_32_ABGR",
};

static const struct si_field r_028714_spi_shader_col_format__fields[] = {
	{"COL0_EXPORT_FORMAT", S_028714_COL0_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_028714_spi_shader_col_format__col0_export_format__values), r_028714_spi_shader_col_format__col0_export_format__values},
	{"COL1_EXPORT_FORMAT", S_028714_COL1_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_028714_spi_shader_col_format__col1_export_format__values), r_028714_spi_shader_col_format__col1_export_format__values},
	{"COL2_EXPORT_FORMAT", S_028714_COL2_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_028714_spi_shader_col_format__col2_export_format__values), r_028714_spi_shader_col_format__col2_export_format__values},
	{"COL3_EXPORT_FORMAT", S_028714_COL3_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_028714_spi_shader_col_format__col3_export_format__values), r_028714_spi_shader_col_format__col3_export_format__values},
	{"COL4_EXPORT_FORMAT", S_028714_COL4_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_028714_spi_shader_col_format__col4_export_format__values), r_028714_spi_shader_col_format__col4_export_format__values},
	{"COL5_EXPORT_FORMAT", S_028714_COL5_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_028714_spi_shader_col_format__col5_export_format__values), r_028714_spi_shader_col_format__col5_export_format__values},
	{"COL6_EXPORT_FORMAT", S_028714_COL6_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_028714_spi_shader_col_format__col6_export_format__values), r_028714_spi_shader_col_format__col6_export_format__values},
	{"COL7_EXPORT_FORMAT", S_028714_COL7_EXPORT_FORMAT(~0u), ARRAY_SIZE(r_028714_spi_shader_col_format__col7_export_format__values), r_028714_spi_shader_col_format__col7_export_format__values},
};

static const char *r_028754_sx_ps_downconvert__mrt0__values[] = {
	[V_028754_SX_RT_EXPORT_NO_CONVERSION] = "SX_RT_EXPORT_NO_CONVERSION",
	[V_028754_SX_RT_EXPORT_32_R] = "SX_RT_EXPORT_32_R",
	[V_028754_SX_RT_EXPORT_32_A] = "SX_RT_EXPORT_32_A",
	[V_028754_SX_RT_EXPORT_10_11_11] = "SX_RT_EXPORT_10_11_11",
	[V_028754_SX_RT_EXPORT_2_10_10_10] = "SX_RT_EXPORT_2_10_10_10",
	[V_028754_SX_RT_EXPORT_8_8_8_8] = "SX_RT_EXPORT_8_8_8_8",
	[V_028754_SX_RT_EXPORT_5_6_5] = "SX_RT_EXPORT_5_6_5",
	[V_028754_SX_RT_EXPORT_1_5_5_5] = "SX_RT_EXPORT_1_5_5_5",
	[V_028754_SX_RT_EXPORT_4_4_4_4] = "SX_RT_EXPORT_4_4_4_4",
	[V_028754_SX_RT_EXPORT_16_16_GR] = "SX_RT_EXPORT_16_16_GR",
	[V_028754_SX_RT_EXPORT_16_16_AR] = "SX_RT_EXPORT_16_16_AR",
};

static const struct si_field r_028754_sx_ps_downconvert__fields[] = {
	{"MRT0", S_028754_MRT0(~0u), ARRAY_SIZE(r_028754_sx_ps_downconvert__mrt0__values), r_028754_sx_ps_downconvert__mrt0__values},
	{"MRT1", S_028754_MRT1(~0u)},
	{"MRT2", S_028754_MRT2(~0u)},
	{"MRT3", S_028754_MRT3(~0u)},
	{"MRT4", S_028754_MRT4(~0u)},
	{"MRT5", S_028754_MRT5(~0u)},
	{"MRT6", S_028754_MRT6(~0u)},
	{"MRT7", S_028754_MRT7(~0u)},
};

static const char *r_028758_sx_blend_opt_epsilon__mrt0_epsilon__values[] = {
	[V_028758_EXACT] = "EXACT",
	[V_028758_11BIT_FORMAT] = "11BIT_FORMAT",
	[V_028758_10BIT_FORMAT] = "10BIT_FORMAT",
	[V_028758_8BIT_FORMAT] = "8BIT_FORMAT",
	[V_028758_6BIT_FORMAT] = "6BIT_FORMAT",
	[V_028758_5BIT_FORMAT] = "5BIT_FORMAT",
	[V_028758_4BIT_FORMAT] = "4BIT_FORMAT",
};

static const struct si_field r_028758_sx_blend_opt_epsilon__fields[] = {
	{"MRT0_EPSILON", S_028758_MRT0_EPSILON(~0u), ARRAY_SIZE(r_028758_sx_blend_opt_epsilon__mrt0_epsilon__values), r_028758_sx_blend_opt_epsilon__mrt0_epsilon__values},
	{"MRT1_EPSILON", S_028758_MRT1_EPSILON(~0u)},
	{"MRT2_EPSILON", S_028758_MRT2_EPSILON(~0u)},
	{"MRT3_EPSILON", S_028758_MRT3_EPSILON(~0u)},
	{"MRT4_EPSILON", S_028758_MRT4_EPSILON(~0u)},
	{"MRT5_EPSILON", S_028758_MRT5_EPSILON(~0u)},
	{"MRT6_EPSILON", S_028758_MRT6_EPSILON(~0u)},
	{"MRT7_EPSILON", S_028758_MRT7_EPSILON(~0u)},
};

static const struct si_field r_02875c_sx_blend_opt_control__fields[] = {
	{"MRT0_COLOR_OPT_DISABLE", S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{"MRT0_ALPHA_OPT_DISABLE", S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{"MRT1_COLOR_OPT_DISABLE", S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{"MRT1_ALPHA_OPT_DISABLE", S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{"MRT2_COLOR_OPT_DISABLE", S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{"MRT2_ALPHA_OPT_DISABLE", S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{"MRT3_COLOR_OPT_DISABLE", S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{"MRT3_ALPHA_OPT_DISABLE", S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{"MRT4_COLOR_OPT_DISABLE", S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{"MRT4_ALPHA_OPT_DISABLE", S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{"MRT5_COLOR_OPT_DISABLE", S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{"MRT5_ALPHA_OPT_DISABLE", S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{"MRT6_COLOR_OPT_DISABLE", S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{"MRT6_ALPHA_OPT_DISABLE", S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{"MRT7_COLOR_OPT_DISABLE", S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{"MRT7_ALPHA_OPT_DISABLE", S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{"PIXEN_ZERO_OPT_DISABLE", S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
};

static const char *r_028760_sx_mrt0_blend_opt__color_src_opt__values[] = {
	[V_028760_BLEND_OPT_PRESERVE_NONE_IGNORE_ALL] = "BLEND_OPT_PRESERVE_NONE_IGNORE_ALL",
	[V_028760_BLEND_OPT_PRESERVE_ALL_IGNORE_NONE] = "BLEND_OPT_PRESERVE_ALL_IGNORE_NONE",
	[V_028760_BLEND_OPT_PRESERVE_C1_IGNORE_C0] = "BLEND_OPT_PRESERVE_C1_IGNORE_C0",
	[V_028760_BLEND_OPT_PRESERVE_C0_IGNORE_C1] = "BLEND_OPT_PRESERVE_C0_IGNORE_C1",
	[V_028760_BLEND_OPT_PRESERVE_A1_IGNORE_A0] = "BLEND_OPT_PRESERVE_A1_IGNORE_A0",
	[V_028760_BLEND_OPT_PRESERVE_A0_IGNORE_A1] = "BLEND_OPT_PRESERVE_A0_IGNORE_A1",
	[V_028760_BLEND_OPT_PRESERVE_NONE_IGNORE_A0] = "BLEND_OPT_PRESERVE_NONE_IGNORE_A0",
	[V_028760_BLEND_OPT_PRESERVE_NONE_IGNORE_NONE] = "BLEND_OPT_PRESERVE_NONE_IGNORE_NONE",
};

static const char *r_028760_sx_mrt0_blend_opt__color_comb_fcn__values[] = {
	[V_028760_OPT_COMB_NONE] = "OPT_COMB_NONE",
	[V_028760_OPT_COMB_ADD] = "OPT_COMB_ADD",
	[V_028760_OPT_COMB_SUBTRACT] = "OPT_COMB_SUBTRACT",
	[V_028760_OPT_COMB_MIN] = "OPT_COMB_MIN",
	[V_028760_OPT_COMB_MAX] = "OPT_COMB_MAX",
	[V_028760_OPT_COMB_REVSUBTRACT] = "OPT_COMB_REVSUBTRACT",
	[V_028760_OPT_COMB_BLEND_DISABLED] = "OPT_COMB_BLEND_DISABLED",
	[V_028760_OPT_COMB_SAFE_ADD] = "OPT_COMB_SAFE_ADD",
};

static const struct si_field r_028760_sx_mrt0_blend_opt__fields[] = {
	{"COLOR_SRC_OPT", S_028760_COLOR_SRC_OPT(~0u), ARRAY_SIZE(r_028760_sx_mrt0_blend_opt__color_src_opt__values), r_028760_sx_mrt0_blend_opt__color_src_opt__values},
	{"COLOR_DST_OPT", S_028760_COLOR_DST_OPT(~0u)},
	{"COLOR_COMB_FCN", S_028760_COLOR_COMB_FCN(~0u), ARRAY_SIZE(r_028760_sx_mrt0_blend_opt__color_comb_fcn__values), r_028760_sx_mrt0_blend_opt__color_comb_fcn__values},
	{"ALPHA_SRC_OPT", S_028760_ALPHA_SRC_OPT(~0u)},
	{"ALPHA_DST_OPT", S_028760_ALPHA_DST_OPT(~0u)},
	{"ALPHA_COMB_FCN", S_028760_ALPHA_COMB_FCN(~0u)},
};

static const struct si_field r_028764_sx_mrt1_blend_opt__fields[] = {
	{"COLOR_SRC_OPT", S_028764_COLOR_SRC_OPT(~0u)},
	{"COLOR_DST_OPT", S_028764_COLOR_DST_OPT(~0u)},
	{"COLOR_COMB_FCN", S_028764_COLOR_COMB_FCN(~0u)},
	{"ALPHA_SRC_OPT", S_028764_ALPHA_SRC_OPT(~0u)},
	{"ALPHA_DST_OPT", S_028764_ALPHA_DST_OPT(~0u)},
	{"ALPHA_COMB_FCN", S_028764_ALPHA_COMB_FCN(~0u)},
};

static const struct si_field r_028768_sx_mrt2_blend_opt__fields[] = {
	{"COLOR_SRC_OPT", S_028768_COLOR_SRC_OPT(~0u)},
	{"COLOR_DST_OPT", S_028768_COLOR_DST_OPT(~0u)},
	{"COLOR_COMB_FCN", S_028768_COLOR_COMB_FCN(~0u)},
	{"ALPHA_SRC_OPT", S_028768_ALPHA_SRC_OPT(~0u)},
	{"ALPHA_DST_OPT", S_028768_ALPHA_DST_OPT(~0u)},
	{"ALPHA_COMB_FCN", S_028768_ALPHA_COMB_FCN(~0u)},
};

static const struct si_field r_02876c_sx_mrt3_blend_opt__fields[] = {
	{"COLOR_SRC_OPT", S_02876C_COLOR_SRC_OPT(~0u)},
	{"COLOR_DST_OPT", S_02876C_COLOR_DST_OPT(~0u)},
	{"COLOR_COMB_FCN", S_02876C_COLOR_COMB_FCN(~0u)},
	{"ALPHA_SRC_OPT", S_02876C_ALPHA_SRC_OPT(~0u)},
	{"ALPHA_DST_OPT", S_02876C_ALPHA_DST_OPT(~0u)},
	{"ALPHA_COMB_FCN", S_02876C_ALPHA_COMB_FCN(~0u)},
};

static const struct si_field r_028770_sx_mrt4_blend_opt__fields[] = {
	{"COLOR_SRC_OPT", S_028770_COLOR_SRC_OPT(~0u)},
	{"COLOR_DST_OPT", S_028770_COLOR_DST_OPT(~0u)},
	{"COLOR_COMB_FCN", S_028770_COLOR_COMB_FCN(~0u)},
	{"ALPHA_SRC_OPT", S_028770_ALPHA_SRC_OPT(~0u)},
	{"ALPHA_DST_OPT", S_028770_ALPHA_DST_OPT(~0u)},
	{"ALPHA_COMB_FCN", S_028770_ALPHA_COMB_FCN(~0u)},
};

static const struct si_field r_028774_sx_mrt5_blend_opt__fields[] = {
	{"COLOR_SRC_OPT", S_028774_COLOR_SRC_OPT(~0u)},
	{"COLOR_DST_OPT", S_028774_COLOR_DST_OPT(~0u)},
	{"COLOR_COMB_FCN", S_028774_COLOR_COMB_FCN(~0u)},
	{"ALPHA_SRC_OPT", S_028774_ALPHA_SRC_OPT(~0u)},
	{"ALPHA_DST_OPT", S_028774_ALPHA_DST_OPT(~0u)},
	{"ALPHA_COMB_FCN", S_028774_ALPHA_COMB_FCN(~0u)},
};

static const struct si_field r_028778_sx_mrt6_blend_opt__fields[] = {
	{"COLOR_SRC_OPT", S_028778_COLOR_SRC_OPT(~0u)},
	{"COLOR_DST_OPT", S_028778_COLOR_DST_OPT(~0u)},
	{"COLOR_COMB_FCN", S_028778_COLOR_COMB_FCN(~0u)},
	{"ALPHA_SRC_OPT", S_028778_ALPHA_SRC_OPT(~0u)},
	{"ALPHA_DST_OPT", S_028778_ALPHA_DST_OPT(~0u)},
	{"ALPHA_COMB_FCN", S_028778_ALPHA_COMB_FCN(~0u)},
};

static const struct si_field r_02877c_sx_mrt7_blend_opt__fields[] = {
	{"COLOR_SRC_OPT", S_02877C_COLOR_SRC_OPT(~0u)},
	{"COLOR_DST_OPT", S_02877C_COLOR_DST_OPT(~0u)},
	{"COLOR_COMB_FCN", S_02877C_COLOR_COMB_FCN(~0u)},
	{"ALPHA_SRC_OPT", S_02877C_ALPHA_SRC_OPT(~0u)},
	{"ALPHA_DST_OPT", S_02877C_ALPHA_DST_OPT(~0u)},
	{"ALPHA_COMB_FCN", S_02877C_ALPHA_COMB_FCN(~0u)},
};

static const char *r_028780_cb_blend0_control__color_srcblend__values[] = {
	[V_028780_BLEND_ZERO] = "BLEND_ZERO",
	[V_028780_BLEND_ONE] = "BLEND_ONE",
	[V_028780_BLEND_SRC_COLOR] = "BLEND_SRC_COLOR",
	[V_028780_BLEND_ONE_MINUS_SRC_COLOR] = "BLEND_ONE_MINUS_SRC_COLOR",
	[V_028780_BLEND_SRC_ALPHA] = "BLEND_SRC_ALPHA",
	[V_028780_BLEND_ONE_MINUS_SRC_ALPHA] = "BLEND_ONE_MINUS_SRC_ALPHA",
	[V_028780_BLEND_DST_ALPHA] = "BLEND_DST_ALPHA",
	[V_028780_BLEND_ONE_MINUS_DST_ALPHA] = "BLEND_ONE_MINUS_DST_ALPHA",
	[V_028780_BLEND_DST_COLOR] = "BLEND_DST_COLOR",
	[V_028780_BLEND_ONE_MINUS_DST_COLOR] = "BLEND_ONE_MINUS_DST_COLOR",
	[V_028780_BLEND_SRC_ALPHA_SATURATE] = "BLEND_SRC_ALPHA_SATURATE",
	[V_028780_BLEND_CONSTANT_COLOR] = "BLEND_CONSTANT_COLOR",
	[V_028780_BLEND_ONE_MINUS_CONSTANT_COLOR] = "BLEND_ONE_MINUS_CONSTANT_COLOR",
	[V_028780_BLEND_SRC1_COLOR] = "BLEND_SRC1_COLOR",
	[V_028780_BLEND_INV_SRC1_COLOR] = "BLEND_INV_SRC1_COLOR",
	[V_028780_BLEND_SRC1_ALPHA] = "BLEND_SRC1_ALPHA",
	[V_028780_BLEND_INV_SRC1_ALPHA] = "BLEND_INV_SRC1_ALPHA",
	[V_028780_BLEND_CONSTANT_ALPHA] = "BLEND_CONSTANT_ALPHA",
	[V_028780_BLEND_ONE_MINUS_CONSTANT_ALPHA] = "BLEND_ONE_MINUS_CONSTANT_ALPHA",
};

static const char *r_028780_cb_blend0_control__color_comb_fcn__values[] = {
	[V_028780_COMB_DST_PLUS_SRC] = "COMB_DST_PLUS_SRC",
	[V_028780_COMB_SRC_MINUS_DST] = "COMB_SRC_MINUS_DST",
	[V_028780_COMB_MIN_DST_SRC] = "COMB_MIN_DST_SRC",
	[V_028780_COMB_MAX_DST_SRC] = "COMB_MAX_DST_SRC",
	[V_028780_COMB_DST_MINUS_SRC] = "COMB_DST_MINUS_SRC",
};

static const char *r_028780_cb_blend0_control__color_destblend__values[] = {
	[V_028780_BLEND_ZERO] = "BLEND_ZERO",
	[V_028780_BLEND_ONE] = "BLEND_ONE",
	[V_028780_BLEND_SRC_COLOR] = "BLEND_SRC_COLOR",
	[V_028780_BLEND_ONE_MINUS_SRC_COLOR] = "BLEND_ONE_MINUS_SRC_COLOR",
	[V_028780_BLEND_SRC_ALPHA] = "BLEND_SRC_ALPHA",
	[V_028780_BLEND_ONE_MINUS_SRC_ALPHA] = "BLEND_ONE_MINUS_SRC_ALPHA",
	[V_028780_BLEND_DST_ALPHA] = "BLEND_DST_ALPHA",
	[V_028780_BLEND_ONE_MINUS_DST_ALPHA] = "BLEND_ONE_MINUS_DST_ALPHA",
	[V_028780_BLEND_DST_COLOR] = "BLEND_DST_COLOR",
	[V_028780_BLEND_ONE_MINUS_DST_COLOR] = "BLEND_ONE_MINUS_DST_COLOR",
	[V_028780_BLEND_SRC_ALPHA_SATURATE] = "BLEND_SRC_ALPHA_SATURATE",
	[V_028780_BLEND_CONSTANT_COLOR] = "BLEND_CONSTANT_COLOR",
	[V_028780_BLEND_ONE_MINUS_CONSTANT_COLOR] = "BLEND_ONE_MINUS_CONSTANT_COLOR",
	[V_028780_BLEND_SRC1_COLOR] = "BLEND_SRC1_COLOR",
	[V_028780_BLEND_INV_SRC1_COLOR] = "BLEND_INV_SRC1_COLOR",
	[V_028780_BLEND_SRC1_ALPHA] = "BLEND_SRC1_ALPHA",
	[V_028780_BLEND_INV_SRC1_ALPHA] = "BLEND_INV_SRC1_ALPHA",
	[V_028780_BLEND_CONSTANT_ALPHA] = "BLEND_CONSTANT_ALPHA",
	[V_028780_BLEND_ONE_MINUS_CONSTANT_ALPHA] = "BLEND_ONE_MINUS_CONSTANT_ALPHA",
};

static const char *r_028780_cb_blend0_control__alpha_srcblend__values[] = {
	[V_028780_BLEND_ZERO] = "BLEND_ZERO",
	[V_028780_BLEND_ONE] = "BLEND_ONE",
	[V_028780_BLEND_SRC_COLOR] = "BLEND_SRC_COLOR",
	[V_028780_BLEND_ONE_MINUS_SRC_COLOR] = "BLEND_ONE_MINUS_SRC_COLOR",
	[V_028780_BLEND_SRC_ALPHA] = "BLEND_SRC_ALPHA",
	[V_028780_BLEND_ONE_MINUS_SRC_ALPHA] = "BLEND_ONE_MINUS_SRC_ALPHA",
	[V_028780_BLEND_DST_ALPHA] = "BLEND_DST_ALPHA",
	[V_028780_BLEND_ONE_MINUS_DST_ALPHA] = "BLEND_ONE_MINUS_DST_ALPHA",
	[V_028780_BLEND_DST_COLOR] = "BLEND_DST_COLOR",
	[V_028780_BLEND_ONE_MINUS_DST_COLOR] = "BLEND_ONE_MINUS_DST_COLOR",
	[V_028780_BLEND_SRC_ALPHA_SATURATE] = "BLEND_SRC_ALPHA_SATURATE",
	[V_028780_BLEND_CONSTANT_COLOR] = "BLEND_CONSTANT_COLOR",
	[V_028780_BLEND_ONE_MINUS_CONSTANT_COLOR] = "BLEND_ONE_MINUS_CONSTANT_COLOR",
	[V_028780_BLEND_SRC1_COLOR] = "BLEND_SRC1_COLOR",
	[V_028780_BLEND_INV_SRC1_COLOR] = "BLEND_INV_SRC1_COLOR",
	[V_028780_BLEND_SRC1_ALPHA] = "BLEND_SRC1_ALPHA",
	[V_028780_BLEND_INV_SRC1_ALPHA] = "BLEND_INV_SRC1_ALPHA",
	[V_028780_BLEND_CONSTANT_ALPHA] = "BLEND_CONSTANT_ALPHA",
	[V_028780_BLEND_ONE_MINUS_CONSTANT_ALPHA] = "BLEND_ONE_MINUS_CONSTANT_ALPHA",
};

static const char *r_028780_cb_blend0_control__alpha_comb_fcn__values[] = {
	[V_028780_COMB_DST_PLUS_SRC] = "COMB_DST_PLUS_SRC",
	[V_028780_COMB_SRC_MINUS_DST] = "COMB_SRC_MINUS_DST",
	[V_028780_COMB_MIN_DST_SRC] = "COMB_MIN_DST_SRC",
	[V_028780_COMB_MAX_DST_SRC] = "COMB_MAX_DST_SRC",
	[V_028780_COMB_DST_MINUS_SRC] = "COMB_DST_MINUS_SRC",
};

static const char *r_028780_cb_blend0_control__alpha_destblend__values[] = {
	[V_028780_BLEND_ZERO] = "BLEND_ZERO",
	[V_028780_BLEND_ONE] = "BLEND_ONE",
	[V_028780_BLEND_SRC_COLOR] = "BLEND_SRC_COLOR",
	[V_028780_BLEND_ONE_MINUS_SRC_COLOR] = "BLEND_ONE_MINUS_SRC_COLOR",
	[V_028780_BLEND_SRC_ALPHA] = "BLEND_SRC_ALPHA",
	[V_028780_BLEND_ONE_MINUS_SRC_ALPHA] = "BLEND_ONE_MINUS_SRC_ALPHA",
	[V_028780_BLEND_DST_ALPHA] = "BLEND_DST_ALPHA",
	[V_028780_BLEND_ONE_MINUS_DST_ALPHA] = "BLEND_ONE_MINUS_DST_ALPHA",
	[V_028780_BLEND_DST_COLOR] = "BLEND_DST_COLOR",
	[V_028780_BLEND_ONE_MINUS_DST_COLOR] = "BLEND_ONE_MINUS_DST_COLOR",
	[V_028780_BLEND_SRC_ALPHA_SATURATE] = "BLEND_SRC_ALPHA_SATURATE",
	[V_028780_BLEND_CONSTANT_COLOR] = "BLEND_CONSTANT_COLOR",
	[V_028780_BLEND_ONE_MINUS_CONSTANT_COLOR] = "BLEND_ONE_MINUS_CONSTANT_COLOR",
	[V_028780_BLEND_SRC1_COLOR] = "BLEND_SRC1_COLOR",
	[V_028780_BLEND_INV_SRC1_COLOR] = "BLEND_INV_SRC1_COLOR",
	[V_028780_BLEND_SRC1_ALPHA] = "BLEND_SRC1_ALPHA",
	[V_028780_BLEND_INV_SRC1_ALPHA] = "BLEND_INV_SRC1_ALPHA",
	[V_028780_BLEND_CONSTANT_ALPHA] = "BLEND_CONSTANT_ALPHA",
	[V_028780_BLEND_ONE_MINUS_CONSTANT_ALPHA] = "BLEND_ONE_MINUS_CONSTANT_ALPHA",
};

static const struct si_field r_028780_cb_blend0_control__fields[] = {
	{"COLOR_SRCBLEND", S_028780_COLOR_SRCBLEND(~0u), ARRAY_SIZE(r_028780_cb_blend0_control__color_srcblend__values), r_028780_cb_blend0_control__color_srcblend__values},
	{"COLOR_COMB_FCN", S_028780_COLOR_COMB_FCN(~0u), ARRAY_SIZE(r_028780_cb_blend0_control__color_comb_fcn__values), r_028780_cb_blend0_control__color_comb_fcn__values},
	{"COLOR_DESTBLEND", S_028780_COLOR_DESTBLEND(~0u), ARRAY_SIZE(r_028780_cb_blend0_control__color_destblend__values), r_028780_cb_blend0_control__color_destblend__values},
	{"ALPHA_SRCBLEND", S_028780_ALPHA_SRCBLEND(~0u), ARRAY_SIZE(r_028780_cb_blend0_control__alpha_srcblend__values), r_028780_cb_blend0_control__alpha_srcblend__values},
	{"ALPHA_COMB_FCN", S_028780_ALPHA_COMB_FCN(~0u), ARRAY_SIZE(r_028780_cb_blend0_control__alpha_comb_fcn__values), r_028780_cb_blend0_control__alpha_comb_fcn__values},
	{"ALPHA_DESTBLEND", S_028780_ALPHA_DESTBLEND(~0u), ARRAY_SIZE(r_028780_cb_blend0_control__alpha_destblend__values), r_028780_cb_blend0_control__alpha_destblend__values},
	{"SEPARATE_ALPHA_BLEND", S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{"ENABLE", S_028780_ENABLE(~0u)},
	{"DISABLE_ROP3", S_028780_DISABLE_ROP3(~0u)},
};

static const struct si_field r_0287cc_cs_copy_state__fields[] = {
	{"SRC_STATE_ID", S_0287CC_SRC_STATE_ID(~0u)},
};

static const struct si_field r_0287e4_vgt_dma_base_hi__fields[] = {
	{"BASE_ADDR", S_0287E4_BASE_ADDR(~0u)},
};

static const char *r_0287f0_vgt_draw_initiator__source_select__values[] = {
	[V_0287F0_DI_SRC_SEL_DMA] = "DI_SRC_SEL_DMA",
	[V_0287F0_DI_SRC_SEL_IMMEDIATE] = "DI_SRC_SEL_IMMEDIATE",
	[V_0287F0_DI_SRC_SEL_AUTO_INDEX] = "DI_SRC_SEL_AUTO_INDEX",
	[V_0287F0_DI_SRC_SEL_RESERVED] = "DI_SRC_SEL_RESERVED",
};

static const char *r_0287f0_vgt_draw_initiator__major_mode__values[] = {
	[V_0287F0_DI_MAJOR_MODE_0] = "DI_MAJOR_MODE_0",
	[V_0287F0_DI_MAJOR_MODE_1] = "DI_MAJOR_MODE_1",
};

static const struct si_field r_0287f0_vgt_draw_initiator__fields[] = {
	{"SOURCE_SELECT", S_0287F0_SOURCE_SELECT(~0u), ARRAY_SIZE(r_0287f0_vgt_draw_initiator__source_select__values), r_0287f0_vgt_draw_initiator__source_select__values},
	{"MAJOR_MODE", S_0287F0_MAJOR_MODE(~0u), ARRAY_SIZE(r_0287f0_vgt_draw_initiator__major_mode__values), r_0287f0_vgt_draw_initiator__major_mode__values},
	{"NOT_EOP", S_0287F0_NOT_EOP(~0u)},
	{"USE_OPAQUE", S_0287F0_USE_OPAQUE(~0u)},
};

static const struct si_field r_0287f8_vgt_event_address_reg__fields[] = {
	{"ADDRESS_LOW", S_0287F8_ADDRESS_LOW(~0u)},
};

static const char *r_028800_db_depth_control__zfunc__values[] = {
	[V_028800_FRAG_NEVER] = "FRAG_NEVER",
	[V_028800_FRAG_LESS] = "FRAG_LESS",
	[V_028800_FRAG_EQUAL] = "FRAG_EQUAL",
	[V_028800_FRAG_LEQUAL] = "FRAG_LEQUAL",
	[V_028800_FRAG_GREATER] = "FRAG_GREATER",
	[V_028800_FRAG_NOTEQUAL] = "FRAG_NOTEQUAL",
	[V_028800_FRAG_GEQUAL] = "FRAG_GEQUAL",
	[V_028800_FRAG_ALWAYS] = "FRAG_ALWAYS",
};

static const char *r_028800_db_depth_control__stencilfunc__values[] = {
	[V_028800_REF_NEVER] = "REF_NEVER",
	[V_028800_REF_LESS] = "REF_LESS",
	[V_028800_REF_EQUAL] = "REF_EQUAL",
	[V_028800_REF_LEQUAL] = "REF_LEQUAL",
	[V_028800_REF_GREATER] = "REF_GREATER",
	[V_028800_REF_NOTEQUAL] = "REF_NOTEQUAL",
	[V_028800_REF_GEQUAL] = "REF_GEQUAL",
	[V_028800_REF_ALWAYS] = "REF_ALWAYS",
};

static const char *r_028800_db_depth_control__stencilfunc_bf__values[] = {
	[V_028800_REF_NEVER] = "REF_NEVER",
	[V_028800_REF_LESS] = "REF_LESS",
	[V_028800_REF_EQUAL] = "REF_EQUAL",
	[V_028800_REF_LEQUAL] = "REF_LEQUAL",
	[V_028800_REF_GREATER] = "REF_GREATER",
	[V_028800_REF_NOTEQUAL] = "REF_NOTEQUAL",
	[V_028800_REF_GEQUAL] = "REF_GEQUAL",
	[V_028800_REF_ALWAYS] = "REF_ALWAYS",
};

static const struct si_field r_028800_db_depth_control__fields[] = {
	{"STENCIL_ENABLE", S_028800_STENCIL_ENABLE(~0u)},
	{"Z_ENABLE", S_028800_Z_ENABLE(~0u)},
	{"Z_WRITE_ENABLE", S_028800_Z_WRITE_ENABLE(~0u)},
	{"DEPTH_BOUNDS_ENABLE", S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{"ZFUNC", S_028800_ZFUNC(~0u), ARRAY_SIZE(r_028800_db_depth_control__zfunc__values), r_028800_db_depth_control__zfunc__values},
	{"BACKFACE_ENABLE", S_028800_BACKFACE_ENABLE(~0u)},
	{"STENCILFUNC", S_028800_STENCILFUNC(~0u), ARRAY_SIZE(r_028800_db_depth_control__stencilfunc__values), r_028800_db_depth_control__stencilfunc__values},
	{"STENCILFUNC_BF", S_028800_STENCILFUNC_BF(~0u), ARRAY_SIZE(r_028800_db_depth_control__stencilfunc_bf__values), r_028800_db_depth_control__stencilfunc_bf__values},
	{"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL", S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{"DISABLE_COLOR_WRITES_ON_DEPTH_PASS", S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
};

static const struct si_field r_028804_db_eqaa__fields[] = {
	{"MAX_ANCHOR_SAMPLES", S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{"PS_ITER_SAMPLES", S_028804_PS_ITER_SAMPLES(~0u)},
	{"MASK_EXPORT_NUM_SAMPLES", S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{"ALPHA_TO_MASK_NUM_SAMPLES", S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{"HIGH_QUALITY_INTERSECTIONS", S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{"INCOHERENT_EQAA_READS", S_028804_INCOHERENT_EQAA_READS(~0u)},
	{"INTERPOLATE_COMP_Z", S_028804_INTERPOLATE_COMP_Z(~0u)},
	{"INTERPOLATE_SRC_Z", S_028804_INTERPOLATE_SRC_Z(~0u)},
	{"STATIC_ANCHOR_ASSOCIATIONS", S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{"ALPHA_TO_MASK_EQAA_DISABLE", S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{"OVERRASTERIZATION_AMOUNT", S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{"ENABLE_POSTZ_OVERRASTERIZATION", S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
};

static const char *r_028808_cb_color_control__mode__values[] = {
	[V_028808_CB_DISABLE] = "CB_DISABLE",
	[V_028808_CB_NORMAL] = "CB_NORMAL",
	[V_028808_CB_ELIMINATE_FAST_CLEAR] = "CB_ELIMINATE_FAST_CLEAR",
	[V_028808_CB_RESOLVE] = "CB_RESOLVE",
	[V_028808_CB_FMASK_DECOMPRESS] = "CB_FMASK_DECOMPRESS",
	[V_028808_CB_DCC_DECOMPRESS] = "CB_DCC_DECOMPRESS",
};

static const char *r_028808_cb_color_control__rop3__values[] = {
	[V_028808_X_0X00] = "X_0X00",
	[V_028808_X_0X05] = "X_0X05",
	[V_028808_X_0X0A] = "X_0X0A",
	[V_028808_X_0X0F] = "X_0X0F",
	[V_028808_X_0X11] = "X_0X11",
	[V_028808_X_0X22] = "X_0X22",
	[V_028808_X_0X33] = "X_0X33",
	[V_028808_X_0X44] = "X_0X44",
	[V_028808_X_0X50] = "X_0X50",
	[V_028808_X_0X55] = "X_0X55",
	[V_028808_X_0X5A] = "X_0X5A",
	[V_028808_X_0X5F] = "X_0X5F",
	[V_028808_X_0X66] = "X_0X66",
	[V_028808_X_0X77] = "X_0X77",
	[V_028808_X_0X88] = "X_0X88",
	[V_028808_X_0X99] = "X_0X99",
	[V_028808_X_0XA0] = "X_0XA0",
	[V_028808_X_0XA5] = "X_0XA5",
	[V_028808_X_0XAA] = "X_0XAA",
	[V_028808_X_0XAF] = "X_0XAF",
	[V_028808_X_0XBB] = "X_0XBB",
	[V_028808_X_0XCC] = "X_0XCC",
	[V_028808_X_0XDD] = "X_0XDD",
	[V_028808_X_0XEE] = "X_0XEE",
	[V_028808_X_0XF0] = "X_0XF0",
	[V_028808_X_0XF5] = "X_0XF5",
	[V_028808_X_0XFA] = "X_0XFA",
	[V_028808_X_0XFF] = "X_0XFF",
};

static const struct si_field r_028808_cb_color_control__fields[] = {
	{"DEGAMMA_ENABLE", S_028808_DEGAMMA_ENABLE(~0u)},
	{"MODE", S_028808_MODE(~0u), ARRAY_SIZE(r_028808_cb_color_control__mode__values), r_028808_cb_color_control__mode__values},
	{"ROP3", S_028808_ROP3(~0u), ARRAY_SIZE(r_028808_cb_color_control__rop3__values), r_028808_cb_color_control__rop3__values},
};

static const char *r_02880c_db_shader_control__z_order__values[] = {
	[V_02880C_LATE_Z] = "LATE_Z",
	[V_02880C_EARLY_Z_THEN_LATE_Z] = "EARLY_Z_THEN_LATE_Z",
	[V_02880C_RE_Z] = "RE_Z",
	[V_02880C_EARLY_Z_THEN_RE_Z] = "EARLY_Z_THEN_RE_Z",
};

static const char *r_02880c_db_shader_control__conservative_z_export__values[] = {
	[V_02880C_EXPORT_ANY_Z] = "EXPORT_ANY_Z",
	[V_02880C_EXPORT_LESS_THAN_Z] = "EXPORT_LESS_THAN_Z",
	[V_02880C_EXPORT_GREATER_THAN_Z] = "EXPORT_GREATER_THAN_Z",
	[V_02880C_EXPORT_RESERVED] = "EXPORT_RESERVED",
};

static const struct si_field r_02880c_db_shader_control__fields[] = {
	{"Z_EXPORT_ENABLE", S_02880C_Z_EXPORT_ENABLE(~0u)},
	{"STENCIL_TEST_VAL_EXPORT_ENABLE", S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{"STENCIL_OP_VAL_EXPORT_ENABLE", S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{"Z_ORDER", S_02880C_Z_ORDER(~0u), ARRAY_SIZE(r_02880c_db_shader_control__z_order__values), r_02880c_db_shader_control__z_order__values},
	{"KILL_ENABLE", S_02880C_KILL_ENABLE(~0u)},
	{"COVERAGE_TO_MASK_ENABLE", S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{"MASK_EXPORT_ENABLE", S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{"EXEC_ON_HIER_FAIL", S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{"EXEC_ON_NOOP", S_02880C_EXEC_ON_NOOP(~0u)},
	{"ALPHA_TO_MASK_DISABLE", S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{"DEPTH_BEFORE_SHADER", S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{"CONSERVATIVE_Z_EXPORT", S_02880C_CONSERVATIVE_Z_EXPORT(~0u), ARRAY_SIZE(r_02880c_db_shader_control__conservative_z_export__values), r_02880c_db_shader_control__conservative_z_export__values},
	{"DUAL_QUAD_DISABLE", S_02880C_DUAL_QUAD_DISABLE(~0u)},
};

static const struct si_field r_028810_pa_cl_clip_cntl__fields[] = {
	{"UCP_ENA_0", S_028810_UCP_ENA_0(~0u)},
	{"UCP_ENA_1", S_028810_UCP_ENA_1(~0u)},
	{"UCP_ENA_2", S_028810_UCP_ENA_2(~0u)},
	{"UCP_ENA_3", S_028810_UCP_ENA_3(~0u)},
	{"UCP_ENA_4", S_028810_UCP_ENA_4(~0u)},
	{"UCP_ENA_5", S_028810_UCP_ENA_5(~0u)},
	{"PS_UCP_Y_SCALE_NEG", S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{"PS_UCP_MODE", S_028810_PS_UCP_MODE(~0u)},
	{"CLIP_DISABLE", S_028810_CLIP_DISABLE(~0u)},
	{"UCP_CULL_ONLY_ENA", S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{"BOUNDARY_EDGE_FLAG_ENA", S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{"DX_CLIP_SPACE_DEF", S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{"DIS_CLIP_ERR_DETECT", S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{"VTX_KILL_OR", S_028810_VTX_KILL_OR(~0u)},
	{"DX_RASTERIZATION_KILL", S_028810_DX_RASTERIZATION_KILL(~0u)},
	{"DX_LINEAR_ATTR_CLIP_ENA", S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{"VTE_VPORT_PROVOKE_DISABLE", S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{"ZCLIP_NEAR_DISABLE", S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{"ZCLIP_FAR_DISABLE", S_028810_ZCLIP_FAR_DISABLE(~0u)},
};

static const char *r_028814_pa_su_sc_mode_cntl__poly_mode__values[] = {
	[V_028814_X_DISABLE_POLY_MODE] = "X_DISABLE_POLY_MODE",
	[V_028814_X_DUAL_MODE] = "X_DUAL_MODE",
};

static const char *r_028814_pa_su_sc_mode_cntl__polymode_front_ptype__values[] = {
	[V_028814_X_DRAW_POINTS] = "X_DRAW_POINTS",
	[V_028814_X_DRAW_LINES] = "X_DRAW_LINES",
	[V_028814_X_DRAW_TRIANGLES] = "X_DRAW_TRIANGLES",
};

static const char *r_028814_pa_su_sc_mode_cntl__polymode_back_ptype__values[] = {
	[V_028814_X_DRAW_POINTS] = "X_DRAW_POINTS",
	[V_028814_X_DRAW_LINES] = "X_DRAW_LINES",
	[V_028814_X_DRAW_TRIANGLES] = "X_DRAW_TRIANGLES",
};

static const struct si_field r_028814_pa_su_sc_mode_cntl__fields[] = {
	{"CULL_FRONT", S_028814_CULL_FRONT(~0u)},
	{"CULL_BACK", S_028814_CULL_BACK(~0u)},
	{"FACE", S_028814_FACE(~0u)},
	{"POLY_MODE", S_028814_POLY_MODE(~0u), ARRAY_SIZE(r_028814_pa_su_sc_mode_cntl__poly_mode__values), r_028814_pa_su_sc_mode_cntl__poly_mode__values},
	{"POLYMODE_FRONT_PTYPE", S_028814_POLYMODE_FRONT_PTYPE(~0u), ARRAY_SIZE(r_028814_pa_su_sc_mode_cntl__polymode_front_ptype__values), r_028814_pa_su_sc_mode_cntl__polymode_front_ptype__values},
	{"POLYMODE_BACK_PTYPE", S_028814_POLYMODE_BACK_PTYPE(~0u), ARRAY_SIZE(r_028814_pa_su_sc_mode_cntl__polymode_back_ptype__values), r_028814_pa_su_sc_mode_cntl__polymode_back_ptype__values},
	{"POLY_OFFSET_FRONT_ENABLE", S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{"POLY_OFFSET_BACK_ENABLE", S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{"POLY_OFFSET_PARA_ENABLE", S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{"VTX_WINDOW_OFFSET_ENABLE", S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{"PROVOKING_VTX_LAST", S_028814_PROVOKING_VTX_LAST(~0u)},
	{"PERSP_CORR_DIS", S_028814_PERSP_CORR_DIS(~0u)},
	{"MULTI_PRIM_IB_ENA", S_028814_MULTI_PRIM_IB_ENA(~0u)},
};

static const struct si_field r_028818_pa_cl_vte_cntl__fields[] = {
	{"VPORT_X_SCALE_ENA", S_028818_VPORT_X_SCALE_ENA(~0u)},
	{"VPORT_X_OFFSET_ENA", S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{"VPORT_Y_SCALE_ENA", S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{"VPORT_Y_OFFSET_ENA", S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{"VPORT_Z_SCALE_ENA", S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{"VPORT_Z_OFFSET_ENA", S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{"VTX_XY_FMT", S_028818_VTX_XY_FMT(~0u)},
	{"VTX_Z_FMT", S_028818_VTX_Z_FMT(~0u)},
	{"VTX_W0_FMT", S_028818_VTX_W0_FMT(~0u)},
};

static const struct si_field r_02881c_pa_cl_vs_out_cntl__fields[] = {
	{"CLIP_DIST_ENA_0", S_02881C_CLIP_DIST_ENA_0(~0u)},
	{"CLIP_DIST_ENA_1", S_02881C_CLIP_DIST_ENA_1(~0u)},
	{"CLIP_DIST_ENA_2", S_02881C_CLIP_DIST_ENA_2(~0u)},
	{"CLIP_DIST_ENA_3", S_02881C_CLIP_DIST_ENA_3(~0u)},
	{"CLIP_DIST_ENA_4", S_02881C_CLIP_DIST_ENA_4(~0u)},
	{"CLIP_DIST_ENA_5", S_02881C_CLIP_DIST_ENA_5(~0u)},
	{"CLIP_DIST_ENA_6", S_02881C_CLIP_DIST_ENA_6(~0u)},
	{"CLIP_DIST_ENA_7", S_02881C_CLIP_DIST_ENA_7(~0u)},
	{"CULL_DIST_ENA_0", S_02881C_CULL_DIST_ENA_0(~0u)},
	{"CULL_DIST_ENA_1", S_02881C_CULL_DIST_ENA_1(~0u)},
	{"CULL_DIST_ENA_2", S_02881C_CULL_DIST_ENA_2(~0u)},
	{"CULL_DIST_ENA_3", S_02881C_CULL_DIST_ENA_3(~0u)},
	{"CULL_DIST_ENA_4", S_02881C_CULL_DIST_ENA_4(~0u)},
	{"CULL_DIST_ENA_5", S_02881C_CULL_DIST_ENA_5(~0u)},
	{"CULL_DIST_ENA_6", S_02881C_CULL_DIST_ENA_6(~0u)},
	{"CULL_DIST_ENA_7", S_02881C_CULL_DIST_ENA_7(~0u)},
	{"USE_VTX_POINT_SIZE", S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{"USE_VTX_EDGE_FLAG", S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{"USE_VTX_RENDER_TARGET_INDX", S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{"USE_VTX_VIEWPORT_INDX", S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{"USE_VTX_KILL_FLAG", S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{"VS_OUT_MISC_VEC_ENA", S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{"VS_OUT_CCDIST0_VEC_ENA", S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{"VS_OUT_CCDIST1_VEC_ENA", S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{"VS_OUT_MISC_SIDE_BUS_ENA", S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{"USE_VTX_GS_CUT_FLAG", S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{"USE_VTX_LINE_WIDTH", S_02881C_USE_VTX_LINE_WIDTH(~0u)},
};

static const struct si_field r_028820_pa_cl_naninf_cntl__fields[] = {
	{"VTE_XY_INF_DISCARD", S_028820_VTE_XY_INF_DISCARD(~0u)},
	{"VTE_Z_INF_DISCARD", S_028820_VTE_Z_INF_DISCARD(~0u)},
	{"VTE_W_INF_DISCARD", S_028820_VTE_W_INF_DISCARD(~0u)},
	{"VTE_0XNANINF_IS_0", S_028820_VTE_0XNANINF_IS_0(~0u)},
	{"VTE_XY_NAN_RETAIN", S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{"VTE_Z_NAN_RETAIN", S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{"VTE_W_NAN_RETAIN", S_028820_VTE_W_NAN_RETAIN(~0u)},
	{"VTE_W_RECIP_NAN_IS_0", S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{"VS_XY_NAN_TO_INF", S_028820_VS_XY_NAN_TO_INF(~0u)},
	{"VS_XY_INF_RETAIN", S_028820_VS_XY_INF_RETAIN(~0u)},
	{"VS_Z_NAN_TO_INF", S_028820_VS_Z_NAN_TO_INF(~0u)},
	{"VS_Z_INF_RETAIN", S_028820_VS_Z_INF_RETAIN(~0u)},
	{"VS_W_NAN_TO_INF", S_028820_VS_W_NAN_TO_INF(~0u)},
	{"VS_W_INF_RETAIN", S_028820_VS_W_INF_RETAIN(~0u)},
	{"VS_CLIP_DIST_INF_DISCARD", S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{"VTE_NO_OUTPUT_NEG_0", S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
};

static const struct si_field r_028824_pa_su_line_stipple_cntl__fields[] = {
	{"LINE_STIPPLE_RESET", S_028824_LINE_STIPPLE_RESET(~0u)},
	{"EXPAND_FULL_LENGTH", S_028824_EXPAND_FULL_LENGTH(~0u)},
	{"FRACTIONAL_ACCUM", S_028824_FRACTIONAL_ACCUM(~0u)},
	{"DIAMOND_ADJUST", S_028824_DIAMOND_ADJUST(~0u)},
};

static const struct si_field r_02882c_pa_su_prim_filter_cntl__fields[] = {
	{"TRIANGLE_FILTER_DISABLE", S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{"LINE_FILTER_DISABLE", S_02882C_LINE_FILTER_DISABLE(~0u)},
	{"POINT_FILTER_DISABLE", S_02882C_POINT_FILTER_DISABLE(~0u)},
	{"RECTANGLE_FILTER_DISABLE", S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{"TRIANGLE_EXPAND_ENA", S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{"LINE_EXPAND_ENA", S_02882C_LINE_EXPAND_ENA(~0u)},
	{"POINT_EXPAND_ENA", S_02882C_POINT_EXPAND_ENA(~0u)},
	{"RECTANGLE_EXPAND_ENA", S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{"PRIM_EXPAND_CONSTANT", S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{"XMAX_RIGHT_EXCLUSION", S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{"YMAX_BOTTOM_EXCLUSION", S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
};

static const struct si_field r_028a00_pa_su_point_size__fields[] = {
	{"HEIGHT", S_028A00_HEIGHT(~0u)},
	{"WIDTH", S_028A00_WIDTH(~0u)},
};

static const struct si_field r_028a04_pa_su_point_minmax__fields[] = {
	{"MIN_SIZE", S_028A04_MIN_SIZE(~0u)},
	{"MAX_SIZE", S_028A04_MAX_SIZE(~0u)},
};

static const struct si_field r_028a08_pa_su_line_cntl__fields[] = {
	{"WIDTH", S_028A08_WIDTH(~0u)},
};

static const struct si_field r_028a0c_pa_sc_line_stipple__fields[] = {
	{"LINE_PATTERN", S_028A0C_LINE_PATTERN(~0u)},
	{"REPEAT_COUNT", S_028A0C_REPEAT_COUNT(~0u)},
	{"PATTERN_BIT_ORDER", S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{"AUTO_RESET_CNTL", S_028A0C_AUTO_RESET_CNTL(~0u)},
};

static const char *r_028a10_vgt_output_path_cntl__path_select__values[] = {
	[V_028A10_VGT_OUTPATH_VTX_REUSE] = "VGT_OUTPATH_VTX_REUSE",
	[V_028A10_VGT_OUTPATH_TESS_EN] = "VGT_OUTPATH_TESS_EN",
	[V_028A10_VGT_OUTPATH_PASSTHRU] = "VGT_OUTPATH_PASSTHRU",
	[V_028A10_VGT_OUTPATH_GS_BLOCK] = "VGT_OUTPATH_GS_BLOCK",
	[V_028A10_VGT_OUTPATH_HS_BLOCK] = "VGT_OUTPATH_HS_BLOCK",
};

static const struct si_field r_028a10_vgt_output_path_cntl__fields[] = {
	{"PATH_SELECT", S_028A10_PATH_SELECT(~0u), ARRAY_SIZE(r_028a10_vgt_output_path_cntl__path_select__values), r_028a10_vgt_output_path_cntl__path_select__values},
};

static const struct si_field r_028a14_vgt_hos_cntl__fields[] = {
	{"TESS_MODE", S_028A14_TESS_MODE(~0u)},
};

static const struct si_field r_028a20_vgt_hos_reuse_depth__fields[] = {
	{"REUSE_DEPTH", S_028A20_REUSE_DEPTH(~0u)},
};

static const char *r_028a24_vgt_group_prim_type__prim_type__values[] = {
	[V_028A24_VGT_GRP_3D_POINT] = "VGT_GRP_3D_POINT",
	[V_028A24_VGT_GRP_3D_LINE] = "VGT_GRP_3D_LINE",
	[V_028A24_VGT_GRP_3D_TRI] = "VGT_GRP_3D_TRI",
	[V_028A24_VGT_GRP_3D_RECT] = "VGT_GRP_3D_RECT",
	[V_028A24_VGT_GRP_3D_QUAD] = "VGT_GRP_3D_QUAD",
	[V_028A24_VGT_GRP_2D_COPY_RECT_V0] = "VGT_GRP_2D_COPY_RECT_V0",
	[V_028A24_VGT_GRP_2D_COPY_RECT_V1] = "VGT_GRP_2D_COPY_RECT_V1",
	[V_028A24_VGT_GRP_2D_COPY_RECT_V2] = "VGT_GRP_2D_COPY_RECT_V2",
	[V_028A24_VGT_GRP_2D_COPY_RECT_V3] = "VGT_GRP_2D_COPY_RECT_V3",
	[V_028A24_VGT_GRP_2D_FILL_RECT] = "VGT_GRP_2D_FILL_RECT",
	[V_028A24_VGT_GRP_2D_LINE] = "VGT_GRP_2D_LINE",
	[V_028A24_VGT_GRP_2D_TRI] = "VGT_GRP_2D_TRI",
	[V_028A24_VGT_GRP_PRIM_INDEX_LINE] = "VGT_GRP_PRIM_INDEX_LINE",
	[V_028A24_VGT_GRP_PRIM_INDEX_TRI] = "VGT_GRP_PRIM_INDEX_TRI",
	[V_028A24_VGT_GRP_PRIM_INDEX_QUAD] = "VGT_GRP_PRIM_INDEX_QUAD",
	[V_028A24_VGT_GRP_3D_LINE_ADJ] = "VGT_GRP_3D_LINE_ADJ",
	[V_028A24_VGT_GRP_3D_TRI_ADJ] = "VGT_GRP_3D_TRI_ADJ",
	[V_028A24_VGT_GRP_3D_PATCH] = "VGT_GRP_3D_PATCH",
};

static const char *r_028a24_vgt_group_prim_type__prim_order__values[] = {
	[V_028A24_VGT_GRP_LIST] = "VGT_GRP_LIST",
	[V_028A24_VGT_GRP_STRIP] = "VGT_GRP_STRIP",
	[V_028A24_VGT_GRP_FAN] = "VGT_GRP_FAN",
	[V_028A24_VGT_GRP_LOOP] = "VGT_GRP_LOOP",
	[V_028A24_VGT_GRP_POLYGON] = "VGT_GRP_POLYGON",
};

static const struct si_field r_028a24_vgt_group_prim_type__fields[] = {
	{"PRIM_TYPE", S_028A24_PRIM_TYPE(~0u), ARRAY_SIZE(r_028a24_vgt_group_prim_type__prim_type__values), r_028a24_vgt_group_prim_type__prim_type__values},
	{"RETAIN_ORDER", S_028A24_RETAIN_ORDER(~0u)},
	{"RETAIN_QUADS", S_028A24_RETAIN_QUADS(~0u)},
	{"PRIM_ORDER", S_028A24_PRIM_ORDER(~0u), ARRAY_SIZE(r_028a24_vgt_group_prim_type__prim_order__values), r_028a24_vgt_group_prim_type__prim_order__values},
};

static const struct si_field r_028a28_vgt_group_first_decr__fields[] = {
	{"FIRST_DECR", S_028A28_FIRST_DECR(~0u)},
};

static const struct si_field r_028a2c_vgt_group_decr__fields[] = {
	{"DECR", S_028A2C_DECR(~0u)},
};

static const struct si_field r_028a30_vgt_group_vect_0_cntl__fields[] = {
	{"COMP_X_EN", S_028A30_COMP_X_EN(~0u)},
	{"COMP_Y_EN", S_028A30_COMP_Y_EN(~0u)},
	{"COMP_Z_EN", S_028A30_COMP_Z_EN(~0u)},
	{"COMP_W_EN", S_028A30_COMP_W_EN(~0u)},
	{"STRIDE", S_028A30_STRIDE(~0u)},
	{"SHIFT", S_028A30_SHIFT(~0u)},
};

static const struct si_field r_028a34_vgt_group_vect_1_cntl__fields[] = {
	{"COMP_X_EN", S_028A34_COMP_X_EN(~0u)},
	{"COMP_Y_EN", S_028A34_COMP_Y_EN(~0u)},
	{"COMP_Z_EN", S_028A34_COMP_Z_EN(~0u)},
	{"COMP_W_EN", S_028A34_COMP_W_EN(~0u)},
	{"STRIDE", S_028A34_STRIDE(~0u)},
	{"SHIFT", S_028A34_SHIFT(~0u)},
};

static const char *r_028a38_vgt_group_vect_0_fmt_cntl__x_conv__values[] = {
	[V_028A38_VGT_GRP_INDEX_16] = "VGT_GRP_INDEX_16",
	[V_028A38_VGT_GRP_INDEX_32] = "VGT_GRP_INDEX_32",
	[V_028A38_VGT_GRP_UINT_16] = "VGT_GRP_UINT_16",
	[V_028A38_VGT_GRP_UINT_32] = "VGT_GRP_UINT_32",
	[V_028A38_VGT_GRP_SINT_16] = "VGT_GRP_SINT_16",
	[V_028A38_VGT_GRP_SINT_32] = "VGT_GRP_SINT_32",
	[V_028A38_VGT_GRP_FLOAT_32] = "VGT_GRP_FLOAT_32",
	[V_028A38_VGT_GRP_AUTO_PRIM] = "VGT_GRP_AUTO_PRIM",
	[V_028A38_VGT_GRP_FIX_1_23_TO_FLOAT] = "VGT_GRP_FIX_1_23_TO_FLOAT",
};

static const char *r_028a38_vgt_group_vect_0_fmt_cntl__y_conv__values[] = {
	[V_028A38_VGT_GRP_INDEX_16] = "VGT_GRP_INDEX_16",
	[V_028A38_VGT_GRP_INDEX_32] = "VGT_GRP_INDEX_32",
	[V_028A38_VGT_GRP_UINT_16] = "VGT_GRP_UINT_16",
	[V_028A38_VGT_GRP_UINT_32] = "VGT_GRP_UINT_32",
	[V_028A38_VGT_GRP_SINT_16] = "VGT_GRP_SINT_16",
	[V_028A38_VGT_GRP_SINT_32] = "VGT_GRP_SINT_32",
	[V_028A38_VGT_GRP_FLOAT_32] = "VGT_GRP_FLOAT_32",
	[V_028A38_VGT_GRP_AUTO_PRIM] = "VGT_GRP_AUTO_PRIM",
	[V_028A38_VGT_GRP_FIX_1_23_TO_FLOAT] = "VGT_GRP_FIX_1_23_TO_FLOAT",
};

static const char *r_028a38_vgt_group_vect_0_fmt_cntl__z_conv__values[] = {
	[V_028A38_VGT_GRP_INDEX_16] = "VGT_GRP_INDEX_16",
	[V_028A38_VGT_GRP_INDEX_32] = "VGT_GRP_INDEX_32",
	[V_028A38_VGT_GRP_UINT_16] = "VGT_GRP_UINT_16",
	[V_028A38_VGT_GRP_UINT_32] = "VGT_GRP_UINT_32",
	[V_028A38_VGT_GRP_SINT_16] = "VGT_GRP_SINT_16",
	[V_028A38_VGT_GRP_SINT_32] = "VGT_GRP_SINT_32",
	[V_028A38_VGT_GRP_FLOAT_32] = "VGT_GRP_FLOAT_32",
	[V_028A38_VGT_GRP_AUTO_PRIM] = "VGT_GRP_AUTO_PRIM",
	[V_028A38_VGT_GRP_FIX_1_23_TO_FLOAT] = "VGT_GRP_FIX_1_23_TO_FLOAT",
};

static const char *r_028a38_vgt_group_vect_0_fmt_cntl__w_conv__values[] = {
	[V_028A38_VGT_GRP_INDEX_16] = "VGT_GRP_INDEX_16",
	[V_028A38_VGT_GRP_INDEX_32] = "VGT_GRP_INDEX_32",
	[V_028A38_VGT_GRP_UINT_16] = "VGT_GRP_UINT_16",
	[V_028A38_VGT_GRP_UINT_32] = "VGT_GRP_UINT_32",
	[V_028A38_VGT_GRP_SINT_16] = "VGT_GRP_SINT_16",
	[V_028A38_VGT_GRP_SINT_32] = "VGT_GRP_SINT_32",
	[V_028A38_VGT_GRP_FLOAT_32] = "VGT_GRP_FLOAT_32",
	[V_028A38_VGT_GRP_AUTO_PRIM] = "VGT_GRP_AUTO_PRIM",
	[V_028A38_VGT_GRP_FIX_1_23_TO_FLOAT] = "VGT_GRP_FIX_1_23_TO_FLOAT",
};

static const struct si_field r_028a38_vgt_group_vect_0_fmt_cntl__fields[] = {
	{"X_CONV", S_028A38_X_CONV(~0u), ARRAY_SIZE(r_028a38_vgt_group_vect_0_fmt_cntl__x_conv__values), r_028a38_vgt_group_vect_0_fmt_cntl__x_conv__values},
	{"X_OFFSET", S_028A38_X_OFFSET(~0u)},
	{"Y_CONV", S_028A38_Y_CONV(~0u), ARRAY_SIZE(r_028a38_vgt_group_vect_0_fmt_cntl__y_conv__values), r_028a38_vgt_group_vect_0_fmt_cntl__y_conv__values},
	{"Y_OFFSET", S_028A38_Y_OFFSET(~0u)},
	{"Z_CONV", S_028A38_Z_CONV(~0u), ARRAY_SIZE(r_028a38_vgt_group_vect_0_fmt_cntl__z_conv__values), r_028a38_vgt_group_vect_0_fmt_cntl__z_conv__values},
	{"Z_OFFSET", S_028A38_Z_OFFSET(~0u)},
	{"W_CONV", S_028A38_W_CONV(~0u), ARRAY_SIZE(r_028a38_vgt_group_vect_0_fmt_cntl__w_conv__values), r_028a38_vgt_group_vect_0_fmt_cntl__w_conv__values},
	{"W_OFFSET", S_028A38_W_OFFSET(~0u)},
};

static const char *r_028a3c_vgt_group_vect_1_fmt_cntl__x_conv__values[] = {
	[V_028A3C_VGT_GRP_INDEX_16] = "VGT_GRP_INDEX_16",
	[V_028A3C_VGT_GRP_INDEX_32] = "VGT_GRP_INDEX_32",
	[V_028A3C_VGT_GRP_UINT_16] = "VGT_GRP_UINT_16",
	[V_028A3C_VGT_GRP_UINT_32] = "VGT_GRP_UINT_32",
	[V_028A3C_VGT_GRP_SINT_16] = "VGT_GRP_SINT_16",
	[V_028A3C_VGT_GRP_SINT_32] = "VGT_GRP_SINT_32",
	[V_028A3C_VGT_GRP_FLOAT_32] = "VGT_GRP_FLOAT_32",
	[V_028A3C_VGT_GRP_AUTO_PRIM] = "VGT_GRP_AUTO_PRIM",
	[V_028A3C_VGT_GRP_FIX_1_23_TO_FLOAT] = "VGT_GRP_FIX_1_23_TO_FLOAT",
};

static const char *r_028a3c_vgt_group_vect_1_fmt_cntl__y_conv__values[] = {
	[V_028A3C_VGT_GRP_INDEX_16] = "VGT_GRP_INDEX_16",
	[V_028A3C_VGT_GRP_INDEX_32] = "VGT_GRP_INDEX_32",
	[V_028A3C_VGT_GRP_UINT_16] = "VGT_GRP_UINT_16",
	[V_028A3C_VGT_GRP_UINT_32] = "VGT_GRP_UINT_32",
	[V_028A3C_VGT_GRP_SINT_16] = "VGT_GRP_SINT_16",
	[V_028A3C_VGT_GRP_SINT_32] = "VGT_GRP_SINT_32",
	[V_028A3C_VGT_GRP_FLOAT_32] = "VGT_GRP_FLOAT_32",
	[V_028A3C_VGT_GRP_AUTO_PRIM] = "VGT_GRP_AUTO_PRIM",
	[V_028A3C_VGT_GRP_FIX_1_23_TO_FLOAT] = "VGT_GRP_FIX_1_23_TO_FLOAT",
};

static const char *r_028a3c_vgt_group_vect_1_fmt_cntl__z_conv__values[] = {
	[V_028A3C_VGT_GRP_INDEX_16] = "VGT_GRP_INDEX_16",
	[V_028A3C_VGT_GRP_INDEX_32] = "VGT_GRP_INDEX_32",
	[V_028A3C_VGT_GRP_UINT_16] = "VGT_GRP_UINT_16",
	[V_028A3C_VGT_GRP_UINT_32] = "VGT_GRP_UINT_32",
	[V_028A3C_VGT_GRP_SINT_16] = "VGT_GRP_SINT_16",
	[V_028A3C_VGT_GRP_SINT_32] = "VGT_GRP_SINT_32",
	[V_028A3C_VGT_GRP_FLOAT_32] = "VGT_GRP_FLOAT_32",
	[V_028A3C_VGT_GRP_AUTO_PRIM] = "VGT_GRP_AUTO_PRIM",
	[V_028A3C_VGT_GRP_FIX_1_23_TO_FLOAT] = "VGT_GRP_FIX_1_23_TO_FLOAT",
};

static const char *r_028a3c_vgt_group_vect_1_fmt_cntl__w_conv__values[] = {
	[V_028A3C_VGT_GRP_INDEX_16] = "VGT_GRP_INDEX_16",
	[V_028A3C_VGT_GRP_INDEX_32] = "VGT_GRP_INDEX_32",
	[V_028A3C_VGT_GRP_UINT_16] = "VGT_GRP_UINT_16",
	[V_028A3C_VGT_GRP_UINT_32] = "VGT_GRP_UINT_32",
	[V_028A3C_VGT_GRP_SINT_16] = "VGT_GRP_SINT_16",
	[V_028A3C_VGT_GRP_SINT_32] = "VGT_GRP_SINT_32",
	[V_028A3C_VGT_GRP_FLOAT_32] = "VGT_GRP_FLOAT_32",
	[V_028A3C_VGT_GRP_AUTO_PRIM] = "VGT_GRP_AUTO_PRIM",
	[V_028A3C_VGT_GRP_FIX_1_23_TO_FLOAT] = "VGT_GRP_FIX_1_23_TO_FLOAT",
};

static const struct si_field r_028a3c_vgt_group_vect_1_fmt_cntl__fields[] = {
	{"X_CONV", S_028A3C_X_CONV(~0u), ARRAY_SIZE(r_028a3c_vgt_group_vect_1_fmt_cntl__x_conv__values), r_028a3c_vgt_group_vect_1_fmt_cntl__x_conv__values},
	{"X_OFFSET", S_028A3C_X_OFFSET(~0u)},
	{"Y_CONV", S_028A3C_Y_CONV(~0u), ARRAY_SIZE(r_028a3c_vgt_group_vect_1_fmt_cntl__y_conv__values), r_028a3c_vgt_group_vect_1_fmt_cntl__y_conv__values},
	{"Y_OFFSET", S_028A3C_Y_OFFSET(~0u)},
	{"Z_CONV", S_028A3C_Z_CONV(~0u), ARRAY_SIZE(r_028a3c_vgt_group_vect_1_fmt_cntl__z_conv__values), r_028a3c_vgt_group_vect_1_fmt_cntl__z_conv__values},
	{"Z_OFFSET", S_028A3C_Z_OFFSET(~0u)},
	{"W_CONV", S_028A3C_W_CONV(~0u), ARRAY_SIZE(r_028a3c_vgt_group_vect_1_fmt_cntl__w_conv__values), r_028a3c_vgt_group_vect_1_fmt_cntl__w_conv__values},
	{"W_OFFSET", S_028A3C_W_OFFSET(~0u)},
};

static const char *r_028a40_vgt_gs_mode__mode__values[] = {
	[V_028A40_GS_OFF] = "GS_OFF",
	[V_028A40_GS_SCENARIO_A] = "GS_SCENARIO_A",
	[V_028A40_GS_SCENARIO_B] = "GS_SCENARIO_B",
	[V_028A40_GS_SCENARIO_G] = "GS_SCENARIO_G",
	[V_028A40_GS_SCENARIO_C] = "GS_SCENARIO_C",
	[V_028A40_SPRITE_EN] = "SPRITE_EN",
};

static const char *r_028a40_vgt_gs_mode__cut_mode__values[] = {
	[V_028A40_GS_CUT_1024] = "GS_CUT_1024",
	[V_028A40_GS_CUT_512] = "GS_CUT_512",
	[V_028A40_GS_CUT_256] = "GS_CUT_256",
	[V_028A40_GS_CUT_128] = "GS_CUT_128",
};

static const char *r_028a40_vgt_gs_mode__onchip__values[] = {
	[V_028A40_X_0_OFFCHIP_GS] = "X_0_OFFCHIP_GS",
	[V_028A40_X_3_ES_AND_GS_ARE_ONCHIP] = "X_3_ES_AND_GS_ARE_ONCHIP",
};

static const struct si_field r_028a40_vgt_gs_mode__fields[] = {
	{"MODE", S_028A40_MODE(~0u), ARRAY_SIZE(r_028a40_vgt_gs_mode__mode__values), r_028a40_vgt_gs_mode__mode__values},
	{"RESERVED_0", S_028A40_RESERVED_0(~0u)},
	{"CUT_MODE", S_028A40_CUT_MODE(~0u), ARRAY_SIZE(r_028a40_vgt_gs_mode__cut_mode__values), r_028a40_vgt_gs_mode__cut_mode__values},
	{"RESERVED_1", S_028A40_RESERVED_1(~0u)},
	{"GS_C_PACK_EN", S_028A40_GS_C_PACK_EN(~0u)},
	{"RESERVED_2", S_028A40_RESERVED_2(~0u)},
	{"ES_PASSTHRU", S_028A40_ES_PASSTHRU(~0u)},
	{"COMPUTE_MODE", S_028A40_COMPUTE_MODE(~0u)},
	{"FAST_COMPUTE_MODE", S_028A40_FAST_COMPUTE_MODE(~0u)},
	{"ELEMENT_INFO_EN", S_028A40_ELEMENT_INFO_EN(~0u)},
	{"PARTIAL_THD_AT_EOI", S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{"SUPPRESS_CUTS", S_028A40_SUPPRESS_CUTS(~0u)},
	{"ES_WRITE_OPTIMIZE", S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{"GS_WRITE_OPTIMIZE", S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{"ONCHIP", S_028A40_ONCHIP(~0u), ARRAY_SIZE(r_028a40_vgt_gs_mode__onchip__values), r_028a40_vgt_gs_mode__onchip__values},
};

static const struct si_field r_028a44_vgt_gs_onchip_cntl__fields[] = {
	{"ES_VERTS_PER_SUBGRP", S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{"GS_PRIMS_PER_SUBGRP", S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
};

static const struct si_field r_028a48_pa_sc_mode_cntl_0__fields[] = {
	{"MSAA_ENABLE", S_028A48_MSAA_ENABLE(~0u)},
	{"VPORT_SCISSOR_ENABLE", S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{"LINE_STIPPLE_ENABLE", S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{"SEND_UNLIT_STILES_TO_PKR", S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
};

static const struct si_field r_028a4c_pa_sc_mode_cntl_1__fields[] = {
	{"WALK_SIZE", S_028A4C_WALK_SIZE(~0u)},
	{"WALK_ALIGNMENT", S_028A4C_WALK_ALIGNMENT(~0u)},
	{"WALK_ALIGN8_PRIM_FITS_ST", S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{"WALK_FENCE_ENABLE", S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{"WALK_FENCE_SIZE", S_028A4C_WALK_FENCE_SIZE(~0u)},
	{"SUPERTILE_WALK_ORDER_ENABLE", S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{"TILE_WALK_ORDER_ENABLE", S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{"TILE_COVER_DISABLE", S_028A4C_TILE_COVER_DISABLE(~0u)},
	{"TILE_COVER_NO_SCISSOR", S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{"ZMM_LINE_EXTENT", S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{"ZMM_LINE_OFFSET", S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{"ZMM_RECT_EXTENT", S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{"KILL_PIX_POST_HI_Z", S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{"KILL_PIX_POST_DETAIL_MASK", S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{"PS_ITER_SAMPLE", S_028A4C_PS_ITER_SAMPLE(~0u)},
	{"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE", S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{"MULTI_GPU_SUPERTILE_ENABLE", S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{"GPU_ID_OVERRIDE_ENABLE", S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{"GPU_ID_OVERRIDE", S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{"MULTI_GPU_PRIM_DISCARD_ENABLE", S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{"FORCE_EOV_CNTDWN_ENABLE", S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{"FORCE_EOV_REZ_ENABLE", S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{"OUT_OF_ORDER_PRIMITIVE_ENABLE", S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{"OUT_OF_ORDER_WATER_MARK", S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
};

static const struct si_field r_028a54_vgt_gs_per_es__fields[] = {
	{"GS_PER_ES", S_028A54_GS_PER_ES(~0u)},
};

static const struct si_field r_028a58_vgt_es_per_gs__fields[] = {
	{"ES_PER_GS", S_028A58_ES_PER_GS(~0u)},
};

static const struct si_field r_028a5c_vgt_gs_per_vs__fields[] = {
	{"GS_PER_VS", S_028A5C_GS_PER_VS(~0u)},
};

static const struct si_field r_028a60_vgt_gsvs_ring_offset_1__fields[] = {
	{"OFFSET", S_028A60_OFFSET(~0u)},
};

static const struct si_field r_028a64_vgt_gsvs_ring_offset_2__fields[] = {
	{"OFFSET", S_028A64_OFFSET(~0u)},
};

static const struct si_field r_028a68_vgt_gsvs_ring_offset_3__fields[] = {
	{"OFFSET", S_028A68_OFFSET(~0u)},
};

static const char *r_028a6c_vgt_gs_out_prim_type__outprim_type__values[] = {
	[V_028A6C_OUTPRIM_TYPE_POINTLIST] = "OUTPRIM_TYPE_POINTLIST",
	[V_028A6C_OUTPRIM_TYPE_LINESTRIP] = "OUTPRIM_TYPE_LINESTRIP",
	[V_028A6C_OUTPRIM_TYPE_TRISTRIP] = "OUTPRIM_TYPE_TRISTRIP",
};

static const struct si_field r_028a6c_vgt_gs_out_prim_type__fields[] = {
	{"OUTPRIM_TYPE", S_028A6C_OUTPRIM_TYPE(~0u), ARRAY_SIZE(r_028a6c_vgt_gs_out_prim_type__outprim_type__values), r_028a6c_vgt_gs_out_prim_type__outprim_type__values},
	{"OUTPRIM_TYPE_1", S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{"OUTPRIM_TYPE_2", S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{"OUTPRIM_TYPE_3", S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{"UNIQUE_TYPE_PER_STREAM", S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
};

static const char *r_028a7c_vgt_dma_index_type__index_type__values[] = {
	[V_028A7C_VGT_INDEX_16] = "VGT_INDEX_16",
	[V_028A7C_VGT_INDEX_32] = "VGT_INDEX_32",
	[V_028A7C_VGT_INDEX_8] = "VGT_INDEX_8",
};

static const char *r_028a7c_vgt_dma_index_type__swap_mode__values[] = {
	[V_028A7C_VGT_DMA_SWAP_NONE] = "VGT_DMA_SWAP_NONE",
	[V_028A7C_VGT_DMA_SWAP_16_BIT] = "VGT_DMA_SWAP_16_BIT",
	[V_028A7C_VGT_DMA_SWAP_32_BIT] = "VGT_DMA_SWAP_32_BIT",
	[V_028A7C_VGT_DMA_SWAP_WORD] = "VGT_DMA_SWAP_WORD",
};

static const char *r_028a7c_vgt_dma_index_type__buf_type__values[] = {
	[V_028A7C_VGT_DMA_BUF_MEM] = "VGT_DMA_BUF_MEM",
	[V_028A7C_VGT_DMA_BUF_RING] = "VGT_DMA_BUF_RING",
	[V_028A7C_VGT_DMA_BUF_SETUP] = "VGT_DMA_BUF_SETUP",
};

static const char *r_028a7c_vgt_dma_index_type__rdreq_policy__values[] = {
	[V_028A7C_VGT_POLICY_LRU] = "VGT_POLICY_LRU",
	[V_028A7C_VGT_POLICY_STREAM] = "VGT_POLICY_STREAM",
};

static const struct si_field r_028a7c_vgt_dma_index_type__fields[] = {
	{"INDEX_TYPE", S_028A7C_INDEX_TYPE(~0u), ARRAY_SIZE(r_028a7c_vgt_dma_index_type__index_type__values), r_028a7c_vgt_dma_index_type__index_type__values},
	{"SWAP_MODE", S_028A7C_SWAP_MODE(~0u), ARRAY_SIZE(r_028a7c_vgt_dma_index_type__swap_mode__values), r_028a7c_vgt_dma_index_type__swap_mode__values},
	{"BUF_TYPE", S_028A7C_BUF_TYPE(~0u), ARRAY_SIZE(r_028a7c_vgt_dma_index_type__buf_type__values), r_028a7c_vgt_dma_index_type__buf_type__values},
	{"RDREQ_POLICY", S_028A7C_RDREQ_POLICY(~0u), ARRAY_SIZE(r_028a7c_vgt_dma_index_type__rdreq_policy__values), r_028a7c_vgt_dma_index_type__rdreq_policy__values},
	{"RDREQ_POLICY_VI", S_028A7C_RDREQ_POLICY_VI(~0u)},
	{"ATC", S_028A7C_ATC(~0u)},
	{"NOT_EOP", S_028A7C_NOT_EOP(~0u)},
	{"REQ_PATH", S_028A7C_REQ_PATH(~0u)},
	{"MTYPE", S_028A7C_MTYPE(~0u)},
};

static const struct si_field r_028a84_vgt_primitiveid_en__fields[] = {
	{"PRIMITIVEID_EN", S_028A84_PRIMITIVEID_EN(~0u)},
	{"DISABLE_RESET_ON_EOI", S_028A84_DISABLE_RESET_ON_EOI(~0u)},
};

static const char *r_028a90_vgt_event_initiator__event_type__values[] = {
	[V_028A90_SAMPLE_STREAMOUTSTATS1] = "SAMPLE_STREAMOUTSTATS1",
	[V_028A90_SAMPLE_STREAMOUTSTATS2] = "SAMPLE_STREAMOUTSTATS2",
	[V_028A90_SAMPLE_STREAMOUTSTATS3] = "SAMPLE_STREAMOUTSTATS3",
	[V_028A90_CACHE_FLUSH_TS] = "CACHE_FLUSH_TS",
	[V_028A90_CONTEXT_DONE] = "CONTEXT_DONE",
	[V_028A90_CACHE_FLUSH] = "CACHE_FLUSH",
	[V_028A90_CS_PARTIAL_FLUSH] = "CS_PARTIAL_FLUSH",
	[V_028A90_VGT_STREAMOUT_SYNC] = "VGT_STREAMOUT_SYNC",
	[V_028A90_VGT_STREAMOUT_RESET] = "VGT_STREAMOUT_RESET",
	[V_028A90_END_OF_PIPE_INCR_DE] = "END_OF_PIPE_INCR_DE",
	[V_028A90_END_OF_PIPE_IB_END] = "END_OF_PIPE_IB_END",
	[V_028A90_RST_PIX_CNT] = "RST_PIX_CNT",
	[V_028A90_VS_PARTIAL_FLUSH] = "VS_PARTIAL_FLUSH",
	[V_028A90_PS_PARTIAL_FLUSH] = "PS_PARTIAL_FLUSH",
	[V_028A90_FLUSH_HS_OUTPUT] = "FLUSH_HS_OUTPUT",
	[V_028A90_FLUSH_LS_OUTPUT] = "FLUSH_LS_OUTPUT",
	[V_028A90_CACHE_FLUSH_AND_INV_TS_EVENT] = "CACHE_FLUSH_AND_INV_TS_EVENT",
	[V_028A90_ZPASS_DONE] = "ZPASS_DONE",
	[V_028A90_CACHE_FLUSH_AND_INV_EVENT] = "CACHE_FLUSH_AND_INV_EVENT",
	[V_028A90_PERFCOUNTER_START] = "PERFCOUNTER_START",
	[V_028A90_PERFCOUNTER_STOP] = "PERFCOUNTER_STOP",
	[V_028A90_PIPELINESTAT_START] = "PIPELINESTAT_START",
	[V_028A90_PIPELINESTAT_STOP] = "PIPELINESTAT_STOP",
	[V_028A90_PERFCOUNTER_SAMPLE] = "PERFCOUNTER_SAMPLE",
	[V_028A90_FLUSH_ES_OUTPUT] = "FLUSH_ES_OUTPUT",
	[V_028A90_FLUSH_GS_OUTPUT] = "FLUSH_GS_OUTPUT",
	[V_028A90_SAMPLE_PIPELINESTAT] = "SAMPLE_PIPELINESTAT",
	[V_028A90_SO_VGTSTREAMOUT_FLUSH] = "SO_VGTSTREAMOUT_FLUSH",
	[V_028A90_SAMPLE_STREAMOUTSTATS] = "SAMPLE_STREAMOUTSTATS",
	[V_028A90_RESET_VTX_CNT] = "RESET_VTX_CNT",
	[V_028A90_BLOCK_CONTEXT_DONE] = "BLOCK_CONTEXT_DONE",
	[V_028A90_CS_CONTEXT_DONE] = "CS_CONTEXT_DONE",
	[V_028A90_VGT_FLUSH] = "VGT_FLUSH",
	[V_028A90_SC_SEND_DB_VPZ] = "SC_SEND_DB_VPZ",
	[V_028A90_BOTTOM_OF_PIPE_TS] = "BOTTOM_OF_PIPE_TS",
	[V_028A90_DB_CACHE_FLUSH_AND_INV] = "DB_CACHE_FLUSH_AND_INV",
	[V_028A90_FLUSH_AND_INV_DB_DATA_TS] = "FLUSH_AND_INV_DB_DATA_TS",
	[V_028A90_FLUSH_AND_INV_DB_META] = "FLUSH_AND_INV_DB_META",
	[V_028A90_FLUSH_AND_INV_CB_DATA_TS] = "FLUSH_AND_INV_CB_DATA_TS",
	[V_028A90_FLUSH_AND_INV_CB_META] = "FLUSH_AND_INV_CB_META",
	[V_028A90_CS_DONE] = "CS_DONE",
	[V_028A90_PS_DONE] = "PS_DONE",
	[V_028A90_FLUSH_AND_INV_CB_PIXEL_DATA] = "FLUSH_AND_INV_CB_PIXEL_DATA",
	[V_028A90_THREAD_TRACE_START] = "THREAD_TRACE_START",
	[V_028A90_THREAD_TRACE_STOP] = "THREAD_TRACE_STOP",
	[V_028A90_THREAD_TRACE_MARKER] = "THREAD_TRACE_MARKER",
	[V_028A90_THREAD_TRACE_FLUSH] = "THREAD_TRACE_FLUSH",
	[V_028A90_THREAD_TRACE_FINISH] = "THREAD_TRACE_FINISH",
	[V_028A90_PIXEL_PIPE_STAT_CONTROL] = "PIXEL_PIPE_STAT_CONTROL",
	[V_028A90_PIXEL_PIPE_STAT_DUMP] = "PIXEL_PIPE_STAT_DUMP",
	[V_028A90_PIXEL_PIPE_STAT_RESET] = "PIXEL_PIPE_STAT_RESET",
};

static const struct si_field r_028a90_vgt_event_initiator__fields[] = {
	{"EVENT_TYPE", S_028A90_EVENT_TYPE(~0u), ARRAY_SIZE(r_028a90_vgt_event_initiator__event_type__values), r_028a90_vgt_event_initiator__event_type__values},
	{"ADDRESS_HI", S_028A90_ADDRESS_HI(~0u)},
	{"EXTENDED_EVENT", S_028A90_EXTENDED_EVENT(~0u)},
};

static const struct si_field r_028a94_vgt_multi_prim_ib_reset_en__fields[] = {
	{"RESET_EN", S_028A94_RESET_EN(~0u)},
};

static const struct si_field r_028aa8_ia_multi_vgt_param__fields[] = {
	{"PRIMGROUP_SIZE", S_028AA8_PRIMGROUP_SIZE(~0u)},
	{"PARTIAL_VS_WAVE_ON", S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{"SWITCH_ON_EOP", S_028AA8_SWITCH_ON_EOP(~0u)},
	{"PARTIAL_ES_WAVE_ON", S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{"SWITCH_ON_EOI", S_028AA8_SWITCH_ON_EOI(~0u)},
	{"WD_SWITCH_ON_EOP", S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{"MAX_PRIMGRP_IN_WAVE", S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
};

static const struct si_field r_028aac_vgt_esgs_ring_itemsize__fields[] = {
	{"ITEMSIZE", S_028AAC_ITEMSIZE(~0u)},
};

static const struct si_field r_028ab0_vgt_gsvs_ring_itemsize__fields[] = {
	{"ITEMSIZE", S_028AB0_ITEMSIZE(~0u)},
};

static const struct si_field r_028ab4_vgt_reuse_off__fields[] = {
	{"REUSE_OFF", S_028AB4_REUSE_OFF(~0u)},
};

static const struct si_field r_028ab8_vgt_vtx_cnt_en__fields[] = {
	{"VTX_CNT_EN", S_028AB8_VTX_CNT_EN(~0u)},
};

static const struct si_field r_028abc_db_htile_surface__fields[] = {
	{"LINEAR", S_028ABC_LINEAR(~0u)},
	{"FULL_CACHE", S_028ABC_FULL_CACHE(~0u)},
	{"HTILE_USES_PRELOAD_WIN", S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{"PRELOAD", S_028ABC_PRELOAD(~0u)},
	{"PREFETCH_WIDTH", S_028ABC_PREFETCH_WIDTH(~0u)},
	{"PREFETCH_HEIGHT", S_028ABC_PREFETCH_HEIGHT(~0u)},
	{"DST_OUTSIDE_ZERO_TO_ONE", S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{"TC_COMPATIBLE", S_028ABC_TC_COMPATIBLE(~0u)},
};

static const char *r_028ac0_db_sresults_compare_state0__comparefunc0__values[] = {
	[V_028AC0_REF_NEVER] = "REF_NEVER",
	[V_028AC0_REF_LESS] = "REF_LESS",
	[V_028AC0_REF_EQUAL] = "REF_EQUAL",
	[V_028AC0_REF_LEQUAL] = "REF_LEQUAL",
	[V_028AC0_REF_GREATER] = "REF_GREATER",
	[V_028AC0_REF_NOTEQUAL] = "REF_NOTEQUAL",
	[V_028AC0_REF_GEQUAL] = "REF_GEQUAL",
	[V_028AC0_REF_ALWAYS] = "REF_ALWAYS",
};

static const struct si_field r_028ac0_db_sresults_compare_state0__fields[] = {
	{"COMPAREFUNC0", S_028AC0_COMPAREFUNC0(~0u), ARRAY_SIZE(r_028ac0_db_sresults_compare_state0__comparefunc0__values), r_028ac0_db_sresults_compare_state0__comparefunc0__values},
	{"COMPAREVALUE0", S_028AC0_COMPAREVALUE0(~0u)},
	{"COMPAREMASK0", S_028AC0_COMPAREMASK0(~0u)},
	{"ENABLE0", S_028AC0_ENABLE0(~0u)},
};

static const char *r_028ac4_db_sresults_compare_state1__comparefunc1__values[] = {
	[V_028AC4_REF_NEVER] = "REF_NEVER",
	[V_028AC4_REF_LESS] = "REF_LESS",
	[V_028AC4_REF_EQUAL] = "REF_EQUAL",
	[V_028AC4_REF_LEQUAL] = "REF_LEQUAL",
	[V_028AC4_REF_GREATER] = "REF_GREATER",
	[V_028AC4_REF_NOTEQUAL] = "REF_NOTEQUAL",
	[V_028AC4_REF_GEQUAL] = "REF_GEQUAL",
	[V_028AC4_REF_ALWAYS] = "REF_ALWAYS",
};

static const struct si_field r_028ac4_db_sresults_compare_state1__fields[] = {
	{"COMPAREFUNC1", S_028AC4_COMPAREFUNC1(~0u), ARRAY_SIZE(r_028ac4_db_sresults_compare_state1__comparefunc1__values), r_028ac4_db_sresults_compare_state1__comparefunc1__values},
	{"COMPAREVALUE1", S_028AC4_COMPAREVALUE1(~0u)},
	{"COMPAREMASK1", S_028AC4_COMPAREMASK1(~0u)},
	{"ENABLE1", S_028AC4_ENABLE1(~0u)},
};

static const struct si_field r_028ac8_db_preload_control__fields[] = {
	{"START_X", S_028AC8_START_X(~0u)},
	{"START_Y", S_028AC8_START_Y(~0u)},
	{"MAX_X", S_028AC8_MAX_X(~0u)},
	{"MAX_Y", S_028AC8_MAX_Y(~0u)},
};

static const struct si_field r_028ad4_vgt_strmout_vtx_stride_0__fields[] = {
	{"STRIDE", S_028AD4_STRIDE(~0u)},
};

static const struct si_field r_028ae4_vgt_strmout_vtx_stride_1__fields[] = {
	{"STRIDE", S_028AE4_STRIDE(~0u)},
};

static const struct si_field r_028af4_vgt_strmout_vtx_stride_2__fields[] = {
	{"STRIDE", S_028AF4_STRIDE(~0u)},
};

static const struct si_field r_028b04_vgt_strmout_vtx_stride_3__fields[] = {
	{"STRIDE", S_028B04_STRIDE(~0u)},
};

static const struct si_field r_028b30_vgt_strmout_draw_opaque_vertex_stride__fields[] = {
	{"VERTEX_STRIDE", S_028B30_VERTEX_STRIDE(~0u)},
};

static const struct si_field r_028b38_vgt_gs_max_vert_out__fields[] = {
	{"MAX_VERT_OUT", S_028B38_MAX_VERT_OUT(~0u)},
};

static const struct si_field r_028b50_vgt_tess_distribution__fields[] = {
	{"ACCUM_ISOLINE", S_028B50_ACCUM_ISOLINE(~0u)},
	{"ACCUM_TRI", S_028B50_ACCUM_TRI(~0u)},
	{"ACCUM_QUAD", S_028B50_ACCUM_QUAD(~0u)},
	{"DONUT_SPLIT", S_028B50_DONUT_SPLIT(~0u)},
};

static const char *r_028b54_vgt_shader_stages_en__ls_en__values[] = {
	[V_028B54_LS_STAGE_OFF] = "LS_STAGE_OFF",
	[V_028B54_LS_STAGE_ON] = "LS_STAGE_ON",
	[V_028B54_CS_STAGE_ON] = "CS_STAGE_ON",
};

static const char *r_028b54_vgt_shader_stages_en__es_en__values[] = {
	[V_028B54_ES_STAGE_OFF] = "ES_STAGE_OFF",
	[V_028B54_ES_STAGE_DS] = "ES_STAGE_DS",
	[V_028B54_ES_STAGE_REAL] = "ES_STAGE_REAL",
};

static const char *r_028b54_vgt_shader_stages_en__vs_en__values[] = {
	[V_028B54_VS_STAGE_REAL] = "VS_STAGE_REAL",
	[V_028B54_VS_STAGE_DS] = "VS_STAGE_DS",
	[V_028B54_VS_STAGE_COPY_SHADER] = "VS_STAGE_COPY_SHADER",
};

static const struct si_field r_028b54_vgt_shader_stages_en__fields[] = {
	{"LS_EN", S_028B54_LS_EN(~0u), ARRAY_SIZE(r_028b54_vgt_shader_stages_en__ls_en__values), r_028b54_vgt_shader_stages_en__ls_en__values},
	{"HS_EN", S_028B54_HS_EN(~0u)},
	{"ES_EN", S_028B54_ES_EN(~0u), ARRAY_SIZE(r_028b54_vgt_shader_stages_en__es_en__values), r_028b54_vgt_shader_stages_en__es_en__values},
	{"GS_EN", S_028B54_GS_EN(~0u)},
	{"VS_EN", S_028B54_VS_EN(~0u), ARRAY_SIZE(r_028b54_vgt_shader_stages_en__vs_en__values), r_028b54_vgt_shader_stages_en__vs_en__values},
	{"DYNAMIC_HS", S_028B54_DYNAMIC_HS(~0u)},
	{"DISPATCH_DRAW_EN", S_028B54_DISPATCH_DRAW_EN(~0u)},
	{"DIS_DEALLOC_ACCUM_0", S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{"DIS_DEALLOC_ACCUM_1", S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{"VS_WAVE_ID_EN", S_028B54_VS_WAVE_ID_EN(~0u)},
};

static const struct si_field r_028b58_vgt_ls_hs_config__fields[] = {
	{"NUM_PATCHES", S_028B58_NUM_PATCHES(~0u)},
	{"HS_NUM_INPUT_CP", S_028B58_HS_NUM_INPUT_CP(~0u)},
	{"HS_NUM_OUTPUT_CP", S_028B58_HS_NUM_OUTPUT_CP(~0u)},
};

static const struct si_field r_028b5c_vgt_gs_vert_itemsize__fields[] = {
	{"ITEMSIZE", S_028B5C_ITEMSIZE(~0u)},
};

static const struct si_field r_028b60_vgt_gs_vert_itemsize_1__fields[] = {
	{"ITEMSIZE", S_028B60_ITEMSIZE(~0u)},
};

static const struct si_field r_028b64_vgt_gs_vert_itemsize_2__fields[] = {
	{"ITEMSIZE", S_028B64_ITEMSIZE(~0u)},
};

static const struct si_field r_028b68_vgt_gs_vert_itemsize_3__fields[] = {
	{"ITEMSIZE", S_028B68_ITEMSIZE(~0u)},
};

static const char *r_028b6c_vgt_tf_param__type__values[] = {
	[V_028B6C_TESS_ISOLINE] = "TESS_ISOLINE",
	[V_028B6C_TESS_TRIANGLE] = "TESS_TRIANGLE",
	[V_028B6C_TESS_QUAD] = "TESS_QUAD",
};

static const char *r_028b6c_vgt_tf_param__partitioning__values[] = {
	[V_028B6C_PART_INTEGER] = "PART_INTEGER",
	[V_028B6C_PART_POW2] = "PART_POW2",
	[V_028B6C_PART_FRAC_ODD] = "PART_FRAC_ODD",
	[V_028B6C_PART_FRAC_EVEN] = "PART_FRAC_EVEN",
};

static const char *r_028b6c_vgt_tf_param__topology__values[] = {
	[V_028B6C_OUTPUT_POINT] = "OUTPUT_POINT",
	[V_028B6C_OUTPUT_LINE] = "OUTPUT_LINE",
	[V_028B6C_OUTPUT_TRIANGLE_CW] = "OUTPUT_TRIANGLE_CW",
	[V_028B6C_OUTPUT_TRIANGLE_CCW] = "OUTPUT_TRIANGLE_CCW",
};

static const char *r_028b6c_vgt_tf_param__rdreq_policy__values[] = {
	[V_028B6C_VGT_POLICY_LRU] = "VGT_POLICY_LRU",
	[V_028B6C_VGT_POLICY_STREAM] = "VGT_POLICY_STREAM",
	[V_028B6C_VGT_POLICY_BYPASS] = "VGT_POLICY_BYPASS",
};

static const struct si_field r_028b6c_vgt_tf_param__fields[] = {
	{"TYPE", S_028B6C_TYPE(~0u), ARRAY_SIZE(r_028b6c_vgt_tf_param__type__values), r_028b6c_vgt_tf_param__type__values},
	{"PARTITIONING", S_028B6C_PARTITIONING(~0u), ARRAY_SIZE(r_028b6c_vgt_tf_param__partitioning__values), r_028b6c_vgt_tf_param__partitioning__values},
	{"TOPOLOGY", S_028B6C_TOPOLOGY(~0u), ARRAY_SIZE(r_028b6c_vgt_tf_param__topology__values), r_028b6c_vgt_tf_param__topology__values},
	{"RESERVED_REDUC_AXIS", S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{"DEPRECATED", S_028B6C_DEPRECATED(~0u)},
	{"NUM_DS_WAVES_PER_SIMD", S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{"DISABLE_DONUTS", S_028B6C_DISABLE_DONUTS(~0u)},
	{"RDREQ_POLICY", S_028B6C_RDREQ_POLICY(~0u), ARRAY_SIZE(r_028b6c_vgt_tf_param__rdreq_policy__values), r_028b6c_vgt_tf_param__rdreq_policy__values},
	{"RDREQ_POLICY_VI", S_028B6C_RDREQ_POLICY_VI(~0u)},
	{"DISTRIBUTION_MODE", S_028B6C_DISTRIBUTION_MODE(~0u)},
	{"MTYPE", S_028B6C_MTYPE(~0u)},
};

static const struct si_field r_028b70_db_alpha_to_mask__fields[] = {
	{"ALPHA_TO_MASK_ENABLE", S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{"ALPHA_TO_MASK_OFFSET0", S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{"ALPHA_TO_MASK_OFFSET1", S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{"ALPHA_TO_MASK_OFFSET2", S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{"ALPHA_TO_MASK_OFFSET3", S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{"OFFSET_ROUND", S_028B70_OFFSET_ROUND(~0u)},
};

static const struct si_field r_028b78_pa_su_poly_offset_db_fmt_cntl__fields[] = {
	{"POLY_OFFSET_NEG_NUM_DB_BITS", S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{"POLY_OFFSET_DB_IS_FLOAT_FMT", S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
};

static const struct si_field r_028b90_vgt_gs_instance_cnt__fields[] = {
	{"ENABLE", S_028B90_ENABLE(~0u)},
	{"CNT", S_028B90_CNT(~0u)},
};

static const struct si_field r_028b94_vgt_strmout_config__fields[] = {
	{"STREAMOUT_0_EN", S_028B94_STREAMOUT_0_EN(~0u)},
	{"STREAMOUT_1_EN", S_028B94_STREAMOUT_1_EN(~0u)},
	{"STREAMOUT_2_EN", S_028B94_STREAMOUT_2_EN(~0u)},
	{"STREAMOUT_3_EN", S_028B94_STREAMOUT_3_EN(~0u)},
	{"RAST_STREAM", S_028B94_RAST_STREAM(~0u)},
	{"RAST_STREAM_MASK", S_028B94_RAST_STREAM_MASK(~0u)},
	{"USE_RAST_STREAM_MASK", S_028B94_USE_RAST_STREAM_MASK(~0u)},
};

static const struct si_field r_028b98_vgt_strmout_buffer_config__fields[] = {
	{"STREAM_0_BUFFER_EN", S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{"STREAM_1_BUFFER_EN", S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{"STREAM_2_BUFFER_EN", S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{"STREAM_3_BUFFER_EN", S_028B98_STREAM_3_BUFFER_EN(~0u)},
};

static const struct si_field r_028bd4_pa_sc_centroid_priority_0__fields[] = {
	{"DISTANCE_0", S_028BD4_DISTANCE_0(~0u)},
	{"DISTANCE_1", S_028BD4_DISTANCE_1(~0u)},
	{"DISTANCE_2", S_028BD4_DISTANCE_2(~0u)},
	{"DISTANCE_3", S_028BD4_DISTANCE_3(~0u)},
	{"DISTANCE_4", S_028BD4_DISTANCE_4(~0u)},
	{"DISTANCE_5", S_028BD4_DISTANCE_5(~0u)},
	{"DISTANCE_6", S_028BD4_DISTANCE_6(~0u)},
	{"DISTANCE_7", S_028BD4_DISTANCE_7(~0u)},
};

static const struct si_field r_028bd8_pa_sc_centroid_priority_1__fields[] = {
	{"DISTANCE_8", S_028BD8_DISTANCE_8(~0u)},
	{"DISTANCE_9", S_028BD8_DISTANCE_9(~0u)},
	{"DISTANCE_10", S_028BD8_DISTANCE_10(~0u)},
	{"DISTANCE_11", S_028BD8_DISTANCE_11(~0u)},
	{"DISTANCE_12", S_028BD8_DISTANCE_12(~0u)},
	{"DISTANCE_13", S_028BD8_DISTANCE_13(~0u)},
	{"DISTANCE_14", S_028BD8_DISTANCE_14(~0u)},
	{"DISTANCE_15", S_028BD8_DISTANCE_15(~0u)},
};

static const struct si_field r_028bdc_pa_sc_line_cntl__fields[] = {
	{"EXPAND_LINE_WIDTH", S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{"LAST_PIXEL", S_028BDC_LAST_PIXEL(~0u)},
	{"PERPENDICULAR_ENDCAP_ENA", S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{"DX10_DIAMOND_TEST_ENA", S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
};

static const struct si_field r_028be0_pa_sc_aa_config__fields[] = {
	{"MSAA_NUM_SAMPLES", S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{"AA_MASK_CENTROID_DTMN", S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{"MAX_SAMPLE_DIST", S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{"MSAA_EXPOSED_SAMPLES", S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{"DETAIL_TO_EXPOSED_MODE", S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
};

static const char *r_028be4_pa_su_vtx_cntl__round_mode__values[] = {
	[V_028BE4_X_TRUNCATE] = "X_TRUNCATE",
	[V_028BE4_X_ROUND] = "X_ROUND",
	[V_028BE4_X_ROUND_TO_EVEN] = "X_ROUND_TO_EVEN",
	[V_028BE4_X_ROUND_TO_ODD] = "X_ROUND_TO_ODD",
};

static const char *r_028be4_pa_su_vtx_cntl__quant_mode__values[] = {
	[V_028BE4_X_16_8_FIXED_POINT_1_16TH] = "X_16_8_FIXED_POINT_1_16TH",
	[V_028BE4_X_16_8_FIXED_POINT_1_8TH] = "X_16_8_FIXED_POINT_1_8TH",
	[V_028BE4_X_16_8_FIXED_POINT_1_4TH] = "X_16_8_FIXED_POINT_1_4TH",
	[V_028BE4_X_16_8_FIXED_POINT_1_2] = "X_16_8_FIXED_POINT_1_2",
	[V_028BE4_X_16_8_FIXED_POINT_1] = "X_16_8_FIXED_POINT_1",
	[V_028BE4_X_16_8_FIXED_POINT_1_256TH] = "X_16_8_FIXED_POINT_1_256TH",
	[V_028BE4_X_14_10_FIXED_POINT_1_1024TH] = "X_14_10_FIXED_POINT_1_1024TH",
	[V_028BE4_X_12_12_FIXED_POINT_1_4096TH] = "X_12_12_FIXED_POINT_1_4096TH",
};

static const struct si_field r_028be4_pa_su_vtx_cntl__fields[] = {
	{"PIX_CENTER", S_028BE4_PIX_CENTER(~0u)},
	{"ROUND_MODE", S_028BE4_ROUND_MODE(~0u), ARRAY_SIZE(r_028be4_pa_su_vtx_cntl__round_mode__values), r_028be4_pa_su_vtx_cntl__round_mode__values},
	{"QUANT_MODE", S_028BE4_QUANT_MODE(~0u), ARRAY_SIZE(r_028be4_pa_su_vtx_cntl__quant_mode__values), r_028be4_pa_su_vtx_cntl__quant_mode__values},
};

static const struct si_field r_028bf8_pa_sc_aa_sample_locs_pixel_x0y0_0__fields[] = {
	{"S0_X", S_028BF8_S0_X(~0u)},
	{"S0_Y", S_028BF8_S0_Y(~0u)},
	{"S1_X", S_028BF8_S1_X(~0u)},
	{"S1_Y", S_028BF8_S1_Y(~0u)},
	{"S2_X", S_028BF8_S2_X(~0u)},
	{"S2_Y", S_028BF8_S2_Y(~0u)},
	{"S3_X", S_028BF8_S3_X(~0u)},
	{"S3_Y", S_028BF8_S3_Y(~0u)},
};

static const struct si_field r_028bfc_pa_sc_aa_sample_locs_pixel_x0y0_1__fields[] = {
	{"S4_X", S_028BFC_S4_X(~0u)},
	{"S4_Y", S_028BFC_S4_Y(~0u)},
	{"S5_X", S_028BFC_S5_X(~0u)},
	{"S5_Y", S_028BFC_S5_Y(~0u)},
	{"S6_X", S_028BFC_S6_X(~0u)},
	{"S6_Y", S_028BFC_S6_Y(~0u)},
	{"S7_X", S_028BFC_S7_X(~0u)},
	{"S7_Y", S_028BFC_S7_Y(~0u)},
};

static const struct si_field r_028c00_pa_sc_aa_sample_locs_pixel_x0y0_2__fields[] = {
	{"S8_X", S_028C00_S8_X(~0u)},
	{"S8_Y", S_028C00_S8_Y(~0u)},
	{"S9_X", S_028C00_S9_X(~0u)},
	{"S9_Y", S_028C00_S9_Y(~0u)},
	{"S10_X", S_028C00_S10_X(~0u)},
	{"S10_Y", S_028C00_S10_Y(~0u)},
	{"S11_X", S_028C00_S11_X(~0u)},
	{"S11_Y", S_028C00_S11_Y(~0u)},
};

static const struct si_field r_028c04_pa_sc_aa_sample_locs_pixel_x0y0_3__fields[] = {
	{"S12_X", S_028C04_S12_X(~0u)},
	{"S12_Y", S_028C04_S12_Y(~0u)},
	{"S13_X", S_028C04_S13_X(~0u)},
	{"S13_Y", S_028C04_S13_Y(~0u)},
	{"S14_X", S_028C04_S14_X(~0u)},
	{"S14_Y", S_028C04_S14_Y(~0u)},
	{"S15_X", S_028C04_S15_X(~0u)},
	{"S15_Y", S_028C04_S15_Y(~0u)},
};

static const struct si_field r_028c08_pa_sc_aa_sample_locs_pixel_x1y0_0__fields[] = {
	{"S0_X", S_028C08_S0_X(~0u)},
	{"S0_Y", S_028C08_S0_Y(~0u)},
	{"S1_X", S_028C08_S1_X(~0u)},
	{"S1_Y", S_028C08_S1_Y(~0u)},
	{"S2_X", S_028C08_S2_X(~0u)},
	{"S2_Y", S_028C08_S2_Y(~0u)},
	{"S3_X", S_028C08_S3_X(~0u)},
	{"S3_Y", S_028C08_S3_Y(~0u)},
};

static const struct si_field r_028c0c_pa_sc_aa_sample_locs_pixel_x1y0_1__fields[] = {
	{"S4_X", S_028C0C_S4_X(~0u)},
	{"S4_Y", S_028C0C_S4_Y(~0u)},
	{"S5_X", S_028C0C_S5_X(~0u)},
	{"S5_Y", S_028C0C_S5_Y(~0u)},
	{"S6_X", S_028C0C_S6_X(~0u)},
	{"S6_Y", S_028C0C_S6_Y(~0u)},
	{"S7_X", S_028C0C_S7_X(~0u)},
	{"S7_Y", S_028C0C_S7_Y(~0u)},
};

static const struct si_field r_028c10_pa_sc_aa_sample_locs_pixel_x1y0_2__fields[] = {
	{"S8_X", S_028C10_S8_X(~0u)},
	{"S8_Y", S_028C10_S8_Y(~0u)},
	{"S9_X", S_028C10_S9_X(~0u)},
	{"S9_Y", S_028C10_S9_Y(~0u)},
	{"S10_X", S_028C10_S10_X(~0u)},
	{"S10_Y", S_028C10_S10_Y(~0u)},
	{"S11_X", S_028C10_S11_X(~0u)},
	{"S11_Y", S_028C10_S11_Y(~0u)},
};

static const struct si_field r_028c14_pa_sc_aa_sample_locs_pixel_x1y0_3__fields[] = {
	{"S12_X", S_028C14_S12_X(~0u)},
	{"S12_Y", S_028C14_S12_Y(~0u)},
	{"S13_X", S_028C14_S13_X(~0u)},
	{"S13_Y", S_028C14_S13_Y(~0u)},
	{"S14_X", S_028C14_S14_X(~0u)},
	{"S14_Y", S_028C14_S14_Y(~0u)},
	{"S15_X", S_028C14_S15_X(~0u)},
	{"S15_Y", S_028C14_S15_Y(~0u)},
};

static const struct si_field r_028c18_pa_sc_aa_sample_locs_pixel_x0y1_0__fields[] = {
	{"S0_X", S_028C18_S0_X(~0u)},
	{"S0_Y", S_028C18_S0_Y(~0u)},
	{"S1_X", S_028C18_S1_X(~0u)},
	{"S1_Y", S_028C18_S1_Y(~0u)},
	{"S2_X", S_028C18_S2_X(~0u)},
	{"S2_Y", S_028C18_S2_Y(~0u)},
	{"S3_X", S_028C18_S3_X(~0u)},
	{"S3_Y", S_028C18_S3_Y(~0u)},
};

static const struct si_field r_028c1c_pa_sc_aa_sample_locs_pixel_x0y1_1__fields[] = {
	{"S4_X", S_028C1C_S4_X(~0u)},
	{"S4_Y", S_028C1C_S4_Y(~0u)},
	{"S5_X", S_028C1C_S5_X(~0u)},
	{"S5_Y", S_028C1C_S5_Y(~0u)},
	{"S6_X", S_028C1C_S6_X(~0u)},
	{"S6_Y", S_028C1C_S6_Y(~0u)},
	{"S7_X", S_028C1C_S7_X(~0u)},
	{"S7_Y", S_028C1C_S7_Y(~0u)},
};

static const struct si_field r_028c20_pa_sc_aa_sample_locs_pixel_x0y1_2__fields[] = {
	{"S8_X", S_028C20_S8_X(~0u)},
	{"S8_Y", S_028C20_S8_Y(~0u)},
	{"S9_X", S_028C20_S9_X(~0u)},
	{"S9_Y", S_028C20_S9_Y(~0u)},
	{"S10_X", S_028C20_S10_X(~0u)},
	{"S10_Y", S_028C20_S10_Y(~0u)},
	{"S11_X", S_028C20_S11_X(~0u)},
	{"S11_Y", S_028C20_S11_Y(~0u)},
};

static const struct si_field r_028c24_pa_sc_aa_sample_locs_pixel_x0y1_3__fields[] = {
	{"S12_X", S_028C24_S12_X(~0u)},
	{"S12_Y", S_028C24_S12_Y(~0u)},
	{"S13_X", S_028C24_S13_X(~0u)},
	{"S13_Y", S_028C24_S13_Y(~0u)},
	{"S14_X", S_028C24_S14_X(~0u)},
	{"S14_Y", S_028C24_S14_Y(~0u)},
	{"S15_X", S_028C24_S15_X(~0u)},
	{"S15_Y", S_028C24_S15_Y(~0u)},
};

static const struct si_field r_028c28_pa_sc_aa_sample_locs_pixel_x1y1_0__fields[] = {
	{"S0_X", S_028C28_S0_X(~0u)},
	{"S0_Y", S_028C28_S0_Y(~0u)},
	{"S1_X", S_028C28_S1_X(~0u)},
	{"S1_Y", S_028C28_S1_Y(~0u)},
	{"S2_X", S_028C28_S2_X(~0u)},
	{"S2_Y", S_028C28_S2_Y(~0u)},
	{"S3_X", S_028C28_S3_X(~0u)},
	{"S3_Y", S_028C28_S3_Y(~0u)},
};

static const struct si_field r_028c2c_pa_sc_aa_sample_locs_pixel_x1y1_1__fields[] = {
	{"S4_X", S_028C2C_S4_X(~0u)},
	{"S4_Y", S_028C2C_S4_Y(~0u)},
	{"S5_X", S_028C2C_S5_X(~0u)},
	{"S5_Y", S_028C2C_S5_Y(~0u)},
	{"S6_X", S_028C2C_S6_X(~0u)},
	{"S6_Y", S_028C2C_S6_Y(~0u)},
	{"S7_X", S_028C2C_S7_X(~0u)},
	{"S7_Y", S_028C2C_S7_Y(~0u)},
};

static const struct si_field r_028c30_pa_sc_aa_sample_locs_pixel_x1y1_2__fields[] = {
	{"S8_X", S_028C30_S8_X(~0u)},
	{"S8_Y", S_028C30_S8_Y(~0u)},
	{"S9_X", S_028C30_S9_X(~0u)},
	{"S9_Y", S_028C30_S9_Y(~0u)},
	{"S10_X", S_028C30_S10_X(~0u)},
	{"S10_Y", S_028C30_S10_Y(~0u)},
	{"S11_X", S_028C30_S11_X(~0u)},
	{"S11_Y", S_028C30_S11_Y(~0u)},
};

static const struct si_field r_028c34_pa_sc_aa_sample_locs_pixel_x1y1_3__fields[] = {
	{"S12_X", S_028C34_S12_X(~0u)},
	{"S12_Y", S_028C34_S12_Y(~0u)},
	{"S13_X", S_028C34_S13_X(~0u)},
	{"S13_Y", S_028C34_S13_Y(~0u)},
	{"S14_X", S_028C34_S14_X(~0u)},
	{"S14_Y", S_028C34_S14_Y(~0u)},
	{"S15_X", S_028C34_S15_X(~0u)},
	{"S15_Y", S_028C34_S15_Y(~0u)},
};

static const struct si_field r_028c38_pa_sc_aa_mask_x0y0_x1y0__fields[] = {
	{"AA_MASK_X0Y0", S_028C38_AA_MASK_X0Y0(~0u)},
	{"AA_MASK_X1Y0", S_028C38_AA_MASK_X1Y0(~0u)},
};

static const struct si_field r_028c3c_pa_sc_aa_mask_x0y1_x1y1__fields[] = {
	{"AA_MASK_X0Y1", S_028C3C_AA_MASK_X0Y1(~0u)},
	{"AA_MASK_X1Y1", S_028C3C_AA_MASK_X1Y1(~0u)},
};

static const struct si_field r_028c40_pa_sc_shader_control__fields[] = {
	{"REALIGN_DQUADS_AFTER_N_WAVES", S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
};

static const struct si_field r_028c58_vgt_vertex_reuse_block_cntl__fields[] = {
	{"VTX_REUSE_DEPTH", S_028C58_VTX_REUSE_DEPTH(~0u)},
};

static const struct si_field r_028c5c_vgt_out_dealloc_cntl__fields[] = {
	{"DEALLOC_DIST", S_028C5C_DEALLOC_DIST(~0u)},
};

static const struct si_field r_028c64_cb_color0_pitch__fields[] = {
	{"TILE_MAX", S_028C64_TILE_MAX(~0u)},
	{"FMASK_TILE_MAX", S_028C64_FMASK_TILE_MAX(~0u)},
};

static const struct si_field r_028c68_cb_color0_slice__fields[] = {
	{"TILE_MAX", S_028C68_TILE_MAX(~0u)},
};

static const struct si_field r_028c6c_cb_color0_view__fields[] = {
	{"SLICE_START", S_028C6C_SLICE_START(~0u)},
	{"SLICE_MAX", S_028C6C_SLICE_MAX(~0u)},
};

static const char *r_028c70_cb_color0_info__endian__values[] = {
	[V_028C70_ENDIAN_NONE] = "ENDIAN_NONE",
	[V_028C70_ENDIAN_8IN16] = "ENDIAN_8IN16",
	[V_028C70_ENDIAN_8IN32] = "ENDIAN_8IN32",
	[V_028C70_ENDIAN_8IN64] = "ENDIAN_8IN64",
};

static const char *r_028c70_cb_color0_info__format__values[] = {
	[V_028C70_COLOR_INVALID] = "COLOR_INVALID",
	[V_028C70_COLOR_8] = "COLOR_8",
	[V_028C70_COLOR_16] = "COLOR_16",
	[V_028C70_COLOR_8_8] = "COLOR_8_8",
	[V_028C70_COLOR_32] = "COLOR_32",
	[V_028C70_COLOR_16_16] = "COLOR_16_16",
	[V_028C70_COLOR_10_11_11] = "COLOR_10_11_11",
	[V_028C70_COLOR_11_11_10] = "COLOR_11_11_10",
	[V_028C70_COLOR_10_10_10_2] = "COLOR_10_10_10_2",
	[V_028C70_COLOR_2_10_10_10] = "COLOR_2_10_10_10",
	[V_028C70_COLOR_8_8_8_8] = "COLOR_8_8_8_8",
	[V_028C70_COLOR_32_32] = "COLOR_32_32",
	[V_028C70_COLOR_16_16_16_16] = "COLOR_16_16_16_16",
	[V_028C70_COLOR_32_32_32_32] = "COLOR_32_32_32_32",
	[V_028C70_COLOR_5_6_5] = "COLOR_5_6_5",
	[V_028C70_COLOR_1_5_5_5] = "COLOR_1_5_5_5",
	[V_028C70_COLOR_5_5_5_1] = "COLOR_5_5_5_1",
	[V_028C70_COLOR_4_4_4_4] = "COLOR_4_4_4_4",
	[V_028C70_COLOR_8_24] = "COLOR_8_24",
	[V_028C70_COLOR_24_8] = "COLOR_24_8",
	[V_028C70_COLOR_X24_8_32_FLOAT] = "COLOR_X24_8_32_FLOAT",
};

static const char *r_028c70_cb_color0_info__number_type__values[] = {
	[V_028C70_NUMBER_UNORM] = "NUMBER_UNORM",
	[V_028C70_NUMBER_SNORM] = "NUMBER_SNORM",
	[V_028C70_NUMBER_UINT] = "NUMBER_UINT",
	[V_028C70_NUMBER_SINT] = "NUMBER_SINT",
	[V_028C70_NUMBER_SRGB] = "NUMBER_SRGB",
	[V_028C70_NUMBER_FLOAT] = "NUMBER_FLOAT",
};

static const char *r_028c70_cb_color0_info__comp_swap__values[] = {
	[V_028C70_SWAP_STD] = "SWAP_STD",
	[V_028C70_SWAP_ALT] = "SWAP_ALT",
	[V_028C70_SWAP_STD_REV] = "SWAP_STD_REV",
	[V_028C70_SWAP_ALT_REV] = "SWAP_ALT_REV",
};

static const char *r_028c70_cb_color0_info__blend_opt_dont_rd_dst__values[] = {
	[V_028C70_FORCE_OPT_AUTO] = "FORCE_OPT_AUTO",
	[V_028C70_FORCE_OPT_DISABLE] = "FORCE_OPT_DISABLE",
	[V_028C70_FORCE_OPT_ENABLE_IF_SRC_A_0] = "FORCE_OPT_ENABLE_IF_SRC_A_0",
	[V_028C70_FORCE_OPT_ENABLE_IF_SRC_RGB_0] = "FORCE_OPT_ENABLE_IF_SRC_RGB_0",
	[V_028C70_FORCE_OPT_ENABLE_IF_SRC_ARGB_0] = "FORCE_OPT_ENABLE_IF_SRC_ARGB_0",
	[V_028C70_FORCE_OPT_ENABLE_IF_SRC_A_1] = "FORCE_OPT_ENABLE_IF_SRC_A_1",
	[V_028C70_FORCE_OPT_ENABLE_IF_SRC_RGB_1] = "FORCE_OPT_ENABLE_IF_SRC_RGB_1",
	[V_028C70_FORCE_OPT_ENABLE_IF_SRC_ARGB_1] = "FORCE_OPT_ENABLE_IF_SRC_ARGB_1",
};

static const char *r_028c70_cb_color0_info__blend_opt_discard_pixel__values[] = {
	[V_028C70_FORCE_OPT_AUTO] = "FORCE_OPT_AUTO",
	[V_028C70_FORCE_OPT_DISABLE] = "FORCE_OPT_DISABLE",
	[V_028C70_FORCE_OPT_ENABLE_IF_SRC_A_0] = "FORCE_OPT_ENABLE_IF_SRC_A_0",
	[V_028C70_FORCE_OPT_ENABLE_IF_SRC_RGB_0] = "FORCE_OPT_ENABLE_IF_SRC_RGB_0",
	[V_028C70_FORCE_OPT_ENABLE_IF_SRC_ARGB_0] = "FORCE_OPT_ENABLE_IF_SRC_ARGB_0",
	[V_028C70_FORCE_OPT_ENABLE_IF_SRC_A_1] = "FORCE_OPT_ENABLE_IF_SRC_A_1",
	[V_028C70_FORCE_OPT_ENABLE_IF_SRC_RGB_1] = "FORCE_OPT_ENABLE_IF_SRC_RGB_1",
	[V_028C70_FORCE_OPT_ENABLE_IF_SRC_ARGB_1] = "FORCE_OPT_ENABLE_IF_SRC_ARGB_1",
};

static const struct si_field r_028c70_cb_color0_info__fields[] = {
	{"ENDIAN", S_028C70_ENDIAN(~0u), ARRAY_SIZE(r_028c70_cb_color0_info__endian__values), r_028c70_cb_color0_info__endian__values},
	{"FORMAT", S_028C70_FORMAT(~0u), ARRAY_SIZE(r_028c70_cb_color0_info__format__values), r_028c70_cb_color0_info__format__values},
	{"LINEAR_GENERAL", S_028C70_LINEAR_GENERAL(~0u)},
	{"NUMBER_TYPE", S_028C70_NUMBER_TYPE(~0u), ARRAY_SIZE(r_028c70_cb_color0_info__number_type__values), r_028c70_cb_color0_info__number_type__values},
	{"COMP_SWAP", S_028C70_COMP_SWAP(~0u), ARRAY_SIZE(r_028c70_cb_color0_info__comp_swap__values), r_028c70_cb_color0_info__comp_swap__values},
	{"FAST_CLEAR", S_028C70_FAST_CLEAR(~0u)},
	{"COMPRESSION", S_028C70_COMPRESSION(~0u)},
	{"BLEND_CLAMP", S_028C70_BLEND_CLAMP(~0u)},
	{"BLEND_BYPASS", S_028C70_BLEND_BYPASS(~0u)},
	{"SIMPLE_FLOAT", S_028C70_SIMPLE_FLOAT(~0u)},
	{"ROUND_MODE", S_028C70_ROUND_MODE(~0u)},
	{"CMASK_IS_LINEAR", S_028C70_CMASK_IS_LINEAR(~0u)},
	{"BLEND_OPT_DONT_RD_DST", S_028C70_BLEND_OPT_DONT_RD_DST(~0u), ARRAY_SIZE(r_028c70_cb_color0_info__blend_opt_dont_rd_dst__values), r_028c70_cb_color0_info__blend_opt_dont_rd_dst__values},
	{"BLEND_OPT_DISCARD_PIXEL", S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), ARRAY_SIZE(r_028c70_cb_color0_info__blend_opt_discard_pixel__values), r_028c70_cb_color0_info__blend_opt_discard_pixel__values},
	{"FMASK_COMPRESSION_DISABLE", S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{"FMASK_COMPRESS_1FRAG_ONLY", S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{"DCC_ENABLE", S_028C70_DCC_ENABLE(~0u)},
	{"CMASK_ADDR_TYPE", S_028C70_CMASK_ADDR_TYPE(~0u)},
};

static const struct si_field r_028c74_cb_color0_attrib__fields[] = {
	{"TILE_MODE_INDEX", S_028C74_TILE_MODE_INDEX(~0u)},
	{"FMASK_TILE_MODE_INDEX", S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{"FMASK_BANK_HEIGHT", S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{"NUM_SAMPLES", S_028C74_NUM_SAMPLES(~0u)},
	{"NUM_FRAGMENTS", S_028C74_NUM_FRAGMENTS(~0u)},
	{"FORCE_DST_ALPHA_1", S_028C74_FORCE_DST_ALPHA_1(~0u)},
};

static const struct si_field r_028c78_cb_color0_dcc_control__fields[] = {
	{"OVERWRITE_COMBINER_DISABLE", S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{"KEY_CLEAR_ENABLE", S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{"MAX_UNCOMPRESSED_BLOCK_SIZE", S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u)},
	{"MIN_COMPRESSED_BLOCK_SIZE", S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u)},
	{"MAX_COMPRESSED_BLOCK_SIZE", S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{"COLOR_TRANSFORM", S_028C78_COLOR_TRANSFORM(~0u)},
	{"INDEPENDENT_64B_BLOCKS", S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{"LOSSY_RGB_PRECISION", S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{"LOSSY_ALPHA_PRECISION", S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
};

static const struct si_field r_028c80_cb_color0_cmask_slice__fields[] = {
	{"TILE_MAX", S_028C80_TILE_MAX(~0u)},
};

static const struct si_field r_028c88_cb_color0_fmask_slice__fields[] = {
	{"TILE_MAX", S_028C88_TILE_MAX(~0u)},
};

static const struct si_reg reg_table[] = {
	{"CONTROL", R_370_CONTROL, ARRAY_SIZE(r_370_control__fields), r_370_control__fields},
	{"DST_ADDR_LO", R_371_DST_ADDR_LO},
	{"DST_ADDR_HI", R_372_DST_ADDR_HI},
	{"CP_DMA_WORD0", R_410_CP_DMA_WORD0, ARRAY_SIZE(r_410_cp_dma_word0__fields), r_410_cp_dma_word0__fields},
	{"CP_DMA_WORD1", R_411_CP_DMA_WORD1, ARRAY_SIZE(r_411_cp_dma_word1__fields), r_411_cp_dma_word1__fields},
	{"CP_DMA_WORD2", R_412_CP_DMA_WORD2, ARRAY_SIZE(r_412_cp_dma_word2__fields), r_412_cp_dma_word2__fields},
	{"CP_DMA_WORD3", R_413_CP_DMA_WORD3, ARRAY_SIZE(r_413_cp_dma_word3__fields), r_413_cp_dma_word3__fields},
	{"COMMAND", R_414_COMMAND, ARRAY_SIZE(r_414_command__fields), r_414_command__fields},
	{"DMA_DATA_WORD0", R_500_DMA_DATA_WORD0, ARRAY_SIZE(r_500_dma_data_word0__fields), r_500_dma_data_word0__fields},
	{"SRC_ADDR_LO", R_501_SRC_ADDR_LO},
	{"SRC_ADDR_HI", R_502_SRC_ADDR_HI},
	{"DST_ADDR_LO", R_503_DST_ADDR_LO},
	{"DST_ADDR_HI", R_504_DST_ADDR_HI},
	{"SRBM_STATUS2", R_000E4C_SRBM_STATUS2, ARRAY_SIZE(r_000e4c_srbm_status2__fields), r_000e4c_srbm_status2__fields},
	{"SRBM_STATUS", R_000E50_SRBM_STATUS, ARRAY_SIZE(r_000e50_srbm_status__fields), r_000e50_srbm_status__fields},
	{"SRBM_STATUS3", R_000E54_SRBM_STATUS3, ARRAY_SIZE(r_000e54_srbm_status3__fields), r_000e54_srbm_status3__fields},
	{"SDMA0_STATUS_REG", R_00D034_SDMA0_STATUS_REG, ARRAY_SIZE(r_00d034_sdma0_status_reg__fields), r_00d034_sdma0_status_reg__fields},
	{"SDMA1_STATUS_REG", R_00D834_SDMA1_STATUS_REG, ARRAY_SIZE(r_00d034_sdma0_status_reg__fields), r_00d034_sdma0_status_reg__fields},
	{"GRBM_STATUS2", R_008008_GRBM_STATUS2, ARRAY_SIZE(r_008008_grbm_status2__fields), r_008008_grbm_status2__fields},
	{"GRBM_STATUS", R_008010_GRBM_STATUS, ARRAY_SIZE(r_008010_grbm_status__fields), r_008010_grbm_status__fields},
	{"CP_STRMOUT_CNTL", R_0084FC_CP_STRMOUT_CNTL, ARRAY_SIZE(r_0084fc_cp_strmout_cntl__fields), r_0084fc_cp_strmout_cntl__fields},
	{"CP_COHER_CNTL", R_0085F0_CP_COHER_CNTL, ARRAY_SIZE(r_0085f0_cp_coher_cntl__fields), r_0085f0_cp_coher_cntl__fields},
	{"CP_COHER_SIZE", R_0085F4_CP_COHER_SIZE},
	{"CP_COHER_BASE", R_0085F8_CP_COHER_BASE},
	{"GRBM_STATUS_SE0", R_008014_GRBM_STATUS_SE0, ARRAY_SIZE(r_008014_grbm_status_se0__fields), r_008014_grbm_status_se0__fields},
	{"GRBM_STATUS_SE1", R_008018_GRBM_STATUS_SE1, ARRAY_SIZE(r_008018_grbm_status_se1__fields), r_008018_grbm_status_se1__fields},
	{"GRBM_STATUS_SE2", R_008038_GRBM_STATUS_SE2, ARRAY_SIZE(r_008038_grbm_status_se2__fields), r_008038_grbm_status_se2__fields},
	{"GRBM_STATUS_SE3", R_00803C_GRBM_STATUS_SE3, ARRAY_SIZE(r_00803c_grbm_status_se3__fields), r_00803c_grbm_status_se3__fields},
	{"CP_STRMOUT_CNTL", R_0300FC_CP_STRMOUT_CNTL, ARRAY_SIZE(r_0300fc_cp_strmout_cntl__fields), r_0300fc_cp_strmout_cntl__fields},
	{"CP_COHER_BASE_HI", R_0301E4_CP_COHER_BASE_HI, ARRAY_SIZE(r_0301e4_cp_coher_base_hi__fields), r_0301e4_cp_coher_base_hi__fields},
	{"CP_COHER_START_DELAY", R_0301EC_CP_COHER_START_DELAY, ARRAY_SIZE(r_0301ec_cp_coher_start_delay__fields), r_0301ec_cp_coher_start_delay__fields},
	{"CP_COHER_CNTL", R_0301F0_CP_COHER_CNTL, ARRAY_SIZE(r_0301f0_cp_coher_cntl__fields), r_0301f0_cp_coher_cntl__fields},
	{"CP_COHER_SIZE", R_0301F4_CP_COHER_SIZE},
	{"CP_COHER_BASE", R_0301F8_CP_COHER_BASE},
	{"CP_COHER_STATUS", R_0301FC_CP_COHER_STATUS, ARRAY_SIZE(r_0301fc_cp_coher_status__fields), r_0301fc_cp_coher_status__fields},
	{"CP_CPC_STATUS", R_008210_CP_CPC_STATUS, ARRAY_SIZE(r_008210_cp_cpc_status__fields), r_008210_cp_cpc_status__fields},
	{"CP_CPC_BUSY_STAT", R_008214_CP_CPC_BUSY_STAT, ARRAY_SIZE(r_008214_cp_cpc_busy_stat__fields), r_008214_cp_cpc_busy_stat__fields},
	{"CP_CPC_STALLED_STAT1", R_008218_CP_CPC_STALLED_STAT1, ARRAY_SIZE(r_008218_cp_cpc_stalled_stat1__fields), r_008218_cp_cpc_stalled_stat1__fields},
	{"CP_CPF_STATUS", R_00821C_CP_CPF_STATUS, ARRAY_SIZE(r_00821c_cp_cpf_status__fields), r_00821c_cp_cpf_status__fields},
	{"CP_CPF_BUSY_STAT", R_008220_CP_CPF_BUSY_STAT, ARRAY_SIZE(r_008220_cp_cpf_busy_stat__fields), r_008220_cp_cpf_busy_stat__fields},
	{"CP_CPF_STALLED_STAT1", R_008224_CP_CPF_STALLED_STAT1, ARRAY_SIZE(r_008224_cp_cpf_stalled_stat1__fields), r_008224_cp_cpf_stalled_stat1__fields},
	{"CP_COHER_SIZE_HI", R_030230_CP_COHER_SIZE_HI, ARRAY_SIZE(r_030230_cp_coher_size_hi__fields), r_030230_cp_coher_size_hi__fields},
	{"VGT_VTX_VECT_EJECT_REG", R_0088B0_VGT_VTX_VECT_EJECT_REG, ARRAY_SIZE(r_0088b0_vgt_vtx_vect_eject_reg__fields), r_0088b0_vgt_vtx_vect_eject_reg__fields},
	{"VGT_CACHE_INVALIDATION", R_0088C4_VGT_CACHE_INVALIDATION, ARRAY_SIZE(r_0088c4_vgt_cache_invalidation__fields), r_0088c4_vgt_cache_invalidation__fields},
	{"VGT_ESGS_RING_SIZE", R_0088C8_VGT_ESGS_RING_SIZE},
	{"VGT_GSVS_RING_SIZE", R_0088CC_VGT_GSVS_RING_SIZE},
	{"VGT_GS_VERTEX_REUSE", R_0088D4_VGT_GS_VERTEX_REUSE, ARRAY_SIZE(r_0088d4_vgt_gs_vertex_reuse__fields), r_0088d4_vgt_gs_vertex_reuse__fields},
	{"VGT_PRIMITIVE_TYPE", R_008958_VGT_PRIMITIVE_TYPE, ARRAY_SIZE(r_008958_vgt_primitive_type__fields), r_008958_vgt_primitive_type__fields},
	{"VGT_INDEX_TYPE", R_00895C_VGT_INDEX_TYPE, ARRAY_SIZE(r_00895c_vgt_index_type__fields), r_00895c_vgt_index_type__fields},
	{"VGT_STRMOUT_BUFFER_FILLED_SIZE_0", R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{"VGT_STRMOUT_BUFFER_FILLED_SIZE_1", R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{"VGT_STRMOUT_BUFFER_FILLED_SIZE_2", R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{"VGT_STRMOUT_BUFFER_FILLED_SIZE_3", R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{"VGT_NUM_INDICES", R_008970_VGT_NUM_INDICES},
	{"VGT_NUM_INSTANCES", R_008974_VGT_NUM_INSTANCES},
	{"VGT_TF_RING_SIZE", R_008988_VGT_TF_RING_SIZE, ARRAY_SIZE(r_008988_vgt_tf_ring_size__fields), r_008988_vgt_tf_ring_size__fields},
	{"VGT_HS_OFFCHIP_PARAM", R_0089B0_VGT_HS_OFFCHIP_PARAM, ARRAY_SIZE(r_0089b0_vgt_hs_offchip_param__fields), r_0089b0_vgt_hs_offchip_param__fields},
	{"VGT_TF_MEMORY_BASE", R_0089B8_VGT_TF_MEMORY_BASE},
	{"PA_CL_ENHANCE", R_008A14_PA_CL_ENHANCE, ARRAY_SIZE(r_008a14_pa_cl_enhance__fields), r_008a14_pa_cl_enhance__fields},
	{"PA_SU_LINE_STIPPLE_VALUE", R_008A60_PA_SU_LINE_STIPPLE_VALUE, ARRAY_SIZE(r_008a60_pa_su_line_stipple_value__fields), r_008a60_pa_su_line_stipple_value__fields},
	{"PA_SC_LINE_STIPPLE_STATE", R_008B10_PA_SC_LINE_STIPPLE_STATE, ARRAY_SIZE(r_008b10_pa_sc_line_stipple_state__fields), r_008b10_pa_sc_line_stipple_state__fields},
	{"CP_STALLED_STAT3", R_008670_CP_STALLED_STAT3, ARRAY_SIZE(r_008670_cp_stalled_stat3__fields), r_008670_cp_stalled_stat3__fields},
	{"CP_STALLED_STAT1", R_008674_CP_STALLED_STAT1, ARRAY_SIZE(r_008674_cp_stalled_stat1__fields), r_008674_cp_stalled_stat1__fields},
	{"CP_STALLED_STAT2", R_008678_CP_STALLED_STAT2, ARRAY_SIZE(r_008678_cp_stalled_stat2__fields), r_008678_cp_stalled_stat2__fields},
	{"CP_STAT", R_008680_CP_STAT, ARRAY_SIZE(r_008680_cp_stat__fields), r_008680_cp_stat__fields},
	{"GRBM_GFX_INDEX", R_030800_GRBM_GFX_INDEX, ARRAY_SIZE(r_030800_grbm_gfx_index__fields), r_030800_grbm_gfx_index__fields},
	{"VGT_ESGS_RING_SIZE", R_030900_VGT_ESGS_RING_SIZE},
	{"VGT_GSVS_RING_SIZE", R_030904_VGT_GSVS_RING_SIZE},
	{"VGT_PRIMITIVE_TYPE", R_030908_VGT_PRIMITIVE_TYPE, ARRAY_SIZE(r_030908_vgt_primitive_type__fields), r_030908_vgt_primitive_type__fields},
	{"VGT_INDEX_TYPE", R_03090C_VGT_INDEX_TYPE, ARRAY_SIZE(r_03090c_vgt_index_type__fields), r_03090c_vgt_index_type__fields},
	{"VGT_STRMOUT_BUFFER_FILLED_SIZE_0", R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{"VGT_STRMOUT_BUFFER_FILLED_SIZE_1", R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{"VGT_STRMOUT_BUFFER_FILLED_SIZE_2", R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{"VGT_STRMOUT_BUFFER_FILLED_SIZE_3", R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{"VGT_NUM_INDICES", R_030930_VGT_NUM_INDICES},
	{"VGT_NUM_INSTANCES", R_030934_VGT_NUM_INSTANCES},
	{"VGT_TF_RING_SIZE", R_030938_VGT_TF_RING_SIZE, ARRAY_SIZE(r_030938_vgt_tf_ring_size__fields), r_030938_vgt_tf_ring_size__fields},
	{"VGT_HS_OFFCHIP_PARAM", R_03093C_VGT_HS_OFFCHIP_PARAM, ARRAY_SIZE(r_03093c_vgt_hs_offchip_param__fields), r_03093c_vgt_hs_offchip_param__fields},
	{"VGT_TF_MEMORY_BASE", R_030940_VGT_TF_MEMORY_BASE},
	{"PA_SU_LINE_STIPPLE_VALUE", R_030A00_PA_SU_LINE_STIPPLE_VALUE, ARRAY_SIZE(r_030a00_pa_su_line_stipple_value__fields), r_030a00_pa_su_line_stipple_value__fields},
	{"PA_SC_LINE_STIPPLE_STATE", R_030A04_PA_SC_LINE_STIPPLE_STATE, ARRAY_SIZE(r_030a04_pa_sc_line_stipple_state__fields), r_030a04_pa_sc_line_stipple_state__fields},
	{"PA_SC_SCREEN_EXTENT_MIN_0", R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, ARRAY_SIZE(r_030a10_pa_sc_screen_extent_min_0__fields), r_030a10_pa_sc_screen_extent_min_0__fields},
	{"PA_SC_SCREEN_EXTENT_MAX_0", R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, ARRAY_SIZE(r_030a14_pa_sc_screen_extent_max_0__fields), r_030a14_pa_sc_screen_extent_max_0__fields},
	{"PA_SC_SCREEN_EXTENT_MIN_1", R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, ARRAY_SIZE(r_030a18_pa_sc_screen_extent_min_1__fields), r_030a18_pa_sc_screen_extent_min_1__fields},
	{"PA_SC_SCREEN_EXTENT_MAX_1", R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, ARRAY_SIZE(r_030a2c_pa_sc_screen_extent_max_1__fields), r_030a2c_pa_sc_screen_extent_max_1__fields},
	{"PA_SC_ENHANCE", R_008BF0_PA_SC_ENHANCE, ARRAY_SIZE(r_008bf0_pa_sc_enhance__fields), r_008bf0_pa_sc_enhance__fields},
	{"SQC_CACHES", R_008C08_SQC_CACHES, ARRAY_SIZE(r_008c08_sqc_caches__fields), r_008c08_sqc_caches__fields},
	{"SQC_CACHES", R_030D20_SQC_CACHES, ARRAY_SIZE(r_030d20_sqc_caches__fields), r_030d20_sqc_caches__fields},
	{"SQ_RANDOM_WAVE_PRI", R_008C0C_SQ_RANDOM_WAVE_PRI, ARRAY_SIZE(r_008c0c_sq_random_wave_pri__fields), r_008c0c_sq_random_wave_pri__fields},
	{"SQ_EXP_0", R_008DFC_SQ_EXP_0, ARRAY_SIZE(r_008dfc_sq_exp_0__fields), r_008dfc_sq_exp_0__fields},
	{"TA_CS_BC_BASE_ADDR", R_030E00_TA_CS_BC_BASE_ADDR},
	{"TA_CS_BC_BASE_ADDR_HI", R_030E04_TA_CS_BC_BASE_ADDR_HI, ARRAY_SIZE(r_030e04_ta_cs_bc_base_addr_hi__fields), r_030e04_ta_cs_bc_base_addr_hi__fields},
	{"DB_OCCLUSION_COUNT0_LOW", R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{"SQ_BUF_RSRC_WORD0", R_008F00_SQ_BUF_RSRC_WORD0},
	{"DB_OCCLUSION_COUNT0_HI", R_030F04_DB_OCCLUSION_COUNT0_HI, ARRAY_SIZE(r_030f04_db_occlusion_count0_hi__fields), r_030f04_db_occlusion_count0_hi__fields},
	{"SQ_BUF_RSRC_WORD1", R_008F04_SQ_BUF_RSRC_WORD1, ARRAY_SIZE(r_008f04_sq_buf_rsrc_word1__fields), r_008f04_sq_buf_rsrc_word1__fields},
	{"DB_OCCLUSION_COUNT1_LOW", R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{"SQ_BUF_RSRC_WORD2", R_008F08_SQ_BUF_RSRC_WORD2},
	{"DB_OCCLUSION_COUNT1_HI", R_030F0C_DB_OCCLUSION_COUNT1_HI, ARRAY_SIZE(r_030f0c_db_occlusion_count1_hi__fields), r_030f0c_db_occlusion_count1_hi__fields},
	{"SQ_BUF_RSRC_WORD3", R_008F0C_SQ_BUF_RSRC_WORD3, ARRAY_SIZE(r_008f0c_sq_buf_rsrc_word3__fields), r_008f0c_sq_buf_rsrc_word3__fields},
	{"DB_OCCLUSION_COUNT2_LOW", R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{"SQ_IMG_RSRC_WORD0", R_008F10_SQ_IMG_RSRC_WORD0},
	{"DB_OCCLUSION_COUNT2_HI", R_030F14_DB_OCCLUSION_COUNT2_HI, ARRAY_SIZE(r_030f14_db_occlusion_count2_hi__fields), r_030f14_db_occlusion_count2_hi__fields},
	{"SQ_IMG_RSRC_WORD1", R_008F14_SQ_IMG_RSRC_WORD1, ARRAY_SIZE(r_008f14_sq_img_rsrc_word1__fields), r_008f14_sq_img_rsrc_word1__fields},
	{"DB_OCCLUSION_COUNT3_LOW", R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{"SQ_IMG_RSRC_WORD2", R_008F18_SQ_IMG_RSRC_WORD2, ARRAY_SIZE(r_008f18_sq_img_rsrc_word2__fields), r_008f18_sq_img_rsrc_word2__fields},
	{"DB_OCCLUSION_COUNT3_HI", R_030F1C_DB_OCCLUSION_COUNT3_HI, ARRAY_SIZE(r_030f1c_db_occlusion_count3_hi__fields), r_030f1c_db_occlusion_count3_hi__fields},
	{"SQ_IMG_RSRC_WORD3", R_008F1C_SQ_IMG_RSRC_WORD3, ARRAY_SIZE(r_008f1c_sq_img_rsrc_word3__fields), r_008f1c_sq_img_rsrc_word3__fields},
	{"SQ_IMG_RSRC_WORD4", R_008F20_SQ_IMG_RSRC_WORD4, ARRAY_SIZE(r_008f20_sq_img_rsrc_word4__fields), r_008f20_sq_img_rsrc_word4__fields},
	{"SQ_IMG_RSRC_WORD5", R_008F24_SQ_IMG_RSRC_WORD5, ARRAY_SIZE(r_008f24_sq_img_rsrc_word5__fields), r_008f24_sq_img_rsrc_word5__fields},
	{"SQ_IMG_RSRC_WORD6", R_008F28_SQ_IMG_RSRC_WORD6, ARRAY_SIZE(r_008f28_sq_img_rsrc_word6__fields), r_008f28_sq_img_rsrc_word6__fields},
	{"SQ_IMG_RSRC_WORD7", R_008F2C_SQ_IMG_RSRC_WORD7},
	{"SQ_IMG_SAMP_WORD0", R_008F30_SQ_IMG_SAMP_WORD0, ARRAY_SIZE(r_008f30_sq_img_samp_word0__fields), r_008f30_sq_img_samp_word0__fields},
	{"SQ_IMG_SAMP_WORD1", R_008F34_SQ_IMG_SAMP_WORD1, ARRAY_SIZE(r_008f34_sq_img_samp_word1__fields), r_008f34_sq_img_samp_word1__fields},
	{"SQ_IMG_SAMP_WORD2", R_008F38_SQ_IMG_SAMP_WORD2, ARRAY_SIZE(r_008f38_sq_img_samp_word2__fields), r_008f38_sq_img_samp_word2__fields},
	{"SQ_IMG_SAMP_WORD3", R_008F3C_SQ_IMG_SAMP_WORD3, ARRAY_SIZE(r_008f3c_sq_img_samp_word3__fields), r_008f3c_sq_img_samp_word3__fields},
	{"SPI_DYN_GPR_LOCK_EN", R_0090DC_SPI_DYN_GPR_LOCK_EN, ARRAY_SIZE(r_0090dc_spi_dyn_gpr_lock_en__fields), r_0090dc_spi_dyn_gpr_lock_en__fields},
	{"SPI_STATIC_THREAD_MGMT_1", R_0090E0_SPI_STATIC_THREAD_MGMT_1, ARRAY_SIZE(r_0090e0_spi_static_thread_mgmt_1__fields), r_0090e0_spi_static_thread_mgmt_1__fields},
	{"SPI_STATIC_THREAD_MGMT_2", R_0090E4_SPI_STATIC_THREAD_MGMT_2, ARRAY_SIZE(r_0090e4_spi_static_thread_mgmt_2__fields), r_0090e4_spi_static_thread_mgmt_2__fields},
	{"SPI_STATIC_THREAD_MGMT_3", R_0090E8_SPI_STATIC_THREAD_MGMT_3, ARRAY_SIZE(r_0090e8_spi_static_thread_mgmt_3__fields), r_0090e8_spi_static_thread_mgmt_3__fields},
	{"SPI_PS_MAX_WAVE_ID", R_0090EC_SPI_PS_MAX_WAVE_ID, ARRAY_SIZE(r_0090ec_spi_ps_max_wave_id__fields), r_0090ec_spi_ps_max_wave_id__fields},
	{"SPI_PS_MAX_WAVE_ID", R_0090E8_SPI_PS_MAX_WAVE_ID, ARRAY_SIZE(r_0090e8_spi_ps_max_wave_id__fields), r_0090e8_spi_ps_max_wave_id__fields},
	{"SPI_ARB_PRIORITY", R_0090F0_SPI_ARB_PRIORITY, ARRAY_SIZE(r_0090f0_spi_arb_priority__fields), r_0090f0_spi_arb_priority__fields},
	{"SPI_ARB_PRIORITY", R_00C700_SPI_ARB_PRIORITY, ARRAY_SIZE(r_00c700_spi_arb_priority__fields), r_00c700_spi_arb_priority__fields},
	{"SPI_ARB_CYCLES_0", R_0090F4_SPI_ARB_CYCLES_0, ARRAY_SIZE(r_0090f4_spi_arb_cycles_0__fields), r_0090f4_spi_arb_cycles_0__fields},
	{"SPI_ARB_CYCLES_1", R_0090F8_SPI_ARB_CYCLES_1, ARRAY_SIZE(r_0090f8_spi_arb_cycles_1__fields), r_0090f8_spi_arb_cycles_1__fields},
	{"SQ_FLAT_SCRATCH_WORD0", R_008F40_SQ_FLAT_SCRATCH_WORD0, ARRAY_SIZE(r_008f40_sq_flat_scratch_word0__fields), r_008f40_sq_flat_scratch_word0__fields},
	{"SQ_FLAT_SCRATCH_WORD1", R_008F44_SQ_FLAT_SCRATCH_WORD1, ARRAY_SIZE(r_008f44_sq_flat_scratch_word1__fields), r_008f44_sq_flat_scratch_word1__fields},
	{"DB_ZPASS_COUNT_LOW", R_030FF8_DB_ZPASS_COUNT_LOW},
	{"DB_ZPASS_COUNT_HI", R_030FFC_DB_ZPASS_COUNT_HI, ARRAY_SIZE(r_030ffc_db_zpass_count_hi__fields), r_030ffc_db_zpass_count_hi__fields},
	{"SPI_CONFIG_CNTL", R_009100_SPI_CONFIG_CNTL, ARRAY_SIZE(r_009100_spi_config_cntl__fields), r_009100_spi_config_cntl__fields},
	{"SPI_CONFIG_CNTL_1", R_00913C_SPI_CONFIG_CNTL_1, ARRAY_SIZE(r_00913c_spi_config_cntl_1__fields), r_00913c_spi_config_cntl_1__fields},
	{"SPI_RESOURCE_RESERVE_CU_AB_0", R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, ARRAY_SIZE(r_00936c_spi_resource_reserve_cu_ab_0__fields), r_00936c_spi_resource_reserve_cu_ab_0__fields},
	{"TA_CS_BC_BASE_ADDR", R_00950C_TA_CS_BC_BASE_ADDR},
	{"DB_SUBTILE_CONTROL", R_009858_DB_SUBTILE_CONTROL, ARRAY_SIZE(r_009858_db_subtile_control__fields), r_009858_db_subtile_control__fields},
	{"GB_ADDR_CONFIG", R_0098F8_GB_ADDR_CONFIG, ARRAY_SIZE(r_0098f8_gb_addr_config__fields), r_0098f8_gb_addr_config__fields},
	{"GB_TILE_MODE0", R_009910_GB_TILE_MODE0, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE1", R_009914_GB_TILE_MODE1, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE2", R_009918_GB_TILE_MODE2, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE3", R_00991C_GB_TILE_MODE3, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE4", R_009920_GB_TILE_MODE4, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE5", R_009924_GB_TILE_MODE5, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE6", R_009928_GB_TILE_MODE6, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE7", R_00992C_GB_TILE_MODE7, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE8", R_009930_GB_TILE_MODE8, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE9", R_009934_GB_TILE_MODE9, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE10", R_009938_GB_TILE_MODE10, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE11", R_00993C_GB_TILE_MODE11, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE12", R_009940_GB_TILE_MODE12, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE13", R_009944_GB_TILE_MODE13, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE14", R_009948_GB_TILE_MODE14, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE15", R_00994C_GB_TILE_MODE15, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE16", R_009950_GB_TILE_MODE16, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE17", R_009954_GB_TILE_MODE17, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE18", R_009958_GB_TILE_MODE18, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE19", R_00995C_GB_TILE_MODE19, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE20", R_009960_GB_TILE_MODE20, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE21", R_009964_GB_TILE_MODE21, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE22", R_009968_GB_TILE_MODE22, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE23", R_00996C_GB_TILE_MODE23, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE24", R_009970_GB_TILE_MODE24, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE25", R_009974_GB_TILE_MODE25, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE26", R_009978_GB_TILE_MODE26, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE27", R_00997C_GB_TILE_MODE27, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE28", R_009980_GB_TILE_MODE28, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE29", R_009984_GB_TILE_MODE29, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE30", R_009988_GB_TILE_MODE30, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_TILE_MODE31", R_00998C_GB_TILE_MODE31, ARRAY_SIZE(r_009910_gb_tile_mode0__fields), r_009910_gb_tile_mode0__fields},
	{"GB_MACROTILE_MODE0", R_009990_GB_MACROTILE_MODE0, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE1", R_009994_GB_MACROTILE_MODE1, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE2", R_009998_GB_MACROTILE_MODE2, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE3", R_00999C_GB_MACROTILE_MODE3, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE4", R_0099A0_GB_MACROTILE_MODE4, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE5", R_0099A4_GB_MACROTILE_MODE5, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE6", R_0099A8_GB_MACROTILE_MODE6, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE7", R_0099AC_GB_MACROTILE_MODE7, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE8", R_0099B0_GB_MACROTILE_MODE8, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE9", R_0099B4_GB_MACROTILE_MODE9, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE10", R_0099B8_GB_MACROTILE_MODE10, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE11", R_0099BC_GB_MACROTILE_MODE11, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE12", R_0099C0_GB_MACROTILE_MODE12, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE13", R_0099C4_GB_MACROTILE_MODE13, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE14", R_0099C8_GB_MACROTILE_MODE14, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"GB_MACROTILE_MODE15", R_0099CC_GB_MACROTILE_MODE15, ARRAY_SIZE(r_009990_gb_macrotile_mode0__fields), r_009990_gb_macrotile_mode0__fields},
	{"SPI_SHADER_TBA_LO_PS", R_00B000_SPI_SHADER_TBA_LO_PS},
	{"SPI_SHADER_TBA_HI_PS", R_00B004_SPI_SHADER_TBA_HI_PS, ARRAY_SIZE(r_00b004_spi_shader_tba_hi_ps__fields), r_00b004_spi_shader_tba_hi_ps__fields},
	{"SPI_SHADER_TMA_LO_PS", R_00B008_SPI_SHADER_TMA_LO_PS},
	{"SPI_SHADER_TMA_HI_PS", R_00B00C_SPI_SHADER_TMA_HI_PS, ARRAY_SIZE(r_00b00c_spi_shader_tma_hi_ps__fields), r_00b00c_spi_shader_tma_hi_ps__fields},
	{"SPI_SHADER_PGM_RSRC3_PS", R_00B01C_SPI_SHADER_PGM_RSRC3_PS, ARRAY_SIZE(r_00b01c_spi_shader_pgm_rsrc3_ps__fields), r_00b01c_spi_shader_pgm_rsrc3_ps__fields},
	{"SPI_SHADER_PGM_LO_PS", R_00B020_SPI_SHADER_PGM_LO_PS},
	{"SPI_SHADER_PGM_HI_PS", R_00B024_SPI_SHADER_PGM_HI_PS, ARRAY_SIZE(r_00b024_spi_shader_pgm_hi_ps__fields), r_00b024_spi_shader_pgm_hi_ps__fields},
	{"SPI_SHADER_PGM_RSRC1_PS", R_00B028_SPI_SHADER_PGM_RSRC1_PS, ARRAY_SIZE(r_00b028_spi_shader_pgm_rsrc1_ps__fields), r_00b028_spi_shader_pgm_rsrc1_ps__fields},
	{"SPI_SHADER_PGM_RSRC2_PS", R_00B02C_SPI_SHADER_PGM_RSRC2_PS, ARRAY_SIZE(r_00b02c_spi_shader_pgm_rsrc2_ps__fields), r_00b02c_spi_shader_pgm_rsrc2_ps__fields},
	{"SPI_SHADER_USER_DATA_PS_0", R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{"SPI_SHADER_USER_DATA_PS_1", R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{"SPI_SHADER_USER_DATA_PS_2", R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{"SPI_SHADER_USER_DATA_PS_3", R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{"SPI_SHADER_USER_DATA_PS_4", R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{"SPI_SHADER_USER_DATA_PS_5", R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{"SPI_SHADER_USER_DATA_PS_6", R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{"SPI_SHADER_USER_DATA_PS_7", R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{"SPI_SHADER_USER_DATA_PS_8", R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{"SPI_SHADER_USER_DATA_PS_9", R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{"SPI_SHADER_USER_DATA_PS_10", R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{"SPI_SHADER_USER_DATA_PS_11", R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{"SPI_SHADER_USER_DATA_PS_12", R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{"SPI_SHADER_USER_DATA_PS_13", R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{"SPI_SHADER_USER_DATA_PS_14", R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{"SPI_SHADER_USER_DATA_PS_15", R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{"SPI_SHADER_TBA_LO_VS", R_00B100_SPI_SHADER_TBA_LO_VS},
	{"SPI_SHADER_TBA_HI_VS", R_00B104_SPI_SHADER_TBA_HI_VS, ARRAY_SIZE(r_00b104_spi_shader_tba_hi_vs__fields), r_00b104_spi_shader_tba_hi_vs__fields},
	{"SPI_SHADER_TMA_LO_VS", R_00B108_SPI_SHADER_TMA_LO_VS},
	{"SPI_SHADER_TMA_HI_VS", R_00B10C_SPI_SHADER_TMA_HI_VS, ARRAY_SIZE(r_00b10c_spi_shader_tma_hi_vs__fields), r_00b10c_spi_shader_tma_hi_vs__fields},
	{"SPI_SHADER_PGM_RSRC3_VS", R_00B118_SPI_SHADER_PGM_RSRC3_VS, ARRAY_SIZE(r_00b118_spi_shader_pgm_rsrc3_vs__fields), r_00b118_spi_shader_pgm_rsrc3_vs__fields},
	{"SPI_SHADER_LATE_ALLOC_VS", R_00B11C_SPI_SHADER_LATE_ALLOC_VS, ARRAY_SIZE(r_00b11c_spi_shader_late_alloc_vs__fields), r_00b11c_spi_shader_late_alloc_vs__fields},
	{"SPI_SHADER_PGM_LO_VS", R_00B120_SPI_SHADER_PGM_LO_VS},
	{"SPI_SHADER_PGM_HI_VS", R_00B124_SPI_SHADER_PGM_HI_VS, ARRAY_SIZE(r_00b124_spi_shader_pgm_hi_vs__fields), r_00b124_spi_shader_pgm_hi_vs__fields},
	{"SPI_SHADER_PGM_RSRC1_VS", R_00B128_SPI_SHADER_PGM_RSRC1_VS, ARRAY_SIZE(r_00b128_spi_shader_pgm_rsrc1_vs__fields), r_00b128_spi_shader_pgm_rsrc1_vs__fields},
	{"SPI_SHADER_PGM_RSRC2_VS", R_00B12C_SPI_SHADER_PGM_RSRC2_VS, ARRAY_SIZE(r_00b12c_spi_shader_pgm_rsrc2_vs__fields), r_00b12c_spi_shader_pgm_rsrc2_vs__fields},
	{"SPI_SHADER_USER_DATA_VS_0", R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{"SPI_SHADER_USER_DATA_VS_1", R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{"SPI_SHADER_USER_DATA_VS_2", R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{"SPI_SHADER_USER_DATA_VS_3", R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{"SPI_SHADER_USER_DATA_VS_4", R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{"SPI_SHADER_USER_DATA_VS_5", R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{"SPI_SHADER_USER_DATA_VS_6", R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{"SPI_SHADER_USER_DATA_VS_7", R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{"SPI_SHADER_USER_DATA_VS_8", R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{"SPI_SHADER_USER_DATA_VS_9", R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{"SPI_SHADER_USER_DATA_VS_10", R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{"SPI_SHADER_USER_DATA_VS_11", R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{"SPI_SHADER_USER_DATA_VS_12", R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{"SPI_SHADER_USER_DATA_VS_13", R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{"SPI_SHADER_USER_DATA_VS_14", R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{"SPI_SHADER_USER_DATA_VS_15", R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{"SPI_SHADER_TBA_LO_GS", R_00B200_SPI_SHADER_TBA_LO_GS},
	{"SPI_SHADER_TBA_HI_GS", R_00B204_SPI_SHADER_TBA_HI_GS, ARRAY_SIZE(r_00b204_spi_shader_tba_hi_gs__fields), r_00b204_spi_shader_tba_hi_gs__fields},
	{"SPI_SHADER_TMA_LO_GS", R_00B208_SPI_SHADER_TMA_LO_GS},
	{"SPI_SHADER_TMA_HI_GS", R_00B20C_SPI_SHADER_TMA_HI_GS, ARRAY_SIZE(r_00b20c_spi_shader_tma_hi_gs__fields), r_00b20c_spi_shader_tma_hi_gs__fields},
	{"SPI_SHADER_PGM_RSRC3_GS", R_00B21C_SPI_SHADER_PGM_RSRC3_GS, ARRAY_SIZE(r_00b21c_spi_shader_pgm_rsrc3_gs__fields), r_00b21c_spi_shader_pgm_rsrc3_gs__fields},
	{"SPI_SHADER_PGM_LO_GS", R_00B220_SPI_SHADER_PGM_LO_GS},
	{"SPI_SHADER_PGM_HI_GS", R_00B224_SPI_SHADER_PGM_HI_GS, ARRAY_SIZE(r_00b224_spi_shader_pgm_hi_gs__fields), r_00b224_spi_shader_pgm_hi_gs__fields},
	{"SPI_SHADER_PGM_RSRC1_GS", R_00B228_SPI_SHADER_PGM_RSRC1_GS, ARRAY_SIZE(r_00b228_spi_shader_pgm_rsrc1_gs__fields), r_00b228_spi_shader_pgm_rsrc1_gs__fields},
	{"SPI_SHADER_PGM_RSRC2_GS", R_00B22C_SPI_SHADER_PGM_RSRC2_GS, ARRAY_SIZE(r_00b22c_spi_shader_pgm_rsrc2_gs__fields), r_00b22c_spi_shader_pgm_rsrc2_gs__fields},
	{"SPI_SHADER_USER_DATA_GS_0", R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{"SPI_SHADER_USER_DATA_GS_1", R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{"SPI_SHADER_USER_DATA_GS_2", R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{"SPI_SHADER_USER_DATA_GS_3", R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{"SPI_SHADER_USER_DATA_GS_4", R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{"SPI_SHADER_USER_DATA_GS_5", R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{"SPI_SHADER_USER_DATA_GS_6", R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{"SPI_SHADER_USER_DATA_GS_7", R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{"SPI_SHADER_USER_DATA_GS_8", R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{"SPI_SHADER_USER_DATA_GS_9", R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{"SPI_SHADER_USER_DATA_GS_10", R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{"SPI_SHADER_USER_DATA_GS_11", R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{"SPI_SHADER_USER_DATA_GS_12", R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{"SPI_SHADER_USER_DATA_GS_13", R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{"SPI_SHADER_USER_DATA_GS_14", R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{"SPI_SHADER_USER_DATA_GS_15", R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{"SPI_SHADER_TBA_LO_ES", R_00B300_SPI_SHADER_TBA_LO_ES},
	{"SPI_SHADER_TBA_HI_ES", R_00B304_SPI_SHADER_TBA_HI_ES, ARRAY_SIZE(r_00b304_spi_shader_tba_hi_es__fields), r_00b304_spi_shader_tba_hi_es__fields},
	{"SPI_SHADER_TMA_LO_ES", R_00B308_SPI_SHADER_TMA_LO_ES},
	{"SPI_SHADER_TMA_HI_ES", R_00B30C_SPI_SHADER_TMA_HI_ES, ARRAY_SIZE(r_00b30c_spi_shader_tma_hi_es__fields), r_00b30c_spi_shader_tma_hi_es__fields},
	{"SPI_SHADER_PGM_RSRC3_ES", R_00B31C_SPI_SHADER_PGM_RSRC3_ES, ARRAY_SIZE(r_00b31c_spi_shader_pgm_rsrc3_es__fields), r_00b31c_spi_shader_pgm_rsrc3_es__fields},
	{"SPI_SHADER_PGM_LO_ES", R_00B320_SPI_SHADER_PGM_LO_ES},
	{"SPI_SHADER_PGM_HI_ES", R_00B324_SPI_SHADER_PGM_HI_ES, ARRAY_SIZE(r_00b324_spi_shader_pgm_hi_es__fields), r_00b324_spi_shader_pgm_hi_es__fields},
	{"SPI_SHADER_PGM_RSRC1_ES", R_00B328_SPI_SHADER_PGM_RSRC1_ES, ARRAY_SIZE(r_00b328_spi_shader_pgm_rsrc1_es__fields), r_00b328_spi_shader_pgm_rsrc1_es__fields},
	{"SPI_SHADER_PGM_RSRC2_ES", R_00B32C_SPI_SHADER_PGM_RSRC2_ES, ARRAY_SIZE(r_00b32c_spi_shader_pgm_rsrc2_es__fields), r_00b32c_spi_shader_pgm_rsrc2_es__fields},
	{"SPI_SHADER_USER_DATA_ES_0", R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{"SPI_SHADER_USER_DATA_ES_1", R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{"SPI_SHADER_USER_DATA_ES_2", R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{"SPI_SHADER_USER_DATA_ES_3", R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{"SPI_SHADER_USER_DATA_ES_4", R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{"SPI_SHADER_USER_DATA_ES_5", R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{"SPI_SHADER_USER_DATA_ES_6", R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{"SPI_SHADER_USER_DATA_ES_7", R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{"SPI_SHADER_USER_DATA_ES_8", R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{"SPI_SHADER_USER_DATA_ES_9", R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{"SPI_SHADER_USER_DATA_ES_10", R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{"SPI_SHADER_USER_DATA_ES_11", R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{"SPI_SHADER_USER_DATA_ES_12", R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{"SPI_SHADER_USER_DATA_ES_13", R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{"SPI_SHADER_USER_DATA_ES_14", R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{"SPI_SHADER_USER_DATA_ES_15", R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{"SPI_SHADER_TBA_LO_HS", R_00B400_SPI_SHADER_TBA_LO_HS},
	{"SPI_SHADER_TBA_HI_HS", R_00B404_SPI_SHADER_TBA_HI_HS, ARRAY_SIZE(r_00b404_spi_shader_tba_hi_hs__fields), r_00b404_spi_shader_tba_hi_hs__fields},
	{"SPI_SHADER_TMA_LO_HS", R_00B408_SPI_SHADER_TMA_LO_HS},
	{"SPI_SHADER_TMA_HI_HS", R_00B40C_SPI_SHADER_TMA_HI_HS, ARRAY_SIZE(r_00b40c_spi_shader_tma_hi_hs__fields), r_00b40c_spi_shader_tma_hi_hs__fields},
	{"SPI_SHADER_PGM_RSRC3_HS", R_00B41C_SPI_SHADER_PGM_RSRC3_HS, ARRAY_SIZE(r_00b41c_spi_shader_pgm_rsrc3_hs__fields), r_00b41c_spi_shader_pgm_rsrc3_hs__fields},
	{"SPI_SHADER_PGM_LO_HS", R_00B420_SPI_SHADER_PGM_LO_HS},
	{"SPI_SHADER_PGM_HI_HS", R_00B424_SPI_SHADER_PGM_HI_HS, ARRAY_SIZE(r_00b424_spi_shader_pgm_hi_hs__fields), r_00b424_spi_shader_pgm_hi_hs__fields},
	{"SPI_SHADER_PGM_RSRC1_HS", R_00B428_SPI_SHADER_PGM_RSRC1_HS, ARRAY_SIZE(r_00b428_spi_shader_pgm_rsrc1_hs__fields), r_00b428_spi_shader_pgm_rsrc1_hs__fields},
	{"SPI_SHADER_PGM_RSRC2_HS", R_00B42C_SPI_SHADER_PGM_RSRC2_HS, ARRAY_SIZE(r_00b42c_spi_shader_pgm_rsrc2_hs__fields), r_00b42c_spi_shader_pgm_rsrc2_hs__fields},
	{"SPI_SHADER_USER_DATA_HS_0", R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{"SPI_SHADER_USER_DATA_HS_1", R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{"SPI_SHADER_USER_DATA_HS_2", R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{"SPI_SHADER_USER_DATA_HS_3", R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{"SPI_SHADER_USER_DATA_HS_4", R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{"SPI_SHADER_USER_DATA_HS_5", R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{"SPI_SHADER_USER_DATA_HS_6", R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{"SPI_SHADER_USER_DATA_HS_7", R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{"SPI_SHADER_USER_DATA_HS_8", R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{"SPI_SHADER_USER_DATA_HS_9", R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{"SPI_SHADER_USER_DATA_HS_10", R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{"SPI_SHADER_USER_DATA_HS_11", R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{"SPI_SHADER_USER_DATA_HS_12", R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{"SPI_SHADER_USER_DATA_HS_13", R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{"SPI_SHADER_USER_DATA_HS_14", R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{"SPI_SHADER_USER_DATA_HS_15", R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{"SPI_SHADER_TBA_LO_LS", R_00B500_SPI_SHADER_TBA_LO_LS},
	{"SPI_SHADER_TBA_HI_LS", R_00B504_SPI_SHADER_TBA_HI_LS, ARRAY_SIZE(r_00b504_spi_shader_tba_hi_ls__fields), r_00b504_spi_shader_tba_hi_ls__fields},
	{"SPI_SHADER_TMA_LO_LS", R_00B508_SPI_SHADER_TMA_LO_LS},
	{"SPI_SHADER_TMA_HI_LS", R_00B50C_SPI_SHADER_TMA_HI_LS, ARRAY_SIZE(r_00b50c_spi_shader_tma_hi_ls__fields), r_00b50c_spi_shader_tma_hi_ls__fields},
	{"SPI_SHADER_PGM_RSRC3_LS", R_00B51C_SPI_SHADER_PGM_RSRC3_LS, ARRAY_SIZE(r_00b51c_spi_shader_pgm_rsrc3_ls__fields), r_00b51c_spi_shader_pgm_rsrc3_ls__fields},
	{"SPI_SHADER_PGM_LO_LS", R_00B520_SPI_SHADER_PGM_LO_LS},
	{"SPI_SHADER_PGM_HI_LS", R_00B524_SPI_SHADER_PGM_HI_LS, ARRAY_SIZE(r_00b524_spi_shader_pgm_hi_ls__fields), r_00b524_spi_shader_pgm_hi_ls__fields},
	{"SPI_SHADER_PGM_RSRC1_LS", R_00B528_SPI_SHADER_PGM_RSRC1_LS, ARRAY_SIZE(r_00b528_spi_shader_pgm_rsrc1_ls__fields), r_00b528_spi_shader_pgm_rsrc1_ls__fields},
	{"SPI_SHADER_PGM_RSRC2_LS", R_00B52C_SPI_SHADER_PGM_RSRC2_LS, ARRAY_SIZE(r_00b52c_spi_shader_pgm_rsrc2_ls__fields), r_00b52c_spi_shader_pgm_rsrc2_ls__fields},
	{"SPI_SHADER_USER_DATA_LS_0", R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{"SPI_SHADER_USER_DATA_LS_1", R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{"SPI_SHADER_USER_DATA_LS_2", R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{"SPI_SHADER_USER_DATA_LS_3", R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{"SPI_SHADER_USER_DATA_LS_4", R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{"SPI_SHADER_USER_DATA_LS_5", R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{"SPI_SHADER_USER_DATA_LS_6", R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{"SPI_SHADER_USER_DATA_LS_7", R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{"SPI_SHADER_USER_DATA_LS_8", R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{"SPI_SHADER_USER_DATA_LS_9", R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{"SPI_SHADER_USER_DATA_LS_10", R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{"SPI_SHADER_USER_DATA_LS_11", R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{"SPI_SHADER_USER_DATA_LS_12", R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{"SPI_SHADER_USER_DATA_LS_13", R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{"SPI_SHADER_USER_DATA_LS_14", R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{"SPI_SHADER_USER_DATA_LS_15", R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{"COMPUTE_DISPATCH_INITIATOR", R_00B800_COMPUTE_DISPATCH_INITIATOR, ARRAY_SIZE(r_00b800_compute_dispatch_initiator__fields), r_00b800_compute_dispatch_initiator__fields},
	{"COMPUTE_DIM_X", R_00B804_COMPUTE_DIM_X},
	{"COMPUTE_DIM_Y", R_00B808_COMPUTE_DIM_Y},
	{"COMPUTE_DIM_Z", R_00B80C_COMPUTE_DIM_Z},
	{"COMPUTE_START_X", R_00B810_COMPUTE_START_X},
	{"COMPUTE_START_Y", R_00B814_COMPUTE_START_Y},
	{"COMPUTE_START_Z", R_00B818_COMPUTE_START_Z},
	{"COMPUTE_NUM_THREAD_X", R_00B81C_COMPUTE_NUM_THREAD_X, ARRAY_SIZE(r_00b81c_compute_num_thread_x__fields), r_00b81c_compute_num_thread_x__fields},
	{"COMPUTE_NUM_THREAD_Y", R_00B820_COMPUTE_NUM_THREAD_Y, ARRAY_SIZE(r_00b820_compute_num_thread_y__fields), r_00b820_compute_num_thread_y__fields},
	{"COMPUTE_NUM_THREAD_Z", R_00B824_COMPUTE_NUM_THREAD_Z, ARRAY_SIZE(r_00b824_compute_num_thread_z__fields), r_00b824_compute_num_thread_z__fields},
	{"COMPUTE_MAX_WAVE_ID", R_00B82C_COMPUTE_MAX_WAVE_ID, ARRAY_SIZE(r_00b82c_compute_max_wave_id__fields), r_00b82c_compute_max_wave_id__fields},
	{"COMPUTE_PIPELINESTAT_ENABLE", R_00B828_COMPUTE_PIPELINESTAT_ENABLE, ARRAY_SIZE(r_00b828_compute_pipelinestat_enable__fields), r_00b828_compute_pipelinestat_enable__fields},
	{"COMPUTE_PERFCOUNT_ENABLE", R_00B82C_COMPUTE_PERFCOUNT_ENABLE, ARRAY_SIZE(r_00b82c_compute_perfcount_enable__fields), r_00b82c_compute_perfcount_enable__fields},
	{"COMPUTE_PGM_LO", R_00B830_COMPUTE_PGM_LO},
	{"COMPUTE_PGM_HI", R_00B834_COMPUTE_PGM_HI, ARRAY_SIZE(r_00b834_compute_pgm_hi__fields), r_00b834_compute_pgm_hi__fields},
	{"COMPUTE_TBA_LO", R_00B838_COMPUTE_TBA_LO},
	{"COMPUTE_TBA_HI", R_00B83C_COMPUTE_TBA_HI, ARRAY_SIZE(r_00b83c_compute_tba_hi__fields), r_00b83c_compute_tba_hi__fields},
	{"COMPUTE_TMA_LO", R_00B840_COMPUTE_TMA_LO},
	{"COMPUTE_TMA_HI", R_00B844_COMPUTE_TMA_HI, ARRAY_SIZE(r_00b844_compute_tma_hi__fields), r_00b844_compute_tma_hi__fields},
	{"COMPUTE_PGM_RSRC1", R_00B848_COMPUTE_PGM_RSRC1, ARRAY_SIZE(r_00b848_compute_pgm_rsrc1__fields), r_00b848_compute_pgm_rsrc1__fields},
	{"COMPUTE_PGM_RSRC2", R_00B84C_COMPUTE_PGM_RSRC2, ARRAY_SIZE(r_00b84c_compute_pgm_rsrc2__fields), r_00b84c_compute_pgm_rsrc2__fields},
	{"COMPUTE_VMID", R_00B850_COMPUTE_VMID, ARRAY_SIZE(r_00b850_compute_vmid__fields), r_00b850_compute_vmid__fields},
	{"COMPUTE_RESOURCE_LIMITS", R_00B854_COMPUTE_RESOURCE_LIMITS, ARRAY_SIZE(r_00b854_compute_resource_limits__fields), r_00b854_compute_resource_limits__fields},
	{"COMPUTE_STATIC_THREAD_MGMT_SE0", R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, ARRAY_SIZE(r_00b858_compute_static_thread_mgmt_se0__fields), r_00b858_compute_static_thread_mgmt_se0__fields},
	{"COMPUTE_STATIC_THREAD_MGMT_SE1", R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, ARRAY_SIZE(r_00b85c_compute_static_thread_mgmt_se1__fields), r_00b85c_compute_static_thread_mgmt_se1__fields},
	{"COMPUTE_TMPRING_SIZE", R_00B860_COMPUTE_TMPRING_SIZE, ARRAY_SIZE(r_00b860_compute_tmpring_size__fields), r_00b860_compute_tmpring_size__fields},
	{"COMPUTE_STATIC_THREAD_MGMT_SE2", R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, ARRAY_SIZE(r_00b864_compute_static_thread_mgmt_se2__fields), r_00b864_compute_static_thread_mgmt_se2__fields},
	{"COMPUTE_STATIC_THREAD_MGMT_SE3", R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, ARRAY_SIZE(r_00b868_compute_static_thread_mgmt_se3__fields), r_00b868_compute_static_thread_mgmt_se3__fields},
	{"COMPUTE_RESTART_X", R_00B86C_COMPUTE_RESTART_X},
	{"COMPUTE_RESTART_Y", R_00B870_COMPUTE_RESTART_Y},
	{"COMPUTE_RESTART_Z", R_00B874_COMPUTE_RESTART_Z},
	{"COMPUTE_MISC_RESERVED", R_00B87C_COMPUTE_MISC_RESERVED, ARRAY_SIZE(r_00b87c_compute_misc_reserved__fields), r_00b87c_compute_misc_reserved__fields},
	{"COMPUTE_DISPATCH_ID", R_00B880_COMPUTE_DISPATCH_ID},
	{"COMPUTE_THREADGROUP_ID", R_00B884_COMPUTE_THREADGROUP_ID},
	{"COMPUTE_RELAUNCH", R_00B888_COMPUTE_RELAUNCH, ARRAY_SIZE(r_00b888_compute_relaunch__fields), r_00b888_compute_relaunch__fields},
	{"COMPUTE_WAVE_RESTORE_ADDR_LO", R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{"COMPUTE_WAVE_RESTORE_ADDR_HI", R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, ARRAY_SIZE(r_00b890_compute_wave_restore_addr_hi__fields), r_00b890_compute_wave_restore_addr_hi__fields},
	{"COMPUTE_WAVE_RESTORE_CONTROL", R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, ARRAY_SIZE(r_00b894_compute_wave_restore_control__fields), r_00b894_compute_wave_restore_control__fields},
	{"COMPUTE_USER_DATA_0", R_00B900_COMPUTE_USER_DATA_0},
	{"COMPUTE_USER_DATA_1", R_00B904_COMPUTE_USER_DATA_1},
	{"COMPUTE_USER_DATA_2", R_00B908_COMPUTE_USER_DATA_2},
	{"COMPUTE_USER_DATA_3", R_00B90C_COMPUTE_USER_DATA_3},
	{"COMPUTE_USER_DATA_4", R_00B910_COMPUTE_USER_DATA_4},
	{"COMPUTE_USER_DATA_5", R_00B914_COMPUTE_USER_DATA_5},
	{"COMPUTE_USER_DATA_6", R_00B918_COMPUTE_USER_DATA_6},
	{"COMPUTE_USER_DATA_7", R_00B91C_COMPUTE_USER_DATA_7},
	{"COMPUTE_USER_DATA_8", R_00B920_COMPUTE_USER_DATA_8},
	{"COMPUTE_USER_DATA_9", R_00B924_COMPUTE_USER_DATA_9},
	{"COMPUTE_USER_DATA_10", R_00B928_COMPUTE_USER_DATA_10},
	{"COMPUTE_USER_DATA_11", R_00B92C_COMPUTE_USER_DATA_11},
	{"COMPUTE_USER_DATA_12", R_00B930_COMPUTE_USER_DATA_12},
	{"COMPUTE_USER_DATA_13", R_00B934_COMPUTE_USER_DATA_13},
	{"COMPUTE_USER_DATA_14", R_00B938_COMPUTE_USER_DATA_14},
	{"COMPUTE_USER_DATA_15", R_00B93C_COMPUTE_USER_DATA_15},
	{"COMPUTE_NOWHERE", R_00B9FC_COMPUTE_NOWHERE},
	{"DB_RENDER_CONTROL", R_028000_DB_RENDER_CONTROL, ARRAY_SIZE(r_028000_db_render_control__fields), r_028000_db_render_control__fields},
	{"DB_COUNT_CONTROL", R_028004_DB_COUNT_CONTROL, ARRAY_SIZE(r_028004_db_count_control__fields), r_028004_db_count_control__fields},
	{"DB_DEPTH_VIEW", R_028008_DB_DEPTH_VIEW, ARRAY_SIZE(r_028008_db_depth_view__fields), r_028008_db_depth_view__fields},
	{"DB_RENDER_OVERRIDE", R_02800C_DB_RENDER_OVERRIDE, ARRAY_SIZE(r_02800c_db_render_override__fields), r_02800c_db_render_override__fields},
	{"DB_RENDER_OVERRIDE2", R_028010_DB_RENDER_OVERRIDE2, ARRAY_SIZE(r_028010_db_render_override2__fields), r_028010_db_render_override2__fields},
	{"DB_HTILE_DATA_BASE", R_028014_DB_HTILE_DATA_BASE},
	{"DB_DEPTH_BOUNDS_MIN", R_028020_DB_DEPTH_BOUNDS_MIN},
	{"DB_DEPTH_BOUNDS_MAX", R_028024_DB_DEPTH_BOUNDS_MAX},
	{"DB_STENCIL_CLEAR", R_028028_DB_STENCIL_CLEAR, ARRAY_SIZE(r_028028_db_stencil_clear__fields), r_028028_db_stencil_clear__fields},
	{"DB_DEPTH_CLEAR", R_02802C_DB_DEPTH_CLEAR},
	{"PA_SC_SCREEN_SCISSOR_TL", R_028030_PA_SC_SCREEN_SCISSOR_TL, ARRAY_SIZE(r_028030_pa_sc_screen_scissor_tl__fields), r_028030_pa_sc_screen_scissor_tl__fields},
	{"PA_SC_SCREEN_SCISSOR_BR", R_028034_PA_SC_SCREEN_SCISSOR_BR, ARRAY_SIZE(r_028034_pa_sc_screen_scissor_br__fields), r_028034_pa_sc_screen_scissor_br__fields},
	{"DB_DEPTH_INFO", R_02803C_DB_DEPTH_INFO, ARRAY_SIZE(r_02803c_db_depth_info__fields), r_02803c_db_depth_info__fields},
	{"DB_Z_INFO", R_028040_DB_Z_INFO, ARRAY_SIZE(r_028040_db_z_info__fields), r_028040_db_z_info__fields},
	{"DB_STENCIL_INFO", R_028044_DB_STENCIL_INFO, ARRAY_SIZE(r_028044_db_stencil_info__fields), r_028044_db_stencil_info__fields},
	{"DB_Z_READ_BASE", R_028048_DB_Z_READ_BASE},
	{"DB_STENCIL_READ_BASE", R_02804C_DB_STENCIL_READ_BASE},
	{"DB_Z_WRITE_BASE", R_028050_DB_Z_WRITE_BASE},
	{"DB_STENCIL_WRITE_BASE", R_028054_DB_STENCIL_WRITE_BASE},
	{"DB_DEPTH_SIZE", R_028058_DB_DEPTH_SIZE, ARRAY_SIZE(r_028058_db_depth_size__fields), r_028058_db_depth_size__fields},
	{"DB_DEPTH_SLICE", R_02805C_DB_DEPTH_SLICE, ARRAY_SIZE(r_02805c_db_depth_slice__fields), r_02805c_db_depth_slice__fields},
	{"TA_BC_BASE_ADDR", R_028080_TA_BC_BASE_ADDR},
	{"TA_BC_BASE_ADDR_HI", R_028084_TA_BC_BASE_ADDR_HI, ARRAY_SIZE(r_028084_ta_bc_base_addr_hi__fields), r_028084_ta_bc_base_addr_hi__fields},
	{"COHER_DEST_BASE_HI_0", R_0281E8_COHER_DEST_BASE_HI_0},
	{"COHER_DEST_BASE_HI_1", R_0281EC_COHER_DEST_BASE_HI_1},
	{"COHER_DEST_BASE_HI_2", R_0281F0_COHER_DEST_BASE_HI_2},
	{"COHER_DEST_BASE_HI_3", R_0281F4_COHER_DEST_BASE_HI_3},
	{"COHER_DEST_BASE_2", R_0281F8_COHER_DEST_BASE_2},
	{"COHER_DEST_BASE_3", R_0281FC_COHER_DEST_BASE_3},
	{"PA_SC_WINDOW_OFFSET", R_028200_PA_SC_WINDOW_OFFSET, ARRAY_SIZE(r_028200_pa_sc_window_offset__fields), r_028200_pa_sc_window_offset__fields},
	{"PA_SC_WINDOW_SCISSOR_TL", R_028204_PA_SC_WINDOW_SCISSOR_TL, ARRAY_SIZE(r_028204_pa_sc_window_scissor_tl__fields), r_028204_pa_sc_window_scissor_tl__fields},
	{"PA_SC_WINDOW_SCISSOR_BR", R_028208_PA_SC_WINDOW_SCISSOR_BR, ARRAY_SIZE(r_028208_pa_sc_window_scissor_br__fields), r_028208_pa_sc_window_scissor_br__fields},
	{"PA_SC_CLIPRECT_RULE", R_02820C_PA_SC_CLIPRECT_RULE, ARRAY_SIZE(r_02820c_pa_sc_cliprect_rule__fields), r_02820c_pa_sc_cliprect_rule__fields},
	{"PA_SC_CLIPRECT_0_TL", R_028210_PA_SC_CLIPRECT_0_TL, ARRAY_SIZE(r_028210_pa_sc_cliprect_0_tl__fields), r_028210_pa_sc_cliprect_0_tl__fields},
	{"PA_SC_CLIPRECT_0_BR", R_028214_PA_SC_CLIPRECT_0_BR, ARRAY_SIZE(r_028214_pa_sc_cliprect_0_br__fields), r_028214_pa_sc_cliprect_0_br__fields},
	{"PA_SC_CLIPRECT_1_TL", R_028218_PA_SC_CLIPRECT_1_TL, ARRAY_SIZE(r_028210_pa_sc_cliprect_0_tl__fields), r_028210_pa_sc_cliprect_0_tl__fields},
	{"PA_SC_CLIPRECT_1_BR", R_02821C_PA_SC_CLIPRECT_1_BR, ARRAY_SIZE(r_028214_pa_sc_cliprect_0_br__fields), r_028214_pa_sc_cliprect_0_br__fields},
	{"PA_SC_CLIPRECT_2_TL", R_028220_PA_SC_CLIPRECT_2_TL, ARRAY_SIZE(r_028210_pa_sc_cliprect_0_tl__fields), r_028210_pa_sc_cliprect_0_tl__fields},
	{"PA_SC_CLIPRECT_2_BR", R_028224_PA_SC_CLIPRECT_2_BR, ARRAY_SIZE(r_028214_pa_sc_cliprect_0_br__fields), r_028214_pa_sc_cliprect_0_br__fields},
	{"PA_SC_CLIPRECT_3_TL", R_028228_PA_SC_CLIPRECT_3_TL, ARRAY_SIZE(r_028210_pa_sc_cliprect_0_tl__fields), r_028210_pa_sc_cliprect_0_tl__fields},
	{"PA_SC_CLIPRECT_3_BR", R_02822C_PA_SC_CLIPRECT_3_BR, ARRAY_SIZE(r_028214_pa_sc_cliprect_0_br__fields), r_028214_pa_sc_cliprect_0_br__fields},
	{"PA_SC_EDGERULE", R_028230_PA_SC_EDGERULE, ARRAY_SIZE(r_028230_pa_sc_edgerule__fields), r_028230_pa_sc_edgerule__fields},
	{"PA_SU_HARDWARE_SCREEN_OFFSET", R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, ARRAY_SIZE(r_028234_pa_su_hardware_screen_offset__fields), r_028234_pa_su_hardware_screen_offset__fields},
	{"CB_TARGET_MASK", R_028238_CB_TARGET_MASK, ARRAY_SIZE(r_028238_cb_target_mask__fields), r_028238_cb_target_mask__fields},
	{"CB_SHADER_MASK", R_02823C_CB_SHADER_MASK, ARRAY_SIZE(r_02823c_cb_shader_mask__fields), r_02823c_cb_shader_mask__fields},
	{"PA_SC_GENERIC_SCISSOR_TL", R_028240_PA_SC_GENERIC_SCISSOR_TL, ARRAY_SIZE(r_028240_pa_sc_generic_scissor_tl__fields), r_028240_pa_sc_generic_scissor_tl__fields},
	{"PA_SC_GENERIC_SCISSOR_BR", R_028244_PA_SC_GENERIC_SCISSOR_BR, ARRAY_SIZE(r_028244_pa_sc_generic_scissor_br__fields), r_028244_pa_sc_generic_scissor_br__fields},
	{"COHER_DEST_BASE_0", R_028248_COHER_DEST_BASE_0},
	{"COHER_DEST_BASE_1", R_02824C_COHER_DEST_BASE_1},
	{"PA_SC_VPORT_SCISSOR_0_TL", R_028250_PA_SC_VPORT_SCISSOR_0_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_0_BR", R_028254_PA_SC_VPORT_SCISSOR_0_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_1_TL", R_028258_PA_SC_VPORT_SCISSOR_1_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_1_BR", R_02825C_PA_SC_VPORT_SCISSOR_1_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_2_TL", R_028260_PA_SC_VPORT_SCISSOR_2_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_2_BR", R_028264_PA_SC_VPORT_SCISSOR_2_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_3_TL", R_028268_PA_SC_VPORT_SCISSOR_3_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_3_BR", R_02826C_PA_SC_VPORT_SCISSOR_3_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_4_TL", R_028270_PA_SC_VPORT_SCISSOR_4_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_4_BR", R_028274_PA_SC_VPORT_SCISSOR_4_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_5_TL", R_028278_PA_SC_VPORT_SCISSOR_5_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_5_BR", R_02827C_PA_SC_VPORT_SCISSOR_5_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_6_TL", R_028280_PA_SC_VPORT_SCISSOR_6_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_6_BR", R_028284_PA_SC_VPORT_SCISSOR_6_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_7_TL", R_028288_PA_SC_VPORT_SCISSOR_7_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_7_BR", R_02828C_PA_SC_VPORT_SCISSOR_7_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_8_TL", R_028290_PA_SC_VPORT_SCISSOR_8_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_8_BR", R_028294_PA_SC_VPORT_SCISSOR_8_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_9_TL", R_028298_PA_SC_VPORT_SCISSOR_9_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_9_BR", R_02829C_PA_SC_VPORT_SCISSOR_9_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_10_TL", R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_10_BR", R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_11_TL", R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_11_BR", R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_12_TL", R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_12_BR", R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_13_TL", R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_13_BR", R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_14_TL", R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_14_BR", R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_SCISSOR_15_TL", R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, ARRAY_SIZE(r_028250_pa_sc_vport_scissor_0_tl__fields), r_028250_pa_sc_vport_scissor_0_tl__fields},
	{"PA_SC_VPORT_SCISSOR_15_BR", R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, ARRAY_SIZE(r_028254_pa_sc_vport_scissor_0_br__fields), r_028254_pa_sc_vport_scissor_0_br__fields},
	{"PA_SC_VPORT_ZMIN_0", R_0282D0_PA_SC_VPORT_ZMIN_0},
	{"PA_SC_VPORT_ZMAX_0", R_0282D4_PA_SC_VPORT_ZMAX_0},
	{"PA_SC_VPORT_ZMIN_1", R_0282D8_PA_SC_VPORT_ZMIN_1},
	{"PA_SC_VPORT_ZMAX_1", R_0282DC_PA_SC_VPORT_ZMAX_1},
	{"PA_SC_VPORT_ZMIN_2", R_0282E0_PA_SC_VPORT_ZMIN_2},
	{"PA_SC_VPORT_ZMAX_2", R_0282E4_PA_SC_VPORT_ZMAX_2},
	{"PA_SC_VPORT_ZMIN_3", R_0282E8_PA_SC_VPORT_ZMIN_3},
	{"PA_SC_VPORT_ZMAX_3", R_0282EC_PA_SC_VPORT_ZMAX_3},
	{"PA_SC_VPORT_ZMIN_4", R_0282F0_PA_SC_VPORT_ZMIN_4},
	{"PA_SC_VPORT_ZMAX_4", R_0282F4_PA_SC_VPORT_ZMAX_4},
	{"PA_SC_VPORT_ZMIN_5", R_0282F8_PA_SC_VPORT_ZMIN_5},
	{"PA_SC_VPORT_ZMAX_5", R_0282FC_PA_SC_VPORT_ZMAX_5},
	{"PA_SC_VPORT_ZMIN_6", R_028300_PA_SC_VPORT_ZMIN_6},
	{"PA_SC_VPORT_ZMAX_6", R_028304_PA_SC_VPORT_ZMAX_6},
	{"PA_SC_VPORT_ZMIN_7", R_028308_PA_SC_VPORT_ZMIN_7},
	{"PA_SC_VPORT_ZMAX_7", R_02830C_PA_SC_VPORT_ZMAX_7},
	{"PA_SC_VPORT_ZMIN_8", R_028310_PA_SC_VPORT_ZMIN_8},
	{"PA_SC_VPORT_ZMAX_8", R_028314_PA_SC_VPORT_ZMAX_8},
	{"PA_SC_VPORT_ZMIN_9", R_028318_PA_SC_VPORT_ZMIN_9},
	{"PA_SC_VPORT_ZMAX_9", R_02831C_PA_SC_VPORT_ZMAX_9},
	{"PA_SC_VPORT_ZMIN_10", R_028320_PA_SC_VPORT_ZMIN_10},
	{"PA_SC_VPORT_ZMAX_10", R_028324_PA_SC_VPORT_ZMAX_10},
	{"PA_SC_VPORT_ZMIN_11", R_028328_PA_SC_VPORT_ZMIN_11},
	{"PA_SC_VPORT_ZMAX_11", R_02832C_PA_SC_VPORT_ZMAX_11},
	{"PA_SC_VPORT_ZMIN_12", R_028330_PA_SC_VPORT_ZMIN_12},
	{"PA_SC_VPORT_ZMAX_12", R_028334_PA_SC_VPORT_ZMAX_12},
	{"PA_SC_VPORT_ZMIN_13", R_028338_PA_SC_VPORT_ZMIN_13},
	{"PA_SC_VPORT_ZMAX_13", R_02833C_PA_SC_VPORT_ZMAX_13},
	{"PA_SC_VPORT_ZMIN_14", R_028340_PA_SC_VPORT_ZMIN_14},
	{"PA_SC_VPORT_ZMAX_14", R_028344_PA_SC_VPORT_ZMAX_14},
	{"PA_SC_VPORT_ZMIN_15", R_028348_PA_SC_VPORT_ZMIN_15},
	{"PA_SC_VPORT_ZMAX_15", R_02834C_PA_SC_VPORT_ZMAX_15},
	{"PA_SC_RASTER_CONFIG", R_028350_PA_SC_RASTER_CONFIG, ARRAY_SIZE(r_028350_pa_sc_raster_config__fields), r_028350_pa_sc_raster_config__fields},
	{"PA_SC_RASTER_CONFIG_1", R_028354_PA_SC_RASTER_CONFIG_1, ARRAY_SIZE(r_028354_pa_sc_raster_config_1__fields), r_028354_pa_sc_raster_config_1__fields},
	{"PA_SC_SCREEN_EXTENT_CONTROL", R_028358_PA_SC_SCREEN_EXTENT_CONTROL, ARRAY_SIZE(r_028358_pa_sc_screen_extent_control__fields), r_028358_pa_sc_screen_extent_control__fields},
	{"VGT_MAX_VTX_INDX", R_028400_VGT_MAX_VTX_INDX},
	{"VGT_MIN_VTX_INDX", R_028404_VGT_MIN_VTX_INDX},
	{"VGT_INDX_OFFSET", R_028408_VGT_INDX_OFFSET},
	{"VGT_MULTI_PRIM_IB_RESET_INDX", R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{"CB_BLEND_RED", R_028414_CB_BLEND_RED},
	{"CB_BLEND_GREEN", R_028418_CB_BLEND_GREEN},
	{"CB_BLEND_BLUE", R_02841C_CB_BLEND_BLUE},
	{"CB_BLEND_ALPHA", R_028420_CB_BLEND_ALPHA},
	{"CB_DCC_CONTROL", R_028424_CB_DCC_CONTROL, ARRAY_SIZE(r_028424_cb_dcc_control__fields), r_028424_cb_dcc_control__fields},
	{"DB_STENCIL_CONTROL", R_02842C_DB_STENCIL_CONTROL, ARRAY_SIZE(r_02842c_db_stencil_control__fields), r_02842c_db_stencil_control__fields},
	{"DB_STENCILREFMASK", R_028430_DB_STENCILREFMASK, ARRAY_SIZE(r_028430_db_stencilrefmask__fields), r_028430_db_stencilrefmask__fields},
	{"DB_STENCILREFMASK_BF", R_028434_DB_STENCILREFMASK_BF, ARRAY_SIZE(r_028434_db_stencilrefmask_bf__fields), r_028434_db_stencilrefmask_bf__fields},
	{"PA_CL_VPORT_XSCALE", R_02843C_PA_CL_VPORT_XSCALE},
	{"PA_CL_VPORT_XOFFSET", R_028440_PA_CL_VPORT_XOFFSET},
	{"PA_CL_VPORT_YSCALE", R_028444_PA_CL_VPORT_YSCALE},
	{"PA_CL_VPORT_YOFFSET", R_028448_PA_CL_VPORT_YOFFSET},
	{"PA_CL_VPORT_ZSCALE", R_02844C_PA_CL_VPORT_ZSCALE},
	{"PA_CL_VPORT_ZOFFSET", R_028450_PA_CL_VPORT_ZOFFSET},
	{"PA_CL_VPORT_XSCALE_1", R_028454_PA_CL_VPORT_XSCALE_1},
	{"PA_CL_VPORT_XOFFSET_1", R_028458_PA_CL_VPORT_XOFFSET_1},
	{"PA_CL_VPORT_YSCALE_1", R_02845C_PA_CL_VPORT_YSCALE_1},
	{"PA_CL_VPORT_YOFFSET_1", R_028460_PA_CL_VPORT_YOFFSET_1},
	{"PA_CL_VPORT_ZSCALE_1", R_028464_PA_CL_VPORT_ZSCALE_1},
	{"PA_CL_VPORT_ZOFFSET_1", R_028468_PA_CL_VPORT_ZOFFSET_1},
	{"PA_CL_VPORT_XSCALE_2", R_02846C_PA_CL_VPORT_XSCALE_2},
	{"PA_CL_VPORT_XOFFSET_2", R_028470_PA_CL_VPORT_XOFFSET_2},
	{"PA_CL_VPORT_YSCALE_2", R_028474_PA_CL_VPORT_YSCALE_2},
	{"PA_CL_VPORT_YOFFSET_2", R_028478_PA_CL_VPORT_YOFFSET_2},
	{"PA_CL_VPORT_ZSCALE_2", R_02847C_PA_CL_VPORT_ZSCALE_2},
	{"PA_CL_VPORT_ZOFFSET_2", R_028480_PA_CL_VPORT_ZOFFSET_2},
	{"PA_CL_VPORT_XSCALE_3", R_028484_PA_CL_VPORT_XSCALE_3},
	{"PA_CL_VPORT_XOFFSET_3", R_028488_PA_CL_VPORT_XOFFSET_3},
	{"PA_CL_VPORT_YSCALE_3", R_02848C_PA_CL_VPORT_YSCALE_3},
	{"PA_CL_VPORT_YOFFSET_3", R_028490_PA_CL_VPORT_YOFFSET_3},
	{"PA_CL_VPORT_ZSCALE_3", R_028494_PA_CL_VPORT_ZSCALE_3},
	{"PA_CL_VPORT_ZOFFSET_3", R_028498_PA_CL_VPORT_ZOFFSET_3},
	{"PA_CL_VPORT_XSCALE_4", R_02849C_PA_CL_VPORT_XSCALE_4},
	{"PA_CL_VPORT_XOFFSET_4", R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{"PA_CL_VPORT_YSCALE_4", R_0284A4_PA_CL_VPORT_YSCALE_4},
	{"PA_CL_VPORT_YOFFSET_4", R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{"PA_CL_VPORT_ZSCALE_4", R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{"PA_CL_VPORT_ZOFFSET_4", R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{"PA_CL_VPORT_XSCALE_5", R_0284B4_PA_CL_VPORT_XSCALE_5},
	{"PA_CL_VPORT_XOFFSET_5", R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{"PA_CL_VPORT_YSCALE_5", R_0284BC_PA_CL_VPORT_YSCALE_5},
	{"PA_CL_VPORT_YOFFSET_5", R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{"PA_CL_VPORT_ZSCALE_5", R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{"PA_CL_VPORT_ZOFFSET_5", R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{"PA_CL_VPORT_XSCALE_6", R_0284CC_PA_CL_VPORT_XSCALE_6},
	{"PA_CL_VPORT_XOFFSET_6", R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{"PA_CL_VPORT_YSCALE_6", R_0284D4_PA_CL_VPORT_YSCALE_6},
	{"PA_CL_VPORT_YOFFSET_6", R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{"PA_CL_VPORT_ZSCALE_6", R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{"PA_CL_VPORT_ZOFFSET_6", R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{"PA_CL_VPORT_XSCALE_7", R_0284E4_PA_CL_VPORT_XSCALE_7},
	{"PA_CL_VPORT_XOFFSET_7", R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{"PA_CL_VPORT_YSCALE_7", R_0284EC_PA_CL_VPORT_YSCALE_7},
	{"PA_CL_VPORT_YOFFSET_7", R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{"PA_CL_VPORT_ZSCALE_7", R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{"PA_CL_VPORT_ZOFFSET_7", R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{"PA_CL_VPORT_XSCALE_8", R_0284FC_PA_CL_VPORT_XSCALE_8},
	{"PA_CL_VPORT_XOFFSET_8", R_028500_PA_CL_VPORT_XOFFSET_8},
	{"PA_CL_VPORT_YSCALE_8", R_028504_PA_CL_VPORT_YSCALE_8},
	{"PA_CL_VPORT_YOFFSET_8", R_028508_PA_CL_VPORT_YOFFSET_8},
	{"PA_CL_VPORT_ZSCALE_8", R_02850C_PA_CL_VPORT_ZSCALE_8},
	{"PA_CL_VPORT_ZOFFSET_8", R_028510_PA_CL_VPORT_ZOFFSET_8},
	{"PA_CL_VPORT_XSCALE_9", R_028514_PA_CL_VPORT_XSCALE_9},
	{"PA_CL_VPORT_XOFFSET_9", R_028518_PA_CL_VPORT_XOFFSET_9},
	{"PA_CL_VPORT_YSCALE_9", R_02851C_PA_CL_VPORT_YSCALE_9},
	{"PA_CL_VPORT_YOFFSET_9", R_028520_PA_CL_VPORT_YOFFSET_9},
	{"PA_CL_VPORT_ZSCALE_9", R_028524_PA_CL_VPORT_ZSCALE_9},
	{"PA_CL_VPORT_ZOFFSET_9", R_028528_PA_CL_VPORT_ZOFFSET_9},
	{"PA_CL_VPORT_XSCALE_10", R_02852C_PA_CL_VPORT_XSCALE_10},
	{"PA_CL_VPORT_XOFFSET_10", R_028530_PA_CL_VPORT_XOFFSET_10},
	{"PA_CL_VPORT_YSCALE_10", R_028534_PA_CL_VPORT_YSCALE_10},
	{"PA_CL_VPORT_YOFFSET_10", R_028538_PA_CL_VPORT_YOFFSET_10},
	{"PA_CL_VPORT_ZSCALE_10", R_02853C_PA_CL_VPORT_ZSCALE_10},
	{"PA_CL_VPORT_ZOFFSET_10", R_028540_PA_CL_VPORT_ZOFFSET_10},
	{"PA_CL_VPORT_XSCALE_11", R_028544_PA_CL_VPORT_XSCALE_11},
	{"PA_CL_VPORT_XOFFSET_11", R_028548_PA_CL_VPORT_XOFFSET_11},
	{"PA_CL_VPORT_YSCALE_11", R_02854C_PA_CL_VPORT_YSCALE_11},
	{"PA_CL_VPORT_YOFFSET_11", R_028550_PA_CL_VPORT_YOFFSET_11},
	{"PA_CL_VPORT_ZSCALE_11", R_028554_PA_CL_VPORT_ZSCALE_11},
	{"PA_CL_VPORT_ZOFFSET_11", R_028558_PA_CL_VPORT_ZOFFSET_11},
	{"PA_CL_VPORT_XSCALE_12", R_02855C_PA_CL_VPORT_XSCALE_12},
	{"PA_CL_VPORT_XOFFSET_12", R_028560_PA_CL_VPORT_XOFFSET_12},
	{"PA_CL_VPORT_YSCALE_12", R_028564_PA_CL_VPORT_YSCALE_12},
	{"PA_CL_VPORT_YOFFSET_12", R_028568_PA_CL_VPORT_YOFFSET_12},
	{"PA_CL_VPORT_ZSCALE_12", R_02856C_PA_CL_VPORT_ZSCALE_12},
	{"PA_CL_VPORT_ZOFFSET_12", R_028570_PA_CL_VPORT_ZOFFSET_12},
	{"PA_CL_VPORT_XSCALE_13", R_028574_PA_CL_VPORT_XSCALE_13},
	{"PA_CL_VPORT_XOFFSET_13", R_028578_PA_CL_VPORT_XOFFSET_13},
	{"PA_CL_VPORT_YSCALE_13", R_02857C_PA_CL_VPORT_YSCALE_13},
	{"PA_CL_VPORT_YOFFSET_13", R_028580_PA_CL_VPORT_YOFFSET_13},
	{"PA_CL_VPORT_ZSCALE_13", R_028584_PA_CL_VPORT_ZSCALE_13},
	{"PA_CL_VPORT_ZOFFSET_13", R_028588_PA_CL_VPORT_ZOFFSET_13},
	{"PA_CL_VPORT_XSCALE_14", R_02858C_PA_CL_VPORT_XSCALE_14},
	{"PA_CL_VPORT_XOFFSET_14", R_028590_PA_CL_VPORT_XOFFSET_14},
	{"PA_CL_VPORT_YSCALE_14", R_028594_PA_CL_VPORT_YSCALE_14},
	{"PA_CL_VPORT_YOFFSET_14", R_028598_PA_CL_VPORT_YOFFSET_14},
	{"PA_CL_VPORT_ZSCALE_14", R_02859C_PA_CL_VPORT_ZSCALE_14},
	{"PA_CL_VPORT_ZOFFSET_14", R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{"PA_CL_VPORT_XSCALE_15", R_0285A4_PA_CL_VPORT_XSCALE_15},
	{"PA_CL_VPORT_XOFFSET_15", R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{"PA_CL_VPORT_YSCALE_15", R_0285AC_PA_CL_VPORT_YSCALE_15},
	{"PA_CL_VPORT_YOFFSET_15", R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{"PA_CL_VPORT_ZSCALE_15", R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{"PA_CL_VPORT_ZOFFSET_15", R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{"PA_CL_UCP_0_X", R_0285BC_PA_CL_UCP_0_X},
	{"PA_CL_UCP_0_Y", R_0285C0_PA_CL_UCP_0_Y},
	{"PA_CL_UCP_0_Z", R_0285C4_PA_CL_UCP_0_Z},
	{"PA_CL_UCP_0_W", R_0285C8_PA_CL_UCP_0_W},
	{"PA_CL_UCP_1_X", R_0285CC_PA_CL_UCP_1_X},
	{"PA_CL_UCP_1_Y", R_0285D0_PA_CL_UCP_1_Y},
	{"PA_CL_UCP_1_Z", R_0285D4_PA_CL_UCP_1_Z},
	{"PA_CL_UCP_1_W", R_0285D8_PA_CL_UCP_1_W},
	{"PA_CL_UCP_2_X", R_0285DC_PA_CL_UCP_2_X},
	{"PA_CL_UCP_2_Y", R_0285E0_PA_CL_UCP_2_Y},
	{"PA_CL_UCP_2_Z", R_0285E4_PA_CL_UCP_2_Z},
	{"PA_CL_UCP_2_W", R_0285E8_PA_CL_UCP_2_W},
	{"PA_CL_UCP_3_X", R_0285EC_PA_CL_UCP_3_X},
	{"PA_CL_UCP_3_Y", R_0285F0_PA_CL_UCP_3_Y},
	{"PA_CL_UCP_3_Z", R_0285F4_PA_CL_UCP_3_Z},
	{"PA_CL_UCP_3_W", R_0285F8_PA_CL_UCP_3_W},
	{"PA_CL_UCP_4_X", R_0285FC_PA_CL_UCP_4_X},
	{"PA_CL_UCP_4_Y", R_028600_PA_CL_UCP_4_Y},
	{"PA_CL_UCP_4_Z", R_028604_PA_CL_UCP_4_Z},
	{"PA_CL_UCP_4_W", R_028608_PA_CL_UCP_4_W},
	{"PA_CL_UCP_5_X", R_02860C_PA_CL_UCP_5_X},
	{"PA_CL_UCP_5_Y", R_028610_PA_CL_UCP_5_Y},
	{"PA_CL_UCP_5_Z", R_028614_PA_CL_UCP_5_Z},
	{"PA_CL_UCP_5_W", R_028618_PA_CL_UCP_5_W},
	{"SPI_PS_INPUT_CNTL_0", R_028644_SPI_PS_INPUT_CNTL_0, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_1", R_028648_SPI_PS_INPUT_CNTL_1, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_2", R_02864C_SPI_PS_INPUT_CNTL_2, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_3", R_028650_SPI_PS_INPUT_CNTL_3, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_4", R_028654_SPI_PS_INPUT_CNTL_4, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_5", R_028658_SPI_PS_INPUT_CNTL_5, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_6", R_02865C_SPI_PS_INPUT_CNTL_6, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_7", R_028660_SPI_PS_INPUT_CNTL_7, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_8", R_028664_SPI_PS_INPUT_CNTL_8, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_9", R_028668_SPI_PS_INPUT_CNTL_9, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_10", R_02866C_SPI_PS_INPUT_CNTL_10, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_11", R_028670_SPI_PS_INPUT_CNTL_11, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_12", R_028674_SPI_PS_INPUT_CNTL_12, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_13", R_028678_SPI_PS_INPUT_CNTL_13, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_14", R_02867C_SPI_PS_INPUT_CNTL_14, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_15", R_028680_SPI_PS_INPUT_CNTL_15, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_16", R_028684_SPI_PS_INPUT_CNTL_16, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_17", R_028688_SPI_PS_INPUT_CNTL_17, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_18", R_02868C_SPI_PS_INPUT_CNTL_18, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_19", R_028690_SPI_PS_INPUT_CNTL_19, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_20", R_028694_SPI_PS_INPUT_CNTL_20, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_21", R_028698_SPI_PS_INPUT_CNTL_21, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_22", R_02869C_SPI_PS_INPUT_CNTL_22, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_23", R_0286A0_SPI_PS_INPUT_CNTL_23, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_24", R_0286A4_SPI_PS_INPUT_CNTL_24, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_25", R_0286A8_SPI_PS_INPUT_CNTL_25, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_26", R_0286AC_SPI_PS_INPUT_CNTL_26, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_27", R_0286B0_SPI_PS_INPUT_CNTL_27, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_28", R_0286B4_SPI_PS_INPUT_CNTL_28, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_29", R_0286B8_SPI_PS_INPUT_CNTL_29, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_30", R_0286BC_SPI_PS_INPUT_CNTL_30, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_PS_INPUT_CNTL_31", R_0286C0_SPI_PS_INPUT_CNTL_31, ARRAY_SIZE(r_028644_spi_ps_input_cntl_0__fields), r_028644_spi_ps_input_cntl_0__fields},
	{"SPI_VS_OUT_CONFIG", R_0286C4_SPI_VS_OUT_CONFIG, ARRAY_SIZE(r_0286c4_spi_vs_out_config__fields), r_0286c4_spi_vs_out_config__fields},
	{"SPI_PS_INPUT_ENA", R_0286CC_SPI_PS_INPUT_ENA, ARRAY_SIZE(r_0286cc_spi_ps_input_ena__fields), r_0286cc_spi_ps_input_ena__fields},
	{"SPI_PS_INPUT_ADDR", R_0286D0_SPI_PS_INPUT_ADDR, ARRAY_SIZE(r_0286d0_spi_ps_input_addr__fields), r_0286d0_spi_ps_input_addr__fields},
	{"SPI_INTERP_CONTROL_0", R_0286D4_SPI_INTERP_CONTROL_0, ARRAY_SIZE(r_0286d4_spi_interp_control_0__fields), r_0286d4_spi_interp_control_0__fields},
	{"SPI_PS_IN_CONTROL", R_0286D8_SPI_PS_IN_CONTROL, ARRAY_SIZE(r_0286d8_spi_ps_in_control__fields), r_0286d8_spi_ps_in_control__fields},
	{"SPI_BARYC_CNTL", R_0286E0_SPI_BARYC_CNTL, ARRAY_SIZE(r_0286e0_spi_baryc_cntl__fields), r_0286e0_spi_baryc_cntl__fields},
	{"SPI_TMPRING_SIZE", R_0286E8_SPI_TMPRING_SIZE, ARRAY_SIZE(r_0286e8_spi_tmpring_size__fields), r_0286e8_spi_tmpring_size__fields},
	{"SPI_WAVE_MGMT_1", R_028704_SPI_WAVE_MGMT_1, ARRAY_SIZE(r_028704_spi_wave_mgmt_1__fields), r_028704_spi_wave_mgmt_1__fields},
	{"SPI_WAVE_MGMT_2", R_028708_SPI_WAVE_MGMT_2, ARRAY_SIZE(r_028708_spi_wave_mgmt_2__fields), r_028708_spi_wave_mgmt_2__fields},
	{"SPI_SHADER_POS_FORMAT", R_02870C_SPI_SHADER_POS_FORMAT, ARRAY_SIZE(r_02870c_spi_shader_pos_format__fields), r_02870c_spi_shader_pos_format__fields},
	{"SPI_SHADER_Z_FORMAT", R_028710_SPI_SHADER_Z_FORMAT, ARRAY_SIZE(r_028710_spi_shader_z_format__fields), r_028710_spi_shader_z_format__fields},
	{"SPI_SHADER_COL_FORMAT", R_028714_SPI_SHADER_COL_FORMAT, ARRAY_SIZE(r_028714_spi_shader_col_format__fields), r_028714_spi_shader_col_format__fields},
	{"SX_PS_DOWNCONVERT", R_028754_SX_PS_DOWNCONVERT, ARRAY_SIZE(r_028754_sx_ps_downconvert__fields), r_028754_sx_ps_downconvert__fields},
	{"SX_BLEND_OPT_EPSILON", R_028758_SX_BLEND_OPT_EPSILON, ARRAY_SIZE(r_028758_sx_blend_opt_epsilon__fields), r_028758_sx_blend_opt_epsilon__fields},
	{"SX_BLEND_OPT_CONTROL", R_02875C_SX_BLEND_OPT_CONTROL, ARRAY_SIZE(r_02875c_sx_blend_opt_control__fields), r_02875c_sx_blend_opt_control__fields},
	{"SX_MRT0_BLEND_OPT", R_028760_SX_MRT0_BLEND_OPT, ARRAY_SIZE(r_028760_sx_mrt0_blend_opt__fields), r_028760_sx_mrt0_blend_opt__fields},
	{"SX_MRT1_BLEND_OPT", R_028764_SX_MRT1_BLEND_OPT, ARRAY_SIZE(r_028764_sx_mrt1_blend_opt__fields), r_028764_sx_mrt1_blend_opt__fields},
	{"SX_MRT2_BLEND_OPT", R_028768_SX_MRT2_BLEND_OPT, ARRAY_SIZE(r_028768_sx_mrt2_blend_opt__fields), r_028768_sx_mrt2_blend_opt__fields},
	{"SX_MRT3_BLEND_OPT", R_02876C_SX_MRT3_BLEND_OPT, ARRAY_SIZE(r_02876c_sx_mrt3_blend_opt__fields), r_02876c_sx_mrt3_blend_opt__fields},
	{"SX_MRT4_BLEND_OPT", R_028770_SX_MRT4_BLEND_OPT, ARRAY_SIZE(r_028770_sx_mrt4_blend_opt__fields), r_028770_sx_mrt4_blend_opt__fields},
	{"SX_MRT5_BLEND_OPT", R_028774_SX_MRT5_BLEND_OPT, ARRAY_SIZE(r_028774_sx_mrt5_blend_opt__fields), r_028774_sx_mrt5_blend_opt__fields},
	{"SX_MRT6_BLEND_OPT", R_028778_SX_MRT6_BLEND_OPT, ARRAY_SIZE(r_028778_sx_mrt6_blend_opt__fields), r_028778_sx_mrt6_blend_opt__fields},
	{"SX_MRT7_BLEND_OPT", R_02877C_SX_MRT7_BLEND_OPT, ARRAY_SIZE(r_02877c_sx_mrt7_blend_opt__fields), r_02877c_sx_mrt7_blend_opt__fields},
	{"CB_BLEND0_CONTROL", R_028780_CB_BLEND0_CONTROL, ARRAY_SIZE(r_028780_cb_blend0_control__fields), r_028780_cb_blend0_control__fields},
	{"CB_BLEND1_CONTROL", R_028784_CB_BLEND1_CONTROL, ARRAY_SIZE(r_028780_cb_blend0_control__fields), r_028780_cb_blend0_control__fields},
	{"CB_BLEND2_CONTROL", R_028788_CB_BLEND2_CONTROL, ARRAY_SIZE(r_028780_cb_blend0_control__fields), r_028780_cb_blend0_control__fields},
	{"CB_BLEND3_CONTROL", R_02878C_CB_BLEND3_CONTROL, ARRAY_SIZE(r_028780_cb_blend0_control__fields), r_028780_cb_blend0_control__fields},
	{"CB_BLEND4_CONTROL", R_028790_CB_BLEND4_CONTROL, ARRAY_SIZE(r_028780_cb_blend0_control__fields), r_028780_cb_blend0_control__fields},
	{"CB_BLEND5_CONTROL", R_028794_CB_BLEND5_CONTROL, ARRAY_SIZE(r_028780_cb_blend0_control__fields), r_028780_cb_blend0_control__fields},
	{"CB_BLEND6_CONTROL", R_028798_CB_BLEND6_CONTROL, ARRAY_SIZE(r_028780_cb_blend0_control__fields), r_028780_cb_blend0_control__fields},
	{"CB_BLEND7_CONTROL", R_02879C_CB_BLEND7_CONTROL, ARRAY_SIZE(r_028780_cb_blend0_control__fields), r_028780_cb_blend0_control__fields},
	{"CS_COPY_STATE", R_0287CC_CS_COPY_STATE, ARRAY_SIZE(r_0287cc_cs_copy_state__fields), r_0287cc_cs_copy_state__fields},
	{"PA_CL_POINT_X_RAD", R_0287D4_PA_CL_POINT_X_RAD},
	{"PA_CL_POINT_Y_RAD", R_0287D8_PA_CL_POINT_Y_RAD},
	{"PA_CL_POINT_SIZE", R_0287DC_PA_CL_POINT_SIZE},
	{"PA_CL_POINT_CULL_RAD", R_0287E0_PA_CL_POINT_CULL_RAD},
	{"VGT_DMA_BASE_HI", R_0287E4_VGT_DMA_BASE_HI, ARRAY_SIZE(r_0287e4_vgt_dma_base_hi__fields), r_0287e4_vgt_dma_base_hi__fields},
	{"VGT_DMA_BASE", R_0287E8_VGT_DMA_BASE},
	{"VGT_DRAW_INITIATOR", R_0287F0_VGT_DRAW_INITIATOR, ARRAY_SIZE(r_0287f0_vgt_draw_initiator__fields), r_0287f0_vgt_draw_initiator__fields},
	{"VGT_IMMED_DATA", R_0287F4_VGT_IMMED_DATA},
	{"VGT_EVENT_ADDRESS_REG", R_0287F8_VGT_EVENT_ADDRESS_REG, ARRAY_SIZE(r_0287f8_vgt_event_address_reg__fields), r_0287f8_vgt_event_address_reg__fields},
	{"DB_DEPTH_CONTROL", R_028800_DB_DEPTH_CONTROL, ARRAY_SIZE(r_028800_db_depth_control__fields), r_028800_db_depth_control__fields},
	{"DB_EQAA", R_028804_DB_EQAA, ARRAY_SIZE(r_028804_db_eqaa__fields), r_028804_db_eqaa__fields},
	{"CB_COLOR_CONTROL", R_028808_CB_COLOR_CONTROL, ARRAY_SIZE(r_028808_cb_color_control__fields), r_028808_cb_color_control__fields},
	{"DB_SHADER_CONTROL", R_02880C_DB_SHADER_CONTROL, ARRAY_SIZE(r_02880c_db_shader_control__fields), r_02880c_db_shader_control__fields},
	{"PA_CL_CLIP_CNTL", R_028810_PA_CL_CLIP_CNTL, ARRAY_SIZE(r_028810_pa_cl_clip_cntl__fields), r_028810_pa_cl_clip_cntl__fields},
	{"PA_SU_SC_MODE_CNTL", R_028814_PA_SU_SC_MODE_CNTL, ARRAY_SIZE(r_028814_pa_su_sc_mode_cntl__fields), r_028814_pa_su_sc_mode_cntl__fields},
	{"PA_CL_VTE_CNTL", R_028818_PA_CL_VTE_CNTL, ARRAY_SIZE(r_028818_pa_cl_vte_cntl__fields), r_028818_pa_cl_vte_cntl__fields},
	{"PA_CL_VS_OUT_CNTL", R_02881C_PA_CL_VS_OUT_CNTL, ARRAY_SIZE(r_02881c_pa_cl_vs_out_cntl__fields), r_02881c_pa_cl_vs_out_cntl__fields},
	{"PA_CL_NANINF_CNTL", R_028820_PA_CL_NANINF_CNTL, ARRAY_SIZE(r_028820_pa_cl_naninf_cntl__fields), r_028820_pa_cl_naninf_cntl__fields},
	{"PA_SU_LINE_STIPPLE_CNTL", R_028824_PA_SU_LINE_STIPPLE_CNTL, ARRAY_SIZE(r_028824_pa_su_line_stipple_cntl__fields), r_028824_pa_su_line_stipple_cntl__fields},
	{"PA_SU_LINE_STIPPLE_SCALE", R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{"PA_SU_PRIM_FILTER_CNTL", R_02882C_PA_SU_PRIM_FILTER_CNTL, ARRAY_SIZE(r_02882c_pa_su_prim_filter_cntl__fields), r_02882c_pa_su_prim_filter_cntl__fields},
	{"PA_SU_POINT_SIZE", R_028A00_PA_SU_POINT_SIZE, ARRAY_SIZE(r_028a00_pa_su_point_size__fields), r_028a00_pa_su_point_size__fields},
	{"PA_SU_POINT_MINMAX", R_028A04_PA_SU_POINT_MINMAX, ARRAY_SIZE(r_028a04_pa_su_point_minmax__fields), r_028a04_pa_su_point_minmax__fields},
	{"PA_SU_LINE_CNTL", R_028A08_PA_SU_LINE_CNTL, ARRAY_SIZE(r_028a08_pa_su_line_cntl__fields), r_028a08_pa_su_line_cntl__fields},
	{"PA_SC_LINE_STIPPLE", R_028A0C_PA_SC_LINE_STIPPLE, ARRAY_SIZE(r_028a0c_pa_sc_line_stipple__fields), r_028a0c_pa_sc_line_stipple__fields},
	{"VGT_OUTPUT_PATH_CNTL", R_028A10_VGT_OUTPUT_PATH_CNTL, ARRAY_SIZE(r_028a10_vgt_output_path_cntl__fields), r_028a10_vgt_output_path_cntl__fields},
	{"VGT_HOS_CNTL", R_028A14_VGT_HOS_CNTL, ARRAY_SIZE(r_028a14_vgt_hos_cntl__fields), r_028a14_vgt_hos_cntl__fields},
	{"VGT_HOS_MAX_TESS_LEVEL", R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{"VGT_HOS_MIN_TESS_LEVEL", R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{"VGT_HOS_REUSE_DEPTH", R_028A20_VGT_HOS_REUSE_DEPTH, ARRAY_SIZE(r_028a20_vgt_hos_reuse_depth__fields), r_028a20_vgt_hos_reuse_depth__fields},
	{"VGT_GROUP_PRIM_TYPE", R_028A24_VGT_GROUP_PRIM_TYPE, ARRAY_SIZE(r_028a24_vgt_group_prim_type__fields), r_028a24_vgt_group_prim_type__fields},
	{"VGT_GROUP_FIRST_DECR", R_028A28_VGT_GROUP_FIRST_DECR, ARRAY_SIZE(r_028a28_vgt_group_first_decr__fields), r_028a28_vgt_group_first_decr__fields},
	{"VGT_GROUP_DECR", R_028A2C_VGT_GROUP_DECR, ARRAY_SIZE(r_028a2c_vgt_group_decr__fields), r_028a2c_vgt_group_decr__fields},
	{"VGT_GROUP_VECT_0_CNTL", R_028A30_VGT_GROUP_VECT_0_CNTL, ARRAY_SIZE(r_028a30_vgt_group_vect_0_cntl__fields), r_028a30_vgt_group_vect_0_cntl__fields},
	{"VGT_GROUP_VECT_1_CNTL", R_028A34_VGT_GROUP_VECT_1_CNTL, ARRAY_SIZE(r_028a34_vgt_group_vect_1_cntl__fields), r_028a34_vgt_group_vect_1_cntl__fields},
	{"VGT_GROUP_VECT_0_FMT_CNTL", R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, ARRAY_SIZE(r_028a38_vgt_group_vect_0_fmt_cntl__fields), r_028a38_vgt_group_vect_0_fmt_cntl__fields},
	{"VGT_GROUP_VECT_1_FMT_CNTL", R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, ARRAY_SIZE(r_028a3c_vgt_group_vect_1_fmt_cntl__fields), r_028a3c_vgt_group_vect_1_fmt_cntl__fields},
	{"VGT_GS_MODE", R_028A40_VGT_GS_MODE, ARRAY_SIZE(r_028a40_vgt_gs_mode__fields), r_028a40_vgt_gs_mode__fields},
	{"VGT_GS_ONCHIP_CNTL", R_028A44_VGT_GS_ONCHIP_CNTL, ARRAY_SIZE(r_028a44_vgt_gs_onchip_cntl__fields), r_028a44_vgt_gs_onchip_cntl__fields},
	{"PA_SC_MODE_CNTL_0", R_028A48_PA_SC_MODE_CNTL_0, ARRAY_SIZE(r_028a48_pa_sc_mode_cntl_0__fields), r_028a48_pa_sc_mode_cntl_0__fields},
	{"PA_SC_MODE_CNTL_1", R_028A4C_PA_SC_MODE_CNTL_1, ARRAY_SIZE(r_028a4c_pa_sc_mode_cntl_1__fields), r_028a4c_pa_sc_mode_cntl_1__fields},
	{"VGT_ENHANCE", R_028A50_VGT_ENHANCE},
	{"VGT_GS_PER_ES", R_028A54_VGT_GS_PER_ES, ARRAY_SIZE(r_028a54_vgt_gs_per_es__fields), r_028a54_vgt_gs_per_es__fields},
	{"VGT_ES_PER_GS", R_028A58_VGT_ES_PER_GS, ARRAY_SIZE(r_028a58_vgt_es_per_gs__fields), r_028a58_vgt_es_per_gs__fields},
	{"VGT_GS_PER_VS", R_028A5C_VGT_GS_PER_VS, ARRAY_SIZE(r_028a5c_vgt_gs_per_vs__fields), r_028a5c_vgt_gs_per_vs__fields},
	{"VGT_GSVS_RING_OFFSET_1", R_028A60_VGT_GSVS_RING_OFFSET_1, ARRAY_SIZE(r_028a60_vgt_gsvs_ring_offset_1__fields), r_028a60_vgt_gsvs_ring_offset_1__fields},
	{"VGT_GSVS_RING_OFFSET_2", R_028A64_VGT_GSVS_RING_OFFSET_2, ARRAY_SIZE(r_028a64_vgt_gsvs_ring_offset_2__fields), r_028a64_vgt_gsvs_ring_offset_2__fields},
	{"VGT_GSVS_RING_OFFSET_3", R_028A68_VGT_GSVS_RING_OFFSET_3, ARRAY_SIZE(r_028a68_vgt_gsvs_ring_offset_3__fields), r_028a68_vgt_gsvs_ring_offset_3__fields},
	{"VGT_GS_OUT_PRIM_TYPE", R_028A6C_VGT_GS_OUT_PRIM_TYPE, ARRAY_SIZE(r_028a6c_vgt_gs_out_prim_type__fields), r_028a6c_vgt_gs_out_prim_type__fields},
	{"IA_ENHANCE", R_028A70_IA_ENHANCE},
	{"VGT_DMA_SIZE", R_028A74_VGT_DMA_SIZE},
	{"VGT_DMA_MAX_SIZE", R_028A78_VGT_DMA_MAX_SIZE},
	{"VGT_DMA_INDEX_TYPE", R_028A7C_VGT_DMA_INDEX_TYPE, ARRAY_SIZE(r_028a7c_vgt_dma_index_type__fields), r_028a7c_vgt_dma_index_type__fields},
	{"WD_ENHANCE", R_028A80_WD_ENHANCE},
	{"VGT_PRIMITIVEID_EN", R_028A84_VGT_PRIMITIVEID_EN, ARRAY_SIZE(r_028a84_vgt_primitiveid_en__fields), r_028a84_vgt_primitiveid_en__fields},
	{"VGT_DMA_NUM_INSTANCES", R_028A88_VGT_DMA_NUM_INSTANCES},
	{"VGT_PRIMITIVEID_RESET", R_028A8C_VGT_PRIMITIVEID_RESET},
	{"VGT_EVENT_INITIATOR", R_028A90_VGT_EVENT_INITIATOR, ARRAY_SIZE(r_028a90_vgt_event_initiator__fields), r_028a90_vgt_event_initiator__fields},
	{"VGT_MULTI_PRIM_IB_RESET_EN", R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, ARRAY_SIZE(r_028a94_vgt_multi_prim_ib_reset_en__fields), r_028a94_vgt_multi_prim_ib_reset_en__fields},
	{"VGT_INSTANCE_STEP_RATE_0", R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{"VGT_INSTANCE_STEP_RATE_1", R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{"IA_MULTI_VGT_PARAM", R_028AA8_IA_MULTI_VGT_PARAM, ARRAY_SIZE(r_028aa8_ia_multi_vgt_param__fields), r_028aa8_ia_multi_vgt_param__fields},
	{"VGT_ESGS_RING_ITEMSIZE", R_028AAC_VGT_ESGS_RING_ITEMSIZE, ARRAY_SIZE(r_028aac_vgt_esgs_ring_itemsize__fields), r_028aac_vgt_esgs_ring_itemsize__fields},
	{"VGT_GSVS_RING_ITEMSIZE", R_028AB0_VGT_GSVS_RING_ITEMSIZE, ARRAY_SIZE(r_028ab0_vgt_gsvs_ring_itemsize__fields), r_028ab0_vgt_gsvs_ring_itemsize__fields},
	{"VGT_REUSE_OFF", R_028AB4_VGT_REUSE_OFF, ARRAY_SIZE(r_028ab4_vgt_reuse_off__fields), r_028ab4_vgt_reuse_off__fields},
	{"VGT_VTX_CNT_EN", R_028AB8_VGT_VTX_CNT_EN, ARRAY_SIZE(r_028ab8_vgt_vtx_cnt_en__fields), r_028ab8_vgt_vtx_cnt_en__fields},
	{"DB_HTILE_SURFACE", R_028ABC_DB_HTILE_SURFACE, ARRAY_SIZE(r_028abc_db_htile_surface__fields), r_028abc_db_htile_surface__fields},
	{"DB_SRESULTS_COMPARE_STATE0", R_028AC0_DB_SRESULTS_COMPARE_STATE0, ARRAY_SIZE(r_028ac0_db_sresults_compare_state0__fields), r_028ac0_db_sresults_compare_state0__fields},
	{"DB_SRESULTS_COMPARE_STATE1", R_028AC4_DB_SRESULTS_COMPARE_STATE1, ARRAY_SIZE(r_028ac4_db_sresults_compare_state1__fields), r_028ac4_db_sresults_compare_state1__fields},
	{"DB_PRELOAD_CONTROL", R_028AC8_DB_PRELOAD_CONTROL, ARRAY_SIZE(r_028ac8_db_preload_control__fields), r_028ac8_db_preload_control__fields},
	{"VGT_STRMOUT_BUFFER_SIZE_0", R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{"VGT_STRMOUT_VTX_STRIDE_0", R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, ARRAY_SIZE(r_028ad4_vgt_strmout_vtx_stride_0__fields), r_028ad4_vgt_strmout_vtx_stride_0__fields},
	{"VGT_STRMOUT_BUFFER_OFFSET_0", R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{"VGT_STRMOUT_BUFFER_SIZE_1", R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{"VGT_STRMOUT_VTX_STRIDE_1", R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, ARRAY_SIZE(r_028ae4_vgt_strmout_vtx_stride_1__fields), r_028ae4_vgt_strmout_vtx_stride_1__fields},
	{"VGT_STRMOUT_BUFFER_OFFSET_1", R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{"VGT_STRMOUT_BUFFER_SIZE_2", R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{"VGT_STRMOUT_VTX_STRIDE_2", R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, ARRAY_SIZE(r_028af4_vgt_strmout_vtx_stride_2__fields), r_028af4_vgt_strmout_vtx_stride_2__fields},
	{"VGT_STRMOUT_BUFFER_OFFSET_2", R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{"VGT_STRMOUT_BUFFER_SIZE_3", R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{"VGT_STRMOUT_VTX_STRIDE_3", R_028B04_VGT_STRMOUT_VTX_STRIDE_3, ARRAY_SIZE(r_028b04_vgt_strmout_vtx_stride_3__fields), r_028b04_vgt_strmout_vtx_stride_3__fields},
	{"VGT_STRMOUT_BUFFER_OFFSET_3", R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{"VGT_STRMOUT_DRAW_OPAQUE_OFFSET", R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE", R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE", R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, ARRAY_SIZE(r_028b30_vgt_strmout_draw_opaque_vertex_stride__fields), r_028b30_vgt_strmout_draw_opaque_vertex_stride__fields},
	{"VGT_GS_MAX_VERT_OUT", R_028B38_VGT_GS_MAX_VERT_OUT, ARRAY_SIZE(r_028b38_vgt_gs_max_vert_out__fields), r_028b38_vgt_gs_max_vert_out__fields},
	{"VGT_TESS_DISTRIBUTION", R_028B50_VGT_TESS_DISTRIBUTION, ARRAY_SIZE(r_028b50_vgt_tess_distribution__fields), r_028b50_vgt_tess_distribution__fields},
	{"VGT_SHADER_STAGES_EN", R_028B54_VGT_SHADER_STAGES_EN, ARRAY_SIZE(r_028b54_vgt_shader_stages_en__fields), r_028b54_vgt_shader_stages_en__fields},
	{"VGT_LS_HS_CONFIG", R_028B58_VGT_LS_HS_CONFIG, ARRAY_SIZE(r_028b58_vgt_ls_hs_config__fields), r_028b58_vgt_ls_hs_config__fields},
	{"VGT_GS_VERT_ITEMSIZE", R_028B5C_VGT_GS_VERT_ITEMSIZE, ARRAY_SIZE(r_028b5c_vgt_gs_vert_itemsize__fields), r_028b5c_vgt_gs_vert_itemsize__fields},
	{"VGT_GS_VERT_ITEMSIZE_1", R_028B60_VGT_GS_VERT_ITEMSIZE_1, ARRAY_SIZE(r_028b60_vgt_gs_vert_itemsize_1__fields), r_028b60_vgt_gs_vert_itemsize_1__fields},
	{"VGT_GS_VERT_ITEMSIZE_2", R_028B64_VGT_GS_VERT_ITEMSIZE_2, ARRAY_SIZE(r_028b64_vgt_gs_vert_itemsize_2__fields), r_028b64_vgt_gs_vert_itemsize_2__fields},
	{"VGT_GS_VERT_ITEMSIZE_3", R_028B68_VGT_GS_VERT_ITEMSIZE_3, ARRAY_SIZE(r_028b68_vgt_gs_vert_itemsize_3__fields), r_028b68_vgt_gs_vert_itemsize_3__fields},
	{"VGT_TF_PARAM", R_028B6C_VGT_TF_PARAM, ARRAY_SIZE(r_028b6c_vgt_tf_param__fields), r_028b6c_vgt_tf_param__fields},
	{"DB_ALPHA_TO_MASK", R_028B70_DB_ALPHA_TO_MASK, ARRAY_SIZE(r_028b70_db_alpha_to_mask__fields), r_028b70_db_alpha_to_mask__fields},
	{"VGT_DISPATCH_DRAW_INDEX", R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{"PA_SU_POLY_OFFSET_DB_FMT_CNTL", R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, ARRAY_SIZE(r_028b78_pa_su_poly_offset_db_fmt_cntl__fields), r_028b78_pa_su_poly_offset_db_fmt_cntl__fields},
	{"PA_SU_POLY_OFFSET_CLAMP", R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{"PA_SU_POLY_OFFSET_FRONT_SCALE", R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{"PA_SU_POLY_OFFSET_FRONT_OFFSET", R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{"PA_SU_POLY_OFFSET_BACK_SCALE", R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{"PA_SU_POLY_OFFSET_BACK_OFFSET", R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{"VGT_GS_INSTANCE_CNT", R_028B90_VGT_GS_INSTANCE_CNT, ARRAY_SIZE(r_028b90_vgt_gs_instance_cnt__fields), r_028b90_vgt_gs_instance_cnt__fields},
	{"VGT_STRMOUT_CONFIG", R_028B94_VGT_STRMOUT_CONFIG, ARRAY_SIZE(r_028b94_vgt_strmout_config__fields), r_028b94_vgt_strmout_config__fields},
	{"VGT_STRMOUT_BUFFER_CONFIG", R_028B98_VGT_STRMOUT_BUFFER_CONFIG, ARRAY_SIZE(r_028b98_vgt_strmout_buffer_config__fields), r_028b98_vgt_strmout_buffer_config__fields},
	{"PA_SC_CENTROID_PRIORITY_0", R_028BD4_PA_SC_CENTROID_PRIORITY_0, ARRAY_SIZE(r_028bd4_pa_sc_centroid_priority_0__fields), r_028bd4_pa_sc_centroid_priority_0__fields},
	{"PA_SC_CENTROID_PRIORITY_1", R_028BD8_PA_SC_CENTROID_PRIORITY_1, ARRAY_SIZE(r_028bd8_pa_sc_centroid_priority_1__fields), r_028bd8_pa_sc_centroid_priority_1__fields},
	{"PA_SC_LINE_CNTL", R_028BDC_PA_SC_LINE_CNTL, ARRAY_SIZE(r_028bdc_pa_sc_line_cntl__fields), r_028bdc_pa_sc_line_cntl__fields},
	{"PA_SC_AA_CONFIG", R_028BE0_PA_SC_AA_CONFIG, ARRAY_SIZE(r_028be0_pa_sc_aa_config__fields), r_028be0_pa_sc_aa_config__fields},
	{"PA_SU_VTX_CNTL", R_028BE4_PA_SU_VTX_CNTL, ARRAY_SIZE(r_028be4_pa_su_vtx_cntl__fields), r_028be4_pa_su_vtx_cntl__fields},
	{"PA_CL_GB_VERT_CLIP_ADJ", R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{"PA_CL_GB_VERT_DISC_ADJ", R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{"PA_CL_GB_HORZ_CLIP_ADJ", R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{"PA_CL_GB_HORZ_DISC_ADJ", R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0", R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, ARRAY_SIZE(r_028bf8_pa_sc_aa_sample_locs_pixel_x0y0_0__fields), r_028bf8_pa_sc_aa_sample_locs_pixel_x0y0_0__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1", R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, ARRAY_SIZE(r_028bfc_pa_sc_aa_sample_locs_pixel_x0y0_1__fields), r_028bfc_pa_sc_aa_sample_locs_pixel_x0y0_1__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2", R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, ARRAY_SIZE(r_028c00_pa_sc_aa_sample_locs_pixel_x0y0_2__fields), r_028c00_pa_sc_aa_sample_locs_pixel_x0y0_2__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3", R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, ARRAY_SIZE(r_028c04_pa_sc_aa_sample_locs_pixel_x0y0_3__fields), r_028c04_pa_sc_aa_sample_locs_pixel_x0y0_3__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0", R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, ARRAY_SIZE(r_028c08_pa_sc_aa_sample_locs_pixel_x1y0_0__fields), r_028c08_pa_sc_aa_sample_locs_pixel_x1y0_0__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1", R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, ARRAY_SIZE(r_028c0c_pa_sc_aa_sample_locs_pixel_x1y0_1__fields), r_028c0c_pa_sc_aa_sample_locs_pixel_x1y0_1__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2", R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, ARRAY_SIZE(r_028c10_pa_sc_aa_sample_locs_pixel_x1y0_2__fields), r_028c10_pa_sc_aa_sample_locs_pixel_x1y0_2__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3", R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, ARRAY_SIZE(r_028c14_pa_sc_aa_sample_locs_pixel_x1y0_3__fields), r_028c14_pa_sc_aa_sample_locs_pixel_x1y0_3__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0", R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, ARRAY_SIZE(r_028c18_pa_sc_aa_sample_locs_pixel_x0y1_0__fields), r_028c18_pa_sc_aa_sample_locs_pixel_x0y1_0__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1", R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, ARRAY_SIZE(r_028c1c_pa_sc_aa_sample_locs_pixel_x0y1_1__fields), r_028c1c_pa_sc_aa_sample_locs_pixel_x0y1_1__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2", R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, ARRAY_SIZE(r_028c20_pa_sc_aa_sample_locs_pixel_x0y1_2__fields), r_028c20_pa_sc_aa_sample_locs_pixel_x0y1_2__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3", R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, ARRAY_SIZE(r_028c24_pa_sc_aa_sample_locs_pixel_x0y1_3__fields), r_028c24_pa_sc_aa_sample_locs_pixel_x0y1_3__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0", R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, ARRAY_SIZE(r_028c28_pa_sc_aa_sample_locs_pixel_x1y1_0__fields), r_028c28_pa_sc_aa_sample_locs_pixel_x1y1_0__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1", R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, ARRAY_SIZE(r_028c2c_pa_sc_aa_sample_locs_pixel_x1y1_1__fields), r_028c2c_pa_sc_aa_sample_locs_pixel_x1y1_1__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2", R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, ARRAY_SIZE(r_028c30_pa_sc_aa_sample_locs_pixel_x1y1_2__fields), r_028c30_pa_sc_aa_sample_locs_pixel_x1y1_2__fields},
	{"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3", R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, ARRAY_SIZE(r_028c34_pa_sc_aa_sample_locs_pixel_x1y1_3__fields), r_028c34_pa_sc_aa_sample_locs_pixel_x1y1_3__fields},
	{"PA_SC_AA_MASK_X0Y0_X1Y0", R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, ARRAY_SIZE(r_028c38_pa_sc_aa_mask_x0y0_x1y0__fields), r_028c38_pa_sc_aa_mask_x0y0_x1y0__fields},
	{"PA_SC_AA_MASK_X0Y1_X1Y1", R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, ARRAY_SIZE(r_028c3c_pa_sc_aa_mask_x0y1_x1y1__fields), r_028c3c_pa_sc_aa_mask_x0y1_x1y1__fields},
	{"PA_SC_SHADER_CONTROL", R_028C40_PA_SC_SHADER_CONTROL, ARRAY_SIZE(r_028c40_pa_sc_shader_control__fields), r_028c40_pa_sc_shader_control__fields},
	{"VGT_VERTEX_REUSE_BLOCK_CNTL", R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, ARRAY_SIZE(r_028c58_vgt_vertex_reuse_block_cntl__fields), r_028c58_vgt_vertex_reuse_block_cntl__fields},
	{"VGT_OUT_DEALLOC_CNTL", R_028C5C_VGT_OUT_DEALLOC_CNTL, ARRAY_SIZE(r_028c5c_vgt_out_dealloc_cntl__fields), r_028c5c_vgt_out_dealloc_cntl__fields},
	{"CB_COLOR0_BASE", R_028C60_CB_COLOR0_BASE},
	{"CB_COLOR0_PITCH", R_028C64_CB_COLOR0_PITCH, ARRAY_SIZE(r_028c64_cb_color0_pitch__fields), r_028c64_cb_color0_pitch__fields},
	{"CB_COLOR0_SLICE", R_028C68_CB_COLOR0_SLICE, ARRAY_SIZE(r_028c68_cb_color0_slice__fields), r_028c68_cb_color0_slice__fields},
	{"CB_COLOR0_VIEW", R_028C6C_CB_COLOR0_VIEW, ARRAY_SIZE(r_028c6c_cb_color0_view__fields), r_028c6c_cb_color0_view__fields},
	{"CB_COLOR0_INFO", R_028C70_CB_COLOR0_INFO, ARRAY_SIZE(r_028c70_cb_color0_info__fields), r_028c70_cb_color0_info__fields},
	{"CB_COLOR0_ATTRIB", R_028C74_CB_COLOR0_ATTRIB, ARRAY_SIZE(r_028c74_cb_color0_attrib__fields), r_028c74_cb_color0_attrib__fields},
	{"CB_COLOR0_DCC_CONTROL", R_028C78_CB_COLOR0_DCC_CONTROL, ARRAY_SIZE(r_028c78_cb_color0_dcc_control__fields), r_028c78_cb_color0_dcc_control__fields},
	{"CB_COLOR0_CMASK", R_028C7C_CB_COLOR0_CMASK},
	{"CB_COLOR0_CMASK_SLICE", R_028C80_CB_COLOR0_CMASK_SLICE, ARRAY_SIZE(r_028c80_cb_color0_cmask_slice__fields), r_028c80_cb_color0_cmask_slice__fields},
	{"CB_COLOR0_FMASK", R_028C84_CB_COLOR0_FMASK},
	{"CB_COLOR0_FMASK_SLICE", R_028C88_CB_COLOR0_FMASK_SLICE, ARRAY_SIZE(r_028c88_cb_color0_fmask_slice__fields), r_028c88_cb_color0_fmask_slice__fields},
	{"CB_COLOR0_CLEAR_WORD0", R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{"CB_COLOR0_CLEAR_WORD1", R_028C90_CB_COLOR0_CLEAR_WORD1},
	{"CB_COLOR0_DCC_BASE", R_028C94_CB_COLOR0_DCC_BASE},
	{"CB_COLOR1_BASE", R_028C9C_CB_COLOR1_BASE},
	{"CB_COLOR1_PITCH", R_028CA0_CB_COLOR1_PITCH, ARRAY_SIZE(r_028c64_cb_color0_pitch__fields), r_028c64_cb_color0_pitch__fields},
	{"CB_COLOR1_SLICE", R_028CA4_CB_COLOR1_SLICE, ARRAY_SIZE(r_028c68_cb_color0_slice__fields), r_028c68_cb_color0_slice__fields},
	{"CB_COLOR1_VIEW", R_028CA8_CB_COLOR1_VIEW, ARRAY_SIZE(r_028c6c_cb_color0_view__fields), r_028c6c_cb_color0_view__fields},
	{"CB_COLOR1_INFO", R_028CAC_CB_COLOR1_INFO, ARRAY_SIZE(r_028c70_cb_color0_info__fields), r_028c70_cb_color0_info__fields},
	{"CB_COLOR1_ATTRIB", R_028CB0_CB_COLOR1_ATTRIB, ARRAY_SIZE(r_028c74_cb_color0_attrib__fields), r_028c74_cb_color0_attrib__fields},
	{"CB_COLOR1_DCC_CONTROL", R_028CB4_CB_COLOR1_DCC_CONTROL, ARRAY_SIZE(r_028c78_cb_color0_dcc_control__fields), r_028c78_cb_color0_dcc_control__fields},
	{"CB_COLOR1_CMASK", R_028CB8_CB_COLOR1_CMASK},
	{"CB_COLOR1_CMASK_SLICE", R_028CBC_CB_COLOR1_CMASK_SLICE, ARRAY_SIZE(r_028c80_cb_color0_cmask_slice__fields), r_028c80_cb_color0_cmask_slice__fields},
	{"CB_COLOR1_FMASK", R_028CC0_CB_COLOR1_FMASK},
	{"CB_COLOR1_FMASK_SLICE", R_028CC4_CB_COLOR1_FMASK_SLICE, ARRAY_SIZE(r_028c88_cb_color0_fmask_slice__fields), r_028c88_cb_color0_fmask_slice__fields},
	{"CB_COLOR1_CLEAR_WORD0", R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{"CB_COLOR1_CLEAR_WORD1", R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{"CB_COLOR1_DCC_BASE", R_028CD0_CB_COLOR1_DCC_BASE},
	{"CB_COLOR2_BASE", R_028CD8_CB_COLOR2_BASE},
	{"CB_COLOR2_PITCH", R_028CDC_CB_COLOR2_PITCH, ARRAY_SIZE(r_028c64_cb_color0_pitch__fields), r_028c64_cb_color0_pitch__fields},
	{"CB_COLOR2_SLICE", R_028CE0_CB_COLOR2_SLICE, ARRAY_SIZE(r_028c68_cb_color0_slice__fields), r_028c68_cb_color0_slice__fields},
	{"CB_COLOR2_VIEW", R_028CE4_CB_COLOR2_VIEW, ARRAY_SIZE(r_028c6c_cb_color0_view__fields), r_028c6c_cb_color0_view__fields},
	{"CB_COLOR2_INFO", R_028CE8_CB_COLOR2_INFO, ARRAY_SIZE(r_028c70_cb_color0_info__fields), r_028c70_cb_color0_info__fields},
	{"CB_COLOR2_ATTRIB", R_028CEC_CB_COLOR2_ATTRIB, ARRAY_SIZE(r_028c74_cb_color0_attrib__fields), r_028c74_cb_color0_attrib__fields},
	{"CB_COLOR2_DCC_CONTROL", R_028CF0_CB_COLOR2_DCC_CONTROL, ARRAY_SIZE(r_028c78_cb_color0_dcc_control__fields), r_028c78_cb_color0_dcc_control__fields},
	{"CB_COLOR2_CMASK", R_028CF4_CB_COLOR2_CMASK},
	{"CB_COLOR2_CMASK_SLICE", R_028CF8_CB_COLOR2_CMASK_SLICE, ARRAY_SIZE(r_028c80_cb_color0_cmask_slice__fields), r_028c80_cb_color0_cmask_slice__fields},
	{"CB_COLOR2_FMASK", R_028CFC_CB_COLOR2_FMASK},
	{"CB_COLOR2_FMASK_SLICE", R_028D00_CB_COLOR2_FMASK_SLICE, ARRAY_SIZE(r_028c88_cb_color0_fmask_slice__fields), r_028c88_cb_color0_fmask_slice__fields},
	{"CB_COLOR2_CLEAR_WORD0", R_028D04_CB_COLOR2_CLEAR_WORD0},
	{"CB_COLOR2_CLEAR_WORD1", R_028D08_CB_COLOR2_CLEAR_WORD1},
	{"CB_COLOR2_DCC_BASE", R_028D0C_CB_COLOR2_DCC_BASE},
	{"CB_COLOR3_BASE", R_028D14_CB_COLOR3_BASE},
	{"CB_COLOR3_PITCH", R_028D18_CB_COLOR3_PITCH, ARRAY_SIZE(r_028c64_cb_color0_pitch__fields), r_028c64_cb_color0_pitch__fields},
	{"CB_COLOR3_SLICE", R_028D1C_CB_COLOR3_SLICE, ARRAY_SIZE(r_028c68_cb_color0_slice__fields), r_028c68_cb_color0_slice__fields},
	{"CB_COLOR3_VIEW", R_028D20_CB_COLOR3_VIEW, ARRAY_SIZE(r_028c6c_cb_color0_view__fields), r_028c6c_cb_color0_view__fields},
	{"CB_COLOR3_INFO", R_028D24_CB_COLOR3_INFO, ARRAY_SIZE(r_028c70_cb_color0_info__fields), r_028c70_cb_color0_info__fields},
	{"CB_COLOR3_ATTRIB", R_028D28_CB_COLOR3_ATTRIB, ARRAY_SIZE(r_028c74_cb_color0_attrib__fields), r_028c74_cb_color0_attrib__fields},
	{"CB_COLOR3_DCC_CONTROL", R_028D2C_CB_COLOR3_DCC_CONTROL, ARRAY_SIZE(r_028c78_cb_color0_dcc_control__fields), r_028c78_cb_color0_dcc_control__fields},
	{"CB_COLOR3_CMASK", R_028D30_CB_COLOR3_CMASK},
	{"CB_COLOR3_CMASK_SLICE", R_028D34_CB_COLOR3_CMASK_SLICE, ARRAY_SIZE(r_028c80_cb_color0_cmask_slice__fields), r_028c80_cb_color0_cmask_slice__fields},
	{"CB_COLOR3_FMASK", R_028D38_CB_COLOR3_FMASK},
	{"CB_COLOR3_FMASK_SLICE", R_028D3C_CB_COLOR3_FMASK_SLICE, ARRAY_SIZE(r_028c88_cb_color0_fmask_slice__fields), r_028c88_cb_color0_fmask_slice__fields},
	{"CB_COLOR3_CLEAR_WORD0", R_028D40_CB_COLOR3_CLEAR_WORD0},
	{"CB_COLOR3_CLEAR_WORD1", R_028D44_CB_COLOR3_CLEAR_WORD1},
	{"CB_COLOR3_DCC_BASE", R_028D48_CB_COLOR3_DCC_BASE},
	{"CB_COLOR4_BASE", R_028D50_CB_COLOR4_BASE},
	{"CB_COLOR4_PITCH", R_028D54_CB_COLOR4_PITCH, ARRAY_SIZE(r_028c64_cb_color0_pitch__fields), r_028c64_cb_color0_pitch__fields},
	{"CB_COLOR4_SLICE", R_028D58_CB_COLOR4_SLICE, ARRAY_SIZE(r_028c68_cb_color0_slice__fields), r_028c68_cb_color0_slice__fields},
	{"CB_COLOR4_VIEW", R_028D5C_CB_COLOR4_VIEW, ARRAY_SIZE(r_028c6c_cb_color0_view__fields), r_028c6c_cb_color0_view__fields},
	{"CB_COLOR4_INFO", R_028D60_CB_COLOR4_INFO, ARRAY_SIZE(r_028c70_cb_color0_info__fields), r_028c70_cb_color0_info__fields},
	{"CB_COLOR4_ATTRIB", R_028D64_CB_COLOR4_ATTRIB, ARRAY_SIZE(r_028c74_cb_color0_attrib__fields), r_028c74_cb_color0_attrib__fields},
	{"CB_COLOR4_DCC_CONTROL", R_028D68_CB_COLOR4_DCC_CONTROL, ARRAY_SIZE(r_028c78_cb_color0_dcc_control__fields), r_028c78_cb_color0_dcc_control__fields},
	{"CB_COLOR4_CMASK", R_028D6C_CB_COLOR4_CMASK},
	{"CB_COLOR4_CMASK_SLICE", R_028D70_CB_COLOR4_CMASK_SLICE, ARRAY_SIZE(r_028c80_cb_color0_cmask_slice__fields), r_028c80_cb_color0_cmask_slice__fields},
	{"CB_COLOR4_FMASK", R_028D74_CB_COLOR4_FMASK},
	{"CB_COLOR4_FMASK_SLICE", R_028D78_CB_COLOR4_FMASK_SLICE, ARRAY_SIZE(r_028c88_cb_color0_fmask_slice__fields), r_028c88_cb_color0_fmask_slice__fields},
	{"CB_COLOR4_CLEAR_WORD0", R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{"CB_COLOR4_CLEAR_WORD1", R_028D80_CB_COLOR4_CLEAR_WORD1},
	{"CB_COLOR4_DCC_BASE", R_028D84_CB_COLOR4_DCC_BASE},
	{"CB_COLOR5_BASE", R_028D8C_CB_COLOR5_BASE},
	{"CB_COLOR5_PITCH", R_028D90_CB_COLOR5_PITCH, ARRAY_SIZE(r_028c64_cb_color0_pitch__fields), r_028c64_cb_color0_pitch__fields},
	{"CB_COLOR5_SLICE", R_028D94_CB_COLOR5_SLICE, ARRAY_SIZE(r_028c68_cb_color0_slice__fields), r_028c68_cb_color0_slice__fields},
	{"CB_COLOR5_VIEW", R_028D98_CB_COLOR5_VIEW, ARRAY_SIZE(r_028c6c_cb_color0_view__fields), r_028c6c_cb_color0_view__fields},
	{"CB_COLOR5_INFO", R_028D9C_CB_COLOR5_INFO, ARRAY_SIZE(r_028c70_cb_color0_info__fields), r_028c70_cb_color0_info__fields},
	{"CB_COLOR5_ATTRIB", R_028DA0_CB_COLOR5_ATTRIB, ARRAY_SIZE(r_028c74_cb_color0_attrib__fields), r_028c74_cb_color0_attrib__fields},
	{"CB_COLOR5_DCC_CONTROL", R_028DA4_CB_COLOR5_DCC_CONTROL, ARRAY_SIZE(r_028c78_cb_color0_dcc_control__fields), r_028c78_cb_color0_dcc_control__fields},
	{"CB_COLOR5_CMASK", R_028DA8_CB_COLOR5_CMASK},
	{"CB_COLOR5_CMASK_SLICE", R_028DAC_CB_COLOR5_CMASK_SLICE, ARRAY_SIZE(r_028c80_cb_color0_cmask_slice__fields), r_028c80_cb_color0_cmask_slice__fields},
	{"CB_COLOR5_FMASK", R_028DB0_CB_COLOR5_FMASK},
	{"CB_COLOR5_FMASK_SLICE", R_028DB4_CB_COLOR5_FMASK_SLICE, ARRAY_SIZE(r_028c88_cb_color0_fmask_slice__fields), r_028c88_cb_color0_fmask_slice__fields},
	{"CB_COLOR5_CLEAR_WORD0", R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{"CB_COLOR5_CLEAR_WORD1", R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{"CB_COLOR5_DCC_BASE", R_028DC0_CB_COLOR5_DCC_BASE},
	{"CB_COLOR6_BASE", R_028DC8_CB_COLOR6_BASE},
	{"CB_COLOR6_PITCH", R_028DCC_CB_COLOR6_PITCH, ARRAY_SIZE(r_028c64_cb_color0_pitch__fields), r_028c64_cb_color0_pitch__fields},
	{"CB_COLOR6_SLICE", R_028DD0_CB_COLOR6_SLICE, ARRAY_SIZE(r_028c68_cb_color0_slice__fields), r_028c68_cb_color0_slice__fields},
	{"CB_COLOR6_VIEW", R_028DD4_CB_COLOR6_VIEW, ARRAY_SIZE(r_028c6c_cb_color0_view__fields), r_028c6c_cb_color0_view__fields},
	{"CB_COLOR6_INFO", R_028DD8_CB_COLOR6_INFO, ARRAY_SIZE(r_028c70_cb_color0_info__fields), r_028c70_cb_color0_info__fields},
	{"CB_COLOR6_ATTRIB", R_028DDC_CB_COLOR6_ATTRIB, ARRAY_SIZE(r_028c74_cb_color0_attrib__fields), r_028c74_cb_color0_attrib__fields},
	{"CB_COLOR6_DCC_CONTROL", R_028DE0_CB_COLOR6_DCC_CONTROL, ARRAY_SIZE(r_028c78_cb_color0_dcc_control__fields), r_028c78_cb_color0_dcc_control__fields},
	{"CB_COLOR6_CMASK", R_028DE4_CB_COLOR6_CMASK},
	{"CB_COLOR6_CMASK_SLICE", R_028DE8_CB_COLOR6_CMASK_SLICE, ARRAY_SIZE(r_028c80_cb_color0_cmask_slice__fields), r_028c80_cb_color0_cmask_slice__fields},
	{"CB_COLOR6_FMASK", R_028DEC_CB_COLOR6_FMASK},
	{"CB_COLOR6_FMASK_SLICE", R_028DF0_CB_COLOR6_FMASK_SLICE, ARRAY_SIZE(r_028c88_cb_color0_fmask_slice__fields), r_028c88_cb_color0_fmask_slice__fields},
	{"CB_COLOR6_CLEAR_WORD0", R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{"CB_COLOR6_CLEAR_WORD1", R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{"CB_COLOR6_DCC_BASE", R_028DFC_CB_COLOR6_DCC_BASE},
	{"CB_COLOR7_BASE", R_028E04_CB_COLOR7_BASE},
	{"CB_COLOR7_PITCH", R_028E08_CB_COLOR7_PITCH, ARRAY_SIZE(r_028c64_cb_color0_pitch__fields), r_028c64_cb_color0_pitch__fields},
	{"CB_COLOR7_SLICE", R_028E0C_CB_COLOR7_SLICE, ARRAY_SIZE(r_028c68_cb_color0_slice__fields), r_028c68_cb_color0_slice__fields},
	{"CB_COLOR7_VIEW", R_028E10_CB_COLOR7_VIEW, ARRAY_SIZE(r_028c6c_cb_color0_view__fields), r_028c6c_cb_color0_view__fields},
	{"CB_COLOR7_INFO", R_028E14_CB_COLOR7_INFO, ARRAY_SIZE(r_028c70_cb_color0_info__fields), r_028c70_cb_color0_info__fields},
	{"CB_COLOR7_ATTRIB", R_028E18_CB_COLOR7_ATTRIB, ARRAY_SIZE(r_028c74_cb_color0_attrib__fields), r_028c74_cb_color0_attrib__fields},
	{"CB_COLOR7_DCC_CONTROL", R_028E1C_CB_COLOR7_DCC_CONTROL, ARRAY_SIZE(r_028c78_cb_color0_dcc_control__fields), r_028c78_cb_color0_dcc_control__fields},
	{"CB_COLOR7_CMASK", R_028E20_CB_COLOR7_CMASK},
	{"CB_COLOR7_CMASK_SLICE", R_028E24_CB_COLOR7_CMASK_SLICE, ARRAY_SIZE(r_028c80_cb_color0_cmask_slice__fields), r_028c80_cb_color0_cmask_slice__fields},
	{"CB_COLOR7_FMASK", R_028E28_CB_COLOR7_FMASK},
	{"CB_COLOR7_FMASK_SLICE", R_028E2C_CB_COLOR7_FMASK_SLICE, ARRAY_SIZE(r_028c88_cb_color0_fmask_slice__fields), r_028c88_cb_color0_fmask_slice__fields},
	{"CB_COLOR7_CLEAR_WORD0", R_028E30_CB_COLOR7_CLEAR_WORD0},
	{"CB_COLOR7_CLEAR_WORD1", R_028E34_CB_COLOR7_CLEAR_WORD1},
	{"CB_COLOR7_DCC_BASE", R_028E38_CB_COLOR7_DCC_BASE},
};

#endif
