/*
 * cve-string.c - string management
 *
 * Copyright (C) 2015 Intel Corporation
 *
 * cve-check-tool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#define _GNU_SOURCE

#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h>

#include "cve-string.h"

cve_string *cve_string_dup(const char *str)
{
        if (!str) {
                return NULL;
        }
        struct cve_string_t *st = calloc(1, sizeof(struct cve_string_t));
        if (!st) {
                return NULL;
        }
        st->len = asprintf(&st->str, "%s", str);
        if (st->len < 0 || !st->str) {
                free(st);
                return NULL;
        }
        return st;
}

cve_string *cve_string_dup_printf(const char *ptn, ...)
{
        if (!ptn) {
                return NULL;
        }

        struct cve_string_t *st = calloc(1, sizeof(struct cve_string_t));
        if (!st) {
                return NULL;
        }

        va_list va;
        va_start(va, ptn);

        st->len = vasprintf(&st->str, ptn, va);
        if (st->len < 0 || !st->str) {
                free(st);
                st = NULL;
                goto end;
        }
end:
        va_end(va);

        return st;
}

bool cve_string_cat(cve_string *s, const char *append)
{
        char *p = NULL;
        int len = 0;

        if (!s || !append) {
                return false;
        }
        if (!s->str) {
                return false;
        }
        len = asprintf(&p, "%s%s", s->str, append);
        if (!p || len < s->len) {
                return false;
        }
        free(s->str);
        s->str = p;
        s->len = len;
        return true;
}

/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=8 tabstop=8 expandtab:
 * :indentSize=8:tabSize=8:noTabs=true:
 */

