/* This file is autogenerated by u_format_table.py from u_format.csv. Do not edit directly. */

/**************************************************************************
 *
 * Copyright 2010 VMware, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **************************************************************************/

#include "u_format.h"
#include "u_format_s3tc.h"
#include "u_format_rgtc.h"
#include "u_format_latc.h"
#include "u_format_etc.h"


#include "pipe/p_compiler.h"
#include "u_math.h"
#include "u_half.h"
#include "u_format.h"
#include "u_format_other.h"
#include "util/format_srgb.h"
#include "u_format_yuv.h"
#include "u_format_zs.h"

union util_format_none {
   uint8_t value;
   struct {
      uint8_t r;
   } chan;
};

static inline void
util_format_none_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_none_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)CLAMP(src[0], 0.0f, 255.0f);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_none_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_none_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_none_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b8g8r8a8_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t a;
#else
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t a;
#endif
   } chan;
};

static inline void
util_format_b8g8r8a8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = value >> 24;
         g = (value >> 16) & 0xff;
         r = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b8g8r8a8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (float_to_ubyte(src[2])) << 24;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 16;
         value |= ((float_to_ubyte(src[0])) & 0xff) << 8;
         value |= (float_to_ubyte(src[3])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (float_to_ubyte(src[2])) & 0xff;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[0])) & 0xff) << 16;
         value |= (float_to_ubyte(src[3])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b8g8r8a8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = value >> 24;
         g = (value >> 16) & 0xff;
         r = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
}

static inline void
util_format_b8g8r8a8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = value >> 24;
         g = (value >> 16) & 0xff;
         r = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b8g8r8a8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (src[2]) << 24;
         value |= ((src[1]) & 0xff) << 16;
         value |= ((src[0]) & 0xff) << 8;
         value |= (src[3]) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (src[2]) & 0xff;
         value |= ((src[1]) & 0xff) << 8;
         value |= ((src[0]) & 0xff) << 16;
         value |= (src[3]) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b8g8r8x8_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t x;
#else
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t x;
#endif
   } chan;
};

static inline void
util_format_b8g8r8x8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = value >> 24;
         g = (value >> 16) & 0xff;
         r = (value >> 8) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b8g8r8x8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (float_to_ubyte(src[2])) << 24;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 16;
         value |= ((float_to_ubyte(src[0])) & 0xff) << 8;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (float_to_ubyte(src[2])) & 0xff;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[0])) & 0xff) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b8g8r8x8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = value >> 24;
         g = (value >> 16) & 0xff;
         r = (value >> 8) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_b8g8r8x8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = value >> 24;
         g = (value >> 16) & 0xff;
         r = (value >> 8) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b8g8r8x8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (src[2]) << 24;
         value |= ((src[1]) & 0xff) << 16;
         value |= ((src[0]) & 0xff) << 8;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (src[2]) & 0xff;
         value |= ((src[1]) & 0xff) << 8;
         value |= ((src[0]) & 0xff) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8r8g8b8_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t a;
      uint8_t r;
      uint8_t g;
      uint8_t b;
#else
      uint8_t a;
      uint8_t r;
      uint8_t g;
      uint8_t b;
#endif
   } chan;
};

static inline void
util_format_a8r8g8b8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 24;
         r = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = (value) & 0xff;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8r8g8b8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (float_to_ubyte(src[3])) << 24;
         value |= ((float_to_ubyte(src[0])) & 0xff) << 16;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 8;
         value |= (float_to_ubyte(src[2])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (float_to_ubyte(src[3])) & 0xff;
         value |= ((float_to_ubyte(src[0])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 16;
         value |= (float_to_ubyte(src[2])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a8r8g8b8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 24;
         r = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = (value) & 0xff;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
}

static inline void
util_format_a8r8g8b8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 24;
         r = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = (value) & 0xff;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8r8g8b8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (src[3]) << 24;
         value |= ((src[0]) & 0xff) << 16;
         value |= ((src[1]) & 0xff) << 8;
         value |= (src[2]) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (src[3]) & 0xff;
         value |= ((src[0]) & 0xff) << 8;
         value |= ((src[1]) & 0xff) << 16;
         value |= (src[2]) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_x8r8g8b8_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t x;
      uint8_t r;
      uint8_t g;
      uint8_t b;
#else
      uint8_t x;
      uint8_t r;
      uint8_t g;
      uint8_t b;
#endif
   } chan;
};

static inline void
util_format_x8r8g8b8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_x8r8g8b8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((float_to_ubyte(src[0])) & 0xff) << 16;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 8;
         value |= (float_to_ubyte(src[2])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((float_to_ubyte(src[0])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 16;
         value |= (float_to_ubyte(src[2])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_x8r8g8b8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_x8r8g8b8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_x8r8g8b8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((src[0]) & 0xff) << 16;
         value |= ((src[1]) & 0xff) << 8;
         value |= (src[2]) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((src[0]) & 0xff) << 8;
         value |= ((src[1]) & 0xff) << 16;
         value |= (src[2]) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8b8g8r8_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t a;
      uint8_t b;
      uint8_t g;
      uint8_t r;
#else
      uint8_t a;
      uint8_t b;
      uint8_t g;
      uint8_t r;
#endif
   } chan;
};

static inline void
util_format_a8b8g8r8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 24;
         b = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = (value) & 0xff;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8b8g8r8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (float_to_ubyte(src[3])) << 24;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 16;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 8;
         value |= (float_to_ubyte(src[0])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (float_to_ubyte(src[3])) & 0xff;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 16;
         value |= (float_to_ubyte(src[0])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a8b8g8r8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 24;
         b = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = (value) & 0xff;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
}

static inline void
util_format_a8b8g8r8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 24;
         b = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = (value) & 0xff;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8b8g8r8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (src[3]) << 24;
         value |= ((src[2]) & 0xff) << 16;
         value |= ((src[1]) & 0xff) << 8;
         value |= (src[0]) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (src[3]) & 0xff;
         value |= ((src[2]) & 0xff) << 8;
         value |= ((src[1]) & 0xff) << 16;
         value |= (src[0]) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_x8b8g8r8_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t x;
      uint8_t b;
      uint8_t g;
      uint8_t r;
#else
      uint8_t x;
      uint8_t b;
      uint8_t g;
      uint8_t r;
#endif
   } chan;
};

static inline void
util_format_x8b8g8r8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_x8b8g8r8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 16;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 8;
         value |= (float_to_ubyte(src[0])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 16;
         value |= (float_to_ubyte(src[0])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_x8b8g8r8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_x8b8g8r8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_x8b8g8r8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((src[2]) & 0xff) << 16;
         value |= ((src[1]) & 0xff) << 8;
         value |= (src[0]) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((src[2]) & 0xff) << 8;
         value |= ((src[1]) & 0xff) << 16;
         value |= (src[0]) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8x8_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t x;
#else
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t x;
#endif
   } chan;
};

static inline void
util_format_r8g8b8x8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8x8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (float_to_ubyte(src[0])) << 24;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 16;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 8;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (float_to_ubyte(src[0])) & 0xff;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8x8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8b8x8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8x8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (src[0]) << 24;
         value |= ((src[1]) & 0xff) << 16;
         value |= ((src[2]) & 0xff) << 8;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (src[0]) & 0xff;
         value |= ((src[1]) & 0xff) << 8;
         value |= ((src[2]) & 0xff) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b5g5r5x1_unorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned x:1;
      unsigned r:5;
      unsigned g:5;
      unsigned b:5;
#else
      unsigned b:5;
      unsigned g:5;
      unsigned r:5;
      unsigned x:1;
#endif
   } chan;
};

static inline void
util_format_b5g5r5x1_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         r = (value >> 10) & 0x1f;
         g = (value >> 5) & 0x1f;
         b = (value) & 0x1f;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x1f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         b = (value) & 0x1f;
         g = (value >> 5) & 0x1f;
         r = (value >> 10) & 0x1f;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x1f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b5g5r5x1_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x1f)) & 0x1f) << 10;
         value |= (((uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x1f)) & 0x1f) << 5;
         value |= ((uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x1f)) & 0x1f;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x1f)) & 0x1f;
         value |= (((uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x1f)) & 0x1f) << 5;
         value |= (((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x1f)) & 0x1f) << 10;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b5g5r5x1_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         r = (value >> 10) & 0x1f;
         g = (value >> 5) & 0x1f;
         b = (value) & 0x1f;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x1f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         b = (value) & 0x1f;
         g = (value >> 5) & 0x1f;
         r = (value >> 10) & 0x1f;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x1f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_b5g5r5x1_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         r = (value >> 10) & 0x1f;
         g = (value >> 5) & 0x1f;
         b = (value) & 0x1f;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0x1f); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0x1f); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x1f); /* b */
         dst[3] = 255; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         b = (value) & 0x1f;
         g = (value >> 5) & 0x1f;
         r = (value >> 10) & 0x1f;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0x1f); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0x1f); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x1f); /* b */
         dst[3] = 255; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b5g5r5x1_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (((uint16_t)(src[0] >> 3)) & 0x1f) << 10;
         value |= (((uint16_t)(src[1] >> 3)) & 0x1f) << 5;
         value |= ((uint16_t)(src[2] >> 3)) & 0x1f;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint16_t)(src[2] >> 3)) & 0x1f;
         value |= (((uint16_t)(src[1] >> 3)) & 0x1f) << 5;
         value |= (((uint16_t)(src[0] >> 3)) & 0x1f) << 10;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b5g5r5a1_unorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned a:1;
      unsigned r:5;
      unsigned g:5;
      unsigned b:5;
#else
      unsigned b:5;
      unsigned g:5;
      unsigned r:5;
      unsigned a:1;
#endif
   } chan;
};

static inline void
util_format_b5g5r5a1_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         a = value >> 15;
         r = (value >> 10) & 0x1f;
         g = (value >> 5) & 0x1f;
         b = (value) & 0x1f;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x1f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         uint16_t a;
         b = (value) & 0x1f;
         g = (value >> 5) & 0x1f;
         r = (value >> 10) & 0x1f;
         a = value >> 15;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x1f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b5g5r5a1_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0x1)) << 15;
         value |= (((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x1f)) & 0x1f) << 10;
         value |= (((uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x1f)) & 0x1f) << 5;
         value |= ((uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x1f)) & 0x1f;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x1f)) & 0x1f;
         value |= (((uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x1f)) & 0x1f) << 5;
         value |= (((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x1f)) & 0x1f) << 10;
         value |= ((uint16_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0x1)) << 15;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b5g5r5a1_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         a = value >> 15;
         r = (value >> 10) & 0x1f;
         g = (value >> 5) & 0x1f;
         b = (value) & 0x1f;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x1f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         uint16_t a;
         b = (value) & 0x1f;
         g = (value >> 5) & 0x1f;
         r = (value >> 10) & 0x1f;
         a = value >> 15;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x1f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
#endif
}

static inline void
util_format_b5g5r5a1_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         a = value >> 15;
         r = (value >> 10) & 0x1f;
         g = (value >> 5) & 0x1f;
         b = (value) & 0x1f;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0x1f); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0x1f); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x1f); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0x1); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         uint16_t a;
         b = (value) & 0x1f;
         g = (value >> 5) & 0x1f;
         r = (value >> 10) & 0x1f;
         a = value >> 15;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0x1f); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0x1f); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x1f); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0x1); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b5g5r5a1_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint16_t)(src[3] >> 7)) << 15;
         value |= (((uint16_t)(src[0] >> 3)) & 0x1f) << 10;
         value |= (((uint16_t)(src[1] >> 3)) & 0x1f) << 5;
         value |= ((uint16_t)(src[2] >> 3)) & 0x1f;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint16_t)(src[2] >> 3)) & 0x1f;
         value |= (((uint16_t)(src[1] >> 3)) & 0x1f) << 5;
         value |= (((uint16_t)(src[0] >> 3)) & 0x1f) << 10;
         value |= ((uint16_t)(src[3] >> 7)) << 15;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b4g4r4a4_unorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned a:4;
      unsigned r:4;
      unsigned g:4;
      unsigned b:4;
#else
      unsigned b:4;
      unsigned g:4;
      unsigned r:4;
      unsigned a:4;
#endif
   } chan;
};

static inline void
util_format_b4g4r4a4_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         a = value >> 12;
         r = (value >> 8) & 0xf;
         g = (value >> 4) & 0xf;
         b = (value) & 0xf;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0xf)); /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         uint16_t a;
         b = (value) & 0xf;
         g = (value >> 4) & 0xf;
         r = (value >> 8) & 0xf;
         a = value >> 12;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0xf)); /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b4g4r4a4_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xf)) << 12;
         value |= (((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xf)) & 0xf) << 8;
         value |= (((uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0xf)) & 0xf) << 4;
         value |= ((uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0xf)) & 0xf;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0xf)) & 0xf;
         value |= (((uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0xf)) & 0xf) << 4;
         value |= (((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xf)) & 0xf) << 8;
         value |= ((uint16_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xf)) << 12;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b4g4r4a4_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         a = value >> 12;
         r = (value >> 8) & 0xf;
         g = (value >> 4) & 0xf;
         b = (value) & 0xf;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0xf)); /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         uint16_t a;
         b = (value) & 0xf;
         g = (value >> 4) & 0xf;
         r = (value >> 8) & 0xf;
         a = value >> 12;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0xf)); /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#endif
}

static inline void
util_format_b4g4r4a4_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         a = value >> 12;
         r = (value >> 8) & 0xf;
         g = (value >> 4) & 0xf;
         b = (value) & 0xf;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0xf); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0xf); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0xf); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0xf); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         uint16_t a;
         b = (value) & 0xf;
         g = (value >> 4) & 0xf;
         r = (value >> 8) & 0xf;
         a = value >> 12;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0xf); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0xf); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0xf); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0xf); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b4g4r4a4_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint16_t)(src[3] >> 4)) << 12;
         value |= (((uint16_t)(src[0] >> 4)) & 0xf) << 8;
         value |= (((uint16_t)(src[1] >> 4)) & 0xf) << 4;
         value |= ((uint16_t)(src[2] >> 4)) & 0xf;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint16_t)(src[2] >> 4)) & 0xf;
         value |= (((uint16_t)(src[1] >> 4)) & 0xf) << 4;
         value |= (((uint16_t)(src[0] >> 4)) & 0xf) << 8;
         value |= ((uint16_t)(src[3] >> 4)) << 12;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b4g4r4x4_unorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned x:4;
      unsigned r:4;
      unsigned g:4;
      unsigned b:4;
#else
      unsigned b:4;
      unsigned g:4;
      unsigned r:4;
      unsigned x:4;
#endif
   } chan;
};

static inline void
util_format_b4g4r4x4_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         r = (value >> 8) & 0xf;
         g = (value >> 4) & 0xf;
         b = (value) & 0xf;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0xf)); /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         b = (value) & 0xf;
         g = (value >> 4) & 0xf;
         r = (value >> 8) & 0xf;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0xf)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b4g4r4x4_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xf)) & 0xf) << 8;
         value |= (((uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0xf)) & 0xf) << 4;
         value |= ((uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0xf)) & 0xf;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0xf)) & 0xf;
         value |= (((uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0xf)) & 0xf) << 4;
         value |= (((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xf)) & 0xf) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b4g4r4x4_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         r = (value >> 8) & 0xf;
         g = (value >> 4) & 0xf;
         b = (value) & 0xf;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0xf)); /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         b = (value) & 0xf;
         g = (value >> 4) & 0xf;
         r = (value >> 8) & 0xf;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0xf)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_b4g4r4x4_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         r = (value >> 8) & 0xf;
         g = (value >> 4) & 0xf;
         b = (value) & 0xf;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0xf); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0xf); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0xf); /* b */
         dst[3] = 255; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         b = (value) & 0xf;
         g = (value >> 4) & 0xf;
         r = (value >> 8) & 0xf;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0xf); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0xf); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0xf); /* b */
         dst[3] = 255; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b4g4r4x4_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (((uint16_t)(src[0] >> 4)) & 0xf) << 8;
         value |= (((uint16_t)(src[1] >> 4)) & 0xf) << 4;
         value |= ((uint16_t)(src[2] >> 4)) & 0xf;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint16_t)(src[2] >> 4)) & 0xf;
         value |= (((uint16_t)(src[1] >> 4)) & 0xf) << 4;
         value |= (((uint16_t)(src[0] >> 4)) & 0xf) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b5g6r5_unorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned r:5;
      unsigned g:6;
      unsigned b:5;
#else
      unsigned b:5;
      unsigned g:6;
      unsigned r:5;
#endif
   } chan;
};

static inline void
util_format_b5g6r5_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         r = value >> 11;
         g = (value >> 5) & 0x3f;
         b = (value) & 0x1f;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x3f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         b = (value) & 0x1f;
         g = (value >> 5) & 0x3f;
         r = value >> 11;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x3f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b5g6r5_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x1f)) << 11;
         value |= (((uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x3f)) & 0x3f) << 5;
         value |= ((uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x1f)) & 0x1f;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x1f)) & 0x1f;
         value |= (((uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x3f)) & 0x3f) << 5;
         value |= ((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x1f)) << 11;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b5g6r5_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         r = value >> 11;
         g = (value >> 5) & 0x3f;
         b = (value) & 0x1f;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x3f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         b = (value) & 0x1f;
         g = (value >> 5) & 0x3f;
         r = value >> 11;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x3f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_b5g6r5_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         r = value >> 11;
         g = (value >> 5) & 0x3f;
         b = (value) & 0x1f;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0x1f); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0x3f); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x1f); /* b */
         dst[3] = 255; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         b = (value) & 0x1f;
         g = (value >> 5) & 0x3f;
         r = value >> 11;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0x1f); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0x3f); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x1f); /* b */
         dst[3] = 255; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b5g6r5_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint16_t)(src[0] >> 3)) << 11;
         value |= (((uint16_t)(src[1] >> 2)) & 0x3f) << 5;
         value |= ((uint16_t)(src[2] >> 3)) & 0x1f;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint16_t)(src[2] >> 3)) & 0x1f;
         value |= (((uint16_t)(src[1] >> 2)) & 0x3f) << 5;
         value |= ((uint16_t)(src[0] >> 3)) << 11;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10g10b10a2_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned a:2;
      unsigned b:10;
      unsigned g:10;
      unsigned r:10;
#else
      unsigned r:10;
      unsigned g:10;
      unsigned b:10;
      unsigned a:2;
#endif
   } chan;
};

static inline void
util_format_r10g10b10a2_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 30;
         b = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value) & 0x3ff;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10a2_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0x3)) << 30;
         value |= (((uint32_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x3ff)) & 0x3ff) << 20;
         value |= (((uint32_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x3ff)) & 0x3ff) << 10;
         value |= ((uint32_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x3ff)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x3ff)) & 0x3ff;
         value |= (((uint32_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x3ff)) & 0x3ff) << 10;
         value |= (((uint32_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x3ff)) & 0x3ff) << 20;
         value |= ((uint32_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0x3)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r10g10b10a2_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 30;
         b = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value) & 0x3ff;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
#endif
}

static inline void
util_format_r10g10b10a2_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 30;
         b = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value) & 0x3ff;
         dst[0] = (uint8_t)(r >> 2); /* r */
         dst[1] = (uint8_t)(g >> 2); /* g */
         dst[2] = (uint8_t)(b >> 2); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0x3); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (uint8_t)(r >> 2); /* r */
         dst[1] = (uint8_t)(g >> 2); /* g */
         dst[2] = (uint8_t)(b >> 2); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0x3); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10a2_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)(src[3] >> 6)) << 30;
         value |= (((uint32_t)(((uint32_t)src[2]) * 0x3ff / 0xff)) & 0x3ff) << 20;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x3ff / 0xff)) & 0x3ff) << 10;
         value |= ((uint32_t)(((uint32_t)src[0]) * 0x3ff / 0xff)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)(((uint32_t)src[0]) * 0x3ff / 0xff)) & 0x3ff;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x3ff / 0xff)) & 0x3ff) << 10;
         value |= (((uint32_t)(((uint32_t)src[2]) * 0x3ff / 0xff)) & 0x3ff) << 20;
         value |= ((uint32_t)(src[3] >> 6)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b10g10r10a2_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned a:2;
      unsigned r:10;
      unsigned g:10;
      unsigned b:10;
#else
      unsigned b:10;
      unsigned g:10;
      unsigned r:10;
      unsigned a:2;
#endif
   } chan;
};

static inline void
util_format_b10g10r10a2_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 30;
         r = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value) & 0x3ff;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b10g10r10a2_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0x3)) << 30;
         value |= (((uint32_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x3ff)) & 0x3ff) << 20;
         value |= (((uint32_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x3ff)) & 0x3ff) << 10;
         value |= ((uint32_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x3ff)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x3ff)) & 0x3ff;
         value |= (((uint32_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x3ff)) & 0x3ff) << 10;
         value |= (((uint32_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x3ff)) & 0x3ff) << 20;
         value |= ((uint32_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0x3)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b10g10r10a2_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 30;
         r = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value) & 0x3ff;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
#endif
}

static inline void
util_format_b10g10r10a2_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 30;
         r = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value) & 0x3ff;
         dst[0] = (uint8_t)(r >> 2); /* r */
         dst[1] = (uint8_t)(g >> 2); /* g */
         dst[2] = (uint8_t)(b >> 2); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0x3); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (uint8_t)(r >> 2); /* r */
         dst[1] = (uint8_t)(g >> 2); /* g */
         dst[2] = (uint8_t)(b >> 2); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0x3); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b10g10r10a2_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)(src[3] >> 6)) << 30;
         value |= (((uint32_t)(((uint32_t)src[0]) * 0x3ff / 0xff)) & 0x3ff) << 20;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x3ff / 0xff)) & 0x3ff) << 10;
         value |= ((uint32_t)(((uint32_t)src[2]) * 0x3ff / 0xff)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)(((uint32_t)src[2]) * 0x3ff / 0xff)) & 0x3ff;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x3ff / 0xff)) & 0x3ff) << 10;
         value |= (((uint32_t)(((uint32_t)src[0]) * 0x3ff / 0xff)) & 0x3ff) << 20;
         value |= ((uint32_t)(src[3] >> 6)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b2g3r3_unorm {
   uint8_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned r:3;
      unsigned g:3;
      unsigned b:2;
#else
      unsigned b:2;
      unsigned g:3;
      unsigned r:3;
#endif
   } chan;
};

static inline void
util_format_b2g3r3_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         uint8_t g;
         uint8_t b;
         r = value >> 5;
         g = (value >> 2) & 0x7;
         b = (value) & 0x3;
         dst[0] = (float)(r * (1.0f/0x7)); /* r */
         dst[1] = (float)(g * (1.0f/0x7)); /* g */
         dst[2] = (float)(b * (1.0f/0x3)); /* b */
         dst[3] = 1; /* a */
#else
         uint8_t value = *(const uint8_t *)src;
         uint8_t b;
         uint8_t g;
         uint8_t r;
         b = (value) & 0x3;
         g = (value >> 2) & 0x7;
         r = value >> 5;
         dst[0] = (float)(r * (1.0f/0x7)); /* r */
         dst[1] = (float)(g * (1.0f/0x7)); /* g */
         dst[2] = (float)(b * (1.0f/0x3)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b2g3r3_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = 0;
         value |= ((uint8_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x7)) << 5;
         value |= (((uint8_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x7)) & 0x7) << 2;
         value |= ((uint8_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x3)) & 0x3;
         *(uint8_t *)dst = value;
#else
         uint8_t value = 0;
         value |= ((uint8_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x3)) & 0x3;
         value |= (((uint8_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x7)) & 0x7) << 2;
         value |= ((uint8_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x7)) << 5;
         *(uint8_t *)dst = value;
#endif
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b2g3r3_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         uint8_t g;
         uint8_t b;
         r = value >> 5;
         g = (value >> 2) & 0x7;
         b = (value) & 0x3;
         dst[0] = (float)(r * (1.0f/0x7)); /* r */
         dst[1] = (float)(g * (1.0f/0x7)); /* g */
         dst[2] = (float)(b * (1.0f/0x3)); /* b */
         dst[3] = 1; /* a */
#else
         uint8_t value = *(const uint8_t *)src;
         uint8_t b;
         uint8_t g;
         uint8_t r;
         b = (value) & 0x3;
         g = (value >> 2) & 0x7;
         r = value >> 5;
         dst[0] = (float)(r * (1.0f/0x7)); /* r */
         dst[1] = (float)(g * (1.0f/0x7)); /* g */
         dst[2] = (float)(b * (1.0f/0x3)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_b2g3r3_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         uint8_t g;
         uint8_t b;
         r = value >> 5;
         g = (value >> 2) & 0x7;
         b = (value) & 0x3;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0x7); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0x7); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x3); /* b */
         dst[3] = 255; /* a */
#else
         uint8_t value = *(const uint8_t *)src;
         uint8_t b;
         uint8_t g;
         uint8_t r;
         b = (value) & 0x3;
         g = (value >> 2) & 0x7;
         r = value >> 5;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0x7); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0x7); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x3); /* b */
         dst[3] = 255; /* a */
#endif
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b2g3r3_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = 0;
         value |= ((uint8_t)(src[0] >> 5)) << 5;
         value |= (((uint8_t)(src[1] >> 5)) & 0x7) << 2;
         value |= ((uint8_t)(src[2] >> 6)) & 0x3;
         *(uint8_t *)dst = value;
#else
         uint8_t value = 0;
         value |= ((uint8_t)(src[2] >> 6)) & 0x3;
         value |= (((uint8_t)(src[1] >> 5)) & 0x7) << 2;
         value |= ((uint8_t)(src[0] >> 5)) << 5;
         *(uint8_t *)dst = value;
#endif
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8_unorm {
   uint8_t value;
   struct {
      uint8_t rgb;
   } chan;
};

static inline void
util_format_l8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = ubyte_to_float(rgb); /* r */
         dst[1] = ubyte_to_float(rgb); /* g */
         dst[2] = ubyte_to_float(rgb); /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= float_to_ubyte(src[0]);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = ubyte_to_float(rgb); /* r */
         dst[1] = ubyte_to_float(rgb); /* g */
         dst[2] = ubyte_to_float(rgb); /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = rgb; /* r */
         dst[1] = rgb; /* g */
         dst[2] = rgb; /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= src[0];
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8_unorm {
   uint8_t value;
   struct {
      uint8_t a;
   } chan;
};

static inline void
util_format_a8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = ubyte_to_float(a); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= float_to_ubyte(src[3]);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = ubyte_to_float(a); /* a */
}

static inline void
util_format_a8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = a; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= src[3];
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i8_unorm {
   uint8_t value;
   struct {
      uint8_t rgba;
   } chan;
};

static inline void
util_format_i8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgba;
         rgba = value;
         dst[0] = ubyte_to_float(rgba); /* r */
         dst[1] = ubyte_to_float(rgba); /* g */
         dst[2] = ubyte_to_float(rgba); /* b */
         dst[3] = ubyte_to_float(rgba); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= float_to_ubyte(src[0]);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_i8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgba;
         rgba = value;
         dst[0] = ubyte_to_float(rgba); /* r */
         dst[1] = ubyte_to_float(rgba); /* g */
         dst[2] = ubyte_to_float(rgba); /* b */
         dst[3] = ubyte_to_float(rgba); /* a */
}

static inline void
util_format_i8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgba;
         rgba = value;
         dst[0] = rgba; /* r */
         dst[1] = rgba; /* g */
         dst[2] = rgba; /* b */
         dst[3] = rgba; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= src[0];
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l4a4_unorm {
   uint8_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned a:4;
      unsigned rgb:4;
#else
      unsigned rgb:4;
      unsigned a:4;
#endif
   } chan;
};

static inline void
util_format_l4a4_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         uint8_t rgb;
         a = value >> 4;
         rgb = (value) & 0xf;
         dst[0] = (float)(rgb * (1.0f/0xf)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xf)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xf)); /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#else
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         uint8_t a;
         rgb = (value) & 0xf;
         a = value >> 4;
         dst[0] = (float)(rgb * (1.0f/0xf)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xf)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xf)); /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#endif
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l4a4_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = 0;
         value |= ((uint8_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xf)) << 4;
         value |= ((uint8_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xf)) & 0xf;
         *(uint8_t *)dst = value;
#else
         uint8_t value = 0;
         value |= ((uint8_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xf)) & 0xf;
         value |= ((uint8_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xf)) << 4;
         *(uint8_t *)dst = value;
#endif
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l4a4_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         uint8_t rgb;
         a = value >> 4;
         rgb = (value) & 0xf;
         dst[0] = (float)(rgb * (1.0f/0xf)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xf)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xf)); /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#else
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         uint8_t a;
         rgb = (value) & 0xf;
         a = value >> 4;
         dst[0] = (float)(rgb * (1.0f/0xf)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xf)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xf)); /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#endif
}

static inline void
util_format_l4a4_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         uint8_t rgb;
         a = value >> 4;
         rgb = (value) & 0xf;
         dst[0] = (uint8_t)(((uint32_t)rgb) * 0xff / 0xf); /* r */
         dst[1] = (uint8_t)(((uint32_t)rgb) * 0xff / 0xf); /* g */
         dst[2] = (uint8_t)(((uint32_t)rgb) * 0xff / 0xf); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0xf); /* a */
#else
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         uint8_t a;
         rgb = (value) & 0xf;
         a = value >> 4;
         dst[0] = (uint8_t)(((uint32_t)rgb) * 0xff / 0xf); /* r */
         dst[1] = (uint8_t)(((uint32_t)rgb) * 0xff / 0xf); /* g */
         dst[2] = (uint8_t)(((uint32_t)rgb) * 0xff / 0xf); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0xf); /* a */
#endif
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l4a4_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = 0;
         value |= ((uint8_t)(src[3] >> 4)) << 4;
         value |= ((uint8_t)(src[0] >> 4)) & 0xf;
         *(uint8_t *)dst = value;
#else
         uint8_t value = 0;
         value |= ((uint8_t)(src[0] >> 4)) & 0xf;
         value |= ((uint8_t)(src[3] >> 4)) << 4;
         *(uint8_t *)dst = value;
#endif
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8a8_unorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t rgb;
      uint8_t a;
#else
      uint8_t rgb;
      uint8_t a;
#endif
   } chan;
};

static inline void
util_format_l8a8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = value >> 8;
         a = (value) & 0xff;
         dst[0] = ubyte_to_float(rgb); /* r */
         dst[1] = ubyte_to_float(rgb); /* g */
         dst[2] = ubyte_to_float(rgb); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = ubyte_to_float(rgb); /* r */
         dst[1] = ubyte_to_float(rgb); /* g */
         dst[2] = ubyte_to_float(rgb); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8a8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (float_to_ubyte(src[0])) << 8;
         value |= (float_to_ubyte(src[3])) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (float_to_ubyte(src[0])) & 0xff;
         value |= (float_to_ubyte(src[3])) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l8a8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = value >> 8;
         a = (value) & 0xff;
         dst[0] = ubyte_to_float(rgb); /* r */
         dst[1] = ubyte_to_float(rgb); /* g */
         dst[2] = ubyte_to_float(rgb); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = ubyte_to_float(rgb); /* r */
         dst[1] = ubyte_to_float(rgb); /* g */
         dst[2] = ubyte_to_float(rgb); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
}

static inline void
util_format_l8a8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = value >> 8;
         a = (value) & 0xff;
         dst[0] = rgb; /* r */
         dst[1] = rgb; /* g */
         dst[2] = rgb; /* b */
         dst[3] = a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = rgb; /* r */
         dst[1] = rgb; /* g */
         dst[2] = rgb; /* b */
         dst[3] = a; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8a8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (src[0]) << 8;
         value |= (src[3]) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (src[0]) & 0xff;
         value |= (src[3]) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16_unorm {
   uint16_t value;
   struct {
      uint16_t rgb;
   } chan;
};

static inline void
util_format_l16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         rgb = value;
         dst[0] = (float)(rgb * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         rgb = value;
         dst[0] = (float)(rgb * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         rgb = value;
         dst[0] = (uint8_t)(rgb >> 8); /* r */
         dst[1] = (uint8_t)(rgb >> 8); /* g */
         dst[2] = (uint8_t)(rgb >> 8); /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a16_unorm {
   uint16_t value;
   struct {
      uint16_t a;
   } chan;
};

static inline void
util_format_a16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xffff);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
}

static inline void
util_format_a16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(a >> 8); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((uint32_t)src[3]) * 0xffff / 0xff);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i16_unorm {
   uint16_t value;
   struct {
      uint16_t rgba;
   } chan;
};

static inline void
util_format_i16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgba;
         rgba = value;
         dst[0] = (float)(rgba * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgba * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgba * (1.0f/0xffff)); /* b */
         dst[3] = (float)(rgba * (1.0f/0xffff)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_i16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgba;
         rgba = value;
         dst[0] = (float)(rgba * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgba * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgba * (1.0f/0xffff)); /* b */
         dst[3] = (float)(rgba * (1.0f/0xffff)); /* a */
}

static inline void
util_format_i16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgba;
         rgba = value;
         dst[0] = (uint8_t)(rgba >> 8); /* r */
         dst[1] = (uint8_t)(rgba >> 8); /* g */
         dst[2] = (uint8_t)(rgba >> 8); /* b */
         dst[3] = (uint8_t)(rgba >> 8); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16a16_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t rgb;
      uint16_t a;
#else
      uint16_t rgb;
      uint16_t a;
#endif
   } chan;
};

static inline void
util_format_l16a16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
         rgb = value >> 16;
         a = (value) & 0xffff;
         dst[0] = (float)(rgb * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xffff)); /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
         rgb = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (float)(rgb * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xffff)); /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16a16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff)) << 16;
         value |= ((uint16_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xffff)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff)) & 0xffff;
         value |= ((uint16_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xffff)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l16a16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
         rgb = value >> 16;
         a = (value) & 0xffff;
         dst[0] = (float)(rgb * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xffff)); /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
         rgb = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (float)(rgb * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xffff)); /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
#endif
}

static inline void
util_format_l16a16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
         rgb = value >> 16;
         a = (value) & 0xffff;
         dst[0] = (uint8_t)(rgb >> 8); /* r */
         dst[1] = (uint8_t)(rgb >> 8); /* g */
         dst[2] = (uint8_t)(rgb >> 8); /* b */
         dst[3] = (uint8_t)(a >> 8); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
         rgb = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (uint8_t)(rgb >> 8); /* r */
         dst[1] = (uint8_t)(rgb >> 8); /* g */
         dst[2] = (uint8_t)(rgb >> 8); /* b */
         dst[3] = (uint8_t)(a >> 8); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16a16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff)) << 16;
         value |= ((uint16_t)(((uint32_t)src[3]) * 0xffff / 0xff)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff)) & 0xffff;
         value |= ((uint16_t)(((uint32_t)src[3]) * 0xffff / 0xff)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8_snorm {
   uint8_t value;
   struct {
      int8_t a;
   } chan;
};

static inline void
util_format_a8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t a;
         a = (int8_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7f)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t a;
         a = (int8_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
}

static inline void
util_format_a8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t a;
         a = (int8_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x7f); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(src[3] >> 1)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8_snorm {
   uint8_t value;
   struct {
      int8_t rgb;
   } chan;
};

static inline void
util_format_l8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t rgb;
         rgb = (int8_t)(value) ;
         dst[0] = (float)(rgb * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t rgb;
         rgb = (int8_t)(value) ;
         dst[0] = (float)(rgb * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t rgb;
         rgb = (int8_t)(value) ;
         dst[0] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(src[0] >> 1)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8a8_snorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t rgb;
      int8_t a;
#else
      int8_t rgb;
      int8_t a;
#endif
   } chan;
};

static inline void
util_format_l8a8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
         rgb = ((int16_t)(value) ) >> 8;
         a = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (float)(rgb * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7f)); /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
         rgb = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (float)(rgb * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7f)); /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8a8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) << 8) ;
         value |= (uint16_t)(((int8_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7f)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) & 0xff) ;
         value |= (uint16_t)(((int8_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7f)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l8a8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
         rgb = ((int16_t)(value) ) >> 8;
         a = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (float)(rgb * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7f)); /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
         rgb = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (float)(rgb * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7f)); /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
#endif
}

static inline void
util_format_l8a8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
         rgb = ((int16_t)(value) ) >> 8;
         a = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x7f); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
         rgb = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x7f); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8a8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(src[0] >> 1)) << 8) ;
         value |= (uint16_t)(((int8_t)(src[3] >> 1)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(src[0] >> 1)) & 0xff) ;
         value |= (uint16_t)(((int8_t)(src[3] >> 1)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i8_snorm {
   uint8_t value;
   struct {
      int8_t rgba;
   } chan;
};

static inline void
util_format_i8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t rgba;
         rgba = (int8_t)(value) ;
         dst[0] = (float)(rgba * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgba * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgba * (1.0f/0x7f)); /* b */
         dst[3] = (float)(rgba * (1.0f/0x7f)); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_i8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t rgba;
         rgba = (int8_t)(value) ;
         dst[0] = (float)(rgba * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgba * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgba * (1.0f/0x7f)); /* b */
         dst[3] = (float)(rgba * (1.0f/0x7f)); /* a */
}

static inline void
util_format_i8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t rgba;
         rgba = (int8_t)(value) ;
         dst[0] = (uint8_t)(((uint32_t)MAX2(rgba, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(rgba, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(rgba, 0)) * 0xff / 0x7f); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(rgba, 0)) * 0xff / 0x7f); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(src[0] >> 1)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a16_snorm {
   uint16_t value;
   struct {
      int16_t a;
   } chan;
};

static inline void
util_format_a16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t a;
         a = (int16_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7fff)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t a;
         a = (int16_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
}

static inline void
util_format_a16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t a;
         a = (int16_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(MAX2(a, 0) >> 7); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(((uint32_t)src[3]) * 0x7fff / 0xff)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16_snorm {
   uint16_t value;
   struct {
      int16_t rgb;
   } chan;
};

static inline void
util_format_l16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         rgb = (int16_t)(value) ;
         dst[0] = (float)(rgb * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         rgb = (int16_t)(value) ;
         dst[0] = (float)(rgb * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         rgb = (int16_t)(value) ;
         dst[0] = (uint8_t)(MAX2(rgb, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(rgb, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(rgb, 0) >> 7); /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16a16_snorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t rgb;
      int16_t a;
#else
      int16_t rgb;
      int16_t a;
#endif
   } chan;
};

static inline void
util_format_l16a16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
         rgb = ((int32_t)(value) ) >> 16;
         a = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (float)(rgb * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
         rgb = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (float)(rgb * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16a16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff)) << 16) ;
         value |= (uint32_t)(((int16_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7fff)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7fff)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l16a16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
         rgb = ((int32_t)(value) ) >> 16;
         a = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (float)(rgb * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
         rgb = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (float)(rgb * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
#endif
}

static inline void
util_format_l16a16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
         rgb = ((int32_t)(value) ) >> 16;
         a = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (uint8_t)(MAX2(rgb, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(rgb, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(rgb, 0) >> 7); /* b */
         dst[3] = (uint8_t)(MAX2(a, 0) >> 7); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
         rgb = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (uint8_t)(MAX2(rgb, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(rgb, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(rgb, 0) >> 7); /* b */
         dst[3] = (uint8_t)(MAX2(a, 0) >> 7); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16a16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff)) << 16) ;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[3]) * 0x7fff / 0xff)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[3]) * 0x7fff / 0xff)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i16_snorm {
   uint16_t value;
   struct {
      int16_t rgba;
   } chan;
};

static inline void
util_format_i16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgba;
         rgba = (int16_t)(value) ;
         dst[0] = (float)(rgba * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgba * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgba * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(rgba * (1.0f/0x7fff)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_i16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t rgba;
         rgba = (int16_t)(value) ;
         dst[0] = (float)(rgba * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgba * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgba * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(rgba * (1.0f/0x7fff)); /* a */
}

static inline void
util_format_i16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgba;
         rgba = (int16_t)(value) ;
         dst[0] = (uint8_t)(MAX2(rgba, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(rgba, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(rgba, 0) >> 7); /* b */
         dst[3] = (uint8_t)(MAX2(rgba, 0) >> 7); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a16_float {
   uint16_t value;
   struct {
      uint16_t a;
   } chan;
};

static inline void
util_format_a16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a16_float pixel;
         pixel.chan.a = util_float_to_half(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
}

static inline void
util_format_a16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = float_to_ubyte(util_half_to_float(pixel.chan.a)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a16_float pixel;
         pixel.chan.a = util_float_to_half((float)(src[3] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16_float {
   uint16_t value;
   struct {
      uint16_t rgb;
   } chan;
};

static inline void
util_format_l16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgb); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgb); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgb); /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l16_float pixel;
         pixel.chan.rgb = util_float_to_half(src[0]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_l16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgb); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgb); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgb); /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l16_float pixel;
         pixel.chan.rgb = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16a16_float {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t rgb;
      uint16_t a;
#else
      uint16_t rgb;
      uint16_t a;
#endif
   } chan;
};

static inline void
util_format_l16a16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgb); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgb); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgb); /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
#else
         union util_format_l16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgb); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgb); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgb); /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16a16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l16a16_float pixel;
         pixel.chan.rgb = util_float_to_half(src[0]);
         pixel.chan.a = util_float_to_half(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_l16a16_float pixel;
         pixel.chan.rgb = util_float_to_half(src[0]);
         pixel.chan.a = util_float_to_half(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l16a16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgb); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgb); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgb); /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
#else
         union util_format_l16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgb); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgb); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgb); /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
#endif
}

static inline void
util_format_l16a16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* b */
         dst[3] = float_to_ubyte(util_half_to_float(pixel.chan.a)); /* a */
#else
         union util_format_l16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* b */
         dst[3] = float_to_ubyte(util_half_to_float(pixel.chan.a)); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16a16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l16a16_float pixel;
         pixel.chan.rgb = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.a = util_float_to_half((float)(src[3] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_l16a16_float pixel;
         pixel.chan.rgb = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.a = util_float_to_half((float)(src[3] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i16_float {
   uint16_t value;
   struct {
      uint16_t rgba;
   } chan;
};

static inline void
util_format_i16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgba); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgba); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgba); /* b */
         dst[3] = util_half_to_float(pixel.chan.rgba); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i16_float pixel;
         pixel.chan.rgba = util_float_to_half(src[0]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_i16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_i16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgba); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgba); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgba); /* b */
         dst[3] = util_half_to_float(pixel.chan.rgba); /* a */
}

static inline void
util_format_i16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.rgba)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.rgba)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.rgba)); /* b */
         dst[3] = float_to_ubyte(util_half_to_float(pixel.chan.rgba)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i16_float pixel;
         pixel.chan.rgba = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a32_float {
   uint32_t value;
   struct {
      float a;
   } chan;
};

static inline void
util_format_a32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a32_float pixel;
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
}

static inline void
util_format_a32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = float_to_ubyte(pixel.chan.a); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a32_float pixel;
         pixel.chan.a = ubyte_to_float(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l32_float {
   uint32_t value;
   struct {
      float rgb;
   } chan;
};

static inline void
util_format_l32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l32_float pixel;
         pixel.chan.rgb = src[0];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_l32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.rgb); /* r */
         dst[1] = float_to_ubyte(pixel.chan.rgb); /* g */
         dst[2] = float_to_ubyte(pixel.chan.rgb); /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l32_float pixel;
         pixel.chan.rgb = ubyte_to_float(src[0]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l32a32_float {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      float rgb;
      float a;
#else
      float rgb;
      float a;
#endif
   } chan;
};

static inline void
util_format_l32a32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_l32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l32a32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_float pixel;
         pixel.chan.rgb = src[0];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_l32a32_float pixel;
         pixel.chan.rgb = src[0];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l32a32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_l32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
}

static inline void
util_format_l32a32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.rgb); /* r */
         dst[1] = float_to_ubyte(pixel.chan.rgb); /* g */
         dst[2] = float_to_ubyte(pixel.chan.rgb); /* b */
         dst[3] = float_to_ubyte(pixel.chan.a); /* a */
#else
         union util_format_l32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.rgb); /* r */
         dst[1] = float_to_ubyte(pixel.chan.rgb); /* g */
         dst[2] = float_to_ubyte(pixel.chan.rgb); /* b */
         dst[3] = float_to_ubyte(pixel.chan.a); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l32a32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_float pixel;
         pixel.chan.rgb = ubyte_to_float(src[0]);
         pixel.chan.a = ubyte_to_float(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_l32a32_float pixel;
         pixel.chan.rgb = ubyte_to_float(src[0]);
         pixel.chan.a = ubyte_to_float(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i32_float {
   uint32_t value;
   struct {
      float rgba;
   } chan;
};

static inline void
util_format_i32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgba; /* r */
         dst[1] = pixel.chan.rgba; /* g */
         dst[2] = pixel.chan.rgba; /* b */
         dst[3] = pixel.chan.rgba; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i32_float pixel;
         pixel.chan.rgba = src[0];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_i32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_i32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgba; /* r */
         dst[1] = pixel.chan.rgba; /* g */
         dst[2] = pixel.chan.rgba; /* b */
         dst[3] = pixel.chan.rgba; /* a */
}

static inline void
util_format_i32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.rgba); /* r */
         dst[1] = float_to_ubyte(pixel.chan.rgba); /* g */
         dst[2] = float_to_ubyte(pixel.chan.rgba); /* b */
         dst[3] = float_to_ubyte(pixel.chan.rgba); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i32_float pixel;
         pixel.chan.rgba = ubyte_to_float(src[0]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8_srgb {
   uint8_t value;
   struct {
      uint8_t rgb;
   } chan;
};

static inline void
util_format_l8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = util_format_srgb_8unorm_to_linear_float(rgb); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(rgb); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(rgb); /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= util_format_linear_float_to_srgb_8unorm(src[0]);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = util_format_srgb_8unorm_to_linear_float(rgb); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(rgb); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(rgb); /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = util_format_srgb_to_linear_8unorm(rgb); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(rgb); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(rgb); /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= util_format_linear_to_srgb_8unorm(src[0]);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8a8_srgb {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t rgb;
      uint8_t a;
#else
      uint8_t rgb;
      uint8_t a;
#endif
   } chan;
};

static inline void
util_format_l8a8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = value >> 8;
         a = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(rgb); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(rgb); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(rgb); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = util_format_srgb_8unorm_to_linear_float(rgb); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(rgb); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(rgb); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8a8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) << 8;
         value |= (float_to_ubyte(src[3])) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff;
         value |= (float_to_ubyte(src[3])) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l8a8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = value >> 8;
         a = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(rgb); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(rgb); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(rgb); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = util_format_srgb_8unorm_to_linear_float(rgb); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(rgb); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(rgb); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
}

static inline void
util_format_l8a8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = value >> 8;
         a = (value) & 0xff;
         dst[0] = util_format_srgb_to_linear_8unorm(rgb); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(rgb); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(rgb); /* b */
         dst[3] = a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = util_format_srgb_to_linear_8unorm(rgb); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(rgb); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(rgb); /* b */
         dst[3] = a; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8a8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) << 8;
         value |= (src[3]) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) & 0xff;
         value |= (src[3]) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8_srgb {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
      uint8_t b;
#else
      uint8_t r;
      uint8_t g;
      uint8_t b;
#endif
   } chan;
};

static inline void
util_format_r8g8b8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_srgb pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_format_srgb_8unorm_to_linear_float(pixel.chan.r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(pixel.chan.g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_srgb pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_format_srgb_8unorm_to_linear_float(pixel.chan.r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(pixel.chan.g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_srgb pixel;
         pixel.chan.r = util_format_linear_float_to_srgb_8unorm(src[0]);
         pixel.chan.g = util_format_linear_float_to_srgb_8unorm(src[1]);
         pixel.chan.b = util_format_linear_float_to_srgb_8unorm(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_srgb pixel;
         pixel.chan.r = util_format_linear_float_to_srgb_8unorm(src[0]);
         pixel.chan.g = util_format_linear_float_to_srgb_8unorm(src[1]);
         pixel.chan.b = util_format_linear_float_to_srgb_8unorm(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_srgb pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_format_srgb_8unorm_to_linear_float(pixel.chan.r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(pixel.chan.g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_srgb pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_format_srgb_8unorm_to_linear_float(pixel.chan.r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(pixel.chan.g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8b8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_srgb pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_format_srgb_to_linear_8unorm(pixel.chan.r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(pixel.chan.g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(pixel.chan.b); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r8g8b8_srgb pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_format_srgb_to_linear_8unorm(pixel.chan.r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(pixel.chan.g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(pixel.chan.b); /* b */
         dst[3] = 255; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_srgb pixel;
         pixel.chan.r = util_format_linear_to_srgb_8unorm(src[0]);
         pixel.chan.g = util_format_linear_to_srgb_8unorm(src[1]);
         pixel.chan.b = util_format_linear_to_srgb_8unorm(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_srgb pixel;
         pixel.chan.r = util_format_linear_to_srgb_8unorm(src[0]);
         pixel.chan.g = util_format_linear_to_srgb_8unorm(src[1]);
         pixel.chan.b = util_format_linear_to_srgb_8unorm(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8a8_srgb {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
#else
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
#endif
   } chan;
};

static inline void
util_format_r8g8b8a8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) << 24;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff) << 8;
         value |= (float_to_ubyte(src[3])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff) << 16;
         value |= (float_to_ubyte(src[3])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8a8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
}

static inline void
util_format_r8g8b8a8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) << 24;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= ((util_format_linear_to_srgb_8unorm(src[2])) & 0xff) << 8;
         value |= (src[3]) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) & 0xff;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[2])) & 0xff) << 16;
         value |= (src[3]) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8b8g8r8_srgb {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t a;
      uint8_t b;
      uint8_t g;
      uint8_t r;
#else
      uint8_t a;
      uint8_t b;
      uint8_t g;
      uint8_t r;
#endif
   } chan;
};

static inline void
util_format_a8b8g8r8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 24;
         b = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = (value) & 0xff;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8b8g8r8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (float_to_ubyte(src[3])) << 24;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff) << 16;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (float_to_ubyte(src[3])) & 0xff;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a8b8g8r8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 24;
         b = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = (value) & 0xff;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
}

static inline void
util_format_a8b8g8r8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 24;
         b = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value) & 0xff;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = (value) & 0xff;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8b8g8r8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (src[3]) << 24;
         value |= ((util_format_linear_to_srgb_8unorm(src[2])) & 0xff) << 16;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (src[3]) & 0xff;
         value |= ((util_format_linear_to_srgb_8unorm(src[2])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_x8b8g8r8_srgb {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t x;
      uint8_t b;
      uint8_t g;
      uint8_t r;
#else
      uint8_t x;
      uint8_t b;
      uint8_t g;
      uint8_t r;
#endif
   } chan;
};

static inline void
util_format_x8b8g8r8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_x8b8g8r8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff) << 16;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_x8b8g8r8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_x8b8g8r8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value) & 0xff;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_x8b8g8r8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((util_format_linear_to_srgb_8unorm(src[2])) & 0xff) << 16;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((util_format_linear_to_srgb_8unorm(src[2])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b8g8r8a8_srgb {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t a;
#else
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t a;
#endif
   } chan;
};

static inline void
util_format_b8g8r8a8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = value >> 24;
         g = (value >> 16) & 0xff;
         r = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b8g8r8a8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) << 24;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff) << 8;
         value |= (float_to_ubyte(src[3])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff) << 16;
         value |= (float_to_ubyte(src[3])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b8g8r8a8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = value >> 24;
         g = (value >> 16) & 0xff;
         r = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
}

static inline void
util_format_b8g8r8a8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = value >> 24;
         g = (value >> 16) & 0xff;
         r = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b8g8r8a8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) << 24;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= ((util_format_linear_to_srgb_8unorm(src[0])) & 0xff) << 8;
         value |= (src[3]) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) & 0xff;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[0])) & 0xff) << 16;
         value |= (src[3]) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b8g8r8x8_srgb {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t x;
#else
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t x;
#endif
   } chan;
};

static inline void
util_format_b8g8r8x8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = value >> 24;
         g = (value >> 16) & 0xff;
         r = (value >> 8) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b8g8r8x8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) << 24;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff) << 8;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b8g8r8x8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = value >> 24;
         g = (value >> 16) & 0xff;
         r = (value >> 8) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_b8g8r8x8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = value >> 24;
         g = (value >> 16) & 0xff;
         r = (value >> 8) & 0xff;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b8g8r8x8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) << 24;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= ((util_format_linear_to_srgb_8unorm(src[0])) & 0xff) << 8;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) & 0xff;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[0])) & 0xff) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8r8g8b8_srgb {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t a;
      uint8_t r;
      uint8_t g;
      uint8_t b;
#else
      uint8_t a;
      uint8_t r;
      uint8_t g;
      uint8_t b;
#endif
   } chan;
};

static inline void
util_format_a8r8g8b8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 24;
         r = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = (value) & 0xff;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8r8g8b8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (float_to_ubyte(src[3])) << 24;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff) << 16;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (float_to_ubyte(src[3])) & 0xff;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a8r8g8b8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 24;
         r = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = (value) & 0xff;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
}

static inline void
util_format_a8r8g8b8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 24;
         r = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value) & 0xff;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = (value) & 0xff;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8r8g8b8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (src[3]) << 24;
         value |= ((util_format_linear_to_srgb_8unorm(src[0])) & 0xff) << 16;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (src[3]) & 0xff;
         value |= ((util_format_linear_to_srgb_8unorm(src[0])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_x8r8g8b8_srgb {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t x;
      uint8_t r;
      uint8_t g;
      uint8_t b;
#else
      uint8_t x;
      uint8_t r;
      uint8_t g;
      uint8_t b;
#endif
   } chan;
};

static inline void
util_format_x8r8g8b8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_x8r8g8b8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff) << 16;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_x8r8g8b8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_x8r8g8b8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 16) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value) & 0xff;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_x8r8g8b8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((util_format_linear_to_srgb_8unorm(src[0])) & 0xff) << 16;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((util_format_linear_to_srgb_8unorm(src[0])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8sg8sb8ux8u_norm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t g;
      uint8_t b;
      uint8_t x;
#else
      int8_t r;
      int8_t g;
      uint8_t b;
      uint8_t x;
#endif
   } chan;
};

static inline void
util_format_r8sg8sb8ux8u_norm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         uint32_t b;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = (value >> 8) & 0xff;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         uint32_t b;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = (value >> 16) & 0xff;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8sg8sb8ux8u_norm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) << 24) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7f)) & 0xff) << 16) ;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 8;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) & 0xff) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7f)) & 0xff) << 8) ;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8sg8sb8ux8u_norm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         uint32_t b;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = (value >> 8) & 0xff;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         uint32_t b;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = (value >> 16) & 0xff;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8sg8sb8ux8u_norm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         uint32_t b;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = (value >> 8) & 0xff;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         uint32_t b;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = (value >> 16) & 0xff;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8sg8sb8ux8u_norm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(src[0] >> 1)) << 24) ;
         value |= (uint32_t)((((uint32_t)(src[1] >> 1)) & 0xff) << 16) ;
         value |= ((src[2]) & 0xff) << 8;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(src[0] >> 1)) & 0xff) ;
         value |= (uint32_t)((((uint32_t)(src[1] >> 1)) & 0xff) << 8) ;
         value |= ((src[2]) & 0xff) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10sg10sb10sa2u_norm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned a:2;
      int b:10;
      int g:10;
      int r:10;
#else
      int r:10;
      int g:10;
      int b:10;
      unsigned a:2;
#endif
   } chan;
};

static inline void
util_format_r10sg10sb10sa2u_norm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         int32_t b;
         int32_t g;
         int32_t r;
         a = value >> 30;
         b = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         uint32_t a;
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         a = value >> 30;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10sg10sb10sa2u_norm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0x3)) << 30;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 20) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 10) ;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 20) ;
         value |= ((uint32_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0x3)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r10sg10sb10sa2u_norm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         int32_t b;
         int32_t g;
         int32_t r;
         a = value >> 30;
         b = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         uint32_t a;
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         a = value >> 30;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
#endif
}

static inline void
util_format_r10sg10sb10sa2u_norm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         int32_t b;
         int32_t g;
         int32_t r;
         a = value >> 30;
         b = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 1); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 1); /* g */
         dst[2] = (uint8_t)(MAX2(b, 0) >> 1); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0x3); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         uint32_t a;
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         a = value >> 30;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 1); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 1); /* g */
         dst[2] = (uint8_t)(MAX2(b, 0) >> 1); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0x3); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10sg10sb10sa2u_norm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)(src[3] >> 6)) << 30;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[2]) * 0x1ff / 0xff)) & 0x3ff) << 20) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1ff / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[0]) * 0x1ff / 0xff)) & 0x3ff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[0]) * 0x1ff / 0xff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1ff / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[2]) * 0x1ff / 0xff)) & 0x3ff) << 20) ;
         value |= ((uint32_t)(src[3] >> 6)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r5sg5sb6u_norm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned b:6;
      int g:5;
      int r:5;
#else
      int r:5;
      int g:5;
      unsigned b:6;
#endif
   } chan;
};

static inline void
util_format_r5sg5sb6u_norm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         int16_t g;
         int16_t r;
         b = value >> 10;
         g = ((int16_t)(value << 6) ) >> 11;
         r = ((int16_t)(value << 11) ) >> 11;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0x3f)); /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         uint16_t b;
         r = ((int16_t)(value << 11) ) >> 11;
         g = ((int16_t)(value << 6) ) >> 11;
         b = value >> 10;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0x3f)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r5sg5sb6u_norm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x3f)) << 10;
         value |= (uint16_t)((((uint16_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0xf)) & 0x1f) << 5) ;
         value |= (uint16_t)(((uint16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0xf)) & 0x1f) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((uint16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0xf)) & 0x1f) ;
         value |= (uint16_t)((((uint16_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0xf)) & 0x1f) << 5) ;
         value |= ((uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x3f)) << 10;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r5sg5sb6u_norm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         int16_t g;
         int16_t r;
         b = value >> 10;
         g = ((int16_t)(value << 6) ) >> 11;
         r = ((int16_t)(value << 11) ) >> 11;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0x3f)); /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         uint16_t b;
         r = ((int16_t)(value << 11) ) >> 11;
         g = ((int16_t)(value << 6) ) >> 11;
         b = value >> 10;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0x3f)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r5sg5sb6u_norm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         int16_t g;
         int16_t r;
         b = value >> 10;
         g = ((int16_t)(value << 6) ) >> 11;
         r = ((int16_t)(value << 11) ) >> 11;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0xf); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0xf); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x3f); /* b */
         dst[3] = 255; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         uint16_t b;
         r = ((int16_t)(value << 11) ) >> 11;
         g = ((int16_t)(value << 6) ) >> 11;
         b = value >> 10;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0xf); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0xf); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x3f); /* b */
         dst[3] = 255; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r5sg5sb6u_norm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint16_t)(src[2] >> 2)) << 10;
         value |= (uint16_t)((((uint16_t)(src[1] >> 4)) & 0x1f) << 5) ;
         value |= (uint16_t)(((uint16_t)(src[0] >> 4)) & 0x1f) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((uint16_t)(src[0] >> 4)) & 0x1f) ;
         value |= (uint16_t)((((uint16_t)(src[1] >> 4)) & 0x1f) << 5) ;
         value |= ((uint16_t)(src[2] >> 2)) << 10;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r64_float {
   uint64_t value;
   struct {
      double r;
   } chan;
};

static inline void
util_format_r64_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r64_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64_float pixel;
         pixel.chan.r = (double)src[0];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r64_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r64_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround(CLAMP(pixel.chan.r, 0.0, 1.0) * 0xff); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r64_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64_float pixel;
         pixel.chan.r = (double)(src[0] * (1.0f/0xff));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r64g64_float {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      double r;
      double g;
#else
      double r;
      double g;
#endif
   } chan;
};

static inline void
util_format_r64g64_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r64g64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r64g64_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64_float pixel;
         pixel.chan.r = (double)src[0];
         pixel.chan.g = (double)src[1];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r64g64_float pixel;
         pixel.chan.r = (double)src[0];
         pixel.chan.g = (double)src[1];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r64g64_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r64g64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r64g64_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround(CLAMP(pixel.chan.r, 0.0, 1.0) * 0xff); /* r */
         dst[1] = (uint8_t)util_iround(CLAMP(pixel.chan.g, 0.0, 1.0) * 0xff); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r64g64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround(CLAMP(pixel.chan.r, 0.0, 1.0) * 0xff); /* r */
         dst[1] = (uint8_t)util_iround(CLAMP(pixel.chan.g, 0.0, 1.0) * 0xff); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r64g64_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64_float pixel;
         pixel.chan.r = (double)(src[0] * (1.0f/0xff));
         pixel.chan.g = (double)(src[1] * (1.0f/0xff));
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r64g64_float pixel;
         pixel.chan.r = (double)(src[0] * (1.0f/0xff));
         pixel.chan.g = (double)(src[1] * (1.0f/0xff));
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r64g64b64_float {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      double r;
      double g;
      double b;
#else
      double r;
      double g;
      double b;
#endif
   } chan;
};

static inline void
util_format_r64g64b64_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64b64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r64g64b64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 24;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r64g64b64_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64b64_float pixel;
         pixel.chan.r = (double)src[0];
         pixel.chan.g = (double)src[1];
         pixel.chan.b = (double)src[2];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r64g64b64_float pixel;
         pixel.chan.r = (double)src[0];
         pixel.chan.g = (double)src[1];
         pixel.chan.b = (double)src[2];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 24;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r64g64b64_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64b64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r64g64b64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r64g64b64_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64b64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround(CLAMP(pixel.chan.r, 0.0, 1.0) * 0xff); /* r */
         dst[1] = (uint8_t)util_iround(CLAMP(pixel.chan.g, 0.0, 1.0) * 0xff); /* g */
         dst[2] = (uint8_t)util_iround(CLAMP(pixel.chan.b, 0.0, 1.0) * 0xff); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r64g64b64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround(CLAMP(pixel.chan.r, 0.0, 1.0) * 0xff); /* r */
         dst[1] = (uint8_t)util_iround(CLAMP(pixel.chan.g, 0.0, 1.0) * 0xff); /* g */
         dst[2] = (uint8_t)util_iround(CLAMP(pixel.chan.b, 0.0, 1.0) * 0xff); /* b */
         dst[3] = 255; /* a */
#endif
         src += 24;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r64g64b64_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64b64_float pixel;
         pixel.chan.r = (double)(src[0] * (1.0f/0xff));
         pixel.chan.g = (double)(src[1] * (1.0f/0xff));
         pixel.chan.b = (double)(src[2] * (1.0f/0xff));
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r64g64b64_float pixel;
         pixel.chan.r = (double)(src[0] * (1.0f/0xff));
         pixel.chan.g = (double)(src[1] * (1.0f/0xff));
         pixel.chan.b = (double)(src[2] * (1.0f/0xff));
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 24;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r64g64b64a64_float {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      double r;
      double g;
      double b;
      double a;
#else
      double r;
      double g;
      double b;
      double a;
#endif
   } chan;
};

static inline void
util_format_r64g64b64a64_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64b64a64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#else
         union util_format_r64g64b64a64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#endif
         src += 32;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r64g64b64a64_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64b64a64_float pixel;
         pixel.chan.r = (double)src[0];
         pixel.chan.g = (double)src[1];
         pixel.chan.b = (double)src[2];
         pixel.chan.a = (double)src[3];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r64g64b64a64_float pixel;
         pixel.chan.r = (double)src[0];
         pixel.chan.g = (double)src[1];
         pixel.chan.b = (double)src[2];
         pixel.chan.a = (double)src[3];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 32;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r64g64b64a64_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64b64a64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#else
         union util_format_r64g64b64a64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r64g64b64a64_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64b64a64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround(CLAMP(pixel.chan.r, 0.0, 1.0) * 0xff); /* r */
         dst[1] = (uint8_t)util_iround(CLAMP(pixel.chan.g, 0.0, 1.0) * 0xff); /* g */
         dst[2] = (uint8_t)util_iround(CLAMP(pixel.chan.b, 0.0, 1.0) * 0xff); /* b */
         dst[3] = (uint8_t)util_iround(CLAMP(pixel.chan.a, 0.0, 1.0) * 0xff); /* a */
#else
         union util_format_r64g64b64a64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround(CLAMP(pixel.chan.r, 0.0, 1.0) * 0xff); /* r */
         dst[1] = (uint8_t)util_iround(CLAMP(pixel.chan.g, 0.0, 1.0) * 0xff); /* g */
         dst[2] = (uint8_t)util_iround(CLAMP(pixel.chan.b, 0.0, 1.0) * 0xff); /* b */
         dst[3] = (uint8_t)util_iround(CLAMP(pixel.chan.a, 0.0, 1.0) * 0xff); /* a */
#endif
         src += 32;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r64g64b64a64_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r64g64b64a64_float pixel;
         pixel.chan.r = (double)(src[0] * (1.0f/0xff));
         pixel.chan.g = (double)(src[1] * (1.0f/0xff));
         pixel.chan.b = (double)(src[2] * (1.0f/0xff));
         pixel.chan.a = (double)(src[3] * (1.0f/0xff));
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r64g64b64a64_float pixel;
         pixel.chan.r = (double)(src[0] * (1.0f/0xff));
         pixel.chan.g = (double)(src[1] * (1.0f/0xff));
         pixel.chan.b = (double)(src[2] * (1.0f/0xff));
         pixel.chan.a = (double)(src[3] * (1.0f/0xff));
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 32;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_float {
   uint32_t value;
   struct {
      float r;
   } chan;
};

static inline void
util_format_r32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_float pixel;
         pixel.chan.r = src[0];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_float {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      float r;
      float g;
#else
      float r;
      float g;
#endif
   } chan;
};

static inline void
util_format_r32g32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = float_to_ubyte(pixel.chan.g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = float_to_ubyte(pixel.chan.g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.g = ubyte_to_float(src[1]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.g = ubyte_to_float(src[1]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_float {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      float r;
      float g;
      float b;
#else
      float r;
      float g;
      float b;
#endif
   } chan;
};

static inline void
util_format_r32g32b32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32b32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = float_to_ubyte(pixel.chan.g); /* g */
         dst[2] = float_to_ubyte(pixel.chan.b); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32b32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = float_to_ubyte(pixel.chan.g); /* g */
         dst[2] = float_to_ubyte(pixel.chan.b); /* b */
         dst[3] = 255; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.g = ubyte_to_float(src[1]);
         pixel.chan.b = ubyte_to_float(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.g = ubyte_to_float(src[1]);
         pixel.chan.b = ubyte_to_float(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_float {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      float r;
      float g;
      float b;
      float a;
#else
      float r;
      float g;
      float b;
      float a;
#endif
   } chan;
};

static inline void
util_format_r32g32b32a32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_r32g32b32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32a32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_r32g32b32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r32g32b32a32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = float_to_ubyte(pixel.chan.g); /* g */
         dst[2] = float_to_ubyte(pixel.chan.b); /* b */
         dst[3] = float_to_ubyte(pixel.chan.a); /* a */
#else
         union util_format_r32g32b32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = float_to_ubyte(pixel.chan.g); /* g */
         dst[2] = float_to_ubyte(pixel.chan.b); /* b */
         dst[3] = float_to_ubyte(pixel.chan.a); /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.g = ubyte_to_float(src[1]);
         pixel.chan.b = ubyte_to_float(src[2]);
         pixel.chan.a = ubyte_to_float(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.g = ubyte_to_float(src[1]);
         pixel.chan.b = ubyte_to_float(src[2]);
         pixel.chan.a = ubyte_to_float(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_unorm {
   uint32_t value;
   struct {
      uint32_t r;
   } chan;
};

static inline void
util_format_r32_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         r = value;
         dst[0] = (float)(r * (1.0/0xffffffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(CLAMP(src[0], 0.0f, 1.0f) * (double)0xffffffff);
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         r = value;
         dst[0] = (float)(r * (1.0/0xffffffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r32_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         r = value;
         dst[0] = (uint8_t)(r >> 24); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((uint64_t)src[0]) * 0xffffffff / 0xff);
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_unorm {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint32_t r;
      uint32_t g;
#else
      uint32_t r;
      uint32_t g;
#endif
   } chan;
};

static inline void
util_format_r32g32_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_unorm pixel;
         pixel.chan.r = (uint32_t)(CLAMP(src[0], 0.0f, 1.0f) * (double)0xffffffff);
         pixel.chan.g = (uint32_t)(CLAMP(src[1], 0.0f, 1.0f) * (double)0xffffffff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_unorm pixel;
         pixel.chan.r = (uint32_t)(CLAMP(src[0], 0.0f, 1.0f) * (double)0xffffffff);
         pixel.chan.g = (uint32_t)(CLAMP(src[1], 0.0f, 1.0f) * (double)0xffffffff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 24); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 24); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_unorm pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0xffffffff / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0xffffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_unorm pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0xffffffff / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0xffffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_unorm {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint32_t r;
      uint32_t g;
      uint32_t b;
#else
      uint32_t r;
      uint32_t g;
      uint32_t b;
#endif
   } chan;
};

static inline void
util_format_r32g32b32_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_unorm pixel;
         pixel.chan.r = (uint32_t)(CLAMP(src[0], 0.0f, 1.0f) * (double)0xffffffff);
         pixel.chan.g = (uint32_t)(CLAMP(src[1], 0.0f, 1.0f) * (double)0xffffffff);
         pixel.chan.b = (uint32_t)(CLAMP(src[2], 0.0f, 1.0f) * (double)0xffffffff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_unorm pixel;
         pixel.chan.r = (uint32_t)(CLAMP(src[0], 0.0f, 1.0f) * (double)0xffffffff);
         pixel.chan.g = (uint32_t)(CLAMP(src[1], 0.0f, 1.0f) * (double)0xffffffff);
         pixel.chan.b = (uint32_t)(CLAMP(src[2], 0.0f, 1.0f) * (double)0xffffffff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32b32_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 24); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 24); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32b32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 24); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 24); /* b */
         dst[3] = 255; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_unorm pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0xffffffff / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0xffffffff / 0xff);
         pixel.chan.b = (uint32_t)(((uint64_t)src[2]) * 0xffffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_unorm pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0xffffffff / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0xffffffff / 0xff);
         pixel.chan.b = (uint32_t)(((uint64_t)src[2]) * 0xffffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_unorm {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint32_t r;
      uint32_t g;
      uint32_t b;
      uint32_t a;
#else
      uint32_t r;
      uint32_t g;
      uint32_t b;
      uint32_t a;
#endif
   } chan;
};

static inline void
util_format_r32g32b32a32_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0xffffffff)); /* a */
#else
         union util_format_r32g32b32a32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0xffffffff)); /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_unorm pixel;
         pixel.chan.r = (uint32_t)(CLAMP(src[0], 0.0f, 1.0f) * (double)0xffffffff);
         pixel.chan.g = (uint32_t)(CLAMP(src[1], 0.0f, 1.0f) * (double)0xffffffff);
         pixel.chan.b = (uint32_t)(CLAMP(src[2], 0.0f, 1.0f) * (double)0xffffffff);
         pixel.chan.a = (uint32_t)(CLAMP(src[3], 0.0f, 1.0f) * (double)0xffffffff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_unorm pixel;
         pixel.chan.r = (uint32_t)(CLAMP(src[0], 0.0f, 1.0f) * (double)0xffffffff);
         pixel.chan.g = (uint32_t)(CLAMP(src[1], 0.0f, 1.0f) * (double)0xffffffff);
         pixel.chan.b = (uint32_t)(CLAMP(src[2], 0.0f, 1.0f) * (double)0xffffffff);
         pixel.chan.a = (uint32_t)(CLAMP(src[3], 0.0f, 1.0f) * (double)0xffffffff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32a32_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0xffffffff)); /* a */
#else
         union util_format_r32g32b32a32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0xffffffff)); /* a */
#endif
}

static inline void
util_format_r32g32b32a32_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 24); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 24); /* b */
         dst[3] = (uint8_t)(pixel.chan.a >> 24); /* a */
#else
         union util_format_r32g32b32a32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 24); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 24); /* b */
         dst[3] = (uint8_t)(pixel.chan.a >> 24); /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_unorm pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0xffffffff / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0xffffffff / 0xff);
         pixel.chan.b = (uint32_t)(((uint64_t)src[2]) * 0xffffffff / 0xff);
         pixel.chan.a = (uint32_t)(((uint64_t)src[3]) * 0xffffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_unorm pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0xffffffff / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0xffffffff / 0xff);
         pixel.chan.b = (uint32_t)(((uint64_t)src[2]) * 0xffffffff / 0xff);
         pixel.chan.a = (uint32_t)(((uint64_t)src[3]) * 0xffffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_uscaled {
   uint32_t value;
   struct {
      uint32_t r;
   } chan;
};

static inline void
util_format_r32_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)CLAMP(src[0], 0.0f, 4294967040.0f);
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r32_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         r = value;
         dst[0] = (uint8_t)(((uint64_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_uscaled {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint32_t r;
      uint32_t g;
#else
      uint32_t r;
      uint32_t g;
#endif
   } chan;
};

static inline void
util_format_r32g32_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_uscaled pixel;
         pixel.chan.r = (uint32_t)CLAMP(src[0], 0.0f, 4294967040.0f);
         pixel.chan.g = (uint32_t)CLAMP(src[1], 0.0f, 4294967040.0f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_uscaled pixel;
         pixel.chan.r = (uint32_t)CLAMP(src[0], 0.0f, 4294967040.0f);
         pixel.chan.g = (uint32_t)CLAMP(src[1], 0.0f, 4294967040.0f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_uscaled pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_uscaled pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_uscaled {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint32_t r;
      uint32_t g;
      uint32_t b;
#else
      uint32_t r;
      uint32_t g;
      uint32_t b;
#endif
   } chan;
};

static inline void
util_format_r32g32b32_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_uscaled pixel;
         pixel.chan.r = (uint32_t)CLAMP(src[0], 0.0f, 4294967040.0f);
         pixel.chan.g = (uint32_t)CLAMP(src[1], 0.0f, 4294967040.0f);
         pixel.chan.b = (uint32_t)CLAMP(src[2], 0.0f, 4294967040.0f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_uscaled pixel;
         pixel.chan.r = (uint32_t)CLAMP(src[0], 0.0f, 4294967040.0f);
         pixel.chan.g = (uint32_t)CLAMP(src[1], 0.0f, 4294967040.0f);
         pixel.chan.b = (uint32_t)CLAMP(src[2], 0.0f, 4294967040.0f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32b32_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint64_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32b32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint64_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_uscaled pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint32_t)(((uint64_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_uscaled pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint32_t)(((uint64_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_uscaled {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint32_t r;
      uint32_t g;
      uint32_t b;
      uint32_t a;
#else
      uint32_t r;
      uint32_t g;
      uint32_t b;
      uint32_t a;
#endif
   } chan;
};

static inline void
util_format_r32g32b32a32_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#else
         union util_format_r32g32b32a32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_uscaled pixel;
         pixel.chan.r = (uint32_t)CLAMP(src[0], 0.0f, 4294967040.0f);
         pixel.chan.g = (uint32_t)CLAMP(src[1], 0.0f, 4294967040.0f);
         pixel.chan.b = (uint32_t)CLAMP(src[2], 0.0f, 4294967040.0f);
         pixel.chan.a = (uint32_t)CLAMP(src[3], 0.0f, 4294967040.0f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_uscaled pixel;
         pixel.chan.r = (uint32_t)CLAMP(src[0], 0.0f, 4294967040.0f);
         pixel.chan.g = (uint32_t)CLAMP(src[1], 0.0f, 4294967040.0f);
         pixel.chan.b = (uint32_t)CLAMP(src[2], 0.0f, 4294967040.0f);
         pixel.chan.a = (uint32_t)CLAMP(src[3], 0.0f, 4294967040.0f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32a32_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#else
         union util_format_r32g32b32a32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r32g32b32a32_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint64_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint64_t)MIN2(pixel.chan.a, 1)) * 0xff / 0x1); /* a */
#else
         union util_format_r32g32b32a32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint64_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint64_t)MIN2(pixel.chan.a, 1)) * 0xff / 0x1); /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_uscaled pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint32_t)(((uint64_t)src[2]) * 0x1 / 0xff);
         pixel.chan.a = (uint32_t)(((uint64_t)src[3]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_uscaled pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint32_t)(((uint64_t)src[2]) * 0x1 / 0xff);
         pixel.chan.a = (uint32_t)(((uint64_t)src[3]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_snorm {
   uint32_t value;
   struct {
      int32_t r;
   } chan;
};

static inline void
util_format_r32_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         r = (int32_t)(value) ;
         dst[0] = (float)(r * (1.0/0x7fffffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)((int32_t)(CLAMP(src[0], -1.0f, 1.0f) * (double)0x7fffffff)) ;
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         r = (int32_t)(value) ;
         dst[0] = (float)(r * (1.0/0x7fffffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r32_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         r = (int32_t)(value) ;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 23); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)((int32_t)(((uint64_t)src[0]) * 0x7fffffff / 0xff)) ;
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_snorm {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
#else
      int32_t r;
      int32_t g;
#endif
   } chan;
};

static inline void
util_format_r32g32_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_snorm pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -1.0f, 1.0f) * (double)0x7fffffff);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -1.0f, 1.0f) * (double)0x7fffffff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_snorm pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -1.0f, 1.0f) * (double)0x7fffffff);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -1.0f, 1.0f) * (double)0x7fffffff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 23); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 23); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_snorm pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x7fffffff / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x7fffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_snorm pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x7fffffff / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x7fffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_snorm {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
      int32_t b;
#else
      int32_t r;
      int32_t g;
      int32_t b;
#endif
   } chan;
};

static inline void
util_format_r32g32b32_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_snorm pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -1.0f, 1.0f) * (double)0x7fffffff);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -1.0f, 1.0f) * (double)0x7fffffff);
         pixel.chan.b = (int32_t)(CLAMP(src[2], -1.0f, 1.0f) * (double)0x7fffffff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_snorm pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -1.0f, 1.0f) * (double)0x7fffffff);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -1.0f, 1.0f) * (double)0x7fffffff);
         pixel.chan.b = (int32_t)(CLAMP(src[2], -1.0f, 1.0f) * (double)0x7fffffff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32b32_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 23); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 23); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32b32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 23); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 23); /* b */
         dst[3] = 255; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_snorm pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x7fffffff / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x7fffffff / 0xff);
         pixel.chan.b = (int32_t)(((uint64_t)src[2]) * 0x7fffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_snorm pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x7fffffff / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x7fffffff / 0xff);
         pixel.chan.b = (int32_t)(((uint64_t)src[2]) * 0x7fffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_snorm {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
#else
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
#endif
   } chan;
};

static inline void
util_format_r32g32b32a32_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0x7fffffff)); /* a */
#else
         union util_format_r32g32b32a32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0x7fffffff)); /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_snorm pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -1.0f, 1.0f) * (double)0x7fffffff);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -1.0f, 1.0f) * (double)0x7fffffff);
         pixel.chan.b = (int32_t)(CLAMP(src[2], -1.0f, 1.0f) * (double)0x7fffffff);
         pixel.chan.a = (int32_t)(CLAMP(src[3], -1.0f, 1.0f) * (double)0x7fffffff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_snorm pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -1.0f, 1.0f) * (double)0x7fffffff);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -1.0f, 1.0f) * (double)0x7fffffff);
         pixel.chan.b = (int32_t)(CLAMP(src[2], -1.0f, 1.0f) * (double)0x7fffffff);
         pixel.chan.a = (int32_t)(CLAMP(src[3], -1.0f, 1.0f) * (double)0x7fffffff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32a32_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0x7fffffff)); /* a */
#else
         union util_format_r32g32b32a32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0x7fffffff)); /* a */
#endif
}

static inline void
util_format_r32g32b32a32_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 23); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 23); /* b */
         dst[3] = (uint8_t)(MAX2(pixel.chan.a, 0) >> 23); /* a */
#else
         union util_format_r32g32b32a32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 23); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 23); /* b */
         dst[3] = (uint8_t)(MAX2(pixel.chan.a, 0) >> 23); /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_snorm pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x7fffffff / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x7fffffff / 0xff);
         pixel.chan.b = (int32_t)(((uint64_t)src[2]) * 0x7fffffff / 0xff);
         pixel.chan.a = (int32_t)(((uint64_t)src[3]) * 0x7fffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_snorm pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x7fffffff / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x7fffffff / 0xff);
         pixel.chan.b = (int32_t)(((uint64_t)src[2]) * 0x7fffffff / 0xff);
         pixel.chan.a = (int32_t)(((uint64_t)src[3]) * 0x7fffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_sscaled {
   uint32_t value;
   struct {
      int32_t r;
   } chan;
};

static inline void
util_format_r32_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         r = (int32_t)(value) ;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)((int32_t)CLAMP(src[0], -2147483648.0f, 2147483520.0f)) ;
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         r = (int32_t)(value) ;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r32_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         r = (int32_t)(value) ;
         dst[0] = (uint8_t)(((uint64_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)((int32_t)(((uint64_t)src[0]) * 0x1 / 0xff)) ;
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_sscaled {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
#else
      int32_t r;
      int32_t g;
#endif
   } chan;
};

static inline void
util_format_r32g32_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_sscaled pixel;
         pixel.chan.r = (int32_t)CLAMP(src[0], -2147483648.0f, 2147483520.0f);
         pixel.chan.g = (int32_t)CLAMP(src[1], -2147483648.0f, 2147483520.0f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_sscaled pixel;
         pixel.chan.r = (int32_t)CLAMP(src[0], -2147483648.0f, 2147483520.0f);
         pixel.chan.g = (int32_t)CLAMP(src[1], -2147483648.0f, 2147483520.0f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_sscaled pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_sscaled pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_sscaled {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
      int32_t b;
#else
      int32_t r;
      int32_t g;
      int32_t b;
#endif
   } chan;
};

static inline void
util_format_r32g32b32_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_sscaled pixel;
         pixel.chan.r = (int32_t)CLAMP(src[0], -2147483648.0f, 2147483520.0f);
         pixel.chan.g = (int32_t)CLAMP(src[1], -2147483648.0f, 2147483520.0f);
         pixel.chan.b = (int32_t)CLAMP(src[2], -2147483648.0f, 2147483520.0f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_sscaled pixel;
         pixel.chan.r = (int32_t)CLAMP(src[0], -2147483648.0f, 2147483520.0f);
         pixel.chan.g = (int32_t)CLAMP(src[1], -2147483648.0f, 2147483520.0f);
         pixel.chan.b = (int32_t)CLAMP(src[2], -2147483648.0f, 2147483520.0f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32b32_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32b32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_sscaled pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int32_t)(((uint64_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_sscaled pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int32_t)(((uint64_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_sscaled {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
#else
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
#endif
   } chan;
};

static inline void
util_format_r32g32b32a32_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#else
         union util_format_r32g32b32a32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_sscaled pixel;
         pixel.chan.r = (int32_t)CLAMP(src[0], -2147483648.0f, 2147483520.0f);
         pixel.chan.g = (int32_t)CLAMP(src[1], -2147483648.0f, 2147483520.0f);
         pixel.chan.b = (int32_t)CLAMP(src[2], -2147483648.0f, 2147483520.0f);
         pixel.chan.a = (int32_t)CLAMP(src[3], -2147483648.0f, 2147483520.0f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_sscaled pixel;
         pixel.chan.r = (int32_t)CLAMP(src[0], -2147483648.0f, 2147483520.0f);
         pixel.chan.g = (int32_t)CLAMP(src[1], -2147483648.0f, 2147483520.0f);
         pixel.chan.b = (int32_t)CLAMP(src[2], -2147483648.0f, 2147483520.0f);
         pixel.chan.a = (int32_t)CLAMP(src[3], -2147483648.0f, 2147483520.0f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32a32_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#else
         union util_format_r32g32b32a32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r32g32b32a32_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.a, 0, 1)) * 0xff / 0x1); /* a */
#else
         union util_format_r32g32b32a32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.a, 0, 1)) * 0xff / 0x1); /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_sscaled pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int32_t)(((uint64_t)src[2]) * 0x1 / 0xff);
         pixel.chan.a = (int32_t)(((uint64_t)src[3]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_sscaled pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int32_t)(((uint64_t)src[2]) * 0x1 / 0xff);
         pixel.chan.a = (int32_t)(((uint64_t)src[3]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16_float {
   uint16_t value;
   struct {
      uint16_t r;
   } chan;
};

static inline void
util_format_r16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16_float {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
#else
      uint16_t r;
      uint16_t g;
#endif
   } chan;
};

static inline void
util_format_r16g16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.g = util_float_to_half(src[1]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.g = util_float_to_half(src[1]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.g)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r16g16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.g)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.g = util_float_to_half((float)(src[1] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.g = util_float_to_half((float)(src[1] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16_float {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
      uint16_t b;
#else
      uint16_t r;
      uint16_t g;
      uint16_t b;
#endif
   } chan;
};

static inline void
util_format_r16g16b16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.g = util_float_to_half(src[1]);
         pixel.chan.b = util_float_to_half(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.g = util_float_to_half(src[1]);
         pixel.chan.b = util_float_to_half(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16b16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.g)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.b)); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r16g16b16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.g)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.b)); /* b */
         dst[3] = 255; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.g = util_float_to_half((float)(src[1] * (1.0f/0xff)));
         pixel.chan.b = util_float_to_half((float)(src[2] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.g = util_float_to_half((float)(src[1] * (1.0f/0xff)));
         pixel.chan.b = util_float_to_half((float)(src[2] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16a16_float {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
#else
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
#endif
   } chan;
};

static inline void
util_format_r16g16b16a16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
#else
         union util_format_r16g16b16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.g = util_float_to_half(src[1]);
         pixel.chan.b = util_float_to_half(src[2]);
         pixel.chan.a = util_float_to_half(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.g = util_float_to_half(src[1]);
         pixel.chan.b = util_float_to_half(src[2]);
         pixel.chan.a = util_float_to_half(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16a16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
#else
         union util_format_r16g16b16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
#endif
}

static inline void
util_format_r16g16b16a16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.g)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.b)); /* b */
         dst[3] = float_to_ubyte(util_half_to_float(pixel.chan.a)); /* a */
#else
         union util_format_r16g16b16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.g)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.b)); /* b */
         dst[3] = float_to_ubyte(util_half_to_float(pixel.chan.a)); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.g = util_float_to_half((float)(src[1] * (1.0f/0xff)));
         pixel.chan.b = util_float_to_half((float)(src[2] * (1.0f/0xff)));
         pixel.chan.a = util_float_to_half((float)(src[3] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.g = util_float_to_half((float)(src[1] * (1.0f/0xff)));
         pixel.chan.b = util_float_to_half((float)(src[2] * (1.0f/0xff)));
         pixel.chan.a = util_float_to_half((float)(src[3] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16_unorm {
   uint16_t value;
   struct {
      uint16_t r;
   } chan;
};

static inline void
util_format_r16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         r = value;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         r = value;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         r = value;
         dst[0] = (uint8_t)(r >> 8); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
#else
      uint16_t r;
      uint16_t g;
#endif
   } chan;
};

static inline void
util_format_r16g16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = value >> 16;
         g = (value) & 0xffff;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(g * (1.0f/0xffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(g * (1.0f/0xffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff)) << 16;
         value |= ((uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0xffff)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff)) & 0xffff;
         value |= ((uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0xffff)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = value >> 16;
         g = (value) & 0xffff;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(g * (1.0f/0xffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(g * (1.0f/0xffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = value >> 16;
         g = (value) & 0xffff;
         dst[0] = (uint8_t)(r >> 8); /* r */
         dst[1] = (uint8_t)(g >> 8); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (uint8_t)(r >> 8); /* r */
         dst[1] = (uint8_t)(g >> 8); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff)) << 16;
         value |= ((uint16_t)(((uint32_t)src[1]) * 0xffff / 0xff)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff)) & 0xffff;
         value |= ((uint16_t)(((uint32_t)src[1]) * 0xffff / 0xff)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16_unorm {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
      uint16_t b;
#else
      uint16_t r;
      uint16_t g;
      uint16_t b;
#endif
   } chan;
};

static inline void
util_format_r16g16b16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_unorm pixel;
         pixel.chan.r = (uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff);
         pixel.chan.g = (uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0xffff);
         pixel.chan.b = (uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0xffff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_unorm pixel;
         pixel.chan.r = (uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff);
         pixel.chan.g = (uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0xffff);
         pixel.chan.b = (uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0xffff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16b16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 8); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 8); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 8); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r16g16b16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 8); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 8); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 8); /* b */
         dst[3] = 255; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_unorm pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0xffff / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0xffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_unorm pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0xffff / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0xffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16a16_unorm {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
#else
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
#endif
   } chan;
};

static inline void
util_format_r16g16b16a16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0f/0xffff)); /* a */
#else
         union util_format_r16g16b16a16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0f/0xffff)); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_unorm pixel;
         pixel.chan.r = (uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff);
         pixel.chan.g = (uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0xffff);
         pixel.chan.b = (uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0xffff);
         pixel.chan.a = (uint16_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xffff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_unorm pixel;
         pixel.chan.r = (uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff);
         pixel.chan.g = (uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0xffff);
         pixel.chan.b = (uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0xffff);
         pixel.chan.a = (uint16_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xffff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16a16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0f/0xffff)); /* a */
#else
         union util_format_r16g16b16a16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0f/0xffff)); /* a */
#endif
}

static inline void
util_format_r16g16b16a16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 8); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 8); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 8); /* b */
         dst[3] = (uint8_t)(pixel.chan.a >> 8); /* a */
#else
         union util_format_r16g16b16a16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 8); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 8); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 8); /* b */
         dst[3] = (uint8_t)(pixel.chan.a >> 8); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_unorm pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0xffff / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0xffff / 0xff);
         pixel.chan.a = (uint16_t)(((uint32_t)src[3]) * 0xffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_unorm pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0xffff / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0xffff / 0xff);
         pixel.chan.a = (uint16_t)(((uint32_t)src[3]) * 0xffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16_uscaled {
   uint16_t value;
   struct {
      uint16_t r;
   } chan;
};

static inline void
util_format_r16_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)CLAMP(src[0], 0.0f, 65535.0f);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r16_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         r = value;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16_uscaled {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
#else
      uint16_t r;
      uint16_t g;
#endif
   } chan;
};

static inline void
util_format_r16g16_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = value >> 16;
         g = (value) & 0xffff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)CLAMP(src[0], 0.0f, 65535.0f)) << 16;
         value |= ((uint16_t)CLAMP(src[1], 0.0f, 65535.0f)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)CLAMP(src[0], 0.0f, 65535.0f)) & 0xffff;
         value |= ((uint16_t)CLAMP(src[1], 0.0f, 65535.0f)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = value >> 16;
         g = (value) & 0xffff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = value >> 16;
         g = (value) & 0xffff;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)(((uint32_t)src[0]) * 0x1 / 0xff)) << 16;
         value |= ((uint16_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0xffff;
         value |= ((uint16_t)(((uint32_t)src[1]) * 0x1 / 0xff)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16_uscaled {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
      uint16_t b;
#else
      uint16_t r;
      uint16_t g;
      uint16_t b;
#endif
   } chan;
};

static inline void
util_format_r16g16b16_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_uscaled pixel;
         pixel.chan.r = (uint16_t)CLAMP(src[0], 0.0f, 65535.0f);
         pixel.chan.g = (uint16_t)CLAMP(src[1], 0.0f, 65535.0f);
         pixel.chan.b = (uint16_t)CLAMP(src[2], 0.0f, 65535.0f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_uscaled pixel;
         pixel.chan.r = (uint16_t)CLAMP(src[0], 0.0f, 65535.0f);
         pixel.chan.g = (uint16_t)CLAMP(src[1], 0.0f, 65535.0f);
         pixel.chan.b = (uint16_t)CLAMP(src[2], 0.0f, 65535.0f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16b16_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r16g16b16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_uscaled pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_uscaled pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16a16_uscaled {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
#else
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
#endif
   } chan;
};

static inline void
util_format_r16g16b16a16_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#else
         union util_format_r16g16b16a16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_uscaled pixel;
         pixel.chan.r = (uint16_t)CLAMP(src[0], 0.0f, 65535.0f);
         pixel.chan.g = (uint16_t)CLAMP(src[1], 0.0f, 65535.0f);
         pixel.chan.b = (uint16_t)CLAMP(src[2], 0.0f, 65535.0f);
         pixel.chan.a = (uint16_t)CLAMP(src[3], 0.0f, 65535.0f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_uscaled pixel;
         pixel.chan.r = (uint16_t)CLAMP(src[0], 0.0f, 65535.0f);
         pixel.chan.g = (uint16_t)CLAMP(src[1], 0.0f, 65535.0f);
         pixel.chan.b = (uint16_t)CLAMP(src[2], 0.0f, 65535.0f);
         pixel.chan.a = (uint16_t)CLAMP(src[3], 0.0f, 65535.0f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16a16_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#else
         union util_format_r16g16b16a16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r16g16b16a16_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MIN2(pixel.chan.a, 1)) * 0xff / 0x1); /* a */
#else
         union util_format_r16g16b16a16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MIN2(pixel.chan.a, 1)) * 0xff / 0x1); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_uscaled pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         pixel.chan.a = (uint16_t)(((uint32_t)src[3]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_uscaled pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         pixel.chan.a = (uint16_t)(((uint32_t)src[3]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16_snorm {
   uint16_t value;
   struct {
      int16_t r;
   } chan;
};

static inline void
util_format_r16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         r = (int16_t)(value) ;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         r = (int16_t)(value) ;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         r = (int16_t)(value) ;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 7); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16_snorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t g;
#else
      int16_t r;
      int16_t g;
#endif
   } chan;
};

static inline void
util_format_r16g16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value) ) >> 16;
         g = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(g * (1.0f/0x7fff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(g * (1.0f/0x7fff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff)) << 16) ;
         value |= (uint32_t)(((int16_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7fff)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7fff)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value) ) >> 16;
         g = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(g * (1.0f/0x7fff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(g * (1.0f/0x7fff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value) ) >> 16;
         g = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 7); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 7); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff)) << 16) ;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[1]) * 0x7fff / 0xff)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[1]) * 0x7fff / 0xff)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16_snorm {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t g;
      int16_t b;
#else
      int16_t r;
      int16_t g;
      int16_t b;
#endif
   } chan;
};

static inline void
util_format_r16g16b16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_snorm pixel;
         pixel.chan.r = (int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.g = (int16_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.b = (int16_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x7fff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_snorm pixel;
         pixel.chan.r = (int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.g = (int16_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.b = (int16_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x7fff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16b16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 7); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r16g16b16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 7); /* b */
         dst[3] = 255; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_snorm pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x7fff / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x7fff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_snorm pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x7fff / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x7fff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16a16_snorm {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t g;
      int16_t b;
      int16_t a;
#else
      int16_t r;
      int16_t g;
      int16_t b;
      int16_t a;
#endif
   } chan;
};

static inline void
util_format_r16g16b16a16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0f/0x7fff)); /* a */
#else
         union util_format_r16g16b16a16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0f/0x7fff)); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_snorm pixel;
         pixel.chan.r = (int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.g = (int16_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.b = (int16_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.a = (int16_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7fff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_snorm pixel;
         pixel.chan.r = (int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.g = (int16_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.b = (int16_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.a = (int16_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7fff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16a16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0f/0x7fff)); /* a */
#else
         union util_format_r16g16b16a16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0f/0x7fff)); /* a */
#endif
}

static inline void
util_format_r16g16b16a16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 7); /* b */
         dst[3] = (uint8_t)(MAX2(pixel.chan.a, 0) >> 7); /* a */
#else
         union util_format_r16g16b16a16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 7); /* b */
         dst[3] = (uint8_t)(MAX2(pixel.chan.a, 0) >> 7); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_snorm pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x7fff / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x7fff / 0xff);
         pixel.chan.a = (int16_t)(((uint32_t)src[3]) * 0x7fff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_snorm pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x7fff / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x7fff / 0xff);
         pixel.chan.a = (int16_t)(((uint32_t)src[3]) * 0x7fff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16_sscaled {
   uint16_t value;
   struct {
      int16_t r;
   } chan;
};

static inline void
util_format_r16_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         r = (int16_t)(value) ;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)CLAMP(src[0], -32768.0f, 32767.0f)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         r = (int16_t)(value) ;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r16_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         r = (int16_t)(value) ;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(((uint32_t)src[0]) * 0x1 / 0xff)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16_sscaled {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t g;
#else
      int16_t r;
      int16_t g;
#endif
   } chan;
};

static inline void
util_format_r16g16_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value) ) >> 16;
         g = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)CLAMP(src[0], -32768.0f, 32767.0f)) << 16) ;
         value |= (uint32_t)(((int16_t)CLAMP(src[1], -32768.0f, 32767.0f)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)CLAMP(src[0], -32768.0f, 32767.0f)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)CLAMP(src[1], -32768.0f, 32767.0f)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value) ) >> 16;
         g = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value) ) >> 16;
         g = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[0]) * 0x1 / 0xff)) << 16) ;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[1]) * 0x1 / 0xff)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16_sscaled {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t g;
      int16_t b;
#else
      int16_t r;
      int16_t g;
      int16_t b;
#endif
   } chan;
};

static inline void
util_format_r16g16b16_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_sscaled pixel;
         pixel.chan.r = (int16_t)CLAMP(src[0], -32768.0f, 32767.0f);
         pixel.chan.g = (int16_t)CLAMP(src[1], -32768.0f, 32767.0f);
         pixel.chan.b = (int16_t)CLAMP(src[2], -32768.0f, 32767.0f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_sscaled pixel;
         pixel.chan.r = (int16_t)CLAMP(src[0], -32768.0f, 32767.0f);
         pixel.chan.g = (int16_t)CLAMP(src[1], -32768.0f, 32767.0f);
         pixel.chan.b = (int16_t)CLAMP(src[2], -32768.0f, 32767.0f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16b16_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r16g16b16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_sscaled pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_sscaled pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16a16_sscaled {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t g;
      int16_t b;
      int16_t a;
#else
      int16_t r;
      int16_t g;
      int16_t b;
      int16_t a;
#endif
   } chan;
};

static inline void
util_format_r16g16b16a16_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#else
         union util_format_r16g16b16a16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_sscaled pixel;
         pixel.chan.r = (int16_t)CLAMP(src[0], -32768.0f, 32767.0f);
         pixel.chan.g = (int16_t)CLAMP(src[1], -32768.0f, 32767.0f);
         pixel.chan.b = (int16_t)CLAMP(src[2], -32768.0f, 32767.0f);
         pixel.chan.a = (int16_t)CLAMP(src[3], -32768.0f, 32767.0f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_sscaled pixel;
         pixel.chan.r = (int16_t)CLAMP(src[0], -32768.0f, 32767.0f);
         pixel.chan.g = (int16_t)CLAMP(src[1], -32768.0f, 32767.0f);
         pixel.chan.b = (int16_t)CLAMP(src[2], -32768.0f, 32767.0f);
         pixel.chan.a = (int16_t)CLAMP(src[3], -32768.0f, 32767.0f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16a16_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#else
         union util_format_r16g16b16a16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r16g16b16a16_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.a, 0, 1)) * 0xff / 0x1); /* a */
#else
         union util_format_r16g16b16a16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.a, 0, 1)) * 0xff / 0x1); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_sscaled pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         pixel.chan.a = (int16_t)(((uint32_t)src[3]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_sscaled pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         pixel.chan.a = (int16_t)(((uint32_t)src[3]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8_unorm {
   uint8_t value;
   struct {
      uint8_t r;
   } chan;
};

static inline void
util_format_r8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= float_to_ubyte(src[0]);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= src[0];
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8_unorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
#else
      uint8_t r;
      uint8_t g;
#endif
   } chan;
};

static inline void
util_format_r8g8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = value >> 8;
         g = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (float_to_ubyte(src[0])) << 8;
         value |= (float_to_ubyte(src[1])) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (float_to_ubyte(src[0])) & 0xff;
         value |= (float_to_ubyte(src[1])) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = value >> 8;
         g = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = value >> 8;
         g = (value) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (src[0]) << 8;
         value |= (src[1]) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (src[0]) & 0xff;
         value |= (src[1]) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8_unorm {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
      uint8_t b;
#else
      uint8_t r;
      uint8_t g;
      uint8_t b;
#endif
   } chan;
};

static inline void
util_format_r8g8b8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = ubyte_to_float(pixel.chan.r); /* r */
         dst[1] = ubyte_to_float(pixel.chan.g); /* g */
         dst[2] = ubyte_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = ubyte_to_float(pixel.chan.r); /* r */
         dst[1] = ubyte_to_float(pixel.chan.g); /* g */
         dst[2] = ubyte_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_unorm pixel;
         pixel.chan.r = float_to_ubyte(src[0]);
         pixel.chan.g = float_to_ubyte(src[1]);
         pixel.chan.b = float_to_ubyte(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_unorm pixel;
         pixel.chan.r = float_to_ubyte(src[0]);
         pixel.chan.g = float_to_ubyte(src[1]);
         pixel.chan.b = float_to_ubyte(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = ubyte_to_float(pixel.chan.r); /* r */
         dst[1] = ubyte_to_float(pixel.chan.g); /* g */
         dst[2] = ubyte_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = ubyte_to_float(pixel.chan.r); /* r */
         dst[1] = ubyte_to_float(pixel.chan.g); /* g */
         dst[2] = ubyte_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8b8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r8g8b8_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 255; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_unorm pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_unorm pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8a8_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
#else
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
#endif
   } chan;
};

static inline void
util_format_r8g8b8a8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (float_to_ubyte(src[0])) << 24;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 16;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 8;
         value |= (float_to_ubyte(src[3])) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (float_to_ubyte(src[0])) & 0xff;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 16;
         value |= (float_to_ubyte(src[3])) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8a8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
}

static inline void
util_format_r8g8b8a8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (src[0]) << 24;
         value |= ((src[1]) & 0xff) << 16;
         value |= ((src[2]) & 0xff) << 8;
         value |= (src[3]) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (src[0]) & 0xff;
         value |= ((src[1]) & 0xff) << 8;
         value |= ((src[2]) & 0xff) << 16;
         value |= (src[3]) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8_uscaled {
   uint8_t value;
   struct {
      uint8_t r;
   } chan;
};

static inline void
util_format_r8_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)CLAMP(src[0], 0.0f, 255.0f);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r8_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8_uscaled {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
#else
      uint8_t r;
      uint8_t g;
#endif
   } chan;
};

static inline void
util_format_r8g8_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = value >> 8;
         g = (value) & 0xff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0.0f, 255.0f)) << 8;
         value |= ((uint8_t)CLAMP(src[1], 0.0f, 255.0f)) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0.0f, 255.0f)) & 0xff;
         value |= ((uint8_t)CLAMP(src[1], 0.0f, 255.0f)) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = value >> 8;
         g = (value) & 0xff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = value >> 8;
         g = (value) & 0xff;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) << 8;
         value |= ((uint8_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0xff;
         value |= ((uint8_t)(((uint32_t)src[1]) * 0x1 / 0xff)) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8_uscaled {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
      uint8_t b;
#else
      uint8_t r;
      uint8_t g;
      uint8_t b;
#endif
   } chan;
};

static inline void
util_format_r8g8b8_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_uscaled pixel;
         pixel.chan.r = (uint8_t)CLAMP(src[0], 0.0f, 255.0f);
         pixel.chan.g = (uint8_t)CLAMP(src[1], 0.0f, 255.0f);
         pixel.chan.b = (uint8_t)CLAMP(src[2], 0.0f, 255.0f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_uscaled pixel;
         pixel.chan.r = (uint8_t)CLAMP(src[0], 0.0f, 255.0f);
         pixel.chan.g = (uint8_t)CLAMP(src[1], 0.0f, 255.0f);
         pixel.chan.b = (uint8_t)CLAMP(src[2], 0.0f, 255.0f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8b8_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r8g8b8_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_uscaled pixel;
         pixel.chan.r = (uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint8_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint8_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_uscaled pixel;
         pixel.chan.r = (uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint8_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint8_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8a8_uscaled {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
#else
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
#endif
   } chan;
};

static inline void
util_format_r8g8b8a8_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0.0f, 255.0f)) << 24;
         value |= (((uint8_t)CLAMP(src[1], 0.0f, 255.0f)) & 0xff) << 16;
         value |= (((uint8_t)CLAMP(src[2], 0.0f, 255.0f)) & 0xff) << 8;
         value |= ((uint8_t)CLAMP(src[3], 0.0f, 255.0f)) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0.0f, 255.0f)) & 0xff;
         value |= (((uint8_t)CLAMP(src[1], 0.0f, 255.0f)) & 0xff) << 8;
         value |= (((uint8_t)CLAMP(src[2], 0.0f, 255.0f)) & 0xff) << 16;
         value |= ((uint8_t)CLAMP(src[3], 0.0f, 255.0f)) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8a8_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#endif
}

static inline void
util_format_r8g8b8a8_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MIN2(a, 1)) * 0xff / 0x1); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MIN2(a, 1)) * 0xff / 0x1); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) << 24;
         value |= (((uint8_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0xff) << 16;
         value |= (((uint8_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0xff) << 8;
         value |= ((uint8_t)(((uint32_t)src[3]) * 0x1 / 0xff)) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0xff;
         value |= (((uint8_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0xff) << 8;
         value |= (((uint8_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0xff) << 16;
         value |= ((uint8_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8_snorm {
   uint8_t value;
   struct {
      int8_t r;
   } chan;
};

static inline void
util_format_r8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(src[0] >> 1)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8_snorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t g;
#else
      int8_t r;
      int8_t g;
#endif
   } chan;
};

static inline void
util_format_r8g8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value) ) >> 8;
         g = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) << 8) ;
         value |= (uint16_t)(((int8_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7f)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) & 0xff) ;
         value |= (uint16_t)(((int8_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7f)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value) ) >> 8;
         g = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value) ) >> 8;
         g = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(src[0] >> 1)) << 8) ;
         value |= (uint16_t)(((int8_t)(src[1] >> 1)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(src[0] >> 1)) & 0xff) ;
         value |= (uint16_t)(((int8_t)(src[1] >> 1)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8_snorm {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t g;
      int8_t b;
#else
      int8_t r;
      int8_t g;
      int8_t b;
#endif
   } chan;
};

static inline void
util_format_r8g8b8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_snorm pixel;
         pixel.chan.r = (int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f);
         pixel.chan.g = (int8_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7f);
         pixel.chan.b = (int8_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x7f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_snorm pixel;
         pixel.chan.r = (int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f);
         pixel.chan.g = (int8_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7f);
         pixel.chan.b = (int8_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x7f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8b8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)MAX2(pixel.chan.r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(pixel.chan.g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(pixel.chan.b, 0)) * 0xff / 0x7f); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r8g8b8_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)MAX2(pixel.chan.r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(pixel.chan.g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(pixel.chan.b, 0)) * 0xff / 0x7f); /* b */
         dst[3] = 255; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_snorm pixel;
         pixel.chan.r = (int8_t)(src[0] >> 1);
         pixel.chan.g = (int8_t)(src[1] >> 1);
         pixel.chan.b = (int8_t)(src[2] >> 1);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_snorm pixel;
         pixel.chan.r = (int8_t)(src[0] >> 1);
         pixel.chan.g = (int8_t)(src[1] >> 1);
         pixel.chan.b = (int8_t)(src[2] >> 1);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8a8_snorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t g;
      int8_t b;
      int8_t a;
#else
      int8_t r;
      int8_t g;
      int8_t b;
      int8_t a;
#endif
   } chan;
};

static inline void
util_format_r8g8b8a8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         a = ((int32_t)(value << 24) ) >> 24;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(b * (1.0f/0x7f)); /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(b * (1.0f/0x7f)); /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) << 24) ;
         value |= (uint32_t)((((int8_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7f)) & 0xff) << 16) ;
         value |= (uint32_t)((((int8_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x7f)) & 0xff) << 8) ;
         value |= (uint32_t)(((int8_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7f)) & 0xff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) & 0xff) ;
         value |= (uint32_t)((((int8_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7f)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x7f)) & 0xff) << 16) ;
         value |= (uint32_t)(((int8_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7f)) << 24) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8a8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         a = ((int32_t)(value << 24) ) >> 24;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(b * (1.0f/0x7f)); /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(b * (1.0f/0x7f)); /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
#endif
}

static inline void
util_format_r8g8b8a8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         a = ((int32_t)(value << 24) ) >> 24;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(b, 0)) * 0xff / 0x7f); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x7f); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(b, 0)) * 0xff / 0x7f); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x7f); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)(src[0] >> 1)) << 24) ;
         value |= (uint32_t)((((int8_t)(src[1] >> 1)) & 0xff) << 16) ;
         value |= (uint32_t)((((int8_t)(src[2] >> 1)) & 0xff) << 8) ;
         value |= (uint32_t)(((int8_t)(src[3] >> 1)) & 0xff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)(src[0] >> 1)) & 0xff) ;
         value |= (uint32_t)((((int8_t)(src[1] >> 1)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)(src[2] >> 1)) & 0xff) << 16) ;
         value |= (uint32_t)(((int8_t)(src[3] >> 1)) << 24) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8_sscaled {
   uint8_t value;
   struct {
      int8_t r;
   } chan;
};

static inline void
util_format_r8_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)CLAMP(src[0], -128.0f, 127.0f)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r8_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8_sscaled {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t g;
#else
      int8_t r;
      int8_t g;
#endif
   } chan;
};

static inline void
util_format_r8g8_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value) ) >> 8;
         g = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)CLAMP(src[0], -128.0f, 127.0f)) << 8) ;
         value |= (uint16_t)(((int8_t)CLAMP(src[1], -128.0f, 127.0f)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)CLAMP(src[0], -128.0f, 127.0f)) & 0xff) ;
         value |= (uint16_t)(((int8_t)CLAMP(src[1], -128.0f, 127.0f)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value) ) >> 8;
         g = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value) ) >> 8;
         g = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) << 8) ;
         value |= (uint16_t)(((int8_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0xff) ;
         value |= (uint16_t)(((int8_t)(((uint32_t)src[1]) * 0x1 / 0xff)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8_sscaled {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t g;
      int8_t b;
#else
      int8_t r;
      int8_t g;
      int8_t b;
#endif
   } chan;
};

static inline void
util_format_r8g8b8_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_sscaled pixel;
         pixel.chan.r = (int8_t)CLAMP(src[0], -128.0f, 127.0f);
         pixel.chan.g = (int8_t)CLAMP(src[1], -128.0f, 127.0f);
         pixel.chan.b = (int8_t)CLAMP(src[2], -128.0f, 127.0f);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_sscaled pixel;
         pixel.chan.r = (int8_t)CLAMP(src[0], -128.0f, 127.0f);
         pixel.chan.g = (int8_t)CLAMP(src[1], -128.0f, 127.0f);
         pixel.chan.b = (int8_t)CLAMP(src[2], -128.0f, 127.0f);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8b8_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r8g8b8_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_sscaled pixel;
         pixel.chan.r = (int8_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int8_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int8_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_sscaled pixel;
         pixel.chan.r = (int8_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int8_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int8_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8a8_sscaled {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t g;
      int8_t b;
      int8_t a;
#else
      int8_t r;
      int8_t g;
      int8_t b;
      int8_t a;
#endif
   } chan;
};

static inline void
util_format_r8g8b8a8_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         a = ((int32_t)(value << 24) ) >> 24;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)CLAMP(src[0], -128.0f, 127.0f)) << 24) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[1], -128.0f, 127.0f)) & 0xff) << 16) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[2], -128.0f, 127.0f)) & 0xff) << 8) ;
         value |= (uint32_t)(((int8_t)CLAMP(src[3], -128.0f, 127.0f)) & 0xff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)CLAMP(src[0], -128.0f, 127.0f)) & 0xff) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[1], -128.0f, 127.0f)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[2], -128.0f, 127.0f)) & 0xff) << 16) ;
         value |= (uint32_t)(((int8_t)CLAMP(src[3], -128.0f, 127.0f)) << 24) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8a8_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         a = ((int32_t)(value << 24) ) >> 24;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#endif
}

static inline void
util_format_r8g8b8a8_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         a = ((int32_t)(value << 24) ) >> 24;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)CLAMP(a, 0, 1)) * 0xff / 0x1); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)CLAMP(a, 0, 1)) * 0xff / 0x1); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) << 24) ;
         value |= (uint32_t)((((int8_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0xff) << 16) ;
         value |= (uint32_t)((((int8_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0xff) << 8) ;
         value |= (uint32_t)(((int8_t)(((uint32_t)src[3]) * 0x1 / 0xff)) & 0xff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0xff) ;
         value |= (uint32_t)((((int8_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0xff) << 16) ;
         value |= (uint32_t)(((int8_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 24) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_fixed {
   uint32_t value;
   struct {
      int32_t r;
   } chan;
};

static inline void
util_format_r32_fixed_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_fixed_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_fixed pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -65536.0f, 65535.0f) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32_fixed_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r32_fixed_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround((CLAMP(pixel.chan.r, 0, 65536) * (1.0/0x10000)) * 0xff); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_fixed_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_fixed pixel;
         pixel.chan.r = (int32_t)((float)(src[0] * (1.0f/0xff)) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_fixed {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
#else
      int32_t r;
      int32_t g;
#endif
   } chan;
};

static inline void
util_format_r32g32_fixed_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_fixed_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_fixed pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -65536.0f, 65535.0f) * (double)0x10000);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -65536.0f, 65535.0f) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_fixed pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -65536.0f, 65535.0f) * (double)0x10000);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -65536.0f, 65535.0f) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32_fixed_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32_fixed_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround((CLAMP(pixel.chan.r, 0, 65536) * (1.0/0x10000)) * 0xff); /* r */
         dst[1] = (uint8_t)util_iround((CLAMP(pixel.chan.g, 0, 65536) * (1.0/0x10000)) * 0xff); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround((CLAMP(pixel.chan.r, 0, 65536) * (1.0/0x10000)) * 0xff); /* r */
         dst[1] = (uint8_t)util_iround((CLAMP(pixel.chan.g, 0, 65536) * (1.0/0x10000)) * 0xff); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_fixed_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_fixed pixel;
         pixel.chan.r = (int32_t)((float)(src[0] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.g = (int32_t)((float)(src[1] * (1.0f/0xff)) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_fixed pixel;
         pixel.chan.r = (int32_t)((float)(src[0] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.g = (int32_t)((float)(src[1] * (1.0f/0xff)) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_fixed {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
      int32_t b;
#else
      int32_t r;
      int32_t g;
      int32_t b;
#endif
   } chan;
};

static inline void
util_format_r32g32b32_fixed_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x10000)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x10000)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_fixed_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_fixed pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -65536.0f, 65535.0f) * (double)0x10000);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -65536.0f, 65535.0f) * (double)0x10000);
         pixel.chan.b = (int32_t)(CLAMP(src[2], -65536.0f, 65535.0f) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_fixed pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -65536.0f, 65535.0f) * (double)0x10000);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -65536.0f, 65535.0f) * (double)0x10000);
         pixel.chan.b = (int32_t)(CLAMP(src[2], -65536.0f, 65535.0f) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32_fixed_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x10000)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x10000)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32b32_fixed_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround((CLAMP(pixel.chan.r, 0, 65536) * (1.0/0x10000)) * 0xff); /* r */
         dst[1] = (uint8_t)util_iround((CLAMP(pixel.chan.g, 0, 65536) * (1.0/0x10000)) * 0xff); /* g */
         dst[2] = (uint8_t)util_iround((CLAMP(pixel.chan.b, 0, 65536) * (1.0/0x10000)) * 0xff); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32b32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround((CLAMP(pixel.chan.r, 0, 65536) * (1.0/0x10000)) * 0xff); /* r */
         dst[1] = (uint8_t)util_iround((CLAMP(pixel.chan.g, 0, 65536) * (1.0/0x10000)) * 0xff); /* g */
         dst[2] = (uint8_t)util_iround((CLAMP(pixel.chan.b, 0, 65536) * (1.0/0x10000)) * 0xff); /* b */
         dst[3] = 255; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_fixed_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_fixed pixel;
         pixel.chan.r = (int32_t)((float)(src[0] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.g = (int32_t)((float)(src[1] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.b = (int32_t)((float)(src[2] * (1.0f/0xff)) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_fixed pixel;
         pixel.chan.r = (int32_t)((float)(src[0] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.g = (int32_t)((float)(src[1] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.b = (int32_t)((float)(src[2] * (1.0f/0xff)) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_fixed {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
#else
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
#endif
   } chan;
};

static inline void
util_format_r32g32b32a32_fixed_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x10000)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0x10000)); /* a */
#else
         union util_format_r32g32b32a32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x10000)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0x10000)); /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_fixed_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_fixed pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -65536.0f, 65535.0f) * (double)0x10000);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -65536.0f, 65535.0f) * (double)0x10000);
         pixel.chan.b = (int32_t)(CLAMP(src[2], -65536.0f, 65535.0f) * (double)0x10000);
         pixel.chan.a = (int32_t)(CLAMP(src[3], -65536.0f, 65535.0f) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_fixed pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -65536.0f, 65535.0f) * (double)0x10000);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -65536.0f, 65535.0f) * (double)0x10000);
         pixel.chan.b = (int32_t)(CLAMP(src[2], -65536.0f, 65535.0f) * (double)0x10000);
         pixel.chan.a = (int32_t)(CLAMP(src[3], -65536.0f, 65535.0f) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32a32_fixed_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x10000)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0x10000)); /* a */
#else
         union util_format_r32g32b32a32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x10000)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0x10000)); /* a */
#endif
}

static inline void
util_format_r32g32b32a32_fixed_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround((CLAMP(pixel.chan.r, 0, 65536) * (1.0/0x10000)) * 0xff); /* r */
         dst[1] = (uint8_t)util_iround((CLAMP(pixel.chan.g, 0, 65536) * (1.0/0x10000)) * 0xff); /* g */
         dst[2] = (uint8_t)util_iround((CLAMP(pixel.chan.b, 0, 65536) * (1.0/0x10000)) * 0xff); /* b */
         dst[3] = (uint8_t)util_iround((CLAMP(pixel.chan.a, 0, 65536) * (1.0/0x10000)) * 0xff); /* a */
#else
         union util_format_r32g32b32a32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)util_iround((CLAMP(pixel.chan.r, 0, 65536) * (1.0/0x10000)) * 0xff); /* r */
         dst[1] = (uint8_t)util_iround((CLAMP(pixel.chan.g, 0, 65536) * (1.0/0x10000)) * 0xff); /* g */
         dst[2] = (uint8_t)util_iround((CLAMP(pixel.chan.b, 0, 65536) * (1.0/0x10000)) * 0xff); /* b */
         dst[3] = (uint8_t)util_iround((CLAMP(pixel.chan.a, 0, 65536) * (1.0/0x10000)) * 0xff); /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_fixed_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_fixed pixel;
         pixel.chan.r = (int32_t)((float)(src[0] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.g = (int32_t)((float)(src[1] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.b = (int32_t)((float)(src[2] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.a = (int32_t)((float)(src[3] * (1.0f/0xff)) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_fixed pixel;
         pixel.chan.r = (int32_t)((float)(src[0] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.g = (int32_t)((float)(src[1] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.b = (int32_t)((float)(src[2] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.a = (int32_t)((float)(src[3] * (1.0f/0xff)) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10g10b10x2_uscaled {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned x:2;
      unsigned b:10;
      unsigned g:10;
      unsigned r:10;
#else
      unsigned r:10;
      unsigned g:10;
      unsigned b:10;
      unsigned x:2;
#endif
   } chan;
};

static inline void
util_format_r10g10b10x2_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value) & 0x3ff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10x2_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (((uint32_t)CLAMP(src[2], 0.0f, 1023.0f)) & 0x3ff) << 20;
         value |= (((uint32_t)CLAMP(src[1], 0.0f, 1023.0f)) & 0x3ff) << 10;
         value |= ((uint32_t)CLAMP(src[0], 0.0f, 1023.0f)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)CLAMP(src[0], 0.0f, 1023.0f)) & 0x3ff;
         value |= (((uint32_t)CLAMP(src[1], 0.0f, 1023.0f)) & 0x3ff) << 10;
         value |= (((uint32_t)CLAMP(src[2], 0.0f, 1023.0f)) & 0x3ff) << 20;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r10g10b10x2_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value) & 0x3ff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r10g10b10x2_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value) & 0x3ff;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(b, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(b, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10x2_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (((uint32_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0x3ff) << 20;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0x3ff) << 10;
         value |= ((uint32_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0x3ff;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0x3ff) << 10;
         value |= (((uint32_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0x3ff) << 20;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10g10b10x2_snorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned x:2;
      int b:10;
      int g:10;
      int r:10;
#else
      int r:10;
      int g:10;
      int b:10;
      unsigned x:2;
#endif
   } chan;
};

static inline void
util_format_r10g10b10x2_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t b;
         int32_t g;
         int32_t r;
         b = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10x2_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 20) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 10) ;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 20) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r10g10b10x2_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t b;
         int32_t g;
         int32_t r;
         b = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r10g10b10x2_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t b;
         int32_t g;
         int32_t r;
         b = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 1); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 1); /* g */
         dst[2] = (uint8_t)(MAX2(b, 0) >> 1); /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 1); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 1); /* g */
         dst[2] = (uint8_t)(MAX2(b, 0) >> 1); /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10x2_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[2]) * 0x1ff / 0xff)) & 0x3ff) << 20) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1ff / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[0]) * 0x1ff / 0xff)) & 0x3ff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[0]) * 0x1ff / 0xff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1ff / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[2]) * 0x1ff / 0xff)) & 0x3ff) << 20) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a4r4_unorm {
   uint8_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned r:4;
      unsigned a:4;
#else
      unsigned a:4;
      unsigned r:4;
#endif
   } chan;
};

static inline void
util_format_a4r4_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         uint8_t a;
         r = value >> 4;
         a = (value) & 0xf;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#else
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         uint8_t r;
         a = (value) & 0xf;
         r = value >> 4;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#endif
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a4r4_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = 0;
         value |= ((uint8_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xf)) << 4;
         value |= ((uint8_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xf)) & 0xf;
         *(uint8_t *)dst = value;
#else
         uint8_t value = 0;
         value |= ((uint8_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xf)) & 0xf;
         value |= ((uint8_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xf)) << 4;
         *(uint8_t *)dst = value;
#endif
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a4r4_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         uint8_t a;
         r = value >> 4;
         a = (value) & 0xf;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#else
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         uint8_t r;
         a = (value) & 0xf;
         r = value >> 4;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#endif
}

static inline void
util_format_a4r4_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         uint8_t a;
         r = value >> 4;
         a = (value) & 0xf;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0xf); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0xf); /* a */
#else
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         uint8_t r;
         a = (value) & 0xf;
         r = value >> 4;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0xf); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0xf); /* a */
#endif
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a4r4_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = 0;
         value |= ((uint8_t)(src[0] >> 4)) << 4;
         value |= ((uint8_t)(src[3] >> 4)) & 0xf;
         *(uint8_t *)dst = value;
#else
         uint8_t value = 0;
         value |= ((uint8_t)(src[3] >> 4)) & 0xf;
         value |= ((uint8_t)(src[0] >> 4)) << 4;
         *(uint8_t *)dst = value;
#endif
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r4a4_unorm {
   uint8_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned a:4;
      unsigned r:4;
#else
      unsigned r:4;
      unsigned a:4;
#endif
   } chan;
};

static inline void
util_format_r4a4_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         uint8_t r;
         a = value >> 4;
         r = (value) & 0xf;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#else
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         uint8_t a;
         r = (value) & 0xf;
         a = value >> 4;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#endif
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r4a4_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = 0;
         value |= ((uint8_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xf)) << 4;
         value |= ((uint8_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xf)) & 0xf;
         *(uint8_t *)dst = value;
#else
         uint8_t value = 0;
         value |= ((uint8_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xf)) & 0xf;
         value |= ((uint8_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xf)) << 4;
         *(uint8_t *)dst = value;
#endif
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r4a4_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         uint8_t r;
         a = value >> 4;
         r = (value) & 0xf;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#else
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         uint8_t a;
         r = (value) & 0xf;
         a = value >> 4;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
#endif
}

static inline void
util_format_r4a4_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         uint8_t r;
         a = value >> 4;
         r = (value) & 0xf;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0xf); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0xf); /* a */
#else
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         uint8_t a;
         r = (value) & 0xf;
         a = value >> 4;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0xf); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0xf); /* a */
#endif
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r4a4_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint8_t value = 0;
         value |= ((uint8_t)(src[3] >> 4)) << 4;
         value |= ((uint8_t)(src[0] >> 4)) & 0xf;
         *(uint8_t *)dst = value;
#else
         uint8_t value = 0;
         value |= ((uint8_t)(src[0] >> 4)) & 0xf;
         value |= ((uint8_t)(src[3] >> 4)) << 4;
         *(uint8_t *)dst = value;
#endif
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8a8_unorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t a;
#else
      uint8_t r;
      uint8_t a;
#endif
   } chan;
};

static inline void
util_format_r8a8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t a;
         r = value >> 8;
         a = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t a;
         r = (value) & 0xff;
         a = value >> 8;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8a8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (float_to_ubyte(src[0])) << 8;
         value |= (float_to_ubyte(src[3])) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (float_to_ubyte(src[0])) & 0xff;
         value |= (float_to_ubyte(src[3])) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8a8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t a;
         r = value >> 8;
         a = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t a;
         r = (value) & 0xff;
         a = value >> 8;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
}

static inline void
util_format_r8a8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t a;
         r = value >> 8;
         a = (value) & 0xff;
         dst[0] = r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t a;
         r = (value) & 0xff;
         a = value >> 8;
         dst[0] = r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = a; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8a8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (src[0]) << 8;
         value |= (src[3]) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (src[0]) & 0xff;
         value |= (src[3]) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8r8_unorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t a;
      uint8_t r;
#else
      uint8_t a;
      uint8_t r;
#endif
   } chan;
};

static inline void
util_format_a8r8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         uint16_t r;
         a = value >> 8;
         r = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         uint16_t r;
         a = (value) & 0xff;
         r = value >> 8;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8r8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (float_to_ubyte(src[3])) << 8;
         value |= (float_to_ubyte(src[0])) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (float_to_ubyte(src[3])) & 0xff;
         value |= (float_to_ubyte(src[0])) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a8r8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         uint16_t r;
         a = value >> 8;
         r = (value) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = ubyte_to_float(a); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         uint16_t r;
         a = (value) & 0xff;
         r = value >> 8;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = ubyte_to_float(a); /* a */
#endif
}

static inline void
util_format_a8r8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         uint16_t r;
         a = value >> 8;
         r = (value) & 0xff;
         dst[0] = r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         uint16_t r;
         a = (value) & 0xff;
         r = value >> 8;
         dst[0] = r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = a; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8r8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (src[3]) << 8;
         value |= (src[0]) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (src[3]) & 0xff;
         value |= (src[0]) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10g10b10a2_uscaled {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned a:2;
      unsigned b:10;
      unsigned g:10;
      unsigned r:10;
#else
      unsigned r:10;
      unsigned g:10;
      unsigned b:10;
      unsigned a:2;
#endif
   } chan;
};

static inline void
util_format_r10g10b10a2_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 30;
         b = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value) & 0x3ff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10a2_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)CLAMP(src[3], 0.0f, 3.0f)) << 30;
         value |= (((uint32_t)CLAMP(src[2], 0.0f, 1023.0f)) & 0x3ff) << 20;
         value |= (((uint32_t)CLAMP(src[1], 0.0f, 1023.0f)) & 0x3ff) << 10;
         value |= ((uint32_t)CLAMP(src[0], 0.0f, 1023.0f)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)CLAMP(src[0], 0.0f, 1023.0f)) & 0x3ff;
         value |= (((uint32_t)CLAMP(src[1], 0.0f, 1023.0f)) & 0x3ff) << 10;
         value |= (((uint32_t)CLAMP(src[2], 0.0f, 1023.0f)) & 0x3ff) << 20;
         value |= ((uint32_t)CLAMP(src[3], 0.0f, 3.0f)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r10g10b10a2_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 30;
         b = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value) & 0x3ff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#endif
}

static inline void
util_format_r10g10b10a2_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 30;
         b = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value) & 0x3ff;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MIN2(a, 1)) * 0xff / 0x1); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MIN2(a, 1)) * 0xff / 0x1); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10a2_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 30;
         value |= (((uint32_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0x3ff) << 20;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0x3ff) << 10;
         value |= ((uint32_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0x3ff;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0x3ff) << 10;
         value |= (((uint32_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0x3ff) << 20;
         value |= ((uint32_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10g10b10a2_sscaled {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int a:2;
      int b:10;
      int g:10;
      int r:10;
#else
      int r:10;
      int g:10;
      int b:10;
      int a:2;
#endif
   } chan;
};

static inline void
util_format_r10g10b10a2_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         int32_t b;
         int32_t g;
         int32_t r;
         a = ((int32_t)(value) ) >> 30;
         b = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         a = ((int32_t)(value) ) >> 30;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10a2_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)CLAMP(src[3], -2.0f, 1.0f)) << 30) ;
         value |= (uint32_t)((((uint32_t)CLAMP(src[2], -512.0f, 511.0f)) & 0x3ff) << 20) ;
         value |= (uint32_t)((((uint32_t)CLAMP(src[1], -512.0f, 511.0f)) & 0x3ff) << 10) ;
         value |= (uint32_t)(((uint32_t)CLAMP(src[0], -512.0f, 511.0f)) & 0x3ff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)CLAMP(src[0], -512.0f, 511.0f)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)CLAMP(src[1], -512.0f, 511.0f)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)CLAMP(src[2], -512.0f, 511.0f)) & 0x3ff) << 20) ;
         value |= (uint32_t)(((uint32_t)CLAMP(src[3], -2.0f, 1.0f)) << 30) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r10g10b10a2_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         int32_t b;
         int32_t g;
         int32_t r;
         a = ((int32_t)(value) ) >> 30;
         b = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         a = ((int32_t)(value) ) >> 30;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#endif
}

static inline void
util_format_r10g10b10a2_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         int32_t b;
         int32_t g;
         int32_t r;
         a = ((int32_t)(value) ) >> 30;
         b = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x1); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         a = ((int32_t)(value) ) >> 30;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x1); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10a2_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 30) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0x3ff) << 20) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0x3ff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0x3ff) << 20) ;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 30) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10g10b10a2_snorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int a:2;
      int b:10;
      int g:10;
      int r:10;
#else
      int r:10;
      int g:10;
      int b:10;
      int a:2;
#endif
   } chan;
};

static inline void
util_format_r10g10b10a2_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         int32_t b;
         int32_t g;
         int32_t r;
         a = ((int32_t)(value) ) >> 30;
         b = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         a = ((int32_t)(value) ) >> 30;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10a2_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x1)) << 30) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 20) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 10) ;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 20) ;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x1)) << 30) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r10g10b10a2_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         int32_t b;
         int32_t g;
         int32_t r;
         a = ((int32_t)(value) ) >> 30;
         b = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         a = ((int32_t)(value) ) >> 30;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
#endif
}

static inline void
util_format_r10g10b10a2_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         int32_t b;
         int32_t g;
         int32_t r;
         a = ((int32_t)(value) ) >> 30;
         b = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 1); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 1); /* g */
         dst[2] = (uint8_t)(MAX2(b, 0) >> 1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x1); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         a = ((int32_t)(value) ) >> 30;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 1); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 1); /* g */
         dst[2] = (uint8_t)(MAX2(b, 0) >> 1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x1); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10a2_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(src[3] >> 7)) << 30) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[2]) * 0x1ff / 0xff)) & 0x3ff) << 20) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1ff / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[0]) * 0x1ff / 0xff)) & 0x3ff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[0]) * 0x1ff / 0xff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1ff / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[2]) * 0x1ff / 0xff)) & 0x3ff) << 20) ;
         value |= (uint32_t)(((uint32_t)(src[3] >> 7)) << 30) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b10g10r10a2_uscaled {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned a:2;
      unsigned r:10;
      unsigned g:10;
      unsigned b:10;
#else
      unsigned b:10;
      unsigned g:10;
      unsigned r:10;
      unsigned a:2;
#endif
   } chan;
};

static inline void
util_format_b10g10r10a2_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 30;
         r = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value) & 0x3ff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b10g10r10a2_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)CLAMP(src[3], 0.0f, 3.0f)) << 30;
         value |= (((uint32_t)CLAMP(src[0], 0.0f, 1023.0f)) & 0x3ff) << 20;
         value |= (((uint32_t)CLAMP(src[1], 0.0f, 1023.0f)) & 0x3ff) << 10;
         value |= ((uint32_t)CLAMP(src[2], 0.0f, 1023.0f)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)CLAMP(src[2], 0.0f, 1023.0f)) & 0x3ff;
         value |= (((uint32_t)CLAMP(src[1], 0.0f, 1023.0f)) & 0x3ff) << 10;
         value |= (((uint32_t)CLAMP(src[0], 0.0f, 1023.0f)) & 0x3ff) << 20;
         value |= ((uint32_t)CLAMP(src[3], 0.0f, 3.0f)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b10g10r10a2_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 30;
         r = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value) & 0x3ff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#endif
}

static inline void
util_format_b10g10r10a2_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 30;
         r = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value) & 0x3ff;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MIN2(a, 1)) * 0xff / 0x1); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MIN2(a, 1)) * 0xff / 0x1); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b10g10r10a2_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 30;
         value |= (((uint32_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0x3ff) << 20;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0x3ff) << 10;
         value |= ((uint32_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0x3ff;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0x3ff) << 10;
         value |= (((uint32_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0x3ff) << 20;
         value |= ((uint32_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b10g10r10a2_sscaled {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int a:2;
      int r:10;
      int g:10;
      int b:10;
#else
      int b:10;
      int g:10;
      int r:10;
      int a:2;
#endif
   } chan;
};

static inline void
util_format_b10g10r10a2_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         int32_t r;
         int32_t g;
         int32_t b;
         a = ((int32_t)(value) ) >> 30;
         r = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t b;
         int32_t g;
         int32_t r;
         int32_t a;
         b = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 2) ) >> 22;
         a = ((int32_t)(value) ) >> 30;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b10g10r10a2_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)CLAMP(src[3], -2.0f, 1.0f)) << 30) ;
         value |= (uint32_t)((((uint32_t)CLAMP(src[0], -512.0f, 511.0f)) & 0x3ff) << 20) ;
         value |= (uint32_t)((((uint32_t)CLAMP(src[1], -512.0f, 511.0f)) & 0x3ff) << 10) ;
         value |= (uint32_t)(((uint32_t)CLAMP(src[2], -512.0f, 511.0f)) & 0x3ff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)CLAMP(src[2], -512.0f, 511.0f)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)CLAMP(src[1], -512.0f, 511.0f)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)CLAMP(src[0], -512.0f, 511.0f)) & 0x3ff) << 20) ;
         value |= (uint32_t)(((uint32_t)CLAMP(src[3], -2.0f, 1.0f)) << 30) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b10g10r10a2_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         int32_t r;
         int32_t g;
         int32_t b;
         a = ((int32_t)(value) ) >> 30;
         r = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t b;
         int32_t g;
         int32_t r;
         int32_t a;
         b = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 2) ) >> 22;
         a = ((int32_t)(value) ) >> 30;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
#endif
}

static inline void
util_format_b10g10r10a2_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         int32_t r;
         int32_t g;
         int32_t b;
         a = ((int32_t)(value) ) >> 30;
         r = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x1); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t b;
         int32_t g;
         int32_t r;
         int32_t a;
         b = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 2) ) >> 22;
         a = ((int32_t)(value) ) >> 30;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x1); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b10g10r10a2_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 30) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0x3ff) << 20) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0x3ff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0x3ff) << 20) ;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 30) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b10g10r10a2_snorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int a:2;
      int r:10;
      int g:10;
      int b:10;
#else
      int b:10;
      int g:10;
      int r:10;
      int a:2;
#endif
   } chan;
};

static inline void
util_format_b10g10r10a2_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         int32_t r;
         int32_t g;
         int32_t b;
         a = ((int32_t)(value) ) >> 30;
         r = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t b;
         int32_t g;
         int32_t r;
         int32_t a;
         b = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 2) ) >> 22;
         a = ((int32_t)(value) ) >> 30;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b10g10r10a2_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x1)) << 30) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 20) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 10) ;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x1ff)) & 0x3ff) << 20) ;
         value |= (uint32_t)(((uint32_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x1)) << 30) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b10g10r10a2_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         int32_t r;
         int32_t g;
         int32_t b;
         a = ((int32_t)(value) ) >> 30;
         r = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t b;
         int32_t g;
         int32_t r;
         int32_t a;
         b = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 2) ) >> 22;
         a = ((int32_t)(value) ) >> 30;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
#endif
}

static inline void
util_format_b10g10r10a2_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         int32_t r;
         int32_t g;
         int32_t b;
         a = ((int32_t)(value) ) >> 30;
         r = ((int32_t)(value << 2) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 22) ) >> 22;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 1); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 1); /* g */
         dst[2] = (uint8_t)(MAX2(b, 0) >> 1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x1); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t b;
         int32_t g;
         int32_t r;
         int32_t a;
         b = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         r = ((int32_t)(value << 2) ) >> 22;
         a = ((int32_t)(value) ) >> 30;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 1); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 1); /* g */
         dst[2] = (uint8_t)(MAX2(b, 0) >> 1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x1); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b10g10r10a2_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(src[3] >> 7)) << 30) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[0]) * 0x1ff / 0xff)) & 0x3ff) << 20) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1ff / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[2]) * 0x1ff / 0xff)) & 0x3ff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[2]) * 0x1ff / 0xff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1ff / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[0]) * 0x1ff / 0xff)) & 0x3ff) << 20) ;
         value |= (uint32_t)(((uint32_t)(src[3] >> 7)) << 30) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8_uint {
   uint8_t value;
   struct {
      uint8_t r;
   } chan;
};

static inline void
util_format_r8_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (unsigned)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)MIN2(src[0], 255);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (unsigned)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r8_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)CLAMP(src[0], 0, 255);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8_uint {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
#else
      uint8_t r;
      uint8_t g;
#endif
   } chan;
};

static inline void
util_format_r8g8_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = value >> 8;
         g = (value) & 0xff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint8_t)MIN2(src[0], 255)) << 8;
         value |= ((uint8_t)MIN2(src[1], 255)) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint8_t)MIN2(src[0], 255)) & 0xff;
         value |= ((uint8_t)MIN2(src[1], 255)) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = value >> 8;
         g = (value) & 0xff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = value >> 8;
         g = (value) & 0xff;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0, 255)) << 8;
         value |= ((uint8_t)CLAMP(src[1], 0, 255)) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0, 255)) & 0xff;
         value |= ((uint8_t)CLAMP(src[1], 0, 255)) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8_uint {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
      uint8_t b;
#else
      uint8_t r;
      uint8_t g;
      uint8_t b;
#endif
   } chan;
};

static inline void
util_format_r8g8b8_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_uint pixel;
         pixel.chan.r = (uint8_t)MIN2(src[0], 255);
         pixel.chan.g = (uint8_t)MIN2(src[1], 255);
         pixel.chan.b = (uint8_t)MIN2(src[2], 255);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_uint pixel;
         pixel.chan.r = (uint8_t)MIN2(src[0], 255);
         pixel.chan.g = (uint8_t)MIN2(src[1], 255);
         pixel.chan.b = (uint8_t)MIN2(src[2], 255);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8b8_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_uint pixel;
         pixel.chan.r = (uint8_t)CLAMP(src[0], 0, 255);
         pixel.chan.g = (uint8_t)CLAMP(src[1], 0, 255);
         pixel.chan.b = (uint8_t)CLAMP(src[2], 0, 255);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_uint pixel;
         pixel.chan.r = (uint8_t)CLAMP(src[0], 0, 255);
         pixel.chan.g = (uint8_t)CLAMP(src[1], 0, 255);
         pixel.chan.b = (uint8_t)CLAMP(src[2], 0, 255);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8a8_uint {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
#else
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
#endif
   } chan;
};

static inline void
util_format_r8g8b8a8_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint8_t)MIN2(src[0], 255)) << 24;
         value |= (((uint8_t)MIN2(src[1], 255)) & 0xff) << 16;
         value |= (((uint8_t)MIN2(src[2], 255)) & 0xff) << 8;
         value |= ((uint8_t)MIN2(src[3], 255)) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint8_t)MIN2(src[0], 255)) & 0xff;
         value |= (((uint8_t)MIN2(src[1], 255)) & 0xff) << 8;
         value |= (((uint8_t)MIN2(src[2], 255)) & 0xff) << 16;
         value |= ((uint8_t)MIN2(src[3], 255)) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8a8_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
}

static inline void
util_format_r8g8b8a8_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         a = (value) & 0xff;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = (int)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = (int)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0, 255)) << 24;
         value |= (((uint8_t)CLAMP(src[1], 0, 255)) & 0xff) << 16;
         value |= (((uint8_t)CLAMP(src[2], 0, 255)) & 0xff) << 8;
         value |= ((uint8_t)CLAMP(src[3], 0, 255)) & 0xff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0, 255)) & 0xff;
         value |= (((uint8_t)CLAMP(src[1], 0, 255)) & 0xff) << 8;
         value |= (((uint8_t)CLAMP(src[2], 0, 255)) & 0xff) << 16;
         value |= ((uint8_t)CLAMP(src[3], 0, 255)) << 24;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8_sint {
   uint8_t value;
   struct {
      int8_t r;
   } chan;
};

static inline void
util_format_r8_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)CLAMP(src[0], -128, 127)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r8_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)MIN2(src[0], 127)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8_sint {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t g;
#else
      int8_t r;
      int8_t g;
#endif
   } chan;
};

static inline void
util_format_r8g8_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value) ) >> 8;
         g = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)CLAMP(src[0], -128, 127)) << 8) ;
         value |= (uint16_t)(((int8_t)CLAMP(src[1], -128, 127)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)CLAMP(src[0], -128, 127)) & 0xff) ;
         value |= (uint16_t)(((int8_t)CLAMP(src[1], -128, 127)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value) ) >> 8;
         g = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value) ) >> 8;
         g = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = (unsigned)MAX2(g, 0); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = (unsigned)MAX2(g, 0); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)MIN2(src[0], 127)) << 8) ;
         value |= (uint16_t)(((int8_t)MIN2(src[1], 127)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)MIN2(src[0], 127)) & 0xff) ;
         value |= (uint16_t)(((int8_t)MIN2(src[1], 127)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8_sint {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t g;
      int8_t b;
#else
      int8_t r;
      int8_t g;
      int8_t b;
#endif
   } chan;
};

static inline void
util_format_r8g8b8_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_sint pixel;
         pixel.chan.r = (int8_t)CLAMP(src[0], -128, 127);
         pixel.chan.g = (int8_t)CLAMP(src[1], -128, 127);
         pixel.chan.b = (int8_t)CLAMP(src[2], -128, 127);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_sint pixel;
         pixel.chan.r = (int8_t)CLAMP(src[0], -128, 127);
         pixel.chan.g = (int8_t)CLAMP(src[1], -128, 127);
         pixel.chan.b = (int8_t)CLAMP(src[2], -128, 127);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8b8_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r8g8b8_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = 1; /* a */
#endif
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r8g8b8_sint pixel;
         pixel.chan.r = (int8_t)MIN2(src[0], 127);
         pixel.chan.g = (int8_t)MIN2(src[1], 127);
         pixel.chan.b = (int8_t)MIN2(src[2], 127);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r8g8b8_sint pixel;
         pixel.chan.r = (int8_t)MIN2(src[0], 127);
         pixel.chan.g = (int8_t)MIN2(src[1], 127);
         pixel.chan.b = (int8_t)MIN2(src[2], 127);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8a8_sint {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t g;
      int8_t b;
      int8_t a;
#else
      int8_t r;
      int8_t g;
      int8_t b;
      int8_t a;
#endif
   } chan;
};

static inline void
util_format_r8g8b8a8_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         a = ((int32_t)(value << 24) ) >> 24;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = (int)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = (int)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)CLAMP(src[0], -128, 127)) << 24) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[1], -128, 127)) & 0xff) << 16) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[2], -128, 127)) & 0xff) << 8) ;
         value |= (uint32_t)(((int8_t)CLAMP(src[3], -128, 127)) & 0xff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)CLAMP(src[0], -128, 127)) & 0xff) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[1], -128, 127)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[2], -128, 127)) & 0xff) << 16) ;
         value |= (uint32_t)(((int8_t)CLAMP(src[3], -128, 127)) << 24) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8a8_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         a = ((int32_t)(value << 24) ) >> 24;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = (int)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = (int)a; /* a */
#endif
}

static inline void
util_format_r8g8b8a8_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         a = ((int32_t)(value << 24) ) >> 24;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = (unsigned)MAX2(g, 0); /* g */
         dst[2] = (unsigned)MAX2(b, 0); /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = (unsigned)MAX2(g, 0); /* g */
         dst[2] = (unsigned)MAX2(b, 0); /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8a8_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)MIN2(src[0], 127)) << 24) ;
         value |= (uint32_t)((((int8_t)MIN2(src[1], 127)) & 0xff) << 16) ;
         value |= (uint32_t)((((int8_t)MIN2(src[2], 127)) & 0xff) << 8) ;
         value |= (uint32_t)(((int8_t)MIN2(src[3], 127)) & 0xff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)MIN2(src[0], 127)) & 0xff) ;
         value |= (uint32_t)((((int8_t)MIN2(src[1], 127)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)MIN2(src[2], 127)) & 0xff) << 16) ;
         value |= (uint32_t)(((int8_t)MIN2(src[3], 127)) << 24) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16_uint {
   uint16_t value;
   struct {
      uint16_t r;
   } chan;
};

static inline void
util_format_r16_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         r = value;
         dst[0] = (unsigned)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)MIN2(src[0], 65535);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         r = value;
         dst[0] = (unsigned)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r16_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         r = value;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)CLAMP(src[0], 0, 65535);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16_uint {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
#else
      uint16_t r;
      uint16_t g;
#endif
   } chan;
};

static inline void
util_format_r16g16_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = value >> 16;
         g = (value) & 0xffff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)MIN2(src[0], 65535)) << 16;
         value |= ((uint16_t)MIN2(src[1], 65535)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)MIN2(src[0], 65535)) & 0xffff;
         value |= ((uint16_t)MIN2(src[1], 65535)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = value >> 16;
         g = (value) & 0xffff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = value >> 16;
         g = (value) & 0xffff;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)CLAMP(src[0], 0, 65535)) << 16;
         value |= ((uint16_t)CLAMP(src[1], 0, 65535)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)CLAMP(src[0], 0, 65535)) & 0xffff;
         value |= ((uint16_t)CLAMP(src[1], 0, 65535)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16_uint {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
      uint16_t b;
#else
      uint16_t r;
      uint16_t g;
      uint16_t b;
#endif
   } chan;
};

static inline void
util_format_r16g16b16_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_uint pixel;
         pixel.chan.r = (uint16_t)MIN2(src[0], 65535);
         pixel.chan.g = (uint16_t)MIN2(src[1], 65535);
         pixel.chan.b = (uint16_t)MIN2(src[2], 65535);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_uint pixel;
         pixel.chan.r = (uint16_t)MIN2(src[0], 65535);
         pixel.chan.g = (uint16_t)MIN2(src[1], 65535);
         pixel.chan.b = (uint16_t)MIN2(src[2], 65535);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16b16_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_uint pixel;
         pixel.chan.r = (uint16_t)CLAMP(src[0], 0, 65535);
         pixel.chan.g = (uint16_t)CLAMP(src[1], 0, 65535);
         pixel.chan.b = (uint16_t)CLAMP(src[2], 0, 65535);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_uint pixel;
         pixel.chan.r = (uint16_t)CLAMP(src[0], 0, 65535);
         pixel.chan.g = (uint16_t)CLAMP(src[1], 0, 65535);
         pixel.chan.b = (uint16_t)CLAMP(src[2], 0, 65535);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16a16_uint {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
#else
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
#endif
   } chan;
};

static inline void
util_format_r16g16b16a16_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = (unsigned)pixel.chan.a; /* a */
#else
         union util_format_r16g16b16a16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = (unsigned)pixel.chan.a; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_uint pixel;
         pixel.chan.r = (uint16_t)MIN2(src[0], 65535);
         pixel.chan.g = (uint16_t)MIN2(src[1], 65535);
         pixel.chan.b = (uint16_t)MIN2(src[2], 65535);
         pixel.chan.a = (uint16_t)MIN2(src[3], 65535);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_uint pixel;
         pixel.chan.r = (uint16_t)MIN2(src[0], 65535);
         pixel.chan.g = (uint16_t)MIN2(src[1], 65535);
         pixel.chan.b = (uint16_t)MIN2(src[2], 65535);
         pixel.chan.a = (uint16_t)MIN2(src[3], 65535);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16a16_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = (unsigned)pixel.chan.a; /* a */
#else
         union util_format_r16g16b16a16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = (unsigned)pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r16g16b16a16_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = (int)pixel.chan.a; /* a */
#else
         union util_format_r16g16b16a16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = (int)pixel.chan.a; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_uint pixel;
         pixel.chan.r = (uint16_t)CLAMP(src[0], 0, 65535);
         pixel.chan.g = (uint16_t)CLAMP(src[1], 0, 65535);
         pixel.chan.b = (uint16_t)CLAMP(src[2], 0, 65535);
         pixel.chan.a = (uint16_t)CLAMP(src[3], 0, 65535);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_uint pixel;
         pixel.chan.r = (uint16_t)CLAMP(src[0], 0, 65535);
         pixel.chan.g = (uint16_t)CLAMP(src[1], 0, 65535);
         pixel.chan.b = (uint16_t)CLAMP(src[2], 0, 65535);
         pixel.chan.a = (uint16_t)CLAMP(src[3], 0, 65535);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16_sint {
   uint16_t value;
   struct {
      int16_t r;
   } chan;
};

static inline void
util_format_r16_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         r = (int16_t)(value) ;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)CLAMP(src[0], -32768, 32767)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         r = (int16_t)(value) ;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r16_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         r = (int16_t)(value) ;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)MIN2(src[0], 32767)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16_sint {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t g;
#else
      int16_t r;
      int16_t g;
#endif
   } chan;
};

static inline void
util_format_r16g16_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value) ) >> 16;
         g = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)CLAMP(src[0], -32768, 32767)) << 16) ;
         value |= (uint32_t)(((int16_t)CLAMP(src[1], -32768, 32767)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)CLAMP(src[0], -32768, 32767)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)CLAMP(src[1], -32768, 32767)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value) ) >> 16;
         g = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value) ) >> 16;
         g = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = (unsigned)MAX2(g, 0); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = (unsigned)MAX2(g, 0); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)MIN2(src[0], 32767)) << 16) ;
         value |= (uint32_t)(((int16_t)MIN2(src[1], 32767)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)MIN2(src[0], 32767)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)MIN2(src[1], 32767)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16_sint {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t g;
      int16_t b;
#else
      int16_t r;
      int16_t g;
      int16_t b;
#endif
   } chan;
};

static inline void
util_format_r16g16b16_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_sint pixel;
         pixel.chan.r = (int16_t)CLAMP(src[0], -32768, 32767);
         pixel.chan.g = (int16_t)CLAMP(src[1], -32768, 32767);
         pixel.chan.b = (int16_t)CLAMP(src[2], -32768, 32767);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_sint pixel;
         pixel.chan.r = (int16_t)CLAMP(src[0], -32768, 32767);
         pixel.chan.g = (int16_t)CLAMP(src[1], -32768, 32767);
         pixel.chan.b = (int16_t)CLAMP(src[2], -32768, 32767);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16b16_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = 1; /* a */
#endif
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16_sint pixel;
         pixel.chan.r = (int16_t)MIN2(src[0], 32767);
         pixel.chan.g = (int16_t)MIN2(src[1], 32767);
         pixel.chan.b = (int16_t)MIN2(src[2], 32767);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16_sint pixel;
         pixel.chan.r = (int16_t)MIN2(src[0], 32767);
         pixel.chan.g = (int16_t)MIN2(src[1], 32767);
         pixel.chan.b = (int16_t)MIN2(src[2], 32767);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16a16_sint {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t g;
      int16_t b;
      int16_t a;
#else
      int16_t r;
      int16_t g;
      int16_t b;
      int16_t a;
#endif
   } chan;
};

static inline void
util_format_r16g16b16a16_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = (int)pixel.chan.a; /* a */
#else
         union util_format_r16g16b16a16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = (int)pixel.chan.a; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_sint pixel;
         pixel.chan.r = (int16_t)CLAMP(src[0], -32768, 32767);
         pixel.chan.g = (int16_t)CLAMP(src[1], -32768, 32767);
         pixel.chan.b = (int16_t)CLAMP(src[2], -32768, 32767);
         pixel.chan.a = (int16_t)CLAMP(src[3], -32768, 32767);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_sint pixel;
         pixel.chan.r = (int16_t)CLAMP(src[0], -32768, 32767);
         pixel.chan.g = (int16_t)CLAMP(src[1], -32768, 32767);
         pixel.chan.b = (int16_t)CLAMP(src[2], -32768, 32767);
         pixel.chan.a = (int16_t)CLAMP(src[3], -32768, 32767);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16a16_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = (int)pixel.chan.a; /* a */
#else
         union util_format_r16g16b16a16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = (int)pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r16g16b16a16_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = (unsigned)MAX2(pixel.chan.a, 0); /* a */
#else
         union util_format_r16g16b16a16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = (unsigned)MAX2(pixel.chan.a, 0); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16a16_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16a16_sint pixel;
         pixel.chan.r = (int16_t)MIN2(src[0], 32767);
         pixel.chan.g = (int16_t)MIN2(src[1], 32767);
         pixel.chan.b = (int16_t)MIN2(src[2], 32767);
         pixel.chan.a = (int16_t)MIN2(src[3], 32767);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16a16_sint pixel;
         pixel.chan.r = (int16_t)MIN2(src[0], 32767);
         pixel.chan.g = (int16_t)MIN2(src[1], 32767);
         pixel.chan.b = (int16_t)MIN2(src[2], 32767);
         pixel.chan.a = (int16_t)MIN2(src[3], 32767);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_uint {
   uint32_t value;
   struct {
      uint32_t r;
   } chan;
};

static inline void
util_format_r32_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         r = value;
         dst[0] = r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= src[0];
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         r = value;
         dst[0] = r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r32_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         r = value;
         dst[0] = (int)MIN2(r, 2147483647); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)MAX2(src[0], 0);
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_uint {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint32_t r;
      uint32_t g;
#else
      uint32_t r;
      uint32_t g;
#endif
   } chan;
};

static inline void
util_format_r32g32_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_uint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_uint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)MIN2(pixel.chan.r, 2147483647); /* r */
         dst[1] = (int)MIN2(pixel.chan.g, 2147483647); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)MIN2(pixel.chan.r, 2147483647); /* r */
         dst[1] = (int)MIN2(pixel.chan.g, 2147483647); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_uint pixel;
         pixel.chan.r = (uint32_t)MAX2(src[0], 0);
         pixel.chan.g = (uint32_t)MAX2(src[1], 0);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_uint pixel;
         pixel.chan.r = (uint32_t)MAX2(src[0], 0);
         pixel.chan.g = (uint32_t)MAX2(src[1], 0);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_uint {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint32_t r;
      uint32_t g;
      uint32_t b;
#else
      uint32_t r;
      uint32_t g;
      uint32_t b;
#endif
   } chan;
};

static inline void
util_format_r32g32b32_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_uint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_uint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32b32_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)MIN2(pixel.chan.r, 2147483647); /* r */
         dst[1] = (int)MIN2(pixel.chan.g, 2147483647); /* g */
         dst[2] = (int)MIN2(pixel.chan.b, 2147483647); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)MIN2(pixel.chan.r, 2147483647); /* r */
         dst[1] = (int)MIN2(pixel.chan.g, 2147483647); /* g */
         dst[2] = (int)MIN2(pixel.chan.b, 2147483647); /* b */
         dst[3] = 1; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_uint pixel;
         pixel.chan.r = (uint32_t)MAX2(src[0], 0);
         pixel.chan.g = (uint32_t)MAX2(src[1], 0);
         pixel.chan.b = (uint32_t)MAX2(src[2], 0);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_uint pixel;
         pixel.chan.r = (uint32_t)MAX2(src[0], 0);
         pixel.chan.g = (uint32_t)MAX2(src[1], 0);
         pixel.chan.b = (uint32_t)MAX2(src[2], 0);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_uint {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint32_t r;
      uint32_t g;
      uint32_t b;
      uint32_t a;
#else
      uint32_t r;
      uint32_t g;
      uint32_t b;
      uint32_t a;
#endif
   } chan;
};

static inline void
util_format_r32g32b32a32_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_r32g32b32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_uint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_uint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32a32_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_r32g32b32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r32g32b32a32_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)MIN2(pixel.chan.r, 2147483647); /* r */
         dst[1] = (int)MIN2(pixel.chan.g, 2147483647); /* g */
         dst[2] = (int)MIN2(pixel.chan.b, 2147483647); /* b */
         dst[3] = (int)MIN2(pixel.chan.a, 2147483647); /* a */
#else
         union util_format_r32g32b32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)MIN2(pixel.chan.r, 2147483647); /* r */
         dst[1] = (int)MIN2(pixel.chan.g, 2147483647); /* g */
         dst[2] = (int)MIN2(pixel.chan.b, 2147483647); /* b */
         dst[3] = (int)MIN2(pixel.chan.a, 2147483647); /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_uint pixel;
         pixel.chan.r = (uint32_t)MAX2(src[0], 0);
         pixel.chan.g = (uint32_t)MAX2(src[1], 0);
         pixel.chan.b = (uint32_t)MAX2(src[2], 0);
         pixel.chan.a = (uint32_t)MAX2(src[3], 0);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_uint pixel;
         pixel.chan.r = (uint32_t)MAX2(src[0], 0);
         pixel.chan.g = (uint32_t)MAX2(src[1], 0);
         pixel.chan.b = (uint32_t)MAX2(src[2], 0);
         pixel.chan.a = (uint32_t)MAX2(src[3], 0);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_sint {
   uint32_t value;
   struct {
      int32_t r;
   } chan;
};

static inline void
util_format_r32_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         r = (int32_t)(value) ;
         dst[0] = r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(src[0]) ;
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         r = (int32_t)(value) ;
         dst[0] = r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_r32_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         r = (int32_t)(value) ;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)((int32_t)MIN2(src[0], 2147483647)) ;
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_sint {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
#else
      int32_t r;
      int32_t g;
#endif
   } chan;
};

static inline void
util_format_r32g32_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_sint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_sint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32_sint pixel;
         pixel.chan.r = (int32_t)MIN2(src[0], 2147483647);
         pixel.chan.g = (int32_t)MIN2(src[1], 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32_sint pixel;
         pixel.chan.r = (int32_t)MIN2(src[0], 2147483647);
         pixel.chan.g = (int32_t)MIN2(src[1], 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_sint {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
      int32_t b;
#else
      int32_t r;
      int32_t g;
      int32_t b;
#endif
   } chan;
};

static inline void
util_format_r32g32b32_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_sint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_sint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32b32_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = 1; /* a */
#endif
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32_sint pixel;
         pixel.chan.r = (int32_t)MIN2(src[0], 2147483647);
         pixel.chan.g = (int32_t)MIN2(src[1], 2147483647);
         pixel.chan.b = (int32_t)MIN2(src[2], 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32_sint pixel;
         pixel.chan.r = (int32_t)MIN2(src[0], 2147483647);
         pixel.chan.g = (int32_t)MIN2(src[1], 2147483647);
         pixel.chan.b = (int32_t)MIN2(src[2], 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_sint {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
#else
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
#endif
   } chan;
};

static inline void
util_format_r32g32b32a32_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_r32g32b32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_sint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_sint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32a32_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_r32g32b32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r32g32b32a32_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = (unsigned)MAX2(pixel.chan.a, 0); /* a */
#else
         union util_format_r32g32b32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = (unsigned)MAX2(pixel.chan.a, 0); /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32a32_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32a32_sint pixel;
         pixel.chan.r = (int32_t)MIN2(src[0], 2147483647);
         pixel.chan.g = (int32_t)MIN2(src[1], 2147483647);
         pixel.chan.b = (int32_t)MIN2(src[2], 2147483647);
         pixel.chan.a = (int32_t)MIN2(src[3], 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32a32_sint pixel;
         pixel.chan.r = (int32_t)MIN2(src[0], 2147483647);
         pixel.chan.g = (int32_t)MIN2(src[1], 2147483647);
         pixel.chan.b = (int32_t)MIN2(src[2], 2147483647);
         pixel.chan.a = (int32_t)MIN2(src[3], 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8_uint {
   uint8_t value;
   struct {
      uint8_t a;
   } chan;
};

static inline void
util_format_a8_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)a; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)MIN2(src[3], 255);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a8_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)a; /* a */
}

static inline void
util_format_a8_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)CLAMP(src[3], 0, 255);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i8_uint {
   uint8_t value;
   struct {
      uint8_t rgba;
   } chan;
};

static inline void
util_format_i8_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgba;
         rgba = value;
         dst[0] = (unsigned)rgba; /* r */
         dst[1] = (unsigned)rgba; /* g */
         dst[2] = (unsigned)rgba; /* b */
         dst[3] = (unsigned)rgba; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i8_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)MIN2(src[0], 255);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_i8_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgba;
         rgba = value;
         dst[0] = (unsigned)rgba; /* r */
         dst[1] = (unsigned)rgba; /* g */
         dst[2] = (unsigned)rgba; /* b */
         dst[3] = (unsigned)rgba; /* a */
}

static inline void
util_format_i8_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgba;
         rgba = value;
         dst[0] = (int)rgba; /* r */
         dst[1] = (int)rgba; /* g */
         dst[2] = (int)rgba; /* b */
         dst[3] = (int)rgba; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i8_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)CLAMP(src[0], 0, 255);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8_uint {
   uint8_t value;
   struct {
      uint8_t rgb;
   } chan;
};

static inline void
util_format_l8_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = (unsigned)rgb; /* r */
         dst[1] = (unsigned)rgb; /* g */
         dst[2] = (unsigned)rgb; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)MIN2(src[0], 255);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l8_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = (unsigned)rgb; /* r */
         dst[1] = (unsigned)rgb; /* g */
         dst[2] = (unsigned)rgb; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l8_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)CLAMP(src[0], 0, 255);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8a8_uint {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t rgb;
      uint8_t a;
#else
      uint8_t rgb;
      uint8_t a;
#endif
   } chan;
};

static inline void
util_format_l8a8_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = value >> 8;
         a = (value) & 0xff;
         dst[0] = (unsigned)rgb; /* r */
         dst[1] = (unsigned)rgb; /* g */
         dst[2] = (unsigned)rgb; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = (unsigned)rgb; /* r */
         dst[1] = (unsigned)rgb; /* g */
         dst[2] = (unsigned)rgb; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8a8_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint8_t)MIN2(src[0], 255)) << 8;
         value |= ((uint8_t)MIN2(src[3], 255)) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint8_t)MIN2(src[0], 255)) & 0xff;
         value |= ((uint8_t)MIN2(src[3], 255)) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l8a8_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = value >> 8;
         a = (value) & 0xff;
         dst[0] = (unsigned)rgb; /* r */
         dst[1] = (unsigned)rgb; /* g */
         dst[2] = (unsigned)rgb; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = (unsigned)rgb; /* r */
         dst[1] = (unsigned)rgb; /* g */
         dst[2] = (unsigned)rgb; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
}

static inline void
util_format_l8a8_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = value >> 8;
         a = (value) & 0xff;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = (int)a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = (int)a; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8a8_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0, 255)) << 8;
         value |= ((uint8_t)CLAMP(src[3], 0, 255)) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0, 255)) & 0xff;
         value |= ((uint8_t)CLAMP(src[3], 0, 255)) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8_sint {
   uint8_t value;
   struct {
      int8_t a;
   } chan;
};

static inline void
util_format_a8_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t a;
         a = (int8_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)CLAMP(src[3], -128, 127)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a8_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t a;
         a = (int8_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
}

static inline void
util_format_a8_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t a;
         a = (int8_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a8_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)MIN2(src[3], 127)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i8_sint {
   uint8_t value;
   struct {
      int8_t rgba;
   } chan;
};

static inline void
util_format_i8_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t rgba;
         rgba = (int8_t)(value) ;
         dst[0] = (int)rgba; /* r */
         dst[1] = (int)rgba; /* g */
         dst[2] = (int)rgba; /* b */
         dst[3] = (int)rgba; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i8_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)CLAMP(src[0], -128, 127)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_i8_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t rgba;
         rgba = (int8_t)(value) ;
         dst[0] = (int)rgba; /* r */
         dst[1] = (int)rgba; /* g */
         dst[2] = (int)rgba; /* b */
         dst[3] = (int)rgba; /* a */
}

static inline void
util_format_i8_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t rgba;
         rgba = (int8_t)(value) ;
         dst[0] = (unsigned)MAX2(rgba, 0); /* r */
         dst[1] = (unsigned)MAX2(rgba, 0); /* g */
         dst[2] = (unsigned)MAX2(rgba, 0); /* b */
         dst[3] = (unsigned)MAX2(rgba, 0); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i8_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)MIN2(src[0], 127)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8_sint {
   uint8_t value;
   struct {
      int8_t rgb;
   } chan;
};

static inline void
util_format_l8_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t rgb;
         rgb = (int8_t)(value) ;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)CLAMP(src[0], -128, 127)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l8_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t rgb;
         rgb = (int8_t)(value) ;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l8_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t rgb;
         rgb = (int8_t)(value) ;
         dst[0] = (unsigned)MAX2(rgb, 0); /* r */
         dst[1] = (unsigned)MAX2(rgb, 0); /* g */
         dst[2] = (unsigned)MAX2(rgb, 0); /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)MIN2(src[0], 127)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8a8_sint {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t rgb;
      int8_t a;
#else
      int8_t rgb;
      int8_t a;
#endif
   } chan;
};

static inline void
util_format_l8a8_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
         rgb = ((int16_t)(value) ) >> 8;
         a = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = (int)a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
         rgb = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = (int)a; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8a8_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)CLAMP(src[0], -128, 127)) << 8) ;
         value |= (uint16_t)(((int8_t)CLAMP(src[3], -128, 127)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)CLAMP(src[0], -128, 127)) & 0xff) ;
         value |= (uint16_t)(((int8_t)CLAMP(src[3], -128, 127)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l8a8_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
         rgb = ((int16_t)(value) ) >> 8;
         a = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = (int)a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
         rgb = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = (int)a; /* a */
#endif
}

static inline void
util_format_l8a8_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
         rgb = ((int16_t)(value) ) >> 8;
         a = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (unsigned)MAX2(rgb, 0); /* r */
         dst[1] = (unsigned)MAX2(rgb, 0); /* g */
         dst[2] = (unsigned)MAX2(rgb, 0); /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
         rgb = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (unsigned)MAX2(rgb, 0); /* r */
         dst[1] = (unsigned)MAX2(rgb, 0); /* g */
         dst[2] = (unsigned)MAX2(rgb, 0); /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l8a8_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)MIN2(src[0], 127)) << 8) ;
         value |= (uint16_t)(((int8_t)MIN2(src[3], 127)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)MIN2(src[0], 127)) & 0xff) ;
         value |= (uint16_t)(((int8_t)MIN2(src[3], 127)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a16_uint {
   uint16_t value;
   struct {
      uint16_t a;
   } chan;
};

static inline void
util_format_a16_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)a; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a16_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)MIN2(src[3], 65535);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a16_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)a; /* a */
}

static inline void
util_format_a16_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a16_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)CLAMP(src[3], 0, 65535);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i16_uint {
   uint16_t value;
   struct {
      uint16_t rgba;
   } chan;
};

static inline void
util_format_i16_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgba;
         rgba = value;
         dst[0] = (unsigned)rgba; /* r */
         dst[1] = (unsigned)rgba; /* g */
         dst[2] = (unsigned)rgba; /* b */
         dst[3] = (unsigned)rgba; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i16_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)MIN2(src[0], 65535);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_i16_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgba;
         rgba = value;
         dst[0] = (unsigned)rgba; /* r */
         dst[1] = (unsigned)rgba; /* g */
         dst[2] = (unsigned)rgba; /* b */
         dst[3] = (unsigned)rgba; /* a */
}

static inline void
util_format_i16_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgba;
         rgba = value;
         dst[0] = (int)rgba; /* r */
         dst[1] = (int)rgba; /* g */
         dst[2] = (int)rgba; /* b */
         dst[3] = (int)rgba; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i16_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)CLAMP(src[0], 0, 65535);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16_uint {
   uint16_t value;
   struct {
      uint16_t rgb;
   } chan;
};

static inline void
util_format_l16_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         rgb = value;
         dst[0] = (unsigned)rgb; /* r */
         dst[1] = (unsigned)rgb; /* g */
         dst[2] = (unsigned)rgb; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)MIN2(src[0], 65535);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l16_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         rgb = value;
         dst[0] = (unsigned)rgb; /* r */
         dst[1] = (unsigned)rgb; /* g */
         dst[2] = (unsigned)rgb; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l16_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         rgb = value;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)CLAMP(src[0], 0, 65535);
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16a16_uint {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t rgb;
      uint16_t a;
#else
      uint16_t rgb;
      uint16_t a;
#endif
   } chan;
};

static inline void
util_format_l16a16_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
         rgb = value >> 16;
         a = (value) & 0xffff;
         dst[0] = (unsigned)rgb; /* r */
         dst[1] = (unsigned)rgb; /* g */
         dst[2] = (unsigned)rgb; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
         rgb = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (unsigned)rgb; /* r */
         dst[1] = (unsigned)rgb; /* g */
         dst[2] = (unsigned)rgb; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16a16_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)MIN2(src[0], 65535)) << 16;
         value |= ((uint16_t)MIN2(src[3], 65535)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)MIN2(src[0], 65535)) & 0xffff;
         value |= ((uint16_t)MIN2(src[3], 65535)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l16a16_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
         rgb = value >> 16;
         a = (value) & 0xffff;
         dst[0] = (unsigned)rgb; /* r */
         dst[1] = (unsigned)rgb; /* g */
         dst[2] = (unsigned)rgb; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
         rgb = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (unsigned)rgb; /* r */
         dst[1] = (unsigned)rgb; /* g */
         dst[2] = (unsigned)rgb; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
}

static inline void
util_format_l16a16_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
         rgb = value >> 16;
         a = (value) & 0xffff;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = (int)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
         rgb = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = (int)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16a16_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)CLAMP(src[0], 0, 65535)) << 16;
         value |= ((uint16_t)CLAMP(src[3], 0, 65535)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)CLAMP(src[0], 0, 65535)) & 0xffff;
         value |= ((uint16_t)CLAMP(src[3], 0, 65535)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a16_sint {
   uint16_t value;
   struct {
      int16_t a;
   } chan;
};

static inline void
util_format_a16_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t a;
         a = (int16_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a16_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)CLAMP(src[3], -32768, 32767)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a16_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t a;
         a = (int16_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
}

static inline void
util_format_a16_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t a;
         a = (int16_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a16_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)MIN2(src[3], 32767)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i16_sint {
   uint16_t value;
   struct {
      int16_t rgba;
   } chan;
};

static inline void
util_format_i16_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgba;
         rgba = (int16_t)(value) ;
         dst[0] = (int)rgba; /* r */
         dst[1] = (int)rgba; /* g */
         dst[2] = (int)rgba; /* b */
         dst[3] = (int)rgba; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i16_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)CLAMP(src[0], -32768, 32767)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_i16_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t rgba;
         rgba = (int16_t)(value) ;
         dst[0] = (int)rgba; /* r */
         dst[1] = (int)rgba; /* g */
         dst[2] = (int)rgba; /* b */
         dst[3] = (int)rgba; /* a */
}

static inline void
util_format_i16_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgba;
         rgba = (int16_t)(value) ;
         dst[0] = (unsigned)MAX2(rgba, 0); /* r */
         dst[1] = (unsigned)MAX2(rgba, 0); /* g */
         dst[2] = (unsigned)MAX2(rgba, 0); /* b */
         dst[3] = (unsigned)MAX2(rgba, 0); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i16_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)MIN2(src[0], 32767)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16_sint {
   uint16_t value;
   struct {
      int16_t rgb;
   } chan;
};

static inline void
util_format_l16_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         rgb = (int16_t)(value) ;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)CLAMP(src[0], -32768, 32767)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l16_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         rgb = (int16_t)(value) ;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l16_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         rgb = (int16_t)(value) ;
         dst[0] = (unsigned)MAX2(rgb, 0); /* r */
         dst[1] = (unsigned)MAX2(rgb, 0); /* g */
         dst[2] = (unsigned)MAX2(rgb, 0); /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)MIN2(src[0], 32767)) ;
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16a16_sint {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t rgb;
      int16_t a;
#else
      int16_t rgb;
      int16_t a;
#endif
   } chan;
};

static inline void
util_format_l16a16_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
         rgb = ((int32_t)(value) ) >> 16;
         a = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = (int)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
         rgb = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = (int)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16a16_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)CLAMP(src[0], -32768, 32767)) << 16) ;
         value |= (uint32_t)(((int16_t)CLAMP(src[3], -32768, 32767)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)CLAMP(src[0], -32768, 32767)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)CLAMP(src[3], -32768, 32767)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l16a16_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
         rgb = ((int32_t)(value) ) >> 16;
         a = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = (int)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
         rgb = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (int)rgb; /* r */
         dst[1] = (int)rgb; /* g */
         dst[2] = (int)rgb; /* b */
         dst[3] = (int)a; /* a */
#endif
}

static inline void
util_format_l16a16_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
         rgb = ((int32_t)(value) ) >> 16;
         a = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (unsigned)MAX2(rgb, 0); /* r */
         dst[1] = (unsigned)MAX2(rgb, 0); /* g */
         dst[2] = (unsigned)MAX2(rgb, 0); /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
         rgb = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (unsigned)MAX2(rgb, 0); /* r */
         dst[1] = (unsigned)MAX2(rgb, 0); /* g */
         dst[2] = (unsigned)MAX2(rgb, 0); /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l16a16_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)MIN2(src[0], 32767)) << 16) ;
         value |= (uint32_t)(((int16_t)MIN2(src[3], 32767)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)MIN2(src[0], 32767)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)MIN2(src[3], 32767)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a32_uint {
   uint32_t value;
   struct {
      uint32_t a;
   } chan;
};

static inline void
util_format_a32_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a32_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= src[3];
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a32_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = a; /* a */
}

static inline void
util_format_a32_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)MIN2(a, 2147483647); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a32_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)MAX2(src[3], 0);
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i32_uint {
   uint32_t value;
   struct {
      uint32_t rgba;
   } chan;
};

static inline void
util_format_i32_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgba;
         rgba = value;
         dst[0] = rgba; /* r */
         dst[1] = rgba; /* g */
         dst[2] = rgba; /* b */
         dst[3] = rgba; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i32_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= src[0];
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_i32_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgba;
         rgba = value;
         dst[0] = rgba; /* r */
         dst[1] = rgba; /* g */
         dst[2] = rgba; /* b */
         dst[3] = rgba; /* a */
}

static inline void
util_format_i32_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgba;
         rgba = value;
         dst[0] = (int)MIN2(rgba, 2147483647); /* r */
         dst[1] = (int)MIN2(rgba, 2147483647); /* g */
         dst[2] = (int)MIN2(rgba, 2147483647); /* b */
         dst[3] = (int)MIN2(rgba, 2147483647); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i32_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)MAX2(src[0], 0);
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l32_uint {
   uint32_t value;
   struct {
      uint32_t rgb;
   } chan;
};

static inline void
util_format_l32_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         rgb = value;
         dst[0] = rgb; /* r */
         dst[1] = rgb; /* g */
         dst[2] = rgb; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l32_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= src[0];
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l32_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         rgb = value;
         dst[0] = rgb; /* r */
         dst[1] = rgb; /* g */
         dst[2] = rgb; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l32_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         rgb = value;
         dst[0] = (int)MIN2(rgb, 2147483647); /* r */
         dst[1] = (int)MIN2(rgb, 2147483647); /* g */
         dst[2] = (int)MIN2(rgb, 2147483647); /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l32_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)MAX2(src[0], 0);
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l32a32_uint {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint32_t rgb;
      uint32_t a;
#else
      uint32_t rgb;
      uint32_t a;
#endif
   } chan;
};

static inline void
util_format_l32a32_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_l32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l32a32_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_uint pixel;
         pixel.chan.rgb = src[0];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_l32a32_uint pixel;
         pixel.chan.rgb = src[0];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l32a32_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_l32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
}

static inline void
util_format_l32a32_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)MIN2(pixel.chan.rgb, 2147483647); /* r */
         dst[1] = (int)MIN2(pixel.chan.rgb, 2147483647); /* g */
         dst[2] = (int)MIN2(pixel.chan.rgb, 2147483647); /* b */
         dst[3] = (int)MIN2(pixel.chan.a, 2147483647); /* a */
#else
         union util_format_l32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)MIN2(pixel.chan.rgb, 2147483647); /* r */
         dst[1] = (int)MIN2(pixel.chan.rgb, 2147483647); /* g */
         dst[2] = (int)MIN2(pixel.chan.rgb, 2147483647); /* b */
         dst[3] = (int)MIN2(pixel.chan.a, 2147483647); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l32a32_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_uint pixel;
         pixel.chan.rgb = (uint32_t)MAX2(src[0], 0);
         pixel.chan.a = (uint32_t)MAX2(src[3], 0);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_l32a32_uint pixel;
         pixel.chan.rgb = (uint32_t)MAX2(src[0], 0);
         pixel.chan.a = (uint32_t)MAX2(src[3], 0);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a32_sint {
   uint32_t value;
   struct {
      int32_t a;
   } chan;
};

static inline void
util_format_a32_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         a = (int32_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a32_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(src[3]) ;
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_a32_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         a = (int32_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = a; /* a */
}

static inline void
util_format_a32_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t a;
         a = (int32_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_a32_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)((int32_t)MIN2(src[3], 2147483647)) ;
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i32_sint {
   uint32_t value;
   struct {
      int32_t rgba;
   } chan;
};

static inline void
util_format_i32_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t rgba;
         rgba = (int32_t)(value) ;
         dst[0] = rgba; /* r */
         dst[1] = rgba; /* g */
         dst[2] = rgba; /* b */
         dst[3] = rgba; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i32_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(src[0]) ;
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_i32_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t rgba;
         rgba = (int32_t)(value) ;
         dst[0] = rgba; /* r */
         dst[1] = rgba; /* g */
         dst[2] = rgba; /* b */
         dst[3] = rgba; /* a */
}

static inline void
util_format_i32_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t rgba;
         rgba = (int32_t)(value) ;
         dst[0] = (unsigned)MAX2(rgba, 0); /* r */
         dst[1] = (unsigned)MAX2(rgba, 0); /* g */
         dst[2] = (unsigned)MAX2(rgba, 0); /* b */
         dst[3] = (unsigned)MAX2(rgba, 0); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_i32_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)((int32_t)MIN2(src[0], 2147483647)) ;
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l32_sint {
   uint32_t value;
   struct {
      int32_t rgb;
   } chan;
};

static inline void
util_format_l32_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         rgb = (int32_t)(value) ;
         dst[0] = rgb; /* r */
         dst[1] = rgb; /* g */
         dst[2] = rgb; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l32_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(src[0]) ;
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l32_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         rgb = (int32_t)(value) ;
         dst[0] = rgb; /* r */
         dst[1] = rgb; /* g */
         dst[2] = rgb; /* b */
         dst[3] = 1; /* a */
}

static inline void
util_format_l32_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         rgb = (int32_t)(value) ;
         dst[0] = (unsigned)MAX2(rgb, 0); /* r */
         dst[1] = (unsigned)MAX2(rgb, 0); /* g */
         dst[2] = (unsigned)MAX2(rgb, 0); /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l32_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)((int32_t)MIN2(src[0], 2147483647)) ;
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l32a32_sint {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t rgb;
      int32_t a;
#else
      int32_t rgb;
      int32_t a;
#endif
   } chan;
};

static inline void
util_format_l32a32_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_l32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l32a32_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_sint pixel;
         pixel.chan.rgb = src[0];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_l32a32_sint pixel;
         pixel.chan.rgb = src[0];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_l32a32_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_l32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
}

static inline void
util_format_l32a32_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.rgb, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.rgb, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.rgb, 0); /* b */
         dst[3] = (unsigned)MAX2(pixel.chan.a, 0); /* a */
#else
         union util_format_l32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.rgb, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.rgb, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.rgb, 0); /* b */
         dst[3] = (unsigned)MAX2(pixel.chan.a, 0); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_l32a32_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_l32a32_sint pixel;
         pixel.chan.rgb = (int32_t)MIN2(src[0], 2147483647);
         pixel.chan.a = (int32_t)MIN2(src[3], 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_l32a32_sint pixel;
         pixel.chan.rgb = (int32_t)MIN2(src[0], 2147483647);
         pixel.chan.a = (int32_t)MIN2(src[3], 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b10g10r10a2_uint {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned a:2;
      unsigned r:10;
      unsigned g:10;
      unsigned b:10;
#else
      unsigned b:10;
      unsigned g:10;
      unsigned r:10;
      unsigned a:2;
#endif
   } chan;
};

static inline void
util_format_b10g10r10a2_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 30;
         r = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value) & 0x3ff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b10g10r10a2_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)MIN2(src[3], 3)) << 30;
         value |= (((uint32_t)MIN2(src[0], 1023)) & 0x3ff) << 20;
         value |= (((uint32_t)MIN2(src[1], 1023)) & 0x3ff) << 10;
         value |= ((uint32_t)MIN2(src[2], 1023)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)MIN2(src[2], 1023)) & 0x3ff;
         value |= (((uint32_t)MIN2(src[1], 1023)) & 0x3ff) << 10;
         value |= (((uint32_t)MIN2(src[0], 1023)) & 0x3ff) << 20;
         value |= ((uint32_t)MIN2(src[3], 3)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b10g10r10a2_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 30;
         r = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value) & 0x3ff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
}

static inline void
util_format_b10g10r10a2_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         a = value >> 30;
         r = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value) & 0x3ff;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = (int)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = (int)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b10g10r10a2_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)CLAMP(src[3], 0, 3)) << 30;
         value |= (((uint32_t)CLAMP(src[0], 0, 1023)) & 0x3ff) << 20;
         value |= (((uint32_t)CLAMP(src[1], 0, 1023)) & 0x3ff) << 10;
         value |= ((uint32_t)CLAMP(src[2], 0, 1023)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)CLAMP(src[2], 0, 1023)) & 0x3ff;
         value |= (((uint32_t)CLAMP(src[1], 0, 1023)) & 0x3ff) << 10;
         value |= (((uint32_t)CLAMP(src[0], 0, 1023)) & 0x3ff) << 20;
         value |= ((uint32_t)CLAMP(src[3], 0, 3)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8x8_snorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t g;
      int8_t b;
      uint8_t x;
#else
      int8_t r;
      int8_t g;
      int8_t b;
      uint8_t x;
#endif
   } chan;
};

static inline void
util_format_r8g8b8x8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(b * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(b * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8x8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) << 24) ;
         value |= (uint32_t)((((int8_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7f)) & 0xff) << 16) ;
         value |= (uint32_t)((((int8_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x7f)) & 0xff) << 8) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) & 0xff) ;
         value |= (uint32_t)((((int8_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7f)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x7f)) & 0xff) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8x8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(b * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(b * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8b8x8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(b, 0)) * 0xff / 0x7f); /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(b, 0)) * 0xff / 0x7f); /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8x8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)(src[0] >> 1)) << 24) ;
         value |= (uint32_t)((((int8_t)(src[1] >> 1)) & 0xff) << 16) ;
         value |= (uint32_t)((((int8_t)(src[2] >> 1)) & 0xff) << 8) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)(src[0] >> 1)) & 0xff) ;
         value |= (uint32_t)((((int8_t)(src[1] >> 1)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)(src[2] >> 1)) & 0xff) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8x8_srgb {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t x;
#else
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t x;
#endif
   } chan;
};

static inline void
util_format_r8g8b8x8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8x8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) << 24;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff) << 8;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8x8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8b8x8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8x8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) << 24;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= ((util_format_linear_to_srgb_8unorm(src[2])) & 0xff) << 8;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) & 0xff;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[2])) & 0xff) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8x8_uint {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t x;
#else
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t x;
#endif
   } chan;
};

static inline void
util_format_r8g8b8x8_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8x8_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint8_t)MIN2(src[0], 255)) << 24;
         value |= (((uint8_t)MIN2(src[1], 255)) & 0xff) << 16;
         value |= (((uint8_t)MIN2(src[2], 255)) & 0xff) << 8;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint8_t)MIN2(src[0], 255)) & 0xff;
         value |= (((uint8_t)MIN2(src[1], 255)) & 0xff) << 8;
         value |= (((uint8_t)MIN2(src[2], 255)) & 0xff) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8x8_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8b8x8_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = value >> 24;
         g = (value >> 16) & 0xff;
         b = (value >> 8) & 0xff;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8x8_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0, 255)) << 24;
         value |= (((uint8_t)CLAMP(src[1], 0, 255)) & 0xff) << 16;
         value |= (((uint8_t)CLAMP(src[2], 0, 255)) & 0xff) << 8;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0, 255)) & 0xff;
         value |= (((uint8_t)CLAMP(src[1], 0, 255)) & 0xff) << 8;
         value |= (((uint8_t)CLAMP(src[2], 0, 255)) & 0xff) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8x8_sint {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t g;
      int8_t b;
      uint8_t x;
#else
      int8_t r;
      int8_t g;
      int8_t b;
      uint8_t x;
#endif
   } chan;
};

static inline void
util_format_r8g8b8x8_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8x8_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)CLAMP(src[0], -128, 127)) << 24) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[1], -128, 127)) & 0xff) << 16) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[2], -128, 127)) & 0xff) << 8) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)CLAMP(src[0], -128, 127)) & 0xff) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[1], -128, 127)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[2], -128, 127)) & 0xff) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8g8b8x8_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r8g8b8x8_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value) ) >> 24;
         g = ((int32_t)(value << 8) ) >> 24;
         b = ((int32_t)(value << 16) ) >> 24;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = (unsigned)MAX2(g, 0); /* g */
         dst[2] = (unsigned)MAX2(b, 0); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = (unsigned)MAX2(g, 0); /* g */
         dst[2] = (unsigned)MAX2(b, 0); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8g8b8x8_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)MIN2(src[0], 127)) << 24) ;
         value |= (uint32_t)((((int8_t)MIN2(src[1], 127)) & 0xff) << 16) ;
         value |= (uint32_t)((((int8_t)MIN2(src[2], 127)) & 0xff) << 8) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)MIN2(src[0], 127)) & 0xff) ;
         value |= (uint32_t)((((int8_t)MIN2(src[1], 127)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)MIN2(src[2], 127)) & 0xff) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b10g10r10x2_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned x:2;
      unsigned r:10;
      unsigned g:10;
      unsigned b:10;
#else
      unsigned b:10;
      unsigned g:10;
      unsigned r:10;
      unsigned x:2;
#endif
   } chan;
};

static inline void
util_format_b10g10r10x2_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value) & 0x3ff;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b10g10r10x2_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (((uint32_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x3ff)) & 0x3ff) << 20;
         value |= (((uint32_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x3ff)) & 0x3ff) << 10;
         value |= ((uint32_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x3ff)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0x3ff)) & 0x3ff;
         value |= (((uint32_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0x3ff)) & 0x3ff) << 10;
         value |= (((uint32_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0x3ff)) & 0x3ff) << 20;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b10g10r10x2_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value) & 0x3ff;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = 1; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_b10g10r10x2_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         r = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value) & 0x3ff;
         dst[0] = (uint8_t)(r >> 2); /* r */
         dst[1] = (uint8_t)(g >> 2); /* g */
         dst[2] = (uint8_t)(b >> 2); /* b */
         dst[3] = 255; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         dst[0] = (uint8_t)(r >> 2); /* r */
         dst[1] = (uint8_t)(g >> 2); /* g */
         dst[2] = (uint8_t)(b >> 2); /* b */
         dst[3] = 255; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b10g10r10x2_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (((uint32_t)(((uint32_t)src[0]) * 0x3ff / 0xff)) & 0x3ff) << 20;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x3ff / 0xff)) & 0x3ff) << 10;
         value |= ((uint32_t)(((uint32_t)src[2]) * 0x3ff / 0xff)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)(((uint32_t)src[2]) * 0x3ff / 0xff)) & 0x3ff;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x3ff / 0xff)) & 0x3ff) << 10;
         value |= (((uint32_t)(((uint32_t)src[0]) * 0x3ff / 0xff)) & 0x3ff) << 20;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16x16_unorm {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t x;
#else
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t x;
#endif
   } chan;
};

static inline void
util_format_r16g16b16x16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16x16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16x16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_unorm pixel;
         pixel.chan.r = (uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff);
         pixel.chan.g = (uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0xffff);
         pixel.chan.b = (uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0xffff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16x16_unorm pixel;
         pixel.chan.r = (uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff);
         pixel.chan.g = (uint16_t)util_iround(CLAMP(src[1], 0.0f, 1.0f) * 0xffff);
         pixel.chan.b = (uint16_t)util_iround(CLAMP(src[2], 0.0f, 1.0f) * 0xffff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16x16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16x16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16b16x16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 8); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 8); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 8); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r16g16b16x16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 8); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 8); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 8); /* b */
         dst[3] = 255; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16x16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_unorm pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0xffff / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0xffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16x16_unorm pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0xffff / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0xffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16x16_snorm {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t g;
      int16_t b;
      uint16_t x;
#else
      int16_t r;
      int16_t g;
      int16_t b;
      uint16_t x;
#endif
   } chan;
};

static inline void
util_format_r16g16b16x16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16x16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16x16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_snorm pixel;
         pixel.chan.r = (int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.g = (int16_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.b = (int16_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x7fff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16x16_snorm pixel;
         pixel.chan.r = (int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.g = (int16_t)util_iround(CLAMP(src[1], -1.0f, 1.0f) * 0x7fff);
         pixel.chan.b = (int16_t)util_iround(CLAMP(src[2], -1.0f, 1.0f) * 0x7fff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16x16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16x16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16b16x16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 7); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r16g16b16x16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 7); /* b */
         dst[3] = 255; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16x16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_snorm pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x7fff / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x7fff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16x16_snorm pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x7fff / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x7fff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16x16_float {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t x;
#else
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t x;
#endif
   } chan;
};

static inline void
util_format_r16g16b16x16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16x16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16x16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.g = util_float_to_half(src[1]);
         pixel.chan.b = util_float_to_half(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16x16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.g = util_float_to_half(src[1]);
         pixel.chan.b = util_float_to_half(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16x16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16x16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16b16x16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.g)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.b)); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r16g16b16x16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.g)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.b)); /* b */
         dst[3] = 255; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16x16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.g = util_float_to_half((float)(src[1] * (1.0f/0xff)));
         pixel.chan.b = util_float_to_half((float)(src[2] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16x16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.g = util_float_to_half((float)(src[1] * (1.0f/0xff)));
         pixel.chan.b = util_float_to_half((float)(src[2] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16x16_uint {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t x;
#else
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t x;
#endif
   } chan;
};

static inline void
util_format_r16g16b16x16_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16x16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16x16_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_uint pixel;
         pixel.chan.r = (uint16_t)MIN2(src[0], 65535);
         pixel.chan.g = (uint16_t)MIN2(src[1], 65535);
         pixel.chan.b = (uint16_t)MIN2(src[2], 65535);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16x16_uint pixel;
         pixel.chan.r = (uint16_t)MIN2(src[0], 65535);
         pixel.chan.g = (uint16_t)MIN2(src[1], 65535);
         pixel.chan.b = (uint16_t)MIN2(src[2], 65535);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16x16_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16x16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)pixel.chan.r; /* r */
         dst[1] = (unsigned)pixel.chan.g; /* g */
         dst[2] = (unsigned)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16b16x16_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16x16_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16x16_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_uint pixel;
         pixel.chan.r = (uint16_t)CLAMP(src[0], 0, 65535);
         pixel.chan.g = (uint16_t)CLAMP(src[1], 0, 65535);
         pixel.chan.b = (uint16_t)CLAMP(src[2], 0, 65535);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16x16_uint pixel;
         pixel.chan.r = (uint16_t)CLAMP(src[0], 0, 65535);
         pixel.chan.g = (uint16_t)CLAMP(src[1], 0, 65535);
         pixel.chan.b = (uint16_t)CLAMP(src[2], 0, 65535);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16x16_sint {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t g;
      int16_t b;
      uint16_t x;
#else
      int16_t r;
      int16_t g;
      int16_t b;
      uint16_t x;
#endif
   } chan;
};

static inline void
util_format_r16g16b16x16_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16x16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16x16_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_sint pixel;
         pixel.chan.r = (int16_t)CLAMP(src[0], -32768, 32767);
         pixel.chan.g = (int16_t)CLAMP(src[1], -32768, 32767);
         pixel.chan.b = (int16_t)CLAMP(src[2], -32768, 32767);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16x16_sint pixel;
         pixel.chan.r = (int16_t)CLAMP(src[0], -32768, 32767);
         pixel.chan.g = (int16_t)CLAMP(src[1], -32768, 32767);
         pixel.chan.b = (int16_t)CLAMP(src[2], -32768, 32767);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16g16b16x16_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16x16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)pixel.chan.r; /* r */
         dst[1] = (int)pixel.chan.g; /* g */
         dst[2] = (int)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r16g16b16x16_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r16g16b16x16_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = 1; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16g16b16x16_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16g16b16x16_sint pixel;
         pixel.chan.r = (int16_t)MIN2(src[0], 32767);
         pixel.chan.g = (int16_t)MIN2(src[1], 32767);
         pixel.chan.b = (int16_t)MIN2(src[2], 32767);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16g16b16x16_sint pixel;
         pixel.chan.r = (int16_t)MIN2(src[0], 32767);
         pixel.chan.g = (int16_t)MIN2(src[1], 32767);
         pixel.chan.b = (int16_t)MIN2(src[2], 32767);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32x32_float {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      float r;
      float g;
      float b;
      uint32_t x;
#else
      float r;
      float g;
      float b;
      uint32_t x;
#endif
   } chan;
};

static inline void
util_format_r32g32b32x32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32x32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32x32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32x32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32x32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32x32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32b32x32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = float_to_ubyte(pixel.chan.g); /* g */
         dst[2] = float_to_ubyte(pixel.chan.b); /* b */
         dst[3] = 255; /* a */
#else
         union util_format_r32g32b32x32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = float_to_ubyte(pixel.chan.g); /* g */
         dst[2] = float_to_ubyte(pixel.chan.b); /* b */
         dst[3] = 255; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32x32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.g = ubyte_to_float(src[1]);
         pixel.chan.b = ubyte_to_float(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32x32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.g = ubyte_to_float(src[1]);
         pixel.chan.b = ubyte_to_float(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32x32_uint {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint32_t r;
      uint32_t g;
      uint32_t b;
      uint32_t x;
#else
      uint32_t r;
      uint32_t g;
      uint32_t b;
      uint32_t x;
#endif
   } chan;
};

static inline void
util_format_r32g32b32x32_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32x32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32x32_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_uint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32x32_uint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32x32_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32x32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32b32x32_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)MIN2(pixel.chan.r, 2147483647); /* r */
         dst[1] = (int)MIN2(pixel.chan.g, 2147483647); /* g */
         dst[2] = (int)MIN2(pixel.chan.b, 2147483647); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32x32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)MIN2(pixel.chan.r, 2147483647); /* r */
         dst[1] = (int)MIN2(pixel.chan.g, 2147483647); /* g */
         dst[2] = (int)MIN2(pixel.chan.b, 2147483647); /* b */
         dst[3] = 1; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32x32_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_uint pixel;
         pixel.chan.r = (uint32_t)MAX2(src[0], 0);
         pixel.chan.g = (uint32_t)MAX2(src[1], 0);
         pixel.chan.b = (uint32_t)MAX2(src[2], 0);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32x32_uint pixel;
         pixel.chan.r = (uint32_t)MAX2(src[0], 0);
         pixel.chan.g = (uint32_t)MAX2(src[1], 0);
         pixel.chan.b = (uint32_t)MAX2(src[2], 0);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32x32_sint {
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t g;
      int32_t b;
      uint32_t x;
#else
      int32_t r;
      int32_t g;
      int32_t b;
      uint32_t x;
#endif
   } chan;
};

static inline void
util_format_r32g32b32x32_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32x32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32x32_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_sint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32x32_sint pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32g32b32x32_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32x32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_r32g32b32x32_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = 1; /* a */
#else
         union util_format_r32g32b32x32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = (unsigned)MAX2(pixel.chan.g, 0); /* g */
         dst[2] = (unsigned)MAX2(pixel.chan.b, 0); /* b */
         dst[3] = 1; /* a */
#endif
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32g32b32x32_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32g32b32x32_sint pixel;
         pixel.chan.r = (int32_t)MIN2(src[0], 2147483647);
         pixel.chan.g = (int32_t)MIN2(src[1], 2147483647);
         pixel.chan.b = (int32_t)MIN2(src[2], 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32g32b32x32_sint pixel;
         pixel.chan.r = (int32_t)MIN2(src[0], 2147483647);
         pixel.chan.g = (int32_t)MIN2(src[1], 2147483647);
         pixel.chan.b = (int32_t)MIN2(src[2], 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8a8_snorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t a;
#else
      int8_t r;
      int8_t a;
#endif
   } chan;
};

static inline void
util_format_r8a8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t a;
         r = ((int16_t)(value) ) >> 8;
         a = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t a;
         r = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8a8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) << 8) ;
         value |= (uint16_t)(((int8_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7f)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7f)) & 0xff) ;
         value |= (uint16_t)(((int8_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7f)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8a8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t a;
         r = ((int16_t)(value) ) >> 8;
         a = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t a;
         r = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
#endif
}

static inline void
util_format_r8a8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t a;
         r = ((int16_t)(value) ) >> 8;
         a = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x7f); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t a;
         r = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x7f); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8a8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(src[0] >> 1)) << 8) ;
         value |= (uint16_t)(((int8_t)(src[3] >> 1)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(src[0] >> 1)) & 0xff) ;
         value |= (uint16_t)(((int8_t)(src[3] >> 1)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16a16_unorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t a;
#else
      uint16_t r;
      uint16_t a;
#endif
   } chan;
};

static inline void
util_format_r16a16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t a;
         r = value >> 16;
         a = (value) & 0xffff;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t a;
         r = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16a16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff)) << 16;
         value |= ((uint16_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xffff)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)util_iround(CLAMP(src[0], 0.0f, 1.0f) * 0xffff)) & 0xffff;
         value |= ((uint16_t)util_iround(CLAMP(src[3], 0.0f, 1.0f) * 0xffff)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16a16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t a;
         r = value >> 16;
         a = (value) & 0xffff;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t a;
         r = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
#endif
}

static inline void
util_format_r16a16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t a;
         r = value >> 16;
         a = (value) & 0xffff;
         dst[0] = (uint8_t)(r >> 8); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(a >> 8); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t a;
         r = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (uint8_t)(r >> 8); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(a >> 8); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16a16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff)) << 16;
         value |= ((uint16_t)(((uint32_t)src[3]) * 0xffff / 0xff)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff)) & 0xffff;
         value |= ((uint16_t)(((uint32_t)src[3]) * 0xffff / 0xff)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16a16_snorm {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t a;
#else
      int16_t r;
      int16_t a;
#endif
   } chan;
};

static inline void
util_format_r16a16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t a;
         r = ((int32_t)(value) ) >> 16;
         a = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t a;
         r = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16a16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff)) << 16) ;
         value |= (uint32_t)(((int16_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7fff)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)util_iround(CLAMP(src[0], -1.0f, 1.0f) * 0x7fff)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)util_iround(CLAMP(src[3], -1.0f, 1.0f) * 0x7fff)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16a16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t a;
         r = ((int32_t)(value) ) >> 16;
         a = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t a;
         r = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
#endif
}

static inline void
util_format_r16a16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t a;
         r = ((int32_t)(value) ) >> 16;
         a = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 7); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(MAX2(a, 0) >> 7); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t a;
         r = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 7); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(MAX2(a, 0) >> 7); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16a16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff)) << 16) ;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[3]) * 0x7fff / 0xff)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[3]) * 0x7fff / 0xff)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16a16_float {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t a;
#else
      uint16_t r;
      uint16_t a;
#endif
   } chan;
};

static inline void
util_format_r16a16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
#else
         union util_format_r16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16a16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16a16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.a = util_float_to_half(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16a16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.a = util_float_to_half(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16a16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
#else
         union util_format_r16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
#endif
}

static inline void
util_format_r16a16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = float_to_ubyte(util_half_to_float(pixel.chan.a)); /* a */
#else
         union util_format_r16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = float_to_ubyte(util_half_to_float(pixel.chan.a)); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16a16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r16a16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.a = util_float_to_half((float)(src[3] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r16a16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.a = util_float_to_half((float)(src[3] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32a32_float {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      float r;
      float a;
#else
      float r;
      float a;
#endif
   } chan;
};

static inline void
util_format_r32a32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_r32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32a32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32a32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32a32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_r32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r32a32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = float_to_ubyte(pixel.chan.a); /* a */
#else
         union util_format_r32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = float_to_ubyte(pixel.chan.a); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32a32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.a = ubyte_to_float(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32a32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.a = ubyte_to_float(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8a8_uint {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t r;
      uint8_t a;
#else
      uint8_t r;
      uint8_t a;
#endif
   } chan;
};

static inline void
util_format_r8a8_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t a;
         r = value >> 8;
         a = (value) & 0xff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t a;
         r = (value) & 0xff;
         a = value >> 8;
         dst[0] = (unsigned)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8a8_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint8_t)MIN2(src[0], 255)) << 8;
         value |= ((uint8_t)MIN2(src[3], 255)) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint8_t)MIN2(src[0], 255)) & 0xff;
         value |= ((uint8_t)MIN2(src[3], 255)) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8a8_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t a;
         r = value >> 8;
         a = (value) & 0xff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t a;
         r = (value) & 0xff;
         a = value >> 8;
         dst[0] = (unsigned)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
}

static inline void
util_format_r8a8_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t a;
         r = value >> 8;
         a = (value) & 0xff;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t a;
         r = (value) & 0xff;
         a = value >> 8;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8a8_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0, 255)) << 8;
         value |= ((uint8_t)CLAMP(src[3], 0, 255)) & 0xff;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0, 255)) & 0xff;
         value |= ((uint8_t)CLAMP(src[3], 0, 255)) << 8;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8a8_sint {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int8_t r;
      int8_t a;
#else
      int8_t r;
      int8_t a;
#endif
   } chan;
};

static inline void
util_format_r8a8_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t a;
         r = ((int16_t)(value) ) >> 8;
         a = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t a;
         r = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8a8_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)CLAMP(src[0], -128, 127)) << 8) ;
         value |= (uint16_t)(((int8_t)CLAMP(src[3], -128, 127)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)CLAMP(src[0], -128, 127)) & 0xff) ;
         value |= (uint16_t)(((int8_t)CLAMP(src[3], -128, 127)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r8a8_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t a;
         r = ((int16_t)(value) ) >> 8;
         a = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t a;
         r = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
#endif
}

static inline void
util_format_r8a8_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t a;
         r = ((int16_t)(value) ) >> 8;
         a = ((int16_t)(value << 8) ) >> 8;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t a;
         r = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r8a8_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)MIN2(src[0], 127)) << 8) ;
         value |= (uint16_t)(((int8_t)MIN2(src[3], 127)) & 0xff) ;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)MIN2(src[0], 127)) & 0xff) ;
         value |= (uint16_t)(((int8_t)MIN2(src[3], 127)) << 8) ;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16a16_uint {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint16_t r;
      uint16_t a;
#else
      uint16_t r;
      uint16_t a;
#endif
   } chan;
};

static inline void
util_format_r16a16_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t a;
         r = value >> 16;
         a = (value) & 0xffff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t a;
         r = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (unsigned)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16a16_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)MIN2(src[0], 65535)) << 16;
         value |= ((uint16_t)MIN2(src[3], 65535)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)MIN2(src[0], 65535)) & 0xffff;
         value |= ((uint16_t)MIN2(src[3], 65535)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16a16_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t a;
         r = value >> 16;
         a = (value) & 0xffff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t a;
         r = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (unsigned)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
}

static inline void
util_format_r16a16_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t a;
         r = value >> 16;
         a = (value) & 0xffff;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t a;
         r = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16a16_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint16_t)CLAMP(src[0], 0, 65535)) << 16;
         value |= ((uint16_t)CLAMP(src[3], 0, 65535)) & 0xffff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint16_t)CLAMP(src[0], 0, 65535)) & 0xffff;
         value |= ((uint16_t)CLAMP(src[3], 0, 65535)) << 16;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16a16_sint {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int16_t r;
      int16_t a;
#else
      int16_t r;
      int16_t a;
#endif
   } chan;
};

static inline void
util_format_r16a16_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t a;
         r = ((int32_t)(value) ) >> 16;
         a = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t a;
         r = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16a16_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)CLAMP(src[0], -32768, 32767)) << 16) ;
         value |= (uint32_t)(((int16_t)CLAMP(src[3], -32768, 32767)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)CLAMP(src[0], -32768, 32767)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)CLAMP(src[3], -32768, 32767)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r16a16_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t a;
         r = ((int32_t)(value) ) >> 16;
         a = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t a;
         r = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (int)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)a; /* a */
#endif
}

static inline void
util_format_r16a16_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t a;
         r = ((int32_t)(value) ) >> 16;
         a = ((int32_t)(value << 16) ) >> 16;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t a;
         r = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (unsigned)MAX2(r, 0); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)MAX2(a, 0); /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r16a16_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)MIN2(src[0], 32767)) << 16) ;
         value |= (uint32_t)(((int16_t)MIN2(src[3], 32767)) & 0xffff) ;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)MIN2(src[0], 32767)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)MIN2(src[3], 32767)) << 16) ;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32a32_uint {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint32_t r;
      uint32_t a;
#else
      uint32_t r;
      uint32_t a;
#endif
   } chan;
};

static inline void
util_format_r32a32_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_r32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32a32_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_uint pixel;
         pixel.chan.r = src[0];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32a32_uint pixel;
         pixel.chan.r = src[0];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32a32_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_r32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r32a32_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)MIN2(pixel.chan.r, 2147483647); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)MIN2(pixel.chan.a, 2147483647); /* a */
#else
         union util_format_r32a32_uint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (int)MIN2(pixel.chan.r, 2147483647); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (int)MIN2(pixel.chan.a, 2147483647); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32a32_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_uint pixel;
         pixel.chan.r = (uint32_t)MAX2(src[0], 0);
         pixel.chan.a = (uint32_t)MAX2(src[3], 0);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32a32_uint pixel;
         pixel.chan.r = (uint32_t)MAX2(src[0], 0);
         pixel.chan.a = (uint32_t)MAX2(src[3], 0);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32a32_sint {
   uint64_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      int32_t r;
      int32_t a;
#else
      int32_t r;
      int32_t a;
#endif
   } chan;
};

static inline void
util_format_r32a32_sint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_r32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32a32_sint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_sint pixel;
         pixel.chan.r = src[0];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32a32_sint pixel;
         pixel.chan.r = src[0];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r32a32_sint_fetch_signed(int *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
#else
         union util_format_r32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
#endif
}

static inline void
util_format_r32a32_sint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)MAX2(pixel.chan.a, 0); /* a */
#else
         union util_format_r32a32_sint pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (unsigned)MAX2(pixel.chan.r, 0); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (unsigned)MAX2(pixel.chan.a, 0); /* a */
#endif
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r32a32_sint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         union util_format_r32a32_sint pixel;
         pixel.chan.r = (int32_t)MIN2(src[0], 2147483647);
         pixel.chan.a = (int32_t)MIN2(src[3], 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
#else
         union util_format_r32a32_sint pixel;
         pixel.chan.r = (int32_t)MIN2(src[0], 2147483647);
         pixel.chan.a = (int32_t)MIN2(src[3], 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
#endif
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10g10b10a2_uint {
   uint32_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned a:2;
      unsigned b:10;
      unsigned g:10;
      unsigned r:10;
#else
      unsigned r:10;
      unsigned g:10;
      unsigned b:10;
      unsigned a:2;
#endif
   } chan;
};

static inline void
util_format_r10g10b10a2_uint_unpack_unsigned(unsigned *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      unsigned *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 30;
         b = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value) & 0x3ff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10a2_uint_pack_unsigned(uint8_t *dst_row, unsigned dst_stride, const unsigned *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const unsigned *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)MIN2(src[3], 3)) << 30;
         value |= (((uint32_t)MIN2(src[2], 1023)) & 0x3ff) << 20;
         value |= (((uint32_t)MIN2(src[1], 1023)) & 0x3ff) << 10;
         value |= ((uint32_t)MIN2(src[0], 1023)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)MIN2(src[0], 1023)) & 0x3ff;
         value |= (((uint32_t)MIN2(src[1], 1023)) & 0x3ff) << 10;
         value |= (((uint32_t)MIN2(src[2], 1023)) & 0x3ff) << 20;
         value |= ((uint32_t)MIN2(src[3], 3)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_r10g10b10a2_uint_fetch_unsigned(unsigned *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 30;
         b = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value) & 0x3ff;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = (unsigned)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (unsigned)r; /* r */
         dst[1] = (unsigned)g; /* g */
         dst[2] = (unsigned)b; /* b */
         dst[3] = (unsigned)a; /* a */
#endif
}

static inline void
util_format_r10g10b10a2_uint_unpack_signed(int *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      int *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         a = value >> 30;
         b = (value >> 20) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value) & 0x3ff;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = (int)a; /* a */
#else
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (int)r; /* r */
         dst[1] = (int)g; /* g */
         dst[2] = (int)b; /* b */
         dst[3] = (int)a; /* a */
#endif
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_r10g10b10a2_uint_pack_signed(uint8_t *dst_row, unsigned dst_stride, const int *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const int *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint32_t value = 0;
         value |= ((uint32_t)CLAMP(src[3], 0, 3)) << 30;
         value |= (((uint32_t)CLAMP(src[2], 0, 1023)) & 0x3ff) << 20;
         value |= (((uint32_t)CLAMP(src[1], 0, 1023)) & 0x3ff) << 10;
         value |= ((uint32_t)CLAMP(src[0], 0, 1023)) & 0x3ff;
         *(uint32_t *)dst = value;
#else
         uint32_t value = 0;
         value |= ((uint32_t)CLAMP(src[0], 0, 1023)) & 0x3ff;
         value |= (((uint32_t)CLAMP(src[1], 0, 1023)) & 0x3ff) << 10;
         value |= (((uint32_t)CLAMP(src[2], 0, 1023)) & 0x3ff) << 20;
         value |= ((uint32_t)CLAMP(src[3], 0, 3)) << 30;
         *(uint32_t *)dst = value;
#endif
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b5g6r5_srgb {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      unsigned r:5;
      unsigned g:6;
      unsigned b:5;
#else
      unsigned b:5;
      unsigned g:6;
      unsigned r:5;
#endif
   } chan;
};

static inline void
util_format_b5g6r5_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         r = value >> 11;
         g = (value >> 5) & 0x3f;
         b = (value) & 0x1f;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r << 3 | r >> 2); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g << 2 | g >> 4); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b << 3 | b >> 2); /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         b = (value) & 0x1f;
         g = (value >> 5) & 0x3f;
         r = value >> 11;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r << 3 | r >> 2); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g << 2 | g >> 4); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b << 3 | b >> 2); /* b */
         dst[3] = 1; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b5g6r5_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0]) >> 3) << 11;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1]) >> 2) & 0x3f) << 5;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2]) >> 3) & 0x1f;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2]) >> 3) & 0x1f;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1]) >> 2) & 0x3f) << 5;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0]) >> 3) << 11;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static inline void
util_format_b5g6r5_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         r = value >> 11;
         g = (value >> 5) & 0x3f;
         b = (value) & 0x1f;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r << 3 | r >> 2); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g << 2 | g >> 4); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b << 3 | b >> 2); /* b */
         dst[3] = 1; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         b = (value) & 0x1f;
         g = (value >> 5) & 0x3f;
         r = value >> 11;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r << 3 | r >> 2); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g << 2 | g >> 4); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b << 3 | b >> 2); /* b */
         dst[3] = 1; /* a */
#endif
}

static inline void
util_format_b5g6r5_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
         uint16_t b;
         r = value >> 11;
         g = (value >> 5) & 0x3f;
         b = (value) & 0x1f;
         dst[0] = util_format_srgb_to_linear_8unorm(r << 3 | r >> 2); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g << 2 | g >> 4); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b << 3 | b >> 2); /* b */
         dst[3] = 255; /* a */
#else
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         b = (value) & 0x1f;
         g = (value >> 5) & 0x3f;
         r = value >> 11;
         dst[0] = util_format_srgb_to_linear_8unorm(r << 3 | r >> 2); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g << 2 | g >> 4); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b << 3 | b >> 2); /* b */
         dst[3] = 255; /* a */
#endif
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static inline void
util_format_b5g6r5_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
#ifdef PIPE_ARCH_BIG_ENDIAN
         uint16_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[0]) >> 3) << 11;
         value |= ((util_format_linear_to_srgb_8unorm(src[1]) >> 2) & 0x3f) << 5;
         value |= (util_format_linear_to_srgb_8unorm(src[2]) >> 3) & 0x1f;
         *(uint16_t *)dst = value;
#else
         uint16_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[2]) >> 3) & 0x1f;
         value |= ((util_format_linear_to_srgb_8unorm(src[1]) >> 2) & 0x3f) << 5;
         value |= (util_format_linear_to_srgb_8unorm(src[0]) >> 3) << 11;
         *(uint16_t *)dst = value;
#endif
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8l8_unorm {
   uint16_t value;
   struct {
#ifdef PIPE_ARCH_BIG_ENDIAN
      uint8_t a;
      uint8_t rgb;
#else
      uint8_t a;
      uint8_t rgb;
#endif
   } chan;
