/*
 * module-agl-audio -- PulseAudio module for providing audio routing support
 * (forked from "module-murphy-ivi" - https://github.com/otcshare )
 * Copyright (c) 2012, Intel Corporation.
 * Copyright (c) 2016, IoT.bzh
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St - Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 */
#ifndef paaglzone
#define paaglzone

#include "userdata.h"

#define AGL_ZONE_MAX 8

struct agl_zone {
	const char *name;
	uint32_t    index;
};

agl_zoneset *agl_zoneset_init (struct userdata *);
void agl_zoneset_done (struct userdata *);

int agl_zoneset_add_zone (struct userdata *, const char *, uint32_t);
agl_zone *agl_zoneset_get_zone_by_name (struct userdata *, const char *);
agl_zone *agl_zoneset_get_zone_by_index (struct userdata *, uint32_t);

#endif
