/* This testcase is part of GDB, the GNU debugger.

   Copyright 2014-2016 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

	.text
	.globl	func
func:

## power7.d
	.long  0x7c642e98    /* <+0>:     lxvd2x  vs3,r4,r5          */
	.long  0x7d642e99    /* <+4>:     lxvd2x  vs43,r4,r5         */
	.long  0x7c642f98    /* <+8>:     stxvd2x vs3,r4,r5          */
	.long  0x7d642f99    /* <+12>:    stxvd2x vs43,r4,r5         */
	.long  0xf0642850    /* <+16>:    xxmrghd vs3,vs4,vs5        */
	.long  0xf16c6857    /* <+20>:    xxmrghd vs43,vs44,vs45     */
	.long  0xf0642b50    /* <+24>:    xxmrgld vs3,vs4,vs5        */
	.long  0xf16c6b57    /* <+28>:    xxmrgld vs43,vs44,vs45     */
	.long  0xf0642850    /* <+32>:    xxmrghd vs3,vs4,vs5        */
	.long  0xf16c6857    /* <+36>:    xxmrghd vs43,vs44,vs45     */
	.long  0xf0642b50    /* <+40>:    xxmrgld vs3,vs4,vs5        */
	.long  0xf16c6b57    /* <+44>:    xxmrgld vs43,vs44,vs45     */
	.long  0xf0642950    /* <+48>:    xxpermdi vs3,vs4,vs5,1     */
	.long  0xf16c6957    /* <+52>:    xxpermdi vs43,vs44,vs45,1  */
	.long  0xf0642a50    /* <+56>:    xxpermdi vs3,vs4,vs5,2     */
	.long  0xf16c6a57    /* <+60>:    xxpermdi vs43,vs44,vs45,2  */
	.long  0xf0642780    /* <+64>:    xvmovdp vs3,vs4            */
	.long  0xf16c6787    /* <+68>:    xvmovdp vs43,vs44          */
	.long  0xf0642780    /* <+72>:    xvmovdp vs3,vs4            */
	.long  0xf16c6787    /* <+76>:    xvmovdp vs43,vs44          */
	.long  0xf0642f80    /* <+80>:    xvcpsgndp vs3,vs4,vs5      */
	.long  0xf16c6f87    /* <+84>:    xvcpsgndp vs43,vs44,vs45   */
	.long  0x4c000324    /* <+88>:    doze                       */
	.long  0x4c000364    /* <+92>:    nap                        */
	.long  0x4c0003a4    /* <+96>:    sleep                      */
	.long  0x4c0003e4    /* <+100>:   rvwinkle                   */
	.long  0x7c830134    /* <+104>:   prtyw   r3,r4              */
	.long  0x7dcd0174    /* <+108>:   prtyd   r13,r14            */
	.long  0x7d5c02a6    /* <+112>:   mfcfar  r10                */
	.long  0x7d7c03a6    /* <+116>:   mtcfar  r11                */
	.long  0x7c832bf8    /* <+120>:   cmpb    r3,r4,r5           */
	.long  0x7d4b662a    /* <+124>:   lwzcix  r10,r11,r12        */
	.long  0xee119004    /* <+128>:   dadd    f16,f17,f18        */
	.long  0xfe96c004    /* <+132>:   daddq   f20,f22,f24        */
	.long  0x7c60066c    /* <+136>:   dss     3                  */
	.long  0x7e00066c    /* <+140>:   dssall                     */
	.long  0x7c2522ac    /* <+144>:   dst     r5,r4,1            */
	.long  0x7e083aac    /* <+148>:   dstt    r8,r7,0            */
	.long  0x7c6532ec    /* <+152>:   dstst   r5,r6,3            */
	.long  0x7e442aec    /* <+156>:   dststt  r4,r5,2            */
	.long  0x7d4b6356    /* <+160>:   divwe   r10,r11,r12        */
	.long  0x7d6c6b57    /* <+164>:   divwe.  r11,r12,r13        */
	.long  0x7d8d7756    /* <+168>:   divweo  r12,r13,r14        */
	.long  0x7dae7f57    /* <+172>:   divweo. r13,r14,r15        */
	.long  0x7d4b6316    /* <+176>:   divweu  r10,r11,r12        */
	.long  0x7d6c6b17    /* <+180>:   divweu. r11,r12,r13        */
	.long  0x7d8d7716    /* <+184>:   divweuo r12,r13,r14        */
	.long  0x7dae7f17    /* <+188>:   divweuo. r13,r14,r15       */
	.long  0x7e27d9f8    /* <+192>:   bpermd  r7,r17,r27         */
	.long  0x7e8a02f4    /* <+196>:   popcntw r10,r20            */
	.long  0x7e8a03f4    /* <+200>:   popcntd r10,r20            */
	.long  0x7e95b428    /* <+204>:   ldbrx   r20,r21,r22        */
	.long  0x7e95b528    /* <+208>:   stdbrx  r20,r21,r22        */
	.long  0x7d4056ee    /* <+212>:   lfiwzx  f10,0,r10          */
	.long  0x7d4956ee    /* <+216>:   lfiwzx  f10,r9,r10         */
	.long  0xec802e9c    /* <+220>:   fcfids  f4,f5              */
	.long  0xec802e9d    /* <+224>:   fcfids. f4,f5              */
	.long  0xec802f9c    /* <+228>:   fcfidus f4,f5              */
	.long  0xec802f9d    /* <+232>:   fcfidus. f4,f5             */
	.long  0xfc80291c    /* <+236>:   fctiwu  f4,f5              */
	.long  0xfc80291d    /* <+240>:   fctiwu. f4,f5              */
	.long  0xfc80291e    /* <+244>:   fctiwuz f4,f5              */
	.long  0xfc80291f    /* <+248>:   fctiwuz. f4,f5             */
	.long  0xfc802f5c    /* <+252>:   fctidu  f4,f5              */
	.long  0xfc802f5d    /* <+256>:   fctidu. f4,f5              */
	.long  0xfc802f5e    /* <+260>:   fctiduz f4,f5              */
	.long  0xfc802f5f    /* <+264>:   fctiduz. f4,f5             */
	.long  0xfc802f9c    /* <+268>:   fcfidu  f4,f5              */
	.long  0xfc802f9d    /* <+272>:   fcfidu. f4,f5              */
	.long  0xfc0a5900    /* <+276>:   ftdiv   cr0,f10,f11        */
	.long  0xff8a5900    /* <+280>:   ftdiv   cr7,f10,f11        */
	.long  0xfc005140    /* <+284>:   ftsqrt  cr0,f10            */
	.long  0xff805140    /* <+288>:   ftsqrt  cr7,f10            */
	.long  0x7e084a2c    /* <+292>:   dcbtt   r8,r9              */
	.long  0x7e0849ec    /* <+296>:   dcbtstt r8,r9              */
	.long  0xed406644    /* <+300>:   dcffix  f10,f12            */
	.long  0xee80b645    /* <+304>:   dcffix. f20,f22            */
	.long  0xfdc07830    /* <+308>:   fre     f14,f15            */
	.long  0xfdc07831    /* <+312>:   fre.    f14,f15            */
	.long  0xedc07830    /* <+316>:   fres    f14,f15            */
	.long  0xedc07831    /* <+320>:   fres.   f14,f15            */
	.long  0xfdc07834    /* <+324>:   frsqrte f14,f15            */
	.long  0xfdc07835    /* <+328>:   frsqrte. f14,f15           */
	.long  0xedc07834    /* <+332>:   frsqrtes f14,f15           */
	.long  0xedc07835    /* <+336>:   frsqrtes. f14,f15          */
	.long  0x7c43271e    /* <+340>:   isel    r2,r3,r4,28        */
	.long  0x7f7bdb78    /* <+344>:   yield                      */
	.long  0x7f7bdb78    /* <+348>:   yield                      */
	.long  0x60420000    /* <+352>:   ori     r2,r2,0            */
	.long  0x60000000    /* <+356>:   nop                        */
	.long  0x60000000    /* <+360>:   nop                        */
	.long  0x60420000    /* <+364>:   ori     r2,r2,0            */
	.long  0x7fbdeb78    /* <+368>:   mdoio                      */
	.long  0x7fbdeb78    /* <+372>:   mdoio                      */
	.long  0x7fdef378    /* <+376>:   mdoom                      */
	.long  0x7fdef378    /* <+380>:   mdoom                      */
	.long  0x7d40e2a6    /* <+384>:   mfppr   r10                */
	.long  0x7d62e2a6    /* <+388>:   mfppr32 r11                */
	.long  0x7d80e3a6    /* <+392>:   mtppr   r12                */
	.long  0x7da2e3a6    /* <+396>:   mtppr32 r13                */
	.long  0x7d605264    /* <+400>:   tlbie   r10,r11            */

## altivec.d
	.long  0x7c60066c    /* <+404>:   dss     3                  */
	.long  0x7e00066c    /* <+408>:   dssall                     */
	.long  0x7c2522ac    /* <+412>:   dst     r5,r4,1            */
	.long  0x7e083aac    /* <+416>:   dstt    r8,r7,0            */
	.long  0x7c6532ec    /* <+420>:   dstst   r5,r6,3            */
	.long  0x7e442aec    /* <+424>:   dststt  r4,r5,2            */
	.long  0x7fd6c00e    /* <+428>:   lvebx   v30,r22,r24        */
	.long  0x7ea0c00e    /* <+432>:   lvebx   v21,0,r24          */
	.long  0x7d50104e    /* <+436>:   lvehx   v10,r16,r2         */
	.long  0x7e80b84e    /* <+440>:   lvehx   v20,0,r23          */
	.long  0x7e24908e    /* <+444>:   lvewx   v17,r4,r18         */
	.long  0x7ee0408e    /* <+448>:   lvewx   v23,0,r8           */
	.long  0x7cc0c80c    /* <+452>:   lvsl    v6,0,r25           */
	.long  0x7c40300c    /* <+456>:   lvsl    v2,0,r6            */
	.long  0x7ed0604c    /* <+460>:   lvsr    v22,r16,r12        */
	.long  0x7c00e84c    /* <+464>:   lvsr    v0,0,r29           */
	.long  0x7de56ace    /* <+468>:   lvxl    v15,r5,r13         */
	.long  0x7e60bace    /* <+472>:   lvxl    v19,0,r23          */
	.long  0x7ec110ce    /* <+476>:   lvx     v22,r1,r2          */
	.long  0x7e4088ce    /* <+480>:   lvx     v18,0,r17          */
	.long  0x7fe042a6    /* <+484>:   mfvrsave r31               */
	.long  0x13000604    /* <+488>:   mfvscr  v24                */
	.long  0x7d4043a6    /* <+492>:   mtvrsave r10               */
	.long  0x1000ce44    /* <+496>:   mtvscr  v25                */
	.long  0x7e5b510e    /* <+500>:   stvebx  v18,r27,r10        */
	.long  0x7e00310e    /* <+504>:   stvebx  v16,0,r6           */
	.long  0x7e2d814e    /* <+508>:   stvehx  v17,r13,r16        */
	.long  0x7ee0a14e    /* <+512>:   stvehx  v23,0,r20          */
	.long  0x7d73f98e    /* <+516>:   stvewx  v11,r19,r31        */
	.long  0x7fe0098e    /* <+520>:   stvewx  v31,0,r1           */
	.long  0x7f558bce    /* <+524>:   stvxl   v26,r21,r17        */
	.long  0x7da0b3ce    /* <+528>:   stvxl   v13,0,r22          */
	.long  0x7d7ff9ce    /* <+532>:   stvx    v11,r31,r31        */
	.long  0x7fc081ce    /* <+536>:   stvx    v30,0,r16          */
	.long  0x1307e180    /* <+540>:   vaddcuw v24,v7,v28         */
	.long  0x107e580a    /* <+544>:   vaddfp  v3,v30,v11         */
	.long  0x111c4b00    /* <+548>:   vaddsbs v8,v28,v9          */
	.long  0x10e52340    /* <+552>:   vaddshs v7,v5,v4           */
	.long  0x12dadb80    /* <+556>:   vaddsws v22,v26,v27        */
	.long  0x120ee000    /* <+560>:   vaddubm v16,v14,v28        */
	.long  0x10c1ca00    /* <+564>:   vaddubs v6,v1,v25          */
	.long  0x10443040    /* <+568>:   vadduhm v2,v4,v6           */
	.long  0x13554240    /* <+572>:   vadduhs v26,v21,v8         */
	.long  0x13bf0880    /* <+576>:   vadduwm v29,v31,v1         */
	.long  0x12ed2280    /* <+580>:   vadduws v23,v13,v4         */
	.long  0x13d04c44    /* <+584>:   vandc   v30,v16,v9         */
	.long  0x106ddc04    /* <+588>:   vand    v3,v13,v27         */
	.long  0x10868d02    /* <+592>:   vavgsb  v4,v6,v17          */
	.long  0x12fc9d42    /* <+596>:   vavgsh  v23,v28,v19        */
	.long  0x110ffd82    /* <+600>:   vavgsw  v8,v15,v31         */
	.long  0x10c7cc02    /* <+604>:   vavgub  v6,v7,v25          */
	.long  0x13365442    /* <+608>:   vavguh  v25,v22,v10        */
	.long  0x1077ec82    /* <+612>:   vavguw  v3,v23,v29         */
	.long  0x11c613ca    /* <+616>:   vctsxs  v14,v2,6           */
	.long  0x1134fb8a    /* <+620>:   vctuxs  v9,v31,20          */
	.long  0x1303f34a    /* <+624>:   vcfsx   v24,v30,3          */
	.long  0x123dab0a    /* <+628>:   vcfux   v17,v21,29         */
	.long  0x125c03c6    /* <+632>:   vcmpbfp v18,v28,v0         */
	.long  0x127a1fc6    /* <+636>:   vcmpbfp. v19,v26,v3        */
	.long  0x120258c6    /* <+640>:   vcmpeqfp v16,v2,v11        */
	.long  0x12ed6cc6    /* <+644>:   vcmpeqfp. v23,v13,v13      */
	.long  0x13335006    /* <+648>:   vcmpequb v25,v19,v10       */
	.long  0x124b1406    /* <+652>:   vcmpequb. v18,v11,v2       */
	.long  0x11393846    /* <+656>:   vcmpequh v9,v25,v7         */
	.long  0x11d8ac46    /* <+660>:   vcmpequh. v14,v24,v21      */
	.long  0x130c2886    /* <+664>:   vcmpequw v24,v12,v5        */
	.long  0x12700c86    /* <+668>:   vcmpequw. v19,v16,v1       */
	.long  0x12f181c6    /* <+672>:   vcmpgefp v23,v17,v16       */
	.long  0x127d8dc6    /* <+676>:   vcmpgefp. v19,v29,v17      */
	.long  0x121c6ac6    /* <+680>:   vcmpgtfp v16,v28,v13       */
	.long  0x11d83ec6    /* <+684>:   vcmpgtfp. v14,v24,v7       */
	.long  0x12163306    /* <+688>:   vcmpgtsb v16,v22,v6        */
	.long  0x104c7706    /* <+692>:   vcmpgtsb. v2,v12,v14       */
	.long  0x1383eb46    /* <+696>:   vcmpgtsh v28,v3,v29        */
	.long  0x12136f46    /* <+700>:   vcmpgtsh. v16,v19,v13      */
	.long  0x11e02b86    /* <+704>:   vcmpgtsw v15,v0,v5         */
	.long  0x12ad0786    /* <+708>:   vcmpgtsw. v21,v13,v0       */
	.long  0x10aaf206    /* <+712>:   vcmpgtub v5,v10,v30        */
	.long  0x10ed5606    /* <+716>:   vcmpgtub. v7,v13,v10       */
	.long  0x130f8246    /* <+720>:   vcmpgtuh v24,v15,v16       */
	.long  0x1335de46    /* <+724>:   vcmpgtuh. v25,v21,v27      */
	.long  0x123b3286    /* <+728>:   vcmpgtuw v17,v27,v6        */
	.long  0x1115de86    /* <+732>:   vcmpgtuw. v8,v21,v27       */
	.long  0x102e0b4a    /* <+736>:   vcfsx   v1,v1,14           */
	.long  0x10997bca    /* <+740>:   vctsxs  v4,v15,25          */
	.long  0x138ebb8a    /* <+744>:   vctuxs  v28,v23,14         */
	.long  0x10c0330a    /* <+748>:   vcfux   v6,v6,0            */
	.long  0x1000418a    /* <+752>:   vexptefp v0,v8             */
	.long  0x12c0d9ca    /* <+756>:   vlogefp v22,v27            */
	.long  0x12f2916e    /* <+760>:   vmaddfp v23,v18,v5,v18     */
	.long  0x11addc0a    /* <+764>:   vmaxfp  v13,v13,v27        */
	.long  0x11177102    /* <+768>:   vmaxsb  v8,v23,v14         */
	.long  0x12710142    /* <+772>:   vmaxsh  v19,v17,v0         */
	.long  0x1263b182    /* <+776>:   vmaxsw  v19,v3,v22         */
	.long  0x12fee002    /* <+780>:   vmaxub  v23,v30,v28        */
	.long  0x1134b842    /* <+784>:   vmaxuh  v9,v20,v23         */
	.long  0x12b30882    /* <+788>:   vmaxuw  v21,v19,v1         */
	.long  0x12cd2da0    /* <+792>:   vmhaddshs v22,v13,v5,v22   */
	.long  0x13e01ca1    /* <+796>:   vmhraddshs v31,v0,v3,v18   */
	.long  0x1055c44a    /* <+800>:   vminfp  v2,v21,v24         */
	.long  0x12865302    /* <+804>:   vminsb  v20,v6,v10         */
	.long  0x125bd342    /* <+808>:   vminsh  v18,v27,v26        */
	.long  0x10640b82    /* <+812>:   vminsw  v3,v4,v1           */
	.long  0x10e06a02    /* <+816>:   vminub  v7,v0,v13          */
	.long  0x100c3242    /* <+820>:   vminuh  v0,v12,v6          */
	.long  0x10c30a82    /* <+824>:   vminuw  v6,v3,v1           */
	.long  0x107d1ea2    /* <+828>:   vmladduhm v3,v29,v3,v26    */
	.long  0x12a5f80c    /* <+832>:   vmrghb  v21,v5,v31         */
	.long  0x12b8004c    /* <+836>:   vmrghh  v21,v24,v0         */
	.long  0x1200b08c    /* <+840>:   vmrghw  v16,v0,v22         */
	.long  0x1031810c    /* <+844>:   vmrglb  v1,v17,v16         */
	.long  0x11c8794c    /* <+848>:   vmrglh  v14,v8,v15         */
	.long  0x13f5298c    /* <+852>:   vmrglw  v31,v21,v5         */
	.long  0x13094c84    /* <+856>:   vmr     v24,v9             */
	.long  0x13094c84    /* <+860>:   vmr     v24,v9             */
	.long  0x10187de5    /* <+864>:   vmsummbm v0,v24,v15,v23    */
	.long  0x10243e68    /* <+868>:   vmsumshm v1,v4,v7,v25      */
	.long  0x11286fe9    /* <+872>:   vmsumshs v9,v8,v13,v31     */
	.long  0x12ff67a4    /* <+876>:   vmsumubm v23,v31,v12,v30   */
	.long  0x13a0d566    /* <+880>:   vmsumuhm v29,v0,v26,v21    */
	.long  0x136ec967    /* <+884>:   vmsumuhs v27,v14,v25,v5    */
	.long  0x11597308    /* <+888>:   vmulesb v10,v25,v14        */
	.long  0x10324348    /* <+892>:   vmulesh v1,v18,v8          */
	.long  0x122e4a08    /* <+896>:   vmuleub v17,v14,v9         */
	.long  0x10ba4a48    /* <+900>:   vmuleuh v5,v26,v9          */
	.long  0x12b23108    /* <+904>:   vmulosb v21,v18,v6         */
	.long  0x10854148    /* <+908>:   vmulosh v4,v5,v8           */
	.long  0x10499808    /* <+912>:   vmuloub v2,v9,v19          */
	.long  0x13a52048    /* <+916>:   vmulouh v29,v5,v4          */
	.long  0x110229af    /* <+920>:   vnmsubfp v8,v2,v6,v5       */
	.long  0x13e95504    /* <+924>:   vnor    v31,v9,v10         */
	.long  0x133ffd04    /* <+928>:   vnot    v25,v31            */
	.long  0x133ffd04    /* <+932>:   vnot    v25,v31            */
	.long  0x12e71484    /* <+936>:   vor     v23,v7,v2          */
	.long  0x101cb66b    /* <+940>:   vperm   v0,v28,v22,v25     */
	.long  0x12198b0e    /* <+944>:   vpkpx   v16,v25,v17        */
	.long  0x1190898e    /* <+948>:   vpkshss v12,v16,v17        */
	.long  0x1033b90e    /* <+952>:   vpkshus v1,v19,v23         */
	.long  0x132769ce    /* <+956>:   vpkswss v25,v7,v13         */
	.long  0x1098514e    /* <+960>:   vpkswus v4,v24,v10         */
	.long  0x113b600e    /* <+964>:   vpkuhum v9,v27,v12         */
	.long  0x12cac88e    /* <+968>:   vpkuhus v22,v10,v25        */
	.long  0x13d2004e    /* <+972>:   vpkuwum v30,v18,v0         */
	.long  0x10e3b0ce    /* <+976>:   vpkuwus v7,v3,v22          */
	.long  0x1300e10a    /* <+980>:   vrefp   v24,v28            */
	.long  0x12209aca    /* <+984>:   vrfim   v17,v19            */
	.long  0x1300ca0a    /* <+988>:   vrfin   v24,v25            */
	.long  0x10602a8a    /* <+992>:   vrfip   v3,v5              */
	.long  0x1100524a    /* <+996>:   vrfiz   v8,v10             */
	.long  0x1352f004    /* <+1000>:  vrlb    v26,v18,v30        */
	.long  0x1211c844    /* <+1004>:  vrlh    v16,v17,v25        */
	.long  0x12fe4884    /* <+1008>:  vrlw    v23,v30,v9         */
	.long  0x1040914a    /* <+1012>:  vrsqrtefp v2,v18           */
	.long  0x128e92aa    /* <+1016>:  vsel    v20,v14,v18,v10    */
	.long  0x13396104    /* <+1020>:  vslb    v25,v25,v12        */
	.long  0x112961ec    /* <+1024>:  vsldoi  v9,v9,v12,7        */
	.long  0x11c25944    /* <+1028>:  vslh    v14,v2,v11         */
	.long  0x13c5340c    /* <+1032>:  vslo    v30,v5,v6          */
	.long  0x12de49c4    /* <+1036>:  vsl     v22,v30,v9         */
	.long  0x135a1984    /* <+1040>:  vslw    v26,v26,v3         */
	.long  0x1026a20c    /* <+1044>:  vspltb  v1,v20,6           */
	.long  0x1203924c    /* <+1048>:  vsplth  v16,v18,3          */
	.long  0x1333030c    /* <+1052>:  vspltisb v25,-13           */
	.long  0x12ca034c    /* <+1056>:  vspltish v22,10            */
	.long  0x11ad038c    /* <+1060>:  vspltisw v13,13            */
	.long  0x1122928c    /* <+1064>:  vspltw  v9,v18,2           */
	.long  0x11d60304    /* <+1068>:  vsrab   v14,v22,v0         */
	.long  0x118c9344    /* <+1072>:  vsrah   v12,v12,v18        */
	.long  0x10426b84    /* <+1076>:  vsraw   v2,v2,v13          */
	.long  0x10fb2a04    /* <+1080>:  vsrb    v7,v27,v5          */
	.long  0x10ebea44    /* <+1084>:  vsrh    v7,v11,v29         */
	.long  0x125efc4c    /* <+1088>:  vsro    v18,v30,v31        */
	.long  0x1049e2c4    /* <+1092>:  vsr     v2,v9,v28          */
	.long  0x10190284    /* <+1096>:  vsrw    v0,v25,v0          */
	.long  0x13025580    /* <+1100>:  vsubcuw v24,v2,v10         */
	.long  0x12d8a04a    /* <+1104>:  vsubfp  v22,v24,v20        */
	.long  0x11566f00    /* <+1108>:  vsubsbs v10,v22,v13        */
	.long  0x1311e740    /* <+1112>:  vsubshs v24,v17,v28        */
	.long  0x115a0780    /* <+1116>:  vsubsws v10,v26,v0         */
	.long  0x120bc400    /* <+1120>:  vsububm v16,v11,v24        */
	.long  0x11750e00    /* <+1124>:  vsububs v11,v21,v1         */
	.long  0x10ccc440    /* <+1128>:  vsubuhm v6,v12,v24         */
	.long  0x13cb4e40    /* <+1132>:  vsubuhs v30,v11,v9         */
	.long  0x12746c80    /* <+1136>:  vsubuwm v19,v20,v13        */
	.long  0x12593680    /* <+1140>:  vsubuws v18,v25,v6         */
	.long  0x132a9688    /* <+1144>:  vsum2sws v25,v10,v18       */
	.long  0x11b0af08    /* <+1148>:  vsum4sbs v13,v16,v21       */
	.long  0x12e82648    /* <+1152>:  vsum4shs v23,v8,v4         */
	.long  0x138df608    /* <+1156>:  vsum4ubs v28,v13,v30       */
	.long  0x12ca4788    /* <+1160>:  vsumsws v22,v10,v8         */
	.long  0x1300734e    /* <+1164>:  vupkhpx v24,v14            */
	.long  0x1040b20e    /* <+1168>:  vupkhsb v2,v22             */
	.long  0x1200124e    /* <+1172>:  vupkhsh v16,v2             */
	.long  0x1140d3ce    /* <+1176>:  vupklpx v10,v26            */
	.long  0x11e0e28e    /* <+1180>:  vupklsb v15,v28            */
	.long  0x110042ce    /* <+1184>:  vupklsh v8,v8              */
	.long  0x13201cc4    /* <+1188>:  vxor    v25,v0,v3          */

## vsd.d
	.long  0x7d0aa499    /* <+1192>:  lxsdx   vs40,r10,r20       */
	.long  0x7d0aa699    /* <+1196>:  lxvd2x  vs40,r10,r20       */
	.long  0x7d0aa299    /* <+1200>:  lxvdsx  vs40,r10,r20       */
	.long  0x7d0aa619    /* <+1204>:  lxvw4x  vs40,r10,r20       */
	.long  0x7d0aa599    /* <+1208>:  stxsdx  vs40,r10,r20       */
	.long  0x7d0aa799    /* <+1212>:  stxvd2x vs40,r10,r20       */
	.long  0x7d0aa719    /* <+1216>:  stxvw4x vs40,r10,r20       */
	.long  0xf100e567    /* <+1220>:  xsabsdp vs40,vs60          */
	.long  0xf112e107    /* <+1224>:  xsadddp vs40,vs50,vs60     */
	.long  0xf092e15e    /* <+1228>:  xscmpodp cr1,vs50,vs60     */
	.long  0xf092e11e    /* <+1232>:  xscmpudp cr1,vs50,vs60     */
	.long  0xf112e587    /* <+1236>:  xscpsgndp vs40,vs50,vs60   */
	.long  0xf100e427    /* <+1240>:  xscvdpsp vs40,vs60         */
	.long  0xf100e563    /* <+1244>:  xscvdpsxds vs40,vs60       */
	.long  0xf100e163    /* <+1248>:  xscvdpsxws vs40,vs60       */
	.long  0xf100e523    /* <+1252>:  xscvdpuxds vs40,vs60       */
	.long  0xf100e123    /* <+1256>:  xscvdpuxws vs40,vs60       */
	.long  0xf100e527    /* <+1260>:  xscvspdp vs40,vs60         */
	.long  0xf100e5e3    /* <+1264>:  xscvsxddp vs40,vs60        */
	.long  0xf100e5a3    /* <+1268>:  xscvuxddp vs40,vs60        */
	.long  0xf112e1c7    /* <+1272>:  xsdivdp vs40,vs50,vs60     */
	.long  0xf112e10f    /* <+1276>:  xsmaddadp vs40,vs50,vs60   */
	.long  0xf112e14f    /* <+1280>:  xsmaddmdp vs40,vs50,vs60   */
	.long  0xf112e507    /* <+1284>:  xsmaxdp vs40,vs50,vs60     */
	.long  0xf112e547    /* <+1288>:  xsmindp vs40,vs50,vs60     */
	.long  0xf112e18f    /* <+1292>:  xsmsubadp vs40,vs50,vs60   */
	.long  0xf112e1cf    /* <+1296>:  xsmsubmdp vs40,vs50,vs60   */
	.long  0xf112e187    /* <+1300>:  xsmuldp vs40,vs50,vs60     */
	.long  0xf100e5a7    /* <+1304>:  xsnabsdp vs40,vs60         */
	.long  0xf100e5e7    /* <+1308>:  xsnegdp vs40,vs60          */
	.long  0xf112e50f    /* <+1312>:  xsnmaddadp vs40,vs50,vs60  */
	.long  0xf112e54f    /* <+1316>:  xsnmaddmdp vs40,vs50,vs60  */
	.long  0xf112e58f    /* <+1320>:  xsnmsubadp vs40,vs50,vs60  */
	.long  0xf112e5cf    /* <+1324>:  xsnmsubmdp vs40,vs50,vs60  */
	.long  0xf100e127    /* <+1328>:  xsrdpi  vs40,vs60          */
	.long  0xf100e1af    /* <+1332>:  xsrdpic vs40,vs60          */
	.long  0xf100e1e7    /* <+1336>:  xsrdpim vs40,vs60          */
	.long  0xf100e1a7    /* <+1340>:  xsrdpip vs40,vs60          */
	.long  0xf100e167    /* <+1344>:  xsrdpiz vs40,vs60          */
	.long  0xf100e16b    /* <+1348>:  xsredp  vs40,vs60          */
	.long  0xf100e12b    /* <+1352>:  xsrsqrtedp vs40,vs60       */
	.long  0xf100e12f    /* <+1356>:  xssqrtdp vs40,vs60         */
	.long  0xf112e147    /* <+1360>:  xssubdp vs40,vs50,vs60     */
	.long  0xf092e1ee    /* <+1364>:  xstdivdp cr1,vs50,vs60     */
	.long  0xf080e1aa    /* <+1368>:  xstsqrtdp cr1,vs60         */
	.long  0xf100e767    /* <+1372>:  xvabsdp vs40,vs60          */
	.long  0xf100e667    /* <+1376>:  xvabssp vs40,vs60          */
	.long  0xf112e307    /* <+1380>:  xvadddp vs40,vs50,vs60     */
	.long  0xf112e207    /* <+1384>:  xvaddsp vs40,vs50,vs60     */
	.long  0xf112e31f    /* <+1388>:  xvcmpeqdp vs40,vs50,vs60   */
	.long  0xf112e71f    /* <+1392>:  xvcmpeqdp. vs40,vs50,vs60  */
	.long  0xf112e21f    /* <+1396>:  xvcmpeqsp vs40,vs50,vs60   */
	.long  0xf112e61f    /* <+1400>:  xvcmpeqsp. vs40,vs50,vs60  */
	.long  0xf112e39f    /* <+1404>:  xvcmpgedp vs40,vs50,vs60   */
	.long  0xf112e79f    /* <+1408>:  xvcmpgedp. vs40,vs50,vs60  */
	.long  0xf112e29f    /* <+1412>:  xvcmpgesp vs40,vs50,vs60   */
	.long  0xf112e69f    /* <+1416>:  xvcmpgesp. vs40,vs50,vs60  */
	.long  0xf112e35f    /* <+1420>:  xvcmpgtdp vs40,vs50,vs60   */
	.long  0xf112e75f    /* <+1424>:  xvcmpgtdp. vs40,vs50,vs60  */
	.long  0xf112e25f    /* <+1428>:  xvcmpgtsp vs40,vs50,vs60   */
	.long  0xf112e65f    /* <+1432>:  xvcmpgtsp. vs40,vs50,vs60  */
	.long  0xf112e787    /* <+1436>:  xvcpsgndp vs40,vs50,vs60   */
	.long  0xf11ce787    /* <+1440>:  xvmovdp vs40,vs60          */
	.long  0xf11ce787    /* <+1444>:  xvmovdp vs40,vs60          */
	.long  0xf112e687    /* <+1448>:  xvcpsgnsp vs40,vs50,vs60   */
	.long  0xf11ce687    /* <+1452>:  xvmovsp vs40,vs60          */
	.long  0xf11ce687    /* <+1456>:  xvmovsp vs40,vs60          */
	.long  0xf100e627    /* <+1460>:  xvcvdpsp vs40,vs60         */
	.long  0xf100e763    /* <+1464>:  xvcvdpsxds vs40,vs60       */
	.long  0xf100e363    /* <+1468>:  xvcvdpsxws vs40,vs60       */
	.long  0xf100e723    /* <+1472>:  xvcvdpuxds vs40,vs60       */
	.long  0xf100e323    /* <+1476>:  xvcvdpuxws vs40,vs60       */
	.long  0xf100e727    /* <+1480>:  xvcvspdp vs40,vs60         */
	.long  0xf100e663    /* <+1484>:  xvcvspsxds vs40,vs60       */
	.long  0xf100e263    /* <+1488>:  xvcvspsxws vs40,vs60       */
	.long  0xf100e623    /* <+1492>:  xvcvspuxds vs40,vs60       */
	.long  0xf100e223    /* <+1496>:  xvcvspuxws vs40,vs60       */
	.long  0xf100e7e3    /* <+1500>:  xvcvsxddp vs40,vs60        */
	.long  0xf100e6e3    /* <+1504>:  xvcvsxdsp vs40,vs60        */
	.long  0xf100e3e3    /* <+1508>:  xvcvsxwdp vs40,vs60        */
	.long  0xf100e2e3    /* <+1512>:  xvcvsxwsp vs40,vs60        */
	.long  0xf100e7a3    /* <+1516>:  xvcvuxddp vs40,vs60        */
	.long  0xf100e6a3    /* <+1520>:  xvcvuxdsp vs40,vs60        */
	.long  0xf100e3a3    /* <+1524>:  xvcvuxwdp vs40,vs60        */
	.long  0xf100e2a3    /* <+1528>:  xvcvuxwsp vs40,vs60        */
	.long  0xf112e3c7    /* <+1532>:  xvdivdp vs40,vs50,vs60     */
	.long  0xf112e2c7    /* <+1536>:  xvdivsp vs40,vs50,vs60     */
	.long  0xf112e30f    /* <+1540>:  xvmaddadp vs40,vs50,vs60   */
	.long  0xf112e34f    /* <+1544>:  xvmaddmdp vs40,vs50,vs60   */
	.long  0xf112e20f    /* <+1548>:  xvmaddasp vs40,vs50,vs60   */
	.long  0xf112e24f    /* <+1552>:  xvmaddmsp vs40,vs50,vs60   */
	.long  0xf112e707    /* <+1556>:  xvmaxdp vs40,vs50,vs60     */
	.long  0xf112e607    /* <+1560>:  xvmaxsp vs40,vs50,vs60     */
	.long  0xf112e747    /* <+1564>:  xvmindp vs40,vs50,vs60     */
	.long  0xf112e647    /* <+1568>:  xvminsp vs40,vs50,vs60     */
	.long  0xf112e38f    /* <+1572>:  xvmsubadp vs40,vs50,vs60   */
	.long  0xf112e3cf    /* <+1576>:  xvmsubmdp vs40,vs50,vs60   */
	.long  0xf112e28f    /* <+1580>:  xvmsubasp vs40,vs50,vs60   */
	.long  0xf112e2cf    /* <+1584>:  xvmsubmsp vs40,vs50,vs60   */
	.long  0xf112e387    /* <+1588>:  xvmuldp vs40,vs50,vs60     */
	.long  0xf112e287    /* <+1592>:  xvmulsp vs40,vs50,vs60     */
	.long  0xf100e7a7    /* <+1596>:  xvnabsdp vs40,vs60         */
	.long  0xf100e6a7    /* <+1600>:  xvnabssp vs40,vs60         */
	.long  0xf100e7e7    /* <+1604>:  xvnegdp vs40,vs60          */
	.long  0xf100e6e7    /* <+1608>:  xvnegsp vs40,vs60          */
	.long  0xf112e70f    /* <+1612>:  xvnmaddadp vs40,vs50,vs60  */
	.long  0xf112e74f    /* <+1616>:  xvnmaddmdp vs40,vs50,vs60  */
	.long  0xf112e60f    /* <+1620>:  xvnmaddasp vs40,vs50,vs60  */
	.long  0xf112e64f    /* <+1624>:  xvnmaddmsp vs40,vs50,vs60  */
	.long  0xf112e78f    /* <+1628>:  xvnmsubadp vs40,vs50,vs60  */
	.long  0xf112e7cf    /* <+1632>:  xvnmsubmdp vs40,vs50,vs60  */
	.long  0xf112e68f    /* <+1636>:  xvnmsubasp vs40,vs50,vs60  */
	.long  0xf112e6cf    /* <+1640>:  xvnmsubmsp vs40,vs50,vs60  */
	.long  0xf100e327    /* <+1644>:  xvrdpi  vs40,vs60          */
	.long  0xf100e3af    /* <+1648>:  xvrdpic vs40,vs60          */
	.long  0xf100e3e7    /* <+1652>:  xvrdpim vs40,vs60          */
	.long  0xf100e3a7    /* <+1656>:  xvrdpip vs40,vs60          */
	.long  0xf100e367    /* <+1660>:  xvrdpiz vs40,vs60          */
	.long  0xf100e36b    /* <+1664>:  xvredp  vs40,vs60          */
	.long  0xf100e26b    /* <+1668>:  xvresp  vs40,vs60          */
	.long  0xf100e227    /* <+1672>:  xvrspi  vs40,vs60          */
	.long  0xf100e2af    /* <+1676>:  xvrspic vs40,vs60          */
	.long  0xf100e2e7    /* <+1680>:  xvrspim vs40,vs60          */
	.long  0xf100e2a7    /* <+1684>:  xvrspip vs40,vs60          */
	.long  0xf100e267    /* <+1688>:  xvrspiz vs40,vs60          */
	.long  0xf100e32b    /* <+1692>:  xvrsqrtedp vs40,vs60       */
	.long  0xf100e22b    /* <+1696>:  xvrsqrtesp vs40,vs60       */
	.long  0xf100e32f    /* <+1700>:  xvsqrtdp vs40,vs60         */
	.long  0xf100e22f    /* <+1704>:  xvsqrtsp vs40,vs60         */
	.long  0xf112e347    /* <+1708>:  xvsubdp vs40,vs50,vs60     */
	.long  0xf112e247    /* <+1712>:  xvsubsp vs40,vs50,vs60     */
	.long  0xf092e3ee    /* <+1716>:  xvtdivdp cr1,vs50,vs60     */
	.long  0xf092e2ee    /* <+1720>:  xvtdivsp cr1,vs50,vs60     */
	.long  0xf080e3aa    /* <+1724>:  xvtsqrtdp cr1,vs60         */
	.long  0xf080e2aa    /* <+1728>:  xvtsqrtsp cr1,vs60         */
	.long  0xf112e417    /* <+1732>:  xxland  vs40,vs50,vs60     */
	.long  0xf112e457    /* <+1736>:  xxlandc vs40,vs50,vs60     */
	.long  0xf112e517    /* <+1740>:  xxlnor  vs40,vs50,vs60     */
	.long  0xf112e497    /* <+1744>:  xxlor   vs40,vs50,vs60     */
	.long  0xf112e4d7    /* <+1748>:  xxlxor  vs40,vs50,vs60     */
	.long  0xf112e097    /* <+1752>:  xxmrghw vs40,vs50,vs60     */
	.long  0xf112e197    /* <+1756>:  xxmrglw vs40,vs50,vs60     */
	.long  0xf112e057    /* <+1760>:  xxmrghd vs40,vs50,vs60     */
	.long  0xf112e157    /* <+1764>:  xxpermdi vs40,vs50,vs60,1  */
	.long  0xf112e257    /* <+1768>:  xxpermdi vs40,vs50,vs60,2  */
	.long  0xf112e357    /* <+1772>:  xxmrgld vs40,vs50,vs60     */
	.long  0xf1129057    /* <+1776>:  xxspltd vs40,vs50,0        */
	.long  0xf1129057    /* <+1780>:  xxspltd vs40,vs50,0        */
	.long  0xf1129357    /* <+1784>:  xxspltd vs40,vs50,1        */
	.long  0xf1129357    /* <+1788>:  xxspltd vs40,vs50,1        */
	.long  0xf112e057    /* <+1792>:  xxmrghd vs40,vs50,vs60     */
	.long  0xf112e057    /* <+1796>:  xxmrghd vs40,vs50,vs60     */
	.long  0xf112e357    /* <+1800>:  xxmrgld vs40,vs50,vs60     */
	.long  0xf1129257    /* <+1804>:  xxswapd vs40,vs50          */
	.long  0xf1129257    /* <+1808>:  xxswapd vs40,vs50          */
	.long  0xf112e7bf    /* <+1812>:  xxsel   vs40,vs50,vs60,vs62*/
	.long  0xf112e217    /* <+1816>:  xxsldwi vs40,vs50,vs60,2   */
	.long  0xf102e293    /* <+1820>:  xxspltw vs40,vs60,2        */
	.long  0x7d00a699    /* <+1824>:  lxvd2x  vs40,0,r20         */
	.long  0x7d0aa699    /* <+1828>:  lxvd2x  vs40,r10,r20       */
	.long  0x7d00a799    /* <+1832>:  stxvd2x vs40,0,r20         */
	.long  0x7d0aa799    /* <+1836>:  stxvd2x vs40,r10,r20       */

## power8.d
	.long  0x7c05071d    /* <+1840>:  tabort. r5                 */
	.long  0x7ce8861d    /* <+1844>:  tabortwc. 7,r8,r16         */
	.long  0x7e8b565d    /* <+1848>:  tabortdc. 20,r11,r10       */
	.long  0x7e2a9e9d    /* <+1852>:  tabortwci. 17,r10,-13      */
	.long  0x7fa3dedd    /* <+1856>:  tabortdci. 29,r3,-5        */
	.long  0x7c00051d    /* <+1860>:  tbegin.                    */
	.long  0x7f80059c    /* <+1864>:  tcheck  cr7                */
	.long  0x7c00055d    /* <+1868>:  tend.                      */
	.long  0x7c00055d    /* <+1872>:  tend.                      */
	.long  0x7e00055d    /* <+1876>:  tendall.                   */
	.long  0x7e00055d    /* <+1880>:  tendall.                   */
	.long  0x7c18075d    /* <+1884>:  treclaim. r24              */
	.long  0x7c0007dd    /* <+1888>:  trechkpt.                  */
	.long  0x7c0005dd    /* <+1892>:  tsuspend.                  */
	.long  0x7c0005dd    /* <+1896>:  tsuspend.                  */
	.long  0x7c2005dd    /* <+1900>:  tresume.                   */
	.long  0x7c2005dd    /* <+1904>:  tresume.                   */
	.long  0x60420000    /* <+1908>:  ori     r2,r2,0            */
	.long  0x60000000    /* <+1912>:  nop                        */
	.long  0x60420000    /* <+1916>:  ori     r2,r2,0            */
	.long  0x4c000124    /* <+1920>:  rfebb   0                  */
	.long  0x4c000924    /* <+1924>:  rfebb                      */
	.long  0x4c000924    /* <+1928>:  rfebb                      */
	.long  0x4d950460    /* <+1932>:  bctar-  12,4*cr5+gt        */
	.long  0x4c870461    /* <+1936>:  bctarl- 4,4*cr1+so         */
	.long  0x4dac0460    /* <+1940>:  bctar+  12,4*cr3+lt        */
	.long  0x4ca20461    /* <+1944>:  bctarl+ 4,eq               */
	.long  0x4c880c60    /* <+1948>:  bctar   4,4*cr2+lt,1       */
	.long  0x4c871461    /* <+1952>:  bctarl  4,4*cr1+so,2       */
	.long  0x7c00003c    /* <+1956>:  waitasec                   */
	.long  0x7c00411c    /* <+1960>:  msgsndp r8                 */
	.long  0x7c200126    /* <+1964>:  mtsle   1                  */
	.long  0x7c00d95c    /* <+1968>:  msgclrp r27                */
	.long  0x7d4a616d    /* <+1972>:  stqcx.  r10,r10,r12        */
	.long  0x7f80396d    /* <+1976>:  stqcx.  r28,0,r7           */
	.long  0x7f135a28    /* <+1980>:  lqarx   r24,r19,r11        */
	.long  0x7ec05a28    /* <+1984>:  lqarx   r22,0,r11          */
	.long  0x7e80325c    /* <+1988>:  mfbhrbe r20,6              */
	.long  0x7fb18329    /* <+1992>:  pbt.    r29,r17,r16        */
	.long  0x7dc03b29    /* <+1996>:  pbt.    r14,0,r7           */
	.long  0x7c00035c    /* <+2000>:  clrbhrb                    */
	.long  0x116a05ed    /* <+2004>:  vpermxor v11,v10,v0,v23    */
	.long  0x1302393c    /* <+2008>:  vaddeuqm v24,v2,v7,v4      */
	.long  0x114a40bd    /* <+2012>:  vaddecuq v10,v10,v8,v2     */
	.long  0x10af44fe    /* <+2016>:  vsubeuqm v5,v15,v8,v19     */
	.long  0x119f877f    /* <+2020>:  vsubecuq v12,v31,v16,v29   */
	.long  0x129d6888    /* <+2024>:  vmulouw v20,v29,v13        */
	.long  0x13a0d089    /* <+2028>:  vmuluwm v29,v0,v26         */
	.long  0x1115e0c0    /* <+2032>:  vaddudm v8,v21,v28         */
	.long  0x103a08c2    /* <+2036>:  vmaxud  v1,v26,v1          */
	.long  0x128308c4    /* <+2040>:  vrld    v20,v3,v1          */
	.long  0x109358c7    /* <+2044>:  vcmpequd v4,v19,v11        */
	.long  0x12eef100    /* <+2048>:  vadduqm v23,v14,v30        */
	.long  0x11086940    /* <+2052>:  vaddcuq v8,v8,v13          */
	.long  0x139b2188    /* <+2056>:  vmulosw v28,v27,v4         */
	.long  0x106421c2    /* <+2060>:  vmaxsd  v3,v4,v4           */
	.long  0x1013aa88    /* <+2064>:  vmuleuw v0,v19,v21         */
	.long  0x13149ac2    /* <+2068>:  vminud  v24,v20,v19        */
	.long  0x101c7ac7    /* <+2072>:  vcmpgtud v0,v28,v15        */
	.long  0x12a01388    /* <+2076>:  vmulesw v21,v0,v2          */
	.long  0x113a4bc2    /* <+2080>:  vminsd  v9,v26,v9          */
	.long  0x133d5bc4    /* <+2084>:  vsrad   v25,v29,v11        */
	.long  0x117c5bc7    /* <+2088>:  vcmpgtsd v11,v28,v11       */
	.long  0x10a8d601    /* <+2092>:  bcdadd. v5,v8,v26,1        */
	.long  0x10836408    /* <+2096>:  vpmsumb v4,v3,v12          */
	.long  0x135fae41    /* <+2100>:  bcdsub. v26,v31,v21,1      */
	.long  0x10b18448    /* <+2104>:  vpmsumh v5,v17,v16         */
	.long  0x12f1a44e    /* <+2108>:  vpkudum v23,v17,v20        */
	.long  0x1315ec88    /* <+2112>:  vpmsumw v24,v21,v29        */
	.long  0x11366cc8    /* <+2116>:  vpmsumd v9,v22,v13         */
	.long  0x125394ce    /* <+2120>:  vpkudus v18,v19,v18        */
	.long  0x13d0b500    /* <+2124>:  vsubuqm v30,v16,v22        */
	.long  0x11cb3d08    /* <+2128>:  vcipher v14,v11,v7         */
	.long  0x1142b509    /* <+2132>:  vcipherlast v10,v2,v22     */
	.long  0x12e06d0c    /* <+2136>:  vgbbd   v23,v13            */
	.long  0x12198540    /* <+2140>:  vsubcuq v16,v25,v16        */
	.long  0x13e12d44    /* <+2144>:  vorc    v31,v1,v5          */
	.long  0x1091fd48    /* <+2148>:  vncipher v4,v17,v31        */
	.long  0x1302dd49    /* <+2152>:  vncipherlast v24,v2,v27    */
	.long  0x12f5bd4c    /* <+2156>:  vbpermq v23,v21,v23        */
	.long  0x13724d4e    /* <+2160>:  vpksdus v27,v18,v9         */
	.long  0x137ddd84    /* <+2164>:  vnand   v27,v29,v27        */
	.long  0x1273c5c4    /* <+2168>:  vsld    v19,v19,v24        */
	.long  0x10ad05c8    /* <+2172>:  vsbox   v5,v13             */
	.long  0x13233dce    /* <+2176>:  vpksdss v25,v3,v7          */
	.long  0x138804c7    /* <+2180>:  vcmpequd. v28,v8,v0        */
	.long  0x1340d64e    /* <+2184>:  vupkhsw v26,v26            */
	.long  0x10a73682    /* <+2188>:  vshasigmaw v5,v7,0,6       */
	.long  0x13957684    /* <+2192>:  veqv    v28,v21,v14        */
	.long  0x10289e8c    /* <+2196>:  vmrgow  v1,v8,v19          */
	.long  0x100a56c2    /* <+2200>:  vshasigmad v0,v10,0,10     */
	.long  0x10bb76c4    /* <+2204>:  vsrd    v5,v27,v14         */
	.long  0x11606ece    /* <+2208>:  vupklsw v11,v13            */
	.long  0x11c08702    /* <+2212>:  vclzb   v14,v16            */
	.long  0x1280df03    /* <+2216>:  vpopcntb v20,v27           */
	.long  0x13805f42    /* <+2220>:  vclzh   v28,v11            */
	.long  0x13004f43    /* <+2224>:  vpopcnth v24,v9            */
	.long  0x1360ff82    /* <+2228>:  vclzw   v27,v31            */
	.long  0x12209f83    /* <+2232>:  vpopcntw v17,v19           */
	.long  0x1180efc2    /* <+2236>:  vclzd   v12,v29            */
	.long  0x12e0b7c3    /* <+2240>:  vpopcntd v23,v22           */
	.long  0x1314eec7    /* <+2244>:  vcmpgtud. v24,v20,v29      */
	.long  0x1126dfc7    /* <+2248>:  vcmpgtsd. v9,v6,v27        */
	.long  0x7fced019    /* <+2252>:  lxsiwzx vs62,r14,r26       */
	.long  0x7d00c819    /* <+2256>:  lxsiwzx vs40,0,r25         */
	.long  0x7f20d098    /* <+2260>:  lxsiwax vs25,0,r26         */
	.long  0x7c601898    /* <+2264>:  lxsiwax vs3,0,r3           */
	.long  0x7fcc0067    /* <+2268>:  mfvsrd  r12,vs62           */
	.long  0x7d9400e6    /* <+2272>:  mffprwz r20,f12            */
	.long  0x7dc97118    /* <+2276>:  stxsiwx vs14,r9,r14        */
	.long  0x7ea04118    /* <+2280>:  stxsiwx vs21,0,r8          */
	.long  0x7e0b0167    /* <+2284>:  mtvsrd  vs48,r11           */
	.long  0x7ff701a7    /* <+2288>:  mtvrwa  v31,r23            */
	.long  0x7e1a01e6    /* <+2292>:  mtfprwz f16,r26            */
	.long  0x7db36c18    /* <+2296>:  lxsspx  vs13,r19,r13       */
	.long  0x7e406c18    /* <+2300>:  lxsspx  vs18,0,r13         */
	.long  0x7d622519    /* <+2304>:  stxsspx vs43,r2,r4         */
	.long  0x7ee05d19    /* <+2308>:  stxsspx vs55,0,r11         */
	.long  0xf2d0c805    /* <+2312>:  xsaddsp vs54,vs48,vs25     */
	.long  0xf1d2080c    /* <+2316>:  xsmaddasp vs14,vs50,vs1    */
	.long  0xf3565042    /* <+2320>:  xssubsp vs26,vs22,vs42     */
	.long  0xf375a04e    /* <+2324>:  xsmaddmsp vs27,vs53,vs52   */
	.long  0xf100d82a    /* <+2328>:  xsrsqrtesp vs8,vs59        */
	.long  0xf180482e    /* <+2332>:  xssqrtsp vs12,vs41         */
	.long  0xf32b0083    /* <+2336>:  xsmulsp vs57,vs11,vs32     */
	.long  0xf0d4d089    /* <+2340>:  xsmsubasp vs38,vs20,vs26   */
	.long  0xf35330c0    /* <+2344>:  xsdivsp vs26,vs19,vs6      */
	.long  0xf065b8cf    /* <+2348>:  xsmsubmsp vs35,vs37,vs55   */
	.long  0xf3604069    /* <+2352>:  xsresp  vs59,vs8           */
	.long  0xf1810c0f    /* <+2356>:  xsnmaddasp vs44,vs33,vs33  */
	.long  0xf23ef44c    /* <+2360>:  xsnmaddmsp vs17,vs62,vs30  */
	.long  0xf2d4fc8d    /* <+2364>:  xsnmsubasp vs54,vs52,vs31  */
	.long  0xf0a5d4cb    /* <+2368>:  xsnmsubmsp vs37,vs5,vs58   */
	.long  0xf3d66556    /* <+2372>:  xxlorc  vs30,vs54,vs44     */
	.long  0xf22eed91    /* <+2376>:  xxlnand vs49,vs14,vs29     */
	.long  0xf3d6f5d1    /* <+2380>:  xxleqv  vs62,vs22,vs30     */
	.long  0xf380b42f    /* <+2384>:  xscvdpspn vs60,vs54        */
	.long  0xf2c06c66    /* <+2388>:  xsrsp   vs22,vs45          */
	.long  0xf340dca2    /* <+2392>:  xscvuxdsp vs26,vs59        */
	.long  0xf0c08ce3    /* <+2396>:  xscvsxdsp vs38,vs49        */
	.long  0xf360d52d    /* <+2400>:  xscvspdpn vs59,vs26        */
	.long  0xff0e168c    /* <+2404>:  fmrgow  f24,f14,f2         */
	.long  0xfec72f8c    /* <+2408>:  fmrgew  f22,f7,f5          */
	.long  0x7c00719c    /* <+2412>:  msgsnd  r14                */
	.long  0x7c00b9dc    /* <+2416>:  msgclr  r23                */
	.long  0x7d002e99    /* <+2420>:  lxvd2x  vs40,0,r5          */
	.long  0x7d002e99    /* <+2424>:  lxvd2x  vs40,0,r5          */
	.long  0x7d543698    /* <+2428>:  lxvd2x  vs10,r20,r6        */
	.long  0x7d543698    /* <+2432>:  lxvd2x  vs10,r20,r6        */
	.long  0x7d203f99    /* <+2436>:  stxvd2x vs41,0,r7          */
	.long  0x7d203f99    /* <+2440>:  stxvd2x vs41,0,r7          */
	.long  0x7d754798    /* <+2444>:  stxvd2x vs11,r21,r8        */
	.long  0x7d754798    /* <+2448>:  stxvd2x vs11,r21,r8        */

## altivec2.d
	.long  0x7c60e20e    /* <+2452>:  lvepxl  v3,0,r28           */
	.long  0x7e64920e    /* <+2456>:  lvepxl  v19,r4,r18         */
	.long  0x7f609a4e    /* <+2460>:  lvepx   v27,0,r19          */
	.long  0x7c39924e    /* <+2464>:  lvepx   v1,r25,r18         */
	.long  0x7fe0da0a    /* <+2468>:  lvexbx  v31,0,r27          */
	.long  0x7f81620a    /* <+2472>:  lvexbx  v28,r1,r12         */
	.long  0x7fe0724a    /* <+2476>:  lvexhx  v31,0,r14          */
	.long  0x7e30fa4a    /* <+2480>:  lvexhx  v17,r16,r31        */
	.long  0x7ec0ea8a    /* <+2484>:  lvexwx  v22,0,r29          */
	.long  0x7ef92a8a    /* <+2488>:  lvexwx  v23,r25,r5         */
	.long  0x7c60660a    /* <+2492>:  lvsm    v3,0,r12           */
	.long  0x7f7d0e0a    /* <+2496>:  lvsm    v27,r29,r1         */
	.long  0x7ce036ca    /* <+2500>:  lvswxl  v7,0,r6            */
	.long  0x7cf046ca    /* <+2504>:  lvswxl  v7,r16,r8          */
	.long  0x7dc094ca    /* <+2508>:  lvswx   v14,0,r18          */
	.long  0x7f9c84ca    /* <+2512>:  lvswx   v28,r28,r16        */
	.long  0x7f60668a    /* <+2516>:  lvtlxl  v27,0,r12          */
	.long  0x7f7c068a    /* <+2520>:  lvtlxl  v27,r28,r0         */
	.long  0x7ee0cc8a    /* <+2524>:  lvtlx   v23,0,r25          */
	.long  0x7c39748a    /* <+2528>:  lvtlx   v1,r25,r14         */
	.long  0x7e80c64a    /* <+2532>:  lvtrxl  v20,0,r24          */
	.long  0x7eddc64a    /* <+2536>:  lvtrxl  v22,r29,r24        */
	.long  0x7f00444a    /* <+2540>:  lvtrx   v24,0,r8           */
	.long  0x7db7e44a    /* <+2544>:  lvtrx   v13,r23,r28        */
	.long  0x7d9c60dc    /* <+2548>:  mvidsplt v12,r28,r12       */
	.long  0x7d5b005c    /* <+2552>:  mviwsplt v10,r27,r0        */
	.long  0x7f606e0e    /* <+2556>:  stvepxl v27,0,r13          */
	.long  0x7c42fe0e    /* <+2560>:  stvepxl v2,r2,r31          */
	.long  0x7c60564e    /* <+2564>:  stvepx  v3,0,r10           */
	.long  0x7f7c064e    /* <+2568>:  stvepx  v27,r28,r0         */
	.long  0x7da0330a    /* <+2572>:  stvexbx v13,0,r6           */
	.long  0x7db91b0a    /* <+2576>:  stvexbx v13,r25,r3         */
	.long  0x7ec00b4a    /* <+2580>:  stvexhx v22,0,r1           */
	.long  0x7e2e534a    /* <+2584>:  stvexhx v17,r14,r10        */
	.long  0x7ea0db8a    /* <+2588>:  stvexwx v21,0,r27          */
	.long  0x7ff20b8a    /* <+2592>:  stvexwx v31,r18,r1         */
	.long  0x7f406f8a    /* <+2596>:  stvflxl v26,0,r13          */
	.long  0x7ecdaf8a    /* <+2600>:  stvflxl v22,r13,r21        */
	.long  0x7ca04d8a    /* <+2604>:  stvflx  v5,0,r9            */
	.long  0x7eb80d8a    /* <+2608>:  stvflx  v21,r24,r1         */
	.long  0x7da0574a    /* <+2612>:  stvfrxl v13,0,r10          */
	.long  0x7db1cf4a    /* <+2616>:  stvfrxl v13,r17,r25        */
	.long  0x7e20554a    /* <+2620>:  stvfrx  v17,0,r10          */
	.long  0x7d0cfd4a    /* <+2624>:  stvfrx  v8,r12,r31         */
	.long  0x7e40efca    /* <+2628>:  stvswxl v18,0,r29          */
	.long  0x7f4e47ca    /* <+2632>:  stvswxl v26,r14,r8         */
	.long  0x7c007dca    /* <+2636>:  stvswx  v0,0,r15           */
	.long  0x7db73dca    /* <+2640>:  stvswx  v13,r23,r7         */
	.long  0x10d18403    /* <+2644>:  vabsdub v6,v17,v16         */
	.long  0x12b22443    /* <+2648>:  vabsduh v21,v18,v4         */
	.long  0x13344c83    /* <+2652>:  vabsduw v25,v20,v9         */
	.long  0x10d1a6ad    /* <+2656>:  vpermxor v6,v17,v20,v26    */
	.long  0x13ba7f3c    /* <+2660>:  vaddeuqm v29,v26,v15,v28   */
	.long  0x11e83e3d    /* <+2664>:  vaddecuq v15,v8,v7,v24     */
	.long  0x1046a87e    /* <+2668>:  vsubeuqm v2,v6,v21,v1      */
	.long  0x13a6013f    /* <+2672>:  vsubecuq v29,v6,v0,v4      */
	.long  0x11c91888    /* <+2676>:  vmulouw v14,v9,v3          */
	.long  0x13109089    /* <+2680>:  vmuluwm v24,v16,v18        */
	.long  0x115188c0    /* <+2684>:  vaddudm v10,v17,v17        */
	.long  0x13d920c2    /* <+2688>:  vmaxud  v30,v25,v4         */
	.long  0x1146e0c4    /* <+2692>:  vrld    v10,v6,v28         */
	.long  0x136738c7    /* <+2696>:  vcmpequd v27,v7,v7         */
	.long  0x12d0c900    /* <+2700>:  vadduqm v22,v16,v25        */
	.long  0x1035e940    /* <+2704>:  vaddcuq v1,v21,v29         */
	.long  0x128b9988    /* <+2708>:  vmulosw v20,v11,v19        */
	.long  0x131309c2    /* <+2712>:  vmaxsd  v24,v19,v1         */
	.long  0x11bbf288    /* <+2716>:  vmuleuw v13,v27,v30        */
	.long  0x11388ac2    /* <+2720>:  vminud  v9,v24,v17         */
	.long  0x1152e2c7    /* <+2724>:  vcmpgtud v10,v18,v28       */
	.long  0x101db388    /* <+2728>:  vmulesw v0,v29,v22         */
	.long  0x11bc0bc2    /* <+2732>:  vminsd  v13,v28,v1         */
	.long  0x11542bc4    /* <+2736>:  vsrad   v10,v20,v5         */
	.long  0x13752bc7    /* <+2740>:  vcmpgtsd v27,v21,v5        */
	.long  0x1017f601    /* <+2744>:  bcdadd. v0,v23,v30,1       */
	.long  0x1338d408    /* <+2748>:  vpmsumb v25,v24,v26        */
	.long  0x11042641    /* <+2752>:  bcdsub. v8,v4,v4,1         */
	.long  0x120ed448    /* <+2756>:  vpmsumh v16,v14,v26        */
	.long  0x1362d44e    /* <+2760>:  vpkudum v27,v2,v26         */
	.long  0x10d78c88    /* <+2764>:  vpmsumw v6,v23,v17         */
	.long  0x1286ccc8    /* <+2768>:  vpmsumd v20,v6,v25         */
	.long  0x137684ce    /* <+2772>:  vpkudus v27,v22,v16        */
	.long  0x12b494c0    /* <+2776>:  vsubudm v21,v20,v18        */
	.long  0x12b49500    /* <+2780>:  vsubuqm v21,v20,v18        */
	.long  0x13bd3508    /* <+2784>:  vcipher v29,v29,v6         */
	.long  0x104da509    /* <+2788>:  vcipherlast v2,v13,v20     */
	.long  0x1280950c    /* <+2792>:  vgbbd   v20,v18            */
	.long  0x1268cd40    /* <+2796>:  vsubcuq v19,v8,v25         */
	.long  0x113aed44    /* <+2800>:  vorc    v9,v26,v29         */
	.long  0x12946d48    /* <+2804>:  vncipher v20,v20,v13       */
	.long  0x11e5dd49    /* <+2808>:  vncipherlast v15,v5,v27    */
	.long  0x1073354c    /* <+2812>:  vbpermq v3,v19,v6          */
	.long  0x13c4e54e    /* <+2816>:  vpksdus v30,v4,v28         */
	.long  0x10047584    /* <+2820>:  vnand   v0,v4,v14          */
	.long  0x1228edc4    /* <+2824>:  vsld    v17,v8,v29         */
	.long  0x13b405c8    /* <+2828>:  vsbox   v29,v20            */
	.long  0x11675dce    /* <+2832>:  vpksdss v11,v7,v11         */
	.long  0x107384c7    /* <+2836>:  vcmpequd. v3,v19,v16       */
	.long  0x12408e4e    /* <+2840>:  vupkhsw v18,v17            */
	.long  0x13a86e82    /* <+2844>:  vshasigmaw v29,v8,0,13     */
	.long  0x12fcd684    /* <+2848>:  veqv    v23,v28,v26        */
	.long  0x13a0178c    /* <+2852>:  vmrgew  v29,v0,v2          */
	.long  0x13a0168c    /* <+2856>:  vmrgow  v29,v0,v2          */
	.long  0x137306c2    /* <+2860>:  vshasigmad v27,v19,0,0     */
	.long  0x129ce6c4    /* <+2864>:  vsrd    v20,v28,v28        */
	.long  0x1240aece    /* <+2868>:  vupklsw v18,v21            */
	.long  0x13c03f02    /* <+2872>:  vclzb   v30,v7             */
	.long  0x13a0af03    /* <+2876>:  vpopcntb v29,v21           */
	.long  0x1320af42    /* <+2880>:  vclzh   v25,v21            */
	.long  0x1200f743    /* <+2884>:  vpopcnth v16,v30           */
	.long  0x13801f82    /* <+2888>:  vclzw   v28,v3             */
	.long  0x11404f83    /* <+2892>:  vpopcntw v10,v9            */
	.long  0x12c04fc2    /* <+2896>:  vclzd   v22,v9             */
	.long  0x11e0f7c3    /* <+2900>:  vpopcntd v15,v30           */
	.long  0x105f36c7    /* <+2904>:  vcmpgtud. v2,v31,v6        */
	.long  0x128f17c7    /* <+2908>:  vcmpgtsd. v20,v15,v2       */

## vsd2.d
	.long  0x7fced019    /* <+2912>:  lxsiwzx vs62,r14,r26       */
	.long  0x7d00c819    /* <+2916>:  lxsiwzx vs40,0,r25         */
	.long  0x7f20d098    /* <+2920>:  lxsiwax vs25,0,r26         */
	.long  0x7c601898    /* <+2924>:  lxsiwax vs3,0,r3           */
	.long  0x7fcc0066    /* <+2928>:  mfvsrd  r12,vs30           */
	.long  0x7fcc0066    /* <+2932>:  mfvsrd  r12,vs30           */
	.long  0x7fcc0067    /* <+2936>:  mfvsrd  r12,vs62           */
	.long  0x7fcc0067    /* <+2940>:  mfvsrd  r12,vs62           */
	.long  0x7d9400e6    /* <+2944>:  mffprwz r20,f12            */
	.long  0x7d9400e6    /* <+2948>:  mffprwz r20,f12            */
	.long  0x7d9500e7    /* <+2952>:  mfvrwz  r21,v12            */
	.long  0x7d9500e7    /* <+2956>:  mfvrwz  r21,v12            */
	.long  0x7dc97118    /* <+2960>:  stxsiwx vs14,r9,r14        */
	.long  0x7ea04118    /* <+2964>:  stxsiwx vs21,0,r8          */
	.long  0x7d7c0166    /* <+2968>:  mtvsrd  vs11,r28           */
	.long  0x7d7c0166    /* <+2972>:  mtvsrd  vs11,r28           */
	.long  0x7d7d0167    /* <+2976>:  mtvsrd  vs43,r29           */
	.long  0x7d7d0167    /* <+2980>:  mtvsrd  vs43,r29           */
	.long  0x7f1601a6    /* <+2984>:  mtfprwa f24,r22            */
	.long  0x7f1601a6    /* <+2988>:  mtfprwa f24,r22            */
	.long  0x7f3701a7    /* <+2992>:  mtvrwa  v25,r23            */
	.long  0x7f3701a7    /* <+2996>:  mtvrwa  v25,r23            */
	.long  0x7f5b01e6    /* <+3000>:  mtfprwz f26,r27            */
	.long  0x7f5b01e6    /* <+3004>:  mtfprwz f26,r27            */
	.long  0x7f7c01e7    /* <+3008>:  mtvrwz  v27,r28            */
	.long  0x7f7c01e7    /* <+3012>:  mtvrwz  v27,r28            */
	.long  0x7db36c18    /* <+3016>:  lxsspx  vs13,r19,r13       */
	.long  0x7e406c18    /* <+3020>:  lxsspx  vs18,0,r13         */
	.long  0x7d622519    /* <+3024>:  stxsspx vs43,r2,r4         */
	.long  0x7ee05d19    /* <+3028>:  stxsspx vs55,0,r11         */
	.long  0xf2d0c805    /* <+3032>:  xsaddsp vs54,vs48,vs25     */
	.long  0xf1d2080c    /* <+3036>:  xsmaddasp vs14,vs50,vs1    */
	.long  0xf3565042    /* <+3040>:  xssubsp vs26,vs22,vs42     */
	.long  0xf375a04e    /* <+3044>:  xsmaddmsp vs27,vs53,vs52   */
	.long  0xf100d82a    /* <+3048>:  xsrsqrtesp vs8,vs59        */
	.long  0xf180482e    /* <+3052>:  xssqrtsp vs12,vs41         */
	.long  0xf32b0083    /* <+3056>:  xsmulsp vs57,vs11,vs32     */
	.long  0xf0d4d089    /* <+3060>:  xsmsubasp vs38,vs20,vs26   */
	.long  0xf35330c0    /* <+3064>:  xsdivsp vs26,vs19,vs6      */
	.long  0xf065b8cf    /* <+3068>:  xsmsubmsp vs35,vs37,vs55   */
	.long  0xf3604069    /* <+3072>:  xsresp  vs59,vs8           */
	.long  0xf1810c0f    /* <+3076>:  xsnmaddasp vs44,vs33,vs33  */
	.long  0xf23ef44c    /* <+3080>:  xsnmaddmsp vs17,vs62,vs30  */
	.long  0xf2d4fc8d    /* <+3084>:  xsnmsubasp vs54,vs52,vs31  */
	.long  0xf0a5d4cb    /* <+3088>:  xsnmsubmsp vs37,vs5,vs58   */
	.long  0xf3d66556    /* <+3092>:  xxlorc  vs30,vs54,vs44     */
	.long  0xf22eed91    /* <+3096>:  xxlnand vs49,vs14,vs29     */
	.long  0xf3d6f5d1    /* <+3100>:  xxleqv  vs62,vs22,vs30     */
	.long  0xf380b42f    /* <+3104>:  xscvdpspn vs60,vs54        */
	.long  0xf2c06c66    /* <+3108>:  xsrsp   vs22,vs45          */
	.long  0xf340dca2    /* <+3112>:  xscvuxdsp vs26,vs59        */
	.long  0xf0c08ce3    /* <+3116>:  xscvsxdsp vs38,vs49        */
	.long  0xf360d52d    /* <+3120>:  xscvspdpn vs59,vs26        */
	.long  0xff0e168c    /* <+3124>:  fmrgow  f24,f14,f2         */
	.long  0xfec72f8c    /* <+3128>:  fmrgew  f22,f7,f5          */

## power9.d
	.long  0x7da30474    /* <+3132>:  cnttzd  r3,r13             */
	.long  0x7dc40475    /* <+3136>:  cnttzd. r4,r14             */
	.long  0x7de50434    /* <+3140>:  cnttzw  r5,r15             */
	.long  0x7e060435    /* <+3144>:  cnttzw. r6,r16             */
	.long  0x7d54ae12    /* <+3148>:  modsd   r10,r20,r21        */
	.long  0x7d75b616    /* <+3152>:  modsw   r11,r21,r22        */
	.long  0x7d96ba12    /* <+3156>:  modud   r12,r22,r23        */
	.long  0x7db7c216    /* <+3160>:  moduw   r13,r23,r24        */
	.long  0x10672581    /* <+3164>:  bcdcfn. v3,v4,0            */
	.long  0x10672781    /* <+3168>:  bcdcfn. v3,v4,1            */
	.long  0x10822d81    /* <+3172>:  bcdcfsq. v4,v5,0           */
	.long  0x10822f81    /* <+3176>:  bcdcfsq. v4,v5,1           */
	.long  0x10a63581    /* <+3180>:  bcdcfz. v5,v6,0            */
	.long  0x10a63781    /* <+3184>:  bcdcfz. v5,v6,1            */
	.long  0x10c74341    /* <+3188>:  bcdcpsgn. v6,v7,v8         */
	.long  0x10e54581    /* <+3192>:  bcdctn. v7,v8              */
	.long  0x11004d81    /* <+3196>:  bcdctsq. v8,v9             */
	.long  0x11245581    /* <+3200>:  bcdctz. v9,v10,0           */
	.long  0x11245781    /* <+3204>:  bcdctz. v9,v10,1           */
	.long  0x115f5d81    /* <+3208>:  bcdsetsgn. v10,v11,0       */
	.long  0x115f5f81    /* <+3212>:  bcdsetsgn. v10,v11,1       */
	.long  0x116c6dc1    /* <+3216>:  bcdsr.  v11,v12,v13,0      */
	.long  0x116c6fc1    /* <+3220>:  bcdsr.  v11,v12,v13,1      */
	.long  0x118d74c1    /* <+3224>:  bcds.   v12,v13,v14,0      */
	.long  0x118d76c1    /* <+3228>:  bcds.   v12,v13,v14,1      */
	.long  0x11ae7d01    /* <+3232>:  bcdtrunc. v13,v14,v15,0    */
	.long  0x11ae7f01    /* <+3236>:  bcdtrunc. v13,v14,v15,1    */
	.long  0x11cf8481    /* <+3240>:  bcdus.  v14,v15,v16        */
	.long  0x11f08d41    /* <+3244>:  bcdutrunc. v15,v16,v17     */
	.long  0x7e80aa5a    /* <+3248>:  lxvll   vs20,0,r21         */
	.long  0x7e8aaa5a    /* <+3252>:  lxvll   vs20,r10,r21       */
	.long  0x7ea05b5a    /* <+3256>:  stxvll  vs21,0,r11         */
	.long  0x7eaa5b5a    /* <+3260>:  stxvll  vs21,r10,r11       */
	.long  0x12d70001    /* <+3264>:  vmul10cuq v22,v23          */
	.long  0x12f8c841    /* <+3268>:  vmul10ecuq v23,v24,v25     */
	.long  0x1319d241    /* <+3272>:  vmul10euq v24,v25,v26      */
	.long  0x133a0201    /* <+3276>:  vmul10uq v25,v26           */
	.long  0xfd4b6008    /* <+3280>:  xsaddqp v10,v11,v12        */
	.long  0xfd6c6009    /* <+3284>:  xsaddqpo v11,v12,v12       */
	.long  0xfe80f00a    /* <+3288>:  xsrqpi  0,v20,v30,0        */
	.long  0xfe81f00a    /* <+3292>:  xsrqpi  1,v20,v30,0        */
	.long  0xfe80f60a    /* <+3296>:  xsrqpi  0,v20,v30,3        */
	.long  0xfe81f60a    /* <+3300>:  xsrqpi  1,v20,v30,3        */
	.long  0xfea0f80b    /* <+3304>:  xsrqpix 0,v21,v31,0        */
	.long  0xfea1f80b    /* <+3308>:  xsrqpix 1,v21,v31,0        */
	.long  0xfea0fe0b    /* <+3312>:  xsrqpix 0,v21,v31,3        */
	.long  0xfea1fe0b    /* <+3316>:  xsrqpix 1,v21,v31,3        */
	.long  0xfd8d7048    /* <+3320>:  xsmulqp v12,v13,v14        */
	.long  0xfdae7849    /* <+3324>:  xsmulqpo v13,v14,v15       */
	.long  0xfec0b84a    /* <+3328>:  xsrqpxp 0,v22,v23,0        */
	.long  0xfec1b84a    /* <+3332>:  xsrqpxp 1,v22,v23,0        */
	.long  0xfec0be4a    /* <+3336>:  xsrqpxp 0,v22,v23,3        */
	.long  0xfec1be4a    /* <+3340>:  xsrqpxp 1,v22,v23,3        */
	.long  0xfdcf80c8    /* <+3344>:  xscpsgnqp v14,v15,v16      */
	.long  0xfc0f8108    /* <+3348>:  xscmpoqp cr0,v15,v16       */
	.long  0xff8f8108    /* <+3352>:  xscmpoqp cr7,v15,v16       */
	.long  0xfc108948    /* <+3356>:  xscmpexpqp cr0,v16,v17     */
	.long  0xff908948    /* <+3360>:  xscmpexpqp cr7,v16,v17     */
	.long  0xfe329b08    /* <+3364>:  xsmaddqp v17,v18,v19       */
	.long  0xfe53a309    /* <+3368>:  xsmaddqpo v18,v19,v20      */
	.long  0xfe74ab48    /* <+3372>:  xsmsubqp v19,v20,v21       */
	.long  0xfe95b349    /* <+3376>:  xsmsubqpo v20,v21,v22      */
	.long  0xfeb6bb88    /* <+3380>:  xsnmaddqp v21,v22,v23      */
	.long  0xfed7c389    /* <+3384>:  xsnmaddqpo v22,v23,v24     */
	.long  0xfef8cbc8    /* <+3388>:  xsnmsubqp v23,v24,v25      */
	.long  0xff19d3c9    /* <+3392>:  xsnmsubqpo v24,v25,v26     */
	.long  0xff3adc08    /* <+3396>:  xssubqp v25,v26,v27        */
	.long  0xff5be409    /* <+3400>:  xssubqpo v26,v27,v28       */
	.long  0xff7cec48    /* <+3404>:  xsdivqp v27,v28,v29        */
	.long  0xff9df449    /* <+3408>:  xsdivqpo v28,v29,v30       */
	.long  0xfc1df508    /* <+3412>:  xscmpuqp cr0,v29,v30       */
	.long  0xff9df508    /* <+3416>:  xscmpuqp cr7,v29,v30       */
	.long  0xfc00f588    /* <+3420>:  xststdcqp cr0,v30,0        */
	.long  0xff80f588    /* <+3424>:  xststdcqp cr7,v30,0        */
	.long  0xfc7ffd88    /* <+3428>:  xststdcqp cr0,v31,127      */
	.long  0xfffffd88    /* <+3432>:  xststdcqp cr7,v31,127      */
	.long  0xfd405e48    /* <+3436>:  xsabsqp v10,v11            */
	.long  0xfd626648    /* <+3440>:  xsxexpqp v11,v12           */
	.long  0xfd886e48    /* <+3444>:  xsnabsqp v12,v13           */
	.long  0xfdb07648    /* <+3448>:  xsnegqp v13,v14            */
	.long  0xfdd27e48    /* <+3452>:  xsxsigqp v14,v15           */
	.long  0xfdfb8648    /* <+3456>:  xssqrtqp v15,v16           */
	.long  0xfe1b8e49    /* <+3460>:  xssqrtqpo v16,v17          */
	.long  0xfe219688    /* <+3464>:  xscvqpuwz v17,v18          */
	.long  0xfe429e88    /* <+3468>:  xscvudqp v18,v19           */
	.long  0xfe69a688    /* <+3472>:  xscvqpswz v19,v20          */
	.long  0xfe8aae88    /* <+3476>:  xscvsdqp v20,v21           */
	.long  0xfeb1b688    /* <+3480>:  xscvqpudz v21,v22          */
	.long  0xfed4be88    /* <+3484>:  xscvqpdp v22,v23           */
	.long  0xfef4c689    /* <+3488>:  xscvqpdpo v23,v24          */
	.long  0xff16ce88    /* <+3492>:  xscvdpqp v24,v25           */
	.long  0xff39d688    /* <+3496>:  xscvqpsdz v25,v26          */
	.long  0xff5be6c8    /* <+3500>:  xsiexpqp v26,v27,v28       */
	.long  0x108531fb    /* <+3504>:  vpermr  v4,v5,v6,v7        */
	.long  0x10a0320d    /* <+3508>:  vextractub v5,v6,0         */
	.long  0x10af320d    /* <+3512>:  vextractub v5,v6,15        */
	.long  0x10c03a4d    /* <+3516>:  vextractuh v6,v7,0         */
	.long  0x10cf3a4d    /* <+3520>:  vextractuh v6,v7,15        */
	.long  0x10e0428d    /* <+3524>:  vextractuw v7,v8,0         */
	.long  0x10ef428d    /* <+3528>:  vextractuw v7,v8,15        */
	.long  0x11004acd    /* <+3532>:  vextractd v8,v9,0          */
	.long  0x110f4acd    /* <+3536>:  vextractd v8,v9,15         */
	.long  0x1120530d    /* <+3540>:  vinsertb v9,v10,0          */
	.long  0x112f530d    /* <+3544>:  vinsertb v9,v10,15         */
	.long  0x11405b4d    /* <+3548>:  vinserth v10,v11,0         */
	.long  0x114f5b4d    /* <+3552>:  vinserth v10,v11,15        */
	.long  0x1160638d    /* <+3556>:  vinsertw v11,v12,0         */
	.long  0x116f638d    /* <+3560>:  vinsertw v11,v12,15        */
	.long  0x11806bcd    /* <+3564>:  vinsertd v12,v13,0         */
	.long  0x118f6bcd    /* <+3568>:  vinsertd v12,v13,15        */
	.long  0x7db40267    /* <+3572>:  mfvsrld r20,vs45           */
	.long  0x7dd50327    /* <+3576>:  mtvsrws vs46,r21           */
	.long  0x7de0bb67    /* <+3580>:  mtvsrdd vs47,0,r23         */
	.long  0x7df6bb67    /* <+3584>:  mtvsrdd vs47,r22,r23       */
	.long  0x7e405a19    /* <+3588>:  lxvx    vs50,0,r11         */
	.long  0x7c0a5a18    /* <+3592>:  lxvx    vs0,r10,r11        */
	.long  0x7e6062d9    /* <+3596>:  lxvwsx  vs51,0,r12         */
	.long  0x7c2a62d8    /* <+3600>:  lxvwsx  vs1,r10,r12        */
	.long  0x7e806e59    /* <+3604>:  lxvh8x  vs52,0,r13         */
	.long  0x7c4a6e58    /* <+3608>:  lxvh8x  vs2,r10,r13        */
	.long  0x7ea076d9    /* <+3612>:  lxvb16x vs53,0,r14         */
	.long  0x7c6a76d8    /* <+3616>:  lxvb16x vs3,r10,r14        */
	.long  0x7ec07b19    /* <+3620>:  stxvx   vs54,0,r15         */
	.long  0x7c947b18    /* <+3624>:  stxvx   vs4,r20,r15        */
	.long  0x7ee08759    /* <+3628>:  stxvh8x vs55,0,r16         */
	.long  0x7cb48758    /* <+3632>:  stxvh8x vs5,r20,r16        */
	.long  0x7f008fd9    /* <+3636>:  stxvb16x vs56,0,r17        */
	.long  0x7cd48fd8    /* <+3640>:  stxvb16x vs6,r20,r17       */
	.long  0xf0802a94    /* <+3644>:  xxextractuw vs4,vs5,0      */
	.long  0xf10f9297    /* <+3648>:  xxextractuw vs40,vs50,15   */
	.long  0xf08002d0    /* <+3652>:  xxspltib vs4,0             */
	.long  0xf127fad1    /* <+3656>:  xxspltib vs41,255          */
	.long  0xf0a032d4    /* <+3660>:  xxinsertw vs5,vs6,0        */
	.long  0xf24fe2d7    /* <+3664>:  xxinsertw vs50,vs60,15     */
	.long  0xf0c73f6c    /* <+3668>:  xxbrh   vs6,vs7            */
	.long  0xf307cf6f    /* <+3672>:  xxbrh   vs56,vs57          */
	.long  0xf0ef476c    /* <+3676>:  xxbrw   vs7,vs8            */
	.long  0xf32fd76f    /* <+3680>:  xxbrw   vs57,vs58          */
	.long  0xf1174f6c    /* <+3684>:  xxbrd   vs8,vs9            */
	.long  0xf357df6f    /* <+3688>:  xxbrd   vs58,vs59          */
	.long  0xf13f576c    /* <+3692>:  xxbrq   vs9,vs10           */
	.long  0xf37fe76f    /* <+3696>:  xxbrq   vs59,vs60          */
	.long  0xe6800002    /* <+3700>:  lxsd    v20,0(0)           */
	.long  0xe68a0002    /* <+3704>:  lxsd    v20,0(r10)         */
	.long  0xe680000a    /* <+3708>:  lxsd    v20,8(0)           */
	.long  0xe68a000a    /* <+3712>:  lxsd    v20,8(r10)         */
	.long  0xe680fffa    /* <+3716>:  lxsd    v20,-8(0)          */
	.long  0xe68afffa    /* <+3720>:  lxsd    v20,-8(r10)        */
	.long  0xe6807ffe    /* <+3724>:  lxsd    v20,32764(0)       */
	.long  0xe68a7ffe    /* <+3728>:  lxsd    v20,32764(r10)     */
	.long  0xe6808002    /* <+3732>:  lxsd    v20,-32768(0)      */
	.long  0xe68a8002    /* <+3736>:  lxsd    v20,-32768(r10)    */
	.long  0xe7c00003    /* <+3740>:  lxssp   v30,0(0)           */
	.long  0xe7cb0003    /* <+3744>:  lxssp   v30,0(r11)         */
	.long  0xe7c0000b    /* <+3748>:  lxssp   v30,8(0)           */
	.long  0xe7cb000b    /* <+3752>:  lxssp   v30,8(r11)         */
	.long  0xe7c0fffb    /* <+3756>:  lxssp   v30,-8(0)          */
	.long  0xe7cbfffb    /* <+3760>:  lxssp   v30,-8(r11)        */
	.long  0xe7c07fff    /* <+3764>:  lxssp   v30,32764(0)       */
	.long  0xe7cb7fff    /* <+3768>:  lxssp   v30,32764(r11)     */
	.long  0xe7c08003    /* <+3772>:  lxssp   v30,-32768(0)      */
	.long  0xe7cb8003    /* <+3776>:  lxssp   v30,-32768(r11)    */
	.long  0xf5000009    /* <+3780>:  lxv     vs40,0(0)          */
	.long  0xf50c0009    /* <+3784>:  lxv     vs40,0(r12)        */
	.long  0xf5000019    /* <+3788>:  lxv     vs40,16(0)         */
	.long  0xf50c0019    /* <+3792>:  lxv     vs40,16(r12)       */
	.long  0xf500fff9    /* <+3796>:  lxv     vs40,-16(0)        */
	.long  0xf54cfff1    /* <+3800>:  lxv     vs10,-16(r12)      */
	.long  0xf5407ff1    /* <+3804>:  lxv     vs10,32752(0)      */
	.long  0xf54c7ff1    /* <+3808>:  lxv     vs10,32752(r12)    */
	.long  0xf5408001    /* <+3812>:  lxv     vs10,-32768(0)     */
	.long  0xf54c8001    /* <+3816>:  lxv     vs10,-32768(r12)   */
	.long  0xf6a00002    /* <+3820>:  stxsd   v21,0(0)           */
	.long  0xf6aa0002    /* <+3824>:  stxsd   v21,0(r10)         */
	.long  0xf6a0000a    /* <+3828>:  stxsd   v21,8(0)           */
	.long  0xf6aa000a    /* <+3832>:  stxsd   v21,8(r10)         */
	.long  0xf6a0fffa    /* <+3836>:  stxsd   v21,-8(0)          */
	.long  0xf6aafffa    /* <+3840>:  stxsd   v21,-8(r10)        */
	.long  0xf6a07ffe    /* <+3844>:  stxsd   v21,32764(0)       */
	.long  0xf6aa7ffe    /* <+3848>:  stxsd   v21,32764(r10)     */
	.long  0xf6a08002    /* <+3852>:  stxsd   v21,-32768(0)      */
	.long  0xf6aa8002    /* <+3856>:  stxsd   v21,-32768(r10)    */
	.long  0xf7e00003    /* <+3860>:  stxssp  v31,0(0)           */
	.long  0xf7eb0003    /* <+3864>:  stxssp  v31,0(r11)         */
	.long  0xf7e0000b    /* <+3868>:  stxssp  v31,8(0)           */
	.long  0xf7eb000b    /* <+3872>:  stxssp  v31,8(r11)         */
	.long  0xf7e0fffb    /* <+3876>:  stxssp  v31,-8(0)          */
	.long  0xf7ebfffb    /* <+3880>:  stxssp  v31,-8(r11)        */
	.long  0xf7e07fff    /* <+3884>:  stxssp  v31,32764(0)       */
	.long  0xf7eb7fff    /* <+3888>:  stxssp  v31,32764(r11)     */
	.long  0xf7e08003    /* <+3892>:  stxssp  v31,-32768(0)      */
	.long  0xf7eb8003    /* <+3896>:  stxssp  v31,-32768(r11)    */
	.long  0xf520000d    /* <+3900>:  stxv    vs41,0(0)          */
	.long  0xf52c000d    /* <+3904>:  stxv    vs41,0(r12)        */
	.long  0xf520001d    /* <+3908>:  stxv    vs41,16(0)         */
	.long  0xf52c001d    /* <+3912>:  stxv    vs41,16(r12)       */
	.long  0xf520fffd    /* <+3916>:  stxv    vs41,-16(0)        */
	.long  0xf56cfff5    /* <+3920>:  stxv    vs11,-16(r12)      */
	.long  0xf5607ff5    /* <+3924>:  stxv    vs11,32752(0)      */
	.long  0xf56c7ff5    /* <+3928>:  stxv    vs11,32752(r12)    */
	.long  0xf5608005    /* <+3932>:  stxv    vs11,-32768(0)     */
	.long  0xf56c8005    /* <+3936>:  stxv    vs11,-32768(r12)   */
	.long  0xf296c0d0    /* <+3940>:  xxperm  vs20,vs22,vs24     */
	.long  0xf10a60d7    /* <+3944>:  xxperm  vs40,vs42,vs44     */
	.long  0xf2b7c9d0    /* <+3948>:  xxpermr vs21,vs23,vs25     */
	.long  0xf12b69d7    /* <+3952>:  xxpermr vs41,vs43,vs45     */
	.long  0x7e8c06f4    /* <+3956>:  extswsli r12,r20,0         */
	.long  0x7e8c0ef4    /* <+3960>:  extswsli r12,r20,1         */
	.long  0x7e8cfef6    /* <+3964>:  extswsli r12,r20,63        */
	.long  0x7ead06f5    /* <+3968>:  extswsli. r13,r21,0        */
	.long  0x7ead0ef5    /* <+3972>:  extswsli. r13,r21,1        */
	.long  0x7eadfef7    /* <+3976>:  extswsli. r13,r21,63       */
	.long  0x11d6b885    /* <+3980>:  vrlwmi  v14,v22,v23        */
	.long  0x11f7c0c5    /* <+3984>:  vrldmi  v15,v23,v24        */
	.long  0x1218c985    /* <+3988>:  vrlwnm  v16,v24,v25        */
	.long  0x1239d1c5    /* <+3992>:  vrldnm  v17,v25,v26        */
	.long  0x125addcc    /* <+3996>:  vbpermd v18,v26,v27        */
	.long  0x1266a602    /* <+4000>:  vnegw   v19,v20            */
	.long  0x1287ae02    /* <+4004>:  vnegd   v20,v21            */
	.long  0x12a8b602    /* <+4008>:  vprtybw v21,v22            */
	.long  0x12c9be02    /* <+4012>:  vprtybd v22,v23            */
	.long  0x12eac602    /* <+4016>:  vprtybq v23,v24            */
	.long  0x1310ce02    /* <+4020>:  vextsb2w v24,v25           */
	.long  0x1331d602    /* <+4024>:  vextsh2w v25,v26           */
	.long  0x1358de02    /* <+4028>:  vextsb2d v26,v27           */
	.long  0x1379e602    /* <+4032>:  vextsh2d v27,v28           */
	.long  0x139aee02    /* <+4036>:  vextsw2d v28,v29           */
	.long  0x13bcf602    /* <+4040>:  vctzb   v29,v30            */
	.long  0x13ddfe02    /* <+4044>:  vctzh   v30,v31            */
	.long  0x13fef602    /* <+4048>:  vctzw   v31,v30            */
	.long  0x13dfee02    /* <+4052>:  vctzd   v30,v29            */
	.long  0x7d40a61a    /* <+4056>:  lxsibzx vs10,0,r20         */
	.long  0x7e4aa61b    /* <+4060>:  lxsibzx vs50,r10,r20       */
	.long  0x7d60ae5a    /* <+4064>:  lxsihzx vs11,0,r21         */
	.long  0x7e6bae5b    /* <+4068>:  lxsihzx vs51,r11,r21       */
	.long  0x7d80b71a    /* <+4072>:  stxsibx vs12,0,r22         */
	.long  0x7e8cb71b    /* <+4076>:  stxsibx vs52,r12,r22       */
	.long  0x7da0bf5a    /* <+4080>:  stxsihx vs13,0,r23         */
	.long  0x7eadbf5b    /* <+4084>:  stxsihx vs53,r13,r23       */
	.long  0x114b6370    /* <+4088>:  maddhd  r10,r11,r12,r13    */
	.long  0x1295b5f1    /* <+4092>:  maddhdu r20,r21,r22,r23    */
	.long  0x10432173    /* <+4096>:  maddld  r2,r3,r4,r5        */
	.long  0xf00aa1d8    /* <+4100>:  xscmpexpdp cr0,vs10,vs20   */
	.long  0xf38891de    /* <+4104>:  xscmpexpdp cr7,vs40,vs50   */
	.long  0xf12baf2d    /* <+4108>:  xsiexpdp vs41,r11,r21      */
	.long  0xf07f5da8    /* <+4112>:  xststdcdp cr0,vs11,127     */
	.long  0xf3ff4daa    /* <+4116>:  xststdcdp cr7,vs41,127     */
	.long  0xf07f5ca8    /* <+4120>:  xststdcsp cr0,vs11,127     */
	.long  0xf3ff4caa    /* <+4124>:  xststdcsp cr7,vs41,127     */
	.long  0xf1a05d6e    /* <+4128>:  xsxexpdp r13,vs43          */
	.long  0xf1c1656e    /* <+4132>:  xsxsigdp r14,vs44          */
	.long  0xf1ae7fc7    /* <+4136>:  xviexpdp vs45,vs46,vs47    */
	.long  0xf1cf86c7    /* <+4140>:  xviexpsp vs46,vs47,vs48    */
	.long  0xf2c0bfab    /* <+4144>:  xvtstdcdp vs54,vs55,0      */
	.long  0xf2dfbfef    /* <+4148>:  xvtstdcdp vs54,vs55,127    */
	.long  0xf2e0c6ab    /* <+4152>:  xvtstdcsp vs55,vs56,0      */
	.long  0xf2ffc6ef    /* <+4156>:  xvtstdcsp vs55,vs56,127    */
	.long  0xf320d76f    /* <+4160>:  xvxexpdp vs57,vs58         */
	.long  0xf348df6f    /* <+4164>:  xvxexpsp vs58,vs59         */
	.long  0xf361e76f    /* <+4168>:  xvxsigdp vs59,vs60         */
	.long  0xf389ef6f    /* <+4172>:  xvxsigsp vs60,vs61         */
	.long  0x7c0639c0    /* <+4176>:  cmpeqb  cr0,r6,r7          */
	.long  0x7f8639c0    /* <+4180>:  cmpeqb  cr7,r6,r7          */
	.long  0x7c084980    /* <+4184>:  cmprb   cr0,0,r8,r9        */
	.long  0x7f884980    /* <+4188>:  cmprb   cr7,0,r8,r9        */
	.long  0x7c284980    /* <+4192>:  cmprb   cr0,1,r8,r9        */
	.long  0x7fa84980    /* <+4196>:  cmprb   cr7,1,r8,r9        */
	.long  0x7de00100    /* <+4200>:  setb    r15,cr0            */
	.long  0x7dfc0100    /* <+4204>:  setb    r15,cr7            */
	.long  0x7f40521a    /* <+4208>:  lxvl    vs26,0,r10         */
	.long  0x7f14521b    /* <+4212>:  lxvl    vs56,r20,r10       */
	.long  0x7f605b1a    /* <+4216>:  stxvl   vs27,0,r11         */
	.long  0x7f355b1b    /* <+4220>:  stxvl   vs57,r21,r11       */
	.long  0x1280f602    /* <+4224>:  vclzlsbb r20,v30           */
	.long  0x12a1fe02    /* <+4228>:  vctzlsbb r21,v31           */
	.long  0x114b6007    /* <+4232>:  vcmpneb v10,v11,v12        */
	.long  0x1295b407    /* <+4236>:  vcmpneb. v20,v21,v22       */
	.long  0x116c6847    /* <+4240>:  vcmpneh v11,v12,v13        */
	.long  0x12b6bc47    /* <+4244>:  vcmpneh. v21,v22,v23       */
	.long  0x118d7087    /* <+4248>:  vcmpnew v12,v13,v14        */
	.long  0x12d7c487    /* <+4252>:  vcmpnew. v22,v23,v24       */
	.long  0x11ae7907    /* <+4256>:  vcmpnezb v13,v14,v15       */
	.long  0x12f8cd07    /* <+4260>:  vcmpnezb. v23,v24,v25      */
	.long  0x11cf8147    /* <+4264>:  vcmpnezh v14,v15,v16       */
	.long  0x1319d547    /* <+4268>:  vcmpnezh. v24,v25,v26      */
	.long  0x11f08987    /* <+4272>:  vcmpnezw v15,v16,v17       */
	.long  0x133add87    /* <+4276>:  vcmpnezw. v25,v26,v27      */
	.long  0x1211560d    /* <+4280>:  vextublx r16,r17,v10       */
	.long  0x12325f0d    /* <+4284>:  vextubrx r17,r18,v11       */
	.long  0x1253664d    /* <+4288>:  vextuhlx r18,r19,v12       */
	.long  0x12746f4d    /* <+4292>:  vextuhrx r19,r20,v13       */
	.long  0x1295768d    /* <+4296>:  vextuwlx r20,r21,v14       */
	.long  0x12b67f8d    /* <+4300>:  vextuwrx r21,r22,v15       */
	.long  0xec001d46    /* <+4304>:  dtstsfi cr0,0,f3           */
	.long  0xefbf1d46    /* <+4308>:  dtstsfi cr7,63,f3          */
	.long  0xfc002546    /* <+4312>:  dtstsfiq cr0,0,f4          */
	.long  0xffbf2546    /* <+4316>:  dtstsfiq cr7,63,f4         */
	.long  0xf110956f    /* <+4320>:  xscvhpdp vs40,vs50         */
	.long  0xf1319d6f    /* <+4324>:  xscvdphp vs41,vs51         */
	.long  0xf158a76f    /* <+4328>:  xvcvhpsp vs42,vs52         */
	.long  0xf179af6f    /* <+4332>:  xvcvsphp vs43,vs53         */
	.long  0x4c600004    /* <+4336>:  addpcis r3,0               */
	.long  0x4c600004    /* <+4340>:  addpcis r3,0               */
	.long  0x4c800005    /* <+4344>:  addpcis r4,1               */
	.long  0x4c800005    /* <+4348>:  addpcis r4,1               */
	.long  0x4cbfffc4    /* <+4352>:  addpcis r5,-2              */
	.long  0x4cbfffc4    /* <+4356>:  addpcis r5,-2              */
	.long  0x4cdf7fc5    /* <+4360>:  addpcis r6,32767           */
	.long  0x4cdf7fc5    /* <+4364>:  addpcis r6,32767           */
	.long  0x4ce08004    /* <+4368>:  addpcis r7,-32768          */
	.long  0x4ce08004    /* <+4372>:  addpcis r7,-32768          */
	.long  0x7c0002a4    /* <+4376>:  slbsync                    */
	.long  0x7d405ba4    /* <+4380>:  slbieg  r10,r11            */
	.long  0x7c602726    /* <+4384>:  slbmfee r3,r4              */
	.long  0x7c602726    /* <+4388>:  slbmfee r3,r4              */
	.long  0x7c612726    /* <+4392>:  slbmfee r3,r4,1            */
	.long  0x7c802ea6    /* <+4396>:  slbmfev r4,r5              */
	.long  0x7c802ea6    /* <+4400>:  slbmfev r4,r5              */
	.long  0x7c812ea6    /* <+4404>:  slbmfev r4,r5,1            */
	.long  0x7c801a64    /* <+4408>:  tlbie   r3,r4              */
	.long  0x7c801a64    /* <+4412>:  tlbie   r3,r4              */
	.long  0x7c8f1a64    /* <+4416>:  tlbie   r3,r4,3,1,1        */
	.long  0x7c001a24    /* <+4420>:  tlbiel  r3                 */
	.long  0x7c001a24    /* <+4424>:  tlbiel  r3                 */
	.long  0x7c8f1a24    /* <+4428>:  tlbiel  r3,r4,3,1,1        */
	.long  0x7c2c6e0c    /* <+4432>:  copy    r12,r13            */
	.long  0x7c2a5f0d    /* <+4436>:  paste.  r10,r11            */
	.long  0x7c00068c    /* <+4440>:  cpabort                    */
	.long  0x7c0004ac    /* <+4444>:  hwsync                     */
	.long  0x7c0004ac    /* <+4448>:  hwsync                     */
	.long  0x7c0004ac    /* <+4452>:  hwsync                     */
	.long  0x7c2004ac    /* <+4456>:  lwsync                     */
	.long  0x7c2004ac    /* <+4460>:  lwsync                     */
	.long  0x7c4004ac    /* <+4464>:  ptesync                    */
	.long  0x7c4004ac    /* <+4468>:  ptesync                    */
	.long  0x7e8004cc    /* <+4472>:  ldat    r20,0,0            */
	.long  0x7e8ae4cc    /* <+4476>:  ldat    r20,r10,28         */
	.long  0x7ea0048c    /* <+4480>:  lwat    r21,0,0            */
	.long  0x7eabe48c    /* <+4484>:  lwat    r21,r11,28         */
	.long  0x7ec005cc    /* <+4488>:  stdat   r22,0,0            */
	.long  0x7ecce5cc    /* <+4492>:  stdat   r22,r12,28         */
	.long  0x7ee0058c    /* <+4496>:  stwat   r23,0,0            */
	.long  0x7eede58c    /* <+4500>:  stwat   r23,r13,28         */
	.long  0x4c000264    /* <+4504>:  urfid                      */
	.long  0x7c00f6e4    /* <+4508>:  rmieg   r30                */
	.long  0x7d407a6a    /* <+4512>:  ldmx    r10,0,r15          */
	.long  0x7d437a6a    /* <+4516>:  ldmx    r10,r3,r15         */
	.long  0x4c0002e4    /* <+4520>:  stop                       */
	.long  0x7c00003c    /* <+4524>:  wait                       */
	.long  0x7c00003c    /* <+4528>:  wait                       */
	.long  0x7c6005e6    /* <+4532>:  darn    r3,0               */
	.long  0x7c6105e6    /* <+4536>:  darn    r3,1               */
	.long  0x7c6205e6    /* <+4540>:  darn    r3,2               */
	.long  0x7c000480    /* <+4544>:  mcrxrx  cr0                */
	.long  0x7f800480    /* <+4548>:  mcrxrx  cr7                */
	.long  0x1295b744    /* <+4552>:  vslv    v20,v21,v22        */
	.long  0x12f8cf04    /* <+4556>:  vsrv    v23,v24,v25        */
	.long  0x7c0006ec    /* <+4560>:  msgsync                    */
	.long  0xf3c8901e    /* <+4564>:  xscmpeqdp vs30,vs40,vs50   */
	.long  0xf3e9985e    /* <+4568>:  xscmpgtdp vs31,vs41,vs51   */
	.long  0xf00aa09f    /* <+4572>:  xscmpgedp vs32,vs42,vs52   */
	.long  0xf04cb447    /* <+4576>:  xsmincdp vs34,vs44,vs54    */
	.long  0xf06dbc07    /* <+4580>:  xsmaxcdp vs35,vs45,vs55    */
	.long  0xf08ec4c7    /* <+4584>:  xsminjdp vs36,vs46,vs56    */
	.long  0xf0afcc87    /* <+4588>:  xsmaxjdp vs37,vs47,vs57    */
	.long  0x1295b5e3    /* <+4592>:  vmsumudm v20,v21,v22,v23   */
	.long  0x7d6c6954    /* <+4596>:  addex   r11,r12,r13,0      */
	.long  0x7d6c6b54    /* <+4600>:  addex   r11,r12,r13,1      */
	.long  0x7d6c6d54    /* <+4604>:  addex   r11,r12,r13,2      */
	.long  0xff20048e    /* <+4608>:  mffs    f25                */
	.long  0xff20048f    /* <+4612>:  mffs.   f25                */
	.long  0xff41048e    /* <+4616>:  mffsce  f26                */
	.long  0xff74a48e    /* <+4620>:  mffscdrn f27,f20           */
	.long  0xff95048e    /* <+4624>:  mffscdrni f28,0            */
	.long  0xff953c8e    /* <+4628>:  mffscdrni f28,7            */
	.long  0xffb6ac8e    /* <+4632>:  mffscrn f29,f21            */
	.long  0xffd7048e    /* <+4636>:  mffscrni f30,0             */
	.long  0xffd71c8e    /* <+4640>:  mffscrni f30,3             */
	.long  0xfff8048e    /* <+4644>:  mffsl   f31                */
	.long  0x7d4006a4    /* <+4648>:  slbiag  r10                */

## altivec3.d
	.long  0x117e0001    /* <+4652>:  vmul10cuq v11,v30          */
	.long  0x13c1b807    /* <+4656>:  vcmpneb v30,v1,v23         */
	.long  0x13d3f77b    /* <+4660>:  vpermr  v30,v19,v30,v29    */
	.long  0x12948841    /* <+4664>:  vmul10ecuq v20,v20,v17     */
	.long  0x1373f847    /* <+4668>:  vcmpneh v27,v19,v31        */
	.long  0x10c9b885    /* <+4672>:  vrlwmi  v6,v9,v23          */
	.long  0x12da0887    /* <+4676>:  vcmpnew v22,v26,v1         */
	.long  0x131ec8c5    /* <+4680>:  vrldmi  v24,v30,v25        */
	.long  0x127db107    /* <+4684>:  vcmpnezb v19,v29,v22       */
	.long  0x11179947    /* <+4688>:  vcmpnezh v8,v23,v19        */
	.long  0x13785985    /* <+4692>:  vrlwnm  v27,v24,v11        */
	.long  0x12ad5187    /* <+4696>:  vcmpnezw v21,v13,v10       */
	.long  0x10b4e9c5    /* <+4700>:  vrldnm  v5,v20,v29         */
	.long  0x13d30201    /* <+4704>:  vmul10uq v30,v19           */
	.long  0x130caa0d    /* <+4708>:  vextractub v24,v21,12      */
	.long  0x1013e241    /* <+4712>:  vmul10euq v0,v19,v28       */
	.long  0x114c1a4d    /* <+4716>:  vextractuh v10,v3,12       */
	.long  0x1387628d    /* <+4720>:  vextractuw v28,v12,7       */
	.long  0x13c1dacd    /* <+4724>:  vextractd v30,v27,1        */
	.long  0x1324fb0d    /* <+4728>:  vinsertb v25,v31,4         */
	.long  0x12aef341    /* <+4732>:  bcdcpsgn. v21,v14,v30      */
	.long  0x12c5934d    /* <+4736>:  vinserth v22,v18,5         */
	.long  0x13a1b38d    /* <+4740>:  vinsertw v29,v22,1         */
	.long  0x13a76bcd    /* <+4744>:  vinsertd v29,v13,7         */
	.long  0x12d94407    /* <+4748>:  vcmpneb. v22,v25,v8        */
	.long  0x120fac47    /* <+4752>:  vcmpneh. v16,v15,v21       */
	.long  0x12d5fc81    /* <+4756>:  bcdus.  v22,v21,v31        */
	.long  0x102c6487    /* <+4760>:  vcmpnew. v1,v12,v12        */
	.long  0x10a346c1    /* <+4764>:  bcds.   v5,v3,v8,1         */
	.long  0x13760d01    /* <+4768>:  bcdtrunc. v27,v22,v1,0     */
	.long  0x105a0507    /* <+4772>:  vcmpnezb. v2,v26,v0        */
	.long  0x134e3d41    /* <+4776>:  bcdutrunc. v26,v14,v7      */
	.long  0x12056547    /* <+4780>:  vcmpnezh. v16,v5,v12       */
	.long  0x13002d81    /* <+4784>:  bcdctsq. v24,v5            */
	.long  0x10e20581    /* <+4788>:  bcdcfsq. v7,v0,0           */
	.long  0x13c46781    /* <+4792>:  bcdctz. v30,v12,1          */
	.long  0x1225bd81    /* <+4796>:  bcdctn. v17,v23            */
	.long  0x10867f81    /* <+4800>:  bcdcfz. v4,v15,1           */
	.long  0x13a72f81    /* <+4804>:  bcdcfn. v29,v5,1           */
	.long  0x137f6581    /* <+4808>:  bcdsetsgn. v27,v12,0       */
	.long  0x11dccd87    /* <+4812>:  vcmpnezw. v14,v28,v25      */
	.long  0x104237c1    /* <+4816>:  bcdsr.  v2,v2,v6,1         */
	.long  0x13202dcc    /* <+4820>:  vbpermd v25,v0,v5          */
	.long  0x1380ce02    /* <+4824>:  vclzlsbb r28,v25           */
	.long  0x1041c602    /* <+4828>:  vctzlsbb r2,v24            */
	.long  0x12a65e02    /* <+4832>:  vnegw   v21,v11            */
	.long  0x1227de02    /* <+4836>:  vnegd   v17,v27            */
	.long  0x13e8be02    /* <+4840>:  vprtybw v31,v23            */
	.long  0x12a9be02    /* <+4844>:  vprtybd v21,v23            */
	.long  0x12aa9602    /* <+4848>:  vprtybq v21,v18            */
	.long  0x13d02602    /* <+4852>:  vextsb2w v30,v4            */
	.long  0x1071d602    /* <+4856>:  vextsh2w v3,v26            */
	.long  0x11788e02    /* <+4860>:  vextsb2d v11,v17           */
	.long  0x10b95602    /* <+4864>:  vextsh2d v5,v10            */
	.long  0x11bace02    /* <+4868>:  vextsw2d v13,v25           */
	.long  0x133c1602    /* <+4872>:  vctzb   v25,v2             */
	.long  0x101d1e02    /* <+4876>:  vctzh   v0,v3              */
	.long  0x12de3602    /* <+4880>:  vctzw   v22,v6             */
	.long  0x135fc602    /* <+4884>:  vctzd   v26,v24            */
	.long  0x10df160d    /* <+4888>:  vextublx r6,r31,v2         */
	.long  0x11a0964d    /* <+4892>:  vextuhlx r13,r0,v18        */
	.long  0x11defe8d    /* <+4896>:  vextuwlx r14,r30,v31       */
	.long  0x11ec7704    /* <+4900>:  vsrv    v15,v12,v14        */
	.long  0x128af70d    /* <+4904>:  vextubrx r20,r10,v30       */
	.long  0x12b51744    /* <+4908>:  vslv    v21,v21,v2         */
	.long  0x11e90f4d    /* <+4912>:  vextuhrx r15,r9,v1         */
	.long  0x12b1878d    /* <+4916>:  vextuwrx r21,r17,v16       */
	.long  0x1295b5e3    /* <+4920>:  vmsumudm v20,v21,v22,v23   */
## vsx3.d
	.long  0x7c46ca19    /* <+4924>:  lxvx    vs34,r6,r25        */
	.long  0x7e805218    /* <+4928>:  lxvx    vs20,0,r10         */
	.long  0x7e98521a    /* <+4932>:  lxvl    vs20,r24,r10       */
	.long  0x7ec0ea1b    /* <+4936>:  lxvl    vs54,0,r29         */
	.long  0x7f149a5a    /* <+4940>:  lxvll   vs24,r20,r19       */
	.long  0x7c40725b    /* <+4944>:  lxvll   vs34,0,r14         */
	.long  0x7ec20266    /* <+4948>:  mfvsrld r2,vs22            */
	.long  0x7f5acad9    /* <+4952>:  lxvwsx  vs58,r26,r25       */
	.long  0x7ee0ead9    /* <+4956>:  lxvwsx  vs55,0,r29         */
	.long  0x7dd52318    /* <+4960>:  stxvx   vs14,r21,r4        */
	.long  0x7fc0b318    /* <+4964>:  stxvx   vs30,0,r22         */
	.long  0x7c1a231a    /* <+4968>:  stxvl   vs0,r26,r4         */
	.long  0x7ca0b31b    /* <+4972>:  stxvl   vs37,0,r22         */
	.long  0x7f0a0326    /* <+4976>:  mtvsrws vs24,r10           */
	.long  0x7fd57b5a    /* <+4980>:  stxvll  vs30,r21,r15       */
	.long  0x7ce0735b    /* <+4984>:  stxvll  vs39,0,r14         */
	.long  0x7d862b66    /* <+4988>:  mtvsrdd vs12,r6,r5         */
	.long  0x7cc0ab67    /* <+4992>:  mtvsrdd vs38,0,r21         */
	.long  0x7f7c361b    /* <+4996>:  lxsibzx vs59,r28,r6        */
	.long  0x7fc0461a    /* <+5000>:  lxsibzx vs30,0,r8          */
	.long  0x7d578e59    /* <+5004>:  lxvh8x  vs42,r23,r17       */
	.long  0x7c802e59    /* <+5008>:  lxvh8x  vs36,0,r5          */
	.long  0x7d895e5a    /* <+5012>:  lxsihzx vs12,r9,r11        */
	.long  0x7e206e5b    /* <+5016>:  lxsihzx vs49,0,r13         */
	.long  0x7ca39ed9    /* <+5020>:  lxvb16x vs37,r3,r19        */
	.long  0x7c00f6d8    /* <+5024>:  lxvb16x vs0,0,r30          */
	.long  0x7c5e371a    /* <+5028>:  stxsibx vs2,r30,r6         */
	.long  0x7d806f1a    /* <+5032>:  stxsibx vs12,0,r13         */
	.long  0x7e1d4758    /* <+5036>:  stxvh8x vs16,r29,r8        */
	.long  0x7ee05759    /* <+5040>:  stxvh8x vs55,0,r10         */
	.long  0x7c42bf5b    /* <+5044>:  stxsihx vs34,r2,r23        */
	.long  0x7f80bf5b    /* <+5048>:  stxsihx vs60,0,r23         */
	.long  0x7eee67d8    /* <+5052>:  stxvb16x vs23,r14,r12      */
	.long  0x7e602fd8    /* <+5056>:  stxvb16x vs19,0,r5         */
	.long  0xe7000002    /* <+5060>:  lxsd    v24,0(0)           */
	.long  0xe5f50012    /* <+5064>:  lxsd    v15,16(r21)        */
	.long  0xe4c00003    /* <+5068>:  lxssp   v6,0(0)            */
	.long  0xe6e90013    /* <+5072>:  lxssp   v23,16(r9)         */
	.long  0xf253081e    /* <+5076>:  xscmpeqdp vs18,vs51,vs33   */
	.long  0xf05a105a    /* <+5080>:  xscmpgtdp vs2,vs26,vs34    */
	.long  0xf0baa098    /* <+5084>:  xscmpgedp vs5,vs26,vs20    */
	.long  0xf18a58d3    /* <+5088>:  xxperm  vs44,vs10,vs43     */
	.long  0xf13429d1    /* <+5092>:  xxpermr vs41,vs20,vs5      */
	.long  0xf212b9da    /* <+5096>:  xscmpexpdp cr4,vs18,vs55   */
	.long  0xf2e32a96    /* <+5100>:  xxextractuw vs23,vs37,3    */
	.long  0xf2c75ad1    /* <+5104>:  xxspltib vs54,235          */
	.long  0xf1e4f2d4    /* <+5108>:  xxinsertw vs15,vs30,4      */
	.long  0xf18b3c00    /* <+5112>:  xsmaxcdp vs12,vs11,vs7     */
	.long  0xf019c441    /* <+5116>:  xsmincdp vs32,vs25,vs24    */
	.long  0xf3356484    /* <+5120>:  xsmaxjdp vs25,vs53,vs12    */
	.long  0xf17f24aa    /* <+5124>:  xststdcsp cr2,vs36,127     */
	.long  0xf0156cc3    /* <+5128>:  xsminjdp vs32,vs21,vs45    */
	.long  0xf220956e    /* <+5132>:  xsxexpdp r17,vs50          */
	.long  0xf0e1456e    /* <+5136>:  xsxsigdp r7,vs40           */
	.long  0xf2d0156f    /* <+5140>:  xscvhpdp vs54,vs34         */
	.long  0xf351b56f    /* <+5144>:  xscvdphp vs58,vs54         */
	.long  0xf07f35aa    /* <+5148>:  xststdcdp cr0,vs38,127     */
	.long  0xf31faeef    /* <+5152>:  xvtstdcsp vs56,vs53,127    */
	.long  0xf2d4a6c3    /* <+5156>:  xviexpsp vs54,vs20,vs52    */
	.long  0xf33cef2d    /* <+5160>:  xsiexpdp vs57,r28,r29      */
	.long  0xf020a76c    /* <+5164>:  xvxexpdp vs1,vs20          */
	.long  0xf2c1df6f    /* <+5168>:  xvxsigdp vs54,vs59         */
	.long  0xf2472f6e    /* <+5172>:  xxbrh   vs18,vs37          */
	.long  0xf1c80f6c    /* <+5176>:  xvxexpsp vs14,vs1          */
	.long  0xf2896f6d    /* <+5180>:  xvxsigsp vs52,vs13         */
	.long  0xf26f2f6c    /* <+5184>:  xxbrw   vs19,vs5           */
	.long  0xf277bf6f    /* <+5188>:  xxbrd   vs51,vs55          */
	.long  0xf0788f6d    /* <+5192>:  xvcvhpsp vs35,vs17         */
	.long  0xf1f96f6e    /* <+5196>:  xvcvsphp vs15,vs45         */
	.long  0xf23fff6c    /* <+5200>:  xxbrq   vs17,vs31          */
	.long  0xf21f67ec    /* <+5204>:  xvtstdcdp vs16,vs12,127    */
	.long  0xf36947c0    /* <+5208>:  xviexpdp vs27,vs9,vs8      */
	.long  0xf4800001    /* <+5212>:  lxv     vs4,0(0)           */
	.long  0xf5140019    /* <+5216>:  lxv     vs40,16(r20)       */
	.long  0xf640000d    /* <+5220>:  stxv    vs50,0(0)          */
	.long  0xf5100015    /* <+5224>:  stxv    vs8,16(r16)        */
	.long  0xf4600002    /* <+5228>:  stxsd   v3,0(0)            */
	.long  0xf6220012    /* <+5232>:  stxsd   v17,16(r2)         */
	.long  0xf5a00003    /* <+5236>:  stxssp  v13,0(0)           */
	.long  0xf62d0013    /* <+5240>:  stxssp  v17,16(r13)        */
	.long  0xfd0a9008    /* <+5244>:  xsaddqp v8,v10,v18         */
	.long  0xfca1e809    /* <+5248>:  xsaddqpo v5,v1,v29         */
	.long  0xfd80960a    /* <+5252>:  xsrqpi  0,v12,v18,3        */
	.long  0xffe1980b    /* <+5256>:  xsrqpix 1,v31,v19,0        */
	.long  0xfdc13048    /* <+5260>:  xsmulqp v14,v1,v6          */
	.long  0xfe27d849    /* <+5264>:  xsmulqpo v17,v7,v27        */
	.long  0xfc80584a    /* <+5268>:  xsrqpxp 0,v4,v11,0         */
	.long  0xffb7e0c8    /* <+5272>:  xscpsgnqp v29,v23,v28      */
	.long  0xff8dd908    /* <+5276>:  xscmpoqp cr7,v13,v27       */
	.long  0xfe953148    /* <+5280>:  xscmpexpqp cr5,v21,v6      */
	.long  0xfc532308    /* <+5284>:  xsmaddqp v2,v19,v4         */
	.long  0xffc78309    /* <+5288>:  xsmaddqpo v30,v7,v16       */
	.long  0xfebe7b48    /* <+5292>:  xsmsubqp v21,v30,v15       */
	.long  0xfd91f349    /* <+5296>:  xsmsubqpo v12,v17,v30      */
	.long  0xfcde6388    /* <+5300>:  xsnmaddqp v6,v30,v12       */
	.long  0xfd966389    /* <+5304>:  xsnmaddqpo v12,v22,v12     */
	.long  0xfd5ddbc8    /* <+5308>:  xsnmsubqp v10,v29,v27      */
	.long  0xffbd6bc9    /* <+5312>:  xsnmsubqpo v29,v29,v13     */
	.long  0xfe7b2408    /* <+5316>:  xssubqp v19,v27,v4         */
	.long  0xfda80c09    /* <+5320>:  xssubqpo v13,v8,v1         */
	.long  0xfd03dc48    /* <+5324>:  xsdivqp v8,v3,v27          */
	.long  0xff14dc49    /* <+5328>:  xsdivqpo v24,v20,v27       */
	.long  0xff8e2508    /* <+5332>:  xscmpuqp cr7,v14,v4        */
	.long  0xfe7f1588    /* <+5336>:  xststdcqp cr4,v2,127       */
	.long  0xffe0b648    /* <+5340>:  xsabsqp v31,v22            */
	.long  0xff221e48    /* <+5344>:  xsxexpqp v25,v3            */
	.long  0xfd48e648    /* <+5348>:  xsnabsqp v10,v28           */
	.long  0xfe70fe48    /* <+5352>:  xsnegqp v19,v31            */
	.long  0xfd726e48    /* <+5356>:  xsxsigqp v11,v13           */
	.long  0xfdbb7648    /* <+5360>:  xssqrtqp v13,v14           */
	.long  0xfc3bde49    /* <+5364>:  xssqrtqpo v1,v27           */
	.long  0xfc613e88    /* <+5368>:  xscvqpuwz v3,v7            */
	.long  0xfe829688    /* <+5372>:  xscvudqp v20,v18           */
	.long  0xffa9ee88    /* <+5376>:  xscvqpswz v29,v29          */
	.long  0xfc4ae688    /* <+5380>:  xscvsdqp v2,v28            */
	.long  0xfef12688    /* <+5384>:  xscvqpudz v23,v4           */
	.long  0xfc74a688    /* <+5388>:  xscvqpdp v3,v20            */
	.long  0xfc341e89    /* <+5392>:  xscvqpdpo v1,v3            */
	.long  0xfe766688    /* <+5396>:  xscvdpqp v19,v12           */
	.long  0xfdb92688    /* <+5400>:  xscvqpsdz v13,v4           */
	.long  0xfcf83ec8    /* <+5404>:  xsiexpqp v7,v24,v7         */
