/*
 * Copyright (C) 2015 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier:     GPL-2.0+
 */

#ifndef __ASM_ARCH_IMX6UL_PINS_H__
#define __ASM_ARCH_IMX6UL_PINS_H__

#include <asm/mach-imx/iomux-v3.h>

enum {

	MX6_PAD_BOOT_MODE0__GPIO5_IO10	                        = IOMUX_PAD(0x02A0, 0x0014, 5, 0x0000, 0, 0),
	MX6_PAD_BOOT_MODE1__GPIO5_IO11	                        = IOMUX_PAD(0x02A4, 0x0018, 5, 0x0000, 0, 0),
	/*
	 * The TAMPER Pin can be used for GPIO, which depends on
	 * fusemap TAMPER_PIN_DISABLE[1:0] settings.
	 */
	MX6_PAD_SNVS_TAMPER0__GPIO5_IO00                       = IOMUX_PAD(0x02A8, 0x001C, 5, 0x0000, 0, 0),
	MX6_PAD_SNVS_TAMPER1__GPIO5_IO01                       = IOMUX_PAD(0x02AC, 0x0020, 5, 0x0000, 0, 0),
	MX6_PAD_SNVS_TAMPER2__GPIO5_IO02                       = IOMUX_PAD(0x02B0, 0x0024, 5, 0x0000, 0, 0),
	MX6_PAD_SNVS_TAMPER3__GPIO5_IO03                       = IOMUX_PAD(0x02B4, 0x0028, 5, 0x0000, 0, 0),
	MX6_PAD_SNVS_TAMPER4__GPIO5_IO04                       = IOMUX_PAD(0x02B8, 0x002C, 5, 0x0000, 0, 0),
	MX6_PAD_SNVS_TAMPER5__GPIO5_IO05                       = IOMUX_PAD(0x02BC, 0x0030, 5, 0x0000, 0, 0),
	MX6_PAD_SNVS_TAMPER6__GPIO5_IO06                       = IOMUX_PAD(0x02C0, 0x0034, 5, 0x0000, 0, 0),
	MX6_PAD_SNVS_TAMPER7__GPIO5_IO07                       = IOMUX_PAD(0x02C4, 0x0038, 5, 0x0000, 0, 0),
	MX6_PAD_SNVS_TAMPER8__GPIO5_IO08                       = IOMUX_PAD(0x02C8, 0x003C, 5, 0x0000, 0, 0),
	MX6_PAD_SNVS_TAMPER9__GPIO5_IO09                       = IOMUX_PAD(0x02CC, 0x0040, 5, 0x0000, 0, 0),

	MX6_PAD_JTAG_MOD__SJC_MOD                              = IOMUX_PAD(0x02D0, 0x0044, 0, 0x0000, 0, 0),
	MX6_PAD_JTAG_MOD__GPT2_CLK                             = IOMUX_PAD(0x02D0, 0x0044, 1, 0x05A0, 0, 0),
	MX6_PAD_JTAG_MOD__SPDIF_OUT                            = IOMUX_PAD(0x02D0, 0x0044, 2, 0x0000, 0, 0),
	MX6_PAD_JTAG_MOD__ENET1_REF_CLK_25M                    = IOMUX_PAD(0x02D0, 0x0044, 3, 0x0000, 0, 0),
	MX6_PAD_JTAG_MOD__CCM_PMIC_RDY                         = IOMUX_PAD(0x02D0, 0x0044, 4, 0x04C0, 0, 0),
	MX6_PAD_JTAG_MOD__GPIO1_IO10                           = IOMUX_PAD(0x02D0, 0x0044, 5, 0x0000, 0, 0),
	MX6_PAD_JTAG_MOD__SDMA_EXT_EVENT00                     = IOMUX_PAD(0x02D0, 0x0044, 6, 0x0610, 0, 0),

	MX6_PAD_JTAG_TMS__SJC_TMS                              = IOMUX_PAD(0x02D4, 0x0048, 0, 0x0000, 0, 0),
	MX6_PAD_JTAG_TMS__GPT2_CAPTURE1                        = IOMUX_PAD(0x02D4, 0x0048, 1, 0x0598, 0, 0),
	MX6_PAD_JTAG_TMS__SAI2_MCLK                            = IOMUX_PAD(0x02D4, 0x0048, 2, 0x05F0, 0, 0),
	MX6_PAD_JTAG_TMS__CCM_CLKO1                            = IOMUX_PAD(0x02D4, 0x0048, 3, 0x0000, 0, 0),
	MX6_PAD_JTAG_TMS__CCM_WAIT                             = IOMUX_PAD(0x02D4, 0x0048, 4, 0x0000, 0, 0),
	MX6_PAD_JTAG_TMS__GPIO1_IO11                           = IOMUX_PAD(0x02D4, 0x0048, 5, 0x0000, 0, 0),
	MX6_PAD_JTAG_TMS__SDMA_EXT_EVENT01                     = IOMUX_PAD(0x02D4, 0x0048, 6, 0x0614, 0, 0),
	MX6_PAD_JTAG_TMS__EPIT1_OUT                            = IOMUX_PAD(0x02D4, 0x0048, 8, 0x0000, 0, 0),

	MX6_PAD_JTAG_TDO__SJC_TDO                              = IOMUX_PAD(0x02D8, 0x004C, 0, 0x0000, 0, 0),
	MX6_PAD_JTAG_TDO__GPT2_CAPTURE2                        = IOMUX_PAD(0x02D8, 0x004C, 1, 0x059C, 0, 0),
	MX6_PAD_JTAG_TDO__SAI2_TX_SYNC                         = IOMUX_PAD(0x02D8, 0x004C, 2, 0x05FC, 0, 0),
	MX6_PAD_JTAG_TDO__CCM_CLKO2                            = IOMUX_PAD(0x02D8, 0x004C, 3, 0x0000, 0, 0),
	MX6_PAD_JTAG_TDO__CCM_STOP                             = IOMUX_PAD(0x02D8, 0x004C, 4, 0x0000, 0, 0),
	MX6_PAD_JTAG_TDO__GPIO1_IO12                           = IOMUX_PAD(0x02D8, 0x004C, 5, 0x0000, 0, 0),
	MX6_PAD_JTAG_TDO__MQS_RIGHT                            = IOMUX_PAD(0x02D8, 0x004C, 6, 0x0000, 0, 0),
	MX6_PAD_JTAG_TDO__EPIT2_OUT                            = IOMUX_PAD(0x02D8, 0x004C, 8, 0x0000, 0, 0),

	MX6_PAD_JTAG_TDI__SJC_TDI                              = IOMUX_PAD(0x02DC, 0x0050, 0, 0x0000, 0, 0),
	MX6_PAD_JTAG_TDI__GPT2_COMPARE1                        = IOMUX_PAD(0x02DC, 0x0050, 1, 0x0000, 0, 0),
	MX6_PAD_JTAG_TDI__SAI2_TX_BCLK                         = IOMUX_PAD(0x02DC, 0x0050, 2, 0x05F8, 0, 0),
	MX6_PAD_JTAG_TDI__PWM6_OUT                             = IOMUX_PAD(0x02DC, 0x0050, 4, 0x0000, 0, 0),
	MX6_PAD_JTAG_TDI__GPIO1_IO13                           = IOMUX_PAD(0x02DC, 0x0050, 5, 0x0000, 0, 0),
	MX6_PAD_JTAG_TDI__MQS_LEFT                             = IOMUX_PAD(0x02DC, 0x0050, 6, 0x0000, 0, 0),
	MX6_PAD_JTAG_TDI__SIM1_POWER_FAIL                      = IOMUX_PAD(0x02DC, 0x0050, 8, 0x0000, 0, 0),

	MX6_PAD_JTAG_TCK__SJC_TCK                              = IOMUX_PAD(0x02E0, 0x0054, 0, 0x0000, 0, 0),
	MX6_PAD_JTAG_TCK__GPT2_COMPARE2                        = IOMUX_PAD(0x02E0, 0x0054, 1, 0x0000, 0, 0),
	MX6_PAD_JTAG_TCK__SAI2_RX_DATA                         = IOMUX_PAD(0x02E0, 0x0054, 2, 0x05F4, 0, 0),
	MX6_PAD_JTAG_TCK__PWM7_OUT                             = IOMUX_PAD(0x02E0, 0x0054, 4, 0x0000, 0, 0),
	MX6_PAD_JTAG_TCK__GPIO1_IO14                           = IOMUX_PAD(0x02E0, 0x0054, 5, 0x0000, 0, 0),
	MX6_PAD_JTAG_TCK__SIM2_POWER_FAIL                      = IOMUX_PAD(0x02E0, 0x0054, 8, 0x0000, 0, 0),

	MX6_PAD_JTAG_TRST_B__SJC_TRSTB                         = IOMUX_PAD(0x02E4, 0x0058, 0, 0x0000, 0, 0),
	MX6_PAD_JTAG_TRST_B__GPT2_COMPARE3                     = IOMUX_PAD(0x02E4, 0x0058, 1, 0x0000, 0, 0),
	MX6_PAD_JTAG_TRST_B__SAI2_TX_DATA                      = IOMUX_PAD(0x02E4, 0x0058, 2, 0x0000, 0, 0),
	MX6_PAD_JTAG_TRST_B__PWM8_OUT                          = IOMUX_PAD(0x02E4, 0x0058, 4, 0x0000, 0, 0),
	MX6_PAD_JTAG_TRST_B__GPIO1_IO15                        = IOMUX_PAD(0x02E4, 0x0058, 5, 0x0000, 0, 0),
	MX6_PAD_JTAG_TRST_B__CAAM_RNG_OSC_OBS                  = IOMUX_PAD(0x02E4, 0x0058, 8, 0x0000, 0, 0),

	MX6_PAD_GPIO1_IO00__I2C2_SCL                           = IOMUX_PAD(0x02E8, 0x005C, IOMUX_CONFIG_SION | 0, 0x05AC, 1, 0),
	MX6_PAD_GPIO1_IO00__GPT1_CAPTURE1                      = IOMUX_PAD(0x02E8, 0x005C, 1, 0x058C, 0, 0),
	MX6_PAD_GPIO1_IO00__ANATOP_OTG1_ID                     = IOMUX_PAD(0x02E8, 0x005C, 2, 0x04B8, 0, 0),
	MX6_PAD_GPIO1_IO00__ENET1_REF_CLK1                     = IOMUX_PAD(0x02E8, 0x005C, 3, 0x0574, 0, 0),
	MX6_PAD_GPIO1_IO00__MQS_RIGHT                          = IOMUX_PAD(0x02E8, 0x005C, 4, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO00__GPIO1_IO00                         = IOMUX_PAD(0x02E8, 0x005C, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO00__ENET1_1588_EVENT0_IN               = IOMUX_PAD(0x02E8, 0x005C, 6, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO00__SRC_SYSTEM_RESET                   = IOMUX_PAD(0x02E8, 0x005C, 7, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO00__WDOG3_WDOG_B                       = IOMUX_PAD(0x02E8, 0x005C, 8, 0x0000, 0, 0),

	MX6_PAD_GPIO1_IO01__I2C2_SDA                           = IOMUX_PAD(0x02EC, 0x0060, IOMUX_CONFIG_SION | 0, 0x05B0, 1, 0),
	MX6_PAD_GPIO1_IO01__GPT1_COMPARE1                      = IOMUX_PAD(0x02EC, 0x0060, 1, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO01__USB_OTG1_OC                        = IOMUX_PAD(0x02EC, 0x0060, 2, 0x0664, 0, 0),
	MX6_PAD_GPIO1_IO01__ENET2_REF_CLK2                     = IOMUX_PAD(0x02EC, 0x0060, 3, 0x057C, 0, 0),
	MX6_PAD_GPIO1_IO01__MQS_LEFT                           = IOMUX_PAD(0x02EC, 0x0060, 4, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO01__GPIO1_IO01                         = IOMUX_PAD(0x02EC, 0x0060, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO01__ENET1_1588_EVENT0_OUT              = IOMUX_PAD(0x02EC, 0x0060, 6, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO01__SRC_EARLY_RESET                    = IOMUX_PAD(0x02EC, 0x0060, 7, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO01__WDOG1_WDOG_B                       = IOMUX_PAD(0x02EC, 0x0060, 8, 0x0000, 0, 0),

	MX6_PAD_GPIO1_IO02__I2C1_SCL                           = IOMUX_PAD(0x02F0, 0x0064, IOMUX_CONFIG_SION | 0, 0x05A4, 0, 0),
	MX6_PAD_GPIO1_IO02__GPT1_COMPARE2                      = IOMUX_PAD(0x02F0, 0x0064, 1, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO02__USB_OTG2_PWR                       = IOMUX_PAD(0x02F0, 0x0064, 2, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO02__ENET1_REF_CLK_25M                  = IOMUX_PAD(0x02F0, 0x0064, 3, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO02__USDHC1_WP                          = IOMUX_PAD(0x02F0, 0x0064, 4, 0x066C, 0, 0),
	MX6_PAD_GPIO1_IO02__GPIO1_IO02                         = IOMUX_PAD(0x02F0, 0x0064, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO02__SDMA_EXT_EVENT00                   = IOMUX_PAD(0x02F0, 0x0064, 6, 0x0610, 1, 0),
	MX6_PAD_GPIO1_IO02__SRC_ANY_PU_RESET                   = IOMUX_PAD(0x02F0, 0x0064, 7, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO02__UART1_DCE_TX                       = IOMUX_PAD(0x02F0, 0x0064, 8, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO02__UART1_DTE_RX                       = IOMUX_PAD(0x02F0, 0x0064, 8, 0x0624, 0, 0),

	MX6_PAD_GPIO1_IO03__I2C1_SDA                           = IOMUX_PAD(0x02F4, 0x0068, IOMUX_CONFIG_SION | 0, 0x05A8, 1, 0),
	MX6_PAD_GPIO1_IO03__GPT1_COMPARE3                      = IOMUX_PAD(0x02F4, 0x0068, 1, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO03__USB_OTG2_OC                        = IOMUX_PAD(0x02F4, 0x0068, 2, 0x0660, 0, 0),
	MX6_PAD_GPIO1_IO03__USDHC1_CD_B                        = IOMUX_PAD(0x02F4, 0x0068, 4, 0x0668, 0, 0),
	MX6_PAD_GPIO1_IO03__GPIO1_IO03                         = IOMUX_PAD(0x02F4, 0x0068, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO03__CCM_DI0_EXT_CLK                    = IOMUX_PAD(0x02F4, 0x0068, 6, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO03__SRC_TESTER_ACK                     = IOMUX_PAD(0x02F4, 0x0068, 7, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO03__UART1_DCE_RX                       = IOMUX_PAD(0x02F4, 0x0068, 8, 0x0624, 1, 0),
	MX6_PAD_GPIO1_IO03__UART1_DTE_TX                       = IOMUX_PAD(0x02F4, 0x0068, 8, 0x0000, 0, 0),

	MX6_PAD_GPIO1_IO04__ENET1_REF_CLK1                     = IOMUX_PAD(0x02F8, 0x006C, 0, 0x0574, 1, 0),
	MX6_PAD_GPIO1_IO04__PWM3_OUT                           = IOMUX_PAD(0x02F8, 0x006C, 1, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO04__USB_OTG1_PWR                       = IOMUX_PAD(0x02F8, 0x006C, 2, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO04__USDHC1_RESET_B                     = IOMUX_PAD(0x02F8, 0x006C, 4, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO04__GPIO1_IO04                         = IOMUX_PAD(0x02F8, 0x006C, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO04__ENET2_1588_EVENT0_IN               = IOMUX_PAD(0x02F8, 0x006C, 6, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO04__UART5_DCE_TX                       = IOMUX_PAD(0x02F8, 0x006C, 8, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO04__UART5_DTE_RX                       = IOMUX_PAD(0x02F8, 0x006C, 8, 0x0644, 2, 0),

	MX6_PAD_GPIO1_IO05__ENET2_REF_CLK2                     = IOMUX_PAD(0x02FC, 0x0070, 0, 0x057C, 1, 0),
	MX6_PAD_GPIO1_IO05__PWM4_OUT                           = IOMUX_PAD(0x02FC, 0x0070, 1, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO05__ANATOP_OTG2_ID                     = IOMUX_PAD(0x02FC, 0x0070, 2, 0x04BC, 0, 0),
	MX6_PAD_GPIO1_IO05__CSI_FIELD                          = IOMUX_PAD(0x02FC, 0x0070, 3, 0x0530, 0, 0),
	MX6_PAD_GPIO1_IO05__USDHC1_VSELECT                     = IOMUX_PAD(0x02FC, 0x0070, 4, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO05__GPIO1_IO05                         = IOMUX_PAD(0x02FC, 0x0070, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO05__ENET2_1588_EVENT0_OUT              = IOMUX_PAD(0x02FC, 0x0070, 6, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO05__UART5_DCE_RX                       = IOMUX_PAD(0x02FC, 0x0070, 8, 0x0644, 3, 0),
	MX6_PAD_GPIO1_IO05__UART5_DTE_TX                       = IOMUX_PAD(0x02FC, 0x0070, 8, 0x0000, 0, 0),

	MX6_PAD_GPIO1_IO06__ENET1_MDIO                         = IOMUX_PAD(0x0300, 0x0074, 0, 0x0578, 0, 0),
	MX6_PAD_GPIO1_IO06__ENET2_MDIO                         = IOMUX_PAD(0x0300, 0x0074, 1, 0x0580, 0, 0),
	MX6_PAD_GPIO1_IO06__USB_OTG_PWR_WAKE                   = IOMUX_PAD(0x0300, 0x0074, 2, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO06__CSI_MCLK                           = IOMUX_PAD(0x0300, 0x0074, 3, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO06__USDHC2_WP                          = IOMUX_PAD(0x0300, 0x0074, 4, 0x069C, 0, 0),
	MX6_PAD_GPIO1_IO06__GPIO1_IO06                         = IOMUX_PAD(0x0300, 0x0074, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO06__CCM_WAIT                           = IOMUX_PAD(0x0300, 0x0074, 6, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO06__CCM_REF_EN_B                       = IOMUX_PAD(0x0300, 0x0074, 7, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO06__UART1_DCE_CTS                      = IOMUX_PAD(0x0300, 0x0074, 8, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO06__UART1_DTE_RTS                      = IOMUX_PAD(0x0300, 0x0074, 8, 0x0620, 0, 0),

	MX6_PAD_GPIO1_IO07__ENET1_MDC                          = IOMUX_PAD(0x0304, 0x0078, 0, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO07__ENET2_MDC                          = IOMUX_PAD(0x0304, 0x0078, 1, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO07__USB_OTG_HOST_MODE                  = IOMUX_PAD(0x0304, 0x0078, 2, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO07__CSI_PIXCLK                         = IOMUX_PAD(0x0304, 0x0078, 3, 0x0528, 0, 0),
	MX6_PAD_GPIO1_IO07__USDHC2_CD_B                        = IOMUX_PAD(0x0304, 0x0078, 4, 0x0674, 1, 0),
	MX6_PAD_GPIO1_IO07__GPIO1_IO07                         = IOMUX_PAD(0x0304, 0x0078, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO07__CCM_STOP                           = IOMUX_PAD(0x0304, 0x0078, 6, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO07__UART1_DCE_RTS                      = IOMUX_PAD(0x0304, 0x0078, 8, 0x0620, 1, 0),
	MX6_PAD_GPIO1_IO07__UART1_DTE_CTS                      = IOMUX_PAD(0x0304, 0x0078, 8, 0x0000, 0, 0),

	MX6_PAD_GPIO1_IO08__PWM1_OUT                           = IOMUX_PAD(0x0308, 0x007C, 0, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO08__WDOG1_WDOG_B                       = IOMUX_PAD(0x0308, 0x007C, 1, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO08__SPDIF_OUT                          = IOMUX_PAD(0x0308, 0x007C, 2, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO08__CSI_VSYNC                          = IOMUX_PAD(0x0308, 0x007C, 3, 0x052C, 1, 0),
	MX6_PAD_GPIO1_IO08__USDHC2_VSELECT                     = IOMUX_PAD(0x0308, 0x007C, 4, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO08__GPIO1_IO08                         = IOMUX_PAD(0x0308, 0x007C, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO08__CCM_PMIC_RDY                       = IOMUX_PAD(0x0308, 0x007C, 6, 0x04C0, 1, 0),
	MX6_PAD_GPIO1_IO08__UART5_DCE_RTS                      = IOMUX_PAD(0x0308, 0x007C, 8, 0x0640, 1, 0),
	MX6_PAD_GPIO1_IO08__UART5_DTE_CTS                      = IOMUX_PAD(0x0308, 0x007C, 8, 0x0000, 0, 0),

	MX6_PAD_GPIO1_IO09__PWM2_OUT                           = IOMUX_PAD(0x030C, 0x0080, 0, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO09__WDOG1_WDOG_ANY                     = IOMUX_PAD(0x030C, 0x0080, 1, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO09__SPDIF_IN                           = IOMUX_PAD(0x030C, 0x0080, 2, 0x0618, 0, 0),
	MX6_PAD_GPIO1_IO09__CSI_HSYNC                          = IOMUX_PAD(0x030C, 0x0080, 3, 0x0524, 1, 0),
	MX6_PAD_GPIO1_IO09__USDHC2_RESET_B                     = IOMUX_PAD(0x030C, 0x0080, 4, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO09__GPIO1_IO09                         = IOMUX_PAD(0x030C, 0x0080, 5, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO09__USDHC1_RESET_B                     = IOMUX_PAD(0x030C, 0x0080, 6, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO09__UART5_DCE_CTS                      = IOMUX_PAD(0x030C, 0x0080, 8, 0x0000, 0, 0),
	MX6_PAD_GPIO1_IO09__UART5_DTE_RTS                      = IOMUX_PAD(0x030C, 0x0080, 8, 0x0640, 2, 0),

	MX6_PAD_UART1_TX_DATA__UART1_DCE_TX                    = IOMUX_PAD(0x0310, 0x0084, 0, 0x0000, 0, 0),

	MX6_PAD_UART1_TX_DATA__UART1_DTE_RX                    = IOMUX_PAD(0x0310, 0x0084, 0, 0x0624, 2, 0),
	MX6_PAD_UART1_TX_DATA__ENET1_RDATA02                   = IOMUX_PAD(0x0310, 0x0084, 1, 0x0000, 0, 0),
	MX6_PAD_UART1_TX_DATA__I2C3_SCL                        = IOMUX_PAD(0x0310, 0x0084, IOMUX_CONFIG_SION | 2, 0x05B4, 0, 0),
	MX6_PAD_UART1_TX_DATA__CSI_DATA02                      = IOMUX_PAD(0x0310, 0x0084, 3, 0x04C4, 1, 0),
	MX6_PAD_UART1_TX_DATA__GPT1_COMPARE1                   = IOMUX_PAD(0x0310, 0x0084, 4, 0x0000, 0, 0),
	MX6_PAD_UART1_TX_DATA__GPIO1_IO16                      = IOMUX_PAD(0x0310, 0x0084, 5, 0x0000, 0, 0),
	MX6_PAD_UART1_TX_DATA__SPDIF_OUT                       = IOMUX_PAD(0x0310, 0x0084, 8, 0x0000, 0, 0),

	MX6_PAD_UART1_RX_DATA__UART1_DCE_RX                    = IOMUX_PAD(0x0314, 0x0088, 0, 0x0624, 3, 0),

	MX6_PAD_UART1_RX_DATA__UART1_DTE_TX                    = IOMUX_PAD(0x0314, 0x0088, 0, 0x0000, 0, 0),
	MX6_PAD_UART1_RX_DATA__ENET1_RDATA03                   = IOMUX_PAD(0x0314, 0x0088, 1, 0x0000, 0, 0),
	MX6_PAD_UART1_RX_DATA__I2C3_SDA                        = IOMUX_PAD(0x0314, 0x0088, IOMUX_CONFIG_SION | 2, 0x05B8, 0, 0),
	MX6_PAD_UART1_RX_DATA__CSI_DATA03                      = IOMUX_PAD(0x0314, 0x0088, 3, 0x04C8, 1, 0),
	MX6_PAD_UART1_RX_DATA__GPT1_CLK                        = IOMUX_PAD(0x0314, 0x0088, 4, 0x0594, 0, 0),
	MX6_PAD_UART1_RX_DATA__GPIO1_IO17                      = IOMUX_PAD(0x0314, 0x0088, 5, 0x0000, 0, 0),
	MX6_PAD_UART1_RX_DATA__SPDIF_IN                        = IOMUX_PAD(0x0314, 0x0088, 8, 0x0618, 1, 0),

	MX6_PAD_UART1_CTS_B__UART1_DCE_CTS                     = IOMUX_PAD(0x0318, 0x008C, 0, 0x0000, 0, 0),

	MX6_PAD_UART1_CTS_B__UART1_DTE_RTS                     = IOMUX_PAD(0x0318, 0x008C, 0, 0x0620, 2, 0),
	MX6_PAD_UART1_CTS_B__ENET1_RX_CLK                      = IOMUX_PAD(0x0318, 0x008C, 1, 0x0000, 0, 0),
	MX6_PAD_UART1_CTS_B__USDHC1_WP                         = IOMUX_PAD(0x0318, 0x008C, 2, 0x066C, 1, 0),
	MX6_PAD_UART1_CTS_B__CSI_DATA04                        = IOMUX_PAD(0x0318, 0x008C, 3, 0x04D8, 0, 0),
	MX6_PAD_UART1_CTS_B__ENET2_1588_EVENT1_IN              = IOMUX_PAD(0x0318, 0x008C, 4, 0x0000, 0, 0),
	MX6_PAD_UART1_CTS_B__GPIO1_IO18                        = IOMUX_PAD(0x0318, 0x008C, 5, 0x0000, 0, 0),
	MX6_PAD_UART1_CTS_B__USDHC2_WP                         = IOMUX_PAD(0x0318, 0x008C, 8, 0x069C, 1, 0),

	MX6_PAD_UART1_RTS_B__UART1_DCE_RTS                     = IOMUX_PAD(0x031C, 0x0090, 0, 0x0620, 3, 0),

	MX6_PAD_UART1_RTS_B__UART1_DTE_CTS                     = IOMUX_PAD(0x031C, 0x0090, 0, 0x0000, 0, 0),
	MX6_PAD_UART1_RTS_B__ENET1_TX_ER                       = IOMUX_PAD(0x031C, 0x0090, 1, 0x0000, 0, 0),
	MX6_PAD_UART1_RTS_B__USDHC1_CD_B                       = IOMUX_PAD(0x031C, 0x0090, 2, 0x0668, 1, 0),
	MX6_PAD_UART1_RTS_B__CSI_DATA05                        = IOMUX_PAD(0x031C, 0x0090, 3, 0x04CC, 1, 0),
	MX6_PAD_UART1_RTS_B__ENET2_1588_EVENT1_OUT             = IOMUX_PAD(0x031C, 0x0090, 4, 0x0000, 0, 0),
	MX6_PAD_UART1_RTS_B__GPIO1_IO19                        = IOMUX_PAD(0x031C, 0x0090, 5, 0x0000, 0, 0),
	MX6_PAD_UART1_RTS_B__USDHC2_CD_B                       = IOMUX_PAD(0x031C, 0x0090, 8, 0x0674, 2, 0),

	MX6_PAD_UART2_TX_DATA__UART2_DCE_TX                    = IOMUX_PAD(0x0320, 0x0094, 0, 0x0000, 0, 0),

	MX6_PAD_UART2_TX_DATA__UART2_DTE_RX                    = IOMUX_PAD(0x0320, 0x0094, 0, 0x062C, 0, 0),
	MX6_PAD_UART2_TX_DATA__ENET1_TDATA02                   = IOMUX_PAD(0x0320, 0x0094, 1, 0x0000, 0, 0),
	MX6_PAD_UART2_TX_DATA__I2C4_SCL                        = IOMUX_PAD(0x0320, 0x0094, IOMUX_CONFIG_SION | 2, 0x05BC, 0, 0),
	MX6_PAD_UART2_TX_DATA__CSI_DATA06                      = IOMUX_PAD(0x0320, 0x0094, 3, 0x04DC, 0, 0),
	MX6_PAD_UART2_TX_DATA__GPT1_CAPTURE1                   = IOMUX_PAD(0x0320, 0x0094, 4, 0x058C, 1, 0),
	MX6_PAD_UART2_TX_DATA__GPIO1_IO20                      = IOMUX_PAD(0x0320, 0x0094, 5, 0x0000, 0, 0),
	MX6_PAD_UART2_TX_DATA__ECSPI3_SS0                      = IOMUX_PAD(0x0320, 0x0094, 8, 0x0560, 0, 0),

	MX6_PAD_UART2_RX_DATA__UART2_DCE_RX                    = IOMUX_PAD(0x0324, 0x0098, 0, 0x062C, 1, 0),

	MX6_PAD_UART2_RX_DATA__UART2_DTE_TX                    = IOMUX_PAD(0x0324, 0x0098, 0, 0x0000, 0, 0),
	MX6_PAD_UART2_RX_DATA__ENET1_TDATA03                   = IOMUX_PAD(0x0324, 0x0098, 1, 0x0000, 0, 0),
	MX6_PAD_UART2_RX_DATA__I2C4_SDA                        = IOMUX_PAD(0x0324, 0x0098, IOMUX_CONFIG_SION | 2, 0x05C0, 0, 0),
	MX6_PAD_UART2_RX_DATA__CSI_DATA07                      = IOMUX_PAD(0x0324, 0x0098, 3, 0x04E0, 0, 0),
	MX6_PAD_UART2_RX_DATA__GPT1_CAPTURE2                   = IOMUX_PAD(0x0324, 0x0098, 4, 0x0590, 0, 0),
	MX6_PAD_UART2_RX_DATA__GPIO1_IO21                      = IOMUX_PAD(0x0324, 0x0098, 5, 0x0000, 0, 0),
	MX6_PAD_UART2_RX_DATA__SJC_DONE                        = IOMUX_PAD(0x0324, 0x0098, 7, 0x0000, 0, 0),
	MX6_PAD_UART2_RX_DATA__ECSPI3_SCLK                     = IOMUX_PAD(0x0324, 0x0098, 8, 0x0554, 0, 0),

	MX6_PAD_UART2_CTS_B__UART2_DCE_CTS                     = IOMUX_PAD(0x0328, 0x009C, 0, 0x0000, 0, 0),

	MX6_PAD_UART2_CTS_B__UART2_DTE_RTS                     = IOMUX_PAD(0x0328, 0x009C, 0, 0x0628, 0, 0),
	MX6_PAD_UART2_CTS_B__ENET1_CRS                         = IOMUX_PAD(0x0328, 0x009C, 1, 0x0000, 0, 0),
	MX6_PAD_UART2_CTS_B__FLEXCAN2_TX                       = IOMUX_PAD(0x0328, 0x009C, 2, 0x0000, 0, 0),
	MX6_PAD_UART2_CTS_B__CSI_DATA08                        = IOMUX_PAD(0x0328, 0x009C, 3, 0x04E4, 0, 0),
	MX6_PAD_UART2_CTS_B__GPT1_COMPARE2                     = IOMUX_PAD(0x0328, 0x009C, 4, 0x0000, 0, 0),
	MX6_PAD_UART2_CTS_B__GPIO1_IO22                        = IOMUX_PAD(0x0328, 0x009C, 5, 0x0000, 0, 0),
	MX6_PAD_UART2_CTS_B__SJC_DE_B                          = IOMUX_PAD(0x0328, 0x009C, 7, 0x0000, 0, 0),
	MX6_PAD_UART2_CTS_B__ECSPI3_MOSI                       = IOMUX_PAD(0x0328, 0x009C, 8, 0x055C, 0, 0),

	MX6_PAD_UART2_RTS_B__UART2_DCE_RTS                     = IOMUX_PAD(0x032C, 0x00A0, 0, 0x0628, 1, 0),

	MX6_PAD_UART2_RTS_B__UART2_DTE_CTS                     = IOMUX_PAD(0x032C, 0x00A0, 0, 0x0000, 0, 0),
	MX6_PAD_UART2_RTS_B__ENET1_COL                         = IOMUX_PAD(0x032C, 0x00A0, 1, 0x0000, 0, 0),
	MX6_PAD_UART2_RTS_B__FLEXCAN2_RX                       = IOMUX_PAD(0x032C, 0x00A0, 2, 0x0588, 0, 0),
	MX6_PAD_UART2_RTS_B__CSI_DATA09                        = IOMUX_PAD(0x032C, 0x00A0, 3, 0x04E8, 0, 0),
	MX6_PAD_UART2_RTS_B__GPT1_COMPARE3                     = IOMUX_PAD(0x032C, 0x00A0, 4, 0x0000, 0, 0),
	MX6_PAD_UART2_RTS_B__GPIO1_IO23                        = IOMUX_PAD(0x032C, 0x00A0, 5, 0x0000, 0, 0),
	MX6_PAD_UART2_RTS_B__SJC_FAIL                          = IOMUX_PAD(0x032C, 0x00A0, 7, 0x0000, 0, 0),
	MX6_PAD_UART2_RTS_B__ECSPI3_MISO                       = IOMUX_PAD(0x032C, 0x00A0, 8, 0x0558, 0, 0),

	MX6_PAD_UART3_TX_DATA__UART3_DCE_TX                    = IOMUX_PAD(0x0330, 0x00A4, 0, 0x0000, 0, 0),

	MX6_PAD_UART3_TX_DATA__UART3_DTE_RX                    = IOMUX_PAD(0x0330, 0x00A4, 0, 0x0634, 0, 0),
	MX6_PAD_UART3_TX_DATA__ENET2_RDATA02                   = IOMUX_PAD(0x0330, 0x00A4, 1, 0x0000, 0, 0),
	MX6_PAD_UART3_TX_DATA__SIM1_PORT0_PD                   = IOMUX_PAD(0x0330, 0x00A4, 2, 0x0000, 0, 0),
	MX6_PAD_UART3_TX_DATA__CSI_DATA01                      = IOMUX_PAD(0x0330, 0x00A4, 3, 0x04D4, 0, 0),
	MX6_PAD_UART3_TX_DATA__UART2_DCE_CTS                   = IOMUX_PAD(0x0330, 0x00A4, 4, 0x0000, 0, 0),
	MX6_PAD_UART3_TX_DATA__UART2_DTE_RTS                   = IOMUX_PAD(0x0330, 0x00A4, 4, 0x0628, 2, 0),
	MX6_PAD_UART3_TX_DATA__GPIO1_IO24                      = IOMUX_PAD(0x0330, 0x00A4, 5, 0x0000, 0, 0),
	MX6_PAD_UART3_TX_DATA__SJC_JTAG_ACT                    = IOMUX_PAD(0x0330, 0x00A4, 7, 0x0000, 0, 0),
	MX6_PAD_UART3_TX_DATA__ANATOP_OTG1_ID                  = IOMUX_PAD(0x0330, 0x00A4, 8, 0x04B8, 1, 0),

	MX6_PAD_UART3_RX_DATA__UART3_DCE_RX                    = IOMUX_PAD(0x0334, 0x00A8, 0, 0x0634, 1, 0),

	MX6_PAD_UART3_RX_DATA__UART3_DTE_TX                    = IOMUX_PAD(0x0334, 0x00A8, 0, 0x0000, 0, 0),
	MX6_PAD_UART3_RX_DATA__ENET2_RDATA03                   = IOMUX_PAD(0x0334, 0x00A8, 1, 0x0000, 0, 0),
	MX6_PAD_UART3_RX_DATA__SIM2_PORT0_PD                   = IOMUX_PAD(0x0334, 0x00A8, 2, 0x0000, 0, 0),
	MX6_PAD_UART3_RX_DATA__CSI_DATA00                      = IOMUX_PAD(0x0334, 0x00A8, 3, 0x04D0, 0, 0),
	MX6_PAD_UART3_RX_DATA__UART2_DCE_RTS                   = IOMUX_PAD(0x0334, 0x00A8, 4, 0x0628, 3, 0),
	MX6_PAD_UART3_RX_DATA__UART2_DTE_CTS                   = IOMUX_PAD(0x0334, 0x00A8, 4, 0x0000, 0, 0),
	MX6_PAD_UART3_RX_DATA__GPIO1_IO25                      = IOMUX_PAD(0x0334, 0x00A8, 5, 0x0000, 0, 0),
	MX6_PAD_UART3_RX_DATA__EPIT1_OUT                       = IOMUX_PAD(0x0334, 0x00A8, 8, 0x0000, 0, 0),

	MX6_PAD_UART3_CTS_B__UART3_DCE_CTS                     = IOMUX_PAD(0x0338, 0x00AC, 0, 0x0000, 0, 0),

	MX6_PAD_UART3_CTS_B__UART3_DTE_RTS                     = IOMUX_PAD(0x0338, 0x00AC, 0, 0x0630, 0, 0),
	MX6_PAD_UART3_CTS_B__ENET2_RX_CLK                      = IOMUX_PAD(0x0338, 0x00AC, IOMUX_CONFIG_SION | 1, 0x0000, 0, 0),
	MX6_PAD_UART3_CTS_B__FLEXCAN1_TX                       = IOMUX_PAD(0x0338, 0x00AC, 2, 0x0000, 0, 0),
	MX6_PAD_UART3_CTS_B__CSI_DATA10                        = IOMUX_PAD(0x0338, 0x00AC, 3, 0x04EC, 0, 0),
	MX6_PAD_UART3_CTS_B__ENET1_1588_EVENT1_IN              = IOMUX_PAD(0x0338, 0x00AC, 4, 0x0000, 0, 0),
	MX6_PAD_UART3_CTS_B__GPIO1_IO26                        = IOMUX_PAD(0x0338, 0x00AC, 5, 0x0000, 0, 0),
	MX6_PAD_UART3_CTS_B__EPIT2_OUT                         = IOMUX_PAD(0x0338, 0x00AC, 8, 0x0000, 0, 0),

	MX6_PAD_UART3_RTS_B__UART3_DCE_RTS                     = IOMUX_PAD(0x033C, 0x00B0, 0, 0x0630, 1, 0),

	MX6_PAD_UART3_RTS_B__UART3_DTE_CTS                     = IOMUX_PAD(0x033C, 0x00B0, 0, 0x0000, 0, 0),
	MX6_PAD_UART3_RTS_B__ENET2_TX_ER                       = IOMUX_PAD(0x033C, 0x00B0, 1, 0x0000, 0, 0),
	MX6_PAD_UART3_RTS_B__FLEXCAN1_RX                       = IOMUX_PAD(0x033C, 0x00B0, 2, 0x0584, 0, 0),
	MX6_PAD_UART3_RTS_B__CSI_DATA11                        = IOMUX_PAD(0x033C, 0x00B0, 3, 0x04F0, 0, 0),
	MX6_PAD_UART3_RTS_B__ENET1_1588_EVENT1_OUT             = IOMUX_PAD(0x033C, 0x00B0, 4, 0x0000, 0, 0),
	MX6_PAD_UART3_RTS_B__GPIO1_IO27                        = IOMUX_PAD(0x033C, 0x00B0, 5, 0x0000, 0, 0),
	MX6_PAD_UART3_RTS_B__WDOG1_WDOG_B                      = IOMUX_PAD(0x033C, 0x00B0, 8, 0x0000, 0, 0),

	MX6_PAD_UART4_TX_DATA__UART4_DCE_TX                    = IOMUX_PAD(0x0340, 0x00B4, 0, 0x0000, 0, 0),

	MX6_PAD_UART4_TX_DATA__UART4_DTE_RX                    = IOMUX_PAD(0x0340, 0x00B4, 0, 0x063C, 0, 0),
	MX6_PAD_UART4_TX_DATA__ENET2_TDATA02                   = IOMUX_PAD(0x0340, 0x00B4, 1, 0x0000, 0, 0),
	MX6_PAD_UART4_TX_DATA__I2C1_SCL                        = IOMUX_PAD(0x0340, 0x00B4, IOMUX_CONFIG_SION | 2, 0x05A4, 1, 0),
	MX6_PAD_UART4_TX_DATA__CSI_DATA12                      = IOMUX_PAD(0x0340, 0x00B4, 3, 0x04F4, 0, 0),
	MX6_PAD_UART4_TX_DATA__CSU_CSU_ALARM_AUT02             = IOMUX_PAD(0x0340, 0x00B4, 4, 0x0000, 0, 0),
	MX6_PAD_UART4_TX_DATA__GPIO1_IO28                      = IOMUX_PAD(0x0340, 0x00B4, 5, 0x0000, 0, 0),
	MX6_PAD_UART4_TX_DATA__ECSPI2_SCLK                     = IOMUX_PAD(0x0340, 0x00B4, 8, 0x0544, 1, 0),

	MX6_PAD_UART4_RX_DATA__UART4_DCE_RX                    = IOMUX_PAD(0x0344, 0x00B8, 0, 0x063C, 1, 0),

	MX6_PAD_UART4_RX_DATA__UART4_DTE_TX                    = IOMUX_PAD(0x0344, 0x00B8, 0, 0x0000, 0, 0),
	MX6_PAD_UART4_RX_DATA__ENET2_TDATA03                   = IOMUX_PAD(0x0344, 0x00B8, 1, 0x0000, 0, 0),
	MX6_PAD_UART4_RX_DATA__I2C1_SDA                        = IOMUX_PAD(0x0344, 0x00B8, IOMUX_CONFIG_SION | 2, 0x05A8, 2, 0),
	MX6_PAD_UART4_RX_DATA__CSI_DATA13                      = IOMUX_PAD(0x0344, 0x00B8, 3, 0x04F8, 0, 0),
	MX6_PAD_UART4_RX_DATA__CSU_CSU_ALARM_AUT01             = IOMUX_PAD(0x0344, 0x00B8, 4, 0x0000, 0, 0),
	MX6_PAD_UART4_RX_DATA__GPIO1_IO29                      = IOMUX_PAD(0x0344, 0x00B8, 5, 0x0000, 0, 0),
	MX6_PAD_UART4_RX_DATA__ECSPI2_SS0                      = IOMUX_PAD(0x0344, 0x00B8, 8, 0x0550, 1, 0),
	MX6_PAD_UART5_TX_DATA__GPIO1_IO30                      = IOMUX_PAD(0x0348, 0x00BC, 5, 0x0000, 0, 0),
	MX6_PAD_UART5_TX_DATA__ECSPI2_MOSI                     = IOMUX_PAD(0x0348, 0x00BC, 8, 0x054C, 0, 0),

	MX6_PAD_UART5_TX_DATA__UART5_DCE_TX                    = IOMUX_PAD(0x0348, 0x00BC, 0, 0x0000, 0, 0),

	MX6_PAD_UART5_TX_DATA__UART5_DTE_RX                    = IOMUX_PAD(0x0348, 0x00BC, 0, 0x0644, 4, 0),
	MX6_PAD_UART5_TX_DATA__ENET2_CRS                       = IOMUX_PAD(0x0348, 0x00BC, 1, 0x0000, 0, 0),
	MX6_PAD_UART5_TX_DATA__I2C2_SCL                        = IOMUX_PAD(0x0348, 0x00BC, IOMUX_CONFIG_SION | 2, 0x05AC, 2, 0),
	MX6_PAD_UART5_TX_DATA__CSI_DATA14                      = IOMUX_PAD(0x0348, 0x00BC, 3, 0x04FC, 0, 0),
	MX6_PAD_UART5_TX_DATA__CSU_CSU_ALARM_AUT00             = IOMUX_PAD(0x0348, 0x00BC, 4, 0x0000, 0, 0),

	MX6_PAD_UART5_RX_DATA__UART5_DCE_RX                    = IOMUX_PAD(0x034C, 0x00C0, 0, 0x0644, 5, 0),

	MX6_PAD_UART5_RX_DATA__UART5_DTE_TX                    = IOMUX_PAD(0x034C, 0x00C0, 0, 0x0000, 0, 0),
	MX6_PAD_UART5_RX_DATA__ENET2_COL                       = IOMUX_PAD(0x034C, 0x00C0, 1, 0x0000, 0, 0),
	MX6_PAD_UART5_RX_DATA__I2C2_SDA                        = IOMUX_PAD(0x034C, 0x00C0, IOMUX_CONFIG_SION | 2, 0x05B0, 2, 0),
	MX6_PAD_UART5_RX_DATA__CSI_DATA15                      = IOMUX_PAD(0x034C, 0x00C0, 3, 0x0500, 0, 0),
	MX6_PAD_UART5_RX_DATA__CSU_CSU_INT_DEB                 = IOMUX_PAD(0x034C, 0x00C0, 4, 0x0000, 0, 0),
	MX6_PAD_UART5_RX_DATA__GPIO1_IO31                      = IOMUX_PAD(0x034C, 0x00C0, 5, 0x0000, 0, 0),
	MX6_PAD_UART5_RX_DATA__ECSPI2_MISO                     = IOMUX_PAD(0x034C, 0x00C0, 8, 0x0548, 1, 0),

	MX6_PAD_ENET1_RX_DATA0__ENET1_RDATA00                  = IOMUX_PAD(0x0350, 0x00C4, 0, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_DATA0__UART4_DCE_RTS                  = IOMUX_PAD(0x0350, 0x00C4, 1, 0x0638, 0, 0),
	MX6_PAD_ENET1_RX_DATA0__UART4_DTE_CTS                  = IOMUX_PAD(0x0350, 0x00C4, 1, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_DATA0__PWM1_OUT                       = IOMUX_PAD(0x0350, 0x00C4, 2, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_DATA0__CSI_DATA16                     = IOMUX_PAD(0x0350, 0x00C4, 3, 0x0504, 0, 0),
	MX6_PAD_ENET1_RX_DATA0__FLEXCAN1_TX                    = IOMUX_PAD(0x0350, 0x00C4, 4, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_DATA0__GPIO2_IO00                     = IOMUX_PAD(0x0350, 0x00C4, 5, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_DATA0__KPP_ROW00                      = IOMUX_PAD(0x0350, 0x00C4, 6, 0x05D0, 0, 0),
	MX6_PAD_ENET1_RX_DATA0__USDHC1_LCTL                    = IOMUX_PAD(0x0350, 0x00C4, 8, 0x0000, 0, 0),

	MX6_PAD_ENET1_RX_DATA1__ENET1_RDATA01                  = IOMUX_PAD(0x0354, 0x00C8, 0, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_DATA1__UART4_DCE_CTS                  = IOMUX_PAD(0x0354, 0x00C8, 1, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_DATA1__UART4_DTE_RTS                  = IOMUX_PAD(0x0354, 0x00C8, 1, 0x0638, 1, 0),
	MX6_PAD_ENET1_RX_DATA1__PWM2_OUT                       = IOMUX_PAD(0x0354, 0x00C8, 2, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_DATA1__CSI_DATA17                     = IOMUX_PAD(0x0354, 0x00C8, 3, 0x0508, 0, 0),
	MX6_PAD_ENET1_RX_DATA1__FLEXCAN1_RX                    = IOMUX_PAD(0x0354, 0x00C8, 4, 0x0584, 1, 0),
	MX6_PAD_ENET1_RX_DATA1__GPIO2_IO01                     = IOMUX_PAD(0x0354, 0x00C8, 5, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_DATA1__KPP_COL00                      = IOMUX_PAD(0x0354, 0x00C8, 6, 0x05C4, 0, 0),
	MX6_PAD_ENET1_RX_DATA1__USDHC2_LCTL                    = IOMUX_PAD(0x0354, 0x00C8, 8, 0x0000, 0, 0),

	MX6_PAD_ENET1_RX_EN__ENET1_RX_EN                       = IOMUX_PAD(0x0358, 0x00CC, 0, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_EN__UART5_DCE_RTS                     = IOMUX_PAD(0x0358, 0x00CC, 1, 0x0640, 3, 0),
	MX6_PAD_ENET1_RX_EN__UART5_DTE_CTS                     = IOMUX_PAD(0x0358, 0x00CC, 1, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_EN__CSI_DATA18                        = IOMUX_PAD(0x0358, 0x00CC, 3, 0x050C, 0, 0),
	MX6_PAD_ENET1_RX_EN__FLEXCAN2_TX                       = IOMUX_PAD(0x0358, 0x00CC, 4, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_EN__GPIO2_IO02                        = IOMUX_PAD(0x0358, 0x00CC, 5, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_EN__KPP_ROW01                         = IOMUX_PAD(0x0358, 0x00CC, 6, 0x05D4, 0, 0),
	MX6_PAD_ENET1_RX_EN__USDHC1_VSELECT                    = IOMUX_PAD(0x0358, 0x00CC, 8, 0x0000, 0, 0),

	MX6_PAD_ENET1_TX_DATA0__ENET1_TDATA00                  = IOMUX_PAD(0x035C, 0x00D0, 0, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_DATA0__UART5_DCE_CTS                  = IOMUX_PAD(0x035C, 0x00D0, 1, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_DATA0__UART5_DTE_RTS                  = IOMUX_PAD(0x035C, 0x00D0, 1, 0x0640, 4, 0),
	MX6_PAD_ENET1_TX_DATA0__CSI_DATA19                     = IOMUX_PAD(0x035C, 0x00D0, 3, 0x0510, 0, 0),
	MX6_PAD_ENET1_TX_DATA0__FLEXCAN2_RX                    = IOMUX_PAD(0x035C, 0x00D0, 4, 0x0588, 1, 0),
	MX6_PAD_ENET1_TX_DATA0__GPIO2_IO03                     = IOMUX_PAD(0x035C, 0x00D0, 5, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_DATA0__KPP_COL01                      = IOMUX_PAD(0x035C, 0x00D0, 6, 0x05C8, 0, 0),
	MX6_PAD_ENET1_TX_DATA0__USDHC2_VSELECT                 = IOMUX_PAD(0x035C, 0x00D0, 8, 0x0000, 0, 0),

	MX6_PAD_ENET1_TX_DATA1__ENET1_TDATA01                  = IOMUX_PAD(0x0360, 0x00D4, 0, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_DATA1__UART6_DCE_CTS                  = IOMUX_PAD(0x0360, 0x00D4, 1, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_DATA1__UART6_DTE_RTS                  = IOMUX_PAD(0x0360, 0x00D4, 1, 0x0648, 2, 0),
	MX6_PAD_ENET1_TX_DATA1__PWM5_OUT                       = IOMUX_PAD(0x0360, 0x00D4, 2, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_DATA1__CSI_DATA20                     = IOMUX_PAD(0x0360, 0x00D4, 3, 0x0514, 0, 0),
	MX6_PAD_ENET1_TX_DATA1__ENET2_MDIO                     = IOMUX_PAD(0x0360, 0x00D4, 4, 0x0580, 1, 0),
	MX6_PAD_ENET1_TX_DATA1__GPIO2_IO04                     = IOMUX_PAD(0x0360, 0x00D4, 5, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_DATA1__KPP_ROW02                      = IOMUX_PAD(0x0360, 0x00D4, 6, 0x05D8, 0, 0),
	MX6_PAD_ENET1_TX_DATA1__WDOG1_WDOG_RST_B_DEB           = IOMUX_PAD(0x0360, 0x00D4, 8, 0x0000, 0, 0),

	MX6_PAD_ENET1_TX_EN__ENET1_TX_EN                       = IOMUX_PAD(0x0364, 0x00D8, 0, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_EN__UART6_DCE_RTS                     = IOMUX_PAD(0x0364, 0x00D8, 1, 0x0648, 3, 0),
	MX6_PAD_ENET1_TX_EN__UART6_DTE_CTS                     = IOMUX_PAD(0x0364, 0x00D8, 1, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_EN__PWM6_OUT                          = IOMUX_PAD(0x0364, 0x00D8, 2, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_EN__CSI_DATA21                        = IOMUX_PAD(0x0364, 0x00D8, 3, 0x0518, 0, 0),
	MX6_PAD_ENET1_TX_EN__ENET2_MDC                         = IOMUX_PAD(0x0364, 0x00D8, 4, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_EN__GPIO2_IO05                        = IOMUX_PAD(0x0364, 0x00D8, 5, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_EN__KPP_COL02                         = IOMUX_PAD(0x0364, 0x00D8, 6, 0x05CC, 0, 0),
	MX6_PAD_ENET1_TX_EN__WDOG2_WDOG_RST_B_DEB              = IOMUX_PAD(0x0364, 0x00D8, 8, 0x0000, 0, 0),

	MX6_PAD_ENET1_TX_CLK__ENET1_TX_CLK                     = IOMUX_PAD(0x0368, 0x00DC, 0, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_CLK__UART7_DCE_CTS                    = IOMUX_PAD(0x0368, 0x00DC, 1, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_CLK__UART7_DTE_RTS                    = IOMUX_PAD(0x0368, 0x00DC, 1, 0x0650, 0, 0),
	MX6_PAD_ENET1_TX_CLK__PWM7_OUT                         = IOMUX_PAD(0x0368, 0x00DC, 2, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_CLK__CSI_DATA22                       = IOMUX_PAD(0x0368, 0x00DC, 3, 0x051C, 0, 0),
	MX6_PAD_ENET1_TX_CLK__ENET1_REF_CLK1                   = IOMUX_PAD(0x0368, 0x00DC, IOMUX_CONFIG_SION | 4, 0x0574, 2, 0),
	MX6_PAD_ENET1_TX_CLK__GPIO2_IO06                       = IOMUX_PAD(0x0368, 0x00DC, 5, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_CLK__KPP_ROW03                        = IOMUX_PAD(0x0368, 0x00DC, 6, 0x0000, 0, 0),
	MX6_PAD_ENET1_TX_CLK__GPT1_CLK                         = IOMUX_PAD(0x0368, 0x00DC, 8, 0x0594, 1, 0),

	MX6_PAD_ENET1_RX_ER__ENET1_RX_ER                       = IOMUX_PAD(0x036C, 0x00E0, 0, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_ER__UART7_DCE_RTS                     = IOMUX_PAD(0x036C, 0x00E0, 1, 0x0650, 1, 0),
	MX6_PAD_ENET1_RX_ER__UART7_DTE_CTS                     = IOMUX_PAD(0x036C, 0x00E0, 1, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_ER__PWM8_OUT                          = IOMUX_PAD(0x036C, 0x00E0, 2, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_ER__CSI_DATA23                        = IOMUX_PAD(0x036C, 0x00E0, 3, 0x0520, 0, 0),
	MX6_PAD_ENET1_RX_ER__EIM_CRE                           = IOMUX_PAD(0x036C, 0x00E0, 4, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_ER__GPIO2_IO07                        = IOMUX_PAD(0x036C, 0x00E0, 5, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_ER__KPP_COL03                         = IOMUX_PAD(0x036C, 0x00E0, 6, 0x0000, 0, 0),
	MX6_PAD_ENET1_RX_ER__GPT1_CAPTURE2                     = IOMUX_PAD(0x036C, 0x00E0, 8, 0x0590, 1, 0),

	MX6_PAD_ENET2_RX_DATA0__ENET2_RDATA00                  = IOMUX_PAD(0x0370, 0x00E4, 0, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_DATA0__UART6_DCE_TX                   = IOMUX_PAD(0x0370, 0x00E4, 1, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_DATA0__UART6_DTE_RX                   = IOMUX_PAD(0x0370, 0x00E4, 1, 0x064C, 1, 0),
	MX6_PAD_ENET2_RX_DATA0__SIM1_PORT0_TRXD                = IOMUX_PAD(0x0370, 0x00E4, 2, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_DATA0__I2C3_SCL                       = IOMUX_PAD(0x0370, 0x00E4, IOMUX_CONFIG_SION | 3, 0x05B4, 1, 0),
	MX6_PAD_ENET2_RX_DATA0__ENET1_MDIO                     = IOMUX_PAD(0x0370, 0x00E4, 4, 0x0578, 1, 0),
	MX6_PAD_ENET2_RX_DATA0__GPIO2_IO08                     = IOMUX_PAD(0x0370, 0x00E4, 5, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_DATA0__KPP_ROW04                      = IOMUX_PAD(0x0370, 0x00E4, 6, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_DATA0__USB_OTG1_PWR                   = IOMUX_PAD(0x0370, 0x00E4, 8, 0x0000, 0, 0),

	MX6_PAD_ENET2_RX_DATA1__ENET2_RDATA01                  = IOMUX_PAD(0x0374, 0x00E8, 0, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_DATA1__UART6_DCE_RX                   = IOMUX_PAD(0x0374, 0x00E8, 1, 0x064C, 2, 0),
	MX6_PAD_ENET2_RX_DATA1__UART6_DTE_TX                   = IOMUX_PAD(0x0374, 0x00E8, 1, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_DATA1__SIM1_PORT0_CLK                 = IOMUX_PAD(0x0374, 0x00E8, 2, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_DATA1__I2C3_SDA                       = IOMUX_PAD(0x0374, 0x00E8, IOMUX_CONFIG_SION | 3, 0x05B8, 1, 0),
	MX6_PAD_ENET2_RX_DATA1__ENET1_MDC                      = IOMUX_PAD(0x0374, 0x00E8, 4, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_DATA1__GPIO2_IO09                     = IOMUX_PAD(0x0374, 0x00E8, 5, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_DATA1__KPP_COL04                      = IOMUX_PAD(0x0374, 0x00E8, 6, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_DATA1__USB_OTG1_OC                    = IOMUX_PAD(0x0374, 0x00E8, 8, 0x0664, 1, 0),

	MX6_PAD_ENET2_RX_EN__ENET2_RX_EN                       = IOMUX_PAD(0x0378, 0x00EC, 0, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_EN__UART7_DCE_TX                      = IOMUX_PAD(0x0378, 0x00EC, 1, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_EN__UART7_DTE_RX                      = IOMUX_PAD(0x0378, 0x00EC, 1, 0x0654, 0, 0),
	MX6_PAD_ENET2_RX_EN__SIM1_PORT0_RST_B                  = IOMUX_PAD(0x0378, 0x00EC, 2, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_EN__I2C4_SCL                          = IOMUX_PAD(0x0378, 0x00EC, IOMUX_CONFIG_SION | 3, 0x05BC, 1, 0),
	MX6_PAD_ENET2_RX_EN__EIM_ADDR26                        = IOMUX_PAD(0x0378, 0x00EC, 4, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_EN__GPIO2_IO10                        = IOMUX_PAD(0x0378, 0x00EC, 5, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_EN__KPP_ROW05                         = IOMUX_PAD(0x0378, 0x00EC, 6, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_EN__ENET1_REF_CLK_25M                 = IOMUX_PAD(0x0378, 0x00EC, 8, 0x0000, 0, 0),

	MX6_PAD_ENET2_TX_DATA0__ENET2_TDATA00                  = IOMUX_PAD(0x037C, 0x00F0, 0, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_DATA0__UART7_DCE_RX                   = IOMUX_PAD(0x037C, 0x00F0, 1, 0x0654, 1, 0),
	MX6_PAD_ENET2_TX_DATA0__UART7_DTE_TX                   = IOMUX_PAD(0x037C, 0x00F0, 1, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_DATA0__SIM1_PORT0_SVEN                = IOMUX_PAD(0x037C, 0x00F0, 2, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_DATA0__I2C4_SDA                       = IOMUX_PAD(0x037C, 0x00F0, IOMUX_CONFIG_SION | 3, 0x05C0, 1, 0),
	MX6_PAD_ENET2_TX_DATA0__EIM_EB_B02                     = IOMUX_PAD(0x037C, 0x00F0, 4, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_DATA0__GPIO2_IO11                     = IOMUX_PAD(0x037C, 0x00F0, 5, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_DATA0__KPP_COL05                      = IOMUX_PAD(0x037C, 0x00F0, 6, 0x0000, 0, 0),

	MX6_PAD_ENET2_TX_DATA1__ENET2_TDATA01                  = IOMUX_PAD(0x0380, 0x00F4, 0, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_DATA1__UART8_DCE_TX                   = IOMUX_PAD(0x0380, 0x00F4, 1, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_DATA1__UART8_DTE_RX                   = IOMUX_PAD(0x0380, 0x00F4, 1, 0x065C, 0, 0),
	MX6_PAD_ENET2_TX_DATA1__SIM2_PORT0_TRXD                = IOMUX_PAD(0x0380, 0x00F4, 2, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_DATA1__ECSPI4_SCLK                    = IOMUX_PAD(0x0380, 0x00F4, 3, 0x0564, 0, 0),
	MX6_PAD_ENET2_TX_DATA1__EIM_EB_B03                     = IOMUX_PAD(0x0380, 0x00F4, 4, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_DATA1__GPIO2_IO12                     = IOMUX_PAD(0x0380, 0x00F4, 5, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_DATA1__KPP_ROW06                      = IOMUX_PAD(0x0380, 0x00F4, 6, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_DATA1__USB_OTG2_PWR                   = IOMUX_PAD(0x0380, 0x00F4, 8, 0x0000, 0, 0),

	MX6_PAD_ENET2_TX_EN__ENET2_TX_EN                       = IOMUX_PAD(0x0384, 0x00F8, 0, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_EN__UART8_DCE_RX                      = IOMUX_PAD(0x0384, 0x00F8, 1, 0x065C, 1, 0),
	MX6_PAD_ENET2_TX_EN__UART8_DTE_TX                      = IOMUX_PAD(0x0384, 0x00F8, 1, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_EN__SIM2_PORT0_CLK                    = IOMUX_PAD(0x0384, 0x00F8, 2, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_EN__ECSPI4_MOSI                       = IOMUX_PAD(0x0384, 0x00F8, 3, 0x056C, 0, 0),
	MX6_PAD_ENET2_TX_EN__EIM_ACLK_FREERUN                  = IOMUX_PAD(0x0384, 0x00F8, 4, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_EN__GPIO2_IO13                        = IOMUX_PAD(0x0384, 0x00F8, 5, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_EN__KPP_COL06                         = IOMUX_PAD(0x0384, 0x00F8, 6, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_EN__USB_OTG2_OC                       = IOMUX_PAD(0x0384, 0x00F8, 8, 0x0660, 1, 0),

	MX6_PAD_ENET2_TX_CLK__ENET2_TX_CLK                     = IOMUX_PAD(0x0388, 0x00FC, IOMUX_CONFIG_SION | 0, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_CLK__UART8_DCE_CTS                    = IOMUX_PAD(0x0388, 0x00FC, 1, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_CLK__UART8_DTE_RTS                    = IOMUX_PAD(0x0388, 0x00FC, 1, 0x0658, 0, 0),
	MX6_PAD_ENET2_TX_CLK__SIM2_PORT0_RST_B                 = IOMUX_PAD(0x0388, 0x00FC, 2, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_CLK__ECSPI4_MISO                      = IOMUX_PAD(0x0388, 0x00FC, 3, 0x0568, 0, 0),
	MX6_PAD_ENET2_TX_CLK__ENET2_REF_CLK2                   = IOMUX_PAD(0x0388, 0x00FC, IOMUX_CONFIG_SION | 4, 0x057C, 2, 0),
	MX6_PAD_ENET2_TX_CLK__GPIO2_IO14                       = IOMUX_PAD(0x0388, 0x00FC, 5, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_CLK__KPP_ROW07                        = IOMUX_PAD(0x0388, 0x00FC, 6, 0x0000, 0, 0),
	MX6_PAD_ENET2_TX_CLK__ANATOP_OTG2_ID                   = IOMUX_PAD(0x0388, 0x00FC, 8, 0x04BC, 1, 0),

	MX6_PAD_ENET2_RX_ER__ENET2_RX_ER                       = IOMUX_PAD(0x038C, 0x0100, 0, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_ER__UART8_DCE_RTS                     = IOMUX_PAD(0x038C, 0x0100, 1, 0x0658, 1, 0),
	MX6_PAD_ENET2_RX_ER__UART8_DTE_CTS                     = IOMUX_PAD(0x038C, 0x0100, 1, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_ER__SIM2_PORT0_SVEN                   = IOMUX_PAD(0x038C, 0x0100, 2, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_ER__ECSPI4_SS0                        = IOMUX_PAD(0x038C, 0x0100, 3, 0x0570, 0, 0),
	MX6_PAD_ENET2_RX_ER__EIM_ADDR25                        = IOMUX_PAD(0x038C, 0x0100, 4, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_ER__GPIO2_IO15                        = IOMUX_PAD(0x038C, 0x0100, 5, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_ER__KPP_COL07                         = IOMUX_PAD(0x038C, 0x0100, 6, 0x0000, 0, 0),
	MX6_PAD_ENET2_RX_ER__WDOG1_WDOG_ANY                    = IOMUX_PAD(0x038C, 0x0100, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_CLK__LCDIF_CLK                             = IOMUX_PAD(0x0390, 0x0104, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_CLK__LCDIF_WR_RWN                          = IOMUX_PAD(0x0390, 0x0104, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_CLK__UART4_DCE_TX                          = IOMUX_PAD(0x0390, 0x0104, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_CLK__UART4_DTE_RX                          = IOMUX_PAD(0x0390, 0x0104, 2, 0x063C, 2, 0),
	MX6_PAD_LCD_CLK__SAI3_MCLK                             = IOMUX_PAD(0x0390, 0x0104, 3, 0x0600, 0, 0),
	MX6_PAD_LCD_CLK__EIM_CS2_B                             = IOMUX_PAD(0x0390, 0x0104, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_CLK__GPIO3_IO00                            = IOMUX_PAD(0x0390, 0x0104, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_CLK__WDOG1_WDOG_RST_B_DEB                  = IOMUX_PAD(0x0390, 0x0104, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_ENABLE__LCDIF_ENABLE                       = IOMUX_PAD(0x0394, 0x0108, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_ENABLE__LCDIF_RD_E                         = IOMUX_PAD(0x0394, 0x0108, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_ENABLE__UART4_DCE_RX                       = IOMUX_PAD(0x0394, 0x0108, 2, 0x063C, 3, 0),
	MX6_PAD_LCD_ENABLE__UART4_DTE_TX                       = IOMUX_PAD(0x0394, 0x0108, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_ENABLE__SAI3_TX_SYNC                       = IOMUX_PAD(0x0394, 0x0108, 3, 0x060C, 0, 0),
	MX6_PAD_LCD_ENABLE__EIM_CS3_B                          = IOMUX_PAD(0x0394, 0x0108, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_ENABLE__GPIO3_IO01                         = IOMUX_PAD(0x0394, 0x0108, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_ENABLE__ECSPI2_RDY                         = IOMUX_PAD(0x0394, 0x0108, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_HSYNC__LCDIF_HSYNC                         = IOMUX_PAD(0x0398, 0x010C, 0, 0x05DC, 0, 0),
	MX6_PAD_LCD_HSYNC__LCDIF_RS                            = IOMUX_PAD(0x0398, 0x010C, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_HSYNC__UART4_DCE_CTS                       = IOMUX_PAD(0x0398, 0x010C, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_HSYNC__UART4_DTE_RTS                       = IOMUX_PAD(0x0398, 0x010C, 2, 0x0638, 2, 0),
	MX6_PAD_LCD_HSYNC__SAI3_TX_BCLK                        = IOMUX_PAD(0x0398, 0x010C, 3, 0x0608, 0, 0),
	MX6_PAD_LCD_HSYNC__WDOG3_WDOG_RST_B_DEB                = IOMUX_PAD(0x0398, 0x010C, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_HSYNC__GPIO3_IO02                          = IOMUX_PAD(0x0398, 0x010C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_HSYNC__ECSPI2_SS1                          = IOMUX_PAD(0x0398, 0x010C, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_VSYNC__LCDIF_VSYNC                         = IOMUX_PAD(0x039C, 0x0110, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_VSYNC__LCDIF_BUSY                          = IOMUX_PAD(0x039C, 0x0110, 1, 0x05DC, 1, 0),
	MX6_PAD_LCD_VSYNC__UART4_DCE_RTS                       = IOMUX_PAD(0x039C, 0x0110, 2, 0x0638, 3, 0),
	MX6_PAD_LCD_VSYNC__UART4_DTE_CTS                       = IOMUX_PAD(0x039C, 0x0110, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_VSYNC__SAI3_RX_DATA                        = IOMUX_PAD(0x039C, 0x0110, 3, 0x0604, 0, 0),
	MX6_PAD_LCD_VSYNC__WDOG2_WDOG_B                        = IOMUX_PAD(0x039C, 0x0110, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_VSYNC__GPIO3_IO03                          = IOMUX_PAD(0x039C, 0x0110, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_VSYNC__ECSPI2_SS2                          = IOMUX_PAD(0x039C, 0x0110, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_RESET__LCDIF_RESET                         = IOMUX_PAD(0x03A0, 0x0114, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_RESET__LCDIF_CS                            = IOMUX_PAD(0x03A0, 0x0114, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_RESET__CA7_MX6UL_EVENTI                    = IOMUX_PAD(0x03A0, 0x0114, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_RESET__SAI3_TX_DATA                        = IOMUX_PAD(0x03A0, 0x0114, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_RESET__WDOG1_WDOG_ANY                      = IOMUX_PAD(0x03A0, 0x0114, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_RESET__GPIO3_IO04                          = IOMUX_PAD(0x03A0, 0x0114, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_RESET__ECSPI2_SS3                          = IOMUX_PAD(0x03A0, 0x0114, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA00__LCDIF_DATA00                       = IOMUX_PAD(0x03A4, 0x0118, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA00__PWM1_OUT                           = IOMUX_PAD(0x03A4, 0x0118, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA00__ENET1_1588_EVENT2_IN               = IOMUX_PAD(0x03A4, 0x0118, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA00__I2C3_SDA                           = IOMUX_PAD(0x03A4, 0x0118, IOMUX_CONFIG_SION | 4, 0x05B8, 2, 0),
	MX6_PAD_LCD_DATA00__GPIO3_IO05                         = IOMUX_PAD(0x03A4, 0x0118, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA00__SRC_BT_CFG00                       = IOMUX_PAD(0x03A4, 0x0118, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA00__SAI1_MCLK                          = IOMUX_PAD(0x03A4, 0x0118, 8, 0x05E0, 1, 0),

	MX6_PAD_LCD_DATA01__LCDIF_DATA01                       = IOMUX_PAD(0x03A8, 0x011C, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA01__PWM2_OUT                           = IOMUX_PAD(0x03A8, 0x011C, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA01__ENET1_1588_EVENT2_OUT              = IOMUX_PAD(0x03A8, 0x011C, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA01__I2C3_SCL                           = IOMUX_PAD(0x03A8, 0x011C, IOMUX_CONFIG_SION | 4, 0x05B4, 2, 0),
	MX6_PAD_LCD_DATA01__GPIO3_IO06                         = IOMUX_PAD(0x03A8, 0x011C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA01__SRC_BT_CFG01                       = IOMUX_PAD(0x03A8, 0x011C, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA01__SAI1_TX_SYNC                       = IOMUX_PAD(0x03A8, 0x011C, 8, 0x05EC, 0, 0),

	MX6_PAD_LCD_DATA02__LCDIF_DATA02                       = IOMUX_PAD(0x03AC, 0x0120, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA02__PWM3_OUT                           = IOMUX_PAD(0x03AC, 0x0120, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA02__ENET1_1588_EVENT3_IN               = IOMUX_PAD(0x03AC, 0x0120, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA02__I2C4_SDA                           = IOMUX_PAD(0x03AC, 0x0120, IOMUX_CONFIG_SION | 4, 0x05C0, 2, 0),
	MX6_PAD_LCD_DATA02__GPIO3_IO07                         = IOMUX_PAD(0x03AC, 0x0120, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA02__SRC_BT_CFG02                       = IOMUX_PAD(0x03AC, 0x0120, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA02__SAI1_TX_BCLK                       = IOMUX_PAD(0x03AC, 0x0120, 8, 0x05E8, 0, 0),

	MX6_PAD_LCD_DATA03__LCDIF_DATA03                       = IOMUX_PAD(0x03B0, 0x0124, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA03__PWM4_OUT                           = IOMUX_PAD(0x03B0, 0x0124, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA03__ENET1_1588_EVENT3_OUT              = IOMUX_PAD(0x03B0, 0x0124, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA03__I2C4_SCL                           = IOMUX_PAD(0x03B0, 0x0124, IOMUX_CONFIG_SION | 4, 0x05BC, 2, 0),
	MX6_PAD_LCD_DATA03__GPIO3_IO08                         = IOMUX_PAD(0x03B0, 0x0124, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA03__SRC_BT_CFG03                       = IOMUX_PAD(0x03B0, 0x0124, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA03__SAI1_RX_DATA                       = IOMUX_PAD(0x03B0, 0x0124, 8, 0x05E4, 0, 0),

	MX6_PAD_LCD_DATA04__LCDIF_DATA04                       = IOMUX_PAD(0x03B4, 0x0128, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA04__UART8_DCE_CTS                      = IOMUX_PAD(0x03B4, 0x0128, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA04__UART8_DTE_RTS                      = IOMUX_PAD(0x03B4, 0x0128, 1, 0x0658, 2, 0),
	MX6_PAD_LCD_DATA04__ENET2_1588_EVENT2_IN               = IOMUX_PAD(0x03B4, 0x0128, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA04__SPDIF_SR_CLK                       = IOMUX_PAD(0x03B4, 0x0128, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA04__GPIO3_IO09                         = IOMUX_PAD(0x03B4, 0x0128, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA04__SRC_BT_CFG04                       = IOMUX_PAD(0x03B4, 0x0128, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA04__SAI1_TX_DATA                       = IOMUX_PAD(0x03B4, 0x0128, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA05__LCDIF_DATA05                       = IOMUX_PAD(0x03B8, 0x012C, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA05__UART8_DCE_RTS                      = IOMUX_PAD(0x03B8, 0x012C, 1, 0x0658, 3, 0),
	MX6_PAD_LCD_DATA05__UART8_DTE_CTS                      = IOMUX_PAD(0x03B8, 0x012C, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA05__ENET2_1588_EVENT2_OUT              = IOMUX_PAD(0x03B8, 0x012C, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA05__SPDIF_OUT                          = IOMUX_PAD(0x03B8, 0x012C, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA05__GPIO3_IO10                         = IOMUX_PAD(0x03B8, 0x012C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA05__SRC_BT_CFG05                       = IOMUX_PAD(0x03B8, 0x012C, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA05__ECSPI1_SS1                         = IOMUX_PAD(0x03B8, 0x012C, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA06__LCDIF_DATA06                       = IOMUX_PAD(0x03BC, 0x0130, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA06__UART7_DCE_CTS                      = IOMUX_PAD(0x03BC, 0x0130, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA06__UART7_DTE_RTS                      = IOMUX_PAD(0x03BC, 0x0130, 1, 0x0650, 2, 0),
	MX6_PAD_LCD_DATA06__ENET2_1588_EVENT3_IN               = IOMUX_PAD(0x03BC, 0x0130, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA06__SPDIF_LOCK                         = IOMUX_PAD(0x03BC, 0x0130, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA06__GPIO3_IO11                         = IOMUX_PAD(0x03BC, 0x0130, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA06__SRC_BT_CFG06                       = IOMUX_PAD(0x03BC, 0x0130, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA06__ECSPI1_SS2                         = IOMUX_PAD(0x03BC, 0x0130, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA07__LCDIF_DATA07                       = IOMUX_PAD(0x03C0, 0x0134, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA07__UART7_DCE_RTS                      = IOMUX_PAD(0x03C0, 0x0134, 1, 0x0650, 3, 0),
	MX6_PAD_LCD_DATA07__UART7_DTE_CTS                      = IOMUX_PAD(0x03C0, 0x0134, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA07__ENET2_1588_EVENT3_OUT              = IOMUX_PAD(0x03C0, 0x0134, 3, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA07__SPDIF_EXT_CLK                      = IOMUX_PAD(0x03C0, 0x0134, 4, 0x061C, 0, 0),
	MX6_PAD_LCD_DATA07__GPIO3_IO12                         = IOMUX_PAD(0x03C0, 0x0134, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA07__SRC_BT_CFG07                       = IOMUX_PAD(0x03C0, 0x0134, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA07__ECSPI1_SS3                         = IOMUX_PAD(0x03C0, 0x0134, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA08__LCDIF_DATA08                       = IOMUX_PAD(0x03C4, 0x0138, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA08__SPDIF_IN                           = IOMUX_PAD(0x03C4, 0x0138, 1, 0x0618, 2, 0),
	MX6_PAD_LCD_DATA08__CSI_DATA16                         = IOMUX_PAD(0x03C4, 0x0138, 3, 0x0504, 1, 0),
	MX6_PAD_LCD_DATA08__EIM_DATA00                         = IOMUX_PAD(0x03C4, 0x0138, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA08__GPIO3_IO13                         = IOMUX_PAD(0x03C4, 0x0138, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA08__SRC_BT_CFG08                       = IOMUX_PAD(0x03C4, 0x0138, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA08__FLEXCAN1_TX                        = IOMUX_PAD(0x03C4, 0x0138, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA09__LCDIF_DATA09                       = IOMUX_PAD(0x03C8, 0x013C, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA09__SAI3_MCLK                          = IOMUX_PAD(0x03C8, 0x013C, 1, 0x0600, 1, 0),
	MX6_PAD_LCD_DATA09__CSI_DATA17                         = IOMUX_PAD(0x03C8, 0x013C, 3, 0x0508, 1, 0),
	MX6_PAD_LCD_DATA09__EIM_DATA01                         = IOMUX_PAD(0x03C8, 0x013C, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA09__GPIO3_IO14                         = IOMUX_PAD(0x03C8, 0x013C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA09__SRC_BT_CFG09                       = IOMUX_PAD(0x03C8, 0x013C, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA09__FLEXCAN1_RX                        = IOMUX_PAD(0x03C8, 0x013C, 8, 0x0584, 2, 0),

	MX6_PAD_LCD_DATA10__LCDIF_DATA10                       = IOMUX_PAD(0x03CC, 0x0140, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA10__SAI3_RX_SYNC                       = IOMUX_PAD(0x03CC, 0x0140, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA10__CSI_DATA18                         = IOMUX_PAD(0x03CC, 0x0140, 3, 0x050C, 1, 0),
	MX6_PAD_LCD_DATA10__EIM_DATA02                         = IOMUX_PAD(0x03CC, 0x0140, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA10__GPIO3_IO15                         = IOMUX_PAD(0x03CC, 0x0140, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA10__SRC_BT_CFG10                       = IOMUX_PAD(0x03CC, 0x0140, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA10__FLEXCAN2_TX                        = IOMUX_PAD(0x03CC, 0x0140, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA11__LCDIF_DATA11                       = IOMUX_PAD(0x03D0, 0x0144, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA11__SAI3_RX_BCLK                       = IOMUX_PAD(0x03D0, 0x0144, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA11__CSI_DATA19                         = IOMUX_PAD(0x03D0, 0x0144, 3, 0x0510, 1, 0),
	MX6_PAD_LCD_DATA11__EIM_DATA03                         = IOMUX_PAD(0x03D0, 0x0144, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA11__GPIO3_IO16                         = IOMUX_PAD(0x03D0, 0x0144, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA11__SRC_BT_CFG11                       = IOMUX_PAD(0x03D0, 0x0144, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA11__FLEXCAN2_RX                        = IOMUX_PAD(0x03D0, 0x0144, 8, 0x0588, 2, 0),

	MX6_PAD_LCD_DATA12__LCDIF_DATA12                       = IOMUX_PAD(0x03D4, 0x0148, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA12__SAI3_TX_SYNC                       = IOMUX_PAD(0x03D4, 0x0148, 1, 0x060C, 1, 0),
	MX6_PAD_LCD_DATA12__CSI_DATA20                         = IOMUX_PAD(0x03D4, 0x0148, 3, 0x0514, 1, 0),
	MX6_PAD_LCD_DATA12__EIM_DATA04                         = IOMUX_PAD(0x03D4, 0x0148, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA12__GPIO3_IO17                         = IOMUX_PAD(0x03D4, 0x0148, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA12__SRC_BT_CFG12                       = IOMUX_PAD(0x03D4, 0x0148, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA12__ECSPI1_RDY                         = IOMUX_PAD(0x03D4, 0x0148, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA13__LCDIF_DATA13                       = IOMUX_PAD(0x03D8, 0x014C, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA13__SAI3_TX_BCLK                       = IOMUX_PAD(0x03D8, 0x014C, 1, 0x0608, 1, 0),
	MX6_PAD_LCD_DATA13__CSI_DATA21                         = IOMUX_PAD(0x03D8, 0x014C, 3, 0x0518, 1, 0),
	MX6_PAD_LCD_DATA13__EIM_DATA05                         = IOMUX_PAD(0x03D8, 0x014C, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA13__GPIO3_IO18                         = IOMUX_PAD(0x03D8, 0x014C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA13__SRC_BT_CFG13                       = IOMUX_PAD(0x03D8, 0x014C, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA13__USDHC2_RESET_B                     = IOMUX_PAD(0x03D8, 0x014C, 8, 0x0000, 0, 0),

	MX6_PAD_LCD_DATA14__LCDIF_DATA14                       = IOMUX_PAD(0x03DC, 0x0150, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA14__SAI3_RX_DATA                       = IOMUX_PAD(0x03DC, 0x0150, 1, 0x0604, 1, 0),
	MX6_PAD_LCD_DATA14__CSI_DATA22                         = IOMUX_PAD(0x03DC, 0x0150, 3, 0x051C, 1, 0),
	MX6_PAD_LCD_DATA14__EIM_DATA06                         = IOMUX_PAD(0x03DC, 0x0150, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA14__GPIO3_IO19                         = IOMUX_PAD(0x03DC, 0x0150, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA14__SRC_BT_CFG14                       = IOMUX_PAD(0x03DC, 0x0150, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA14__USDHC2_DATA4                       = IOMUX_PAD(0x03DC, 0x0150, 8, 0x068C, 0, 0),

	MX6_PAD_LCD_DATA15__LCDIF_DATA15                       = IOMUX_PAD(0x03E0, 0x0154, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA15__SAI3_TX_DATA                       = IOMUX_PAD(0x03E0, 0x0154, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA15__CSI_DATA23                         = IOMUX_PAD(0x03E0, 0x0154, 3, 0x0520, 1, 0),
	MX6_PAD_LCD_DATA15__EIM_DATA07                         = IOMUX_PAD(0x03E0, 0x0154, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA15__GPIO3_IO20                         = IOMUX_PAD(0x03E0, 0x0154, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA15__SRC_BT_CFG15                       = IOMUX_PAD(0x03E0, 0x0154, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA15__USDHC2_DATA5                       = IOMUX_PAD(0x03E0, 0x0154, 8, 0x0690, 0, 0),

	MX6_PAD_LCD_DATA16__LCDIF_DATA16                       = IOMUX_PAD(0x03E4, 0x0158, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA16__UART7_DCE_TX                       = IOMUX_PAD(0x03E4, 0x0158, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA16__UART7_DTE_RX                       = IOMUX_PAD(0x03E4, 0x0158, 1, 0x0654, 2, 0),
	MX6_PAD_LCD_DATA16__CSI_DATA01                         = IOMUX_PAD(0x03E4, 0x0158, 3, 0x04D4, 1, 0),
	MX6_PAD_LCD_DATA16__EIM_DATA08                         = IOMUX_PAD(0x03E4, 0x0158, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA16__GPIO3_IO21                         = IOMUX_PAD(0x03E4, 0x0158, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA16__SRC_BT_CFG24                       = IOMUX_PAD(0x03E4, 0x0158, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA16__USDHC2_DATA6                       = IOMUX_PAD(0x03E4, 0x0158, 8, 0x0694, 0, 0),

	MX6_PAD_LCD_DATA17__LCDIF_DATA17                       = IOMUX_PAD(0x03E8, 0x015C, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA17__UART7_DCE_RX                       = IOMUX_PAD(0x03E8, 0x015C, 1, 0x0654, 3, 0),
	MX6_PAD_LCD_DATA17__UART7_DTE_TX                       = IOMUX_PAD(0x03E8, 0x015C, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA17__CSI_DATA00                         = IOMUX_PAD(0x03E8, 0x015C, 3, 0x04D0, 1, 0),
	MX6_PAD_LCD_DATA17__EIM_DATA09                         = IOMUX_PAD(0x03E8, 0x015C, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA17__GPIO3_IO22                         = IOMUX_PAD(0x03E8, 0x015C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA17__SRC_BT_CFG25                       = IOMUX_PAD(0x03E8, 0x015C, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA17__USDHC2_DATA7                       = IOMUX_PAD(0x03E8, 0x015C, 8, 0x0698, 0, 0),

	MX6_PAD_LCD_DATA18__LCDIF_DATA18                       = IOMUX_PAD(0x03EC, 0x0160, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA18__PWM5_OUT                           = IOMUX_PAD(0x03EC, 0x0160, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA18__CA7_MX6UL_EVENTO                   = IOMUX_PAD(0x03EC, 0x0160, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA18__CSI_DATA10                         = IOMUX_PAD(0x03EC, 0x0160, 3, 0x04EC, 1, 0),
	MX6_PAD_LCD_DATA18__EIM_DATA10                         = IOMUX_PAD(0x03EC, 0x0160, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA18__GPIO3_IO23                         = IOMUX_PAD(0x03EC, 0x0160, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA18__SRC_BT_CFG26                       = IOMUX_PAD(0x03EC, 0x0160, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA18__USDHC2_CMD                         = IOMUX_PAD(0x03EC, 0x0160, 8, 0x0678, 1, 0),
	MX6_PAD_LCD_DATA19__EIM_DATA11                         = IOMUX_PAD(0x03F0, 0x0164, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA19__GPIO3_IO24                         = IOMUX_PAD(0x03F0, 0x0164, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA19__SRC_BT_CFG27                       = IOMUX_PAD(0x03F0, 0x0164, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA19__USDHC2_CLK                         = IOMUX_PAD(0x03F0, 0x0164, 8, 0x0670, 1, 0),

	MX6_PAD_LCD_DATA19__LCDIF_DATA19                       = IOMUX_PAD(0x03F0, 0x0164, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA19__PWM6_OUT                           = IOMUX_PAD(0x03F0, 0x0164, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA19__WDOG1_WDOG_ANY                     = IOMUX_PAD(0x03F0, 0x0164, 2, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA19__CSI_DATA11                         = IOMUX_PAD(0x03F0, 0x0164, 3, 0x04F0, 1, 0),
	MX6_PAD_LCD_DATA20__EIM_DATA12                         = IOMUX_PAD(0x03F4, 0x0168, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA20__GPIO3_IO25                         = IOMUX_PAD(0x03F4, 0x0168, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA20__SRC_BT_CFG28                       = IOMUX_PAD(0x03F4, 0x0168, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA20__USDHC2_DATA0                       = IOMUX_PAD(0x03F4, 0x0168, 8, 0x067C, 1, 0),

	MX6_PAD_LCD_DATA20__LCDIF_DATA20                       = IOMUX_PAD(0x03F4, 0x0168, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA20__UART8_DCE_TX                       = IOMUX_PAD(0x03F4, 0x0168, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA20__UART8_DTE_RX                       = IOMUX_PAD(0x03F4, 0x0168, 1, 0x065C, 2, 0),
	MX6_PAD_LCD_DATA20__ECSPI1_SCLK                        = IOMUX_PAD(0x03F4, 0x0168, 2, 0x0534, 0, 0),
	MX6_PAD_LCD_DATA20__CSI_DATA12                         = IOMUX_PAD(0x03F4, 0x0168, 3, 0x04F4, 1, 0),

	MX6_PAD_LCD_DATA21__LCDIF_DATA21                       = IOMUX_PAD(0x03F8, 0x016C, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA21__UART8_DCE_RX                       = IOMUX_PAD(0x03F8, 0x016C, 1, 0x065C, 3, 0),
	MX6_PAD_LCD_DATA21__UART8_DTE_TX                       = IOMUX_PAD(0x03F8, 0x016C, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA21__ECSPI1_SS0                         = IOMUX_PAD(0x03F8, 0x016C, 2, 0x0540, 0, 0),
	MX6_PAD_LCD_DATA21__CSI_DATA13                         = IOMUX_PAD(0x03F8, 0x016C, 3, 0x04F8, 1, 0),
	MX6_PAD_LCD_DATA21__EIM_DATA13                         = IOMUX_PAD(0x03F8, 0x016C, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA21__GPIO3_IO26                         = IOMUX_PAD(0x03F8, 0x016C, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA21__SRC_BT_CFG29                       = IOMUX_PAD(0x03F8, 0x016C, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA21__USDHC2_DATA1                       = IOMUX_PAD(0x03F8, 0x016C, 8, 0x0680, 1, 0),

	MX6_PAD_LCD_DATA22__LCDIF_DATA22                       = IOMUX_PAD(0x03FC, 0x0170, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA22__MQS_RIGHT                          = IOMUX_PAD(0x03FC, 0x0170, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA22__ECSPI1_MOSI                        = IOMUX_PAD(0x03FC, 0x0170, 2, 0x053C, 0, 0),
	MX6_PAD_LCD_DATA22__CSI_DATA14                         = IOMUX_PAD(0x03FC, 0x0170, 3, 0x04FC, 1, 0),
	MX6_PAD_LCD_DATA22__EIM_DATA14                         = IOMUX_PAD(0x03FC, 0x0170, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA22__GPIO3_IO27                         = IOMUX_PAD(0x03FC, 0x0170, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA22__SRC_BT_CFG30                       = IOMUX_PAD(0x03FC, 0x0170, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA22__USDHC2_DATA2                       = IOMUX_PAD(0x03FC, 0x0170, 8, 0x0684, 0, 0),

	MX6_PAD_LCD_DATA23__LCDIF_DATA23                       = IOMUX_PAD(0x0400, 0x0174, 0, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA23__MQS_LEFT                           = IOMUX_PAD(0x0400, 0x0174, 1, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA23__ECSPI1_MISO                        = IOMUX_PAD(0x0400, 0x0174, 2, 0x0538, 0, 0),
	MX6_PAD_LCD_DATA23__CSI_DATA15                         = IOMUX_PAD(0x0400, 0x0174, 3, 0x0500, 1, 0),
	MX6_PAD_LCD_DATA23__EIM_DATA15                         = IOMUX_PAD(0x0400, 0x0174, 4, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA23__GPIO3_IO28                         = IOMUX_PAD(0x0400, 0x0174, 5, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA23__SRC_BT_CFG31                       = IOMUX_PAD(0x0400, 0x0174, 6, 0x0000, 0, 0),
	MX6_PAD_LCD_DATA23__USDHC2_DATA3                       = IOMUX_PAD(0x0400, 0x0174, 8, 0x0688, 1, 0),

	MX6_PAD_NAND_RE_B__RAWNAND_RE_B                        = IOMUX_PAD(0x0404, 0x0178, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_RE_B__USDHC2_CLK                          = IOMUX_PAD(0x0404, 0x0178, 1, 0x0670, 2, 0),
	MX6_PAD_NAND_RE_B__QSPI_B_SCLK                         = IOMUX_PAD(0x0404, 0x0178, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_RE_B__KPP_ROW00                           = IOMUX_PAD(0x0404, 0x0178, 3, 0x05D0, 1, 0),
	MX6_PAD_NAND_RE_B__EIM_EB_B00                          = IOMUX_PAD(0x0404, 0x0178, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_RE_B__GPIO4_IO00                          = IOMUX_PAD(0x0404, 0x0178, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_RE_B__ECSPI3_SS2                          = IOMUX_PAD(0x0404, 0x0178, 8, 0x0000, 0, 0),

	MX6_PAD_NAND_WE_B__RAWNAND_WE_B                        = IOMUX_PAD(0x0408, 0x017C, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_WE_B__USDHC2_CMD                          = IOMUX_PAD(0x0408, 0x017C, 1, 0x0678, 2, 0),
	MX6_PAD_NAND_WE_B__QSPI_B_SS0_B                        = IOMUX_PAD(0x0408, 0x017C, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_WE_B__KPP_COL00                           = IOMUX_PAD(0x0408, 0x017C, 3, 0x05C4, 1, 0),
	MX6_PAD_NAND_WE_B__EIM_EB_B01                          = IOMUX_PAD(0x0408, 0x017C, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_WE_B__GPIO4_IO01                          = IOMUX_PAD(0x0408, 0x017C, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_WE_B__ECSPI3_SS3                          = IOMUX_PAD(0x0408, 0x017C, 8, 0x0000, 0, 0),

	MX6_PAD_NAND_DATA00__RAWNAND_DATA00                    = IOMUX_PAD(0x040C, 0x0180, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA00__USDHC2_DATA0                      = IOMUX_PAD(0x040C, 0x0180, 1, 0x067C, 2, 0),
	MX6_PAD_NAND_DATA00__QSPI_B_SS1_B                      = IOMUX_PAD(0x040C, 0x0180, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA00__KPP_ROW01                         = IOMUX_PAD(0x040C, 0x0180, 3, 0x05D4, 1, 0),
	MX6_PAD_NAND_DATA00__EIM_AD08                          = IOMUX_PAD(0x040C, 0x0180, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA00__GPIO4_IO02                        = IOMUX_PAD(0x040C, 0x0180, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA00__ECSPI4_RDY                        = IOMUX_PAD(0x040C, 0x0180, 8, 0x0000, 0, 0),

	MX6_PAD_NAND_DATA01__RAWNAND_DATA01                    = IOMUX_PAD(0x0410, 0x0184, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA01__USDHC2_DATA1                      = IOMUX_PAD(0x0410, 0x0184, 1, 0x0680, 2, 0),
	MX6_PAD_NAND_DATA01__QSPI_B_DQS                        = IOMUX_PAD(0x0410, 0x0184, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA01__KPP_COL01                         = IOMUX_PAD(0x0410, 0x0184, 3, 0x05C8, 1, 0),
	MX6_PAD_NAND_DATA01__EIM_AD09                          = IOMUX_PAD(0x0410, 0x0184, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA01__GPIO4_IO03                        = IOMUX_PAD(0x0410, 0x0184, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA01__ECSPI4_SS1                        = IOMUX_PAD(0x0410, 0x0184, 8, 0x0000, 0, 0),

	MX6_PAD_NAND_DATA02__RAWNAND_DATA02                    = IOMUX_PAD(0x0414, 0x0188, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA02__USDHC2_DATA2                      = IOMUX_PAD(0x0414, 0x0188, 1, 0x0684, 1, 0),
	MX6_PAD_NAND_DATA02__QSPI_B_DATA00                     = IOMUX_PAD(0x0414, 0x0188, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA02__KPP_ROW02                         = IOMUX_PAD(0x0414, 0x0188, 3, 0x05D8, 1, 0),
	MX6_PAD_NAND_DATA02__EIM_AD10                          = IOMUX_PAD(0x0414, 0x0188, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA02__GPIO4_IO04                        = IOMUX_PAD(0x0414, 0x0188, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA02__ECSPI4_SS2                        = IOMUX_PAD(0x0414, 0x0188, 8, 0x0000, 0, 0),

	MX6_PAD_NAND_DATA03__RAWNAND_DATA03                    = IOMUX_PAD(0x0418, 0x018C, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA03__USDHC2_DATA3                      = IOMUX_PAD(0x0418, 0x018C, 1, 0x0688, 2, 0),
	MX6_PAD_NAND_DATA03__QSPI_B_DATA01                     = IOMUX_PAD(0x0418, 0x018C, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA03__KPP_COL02                         = IOMUX_PAD(0x0418, 0x018C, 3, 0x05CC, 1, 0),
	MX6_PAD_NAND_DATA03__EIM_AD11                          = IOMUX_PAD(0x0418, 0x018C, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA03__GPIO4_IO05                        = IOMUX_PAD(0x0418, 0x018C, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA03__ECSPI4_SS3                        = IOMUX_PAD(0x0418, 0x018C, 8, 0x0000, 0, 0),

	MX6_PAD_NAND_DATA04__RAWNAND_DATA04                    = IOMUX_PAD(0x041C, 0x0190, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA04__USDHC2_DATA4                      = IOMUX_PAD(0x041C, 0x0190, 1, 0x068C, 1, 0),
	MX6_PAD_NAND_DATA04__QSPI_B_DATA02                     = IOMUX_PAD(0x041C, 0x0190, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA04__ECSPI4_SCLK                       = IOMUX_PAD(0x041C, 0x0190, 3, 0x0564, 1, 0),
	MX6_PAD_NAND_DATA04__EIM_AD12                          = IOMUX_PAD(0x041C, 0x0190, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA04__GPIO4_IO06                        = IOMUX_PAD(0x041C, 0x0190, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA04__UART2_DCE_TX                      = IOMUX_PAD(0x041C, 0x0190, 8, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA04__UART2_DTE_RX                      = IOMUX_PAD(0x041C, 0x0190, 8, 0x062C, 2, 0),

	MX6_PAD_NAND_DATA05__RAWNAND_DATA05                    = IOMUX_PAD(0x0420, 0x0194, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA05__USDHC2_DATA5                      = IOMUX_PAD(0x0420, 0x0194, 1, 0x0690, 1, 0),
	MX6_PAD_NAND_DATA05__QSPI_B_DATA03                     = IOMUX_PAD(0x0420, 0x0194, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA05__ECSPI4_MOSI                       = IOMUX_PAD(0x0420, 0x0194, 3, 0x056C, 1, 0),
	MX6_PAD_NAND_DATA05__EIM_AD13                          = IOMUX_PAD(0x0420, 0x0194, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA05__GPIO4_IO07                        = IOMUX_PAD(0x0420, 0x0194, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA05__UART2_DCE_RX                      = IOMUX_PAD(0x0420, 0x0194, 8, 0x062C, 3, 0),
	MX6_PAD_NAND_DATA05__UART2_DTE_TX                      = IOMUX_PAD(0x0420, 0x0194, 8, 0x0000, 0, 0),

	MX6_PAD_NAND_DATA06__RAWNAND_DATA06                    = IOMUX_PAD(0x0424, 0x0198, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA06__USDHC2_DATA6                      = IOMUX_PAD(0x0424, 0x0198, 1, 0x0694, 1, 0),
	MX6_PAD_NAND_DATA06__SAI2_RX_BCLK                      = IOMUX_PAD(0x0424, 0x0198, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA06__ECSPI4_MISO                       = IOMUX_PAD(0x0424, 0x0198, 3, 0x0568, 1, 0),
	MX6_PAD_NAND_DATA06__EIM_AD14                          = IOMUX_PAD(0x0424, 0x0198, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA06__GPIO4_IO08                        = IOMUX_PAD(0x0424, 0x0198, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA06__UART2_DCE_CTS                     = IOMUX_PAD(0x0424, 0x0198, 8, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA06__UART2_DTE_RTS                     = IOMUX_PAD(0x0424, 0x0198, 8, 0x0628, 4, 0),

	MX6_PAD_NAND_DATA07__RAWNAND_DATA07                    = IOMUX_PAD(0x0428, 0x019C, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA07__USDHC2_DATA7                      = IOMUX_PAD(0x0428, 0x019C, 1, 0x0698, 1, 0),
	MX6_PAD_NAND_DATA07__QSPI_A_SS1_B                      = IOMUX_PAD(0x0428, 0x019C, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA07__ECSPI4_SS0                        = IOMUX_PAD(0x0428, 0x019C, 3, 0x0570, 1, 0),
	MX6_PAD_NAND_DATA07__EIM_AD15                          = IOMUX_PAD(0x0428, 0x019C, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA07__GPIO4_IO09                        = IOMUX_PAD(0x0428, 0x019C, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_DATA07__UART2_DCE_RTS                     = IOMUX_PAD(0x0428, 0x019C, 8, 0x0628, 5, 0),
	MX6_PAD_NAND_DATA07__UART2_DTE_CTS                     = IOMUX_PAD(0x0428, 0x019C, 8, 0x0000, 0, 0),

	MX6_PAD_NAND_ALE__RAWNAND_ALE                          = IOMUX_PAD(0x042C, 0x01A0, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_ALE__USDHC2_RESET_B                       = IOMUX_PAD(0x042C, 0x01A0, 1, 0x0000, 0, 0),
	MX6_PAD_NAND_ALE__QSPI_A_DQS                           = IOMUX_PAD(0x042C, 0x01A0, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_ALE__PWM3_OUT                             = IOMUX_PAD(0x042C, 0x01A0, 3, 0x0000, 0, 0),
	MX6_PAD_NAND_ALE__EIM_ADDR17                           = IOMUX_PAD(0x042C, 0x01A0, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_ALE__GPIO4_IO10                           = IOMUX_PAD(0x042C, 0x01A0, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_ALE__ECSPI3_SS1                           = IOMUX_PAD(0x042C, 0x01A0, 8, 0x0000, 0, 0),

	MX6_PAD_NAND_WP_B__RAWNAND_WP_B                        = IOMUX_PAD(0x0430, 0x01A4, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_WP_B__USDHC1_RESET_B                      = IOMUX_PAD(0x0430, 0x01A4, 1, 0x0000, 0, 0),
	MX6_PAD_NAND_WP_B__QSPI_A_SCLK                         = IOMUX_PAD(0x0430, 0x01A4, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_WP_B__PWM4_OUT                            = IOMUX_PAD(0x0430, 0x01A4, 3, 0x0000, 0, 0),
	MX6_PAD_NAND_WP_B__EIM_BCLK                            = IOMUX_PAD(0x0430, 0x01A4, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_WP_B__GPIO4_IO11                          = IOMUX_PAD(0x0430, 0x01A4, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_WP_B__ECSPI3_RDY                          = IOMUX_PAD(0x0430, 0x01A4, 8, 0x0000, 0, 0),

	MX6_PAD_NAND_READY_B__RAWNAND_READY_B                  = IOMUX_PAD(0x0434, 0x01A8, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_READY_B__USDHC1_DATA4                     = IOMUX_PAD(0x0434, 0x01A8, 1, 0x0000, 0, 0),
	MX6_PAD_NAND_READY_B__QSPI_A_DATA00                    = IOMUX_PAD(0x0434, 0x01A8, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_READY_B__ECSPI3_SS0                       = IOMUX_PAD(0x0434, 0x01A8, 3, 0x0560, 1, 0),
	MX6_PAD_NAND_READY_B__EIM_CS1_B                        = IOMUX_PAD(0x0434, 0x01A8, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_READY_B__GPIO4_IO12                       = IOMUX_PAD(0x0434, 0x01A8, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_READY_B__UART3_DCE_TX                     = IOMUX_PAD(0x0434, 0x01A8, 8, 0x0000, 0, 0),
	MX6_PAD_NAND_READY_B__UART3_DTE_RX                     = IOMUX_PAD(0x0434, 0x01A8, 8, 0x0634, 2, 0),

	MX6_PAD_NAND_CE0_B__RAWNAND_CE0_B                      = IOMUX_PAD(0x0438, 0x01AC, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_CE0_B__USDHC1_DATA5                       = IOMUX_PAD(0x0438, 0x01AC, 1, 0x0000, 0, 0),
	MX6_PAD_NAND_CE0_B__QSPI_A_DATA01                      = IOMUX_PAD(0x0438, 0x01AC, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_CE0_B__ECSPI3_SCLK                        = IOMUX_PAD(0x0438, 0x01AC, 3, 0x0554, 1, 0),
	MX6_PAD_NAND_CE0_B__EIM_DTACK_B                        = IOMUX_PAD(0x0438, 0x01AC, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_CE0_B__GPIO4_IO13                         = IOMUX_PAD(0x0438, 0x01AC, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_CE0_B__UART3_DCE_RX                       = IOMUX_PAD(0x0438, 0x01AC, 8, 0x0634, 3, 0),
	MX6_PAD_NAND_CE0_B__UART3_DTE_TX                       = IOMUX_PAD(0x0438, 0x01AC, 8, 0x0000, 0, 0),

	MX6_PAD_NAND_CE1_B__RAWNAND_CE1_B                      = IOMUX_PAD(0x043C, 0x01B0, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_CE1_B__USDHC1_DATA6                       = IOMUX_PAD(0x043C, 0x01B0, 1, 0x0000, 0, 0),
	MX6_PAD_NAND_CE1_B__QSPI_A_DATA02                      = IOMUX_PAD(0x043C, 0x01B0, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_CE1_B__ECSPI3_MOSI                        = IOMUX_PAD(0x043C, 0x01B0, 3, 0x055C, 1, 0),
	MX6_PAD_NAND_CE1_B__EIM_ADDR18                         = IOMUX_PAD(0x043C, 0x01B0, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_CE1_B__GPIO4_IO14                         = IOMUX_PAD(0x043C, 0x01B0, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_CE1_B__UART3_DCE_CTS                      = IOMUX_PAD(0x043C, 0x01B0, 8, 0x0000, 0, 0),
	MX6_PAD_NAND_CE1_B__UART3_DTE_RTS                      = IOMUX_PAD(0x043C, 0x01B0, 8, 0x0630, 2, 0),

	MX6_PAD_NAND_CLE__RAWNAND_CLE                          = IOMUX_PAD(0x0440, 0x01B4, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_CLE__USDHC1_DATA7                         = IOMUX_PAD(0x0440, 0x01B4, 1, 0x0000, 0, 0),
	MX6_PAD_NAND_CLE__QSPI_A_DATA03                        = IOMUX_PAD(0x0440, 0x01B4, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_CLE__ECSPI3_MISO                          = IOMUX_PAD(0x0440, 0x01B4, 3, 0x0558, 1, 0),
	MX6_PAD_NAND_CLE__EIM_ADDR16                           = IOMUX_PAD(0x0440, 0x01B4, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_CLE__GPIO4_IO15                           = IOMUX_PAD(0x0440, 0x01B4, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_CLE__UART3_DCE_RTS                        = IOMUX_PAD(0x0440, 0x01B4, 8, 0x0630, 3, 0),
	MX6_PAD_NAND_CLE__UART3_DTE_CTS                        = IOMUX_PAD(0x0440, 0x01B4, 8, 0x0000, 0, 0),

	MX6_PAD_NAND_DQS__RAWNAND_DQS                          = IOMUX_PAD(0x0444, 0x01B8, 0, 0x0000, 0, 0),
	MX6_PAD_NAND_DQS__CSI_FIELD                            = IOMUX_PAD(0x0444, 0x01B8, 1, 0x0530, 1, 0),
	MX6_PAD_NAND_DQS__QSPI_A_SS0_B                         = IOMUX_PAD(0x0444, 0x01B8, 2, 0x0000, 0, 0),
	MX6_PAD_NAND_DQS__PWM5_OUT                             = IOMUX_PAD(0x0444, 0x01B8, 3, 0x0000, 0, 0),
	MX6_PAD_NAND_DQS__EIM_WAIT                             = IOMUX_PAD(0x0444, 0x01B8, 4, 0x0000, 0, 0),
	MX6_PAD_NAND_DQS__GPIO4_IO16                           = IOMUX_PAD(0x0444, 0x01B8, 5, 0x0000, 0, 0),
	MX6_PAD_NAND_DQS__SDMA_EXT_EVENT01                     = IOMUX_PAD(0x0444, 0x01B8, 6, 0x0614, 1, 0),
	MX6_PAD_NAND_DQS__SPDIF_EXT_CLK                        = IOMUX_PAD(0x0444, 0x01B8, 8, 0x061C, 1, 0),

	MX6_PAD_SD1_CMD__USDHC1_CMD                            = IOMUX_PAD(0x0448, 0x01BC, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_CMD__GPT2_COMPARE1                         = IOMUX_PAD(0x0448, 0x01BC, 1, 0x0000, 0, 0),
	MX6_PAD_SD1_CMD__SAI2_RX_SYNC                          = IOMUX_PAD(0x0448, 0x01BC, 2, 0x0000, 0, 0),
	MX6_PAD_SD1_CMD__SPDIF_OUT                             = IOMUX_PAD(0x0448, 0x01BC, 3, 0x0000, 0, 0),
	MX6_PAD_SD1_CMD__EIM_ADDR19                            = IOMUX_PAD(0x0448, 0x01BC, 4, 0x0000, 0, 0),
	MX6_PAD_SD1_CMD__GPIO2_IO16                            = IOMUX_PAD(0x0448, 0x01BC, 5, 0x0000, 0, 0),
	MX6_PAD_SD1_CMD__SDMA_EXT_EVENT00                      = IOMUX_PAD(0x0448, 0x01BC, 6, 0x0610, 2, 0),
	MX6_PAD_SD1_CMD__USB_OTG1_PWR                          = IOMUX_PAD(0x0448, 0x01BC, 8, 0x0000, 0, 0),

	MX6_PAD_SD1_CLK__USDHC1_CLK                            = IOMUX_PAD(0x044C, 0x01C0, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_CLK__GPT2_COMPARE2                         = IOMUX_PAD(0x044C, 0x01C0, 1, 0x0000, 0, 0),
	MX6_PAD_SD1_CLK__SAI2_MCLK                             = IOMUX_PAD(0x044C, 0x01C0, 2, 0x05F0, 1, 0),
	MX6_PAD_SD1_CLK__SPDIF_IN                              = IOMUX_PAD(0x044C, 0x01C0, 3, 0x0618, 3, 0),
	MX6_PAD_SD1_CLK__EIM_ADDR20                            = IOMUX_PAD(0x044C, 0x01C0, 4, 0x0000, 0, 0),
	MX6_PAD_SD1_CLK__GPIO2_IO17                            = IOMUX_PAD(0x044C, 0x01C0, 5, 0x0000, 0, 0),
	MX6_PAD_SD1_CLK__USB_OTG1_OC                           = IOMUX_PAD(0x044C, 0x01C0, 8, 0x0664, 2, 0),

	MX6_PAD_SD1_DATA0__USDHC1_DATA0                        = IOMUX_PAD(0x0450, 0x01C4, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA0__GPT2_COMPARE3                       = IOMUX_PAD(0x0450, 0x01C4, 1, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA0__SAI2_TX_SYNC                        = IOMUX_PAD(0x0450, 0x01C4, 2, 0x05FC, 1, 0),
	MX6_PAD_SD1_DATA0__FLEXCAN1_TX                         = IOMUX_PAD(0x0450, 0x01C4, 3, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA0__EIM_ADDR21                          = IOMUX_PAD(0x0450, 0x01C4, 4, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA0__GPIO2_IO18                          = IOMUX_PAD(0x0450, 0x01C4, 5, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA0__ANATOP_OTG1_ID                      = IOMUX_PAD(0x0450, 0x01C4, 8, 0x04B8, 2, 0),

	MX6_PAD_SD1_DATA1__USDHC1_DATA1                        = IOMUX_PAD(0x0454, 0x01C8, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA1__GPT2_CLK                            = IOMUX_PAD(0x0454, 0x01C8, 1, 0x05A0, 1, 0),
	MX6_PAD_SD1_DATA1__SAI2_TX_BCLK                        = IOMUX_PAD(0x0454, 0x01C8, 2, 0x05F8, 1, 0),
	MX6_PAD_SD1_DATA1__FLEXCAN1_RX                         = IOMUX_PAD(0x0454, 0x01C8, 3, 0x0584, 3, 0),
	MX6_PAD_SD1_DATA1__EIM_ADDR22                          = IOMUX_PAD(0x0454, 0x01C8, 4, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA1__GPIO2_IO19                          = IOMUX_PAD(0x0454, 0x01C8, 5, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA1__USB_OTG2_PWR                        = IOMUX_PAD(0x0454, 0x01C8, 8, 0x0000, 0, 0),

	MX6_PAD_SD1_DATA2__USDHC1_DATA2                        = IOMUX_PAD(0x0458, 0x01CC, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA2__GPT2_CAPTURE1                       = IOMUX_PAD(0x0458, 0x01CC, 1, 0x0598, 1, 0),
	MX6_PAD_SD1_DATA2__SAI2_RX_DATA                        = IOMUX_PAD(0x0458, 0x01CC, 2, 0x05F4, 1, 0),
	MX6_PAD_SD1_DATA2__FLEXCAN2_TX                         = IOMUX_PAD(0x0458, 0x01CC, 3, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA2__EIM_ADDR23                          = IOMUX_PAD(0x0458, 0x01CC, 4, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA2__GPIO2_IO20                          = IOMUX_PAD(0x0458, 0x01CC, 5, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA2__CCM_CLKO1                           = IOMUX_PAD(0x0458, 0x01CC, 6, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA2__USB_OTG2_OC                         = IOMUX_PAD(0x0458, 0x01CC, 8, 0x0660, 2, 0),

	MX6_PAD_SD1_DATA3__USDHC1_DATA3                        = IOMUX_PAD(0x045C, 0x01D0, 0, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA3__GPT2_CAPTURE2                       = IOMUX_PAD(0x045C, 0x01D0, 1, 0x059C, 1, 0),
	MX6_PAD_SD1_DATA3__SAI2_TX_DATA                        = IOMUX_PAD(0x045C, 0x01D0, 2, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA3__FLEXCAN2_RX                         = IOMUX_PAD(0x045C, 0x01D0, 3, 0x0588, 3, 0),
	MX6_PAD_SD1_DATA3__EIM_ADDR24                          = IOMUX_PAD(0x045C, 0x01D0, 4, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA3__GPIO2_IO21                          = IOMUX_PAD(0x045C, 0x01D0, 5, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA3__CCM_CLKO2                           = IOMUX_PAD(0x045C, 0x01D0, 6, 0x0000, 0, 0),
	MX6_PAD_SD1_DATA3__ANATOP_OTG2_ID                      = IOMUX_PAD(0x045C, 0x01D0, 8, 0x04BC, 2, 0),

	MX6_PAD_CSI_MCLK__CSI_MCLK                             = IOMUX_PAD(0x0460, 0x01D4, 0, 0x0000, 0, 0),
	MX6_PAD_CSI_MCLK__USDHC2_CD_B                          = IOMUX_PAD(0x0460, 0x01D4, 1, 0x0674, 0, 0),
	MX6_PAD_CSI_MCLK__RAWNAND_CE2_B                        = IOMUX_PAD(0x0460, 0x01D4, 2, 0x0000, 0, 0),
	MX6_PAD_CSI_MCLK__I2C1_SDA                             = IOMUX_PAD(0x0460, 0x01D4, IOMUX_CONFIG_SION | 3, 0x05A8, 0, 0),
	MX6_PAD_CSI_MCLK__EIM_CS0_B                            = IOMUX_PAD(0x0460, 0x01D4, 4, 0x0000, 0, 0),
	MX6_PAD_CSI_MCLK__GPIO4_IO17                           = IOMUX_PAD(0x0460, 0x01D4, 5, 0x0000, 0, 0),
	MX6_PAD_CSI_MCLK__SNVS_HP_VIO_5_CTL                    = IOMUX_PAD(0x0460, 0x01D4, 6, 0x0000, 0, 0),
	MX6_PAD_CSI_MCLK__UART6_DCE_TX                         = IOMUX_PAD(0x0460, 0x01D4, 8, 0x0000, 0, 0),
	MX6_PAD_CSI_MCLK__UART6_DTE_RX                         = IOMUX_PAD(0x0460, 0x01D4, 8, 0x064C, 0, 0),

	MX6_PAD_CSI_PIXCLK__CSI_PIXCLK                         = IOMUX_PAD(0x0464, 0x01D8, 0, 0x0528, 1, 0),
	MX6_PAD_CSI_PIXCLK__USDHC2_WP                          = IOMUX_PAD(0x0464, 0x01D8, 1, 0x069C, 2, 0),
	MX6_PAD_CSI_PIXCLK__RAWNAND_CE3_B                      = IOMUX_PAD(0x0464, 0x01D8, 2, 0x0000, 0, 0),
	MX6_PAD_CSI_PIXCLK__I2C1_SCL                           = IOMUX_PAD(0x0464, 0x01D8, IOMUX_CONFIG_SION | 3, 0x05A4, 2, 0),
	MX6_PAD_CSI_PIXCLK__EIM_OE                             = IOMUX_PAD(0x0464, 0x01D8, 4, 0x0000, 0, 0),
	MX6_PAD_CSI_PIXCLK__GPIO4_IO18                         = IOMUX_PAD(0x0464, 0x01D8, 5, 0x0000, 0, 0),
	MX6_PAD_CSI_PIXCLK__SNVS_HP_VIO_5                      = IOMUX_PAD(0x0464, 0x01D8, 6, 0x0000, 0, 0),
	MX6_PAD_CSI_PIXCLK__UART6_DCE_RX                       = IOMUX_PAD(0x0464, 0x01D8, 8, 0x064C, 3, 0),
	MX6_PAD_CSI_PIXCLK__UART6_DTE_TX                       = IOMUX_PAD(0x0464, 0x01D8, 8, 0x0000, 0, 0),

	MX6_PAD_CSI_VSYNC__CSI_VSYNC                           = IOMUX_PAD(0x0468, 0x01DC, 0, 0x052C, 0, 0),
	MX6_PAD_CSI_VSYNC__USDHC2_CLK                          = IOMUX_PAD(0x0468, 0x01DC, 1, 0x0670, 0, 0),
	MX6_PAD_CSI_VSYNC__SIM1_PORT1_CLK                      = IOMUX_PAD(0x0468, 0x01DC, 2, 0x0000, 0, 0),
	MX6_PAD_CSI_VSYNC__I2C2_SDA                            = IOMUX_PAD(0x0468, 0x01DC, IOMUX_CONFIG_SION | 3, 0x05B0, 0, 0),
	MX6_PAD_CSI_VSYNC__EIM_RW                              = IOMUX_PAD(0x0468, 0x01DC, 4, 0x0000, 0, 0),
	MX6_PAD_CSI_VSYNC__GPIO4_IO19                          = IOMUX_PAD(0x0468, 0x01DC, 5, 0x0000, 0, 0),
	MX6_PAD_CSI_VSYNC__PWM7_OUT                            = IOMUX_PAD(0x0468, 0x01DC, 6, 0x0000, 0, 0),
	MX6_PAD_CSI_VSYNC__UART6_DCE_RTS                       = IOMUX_PAD(0x0468, 0x01DC, 8, 0x0648, 0, 0),
	MX6_PAD_CSI_VSYNC__UART6_DTE_CTS                       = IOMUX_PAD(0x0468, 0x01DC, 8, 0x0000, 0, 0),

	MX6_PAD_CSI_HSYNC__CSI_HSYNC                           = IOMUX_PAD(0x046C, 0x01E0, 0, 0x0524, 0, 0),
	MX6_PAD_CSI_HSYNC__USDHC2_CMD                          = IOMUX_PAD(0x046C, 0x01E0, 1, 0x0678, 0, 0),
	MX6_PAD_CSI_HSYNC__SIM1_PORT1_PD                       = IOMUX_PAD(0x046C, 0x01E0, 2, 0x0000, 0, 0),
	MX6_PAD_CSI_HSYNC__I2C2_SCL                            = IOMUX_PAD(0x046C, 0x01E0, IOMUX_CONFIG_SION | 3, 0x05AC, 0, 0),
	MX6_PAD_CSI_HSYNC__EIM_LBA_B                           = IOMUX_PAD(0x046C, 0x01E0, 4, 0x0000, 0, 0),
	MX6_PAD_CSI_HSYNC__GPIO4_IO20                          = IOMUX_PAD(0x046C, 0x01E0, 5, 0x0000, 0, 0),
	MX6_PAD_CSI_HSYNC__PWM8_OUT                            = IOMUX_PAD(0x046C, 0x01E0, 6, 0x0000, 0, 0),
	MX6_PAD_CSI_HSYNC__UART6_DCE_CTS                       = IOMUX_PAD(0x046C, 0x01E0, 8, 0x0000, 0, 0),
	MX6_PAD_CSI_HSYNC__UART6_DTE_RTS                       = IOMUX_PAD(0x046C, 0x01E0, 8, 0x0648, 1, 0),

	MX6_PAD_CSI_DATA00__CSI_DATA02                         = IOMUX_PAD(0x0470, 0x01E4, 0, 0x04C4, 0, 0),
	MX6_PAD_CSI_DATA00__USDHC2_DATA0                       = IOMUX_PAD(0x0470, 0x01E4, 1, 0x067C, 0, 0),
	MX6_PAD_CSI_DATA00__SIM1_PORT1_RST_B                   = IOMUX_PAD(0x0470, 0x01E4, 2, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA00__ECSPI2_SCLK                        = IOMUX_PAD(0x0470, 0x01E4, 3, 0x0544, 0, 0),
	MX6_PAD_CSI_DATA00__EIM_AD00                           = IOMUX_PAD(0x0470, 0x01E4, 4, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA00__GPIO4_IO21                         = IOMUX_PAD(0x0470, 0x01E4, 5, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA00__SRC_INT_BOOT                       = IOMUX_PAD(0x0470, 0x01E4, 6, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA00__UART5_DCE_TX                       = IOMUX_PAD(0x0470, 0x01E4, 8, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA00__UART5_DTE_RX                       = IOMUX_PAD(0x0470, 0x01E4, 8, 0x0644, 0, 0),

	MX6_PAD_CSI_DATA01__CSI_DATA03                         = IOMUX_PAD(0x0474, 0x01E8, 0, 0x04C8, 0, 0),
	MX6_PAD_CSI_DATA01__USDHC2_DATA1                       = IOMUX_PAD(0x0474, 0x01E8, 1, 0x0680, 0, 0),
	MX6_PAD_CSI_DATA01__SIM1_PORT1_SVEN                    = IOMUX_PAD(0x0474, 0x01E8, 2, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA01__ECSPI2_SS0                         = IOMUX_PAD(0x0474, 0x01E8, 3, 0x0550, 0, 0),
	MX6_PAD_CSI_DATA01__EIM_AD01                           = IOMUX_PAD(0x0474, 0x01E8, 4, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA01__GPIO4_IO22                         = IOMUX_PAD(0x0474, 0x01E8, 5, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA01__SAI1_MCLK                          = IOMUX_PAD(0x0474, 0x01E8, 6, 0x05E0, 0, 0),
	MX6_PAD_CSI_DATA01__UART5_DCE_RX                       = IOMUX_PAD(0x0474, 0x01E8, 8, 0x0644, 1, 0),
	MX6_PAD_CSI_DATA01__UART5_DTE_TX                       = IOMUX_PAD(0x0474, 0x01E8, 8, 0x0000, 0, 0),

	MX6_PAD_CSI_DATA02__CSI_DATA04                         = IOMUX_PAD(0x0478, 0x01EC, 0, 0x04D8, 1, 0),
	MX6_PAD_CSI_DATA02__USDHC2_DATA2                       = IOMUX_PAD(0x0478, 0x01EC, 1, 0x0684, 2, 0),
	MX6_PAD_CSI_DATA02__SIM1_PORT1_TRXD                    = IOMUX_PAD(0x0478, 0x01EC, 2, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA02__ECSPI2_MOSI                        = IOMUX_PAD(0x0478, 0x01EC, 3, 0x054C, 1, 0),
	MX6_PAD_CSI_DATA02__EIM_AD02                           = IOMUX_PAD(0x0478, 0x01EC, 4, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA02__GPIO4_IO23                         = IOMUX_PAD(0x0478, 0x01EC, 5, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA02__SAI1_RX_SYNC                       = IOMUX_PAD(0x0478, 0x01EC, 6, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA02__UART5_DCE_RTS                      = IOMUX_PAD(0x0478, 0x01EC, 8, 0x0640, 5, 0),
	MX6_PAD_CSI_DATA02__UART5_DTE_CTS                      = IOMUX_PAD(0x0478, 0x01EC, 8, 0x0000, 0, 0),

	MX6_PAD_CSI_DATA03__CSI_DATA05                         = IOMUX_PAD(0x047C, 0x01F0, 0, 0x04CC, 0, 0),
	MX6_PAD_CSI_DATA03__USDHC2_DATA3                       = IOMUX_PAD(0x047C, 0x01F0, 1, 0x0688, 0, 0),
	MX6_PAD_CSI_DATA03__SIM2_PORT1_PD                      = IOMUX_PAD(0x047C, 0x01F0, 2, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA03__ECSPI2_MISO                        = IOMUX_PAD(0x047C, 0x01F0, 3, 0x0548, 0, 0),
	MX6_PAD_CSI_DATA03__EIM_AD03                           = IOMUX_PAD(0x047C, 0x01F0, 4, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA03__GPIO4_IO24                         = IOMUX_PAD(0x047C, 0x01F0, 5, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA03__SAI1_RX_BCLK                       = IOMUX_PAD(0x047C, 0x01F0, 6, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA03__UART5_DCE_CTS                      = IOMUX_PAD(0x047C, 0x01F0, 8, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA03__UART5_DTE_RTS                      = IOMUX_PAD(0x047C, 0x01F0, 8, 0x0640, 0, 0),

	MX6_PAD_CSI_DATA04__CSI_DATA06                         = IOMUX_PAD(0x0480, 0x01F4, 0, 0x04DC, 1, 0),
	MX6_PAD_CSI_DATA04__USDHC2_DATA4                       = IOMUX_PAD(0x0480, 0x01F4, 1, 0x068C, 2, 0),
	MX6_PAD_CSI_DATA04__SIM2_PORT1_CLK                     = IOMUX_PAD(0x0480, 0x01F4, 2, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA04__ECSPI1_SCLK                        = IOMUX_PAD(0x0480, 0x01F4, 3, 0x0534, 1, 0),
	MX6_PAD_CSI_DATA04__EIM_AD04                           = IOMUX_PAD(0x0480, 0x01F4, 4, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA04__GPIO4_IO25                         = IOMUX_PAD(0x0480, 0x01F4, 5, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA04__SAI1_TX_SYNC                       = IOMUX_PAD(0x0480, 0x01F4, 6, 0x05EC, 1, 0),
	MX6_PAD_CSI_DATA04__USDHC1_WP                          = IOMUX_PAD(0x0480, 0x01F4, 8, 0x066C, 2, 0),

	MX6_PAD_CSI_DATA05__CSI_DATA07                         = IOMUX_PAD(0x0484, 0x01F8, 0, 0x04E0, 1, 0),
	MX6_PAD_CSI_DATA05__USDHC2_DATA5                       = IOMUX_PAD(0x0484, 0x01F8, 1, 0x0690, 2, 0),
	MX6_PAD_CSI_DATA05__SIM2_PORT1_RST_B                   = IOMUX_PAD(0x0484, 0x01F8, 2, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA05__ECSPI1_SS0                         = IOMUX_PAD(0x0484, 0x01F8, 3, 0x0540, 1, 0),
	MX6_PAD_CSI_DATA05__EIM_AD05                           = IOMUX_PAD(0x0484, 0x01F8, 4, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA05__GPIO4_IO26                         = IOMUX_PAD(0x0484, 0x01F8, 5, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA05__SAI1_TX_BCLK                       = IOMUX_PAD(0x0484, 0x01F8, 6, 0x05E8, 1, 0),
	MX6_PAD_CSI_DATA05__USDHC1_CD_B                        = IOMUX_PAD(0x0484, 0x01F8, 8, 0x0668, 2, 0),

	MX6_PAD_CSI_DATA06__CSI_DATA08                         = IOMUX_PAD(0x0488, 0x01FC, 0, 0x04E4, 1, 0),
	MX6_PAD_CSI_DATA06__USDHC2_DATA6                       = IOMUX_PAD(0x0488, 0x01FC, 1, 0x0694, 2, 0),
	MX6_PAD_CSI_DATA06__SIM2_PORT1_SVEN                    = IOMUX_PAD(0x0488, 0x01FC, 2, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA06__ECSPI1_MOSI                        = IOMUX_PAD(0x0488, 0x01FC, 3, 0x053C, 1, 0),
	MX6_PAD_CSI_DATA06__EIM_AD06                           = IOMUX_PAD(0x0488, 0x01FC, 4, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA06__GPIO4_IO27                         = IOMUX_PAD(0x0488, 0x01FC, 5, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA06__SAI1_RX_DATA                       = IOMUX_PAD(0x0488, 0x01FC, 6, 0x05E4, 1, 0),
	MX6_PAD_CSI_DATA06__USDHC1_RESET_B                     = IOMUX_PAD(0x0488, 0x01FC, 8, 0x0000, 0, 0),

	MX6_PAD_CSI_DATA07__CSI_DATA09                         = IOMUX_PAD(0x048C, 0x0200, 0, 0x04E8, 1, 0),
	MX6_PAD_CSI_DATA07__USDHC2_DATA7                       = IOMUX_PAD(0x048C, 0x0200, 1, 0x0698, 2, 0),
	MX6_PAD_CSI_DATA07__SIM2_PORT1_TRXD                    = IOMUX_PAD(0x048C, 0x0200, 2, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA07__ECSPI1_MISO                        = IOMUX_PAD(0x048C, 0x0200, 3, 0x0538, 1, 0),
	MX6_PAD_CSI_DATA07__EIM_AD07                           = IOMUX_PAD(0x048C, 0x0200, 4, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA07__GPIO4_IO28                         = IOMUX_PAD(0x048C, 0x0200, 5, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA07__SAI1_TX_DATA                       = IOMUX_PAD(0x048C, 0x0200, 6, 0x0000, 0, 0),
	MX6_PAD_CSI_DATA07__USDHC1_VSELECT                     = IOMUX_PAD(0x048C, 0x0200, 8, 0x0000, 0, 0),
};
#endif  /* __ASM_ARCH_IMX6UL_PINS_H__ */
