
/*
 *	This file was automatically generated by dbusxx-xml2cpp; DO NOT EDIT!
 */

#ifndef __dbusxx__genivi_navigationcore_proxy_h__PROXY_MARSHAL_H
#define __dbusxx__genivi_navigationcore_proxy_h__PROXY_MARSHAL_H

#include <dbus-c++-1/dbus-c++/dbus.h>
#include <cassert>

namespace org {
namespace genivi {
namespace navigationcore {

class Session_proxy
: public ::DBus::InterfaceProxy
{
public:

    Session_proxy()
    : ::DBus::InterfaceProxy("org.genivi.navigationcore.Session")
    {
        connect_signal(Session_proxy, SessionDeleted, _SessionDeleted_stub);
    }

public:

    /* properties exported by this interface */
public:

    /* methods exported by this interface,
     * this functions will invoke the corresponding methods on the remote objects
     */
    ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > SessionGetVersion()
    {
        ::DBus::CallMessage call;
        call.member("GetVersion");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout;
        ri >> argout;
        return argout;
    }

    uint32_t CreateSession(const std::string& client)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << client;
        call.member("CreateSession");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        uint32_t argout;
        ri >> argout;
        return argout;
    }

    void DeleteSession(const uint32_t& sessionHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        call.member("DeleteSession");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetSessionStatus(const uint32_t& sessionHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        call.member("GetSessionStatus");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    std::vector< ::DBus::Struct< uint32_t, std::string > > GetAllSessions()
    {
        ::DBus::CallMessage call;
        call.member("GetAllSessions");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< ::DBus::Struct< uint32_t, std::string > > argout;
        ri >> argout;
        return argout;
    }


public:

    /* signal handlers for this interface
     */
    virtual void SessionDeleted(const uint32_t& sessionHandle) = 0;

private:

    /* unmarshalers (to unpack the DBus message before calling the actual signal handler)
     */
    void _SessionDeleted_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t sessionHandle;
        ri >> sessionHandle;
        SessionDeleted(sessionHandle);
    }
};

} } }
namespace org {
namespace genivi {
namespace navigationcore {

class Routing_proxy
: public ::DBus::InterfaceProxy
{
public:

    Routing_proxy()
    : ::DBus::InterfaceProxy("org.genivi.navigationcore.Routing")
    {
        connect_signal(Routing_proxy, RouteDeleted, _RouteDeleted_stub);
        connect_signal(Routing_proxy, RouteCalculationCancelled, _RouteCalculationCancelled_stub);
        connect_signal(Routing_proxy, RouteCalculationSuccessful, _RouteCalculationSuccessful_stub);
        connect_signal(Routing_proxy, RouteCalculationFailed, _RouteCalculationFailed_stub);
        connect_signal(Routing_proxy, RouteCalculationProgressUpdate, _RouteCalculationProgressUpdate_stub);
        connect_signal(Routing_proxy, AlternativeRoutesAvailable, _AlternativeRoutesAvailable_stub);
    }

public:

    /* properties exported by this interface */
public:

    /* methods exported by this interface,
     * this functions will invoke the corresponding methods on the remote objects
     */
    ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > RoutingGetVersion()
    {
        ::DBus::CallMessage call;
        call.member("GetVersion");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout;
        ri >> argout;
        return argout;
    }

    uint32_t CreateRoute(const uint32_t& sessionHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        call.member("CreateRoute");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        uint32_t argout;
        ri >> argout;
        return argout;
    }

    void DeleteRoute(const uint32_t& sessionHandle, const uint32_t& routeHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << routeHandle;
        call.member("DeleteRoute");
        ::DBus::Message ret = invoke_method (call);
    }

    void SetCostModel(const uint32_t& sessionHandle, const uint32_t& routeHandle, const int32_t& costModel)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << routeHandle;
        wi << costModel;
        call.member("SetCostModel");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetCostModel(const uint32_t& routeHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << routeHandle;
        call.member("GetCostModel");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    std::vector< int32_t > GetSupportedCostModels()
    {
        ::DBus::CallMessage call;
        call.member("GetSupportedCostModels");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< int32_t > argout;
        ri >> argout;
        return argout;
    }

    void SetRoutePreferences(const uint32_t& sessionHandle, const uint32_t& routeHandle, const std::string& countryCode, const std::vector< ::DBus::Struct< int32_t, int32_t > >& roadPreferenceList, const std::vector< ::DBus::Struct< int32_t, int32_t > >& conditionPreferenceList)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << routeHandle;
        wi << countryCode;
        wi << roadPreferenceList;
        wi << conditionPreferenceList;
        call.member("SetRoutePreferences");
        ::DBus::Message ret = invoke_method (call);
    }

    void GetRoutePreferences(const uint32_t& routeHandle, const std::string& countryCode, std::vector< ::DBus::Struct< int32_t, int32_t > >& roadPreferenceList, std::vector< ::DBus::Struct< int32_t, int32_t > >& conditionPreferenceList)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << routeHandle;
        wi << countryCode;
        call.member("GetRoutePreferences");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> roadPreferenceList;
        ri >> conditionPreferenceList;
    }

    void GetSupportedRoutePreferences(std::vector< ::DBus::Struct< int32_t, int32_t > >& routePreferencesList, std::vector< ::DBus::Struct< int32_t, int32_t > >& conditionPreferenceList)
    {
        ::DBus::CallMessage call;
        call.member("GetSupportedRoutePreferences");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> routePreferencesList;
        ri >> conditionPreferenceList;
    }

    void SetRouteSchedule(const uint32_t& sessionHandle, const uint32_t& routeHandle, const std::map< int32_t, uint32_t >& routeSchedule)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << routeHandle;
        wi << routeSchedule;
        call.member("SetRouteSchedule");
        ::DBus::Message ret = invoke_method (call);
    }

    std::map< int32_t, uint32_t > GetRouteSchedule(const uint32_t& routeHandle, const std::vector< int32_t >& valuesToReturn)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << routeHandle;
        wi << valuesToReturn;
        call.member("GetRouteSchedule");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::map< int32_t, uint32_t > argout;
        ri >> argout;
        return argout;
    }

    void SetTransportationMeans(const uint32_t& sessionHandle, const uint32_t& routeHandle, const std::vector< int32_t >& transportationMeansList)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << routeHandle;
        wi << transportationMeansList;
        call.member("SetTransportationMeans");
        ::DBus::Message ret = invoke_method (call);
    }

    std::vector< int32_t > GetTransportationMeans(const uint32_t& routeHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << routeHandle;
        call.member("GetTransportationMeans");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< int32_t > argout;
        ri >> argout;
        return argout;
    }

    std::vector< int32_t > GetSupportedTransportationMeans()
    {
        ::DBus::CallMessage call;
        call.member("GetSupportedTransportationMeans");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< int32_t > argout;
        ri >> argout;
        return argout;
    }

    void SetExcludedAreas(const uint32_t& sessionHandle, const uint32_t& routeHandle, const std::vector< std::vector< ::DBus::Struct< double, double > > >& excludedAreas)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << routeHandle;
        wi << excludedAreas;
        call.member("SetExcludedAreas");
        ::DBus::Message ret = invoke_method (call);
    }

    std::vector< std::vector< ::DBus::Struct< double, double > > > GetExcludedAreas(const uint32_t& routeHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << routeHandle;
        call.member("GetExcludedAreas");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< std::vector< ::DBus::Struct< double, double > > > argout;
        ri >> argout;
        return argout;
    }

    void SetWaypoints(const uint32_t& sessionHandle, const uint32_t& routeHandle, const bool& startFromCurrentPosition, const std::vector< std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > >& waypointsList)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << routeHandle;
        wi << startFromCurrentPosition;
        wi << waypointsList;
        call.member("SetWaypoints");
        ::DBus::Message ret = invoke_method (call);
    }

    void GetWaypoints(const uint32_t& routeHandle, bool& startFromCurrentPosition, std::vector< std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > >& waypointsList)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << routeHandle;
        call.member("GetWaypoints");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> startFromCurrentPosition;
        ri >> waypointsList;
    }

    void CalculateRoute(const uint32_t& sessionHandle, const uint32_t& routeHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << routeHandle;
        call.member("CalculateRoute");
        ::DBus::Message ret = invoke_method (call);
    }

    void CancelRouteCalculation(const uint32_t& sessionHandle, const uint32_t& routeHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << routeHandle;
        call.member("CancelRouteCalculation");
        ::DBus::Message ret = invoke_method (call);
    }

    std::vector< uint32_t > CalculateRoutes(const uint32_t& sessionHandle, const std::vector< uint32_t >& calculatedRoutesList)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << calculatedRoutesList;
        call.member("CalculateRoutes");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< uint32_t > argout;
        ri >> argout;
        return argout;
    }

    void GetRouteSegments(const uint32_t& routeHandle, const int16_t& detailLevel, const std::vector< int32_t >& valuesToReturn, const uint32_t& numberOfSegments, const uint32_t& offset, uint32_t& totalNumberOfSegments, std::vector< std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > >& routeSegments)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << routeHandle;
        wi << detailLevel;
        wi << valuesToReturn;
        wi << numberOfSegments;
        wi << offset;
        call.member("GetRouteSegments");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> totalNumberOfSegments;
        ri >> routeSegments;
    }

    std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > GetRouteOverview(const uint32_t& routeHandle, const std::vector< int32_t >& valuesToReturn)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << routeHandle;
        wi << valuesToReturn;
        call.member("GetRouteOverview");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > argout;
        ri >> argout;
        return argout;
    }

    ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > > GetRouteBoundingBox(const uint32_t& routeHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << routeHandle;
        call.member("GetRouteBoundingBox");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > > argout;
        ri >> argout;
        return argout;
    }

    std::vector< uint32_t > GetAllRoutes()
    {
        ::DBus::CallMessage call;
        call.member("GetAllRoutes");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< uint32_t > argout;
        ri >> argout;
        return argout;
    }

    void SetBlockedRouteStretches(const uint32_t& sessionHandle, const uint32_t& routeHandle, const std::vector< ::DBus::Struct< uint32_t, uint32_t > >& blockParameters)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << routeHandle;
        wi << blockParameters;
        call.member("SetBlockedRouteStretches");
        ::DBus::Message ret = invoke_method (call);
    }

    std::vector< ::DBus::Struct< uint32_t, uint32_t > > GetBlockedRouteStretches(const uint32_t& routeHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << routeHandle;
        call.member("GetBlockedRouteStretches");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< ::DBus::Struct< uint32_t, uint32_t > > argout;
        ri >> argout;
        return argout;
    }


public:

    /* signal handlers for this interface
     */
    virtual void RouteDeleted(const uint32_t& routeHandle) = 0;
    virtual void RouteCalculationCancelled(const uint32_t& routeHandle) = 0;
    virtual void RouteCalculationSuccessful(const uint32_t& routeHandle, const std::map< int32_t, int32_t >& unfullfilledPreferences) = 0;
    virtual void RouteCalculationFailed(const uint32_t& routeHandle, const int32_t& errorCode, const std::map< int32_t, int32_t >& unfullfilledPreferences) = 0;
    virtual void RouteCalculationProgressUpdate(const uint32_t& routeHandle, const int32_t& status, const uint8_t& percentage) = 0;
    virtual void AlternativeRoutesAvailable(const std::vector< uint32_t >& routeHandlesList) = 0;

private:

    /* unmarshalers (to unpack the DBus message before calling the actual signal handler)
     */
    void _RouteDeleted_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t routeHandle;
        ri >> routeHandle;
        RouteDeleted(routeHandle);
    }
    void _RouteCalculationCancelled_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t routeHandle;
        ri >> routeHandle;
        RouteCalculationCancelled(routeHandle);
    }
    void _RouteCalculationSuccessful_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t routeHandle;
        ri >> routeHandle;
        std::map< int32_t, int32_t > unfullfilledPreferences;
        ri >> unfullfilledPreferences;
        RouteCalculationSuccessful(routeHandle, unfullfilledPreferences);
    }
    void _RouteCalculationFailed_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t routeHandle;
        ri >> routeHandle;
        int32_t errorCode;
        ri >> errorCode;
        std::map< int32_t, int32_t > unfullfilledPreferences;
        ri >> unfullfilledPreferences;
        RouteCalculationFailed(routeHandle, errorCode, unfullfilledPreferences);
    }
    void _RouteCalculationProgressUpdate_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t routeHandle;
        ri >> routeHandle;
        int32_t status;
        ri >> status;
        uint8_t percentage;
        ri >> percentage;
        RouteCalculationProgressUpdate(routeHandle, status, percentage);
    }
    void _AlternativeRoutesAvailable_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        std::vector< uint32_t > routeHandlesList;
        ri >> routeHandlesList;
        AlternativeRoutesAvailable(routeHandlesList);
    }
};

} } }
namespace org {
namespace genivi {
namespace navigationcore {

class MapMatchedPosition_proxy
: public ::DBus::InterfaceProxy
{
public:

    MapMatchedPosition_proxy()
    : ::DBus::InterfaceProxy("org.genivi.navigationcore.MapMatchedPosition")
    {
        connect_signal(MapMatchedPosition_proxy, SimulationStatusChanged, _SimulationStatusChanged_stub);
        connect_signal(MapMatchedPosition_proxy, SimulationSpeedChanged, _SimulationSpeedChanged_stub);
        connect_signal(MapMatchedPosition_proxy, PositionUpdate, _PositionUpdate_stub);
        connect_signal(MapMatchedPosition_proxy, AddressUpdate, _AddressUpdate_stub);
        connect_signal(MapMatchedPosition_proxy, PositionOnSegmentUpdate, _PositionOnSegmentUpdate_stub);
        connect_signal(MapMatchedPosition_proxy, StatusUpdate, _StatusUpdate_stub);
        connect_signal(MapMatchedPosition_proxy, OffRoadPositionChanged, _OffRoadPositionChanged_stub);
    }

public:

    /* properties exported by this interface */
public:

    /* methods exported by this interface,
     * this functions will invoke the corresponding methods on the remote objects
     */
    ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > MapMatchedPositionGetVersion()
    {
        ::DBus::CallMessage call;
        call.member("GetVersion");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout;
        ri >> argout;
        return argout;
    }

    void SetSimulationMode(const uint32_t& sessionHandle, const bool& activate)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << activate;
        call.member("SetSimulationMode");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetSimulationStatus()
    {
        ::DBus::CallMessage call;
        call.member("GetSimulationStatus");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    void AddSimulationStatusListener()
    {
        ::DBus::CallMessage call;
        call.member("AddSimulationStatusListener");
        ::DBus::Message ret = invoke_method (call);
    }

    void RemoveSimulationStatusListener()
    {
        ::DBus::CallMessage call;
        call.member("RemoveSimulationStatusListener");
        ::DBus::Message ret = invoke_method (call);
    }

    void SetSimulationSpeed(const uint32_t& sessionHandle, const uint8_t& speedFactor)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << speedFactor;
        call.member("SetSimulationSpeed");
        ::DBus::Message ret = invoke_method (call);
    }

    uint8_t GetSimulationSpeed()
    {
        ::DBus::CallMessage call;
        call.member("GetSimulationSpeed");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        uint8_t argout;
        ri >> argout;
        return argout;
    }

    void AddSimulationSpeedListener()
    {
        ::DBus::CallMessage call;
        call.member("AddSimulationSpeedListener");
        ::DBus::Message ret = invoke_method (call);
    }

    void RemoveSimulationSpeedListener()
    {
        ::DBus::CallMessage call;
        call.member("RemoveSimulationSpeedListener");
        ::DBus::Message ret = invoke_method (call);
    }

    void StartSimulation(const uint32_t& sessionHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        call.member("StartSimulation");
        ::DBus::Message ret = invoke_method (call);
    }

    void PauseSimulation(const uint32_t& sessionHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        call.member("PauseSimulation");
        ::DBus::Message ret = invoke_method (call);
    }

    std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > GetPosition(const std::vector< int32_t >& valuesToReturn)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << valuesToReturn;
        call.member("GetPosition");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > argout;
        ri >> argout;
        return argout;
    }

    void SetPosition(const uint32_t& sessionHandle, const std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > >& position)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << position;
        call.member("SetPosition");
        ::DBus::Message ret = invoke_method (call);
    }

    std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > GetAddress(const std::vector< int32_t >& valuesToReturn)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << valuesToReturn;
        call.member("GetAddress");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > argout;
        ri >> argout;
        return argout;
    }

    std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > GetPositionOnSegment(const std::vector< int32_t >& valuesToReturn)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << valuesToReturn;
        call.member("GetPositionOnSegment");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > argout;
        ri >> argout;
        return argout;
    }

    std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > GetStatus(const std::vector< int32_t >& valuesToReturn)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << valuesToReturn;
        call.member("GetStatus");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > argout;
        ri >> argout;
        return argout;
    }


public:

    /* signal handlers for this interface
     */
    virtual void SimulationStatusChanged(const int32_t& simulationStatus) = 0;
    virtual void SimulationSpeedChanged(const uint8_t& speedFactor) = 0;
    virtual void PositionUpdate(const std::vector< int32_t >& changedValues) = 0;
    virtual void AddressUpdate(const std::vector< int32_t >& changedValues) = 0;
    virtual void PositionOnSegmentUpdate(const std::vector< int32_t >& changedValues) = 0;
    virtual void StatusUpdate(const std::vector< int32_t >& changedValues) = 0;
    virtual void OffRoadPositionChanged(const uint32_t& distance, const int32_t& direction) = 0;

private:

    /* unmarshalers (to unpack the DBus message before calling the actual signal handler)
     */
    void _SimulationStatusChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        int32_t simulationStatus;
        ri >> simulationStatus;
        SimulationStatusChanged(simulationStatus);
    }
    void _SimulationSpeedChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint8_t speedFactor;
        ri >> speedFactor;
        SimulationSpeedChanged(speedFactor);
    }
    void _PositionUpdate_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        std::vector< int32_t > changedValues;
        ri >> changedValues;
        PositionUpdate(changedValues);
    }
    void _AddressUpdate_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        std::vector< int32_t > changedValues;
        ri >> changedValues;
        AddressUpdate(changedValues);
    }
    void _PositionOnSegmentUpdate_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        std::vector< int32_t > changedValues;
        ri >> changedValues;
        PositionOnSegmentUpdate(changedValues);
    }
    void _StatusUpdate_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        std::vector< int32_t > changedValues;
        ri >> changedValues;
        StatusUpdate(changedValues);
    }
    void _OffRoadPositionChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t distance;
        ri >> distance;
        int32_t direction;
        ri >> direction;
        OffRoadPositionChanged(distance, direction);
    }
};

} } }
namespace org {
namespace genivi {
namespace navigationcore {

class Guidance_proxy
: public ::DBus::InterfaceProxy
{
public:

    Guidance_proxy()
    : ::DBus::InterfaceProxy("org.genivi.navigationcore.Guidance")
    {
        connect_signal(Guidance_proxy, VehicleLeftTheRoadNetwork, _VehicleLeftTheRoadNetwork_stub);
        connect_signal(Guidance_proxy, GuidanceStatusChanged, _GuidanceStatusChanged_stub);
        connect_signal(Guidance_proxy, WaypointReached, _WaypointReached_stub);
        connect_signal(Guidance_proxy, ManeuverChanged, _ManeuverChanged_stub);
        connect_signal(Guidance_proxy, PositionOnRouteChanged, _PositionOnRouteChanged_stub);
        connect_signal(Guidance_proxy, VehicleLeftTheRoute, _VehicleLeftTheRoute_stub);
        connect_signal(Guidance_proxy, PositionToRouteChanged, _PositionToRouteChanged_stub);
        connect_signal(Guidance_proxy, ActiveRouteChanged, _ActiveRouteChanged_stub);
    }

public:

    /* properties exported by this interface */
public:

    /* methods exported by this interface,
     * this functions will invoke the corresponding methods on the remote objects
     */
    ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > GuidanceGetVersion()
    {
        ::DBus::CallMessage call;
        call.member("GetVersion");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout;
        ri >> argout;
        return argout;
    }

    void StartGuidance(const uint32_t& sessionHandle, const uint32_t& routeHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << routeHandle;
        call.member("StartGuidance");
        ::DBus::Message ret = invoke_method (call);
    }

    void StopGuidance(const uint32_t& sessionHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        call.member("StopGuidance");
        ::DBus::Message ret = invoke_method (call);
    }

    void SetVoiceGuidance(const bool& activate, const std::string& voice)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << activate;
        wi << voice;
        call.member("SetVoiceGuidance");
        ::DBus::Message ret = invoke_method (call);
    }

    void GetGuidanceDetails(bool& voiceGuidance, bool& vehicleOnTheRoad, bool& isDestinationReached, int32_t& maneuver)
    {
        ::DBus::CallMessage call;
        call.member("GetGuidanceDetails");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> voiceGuidance;
        ri >> vehicleOnTheRoad;
        ri >> isDestinationReached;
        ri >> maneuver;
    }

    void PlayVoiceManeuver()
    {
        ::DBus::CallMessage call;
        call.member("PlayVoiceManeuver");
        ::DBus::Message ret = invoke_method (call);
    }

    void GetWaypointInformation(const uint16_t& requestedNumberOfWaypoints, uint16_t& numberOfWaypoints, std::vector< ::DBus::Struct< uint32_t, uint32_t, int32_t, int32_t, int16_t, int16_t, bool, uint16_t > >& waypointsList)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << requestedNumberOfWaypoints;
        call.member("GetWaypointInformation");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> numberOfWaypoints;
        ri >> waypointsList;
    }

    void GetDestinationInformation(uint32_t& offset, uint32_t& travelTime, int32_t& direction, int32_t& side, int16_t& timeZone, int16_t& daylightSavingTime)
    {
        ::DBus::CallMessage call;
        call.member("GetDestinationInformation");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> offset;
        ri >> travelTime;
        ri >> direction;
        ri >> side;
        ri >> timeZone;
        ri >> daylightSavingTime;
    }

    void GetManeuversList(const uint16_t& requestedNumberOfManeuvers, const uint32_t& maneuverOffset, uint16_t& numberOfManeuvers, std::vector< ::DBus::Struct< std::string, std::string, uint16_t, int32_t, uint32_t, std::vector< ::DBus::Struct< uint32_t, uint32_t, int32_t, int32_t, std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > > > > >& maneuversList)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << requestedNumberOfManeuvers;
        wi << maneuverOffset;
        call.member("GetManeuversList");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> numberOfManeuvers;
        ri >> maneuversList;
    }

    void SetRouteCalculationMode(const uint32_t& sessionHandle, const int32_t& routeCalculationMode)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << routeCalculationMode;
        call.member("SetRouteCalculationMode");
        ::DBus::Message ret = invoke_method (call);
    }

    void SkipNextManeuver(const uint32_t& sessionHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        call.member("SkipNextManeuver");
        ::DBus::Message ret = invoke_method (call);
    }

    void GetGuidanceStatus(int32_t& guidanceStatus, uint32_t& routeHandle)
    {
        ::DBus::CallMessage call;
        call.member("GetGuidanceStatus");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> guidanceStatus;
        ri >> routeHandle;
    }

    void SetVoiceGuidanceSettings(const int32_t& promptMode)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << promptMode;
        call.member("SetVoiceGuidanceSettings");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetVoiceGuidanceSettings()
    {
        ::DBus::CallMessage call;
        call.member("GetVoiceGuidanceSettings");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }


public:

    /* signal handlers for this interface
     */
    virtual void VehicleLeftTheRoadNetwork() = 0;
    virtual void GuidanceStatusChanged(const int32_t& guidanceStatus, const uint32_t& routeHandle) = 0;
    virtual void WaypointReached(const bool& isDestination) = 0;
    virtual void ManeuverChanged(const int32_t& maneuver) = 0;
    virtual void PositionOnRouteChanged(const uint32_t& offsetOnRoute) = 0;
    virtual void VehicleLeftTheRoute() = 0;
    virtual void PositionToRouteChanged(const uint32_t& distance, const int32_t& direction) = 0;
    virtual void ActiveRouteChanged(const int32_t& changeCause) = 0;

private:

    /* unmarshalers (to unpack the DBus message before calling the actual signal handler)
     */
    void _VehicleLeftTheRoadNetwork_stub(const ::DBus::SignalMessage &sig)
    {
        VehicleLeftTheRoadNetwork();
    }
    void _GuidanceStatusChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        int32_t guidanceStatus;
        ri >> guidanceStatus;
        uint32_t routeHandle;
        ri >> routeHandle;
        GuidanceStatusChanged(guidanceStatus, routeHandle);
    }
    void _WaypointReached_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        bool isDestination;
        ri >> isDestination;
        WaypointReached(isDestination);
    }
    void _ManeuverChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        int32_t maneuver;
        ri >> maneuver;
        ManeuverChanged(maneuver);
    }
    void _PositionOnRouteChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t offsetOnRoute;
        ri >> offsetOnRoute;
        PositionOnRouteChanged(offsetOnRoute);
    }
    void _VehicleLeftTheRoute_stub(const ::DBus::SignalMessage &sig)
    {
        VehicleLeftTheRoute();
    }
    void _PositionToRouteChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t distance;
        ri >> distance;
        int32_t direction;
        ri >> direction;
        PositionToRouteChanged(distance, direction);
    }
    void _ActiveRouteChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        int32_t changeCause;
        ri >> changeCause;
        ActiveRouteChanged(changeCause);
    }
};

} } }
#endif //__dbusxx__genivi_navigationcore_proxy_h__PROXY_MARSHAL_H
