/*
 * Copyright (c) 2017 TOYOTA MOTOR CORPORATION
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "qlibwindowmanager.h"
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string>
//#include <wrap-json.h>

// TODO: write description for function
// TODO: replace json_object creation to use wrap-json

using namespace std;

int QLibWindowmanager::init(int port, const QString &token) {
    string ctoken = token.toStdString();
    int ret_init =  this->wm->init(port, ctoken.c_str());

    // initialize dpyinfo
    json_object *obj = json_object_new_object();

    int ret = this->wm->getDisplayInfo(obj);

    this->screen_info = new AGLScreenInfoPrivate;

    if (!ret) {
        json_object *j_val;
        if (json_object_object_get_ex(obj, "width_pixel", &j_val)) {
            this->screen_info->set_width_dp(json_object_get_double(j_val));
        }
        if (json_object_object_get_ex(obj, "height_pixel", &j_val)) {
            this->screen_info->set_height_dp(json_object_get_double(j_val));
        }
        if (json_object_object_get_ex(obj, "width_mm", &j_val)) {
            this->screen_info->set_width_mm(json_object_get_double(j_val));
        }
        if (json_object_object_get_ex(obj, "height_mm", &j_val)) {
            this->screen_info->set_height_mm(json_object_get_double(j_val));
        }
        if (json_object_object_get_ex(obj, "scale", &j_val)) {
            this->screen_info->set_scale_factor(json_object_get_double(j_val));
        }
    }

    json_object_put(obj);

    return ret_init;
}

int QLibWindowmanager::requestSurface(const QString &label) {
    string cstr = label.toStdString();
    applabel = strdup(cstr.c_str());

    json_object *obj = json_object_new_object();
    json_object_object_add(obj, wm->kKeyDrawingName, json_object_new_string(applabel));
    int surface_id = this->wm->requestSurface(obj);
    if(surface_id < 0){
        qDebug("failed to get surfaceID");
        return -1;
    }
    else{
        qDebug("surfaceID is set to %d", surface_id);
        char buf[65];   // surface id is under 64bit(1.84E19,) so 65 is sufficient for buffer
        snprintf(buf, 65, "%d", surface_id);
        setenv("QT_IVI_SURFACE_ID", buf, 1);
        return 0;
    }
}

int QLibWindowmanager::activateWindow(const QString &label) {
    json_object *obj = json_object_new_object();
    string clabel = label.toStdString();
    // Request default drawing area "normal.full"
    string cdrawing_area = wm->kStrLayoutNormal + "." + wm->kStrAreaFull;
    json_object_object_add(obj, wm->kKeyDrawingName, json_object_new_string(clabel.c_str()));
    json_object_object_add(obj, wm->kKeyDrawingArea, json_object_new_string(cdrawing_area.c_str()));
    return this->wm->activateWindow(obj);
}

int QLibWindowmanager::activateWindow(const QString &label, const QString &drawing_area) {
    json_object *obj = json_object_new_object();
    string clabel = label.toStdString();
    string cdrawing_area = drawing_area.toStdString();
    json_object_object_add(obj, wm->kKeyDrawingName, json_object_new_string(clabel.c_str()));
    json_object_object_add(obj, wm->kKeyDrawingArea, json_object_new_string(cdrawing_area.c_str()));
    return this->wm->activateWindow(obj);
}

int QLibWindowmanager::deactivateWindow(const QString &label) {
    json_object *obj = json_object_new_object();
    string clabel = label.toStdString();
    json_object_object_add(obj, wm->kKeyDrawingName, json_object_new_string(clabel.c_str()));
    return this->wm->deactivateWindow(obj);
}

// This API is deprecated, please use new API
int QLibWindowmanager::activateSurface(const QString &label) {
    return this->activateWindow(label);
}

// This API is deprecated, please use new API
int QLibWindowmanager::activateSurface(const QString &label, const QString &drawing_area) {
    return this->activateWindow(label, drawing_area);
}

// This API is deprecated, please use new API
int QLibWindowmanager::deactivateSurface(const QString &label) {
    return this->deactivateWindow(label);
}

int QLibWindowmanager::endDraw(const QString &label) {
    json_object *obj = json_object_new_object();
    string clabel = label.toStdString();
    json_object_object_add(obj, wm->kKeyDrawingName, json_object_new_string(clabel.c_str()));
    return this->wm->endDraw(obj);
    }

void QLibWindowmanager::set_event_handler(enum QEventType et,
                                  handler_fun f) {
    LibWindowmanager::EventType wet = (LibWindowmanager::EventType)et;
    return this->wm->set_event_handler(wet, std::move(f));
}

void QLibWindowmanager::slotActivateWindow(){
    // This is needed for first rendering when the app is launched
    if(!isActive){
        qDebug("Let's show %s", qPrintable(applabel));
        isActive = true;
        this->activateWindow(applabel);
    }
}

// This API is deprecated, please use new API
void QLibWindowmanager::slotActivateSurface(){
    this->slotActivateWindow();
}

QLibWindowmanager::QLibWindowmanager(QObject *parent)
    :QObject(parent), isActive(false), screen_info(nullptr)
{
    wm = new LibWindowmanager();
}

QLibWindowmanager::~QLibWindowmanager() { }
