# AGL Signals composer

## Goal

Goals here are to provides a common interface to manage signals provided by
different sources, mostly AGL Application Framework binding like low-can, GPS or
sensors through MRAA.

## Installation

Prerequisite are the same than for a classic binding and you could refer to the [wiki page](https://en.opensuse.org/LinuxAutomotive#AGL_Application_Framework) to install the **AGL Application Framework** for your distribution.

Few additionnal prerequisites are necessary which are:

- LUA >= 5.3
- libuuid

Then download and build the project with the following commands:

```bash
git clone https://github.com/iotbzh/afb-signal-composer --recurse-submodules
cd afb-signal-composer
./conf.d/autobuild/linux/autobuild install
```

This will install the binding into _${HOME}/opt/signal-composer_ directory. You can change that by modify the variable **CMAKE_INSTALL_PREFIX** in _conf.d/cmake/config.cmake_ file.

## Generate the documentation

### Prerequisites

You can use gitbook to serve documentation. To do so, please install it using *npm* as well as *calibre* package from your package distribution manager:

```bash
sudo npm install -g gitbook-cli
sudo apt-get install calibre
```

To generate Doxygen documentation, you'll need doxygen and graphviz:

```bash
sudo apt-get install doxygen graphviz
```

Prepare your build environment:

```bash
mkdir build && cd build
cmake ..
```

### Generation

Generate a PDF version :

```bash
gendocs.sh pdf
```

Serve an HTML version, this will run a web server that will serve you locally documentation :

```bash
gendocs.sh serve
```

Generate **doxygen** documentation:

```bash
$ doxygen
warning: tag INPUT: input source `src/' does not exist
Notice: Output directory `docs_doxygen' does not exist. I have created it for you.
Searching for include files...
Searching for example files...
Searching for images...
Searching for dot files...
Searching for msc files...
Searching for dia files...
Searching for files to exclude
Searching INPUT for files to process...
warning: source src is not a readable file or directory... skipping.
Reading and parsing tag files
Parsing files
Building group list...
Building directory list...
Building namespace list...
Building file list...
Building class list...
Associating documentation with classes...
Computing nesting relations for classes...
Building example list...
Searching for enumerations...
Searching for documented typedefs...
Searching for members imported via using declarations...
Searching for included using directives...
Searching for documented variables...
Building interface member list...
Building member list...
Searching for friends...
Searching for documented defines...
Computing class inheritance relations...
Computing class usage relations...
Flushing cached template relations that have become invalid...
Computing class relations...
Add enum values to enums...
Searching for member function documentation...
Creating members for template instances...
Building page list...
Search for main page...
Computing page relations...
Determining the scope of groups...
Sorting lists...
Freeing entry tree
Determining which enums are documented
Computing member relations...
Building full member lists recursively...
Adding members to member groups.
Computing member references...
Inheriting documentation...
Generating disk names...
Adding source references...
Adding xrefitems...
Sorting member lists...
Computing dependencies between directories...
Generating citations page...
Counting data structures...
Resolving user defined references...
Finding anchors and sections in the documentation...
Transferring function references...
Combining using relations...
Adding members to index pages...
Generating style sheet...
Generating search indices...
Generating example documentation...
Generating file sources...
Generating file documentation...
Generating page documentation...
Generating group documentation...
Generating class documentation...
Generating namespace index...
Generating graph info page...
Generating directory documentation...
Generating index page...
Generating page index...
Generating module index...
Generating namespace index...
Generating namespace member index...
Generating annotated compound index...
Generating alphabetical compound index...
Generating hierarchical class index...
Generating graphical class hierarchy...
Generating member index...
Generating file index...
Generating file member index...
Generating example index...
finalizing index lists...
writing tag file...
Running dot...
Running dot for graph 1/1
lookup cache used 127/65536 hits=628 misses=194
finished...
```
