--[[
   Copyright (C) 2018 "IoT.bzh"
   Author Frédéric Marec <frederic.marec@iot.bzh>

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.


   NOTE: strict mode: every global variables should be prefixed by '_'
--]]

local testPrefix ="persistence_BasicAPITest_"

-- This tests the 'insert' verb of the persistence API
_AFT.testVerbStatusSuccess(testPrefix.."insert","persistence","insert", {key="TEST", value="myvalue"}, nil,
  function()
    _AFT.callVerb("persistence", "delete", {key="TEST"})
  end)

-- This tests the 'delete' verb of the persistence API
_AFT.testVerbStatusSuccess(testPrefix.."delete","persistence","delete", {key="TEST"},
  function()
    _AFT.callVerb("persistence", "insert", {key="TEST", value="myvalue"})
  end, nil)

-- This tests the 'update' verb of the persistence API
_AFT.testVerbStatusSuccess(testPrefix.."update","persistence","update", {key="TEST", value="test"},
  function()
    _AFT.callVerb("persistence", "insert", {key="TEST", value="myvalue"})
  end,
  function()
    _AFT.callVerb("persistence", "delete", {key="TEST"})
  end)

-- This tests the 'read' verb of the persistence API
_AFT.testVerbStatusSuccess(testPrefix.."read","persistence","read", {key="TEST"},
  function()
    _AFT.callVerb("persistence", "insert", {key="TEST", value="myvalue"})
  end,
  function()
    _AFT.callVerb("persistence", "delete", {key="TEST"})
  end)

-- This tests the 'read' verb of the persistence API
_AFT.testVerbStatusError(testPrefix.."read-unknow-value","persistence","read", {key="TEST"}, nil, nil)

-- This tests the 'insert' verb of the persistence API
_AFT.testVerbStatusError(testPrefix.."insert-without-value","persistence","insert", {key="TEST"}, nil,
  function()
    _AFT.callVerb("persistence", "delete", {key="TEST"})
  end)

-- This tests the 'delete' verb of the persistence API
_AFT.testVerbStatusError(testPrefix.."delete-unknow-key","persistence","delete", {key="TEST"}, nil, nil)

-- This tests the 'insert' verb of the persistence API
_AFT.testVerbStatusError(testPrefix.."insert-with-anything","persistence","insert", {value="talenka"}, nil, nil)

-- This tests the 'update' verb of the persistence API
_AFT.testVerbStatusError(testPrefix.."update-unkwon-null-value","persistence","update", {key=null}, nil, nil)

_AFT.exitAtEnd()
