INSTALL - CUPS v2.2.4 - 2017-06-30
==================================

This file describes how to compile and install CUPS from source code. For more
information on CUPS see the file called "README.txt".  A complete change log can
be found in "CHANGES.txt".

> USING CUPS REQUIRES ADDITIONAL THIRD-PARTY SUPPORT SOFTWARE AND PRINTER
> DRIVERS.  THESE ARE TYPICALLY INCLUDED WITH YOUR OPERATING SYSTEM
> DISTRIBUTION.  APPLE DOES NOT ENDORSE OR SUPPORT THIRD-PARTY SUPPORT SOFTWARE
> FOR CUPS.


BEFORE YOU BEGIN
----------------

You'll need ANSI-compliant C and C++ compilers, plus a make program and POSIX-
compliant shell (/bin/sh).  The GNU compiler tools and Bash work well and we
have tested the current CUPS code against several versions of GCC with excellent
results.

The makefiles used by the project should work with most versions of make.  We've
tested them with GNU make as well as the make programs shipped by Compaq, HP,
SGI, and Sun.  BSD users should use GNU make (gmake) since BSD make does not
support "include".

Besides these tools you'll want ZLIB library for compression support, the GNU
TLS library for encryption support on platforms other than iOS, macOS, or
Windows, and either MIT (1.6.3 or higher) or Heimdal Kerberos for Kerberos
support.  CUPS will compile and run without these, however you'll miss out on
many of the features provided by CUPS.

On a stock Ubuntu install, the following command will install the required
prerequisites:

    sudo apt-get install autoconf build-essential libavahi-client-dev \
         libgnutls28-dev libkrb5-dev libnss-mdns libpam-dev \
         libsystemd-dev libusb-1.0-0-dev zlib1g-dev

Also, please note that CUPS does not include print filters to support PDF or
raster printing.  You *must* download GPL Ghostscript and/or the Open Printing
CUPS filters package separately to print on operating systems other than macOS.


CONFIGURATION
-------------

CUPS uses GNU autoconf, so you should find the usual "configure" script in the
main CUPS source directory.  To configure CUPS for your system, type:

    ./configure

The default installation will put the CUPS software in the "/etc", "/usr", and
"/var" directories on your system, which will overwrite any existing printing
commands on your system.  Use the "--prefix" option to install the CUPS software
in another location:

    ./configure --prefix=/some/directory

To see a complete list of configuration options, use the --help option:

    ./configure --help

If any of the dependent libraries are not installed in a system default location
(typically "/usr/include" and "/usr/lib") you'll need to set the CFLAGS,
CPPFLAGS, CXXFLAGS, DSOFLAGS, and LDFLAGS environment variables prior to running
configure:

    setenv CFLAGS "-I/some/directory"
    setenv CPPFLAGS "-I/some/directory"
    setenv CXXFLAGS "-I/some/directory"
    setenv DSOFLAGS "-L/some/directory"
    setenv LDFLAGS "-L/some/directory"
    ./configure ...

or:

    CFLAGS="-I/some/directory" \
    CPPFLAGS="-I/some/directory" \
    CXXFLAGS="-I/some/directory" \
    DSOFLAGS="-L/some/directory" \
    LDFLAGS="-L/some/directory" \
    ./configure ...

The "--enable-debug" option compiles CUPS with debugging information enabled.
Additional debug logging support can be enabled using the
"--enable-debug-printfs" option - these debug messages are enabled using the
CUPS_DEBUG_LOG environment variable at run-time.

CUPS also includes an extensive set of unit tests that can be used to find and
diagnose a variety of common problems - use the "--enable-unit-tests" configure
option to run them at build time.

On macOS, use the "--with-archflags" option to build with the correct set of
architectures:

    ./configure --with-archflags="-arch i386 -arch x86_64" ...

> Note: Current versions of macOS DO NOT allow installation to /usr with the
> default system integrity settings.  In addition, we do not recommend replacing
> the CUPS supplied with macOS because not all versions of CUPS are compatible
> with every macOS release, and because software updates will replace parts
> of your local installation potentially rendering your system unusable.

Once you have configured things, just type:

    make ENTER

or if you have FreeBSD, NetBSD, or OpenBSD type:

    gmake ENTER

to build the software.


TESTING THE SOFTWARE
--------------------

Aside from the built-in unit tests, CUPS includes an automated test framework
for testing the entire printing system.  To run the tests, just type:

    make check ENTER

or if you have FreeBSD, NetBSD, or OpenBSD type:

    gmake check ENTER

The test framework runs a copy of the CUPS scheduler (cupsd) on port 8631 in
/tmp/cups-$USER and produces a nice HTML report of the results.


INSTALLING THE SOFTWARE
-----------------------

Once you have built the software you need to install it.  The "install" target
provides a quick way to install the software on your local system:

    make install ENTER

or for FreeBSD, NetBSD, or OpenBSD:

    gmake install ENTER

Use the BUILDROOT variable to install to an alternate root directory:

    make BUILDROOT=/some/other/root/directory install ENTER

You can also build binary packages that can be installed on other machines using
the RPM spec file ("packaging/cups.spec") or EPM list file
("packaging/cups.list").  The latter also supports building of binary RPMs, so
it may be more convenient to use.

You can find the RPM software at:

    http://www.rpm.org/

The EPM software is available at:

    https://michaelrsweet.github.io/epm


CREATING BINARY DISTRIBUTIONS WITH EPM
--------------------------------------

The top level makefile supports generation of many types of binary distributions
using EPM.  To build a binary distribution type:

    make <format> ENTER

or

    gmake <format> ENTER

for FreeBSD, NetBSD, and OpenBSD.  The <format> target is one of the following:

- "epm": Builds a script + tarfile package
- "bsd": Builds a *BSD package
- "deb": Builds a Debian package
- "pkg": Builds a Solaris package
- "rpm": Builds a RPM package
- "slackware": Build a Slackware package


GETTING DEBUG LOGGING FROM CUPS
-------------------------------

When configured with the "--enable-debug-printfs" option, CUPS compiles in
additional debug logging support in the scheduler, CUPS API, and CUPS Imaging
API.  The following environment variables are used to enable and control debug
logging:

- `CUPS_DEBUG_FILTER`: Specifies a POSIX regular expression to control which
  messages are logged.
- `CUPS_DEBUG_LEVEL`: Specifies a number from 0 to 9 to control the verbosity of
  the logging. The default level is 1.
- `CUPS_DEBUG_LOG`: Specifies a log file to use.  Specify the name "-" to send
  the messages to stderr.  Prefix a filename with "+" to append to an existing
  file.


REPORTING PROBLEMS
------------------

If you have problems, READ THE DOCUMENTATION FIRST!  If the documentation does
not solve your problems, please post a message on the users forum at:

    https://www.cups.org/

Include your operating system and version, compiler and version, and any errors
or problems you've run into.  The "config.log" file and the output from the
configure script and make should also be sent, as it often helps to determine
the cause of your problem.

If you are running a version of Linux, be sure to provide the Linux distribution
you have, too.
