#include <json-c/json.h>
#include "ahl-binding.hpp"
#include "interrupt.hpp"
#include "role.hpp"

interrupt_t::interrupt_t(json_object* o)
{
    jcast(type_, o, "type");
    json_object * value = NULL;
    json_object_object_get_ex(o, "args", &value);
    args_ = value;
}

interrupt_t& interrupt_t::operator<<(json_object* o)
{
    jcast(type_, o, "type");
    json_object * value = NULL;
    json_object_object_get_ex(o, "args", &value);
    args_  = value;
    return *this;
}

std::string interrupt_t::type() const
{
    return type_;
}

json_object* interrupt_t::args() const
{
    return args_;
}

void interrupt_t::type(std::string v)
{
    type_ = v;
}

void interrupt_t::args(json_object* v)
{
    args_ = v;
}

int interrupt_t::apply(afb_request* req, const role_t& role)
{
    /*if (type_ == "mute")
    {
    }
    else if (type_ == "continue")
    {
    }
    else if (type_ == "cancel")
    {
    }
    else */if (type_ == "ramp")
    {
        for(const auto& r: ahl_binding_t::instance().roles())
        {
            if (r.opened() && role.priority() > r.priority())
            {
                // { "ramp" : { "uid" : "ramp-slow", "volume" : 30 } }
                json_object* arg = json_object_new_object();
                json_object_object_add(arg, "ramp", args_);
                json_object_get(args_);
                json_object* result = nullptr;

                AFB_DYNAPI_DEBUG(ahl_binding_t::instance().handle(),
                    "Call '%s'/'%s' '%s'",
                    r.hal().c_str(), r.stream().c_str(), json_object_to_json_string(arg));

                if(afb_dynapi_call_sync(ahl_binding_t::instance().handle(), r.hal().c_str(), r.stream().c_str(), arg, &result))
                {
                    afb_request_fail(req, "Failed to call 'ramp' action on stream", nullptr);
                    return -1;
                }
                json_object* response = nullptr;
                json_object* jvolold = nullptr;
                if (json_object_object_get_ex(result, "response", &response))
                {
                    if (json_object_object_get_ex(response, "volold", &jvolold))
                    {
                        applied_on_.push_back(std::make_tuple<std::string, int>(r.uid(), json_object_get_int(jvolold)));
                        AFB_DYNAPI_DEBUG(ahl_binding_t::instance().handle(),
                            "POLICY: Applying a ramp to '%s' stream because '%s' is opened and have higher priority!",
                            r.stream().c_str(), role.stream().c_str());
                    }
                }
            }
        }
        return 0;
    }
    else
    {
        afb_request_fail(req, "Unkown interrupt uid!", nullptr);
        return -1;
    }
}

void interrupt_t::clear()
{
    for (const std::tuple<std::string, int>& state : applied_on_)
    {
        std::string role;
        int vol;
        std::tie(role, vol) = state;
        /*if (type_ == "mute")
        {
        }
        else if (type_ == "continue")
        {
        }
        else if (type_ == "cancel")
        {
        }
        else */if (type_ == "ramp")
        {
            for(const auto& r: ahl_binding_t::instance().roles())
            {
                if (r.uid() == role)
                {
                    // { "ramp" : { "uid" : "ramp-slow", "volume" : 30 } }
                    // Create an fake-interrupt, with the old volume
                    json_object* interrupt = json_tokener_parse(json_object_to_json_string(args_));
                    json_object_object_add(interrupt, "volume", json_object_new_int(vol)); // Replace the volume
                    /*
                    json_object* volume = nullptr;
                    if (json_object_object_get_ex(interrupt, "volume", &volume))
                    {
                        json_object_set_int(volume, vol);
                    }
                    */

                    json_object* arg = json_object_new_object();
                    json_object_object_add(arg, "ramp", interrupt);
                    json_object* result = nullptr;

                    AFB_DYNAPI_DEBUG(ahl_binding_t::instance().handle(),
                        "Call '%s'/'%s' '%s",
                        r.hal().c_str(), r.stream().c_str(), json_object_to_json_string(arg));

                    if(afb_dynapi_call_sync(ahl_binding_t::instance().handle(), r.hal().c_str(), r.stream().c_str(), arg, &result))
                    {
                        AFB_DYNAPI_ERROR(ahl_binding_t::instance().handle(),
                            "Failed to call 'ramp' action on '%s'", role.c_str());
                    }
                    else
                    {
                        AFB_DYNAPI_DEBUG(ahl_binding_t::instance().handle(),
                            "Called 'ramp' action on '%s'", role.c_str());
                    }
                }
            }
        }
    }
    applied_on_.clear();
}
