# 4a-tools

This repository contains tools, scripts and data to test the 4A stack (Advanced AGL Audio Architecture).

4A is related to [AGL project](https://www.automotivelinux.org/)

## References

### Presentation

* [4a-proposal-Feb18]
* [4a-roadmap-Apr18]
* [4a-HALs-by-fiberdyne]
* [4a-presentation-by-audiokinetics]

### 4A repositories

Repositories related to 4A:

* [agl-service-audio-4a]: high level API providing simple, unified entry point for all AGL audio applications
* [4a-hal-generic]: HAL manager and default HALs (hardware abstraction layers)
* [4a-alsa-core]: low level binding to wrap ALSA core operations
* [4a-softmixer]: reference software mixer using ALSA snd-aloop driver and a user space mixer
* [apps/mixer]: Mixer Application

[4a-alsa-core]:https://git.automotivelinux.org/src/4a-alsa-core/
[4a-hal-generic]:https://github.com/iotbzh/4a-hal-generic
[4a-softmixer]:https://github.com/iotbzh/4a-softmixer
[agl-service-audio-4a]:https://git.automotivelinux.org/apps/agl-service-audio-4a/
[apps/mixer]:https://git.automotivelinux.org/apps/mixer/

[4a-proposal-Feb18]:https://iot.bzh/en/publications/32-2018/67-agl-audio-advanced-architecture
[4a-roadmap-Apr18]:https://iot.bzh/en/publications/32-2018/73-iotbzh-agl-4a-audio-roadmap-apr-18
[4a-HALs-by-fiberdyne]:https://wiki.automotivelinux.org/_media/agl-distro/201804_aglf2f_fddsp-4a-audio-hal.pptx
[4a-presentation-by-audiokinetics]:https://schd.ws/hosted_files/aglammeu17/aa/HighLevelAudio_DresdenAMM_Final_0.pdf
	
