# NFC Service

## Overview

NFC service uses neard package to detect the presence of NFC tags and signal clients via an event.
The presence event shall include a dictionary named "record" that contains entries with a "Type"
field and a value field named after the "Type" value.

## Verbs

| Name               | Description                          | JSON Parameters                                                        |
|--------------------|:-------------------------------------|:-----------------------------------------------------------------------|
| subscribe          | subscribe to NFC events              | *Request:* {"value": "presence"}                                       |
| unsubscribe        | unsubscribe to NFC events            | *Request:* {"value": "presence"}                                       |

## Events
### neard response

| Name               | Description                          | JSON Response                                                          |
|--------------------|:-------------------------------------|:-----------------------------------------------------------------------|
| presence           | event that reports NFC tag presence  |  *Response:* {"status": "detected",                                    |
|                    |                                      |      "record": { "Type": "URI", "URI": "http://www.nfc-forum.com" } }  |
