Building AVIRT
===================================

## Table of Contents

1. [Introduction](#intro)
2. [Out of Tree](#out-of-tree)
3. [In Tree](#in-tree)

<a name="intro"/>

## Introduction

The AVIRT module and submodules can be built using a variety of methods. There are Visual Code build tasks for in and out of tree builds, make file support for CLI building (both in and out of tree), and xds build support.

<a name="out-of-tree"/>

## Out Of Tree

### Building with CLI

To build both AVIRT and the additional Audio Paths out-of-tree, use the following command:

```sh
$ make
```

or

```sh
$ CONFIG_AVIRT=m CONFIG_AVIRT_BUILDLOCAL=y CONFIG_AVIRT_AP_DUMMY=m CONFIG_AVIRT_AP_LOOPBACK=m make -C /lib/modules/$(uname -r)/build/ M=$(pwd)
```

The latter is executed internally with the make file.

### Building with XDS SDK

To build both AVIRT and the dummy Audio Path out-of-tree for [AGL](http://docs.automotivelinux.org/) (`aarch64` currently supported), use the [XDS](http://docs.automotivelinux.org/docs/devguides/en/dev/reference/xds/part-1/0_Abstract.html) build system together with the `make_agl.sh` script:

```sh
$ ./make_agl.sh ${XDS_SDK_ID}
```

<a name="in-tree"/>

## In tree

The kernal modules can be built in tree, dependent on the avirt repository being located in drivers/staging - If using your own fork of the linux kernel, you will need to update the staging Makefiles and Kconfigs accordingly.

To build in tree, use the [Fiberdyne Linux fork](https://github.com/fiberdyne/linux), which will automatically clone the AVIRT Driver and required AudioPath modules to the `drivers/staging` directory. You can then turn AVIRT Support on by setting to `<M>`. The drivers can be found here:

```
$ make menuconfig

# Navigate to: Device Drivers--->Staging Drivers--->AVIRT Support
```

Finally build the kernel with the configuration selected by making.

```
$ make
```
