/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <valacodegen.h>
#include <version.h>
#include <config.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};


static gpointer vala_compiler_parent_class = NULL;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_shared_library;
static gchar* vala_compiler_shared_library = NULL;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources = NULL;
static gchar** vala_compiler_gresources_directories;
static gchar** vala_compiler_gresources_directories = NULL;
static gboolean vala_compiler_ccode_only;
static gboolean vala_compiler_ccode_only = FALSE;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_thread;
static gboolean vala_compiler_thread = FALSE;
static gboolean vala_compiler_mem_profiler;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_since_check;
static gboolean vala_compiler_disable_since_check = FALSE;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_disable_warnings = FALSE;
static gchar* vala_compiler_cc_command;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_diagnostic_colors;
static gboolean vala_compiler_disable_diagnostic_colors = FALSE;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_entry_point;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;

G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance);
G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value, gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value, gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_compiler_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_COMPILER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COMPILER, ValaCompilerPrivate))
enum  {
	VALA_COMPILER_DUMMY_PROPERTY
};
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gint vala_compiler_run_source (gchar** args, int args_length1);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status);
static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self);
static gint vala_compiler_main (gchar** args, int args_length1);
static void vala_compiler_finalize (ValaCompiler * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[57] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"shared-library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_shared_library, "Shared library name used in generated gir", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Change output directory from current working directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_thread, "Enable multithreading support (DEPRECATED AND IGNORED)", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"disable-since-check", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_since_check, "Do not check whether used symbols exist in local packages", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_diagnostic_colors, "Disable colored output", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"gresourcesdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources_directories, "Look for resources in DIRECTORY", "DIRECTORY..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static gint vala_compiler_quit (ValaCompiler* self) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gint _tmp4_;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_;
	ValaReport* _tmp11_;
	ValaReport* _tmp12_;
	gint _tmp13_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_report_get_errors (_tmp3_);
	if (_tmp4_ == 0) {
		ValaCodeContext* _tmp5_;
		ValaReport* _tmp6_;
		ValaReport* _tmp7_;
		gint _tmp8_;
		_tmp5_ = self->priv->context;
		_tmp6_ = vala_code_context_get_report (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_report_get_warnings (_tmp7_);
		_tmp0_ = _tmp8_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp10_ = self->priv->context;
	_tmp11_ = vala_code_context_get_report (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_report_get_errors (_tmp12_);
	if (_tmp13_ == 0) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		_tmp15_ = vala_compiler_fatal_warnings;
		if (!_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			ValaCodeContext* _tmp16_;
			ValaReport* _tmp17_;
			ValaReport* _tmp18_;
			gint _tmp19_;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_report_get_warnings (_tmp18_);
			_tmp14_ = _tmp19_ == 0;
		}
		_tmp9_ = _tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp20_;
		_tmp20_ = vala_compiler_quiet_mode;
		if (!_tmp20_) {
			FILE* _tmp21_;
			ValaCodeContext* _tmp22_;
			ValaReport* _tmp23_;
			ValaReport* _tmp24_;
			gint _tmp25_;
			_tmp21_ = stdout;
			_tmp22_ = self->priv->context;
			_tmp23_ = vala_code_context_get_report (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_report_get_warnings (_tmp24_);
			fprintf (_tmp21_, "Compilation succeeded - %d warning(s)\n", _tmp25_);
		}
		result = 0;
		return result;
	} else {
		gboolean _tmp26_;
		_tmp26_ = vala_compiler_quiet_mode;
		if (!_tmp26_) {
			FILE* _tmp27_;
			ValaCodeContext* _tmp28_;
			ValaReport* _tmp29_;
			ValaReport* _tmp30_;
			gint _tmp31_;
			ValaCodeContext* _tmp32_;
			ValaReport* _tmp33_;
			ValaReport* _tmp34_;
			gint _tmp35_;
			_tmp27_ = stdout;
			_tmp28_ = self->priv->context;
			_tmp29_ = vala_code_context_get_report (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_report_get_errors (_tmp30_);
			_tmp32_ = self->priv->context;
			_tmp33_ = vala_code_context_get_report (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_report_get_warnings (_tmp34_);
			fprintf (_tmp27_, "Compilation failed: %d error(s), %d warning(s)\n", _tmp31_, _tmp35_);
		}
		result = 1;
		return result;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gint vala_compiler_run (ValaCompiler* self) {
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	ValaCodeContext* _tmp29_;
	gboolean _tmp30_;
	ValaCodeContext* _tmp31_;
	gboolean _tmp32_;
	ValaCodeContext* _tmp33_;
	gboolean _tmp34_;
	ValaCodeContext* _tmp35_;
	gboolean _tmp36_;
	ValaCodeContext* _tmp37_;
	gboolean _tmp38_;
	ValaCodeContext* _tmp39_;
	gboolean _tmp40_;
	ValaCodeContext* _tmp41_;
	gboolean _tmp42_;
	ValaCodeContext* _tmp43_;
	gboolean _tmp44_;
	ValaCodeContext* _tmp45_;
	ValaReport* _tmp46_;
	ValaReport* _tmp47_;
	gboolean _tmp48_;
	ValaCodeContext* _tmp49_;
	ValaReport* _tmp50_;
	ValaReport* _tmp51_;
	gboolean _tmp52_;
	ValaCodeContext* _tmp53_;
	gboolean _tmp54_;
	ValaCodeContext* _tmp55_;
	gboolean _tmp56_;
	ValaCodeContext* _tmp57_;
	gboolean _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_;
	ValaCodeContext* _tmp62_;
	gboolean _tmp63_;
	ValaCodeContext* _tmp64_;
	const gchar* _tmp65_;
	gboolean _tmp66_ = FALSE;
	const gchar* _tmp67_;
	ValaCodeContext* _tmp69_;
	gboolean _tmp70_;
	ValaCodeContext* _tmp71_;
	const gchar* _tmp72_;
	ValaCodeContext* _tmp73_;
	const gchar* _tmp74_;
	ValaCodeContext* _tmp75_;
	const gchar* _tmp76_;
	ValaCodeContext* _tmp77_;
	const gchar* _tmp78_;
	gboolean _tmp79_ = FALSE;
	const gchar* _tmp80_;
	const gchar* _tmp82_;
	const gchar* _tmp90_;
	ValaCodeContext* _tmp99_;
	gchar** _tmp100_;
	gint _tmp100__length1;
	gchar** _tmp101_;
	gint _tmp101__length1;
	ValaCodeContext* _tmp102_;
	gboolean _tmp103_;
	ValaCodeContext* _tmp104_;
	gchar** _tmp105_;
	gint _tmp105__length1;
	gchar** _tmp106_;
	gint _tmp106__length1;
	ValaCodeContext* _tmp107_;
	gchar** _tmp108_;
	gint _tmp108__length1;
	gchar** _tmp109_;
	gint _tmp109__length1;
	ValaCodeContext* _tmp110_;
	gboolean _tmp111_;
	ValaCodeContext* _tmp112_;
	gboolean _tmp113_;
	ValaCodeContext* _tmp114_;
	gboolean _tmp115_;
	gboolean _tmp116_ = FALSE;
	gboolean _tmp117_;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp120_ = FALSE;
	const gchar* _tmp121_;
	gboolean _tmp129_;
	const gchar* _tmp130_;
	ValaCodeContext* _tmp131_;
	gboolean _tmp132_;
	ValaCodeContext* _tmp133_;
	const gchar* _tmp134_;
	ValaCodeContext* _tmp135_;
	gboolean _tmp136_;
	gchar** _tmp137_;
	gint _tmp137__length1;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp149_ = FALSE;
	const gchar* _tmp150_;
	ValaCodeContext* _tmp153_;
	gint _tmp154_;
	ValaCodeContext* _tmp155_;
	gint _tmp156_;
	ValaCodeContext* _tmp157_;
	gint _tmp158_;
	gint _tmp159_;
	gboolean _tmp168_;
	gchar** _tmp171_;
	gint _tmp171__length1;
	gchar** _tmp176_;
	gint _tmp176__length1;
	ValaCodeContext* _tmp187_;
	gchar** _tmp188_;
	gint _tmp188__length1;
	gchar** _tmp189_;
	gint _tmp189__length1;
	ValaCodeContext* _tmp190_;
	gchar** _tmp191_;
	gint _tmp191__length1;
	gchar** _tmp192_;
	gint _tmp192__length1;
	gboolean _tmp193_ = FALSE;
	ValaCodeContext* _tmp194_;
	ValaReport* _tmp195_;
	ValaReport* _tmp196_;
	gint _tmp197_;
	ValaCodeContext* _tmp205_;
	ValaGDBusServerModule* _tmp206_;
	ValaGDBusServerModule* _tmp207_;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp208_;
	gint _tmp208__length1;
	gboolean _tmp218_ = FALSE;
	gboolean _tmp219_;
	gboolean _tmp223_ = FALSE;
	ValaCodeContext* _tmp224_;
	ValaReport* _tmp225_;
	ValaReport* _tmp226_;
	gint _tmp227_;
	ValaParser* parser = NULL;
	ValaParser* _tmp235_;
	ValaParser* _tmp236_;
	ValaCodeContext* _tmp237_;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp238_;
	ValaGenieParser* _tmp239_;
	ValaCodeContext* _tmp240_;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp241_;
	ValaGirParser* _tmp242_;
	ValaCodeContext* _tmp243_;
	gboolean _tmp244_ = FALSE;
	ValaCodeContext* _tmp245_;
	ValaReport* _tmp246_;
	ValaReport* _tmp247_;
	gint _tmp248_;
	const gchar* _tmp256_;
	ValaCodeContext* _tmp262_;
	gboolean _tmp263_ = FALSE;
	ValaCodeContext* _tmp264_;
	ValaReport* _tmp265_;
	ValaReport* _tmp266_;
	gint _tmp267_;
	gboolean _tmp275_ = FALSE;
	gboolean _tmp276_ = FALSE;
	gboolean _tmp277_;
	const gchar* _tmp285_;
	gboolean _tmp290_ = FALSE;
	ValaCodeContext* _tmp291_;
	ValaReport* _tmp292_;
	ValaReport* _tmp293_;
	gint _tmp294_;
	ValaCodeContext* _tmp302_;
	ValaCodeGenerator* _tmp303_;
	ValaCodeGenerator* _tmp304_;
	ValaCodeContext* _tmp305_;
	gboolean _tmp306_ = FALSE;
	ValaCodeContext* _tmp307_;
	ValaReport* _tmp308_;
	ValaReport* _tmp309_;
	gint _tmp310_;
	gboolean _tmp318_ = FALSE;
	const gchar* _tmp319_;
	const gchar* _tmp323_;
	const gchar* _tmp376_;
	const gchar* _tmp390_;
	const gchar* _tmp413_;
	gboolean _tmp416_ = FALSE;
	ValaCodeContext* _tmp417_;
	ValaReport* _tmp418_;
	ValaReport* _tmp419_;
	gint _tmp420_;
	gboolean _tmp428_;
	gint _tmp452_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = vala_compiler_disable_diagnostic_colors;
	if (_tmp2_ == FALSE) {
		const gchar* env_colors = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp3_;
		_tmp4_ = env_colors;
		if (_tmp4_ != NULL) {
			ValaCodeContext* _tmp5_;
			ValaReport* _tmp6_;
			ValaReport* _tmp7_;
			const gchar* _tmp8_;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_report (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = env_colors;
			vala_report_set_colors (_tmp7_, _tmp8_);
		} else {
			ValaCodeContext* _tmp9_;
			ValaReport* _tmp10_;
			ValaReport* _tmp11_;
			_tmp9_ = self->priv->context;
			_tmp10_ = vala_code_context_get_report (_tmp9_);
			_tmp11_ = _tmp10_;
			vala_report_set_colors (_tmp11_, VALA_COMPILER_DEFAULT_COLORS);
		}
	}
	_tmp14_ = vala_compiler_ccode_only;
	if (!_tmp14_) {
		gboolean _tmp15_;
		_tmp15_ = vala_compiler_compile_only;
		_tmp13_ = !_tmp15_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		const gchar* _tmp16_;
		_tmp16_ = vala_compiler_output;
		_tmp12_ = _tmp16_ == NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		gint _tmp19_;
		_tmp17_ = vala_compiler_sources;
		_tmp17__length1 = _vala_array_length (vala_compiler_sources);
		_tmp18_ = _tmp17_[0];
		_tmp19_ = string_last_index_of_char (_tmp18_, (gunichar) '.', 0);
		if (_tmp19_ != -1) {
			gint dot = 0;
			gchar** _tmp20_;
			gint _tmp20__length1;
			const gchar* _tmp21_;
			gint _tmp22_;
			gchar** _tmp23_;
			gint _tmp23__length1;
			const gchar* _tmp24_;
			gint _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp20_ = vala_compiler_sources;
			_tmp20__length1 = _vala_array_length (vala_compiler_sources);
			_tmp21_ = _tmp20_[0];
			_tmp22_ = string_last_index_of_char (_tmp21_, (gunichar) '.', 0);
			dot = _tmp22_;
			_tmp23_ = vala_compiler_sources;
			_tmp23__length1 = _vala_array_length (vala_compiler_sources);
			_tmp24_ = _tmp23_[0];
			_tmp25_ = dot;
			_tmp26_ = string_substring (_tmp24_, (glong) 0, (glong) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_path_get_basename (_tmp27_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp28_;
			_g_free0 (_tmp27_);
		}
	}
	_tmp29_ = self->priv->context;
	_tmp30_ = vala_compiler_disable_assert;
	vala_code_context_set_assert (_tmp29_, !_tmp30_);
	_tmp31_ = self->priv->context;
	_tmp32_ = vala_compiler_enable_checking;
	vala_code_context_set_checking (_tmp31_, _tmp32_);
	_tmp33_ = self->priv->context;
	_tmp34_ = vala_compiler_deprecated;
	vala_code_context_set_deprecated (_tmp33_, _tmp34_);
	_tmp35_ = self->priv->context;
	_tmp36_ = vala_compiler_disable_since_check;
	vala_code_context_set_since_check (_tmp35_, !_tmp36_);
	_tmp37_ = self->priv->context;
	_tmp38_ = vala_compiler_hide_internal;
	vala_code_context_set_hide_internal (_tmp37_, _tmp38_);
	_tmp39_ = self->priv->context;
	_tmp40_ = vala_compiler_experimental;
	vala_code_context_set_experimental (_tmp39_, _tmp40_);
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_compiler_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp41_, _tmp42_);
	_tmp43_ = self->priv->context;
	_tmp44_ = vala_compiler_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp43_, _tmp44_);
	_tmp45_ = self->priv->context;
	_tmp46_ = vala_code_context_get_report (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_compiler_disable_warnings;
	vala_report_set_enable_warnings (_tmp47_, !_tmp48_);
	_tmp49_ = self->priv->context;
	_tmp50_ = vala_code_context_get_report (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_compiler_quiet_mode;
	vala_report_set_verbose_errors (_tmp51_, !_tmp52_);
	_tmp53_ = self->priv->context;
	_tmp54_ = vala_compiler_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp53_, _tmp54_);
	_tmp55_ = self->priv->context;
	_tmp56_ = vala_compiler_disable_version_header;
	vala_code_context_set_version_header (_tmp55_, !_tmp56_);
	_tmp57_ = self->priv->context;
	_tmp58_ = vala_compiler_ccode_only;
	vala_code_context_set_ccode_only (_tmp57_, _tmp58_);
	_tmp60_ = vala_compiler_ccode_only;
	if (_tmp60_) {
		gchar** _tmp61_;
		gint _tmp61__length1;
		_tmp61_ = vala_compiler_cc_options;
		_tmp61__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp59_ = _tmp61_ != NULL;
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp62_ = self->priv->context;
	_tmp63_ = vala_compiler_compile_only;
	vala_code_context_set_compile_only (_tmp62_, _tmp63_);
	_tmp64_ = self->priv->context;
	_tmp65_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp64_, _tmp65_);
	_tmp67_ = vala_compiler_header_filename;
	if (_tmp67_ == NULL) {
		gboolean _tmp68_;
		_tmp68_ = vala_compiler_use_header;
		_tmp66_ = _tmp68_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp69_ = self->priv->context;
	_tmp70_ = vala_compiler_use_header;
	vala_code_context_set_use_header (_tmp69_, _tmp70_);
	_tmp71_ = self->priv->context;
	_tmp72_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp71_, _tmp72_);
	_tmp73_ = self->priv->context;
	_tmp74_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp73_, _tmp74_);
	_tmp75_ = self->priv->context;
	_tmp76_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp75_, _tmp76_);
	_tmp77_ = self->priv->context;
	_tmp78_ = vala_compiler_output;
	vala_code_context_set_output (_tmp77_, _tmp78_);
	_tmp80_ = vala_compiler_output;
	if (_tmp80_ != NULL) {
		gboolean _tmp81_;
		_tmp81_ = vala_compiler_ccode_only;
		_tmp79_ = _tmp81_;
	} else {
		_tmp79_ = FALSE;
	}
	if (_tmp79_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp82_ = vala_compiler_basedir;
	if (_tmp82_ == NULL) {
		ValaCodeContext* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		_tmp83_ = self->priv->context;
		_tmp84_ = vala_code_context_realpath (".");
		_tmp85_ = _tmp84_;
		vala_code_context_set_basedir (_tmp83_, _tmp85_);
		_g_free0 (_tmp85_);
	} else {
		ValaCodeContext* _tmp86_;
		const gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		_tmp86_ = self->priv->context;
		_tmp87_ = vala_compiler_basedir;
		_tmp88_ = vala_code_context_realpath (_tmp87_);
		_tmp89_ = _tmp88_;
		vala_code_context_set_basedir (_tmp86_, _tmp89_);
		_g_free0 (_tmp89_);
	}
	_tmp90_ = vala_compiler_directory;
	if (_tmp90_ != NULL) {
		ValaCodeContext* _tmp91_;
		const gchar* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		_tmp91_ = self->priv->context;
		_tmp92_ = vala_compiler_directory;
		_tmp93_ = vala_code_context_realpath (_tmp92_);
		_tmp94_ = _tmp93_;
		vala_code_context_set_directory (_tmp91_, _tmp94_);
		_g_free0 (_tmp94_);
	} else {
		ValaCodeContext* _tmp95_;
		ValaCodeContext* _tmp96_;
		const gchar* _tmp97_;
		const gchar* _tmp98_;
		_tmp95_ = self->priv->context;
		_tmp96_ = self->priv->context;
		_tmp97_ = vala_code_context_get_basedir (_tmp96_);
		_tmp98_ = _tmp97_;
		vala_code_context_set_directory (_tmp95_, _tmp98_);
	}
	_tmp99_ = self->priv->context;
	_tmp100_ = vala_compiler_vapi_directories;
	_tmp100__length1 = _vala_array_length (vala_compiler_vapi_directories);
	_tmp101_ = (_tmp100_ != NULL) ? _vala_array_dup1 (_tmp100_, _tmp100__length1) : ((gpointer) _tmp100_);
	_tmp101__length1 = _tmp100__length1;
	_tmp99_->vapi_directories = (_vala_array_free (_tmp99_->vapi_directories, _tmp99_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp99_->vapi_directories = _tmp101_;
	_tmp99_->vapi_directories_length1 = _tmp101__length1;
	_tmp102_ = self->priv->context;
	_tmp103_ = vala_compiler_vapi_comments;
	vala_code_context_set_vapi_comments (_tmp102_, _tmp103_);
	_tmp104_ = self->priv->context;
	_tmp105_ = vala_compiler_gir_directories;
	_tmp105__length1 = _vala_array_length (vala_compiler_gir_directories);
	_tmp106_ = (_tmp105_ != NULL) ? _vala_array_dup2 (_tmp105_, _tmp105__length1) : ((gpointer) _tmp105_);
	_tmp106__length1 = _tmp105__length1;
	_tmp104_->gir_directories = (_vala_array_free (_tmp104_->gir_directories, _tmp104_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp104_->gir_directories = _tmp106_;
	_tmp104_->gir_directories_length1 = _tmp106__length1;
	_tmp107_ = self->priv->context;
	_tmp108_ = vala_compiler_metadata_directories;
	_tmp108__length1 = _vala_array_length (vala_compiler_metadata_directories);
	_tmp109_ = (_tmp108_ != NULL) ? _vala_array_dup3 (_tmp108_, _tmp108__length1) : ((gpointer) _tmp108_);
	_tmp109__length1 = _tmp108__length1;
	_tmp107_->metadata_directories = (_vala_array_free (_tmp107_->metadata_directories, _tmp107_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp107_->metadata_directories = _tmp109_;
	_tmp107_->metadata_directories_length1 = _tmp109__length1;
	_tmp110_ = self->priv->context;
	_tmp111_ = vala_compiler_debug;
	vala_code_context_set_debug (_tmp110_, _tmp111_);
	_tmp112_ = self->priv->context;
	_tmp113_ = vala_compiler_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp112_, _tmp113_);
	_tmp114_ = self->priv->context;
	_tmp115_ = vala_compiler_save_temps;
	vala_code_context_set_save_temps (_tmp114_, _tmp115_);
	_tmp117_ = vala_compiler_ccode_only;
	if (_tmp117_) {
		gboolean _tmp118_;
		_tmp118_ = vala_compiler_save_temps;
		_tmp116_ = _tmp118_;
	} else {
		_tmp116_ = FALSE;
	}
	if (_tmp116_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp121_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp121_, "gobject-2.0") == 0) {
		_tmp120_ = TRUE;
	} else {
		const gchar* _tmp122_;
		_tmp122_ = vala_compiler_profile;
		_tmp120_ = g_strcmp0 (_tmp122_, "gobject") == 0;
	}
	if (_tmp120_) {
		_tmp119_ = TRUE;
	} else {
		const gchar* _tmp123_;
		_tmp123_ = vala_compiler_profile;
		_tmp119_ = _tmp123_ == NULL;
	}
	if (_tmp119_) {
		ValaCodeContext* _tmp124_;
		ValaCodeContext* _tmp125_;
		_tmp124_ = self->priv->context;
		vala_code_context_set_profile (_tmp124_, VALA_PROFILE_GOBJECT);
		_tmp125_ = self->priv->context;
		vala_code_context_add_define (_tmp125_, "GOBJECT");
	} else {
		const gchar* _tmp126_;
		gchar* _tmp127_;
		gchar* _tmp128_;
		_tmp126_ = vala_compiler_profile;
		_tmp127_ = g_strdup_printf ("Unknown profile %s", _tmp126_);
		_tmp128_ = _tmp127_;
		vala_report_error (NULL, _tmp128_);
		_g_free0 (_tmp128_);
	}
	_tmp129_ = vala_compiler_nostdpkg;
	_tmp130_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = _tmp129_ | (_tmp130_ != NULL);
	_tmp131_ = self->priv->context;
	_tmp132_ = vala_compiler_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp131_, _tmp132_);
	_tmp133_ = self->priv->context;
	_tmp134_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp133_, _tmp134_);
	_tmp135_ = self->priv->context;
	_tmp136_ = vala_compiler_run_output;
	vala_code_context_set_run_output (_tmp135_, _tmp136_);
	_tmp137_ = vala_compiler_defines;
	_tmp137__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp137_ != NULL) {
		gchar** _tmp138_;
		gint _tmp138__length1;
		_tmp138_ = vala_compiler_defines;
		_tmp138__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp138_;
			define_collection_length1 = _tmp138__length1;
			for (define_it = 0; define_it < _tmp138__length1; define_it = define_it + 1) {
				gchar* _tmp139_;
				gchar* define = NULL;
				_tmp139_ = g_strdup (define_collection[define_it]);
				define = _tmp139_;
				{
					ValaCodeContext* _tmp140_;
					const gchar* _tmp141_;
					_tmp140_ = self->priv->context;
					_tmp141_ = define;
					vala_code_context_add_define (_tmp140_, _tmp141_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp142_ = FALSE;
			_tmp142_ = TRUE;
			while (TRUE) {
				gint _tmp144_;
				ValaCodeContext* _tmp145_;
				gint _tmp146_;
				gchar* _tmp147_;
				gchar* _tmp148_;
				if (!_tmp142_) {
					gint _tmp143_;
					_tmp143_ = i;
					i = _tmp143_ + 2;
				}
				_tmp142_ = FALSE;
				_tmp144_ = i;
				if (!(_tmp144_ <= 36)) {
					break;
				}
				_tmp145_ = self->priv->context;
				_tmp146_ = i;
				_tmp147_ = g_strdup_printf ("VALA_0_%d", _tmp146_);
				_tmp148_ = _tmp147_;
				vala_code_context_add_define (_tmp145_, _tmp148_);
				_g_free0 (_tmp148_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 32;
	_tmp150_ = vala_compiler_target_glib;
	if (_tmp150_ != NULL) {
		const gchar* _tmp151_;
		gint _tmp152_;
		_tmp151_ = vala_compiler_target_glib;
		_tmp152_ = sscanf (_tmp151_, "%d.%d", &glib_major, &glib_minor);
		_tmp149_ = _tmp152_ != 2;
	} else {
		_tmp149_ = FALSE;
	}
	if (_tmp149_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp153_ = self->priv->context;
	_tmp154_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp153_, _tmp154_);
	_tmp155_ = self->priv->context;
	_tmp156_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp155_, _tmp156_);
	_tmp157_ = self->priv->context;
	_tmp158_ = vala_code_context_get_target_glib_major (_tmp157_);
	_tmp159_ = _tmp158_;
	if (_tmp159_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp160_ = FALSE;
			_tmp160_ = TRUE;
			while (TRUE) {
				gint _tmp162_;
				gint _tmp163_;
				ValaCodeContext* _tmp164_;
				gint _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				if (!_tmp160_) {
					gint _tmp161_;
					_tmp161_ = i;
					i = _tmp161_ + 2;
				}
				_tmp160_ = FALSE;
				_tmp162_ = i;
				_tmp163_ = glib_minor;
				if (!(_tmp162_ <= _tmp163_)) {
					break;
				}
				_tmp164_ = self->priv->context;
				_tmp165_ = i;
				_tmp166_ = g_strdup_printf ("GLIB_2_%d", _tmp165_);
				_tmp167_ = _tmp166_;
				vala_code_context_add_define (_tmp164_, _tmp167_);
				_g_free0 (_tmp167_);
			}
		}
	}
	_tmp168_ = vala_compiler_nostdpkg;
	if (!_tmp168_) {
		ValaCodeContext* _tmp169_;
		ValaCodeContext* _tmp170_;
		_tmp169_ = self->priv->context;
		vala_code_context_add_external_package (_tmp169_, "glib-2.0");
		_tmp170_ = self->priv->context;
		vala_code_context_add_external_package (_tmp170_, "gobject-2.0");
	}
	_tmp171_ = vala_compiler_packages;
	_tmp171__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp171_ != NULL) {
		gchar** _tmp172_;
		gint _tmp172__length1;
		_tmp172_ = vala_compiler_packages;
		_tmp172__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp172_;
			package_collection_length1 = _tmp172__length1;
			for (package_it = 0; package_it < _tmp172__length1; package_it = package_it + 1) {
				gchar* _tmp173_;
				gchar* package = NULL;
				_tmp173_ = g_strdup (package_collection[package_it]);
				package = _tmp173_;
				{
					ValaCodeContext* _tmp174_;
					const gchar* _tmp175_;
					_tmp174_ = self->priv->context;
					_tmp175_ = package;
					vala_code_context_add_external_package (_tmp174_, _tmp175_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp176_ = vala_compiler_fast_vapis;
	_tmp176__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp176_ != NULL) {
		gchar** _tmp177_;
		gint _tmp177__length1;
		ValaCodeContext* _tmp186_;
		_tmp177_ = vala_compiler_fast_vapis;
		_tmp177__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp177_;
			vapi_collection_length1 = _tmp177__length1;
			for (vapi_it = 0; vapi_it < _tmp177__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp178_;
				gchar* vapi = NULL;
				_tmp178_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp178_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp179_;
					gchar* _tmp180_;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp181_;
					const gchar* _tmp182_;
					ValaSourceFile* _tmp183_;
					ValaCodeContext* _tmp184_;
					ValaSourceFile* _tmp185_;
					_tmp179_ = vapi;
					_tmp180_ = vala_code_context_realpath (_tmp179_);
					rpath = _tmp180_;
					_tmp181_ = self->priv->context;
					_tmp182_ = rpath;
					_tmp183_ = vala_source_file_new (_tmp181_, VALA_SOURCE_FILE_TYPE_FAST, _tmp182_, NULL, FALSE);
					source_file = _tmp183_;
					_tmp184_ = self->priv->context;
					_tmp185_ = source_file;
					vala_code_context_add_source_file (_tmp184_, _tmp185_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp186_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp186_, TRUE);
	}
	_tmp187_ = self->priv->context;
	_tmp188_ = vala_compiler_gresources;
	_tmp188__length1 = _vala_array_length (vala_compiler_gresources);
	_tmp189_ = (_tmp188_ != NULL) ? _vala_array_dup4 (_tmp188_, _tmp188__length1) : ((gpointer) _tmp188_);
	_tmp189__length1 = _tmp188__length1;
	_tmp187_->gresources = (_vala_array_free (_tmp187_->gresources, _tmp187_->gresources_length1, (GDestroyNotify) g_free), NULL);
	_tmp187_->gresources = _tmp189_;
	_tmp187_->gresources_length1 = _tmp189__length1;
	_tmp190_ = self->priv->context;
	_tmp191_ = vala_compiler_gresources_directories;
	_tmp191__length1 = _vala_array_length (vala_compiler_gresources_directories);
	_tmp192_ = (_tmp191_ != NULL) ? _vala_array_dup5 (_tmp191_, _tmp191__length1) : ((gpointer) _tmp191_);
	_tmp192__length1 = _tmp191__length1;
	_tmp190_->gresources_directories = (_vala_array_free (_tmp190_->gresources_directories, _tmp190_->gresources_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp190_->gresources_directories = _tmp192_;
	_tmp190_->gresources_directories_length1 = _tmp192__length1;
	_tmp194_ = self->priv->context;
	_tmp195_ = vala_code_context_get_report (_tmp194_);
	_tmp196_ = _tmp195_;
	_tmp197_ = vala_report_get_errors (_tmp196_);
	if (_tmp197_ > 0) {
		_tmp193_ = TRUE;
	} else {
		gboolean _tmp198_ = FALSE;
		gboolean _tmp199_;
		_tmp199_ = vala_compiler_fatal_warnings;
		if (_tmp199_) {
			ValaCodeContext* _tmp200_;
			ValaReport* _tmp201_;
			ValaReport* _tmp202_;
			gint _tmp203_;
			_tmp200_ = self->priv->context;
			_tmp201_ = vala_code_context_get_report (_tmp200_);
			_tmp202_ = _tmp201_;
			_tmp203_ = vala_report_get_warnings (_tmp202_);
			_tmp198_ = _tmp203_ > 0;
		} else {
			_tmp198_ = FALSE;
		}
		_tmp193_ = _tmp198_;
	}
	if (_tmp193_) {
		gint _tmp204_;
		_tmp204_ = vala_compiler_quit (self);
		result = _tmp204_;
		return result;
	}
	_tmp205_ = self->priv->context;
	_tmp206_ = vala_gd_bus_server_module_new ();
	_tmp207_ = _tmp206_;
	vala_code_context_set_codegen (_tmp205_, (ValaCodeGenerator*) _tmp207_);
	_vala_code_visitor_unref0 (_tmp207_);
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp208_ = vala_compiler_sources;
	_tmp208__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp208_;
		source_collection_length1 = _tmp208__length1;
		for (source_it = 0; source_it < _tmp208__length1; source_it = source_it + 1) {
			gchar* _tmp209_;
			gchar* source = NULL;
			_tmp209_ = g_strdup (source_collection[source_it]);
			source = _tmp209_;
			{
				ValaCodeContext* _tmp210_;
				const gchar* _tmp211_;
				gboolean _tmp212_;
				gboolean _tmp213_;
				_tmp210_ = self->priv->context;
				_tmp211_ = source;
				_tmp212_ = vala_compiler_run_output;
				_tmp213_ = vala_code_context_add_source_filename (_tmp210_, _tmp211_, _tmp212_, TRUE);
				if (_tmp213_) {
					const gchar* _tmp214_;
					gboolean _tmp215_;
					_tmp214_ = source;
					_tmp215_ = g_str_has_suffix (_tmp214_, ".c");
					if (_tmp215_) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp216_;
						gboolean _tmp217_;
						_tmp216_ = source;
						_tmp217_ = g_str_has_suffix (_tmp216_, ".h");
						if (_tmp217_) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	_tmp219_ = vala_compiler_ccode_only;
	if (_tmp219_) {
		gboolean _tmp220_ = FALSE;
		gboolean _tmp221_;
		_tmp221_ = has_c_files;
		if (_tmp221_) {
			_tmp220_ = TRUE;
		} else {
			gboolean _tmp222_;
			_tmp222_ = has_h_files;
			_tmp220_ = _tmp222_;
		}
		_tmp218_ = _tmp220_;
	} else {
		_tmp218_ = FALSE;
	}
	if (_tmp218_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp224_ = self->priv->context;
	_tmp225_ = vala_code_context_get_report (_tmp224_);
	_tmp226_ = _tmp225_;
	_tmp227_ = vala_report_get_errors (_tmp226_);
	if (_tmp227_ > 0) {
		_tmp223_ = TRUE;
	} else {
		gboolean _tmp228_ = FALSE;
		gboolean _tmp229_;
		_tmp229_ = vala_compiler_fatal_warnings;
		if (_tmp229_) {
			ValaCodeContext* _tmp230_;
			ValaReport* _tmp231_;
			ValaReport* _tmp232_;
			gint _tmp233_;
			_tmp230_ = self->priv->context;
			_tmp231_ = vala_code_context_get_report (_tmp230_);
			_tmp232_ = _tmp231_;
			_tmp233_ = vala_report_get_warnings (_tmp232_);
			_tmp228_ = _tmp233_ > 0;
		} else {
			_tmp228_ = FALSE;
		}
		_tmp223_ = _tmp228_;
	}
	if (_tmp223_) {
		gint _tmp234_;
		_tmp234_ = vala_compiler_quit (self);
		result = _tmp234_;
		return result;
	}
	_tmp235_ = vala_parser_new ();
	parser = _tmp235_;
	_tmp236_ = parser;
	_tmp237_ = self->priv->context;
	vala_parser_parse (_tmp236_, _tmp237_);
	_tmp238_ = vala_genie_parser_new ();
	genie_parser = _tmp238_;
	_tmp239_ = genie_parser;
	_tmp240_ = self->priv->context;
	vala_genie_parser_parse (_tmp239_, _tmp240_);
	_tmp241_ = vala_gir_parser_new ();
	gir_parser = _tmp241_;
	_tmp242_ = gir_parser;
	_tmp243_ = self->priv->context;
	vala_gir_parser_parse (_tmp242_, _tmp243_);
	_tmp245_ = self->priv->context;
	_tmp246_ = vala_code_context_get_report (_tmp245_);
	_tmp247_ = _tmp246_;
	_tmp248_ = vala_report_get_errors (_tmp247_);
	if (_tmp248_ > 0) {
		_tmp244_ = TRUE;
	} else {
		gboolean _tmp249_ = FALSE;
		gboolean _tmp250_;
		_tmp250_ = vala_compiler_fatal_warnings;
		if (_tmp250_) {
			ValaCodeContext* _tmp251_;
			ValaReport* _tmp252_;
			ValaReport* _tmp253_;
			gint _tmp254_;
			_tmp251_ = self->priv->context;
			_tmp252_ = vala_code_context_get_report (_tmp251_);
			_tmp253_ = _tmp252_;
			_tmp254_ = vala_report_get_warnings (_tmp253_);
			_tmp249_ = _tmp254_ > 0;
		} else {
			_tmp249_ = FALSE;
		}
		_tmp244_ = _tmp249_;
	}
	if (_tmp244_) {
		gint _tmp255_;
		_tmp255_ = vala_compiler_quit (self);
		result = _tmp255_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp256_ = vala_compiler_fast_vapi_filename;
	if (_tmp256_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp257_;
		ValaCodeWriter* _tmp258_;
		ValaCodeContext* _tmp259_;
		const gchar* _tmp260_;
		gint _tmp261_;
		_tmp257_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp257_;
		_tmp258_ = interface_writer;
		_tmp259_ = self->priv->context;
		_tmp260_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp258_, _tmp259_, _tmp260_);
		_tmp261_ = vala_compiler_quit (self);
		result = _tmp261_;
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp262_ = self->priv->context;
	vala_code_context_check (_tmp262_);
	_tmp264_ = self->priv->context;
	_tmp265_ = vala_code_context_get_report (_tmp264_);
	_tmp266_ = _tmp265_;
	_tmp267_ = vala_report_get_errors (_tmp266_);
	if (_tmp267_ > 0) {
		_tmp263_ = TRUE;
	} else {
		gboolean _tmp268_ = FALSE;
		gboolean _tmp269_;
		_tmp269_ = vala_compiler_fatal_warnings;
		if (_tmp269_) {
			ValaCodeContext* _tmp270_;
			ValaReport* _tmp271_;
			ValaReport* _tmp272_;
			gint _tmp273_;
			_tmp270_ = self->priv->context;
			_tmp271_ = vala_code_context_get_report (_tmp270_);
			_tmp272_ = _tmp271_;
			_tmp273_ = vala_report_get_warnings (_tmp272_);
			_tmp268_ = _tmp273_ > 0;
		} else {
			_tmp268_ = FALSE;
		}
		_tmp263_ = _tmp268_;
	}
	if (_tmp263_) {
		gint _tmp274_;
		_tmp274_ = vala_compiler_quit (self);
		result = _tmp274_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp277_ = vala_compiler_ccode_only;
	if (!_tmp277_) {
		gboolean _tmp278_;
		_tmp278_ = vala_compiler_compile_only;
		_tmp276_ = !_tmp278_;
	} else {
		_tmp276_ = FALSE;
	}
	if (_tmp276_) {
		const gchar* _tmp279_;
		_tmp279_ = vala_compiler_library;
		_tmp275_ = _tmp279_ == NULL;
	} else {
		_tmp275_ = FALSE;
	}
	if (_tmp275_) {
		gboolean _tmp280_ = FALSE;
		gboolean _tmp281_;
		_tmp281_ = has_c_files;
		if (!_tmp281_) {
			ValaCodeContext* _tmp282_;
			ValaMethod* _tmp283_;
			ValaMethod* _tmp284_;
			_tmp282_ = self->priv->context;
			_tmp283_ = vala_code_context_get_entry_point (_tmp282_);
			_tmp284_ = _tmp283_;
			_tmp280_ = _tmp284_ == NULL;
		} else {
			_tmp280_ = FALSE;
		}
		if (_tmp280_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp285_ = vala_compiler_dump_tree;
	if (_tmp285_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp286_;
		ValaCodeWriter* _tmp287_;
		ValaCodeContext* _tmp288_;
		const gchar* _tmp289_;
		_tmp286_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp286_;
		_tmp287_ = code_writer;
		_tmp288_ = self->priv->context;
		_tmp289_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp287_, _tmp288_, _tmp289_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp291_ = self->priv->context;
	_tmp292_ = vala_code_context_get_report (_tmp291_);
	_tmp293_ = _tmp292_;
	_tmp294_ = vala_report_get_errors (_tmp293_);
	if (_tmp294_ > 0) {
		_tmp290_ = TRUE;
	} else {
		gboolean _tmp295_ = FALSE;
		gboolean _tmp296_;
		_tmp296_ = vala_compiler_fatal_warnings;
		if (_tmp296_) {
			ValaCodeContext* _tmp297_;
			ValaReport* _tmp298_;
			ValaReport* _tmp299_;
			gint _tmp300_;
			_tmp297_ = self->priv->context;
			_tmp298_ = vala_code_context_get_report (_tmp297_);
			_tmp299_ = _tmp298_;
			_tmp300_ = vala_report_get_warnings (_tmp299_);
			_tmp295_ = _tmp300_ > 0;
		} else {
			_tmp295_ = FALSE;
		}
		_tmp290_ = _tmp295_;
	}
	if (_tmp290_) {
		gint _tmp301_;
		_tmp301_ = vala_compiler_quit (self);
		result = _tmp301_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp302_ = self->priv->context;
	_tmp303_ = vala_code_context_get_codegen (_tmp302_);
	_tmp304_ = _tmp303_;
	_tmp305_ = self->priv->context;
	vala_code_generator_emit (_tmp304_, _tmp305_);
	_tmp307_ = self->priv->context;
	_tmp308_ = vala_code_context_get_report (_tmp307_);
	_tmp309_ = _tmp308_;
	_tmp310_ = vala_report_get_errors (_tmp309_);
	if (_tmp310_ > 0) {
		_tmp306_ = TRUE;
	} else {
		gboolean _tmp311_ = FALSE;
		gboolean _tmp312_;
		_tmp312_ = vala_compiler_fatal_warnings;
		if (_tmp312_) {
			ValaCodeContext* _tmp313_;
			ValaReport* _tmp314_;
			ValaReport* _tmp315_;
			gint _tmp316_;
			_tmp313_ = self->priv->context;
			_tmp314_ = vala_code_context_get_report (_tmp313_);
			_tmp315_ = _tmp314_;
			_tmp316_ = vala_report_get_warnings (_tmp315_);
			_tmp311_ = _tmp316_ > 0;
		} else {
			_tmp311_ = FALSE;
		}
		_tmp306_ = _tmp311_;
	}
	if (_tmp306_) {
		gint _tmp317_;
		_tmp317_ = vala_compiler_quit (self);
		result = _tmp317_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp319_ = vala_compiler_vapi_filename;
	if (_tmp319_ == NULL) {
		const gchar* _tmp320_;
		_tmp320_ = vala_compiler_library;
		_tmp318_ = _tmp320_ != NULL;
	} else {
		_tmp318_ = FALSE;
	}
	if (_tmp318_) {
		const gchar* _tmp321_;
		gchar* _tmp322_;
		_tmp321_ = vala_compiler_library;
		_tmp322_ = g_strdup_printf ("%s.vapi", _tmp321_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp322_;
	}
	_tmp323_ = vala_compiler_library;
	if (_tmp323_ != NULL) {
		const gchar* _tmp324_;
		_tmp324_ = vala_compiler_gir;
		if (_tmp324_ != NULL) {
			gchar* gir_base = NULL;
			const gchar* _tmp325_;
			gchar* _tmp326_;
			glong gir_len = 0L;
			const gchar* _tmp327_;
			gint _tmp328_;
			gint _tmp329_;
			gint last_hyphen = 0;
			const gchar* _tmp330_;
			gint _tmp331_;
			gboolean _tmp332_ = FALSE;
			gint _tmp333_;
			_tmp325_ = vala_compiler_gir;
			_tmp326_ = g_path_get_basename (_tmp325_);
			gir_base = _tmp326_;
			_tmp327_ = gir_base;
			_tmp328_ = strlen (_tmp327_);
			_tmp329_ = _tmp328_;
			gir_len = (glong) _tmp329_;
			_tmp330_ = gir_base;
			_tmp331_ = string_last_index_of_char (_tmp330_, (gunichar) '-', 0);
			last_hyphen = _tmp331_;
			_tmp333_ = last_hyphen;
			if (_tmp333_ == -1) {
				_tmp332_ = TRUE;
			} else {
				const gchar* _tmp334_;
				gboolean _tmp335_;
				_tmp334_ = gir_base;
				_tmp335_ = g_str_has_suffix (_tmp334_, ".gir");
				_tmp332_ = !_tmp335_;
			}
			if (_tmp332_) {
				const gchar* _tmp336_;
				gchar* _tmp337_;
				gchar* _tmp338_;
				_tmp336_ = vala_compiler_gir;
				_tmp337_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp336_);
				_tmp338_ = _tmp337_;
				vala_report_error (NULL, _tmp338_);
				_g_free0 (_tmp338_);
			} else {
				gchar* gir_namespace = NULL;
				const gchar* _tmp339_;
				gint _tmp340_;
				gchar* _tmp341_;
				gchar* gir_version = NULL;
				const gchar* _tmp342_;
				gint _tmp343_;
				glong _tmp344_;
				gint _tmp345_;
				gchar* _tmp346_;
				const gchar* _tmp347_;
				gboolean _tmp348_ = FALSE;
				gboolean _tmp349_ = FALSE;
				gboolean _tmp350_ = FALSE;
				const gchar* _tmp351_;
				_tmp339_ = gir_base;
				_tmp340_ = last_hyphen;
				_tmp341_ = string_substring (_tmp339_, (glong) 0, (glong) _tmp340_);
				gir_namespace = _tmp341_;
				_tmp342_ = gir_base;
				_tmp343_ = last_hyphen;
				_tmp344_ = gir_len;
				_tmp345_ = last_hyphen;
				_tmp346_ = string_substring (_tmp342_, (glong) (_tmp343_ + 1), (_tmp344_ - _tmp345_) - 5);
				gir_version = _tmp346_;
				_tmp347_ = gir_version;
				g_strcanon (_tmp347_, "0123456789.", '?');
				_tmp351_ = gir_namespace;
				if (g_strcmp0 (_tmp351_, "") == 0) {
					_tmp350_ = TRUE;
				} else {
					const gchar* _tmp352_;
					_tmp352_ = gir_version;
					_tmp350_ = g_strcmp0 (_tmp352_, "") == 0;
				}
				if (_tmp350_) {
					_tmp349_ = TRUE;
				} else {
					const gchar* _tmp353_;
					gchar _tmp354_;
					gboolean _tmp355_;
					_tmp353_ = gir_version;
					_tmp354_ = string_get (_tmp353_, (glong) 0);
					_tmp355_ = g_ascii_isdigit (_tmp354_);
					_tmp349_ = !_tmp355_;
				}
				if (_tmp349_) {
					_tmp348_ = TRUE;
				} else {
					const gchar* _tmp356_;
					gboolean _tmp357_;
					_tmp356_ = gir_version;
					_tmp357_ = string_contains (_tmp356_, "?");
					_tmp348_ = _tmp357_;
				}
				if (_tmp348_) {
					const gchar* _tmp358_;
					gchar* _tmp359_;
					gchar* _tmp360_;
					_tmp358_ = vala_compiler_gir;
					_tmp359_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp358_);
					_tmp360_ = _tmp359_;
					vala_report_error (NULL, _tmp360_);
					_g_free0 (_tmp360_);
				} else {
					ValaGIRWriter* gir_writer = NULL;
					ValaGIRWriter* _tmp361_;
					gchar* gir_directory = NULL;
					gchar* _tmp362_;
					const gchar* _tmp363_;
					ValaGIRWriter* _tmp368_;
					ValaCodeContext* _tmp369_;
					const gchar* _tmp370_;
					const gchar* _tmp371_;
					const gchar* _tmp372_;
					const gchar* _tmp373_;
					const gchar* _tmp374_;
					const gchar* _tmp375_;
					_tmp361_ = vala_gir_writer_new ();
					gir_writer = _tmp361_;
					_tmp362_ = g_strdup (".");
					gir_directory = _tmp362_;
					_tmp363_ = vala_compiler_directory;
					if (_tmp363_ != NULL) {
						ValaCodeContext* _tmp364_;
						const gchar* _tmp365_;
						const gchar* _tmp366_;
						gchar* _tmp367_;
						_tmp364_ = self->priv->context;
						_tmp365_ = vala_code_context_get_directory (_tmp364_);
						_tmp366_ = _tmp365_;
						_tmp367_ = g_strdup (_tmp366_);
						_g_free0 (gir_directory);
						gir_directory = _tmp367_;
					}
					_tmp368_ = gir_writer;
					_tmp369_ = self->priv->context;
					_tmp370_ = gir_directory;
					_tmp371_ = vala_compiler_gir;
					_tmp372_ = gir_namespace;
					_tmp373_ = gir_version;
					_tmp374_ = vala_compiler_library;
					_tmp375_ = vala_compiler_shared_library;
					vala_gir_writer_write_file (_tmp368_, _tmp369_, _tmp370_, _tmp371_, _tmp372_, _tmp373_, _tmp374_, _tmp375_);
					_g_free0 (gir_directory);
					_vala_code_visitor_unref0 (gir_writer);
				}
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
			_g_free0 (gir_base);
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	}
	_tmp376_ = vala_compiler_vapi_filename;
	if (_tmp376_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp377_;
		gboolean _tmp378_ = FALSE;
		const gchar* _tmp379_;
		ValaCodeWriter* _tmp387_;
		ValaCodeContext* _tmp388_;
		const gchar* _tmp389_;
		_tmp377_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp377_;
		_tmp379_ = vala_compiler_directory;
		if (_tmp379_ != NULL) {
			const gchar* _tmp380_;
			gboolean _tmp381_;
			_tmp380_ = vala_compiler_vapi_filename;
			_tmp381_ = g_path_is_absolute (_tmp380_);
			_tmp378_ = !_tmp381_;
		} else {
			_tmp378_ = FALSE;
		}
		if (_tmp378_) {
			ValaCodeContext* _tmp382_;
			const gchar* _tmp383_;
			const gchar* _tmp384_;
			const gchar* _tmp385_;
			gchar* _tmp386_;
			_tmp382_ = self->priv->context;
			_tmp383_ = vala_code_context_get_directory (_tmp382_);
			_tmp384_ = _tmp383_;
			_tmp385_ = vala_compiler_vapi_filename;
			_tmp386_ = g_strdup_printf ("%s%c%s", _tmp384_, (gint) G_DIR_SEPARATOR, _tmp385_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp386_;
		}
		_tmp387_ = interface_writer;
		_tmp388_ = self->priv->context;
		_tmp389_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp387_, _tmp388_, _tmp389_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp390_ = vala_compiler_internal_vapi_filename;
	if (_tmp390_ != NULL) {
		gboolean _tmp391_ = FALSE;
		const gchar* _tmp392_;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp395_;
		ValaCodeWriter* _tmp396_;
		const gchar* _tmp397_;
		const gchar* _tmp398_;
		gchar* vapi_filename = NULL;
		const gchar* _tmp399_;
		gchar* _tmp400_;
		gboolean _tmp401_ = FALSE;
		const gchar* _tmp402_;
		ValaCodeWriter* _tmp410_;
		ValaCodeContext* _tmp411_;
		const gchar* _tmp412_;
		_tmp392_ = vala_compiler_internal_header_filename;
		if (_tmp392_ == NULL) {
			_tmp391_ = TRUE;
		} else {
			const gchar* _tmp393_;
			_tmp393_ = vala_compiler_header_filename;
			_tmp391_ = _tmp393_ == NULL;
		}
		if (_tmp391_) {
			gint _tmp394_;
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			_tmp394_ = vala_compiler_quit (self);
			result = _tmp394_;
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp395_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp395_;
		_tmp396_ = interface_writer;
		_tmp397_ = vala_compiler_header_filename;
		_tmp398_ = vala_compiler_internal_header_filename;
		vala_code_writer_set_cheader_override (_tmp396_, _tmp397_, _tmp398_);
		_tmp399_ = vala_compiler_internal_vapi_filename;
		_tmp400_ = g_strdup (_tmp399_);
		vapi_filename = _tmp400_;
		_tmp402_ = vala_compiler_directory;
		if (_tmp402_ != NULL) {
			const gchar* _tmp403_;
			gboolean _tmp404_;
			_tmp403_ = vapi_filename;
			_tmp404_ = g_path_is_absolute (_tmp403_);
			_tmp401_ = !_tmp404_;
		} else {
			_tmp401_ = FALSE;
		}
		if (_tmp401_) {
			ValaCodeContext* _tmp405_;
			const gchar* _tmp406_;
			const gchar* _tmp407_;
			const gchar* _tmp408_;
			gchar* _tmp409_;
			_tmp405_ = self->priv->context;
			_tmp406_ = vala_code_context_get_directory (_tmp405_);
			_tmp407_ = _tmp406_;
			_tmp408_ = vapi_filename;
			_tmp409_ = g_strdup_printf ("%s%c%s", _tmp407_, (gint) G_DIR_SEPARATOR, _tmp408_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp409_;
		}
		_tmp410_ = interface_writer;
		_tmp411_ = self->priv->context;
		_tmp412_ = vapi_filename;
		vala_code_writer_write_file (_tmp410_, _tmp411_, _tmp412_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp413_ = vala_compiler_dependencies;
	if (_tmp413_ != NULL) {
		ValaCodeContext* _tmp414_;
		const gchar* _tmp415_;
		_tmp414_ = self->priv->context;
		_tmp415_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp414_, _tmp415_);
	}
	_tmp417_ = self->priv->context;
	_tmp418_ = vala_code_context_get_report (_tmp417_);
	_tmp419_ = _tmp418_;
	_tmp420_ = vala_report_get_errors (_tmp419_);
	if (_tmp420_ > 0) {
		_tmp416_ = TRUE;
	} else {
		gboolean _tmp421_ = FALSE;
		gboolean _tmp422_;
		_tmp422_ = vala_compiler_fatal_warnings;
		if (_tmp422_) {
			ValaCodeContext* _tmp423_;
			ValaReport* _tmp424_;
			ValaReport* _tmp425_;
			gint _tmp426_;
			_tmp423_ = self->priv->context;
			_tmp424_ = vala_code_context_get_report (_tmp423_);
			_tmp425_ = _tmp424_;
			_tmp426_ = vala_report_get_warnings (_tmp425_);
			_tmp421_ = _tmp426_ > 0;
		} else {
			_tmp421_ = FALSE;
		}
		_tmp416_ = _tmp421_;
	}
	if (_tmp416_) {
		gint _tmp427_;
		_tmp427_ = vala_compiler_quit (self);
		result = _tmp427_;
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp428_ = vala_compiler_ccode_only;
	if (!_tmp428_) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp429_;
		gboolean _tmp430_ = FALSE;
		const gchar* _tmp431_;
		gboolean _tmp435_ = FALSE;
		const gchar* _tmp436_;
		gchar** _tmp440_;
		gint _tmp440__length1;
		_tmp429_ = vala_ccode_compiler_new ();
		ccompiler = _tmp429_;
		_tmp431_ = vala_compiler_cc_command;
		if (_tmp431_ == NULL) {
			const gchar* _tmp432_;
			_tmp432_ = g_getenv ("CC");
			_tmp430_ = _tmp432_ != NULL;
		} else {
			_tmp430_ = FALSE;
		}
		if (_tmp430_) {
			const gchar* _tmp433_;
			gchar* _tmp434_;
			_tmp433_ = g_getenv ("CC");
			_tmp434_ = g_strdup (_tmp433_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp434_;
		}
		_tmp436_ = vala_compiler_pkg_config_command;
		if (_tmp436_ == NULL) {
			const gchar* _tmp437_;
			_tmp437_ = g_getenv ("PKG_CONFIG");
			_tmp435_ = _tmp437_ != NULL;
		} else {
			_tmp435_ = FALSE;
		}
		if (_tmp435_) {
			const gchar* _tmp438_;
			gchar* _tmp439_;
			_tmp438_ = g_getenv ("PKG_CONFIG");
			_tmp439_ = g_strdup (_tmp438_);
			_g_free0 (vala_compiler_pkg_config_command);
			vala_compiler_pkg_config_command = _tmp439_;
		}
		_tmp440_ = vala_compiler_cc_options;
		_tmp440__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp440_ == NULL) {
			ValaCCodeCompiler* _tmp441_;
			ValaCodeContext* _tmp442_;
			const gchar* _tmp443_;
			gchar** _tmp444_;
			gchar** _tmp445_;
			gint _tmp445__length1;
			const gchar* _tmp446_;
			_tmp441_ = ccompiler;
			_tmp442_ = self->priv->context;
			_tmp443_ = vala_compiler_cc_command;
			_tmp444_ = g_new0 (gchar*, 0 + 1);
			_tmp445_ = _tmp444_;
			_tmp445__length1 = 0;
			_tmp446_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp441_, _tmp442_, _tmp443_, _tmp445_, 0, _tmp446_);
			_tmp445_ = (_vala_array_free (_tmp445_, _tmp445__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp447_;
			ValaCodeContext* _tmp448_;
			const gchar* _tmp449_;
			gchar** _tmp450_;
			gint _tmp450__length1;
			const gchar* _tmp451_;
			_tmp447_ = ccompiler;
			_tmp448_ = self->priv->context;
			_tmp449_ = vala_compiler_cc_command;
			_tmp450_ = vala_compiler_cc_options;
			_tmp450__length1 = _vala_array_length (vala_compiler_cc_options);
			_tmp451_ = vala_compiler_pkg_config_command;
			vala_ccode_compiler_compile (_tmp447_, _tmp448_, _tmp449_, _tmp450_, _tmp450__length1, _tmp451_);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	_tmp452_ = vala_compiler_quit (self);
	result = _tmp452_;
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void ___lambda4_ (Block1Data* _data1_, GPid pid, gint status) {
	gint _tmp0_;
	GMainLoop* _tmp1_;
	_tmp0_ = status;
	_data1_->child_status = (_tmp0_ & 0xff00) >> 8;
	_tmp1_ = _data1_->loop;
	g_main_loop_quit (_tmp1_);
}


static void ____lambda4__gchild_watch_func (GPid pid, gint status, gpointer self) {
	___lambda4_ (self, pid, status);
}


static gint vala_compiler_run_source (gchar** args, int args_length1) {
	gint result = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp32_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	gint _tmp37_;
	const gchar* _tmp38_;
	gchar** _tmp40_;
	gint _tmp40__length1;
	gint _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar** _tmp44_;
	const gchar* _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	gint _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gint outputfd = 0;
	const gchar* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp55_;
	gint ret = 0;
	ValaCompiler* _tmp56_;
	gint _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	const gchar* _tmp60_;
	gint _tmp61_;
	gchar** target_args = NULL;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	gchar** _tmp65_;
	gint target_args_length1;
	gint _target_args_size_;
	gint _tmp85_ = 0;
	GError * _inner_error_ = NULL;
	i = 1;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = i;
	_tmp3_ = _tmp1_[_tmp2_];
	if (_tmp3_ != NULL) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_;
		const gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = args;
		_tmp4__length1 = args_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = g_str_has_prefix (_tmp6_, "-");
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp31_;
		{
			gchar** compile_args = NULL;
			gint compile_args_length1 = 0;
			gint _compile_args_size_ = 0;
			gchar** _tmp8_;
			gint _tmp8__length1;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar** _tmp12_ = NULL;
			gint _tmp13_;
			GOptionContext* opt_context = NULL;
			GOptionContext* _tmp15_;
			GOptionContext* _tmp16_;
			GOptionContext* _tmp17_;
			gchar** temp_args = NULL;
			gchar** _tmp18_;
			gint _tmp18__length1;
			gint temp_args_length1;
			gint _temp_args_size_;
			GOptionContext* _tmp19_;
			_tmp8_ = args;
			_tmp8__length1 = args_length1;
			_tmp9_ = _tmp8_[1];
			_tmp10_ = g_strconcat ("valac ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			g_shell_parse_argv (_tmp11_, &_tmp13_, &_tmp12_, &_inner_error_);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
			compile_args = _tmp12_;
			compile_args_length1 = _tmp13_;
			_compile_args_size_ = compile_args_length1;
			_g_free0 (_tmp11_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gint _tmp14_ = 0;
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp14_;
			}
			_tmp15_ = g_option_context_new ("- Vala");
			opt_context = _tmp15_;
			_tmp16_ = opt_context;
			g_option_context_set_help_enabled (_tmp16_, TRUE);
			_tmp17_ = opt_context;
			g_option_context_add_main_entries (_tmp17_, VALA_COMPILER_options, NULL);
			_tmp18_ = compile_args;
			_tmp18__length1 = compile_args_length1;
			temp_args = _tmp18_;
			temp_args_length1 = _tmp18__length1;
			_temp_args_size_ = temp_args_length1;
			_tmp19_ = opt_context;
			g_option_context_parse (_tmp19_, &temp_args_length1, &temp_args, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gint _tmp20_ = 0;
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				if (_inner_error_->domain == G_SHELL_ERROR) {
					goto __catch0_g_shell_error;
				}
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				_g_option_context_free0 (opt_context);
				compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp20_;
			}
			_g_option_context_free0 (opt_context);
			compile_args = (_vala_array_free (compile_args, compile_args_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally0;
		__catch0_g_shell_error:
		{
			GError* e = NULL;
			FILE* _tmp21_;
			GError* _tmp22_;
			const gchar* _tmp23_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = stdout;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			fprintf (_tmp21_, "%s\n", _tmp23_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError* e = NULL;
			FILE* _tmp24_;
			GError* _tmp25_;
			const gchar* _tmp26_;
			FILE* _tmp27_;
			gchar** _tmp28_;
			gint _tmp28__length1;
			const gchar* _tmp29_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = stdout;
			_tmp25_ = e;
			_tmp26_ = _tmp25_->message;
			fprintf (_tmp24_, "%s\n", _tmp26_);
			_tmp27_ = stdout;
			_tmp28_ = args;
			_tmp28__length1 = args_length1;
			_tmp29_ = _tmp28_[0];
			fprintf (_tmp27_, "Run '%s --help' to see a full list of available command line options.\n", _tmp29_);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp30_ = 0;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp30_;
		}
		_tmp31_ = i;
		i = _tmp31_ + 1;
	}
	_tmp32_ = vala_compiler_version;
	if (_tmp32_) {
		FILE* _tmp33_;
		_tmp33_ = stdout;
		fprintf (_tmp33_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp34_;
		_tmp34_ = vala_compiler_api_version;
		if (_tmp34_) {
			FILE* _tmp35_;
			_tmp35_ = stdout;
			fprintf (_tmp35_, "%s\n", API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp36_ = args;
	_tmp36__length1 = args_length1;
	_tmp37_ = i;
	_tmp38_ = _tmp36_[_tmp37_];
	if (_tmp38_ == NULL) {
		FILE* _tmp39_;
		_tmp39_ = stderr;
		fprintf (_tmp39_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp40_ = args;
	_tmp40__length1 = args_length1;
	_tmp41_ = i;
	_tmp42_ = _tmp40_[_tmp41_];
	_tmp43_ = g_strdup (_tmp42_);
	_tmp44_ = g_new0 (gchar*, 1 + 1);
	_tmp44_[0] = _tmp43_;
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = _tmp44_;
	_tmp45_ = g_get_tmp_dir ();
	_tmp46_ = args;
	_tmp46__length1 = args_length1;
	_tmp47_ = i;
	_tmp48_ = _tmp46_[_tmp47_];
	_tmp49_ = g_path_get_basename (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp45_, _tmp50_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp51_;
	_g_free0 (_tmp50_);
	_tmp52_ = vala_compiler_output;
	_tmp53_ = g_mkstemp (_tmp52_);
	outputfd = _tmp53_;
	_tmp54_ = outputfd;
	if (_tmp54_ < 0) {
		result = 1;
		return result;
	}
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_tmp55_ = vala_compiler_new ();
	compiler = _tmp55_;
	_tmp56_ = compiler;
	_tmp57_ = vala_compiler_run (_tmp56_);
	ret = _tmp57_;
	_tmp58_ = ret;
	if (_tmp58_ != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp59_ = outputfd;
	close (_tmp59_);
	_tmp60_ = vala_compiler_output;
	_tmp61_ = g_chmod (_tmp60_, 0700);
	if (_tmp61_ != 0) {
		const gchar* _tmp62_;
		_tmp62_ = vala_compiler_output;
		g_unlink (_tmp62_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp63_ = vala_compiler_output;
	_tmp64_ = g_strdup (_tmp63_);
	_tmp65_ = g_new0 (gchar*, 1 + 1);
	_tmp65_[0] = _tmp64_;
	target_args = _tmp65_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	while (TRUE) {
		gint _tmp66_;
		gchar** _tmp67_;
		gint _tmp67__length1;
		gchar** _tmp68_;
		gint _tmp68__length1;
		gchar** _tmp69_;
		gint _tmp69__length1;
		gint _tmp70_;
		const gchar* _tmp71_;
		gchar* _tmp72_;
		gint _tmp73_;
		_tmp66_ = i;
		_tmp67_ = args;
		_tmp67__length1 = args_length1;
		if (!(_tmp66_ < _tmp67__length1)) {
			break;
		}
		_tmp68_ = target_args;
		_tmp68__length1 = target_args_length1;
		_tmp69_ = args;
		_tmp69__length1 = args_length1;
		_tmp70_ = i;
		_tmp71_ = _tmp69_[_tmp70_];
		_tmp72_ = g_strdup (_tmp71_);
		_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp72_);
		_tmp73_ = i;
		i = _tmp73_ + 1;
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp74_;
		gchar** _tmp75_;
		gint _tmp75__length1;
		GPid _tmp76_ = 0;
		const gchar* _tmp78_;
		GPid _tmp79_;
		GMainLoop* _tmp80_;
		gint _tmp81_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp74_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp74_;
		_data1_->child_status = 0;
		_tmp75_ = target_args;
		_tmp75__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp75_, NULL, (G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_FILE_AND_ARGV_ZERO, NULL, NULL, &_tmp76_, &_inner_error_);
		pid = _tmp76_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp77_ = 0;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp77_;
		}
		_tmp78_ = vala_compiler_output;
		g_unlink (_tmp78_);
		_tmp79_ = pid;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp79_, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp80_ = _data1_->loop;
		g_main_loop_run (_tmp80_);
		_tmp81_ = _data1_->child_status;
		result = _tmp81_;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp82_;
		GError* _tmp83_;
		const gchar* _tmp84_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp82_ = stdout;
		_tmp83_ = e;
		_tmp84_ = _tmp83_->message;
		fprintf (_tmp82_, "%s\n", _tmp84_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return _tmp85_;
}


static gint vala_compiler_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp24_;
	gboolean _tmp28_ = FALSE;
	gchar** _tmp29_;
	gint _tmp29__length1;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp32_;
	ValaCompiler* _tmp33_;
	gint _tmp34_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_path_get_basename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "vala") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = g_path_get_basename (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp9_);
	}
	if (_tmp0_) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		gint _tmp11_;
		_tmp10_ = args;
		_tmp10__length1 = args_length1;
		_tmp11_ = vala_compiler_run_source (_tmp10_, _tmp10__length1);
		result = _tmp11_;
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp12_;
		GOptionContext* _tmp13_;
		GOptionContext* _tmp14_;
		GOptionContext* _tmp15_;
		_tmp12_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp12_;
		_tmp13_ = opt_context;
		g_option_context_set_help_enabled (_tmp13_, TRUE);
		_tmp14_ = opt_context;
		g_option_context_add_main_entries (_tmp14_, VALA_COMPILER_options, NULL);
		_tmp15_ = opt_context;
		g_option_context_parse (_tmp15_, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp16_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp16_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		FILE* _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = stdout;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		fprintf (_tmp17_, "%s\n", _tmp19_);
		_tmp20_ = stdout;
		_tmp21_ = args;
		_tmp21__length1 = args_length1;
		_tmp22_ = _tmp21_[0];
		fprintf (_tmp20_, "Run '%s --help' to see a full list of available command line options.\n", _tmp22_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp23_ = 0;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp23_;
	}
	_tmp24_ = vala_compiler_version;
	if (_tmp24_) {
		FILE* _tmp25_;
		_tmp25_ = stdout;
		fprintf (_tmp25_, "Vala %s\n", BUILD_VERSION);
		result = 0;
		return result;
	} else {
		gboolean _tmp26_;
		_tmp26_ = vala_compiler_api_version;
		if (_tmp26_) {
			FILE* _tmp27_;
			_tmp27_ = stdout;
			fprintf (_tmp27_, "%s\n", API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp29_ = vala_compiler_sources;
	_tmp29__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp29_ == NULL) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		_tmp30_ = vala_compiler_fast_vapis;
		_tmp30__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp28_ = _tmp30_ == NULL;
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		FILE* _tmp31_;
		_tmp31_ = stderr;
		fprintf (_tmp31_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp32_ = vala_compiler_new ();
	compiler = _tmp32_;
	_tmp33_ = compiler;
	_tmp34_ = vala_compiler_run (_tmp33_);
	result = _tmp34_;
	_vala_compiler_unref0 (compiler);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return vala_compiler_main (argv, argc);
}


G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type) {
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}


G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void) {
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}


static void vala_value_compiler_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_compiler_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}


static void vala_value_compiler_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_compiler_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_compiler_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_compiler_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}


G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}


G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value, gpointer v_object) {
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value, gpointer v_object) {
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}


static void vala_compiler_class_init (ValaCompilerClass * klass) {
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_add_private (klass, sizeof (ValaCompilerPrivate));
}


static void vala_compiler_instance_init (ValaCompiler * self) {
	self->priv = VALA_COMPILER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void vala_compiler_finalize (ValaCompiler * obj) {
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


G_GNUC_INTERNAL GType vala_compiler_get_type (void) {
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_compiler_type_id;
		vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}


G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance) {
	ValaCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance) {
	ValaCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



