##
# This file is part of the libvcard project.
#
# Copyright (C) 2010, Emanuele Bertoldi (Card Tech srl).
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
#
# $Revision$
# $Date$
##

VERSION=1.0.2
VCARD_INCDIR = include/vcard
VCARD_SRCDIR = libvcard

PUBLIC_HEADERS = $$VCARD_INCDIR/libvcard_global.h \
    $$VCARD_INCDIR/vcard.h \
    $$VCARD_INCDIR/vcardproperty.h \
    $$VCARD_INCDIR/vcardparam.h

QT -= gui
TARGET = vcard
TEMPLATE = lib
DEFINES += VCARD_LIBRARY
INCLUDEPATH += $$VCARD_INCDIR
HEADERS += $$PUBLIC_HEADERS
SOURCES += $$VCARD_SRCDIR/vcard.cpp \
    $$VCARD_SRCDIR/vcardproperty.cpp \
    $$VCARD_SRCDIR/vcardparam.cpp
DESTDIR = $$VCARD_LIBDIR

unix: {
    # install library and headers
    isEmpty(PREFIX) {
      PREFIX = /usr/local
    }
    target.path = $$PREFIX/lib
    INSTALLS += target

    incfiles.path = $$PREFIX/include/vcard
    incfiles.files = $$PUBLIC_HEADERS
    INSTALLS += incfiles

    # install pkg-config file (libvcard.pc)
    CONFIG += create_pc create_prl
    QMAKE_PKGCONFIG_REQUIRES = QtCore
    QMAKE_PKGCONFIG_LIBDIR = $$target.path
    QMAKE_PKGCONFIG_INCDIR = $$incfiles.path
    QMAKE_PKGCONFIG_DESTDIR = pkgconfig
}
