/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Jan 16 09:07:53 EST 2017 */

#include "codelet-dft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_twiddle.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 64 -name t2_64 -include t.h */

/*
 * This function contains 1154 FP additions, 840 FP multiplications,
 * (or, 520 additions, 206 multiplications, 634 fused multiply/add),
 * 349 stack variables, 15 constants, and 256 memory accesses
 */
#include "t.h"

static void t2_64(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP820678790, +0.820678790828660330972281985331011598767386482);
     DK(KP098491403, +0.098491403357164253077197521291327432293052451);
     DK(KP534511135, +0.534511135950791641089685961295362908582039528);
     DK(KP303346683, +0.303346683607342391675883946941299872384187453);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     {
	  INT m;
	  for (m = mb, W = W + (mb * 10); m < me; m = m + 1, ri = ri + ms, ii = ii + ms, W = W + 10, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E Tg0, TlC, TlB, Tg3;
	       {
		    E T2, T3, Tc, T8, Te, T5, T6, T14, T3d, T3i, TJ, T7, Tr, T3g, TG;
		    E T10, T3a, TL, TP, Tb, Tt, T17, Td, Ti, T3N, T3R, T1i, Tu, T1I, T2U;
		    E T1t, T3U, T5O, T48, T2u, T7B, TK, T79, T3D, T2h, T2l, T3G, T1x, T3X, T2d;
		    E T1M, T2X, T4B, T4x, T3j, T4T, T29, T5s, T81, T5w, T7X, T7N, T7h, T64, T6a;
		    E T6e, T7l, T60, T7R, T6h, T5A, T7o, T6J, T6k, T5E, T6N, T7r, T6x, T6t, T7c;
		    E TO, T2x, T7E, TU, TQ, T2C, T2y, T5R, T4b, T4c, T4g, T4W, T3m, T3r, T3n;
		    E T1k, Tx, Ty, T4p, T4s, TC, T23, T1Z, T19, Th, T31, T35, T1e, T44, T41;
		    E T1a, T6W, T70, T55, T59, T3v, T3z, Tf, T1R, T2N, T2Q, T1V, T1p, T1l, Tm;
		    {
			 E T1H, T1s, T2g, Tg, Tw, TH, T2t, T47, T3h, T3M, T4w, T28, T3Q, T4A, T2c;
			 E Ts;
			 {
			      E T4, T13, TI, TF, TZ, Ta, T9;
			      T2 = W[0];
			      T3 = W[2];
			      Tc = W[5];
			      T8 = W[4];
			      Te = W[6];
			      T4 = T2 * T3;
			      T13 = T2 * Tc;
			      TI = T3 * Tc;
			      TF = T3 * T8;
			      T1H = T8 * Te;
			      TZ = T2 * T8;
			      T5 = W[1];
			      T6 = W[3];
			      T1s = T3 * Te;
			      T2g = T2 * Te;
			      T14 = FNMS(T5, T8, T13);
			      T3d = FMA(T5, T8, T13);
			      T3i = FNMS(T6, T8, TI);
			      TJ = FMA(T6, T8, TI);
			      T7 = FNMS(T5, T6, T4);
			      Tr = FMA(T5, T6, T4);
			      Ta = T2 * T6;
			      Tg = T7 * Tc;
			      Tw = Tr * Tc;
			      T3g = FMA(T6, Tc, TF);
			      TG = FNMS(T6, Tc, TF);
			      T10 = FMA(T5, Tc, TZ);
			      T3a = FNMS(T5, Tc, TZ);
			      TH = TG * Te;
			      T2t = T10 * Te;
			      T47 = T3a * Te;
			      T3h = T3g * Te;
			      TL = W[8];
			      TP = W[9];
			      T9 = T7 * T8;
			      Tb = FMA(T5, T3, Ta);
			      Tt = FNMS(T5, T3, Ta);
			      T3M = T2 * TL;
			      T4w = T8 * TL;
			      T28 = T3 * TL;
			      T3Q = T2 * TP;
			      T4A = T8 * TP;
			      T2c = T3 * TP;
			      T17 = FNMS(Tb, Tc, T9);
			      Td = FMA(Tb, Tc, T9);
			      Ts = Tr * T8;
			      Ti = W[7];
			 }
			 {
			      E T5r, T80, T1L, T2k, T1w, T5z, T2B, T2v;
			      T3N = FMA(T5, TP, T3M);
			      T3R = FNMS(T5, TL, T3Q);
			      T1i = FMA(Tt, Tc, Ts);
			      Tu = FNMS(Tt, Tc, Ts);
			      T1I = FNMS(Tc, Ti, T1H);
			      T2U = FMA(Tc, Ti, T1H);
			      T1t = FMA(T6, Ti, T1s);
			      T3U = FNMS(T6, Ti, T1s);
			      T5O = FNMS(T3d, Ti, T47);
			      T48 = FMA(T3d, Ti, T47);
			      T2u = FMA(T14, Ti, T2t);
			      T7B = FNMS(T14, Ti, T2t);
			      T1L = T8 * Ti;
			      T2k = T2 * Ti;
			      T1w = T3 * Ti;
			      TK = FMA(TJ, Ti, TH);
			      T79 = FNMS(TJ, Ti, TH);
			      T3D = FMA(T5, Ti, T2g);
			      T2h = FNMS(T5, Ti, T2g);
			      T2l = FMA(T5, Te, T2k);
			      T3G = FNMS(T5, Te, T2k);
			      T1x = FNMS(T6, Te, T1w);
			      T3X = FMA(T6, Te, T1w);
			      T2d = FNMS(T6, TL, T2c);
			      T1M = FMA(Tc, Te, T1L);
			      T2X = FNMS(Tc, Te, T1L);
			      T4B = FNMS(Tc, TL, T4A);
			      T4x = FMA(Tc, TP, T4w);
			      T3j = FMA(T3i, Ti, T3h);
			      T4T = FNMS(T3i, Ti, T3h);
			      T29 = FMA(T6, TP, T28);
			      T5r = T3g * TL;
			      T80 = T7 * TP;
			      {
				   E T7M, T7g, T63, T5v, T7W;
				   T5v = T3g * TP;
				   T7W = T7 * TL;
				   T5s = FMA(T3i, TP, T5r);
				   T81 = FNMS(Tb, TL, T80);
				   T5w = FNMS(T3i, TL, T5v);
				   T7X = FMA(Tb, TP, T7W);
				   T7M = TG * TL;
				   T7g = T10 * TL;
				   T63 = T3a * TP;
				   {
					E T6d, T7k, T69, T5Z, T7Q;
					T69 = Tr * TL;
					T7N = FMA(TJ, TP, T7M);
					T7h = FMA(T14, TP, T7g);
					T64 = FNMS(T3d, TL, T63);
					T6a = FMA(Tt, TP, T69);
					T6d = Tr * TP;
					T7k = T10 * TP;
					T5Z = T3a * TL;
					T7Q = TG * TP;
					T6e = FNMS(Tt, TL, T6d);
					T7l = FNMS(T14, TL, T7k);
					T60 = FMA(T3d, TP, T5Z);
					T7R = FNMS(TJ, TL, T7Q);
					T5z = Tr * Te;
				   }
			      }
			      {
				   E T6I, T5D, T6M, T6s, T6w;
				   T6I = T7 * Te;
				   T5D = Tr * Ti;
				   T6M = T7 * Ti;
				   T6h = FNMS(Tt, Ti, T5z);
				   T5A = FMA(Tt, Ti, T5z);
				   T7o = FMA(Tb, Ti, T6I);
				   T6J = FNMS(Tb, Ti, T6I);
				   T6k = FMA(Tt, Te, T5D);
				   T5E = FNMS(Tt, Te, T5D);
				   T6N = FMA(Tb, Te, T6M);
				   T7r = FNMS(Tb, Te, T6M);
				   T6s = T2U * TL;
				   T6w = T2U * TP;
				   {
					E TN, TT, TM, T2w;
					TN = TG * Ti;
					T2w = T10 * Ti;
					T6x = FNMS(T2X, TL, T6w);
					T6t = FMA(T2X, TP, T6s);
					T7c = FMA(TJ, Te, TN);
					TO = FNMS(TJ, Te, TN);
					TT = TK * TP;
					TM = TK * TL;
					T2x = FNMS(T14, Te, T2w);
					T7E = FMA(T14, Te, T2w);
					TU = FNMS(TO, TL, TT);
					TQ = FMA(TO, TP, TM);
					T2B = T2u * TP;
					T2v = T2u * TL;
				   }
			      }
			      {
				   E T1Y, T22, Tv, TB;
				   {
					E T49, T4f, T4a, T3l, T3q, T3k;
					T4a = T3a * Ti;
					T2C = FNMS(T2x, TL, T2B);
					T2y = FMA(T2x, TP, T2v);
					T5R = FMA(T3d, Te, T4a);
					T4b = FNMS(T3d, Te, T4a);
					T49 = T48 * TL;
					T4f = T48 * TP;
					T3l = T3g * Ti;
					T4c = FMA(T4b, TP, T49);
					T4g = FNMS(T4b, TL, T4f);
					T4W = FMA(T3i, Te, T3l);
					T3m = FNMS(T3i, Te, T3l);
					T1Y = Tu * TL;
					T3q = T3j * TP;
					T3k = T3j * TL;
					T22 = Tu * TP;
					Tv = Tu * Te;
					T3r = FNMS(T3m, TL, T3q);
					T3n = FMA(T3m, TP, T3k);
					TB = Tu * Ti;
					T1k = FNMS(Tt, T8, Tw);
					Tx = FMA(Tt, T8, Tw);
				   }
				   {
					E T30, T34, T18, T1d;
					T30 = T17 * TL;
					T34 = T17 * TP;
					T18 = T17 * Te;
					Ty = FMA(Tx, Ti, Tv);
					T4p = FNMS(Tx, Ti, Tv);
					T4s = FMA(Tx, Te, TB);
					TC = FNMS(Tx, Te, TB);
					T23 = FNMS(Tx, TL, T22);
					T1Z = FMA(Tx, TP, T1Y);
					T1d = T17 * Ti;
					T19 = FMA(Tb, T8, Tg);
					Th = FNMS(Tb, T8, Tg);
					{
					     E T1j, T1o, T1Q, T1U;
					     T1j = T1i * TL;
					     {
						  E T6V, T6Z, T54, T58;
						  T6V = Ty * TL;
						  T6Z = Ty * TP;
						  T31 = FMA(T19, TP, T30);
						  T35 = FNMS(T19, TL, T34);
						  T1e = FMA(T19, Te, T1d);
						  T44 = FNMS(T19, Te, T1d);
						  T41 = FMA(T19, Ti, T18);
						  T1a = FNMS(T19, Ti, T18);
						  T6W = FMA(TC, TP, T6V);
						  T70 = FNMS(TC, TL, T6Z);
						  T1o = T1i * TP;
						  T54 = T41 * TL;
						  T58 = T41 * TP;
						  T1Q = T1i * Te;
						  T1U = T1i * Ti;
						  T55 = FMA(T44, TP, T54);
						  T59 = FNMS(T44, TL, T58);
					     }
					     T3v = Td * TL;
					     T3z = Td * TP;
					     Tf = Td * Te;
					     T1R = FMA(T1k, Ti, T1Q);
					     T2N = FNMS(T1k, Ti, T1Q);
					     T2Q = FMA(T1k, Te, T1U);
					     T1V = FNMS(T1k, Te, T1U);
					     T1p = FNMS(T1k, TL, T1o);
					     T1l = FMA(T1k, TP, T1j);
					     Tm = Td * Ti;
					}
				   }
			      }
			 }
		    }
		    {
			 E Tl9, TlD, TY, Tg4, T8w, TdS, TkE, Tkd, T2G, Tge, Tgh, TiK, Te1, T98, Te0;
			 E T9f, Te5, T9p, Tgq, T39, Te8, T9M, TiN, Tgn, TeE, TbI, Thr, T74, TeP, TcB;
			 E Tja, Thc, T8D, TdT, T1B, TkD, T8K, TdU, Tg7, Tk7, T8T, TdY, T27, Tg9, T90;
			 E TdX, Tgc, TiJ, T9Y, Tec, T4k, TgB, Tal, Tef, Tgy, TiT, Taz, Tel, T5d, Th0;
			 E Tbs, Tew, TgL, TiZ, T3K, Tgo, Tgt, TiO, T9P, Te6, T9E, Te9, T4L, Tgz, TgE;
			 E TiU, Tao, Ted, Tad, Teg, T5I, TgM, Th3, Tj0, Tbv, Tem, TaO, Tex, T7v, Thd;
			 E Thu, Tjb, TcE, TeF, TbX, TeQ, T68, Tj5, Tez, Teq, Tbj, Tbx, TgS, Th5, T6B;
			 E Tj6, TeA, Tet, Tb4, Tby, TgX, Th6, T7V, Tjg, TeS, TeJ, Tcs, TcG, Thj, Thw;
			 E T84, T83, T85, Tc7, T8k, Tc3, T86, T89, T8b;
			 {
			      E T3w, T3A, T4H, T4E, T8e, T8i, T5j, T5n, T4U, T4S, T4V, Tau, T5b, Tbq, T4X;
			      E T50, T52;
			      {
				   E T72, Tcz, Tcv, T6Q, Tha, TbG, T6U, Tcx, T99, T9e;
				   {
					E T1, Tkb, Tp, Tka, TR, TV, TE, T8s, TS, T8t;
					{
					     E Tn, Tj, T8d, T8h, T5i, T5m;
					     T1 = ri[0];
					     T8d = T1R * TL;
					     T8h = T1R * TP;
					     T3w = FMA(Th, TP, T3v);
					     T3A = FNMS(Th, TL, T3z);
					     Tn = FMA(Th, Te, Tm);
					     T4H = FNMS(Th, Te, Tm);
					     T4E = FMA(Th, Ti, Tf);
					     Tj = FNMS(Th, Ti, Tf);
					     T8e = FMA(T1V, TP, T8d);
					     T8i = FNMS(T1V, TL, T8h);
					     Tkb = ii[0];
					     T5i = T4E * TL;
					     T5m = T4E * TP;
					     {
						  E Tk, To, Tl, Tk9;
						  Tk = ri[WS(rs, 32)];
						  To = ii[WS(rs, 32)];
						  T5j = FMA(T4H, TP, T5i);
						  T5n = FNMS(T4H, TL, T5m);
						  Tl = Tj * Tk;
						  Tk9 = Tj * To;
						  {
						       E Tz, TD, TA, T8r;
						       Tz = ri[WS(rs, 16)];
						       TD = ii[WS(rs, 16)];
						       Tp = FMA(Tn, To, Tl);
						       Tka = FNMS(Tn, Tk, Tk9);
						       TA = Ty * Tz;
						       T8r = Ty * TD;
						       TR = ri[WS(rs, 48)];
						       TV = ii[WS(rs, 48)];
						       TE = FMA(TC, TD, TA);
						       T8s = FNMS(TC, Tz, T8r);
						       TS = TQ * TR;
						       T8t = TQ * TV;
						  }
					     }
					}
					{
					     E T8q, Tq, Tl7, Tkc, TW, T8u;
					     T8q = T1 - Tp;
					     Tq = T1 + Tp;
					     Tl7 = Tkb - Tka;
					     Tkc = Tka + Tkb;
					     TW = FMA(TU, TV, TS);
					     T8u = FNMS(TU, TR, T8t);
					     {
						  E TX, Tl8, T8v, Tk8;
						  TX = TE + TW;
						  Tl8 = TE - TW;
						  T8v = T8s - T8u;
						  Tk8 = T8s + T8u;
						  Tl9 = Tl7 - Tl8;
						  TlD = Tl8 + Tl7;
						  TY = Tq + TX;
						  Tg4 = Tq - TX;
						  T8w = T8q - T8v;
						  TdS = T8q + T8v;
						  TkE = Tkc - Tk8;
						  Tkd = Tk8 + Tkc;
					     }
					}
				   }
				   {
					E T2f, T93, T2E, T9d, T2n, T95, T2s, T9b;
					{
					     E T2a, T2e, T2i, T2m;
					     T2a = ri[WS(rs, 60)];
					     T2e = ii[WS(rs, 60)];
					     {
						  E T2z, T2D, T2b, T92, T2A, T9c;
						  T2z = ri[WS(rs, 44)];
						  T2D = ii[WS(rs, 44)];
						  T2b = T29 * T2a;
						  T92 = T29 * T2e;
						  T2A = T2y * T2z;
						  T9c = T2y * T2D;
						  T2f = FMA(T2d, T2e, T2b);
						  T93 = FNMS(T2d, T2a, T92);
						  T2E = FMA(T2C, T2D, T2A);
						  T9d = FNMS(T2C, T2z, T9c);
					     }
					     T2i = ri[WS(rs, 28)];
					     T2m = ii[WS(rs, 28)];
					     {
						  E T2p, T2r, T2j, T94, T2q, T9a;
						  T2p = ri[WS(rs, 12)];
						  T2r = ii[WS(rs, 12)];
						  T2j = T2h * T2i;
						  T94 = T2h * T2m;
						  T2q = TG * T2p;
						  T9a = TG * T2r;
						  T2n = FMA(T2l, T2m, T2j);
						  T95 = FNMS(T2l, T2i, T94);
						  T2s = FMA(TJ, T2r, T2q);
						  T9b = FNMS(TJ, T2p, T9a);
					     }
					}
					{
					     E T2o, Tgf, T96, T97, T2F, Tgg;
					     T99 = T2f - T2n;
					     T2o = T2f + T2n;
					     Tgf = T93 + T95;
					     T96 = T93 - T95;
					     T97 = T2s - T2E;
					     T2F = T2s + T2E;
					     Tgg = T9b + T9d;
					     T9e = T9b - T9d;
					     T2G = T2o + T2F;
					     Tge = T2o - T2F;
					     Tgh = Tgf - Tgg;
					     TiK = Tgf + Tgg;
					     Te1 = T96 - T97;
					     T98 = T96 + T97;
					}
				   }
				   {
					E T9K, T2T, T9G, T9n, Tgl, T9o, T38, T9I;
					{
					     E T2M, T9k, T37, T2V, T2S, T2W, T2Y, T9m, T32, T33, T36, T2Z, T9H;
					     {
						  E T2J, T2L, T2K, T9j;
						  T2J = ri[WS(rs, 2)];
						  T2L = ii[WS(rs, 2)];
						  T32 = ri[WS(rs, 50)];
						  Te0 = T99 + T9e;
						  T9f = T99 - T9e;
						  T2K = Tr * T2J;
						  T9j = Tr * T2L;
						  T33 = T31 * T32;
						  T36 = ii[WS(rs, 50)];
						  T2M = FMA(Tt, T2L, T2K);
						  T9k = FNMS(Tt, T2J, T9j);
					     }
					     {
						  E T2O, T9J, T2R, T2P, T9l;
						  T2O = ri[WS(rs, 34)];
						  T37 = FMA(T35, T36, T33);
						  T9J = T31 * T36;
						  T2R = ii[WS(rs, 34)];
						  T2P = T2N * T2O;
						  T2V = ri[WS(rs, 18)];
						  T9K = FNMS(T35, T32, T9J);
						  T9l = T2N * T2R;
						  T2S = FMA(T2Q, T2R, T2P);
						  T2W = T2U * T2V;
						  T2Y = ii[WS(rs, 18)];
						  T9m = FNMS(T2Q, T2O, T9l);
					     }
					     T2T = T2M + T2S;
					     T9G = T2M - T2S;
					     T2Z = FMA(T2X, T2Y, T2W);
					     T9H = T2U * T2Y;
					     T9n = T9k - T9m;
					     Tgl = T9k + T9m;
					     T9o = T2Z - T37;
					     T38 = T2Z + T37;
					     T9I = FNMS(T2X, T2V, T9H);
					}
					{
					     E T6H, TbD, T6P, T6R, T6T, TbF, T6S, Tcw;
					     {
						  E T6X, T71, T6E, TbC, T6K, TbE;
						  {
						       E T6F, T6G, T9L, Tgm;
						       T6E = ri[WS(rs, 63)];
						       Te5 = T9n - T9o;
						       T9p = T9n + T9o;
						       Tgq = T2T - T38;
						       T39 = T2T + T38;
						       T9L = T9I - T9K;
						       Tgm = T9I + T9K;
						       T6F = TL * T6E;
						       T6G = ii[WS(rs, 63)];
						       Te8 = T9G + T9L;
						       T9M = T9G - T9L;
						       TiN = Tgl + Tgm;
						       Tgn = Tgl - Tgm;
						       TbC = TL * T6G;
						       T6H = FMA(TP, T6G, T6F);
						  }
						  T6X = ri[WS(rs, 47)];
						  T71 = ii[WS(rs, 47)];
						  TbD = FNMS(TP, T6E, TbC);
						  {
						       E T6O, T6L, T6Y, Tcy;
						       T6K = ri[WS(rs, 31)];
						       T6Y = T6W * T6X;
						       Tcy = T6W * T71;
						       T6O = ii[WS(rs, 31)];
						       T6L = T6J * T6K;
						       T72 = FMA(T70, T71, T6Y);
						       Tcz = FNMS(T70, T6X, Tcy);
						       TbE = T6J * T6O;
						       T6P = FMA(T6N, T6O, T6L);
						  }
						  T6R = ri[WS(rs, 15)];
						  T6T = ii[WS(rs, 15)];
						  TbF = FNMS(T6N, T6K, TbE);
					     }
					     Tcv = T6H - T6P;
					     T6Q = T6H + T6P;
					     T6S = TK * T6R;
					     Tcw = TK * T6T;
					     Tha = TbD + TbF;
					     TbG = TbD - TbF;
					     T6U = FMA(TO, T6T, T6S);
					     Tcx = FNMS(TO, T6R, Tcw);
					}
				   }
				   {
					E T1J, T1G, T1K, T8O, T25, T8Y, T1N, T1S, T1W;
					{
					     E T1b, T16, T1c, T8y, T1z, T8I, T1f, T1m, T1q;
					     {
						  E T11, T12, T15, T1u, T1y, T8x, T1v, T8H;
						  T11 = ri[WS(rs, 8)];
						  {
						       E TbH, T73, TcA, Thb;
						       TbH = T6U - T72;
						       T73 = T6U + T72;
						       TcA = Tcx - Tcz;
						       Thb = Tcx + Tcz;
						       TeE = TbG - TbH;
						       TbI = TbG + TbH;
						       Thr = T6Q - T73;
						       T74 = T6Q + T73;
						       TeP = Tcv + TcA;
						       TcB = Tcv - TcA;
						       Tja = Tha + Thb;
						       Thc = Tha - Thb;
						       T12 = T10 * T11;
						  }
						  T15 = ii[WS(rs, 8)];
						  T1u = ri[WS(rs, 24)];
						  T1y = ii[WS(rs, 24)];
						  T1b = ri[WS(rs, 40)];
						  T16 = FMA(T14, T15, T12);
						  T8x = T10 * T15;
						  T1v = T1t * T1u;
						  T8H = T1t * T1y;
						  T1c = T1a * T1b;
						  T8y = FNMS(T14, T11, T8x);
						  T1z = FMA(T1x, T1y, T1v);
						  T8I = FNMS(T1x, T1u, T8H);
						  T1f = ii[WS(rs, 40)];
						  T1m = ri[WS(rs, 56)];
						  T1q = ii[WS(rs, 56)];
					     }
					     {
						  E T1D, T1E, T1F, T20, T24, T8N, T21, T8X;
						  {
						       E T1h, T8C, T8A, T1r, T8G, Tg5, T8B;
						       T1D = ri[WS(rs, 4)];
						       {
							    E T1g, T8z, T1n, T8F;
							    T1g = FMA(T1e, T1f, T1c);
							    T8z = T1a * T1f;
							    T1n = T1l * T1m;
							    T8F = T1l * T1q;
							    T1h = T16 + T1g;
							    T8C = T16 - T1g;
							    T8A = FNMS(T1e, T1b, T8z);
							    T1r = FMA(T1p, T1q, T1n);
							    T8G = FNMS(T1p, T1m, T8F);
							    T1E = T7 * T1D;
						       }
						       Tg5 = T8y + T8A;
						       T8B = T8y - T8A;
						       {
							    E T1A, T8E, Tg6, T8J;
							    T1A = T1r + T1z;
							    T8E = T1r - T1z;
							    Tg6 = T8G + T8I;
							    T8J = T8G - T8I;
							    T8D = T8B - T8C;
							    TdT = T8C + T8B;
							    T1B = T1h + T1A;
							    TkD = T1A - T1h;
							    T8K = T8E + T8J;
							    TdU = T8E - T8J;
							    Tg7 = Tg5 - Tg6;
							    Tk7 = Tg5 + Tg6;
							    T1F = ii[WS(rs, 4)];
						       }
						  }
						  T20 = ri[WS(rs, 52)];
						  T24 = ii[WS(rs, 52)];
						  T1J = ri[WS(rs, 36)];
						  T1G = FMA(Tb, T1F, T1E);
						  T8N = T7 * T1F;
						  T21 = T1Z * T20;
						  T8X = T1Z * T24;
						  T1K = T1I * T1J;
						  T8O = FNMS(Tb, T1D, T8N);
						  T25 = FMA(T23, T24, T21);
						  T8Y = FNMS(T23, T20, T8X);
						  T1N = ii[WS(rs, 36)];
						  T1S = ri[WS(rs, 20)];
						  T1W = ii[WS(rs, 20)];
					     }
					}
					{
					     E T3V, T3T, T3W, T9T, T4i, Taj, T3Y, T42, T45;
					     {
						  E T3O, T3P, T3S, T4d, T4h, T9S, T4e, Tai;
						  {
						       E T1P, T8U, T8Q, T1X, T8W, Tga, T8R;
						       T3O = ri[WS(rs, 62)];
						       {
							    E T1O, T8P, T1T, T8V;
							    T1O = FMA(T1M, T1N, T1K);
							    T8P = T1I * T1N;
							    T1T = T1R * T1S;
							    T8V = T1R * T1W;
							    T1P = T1G + T1O;
							    T8U = T1G - T1O;
							    T8Q = FNMS(T1M, T1J, T8P);
							    T1X = FMA(T1V, T1W, T1T);
							    T8W = FNMS(T1V, T1S, T8V);
							    T3P = T3N * T3O;
						       }
						       Tga = T8O + T8Q;
						       T8R = T8O - T8Q;
						       {
							    E T26, T8S, Tgb, T8Z;
							    T26 = T1X + T25;
							    T8S = T1X - T25;
							    Tgb = T8W + T8Y;
							    T8Z = T8W - T8Y;
							    T8T = T8R + T8S;
							    TdY = T8R - T8S;
							    T27 = T1P + T26;
							    Tg9 = T1P - T26;
							    T90 = T8U - T8Z;
							    TdX = T8U + T8Z;
							    Tgc = Tga - Tgb;
							    TiJ = Tga + Tgb;
							    T3S = ii[WS(rs, 62)];
						       }
						  }
						  T4d = ri[WS(rs, 46)];
						  T4h = ii[WS(rs, 46)];
						  T3V = ri[WS(rs, 30)];
						  T3T = FMA(T3R, T3S, T3P);
						  T9S = T3N * T3S;
						  T4e = T4c * T4d;
						  Tai = T4c * T4h;
						  T3W = T3U * T3V;
						  T9T = FNMS(T3R, T3O, T9S);
						  T4i = FMA(T4g, T4h, T4e);
						  Taj = FNMS(T4g, T4d, Tai);
						  T3Y = ii[WS(rs, 30)];
						  T42 = ri[WS(rs, 14)];
						  T45 = ii[WS(rs, 14)];
					     }
					     {
						  E T4P, T4Q, T4R, T56, T5a, Tat, T57, Tbp;
						  {
						       E T40, Taf, T9V, T46, Tah, Tgw, T9W;
						       T4P = ri[WS(rs, 1)];
						       {
							    E T3Z, T9U, T43, Tag;
							    T3Z = FMA(T3X, T3Y, T3W);
							    T9U = T3U * T3Y;
							    T43 = T41 * T42;
							    Tag = T41 * T45;
							    T40 = T3T + T3Z;
							    Taf = T3T - T3Z;
							    T9V = FNMS(T3X, T3V, T9U);
							    T46 = FMA(T44, T45, T43);
							    Tah = FNMS(T44, T42, Tag);
							    T4Q = T2 * T4P;
						       }
						       Tgw = T9T + T9V;
						       T9W = T9T - T9V;
						       {
							    E T4j, T9X, Tgx, Tak;
							    T4j = T46 + T4i;
							    T9X = T46 - T4i;
							    Tgx = Tah + Taj;
							    Tak = Tah - Taj;
							    T9Y = T9W + T9X;
							    Tec = T9W - T9X;
							    T4k = T40 + T4j;
							    TgB = T40 - T4j;
							    Tal = Taf - Tak;
							    Tef = Taf + Tak;
							    Tgy = Tgw - Tgx;
							    TiT = Tgw + Tgx;
							    T4R = ii[WS(rs, 1)];
						       }
						  }
						  T56 = ri[WS(rs, 49)];
						  T5a = ii[WS(rs, 49)];
						  T4U = ri[WS(rs, 33)];
						  T4S = FMA(T5, T4R, T4Q);
						  Tat = T2 * T4R;
						  T57 = T55 * T56;
						  Tbp = T55 * T5a;
						  T4V = T4T * T4U;
						  Tau = FNMS(T5, T4P, Tat);
						  T5b = FMA(T59, T5a, T57);
						  Tbq = FNMS(T59, T56, Tbp);
						  T4X = ii[WS(rs, 33)];
						  T50 = ri[WS(rs, 17)];
						  T52 = ii[WS(rs, 17)];
					     }
					}
				   }
			      }
			      {
				   E T7a, T78, T7b, TbL, T7t, TbU, T7d, T7i, T7m;
				   {
					E T4q, T4o, T4r, Ta1, T4J, Taa, T4t, T4y, T4C;
					{
					     E T3o, T3f, T3p, T9s, T3I, T9B, T3s, T3x, T3B;
					     {
						  E T3b, T3c, T3e, T3E, T3H, T9r, T3F, T9A;
						  {
						       E T4Z, Tbm, Taw, T53, Tbo, TgJ, Tax;
						       T3b = ri[WS(rs, 10)];
						       {
							    E T4Y, Tav, T51, Tbn;
							    T4Y = FMA(T4W, T4X, T4V);
							    Tav = T4T * T4X;
							    T51 = T48 * T50;
							    Tbn = T48 * T52;
							    T4Z = T4S + T4Y;
							    Tbm = T4S - T4Y;
							    Taw = FNMS(T4W, T4U, Tav);
							    T53 = FMA(T4b, T52, T51);
							    Tbo = FNMS(T4b, T50, Tbn);
							    T3c = T3a * T3b;
						       }
						       TgJ = Tau + Taw;
						       Tax = Tau - Taw;
						       {
							    E T5c, Tay, TgK, Tbr;
							    T5c = T53 + T5b;
							    Tay = T53 - T5b;
							    TgK = Tbo + Tbq;
							    Tbr = Tbo - Tbq;
							    Taz = Tax + Tay;
							    Tel = Tax - Tay;
							    T5d = T4Z + T5c;
							    Th0 = T4Z - T5c;
							    Tbs = Tbm - Tbr;
							    Tew = Tbm + Tbr;
							    TgL = TgJ - TgK;
							    TiZ = TgJ + TgK;
							    T3e = ii[WS(rs, 10)];
						       }
						  }
						  T3E = ri[WS(rs, 26)];
						  T3H = ii[WS(rs, 26)];
						  T3o = ri[WS(rs, 42)];
						  T3f = FMA(T3d, T3e, T3c);
						  T9r = T3a * T3e;
						  T3F = T3D * T3E;
						  T9A = T3D * T3H;
						  T3p = T3n * T3o;
						  T9s = FNMS(T3d, T3b, T9r);
						  T3I = FMA(T3G, T3H, T3F);
						  T9B = FNMS(T3G, T3E, T9A);
						  T3s = ii[WS(rs, 42)];
						  T3x = ri[WS(rs, 58)];
						  T3B = ii[WS(rs, 58)];
					     }
					     {
						  E T4l, T4m, T4n, T4F, T4I, Ta0, T4G, Ta9;
						  {
						       E T3u, T9q, T9u, T3C, T9z, Tgr, T9v;
						       T4l = ri[WS(rs, 6)];
						       {
							    E T3t, T9t, T3y, T9y;
							    T3t = FMA(T3r, T3s, T3p);
							    T9t = T3n * T3s;
							    T3y = T3w * T3x;
							    T9y = T3w * T3B;
							    T3u = T3f + T3t;
							    T9q = T3f - T3t;
							    T9u = FNMS(T3r, T3o, T9t);
							    T3C = FMA(T3A, T3B, T3y);
							    T9z = FNMS(T3A, T3x, T9y);
							    T4m = T3g * T4l;
						       }
						       Tgr = T9s + T9u;
						       T9v = T9s - T9u;
						       {
							    E T3J, T9x, Tgs, T9C;
							    T3J = T3C + T3I;
							    T9x = T3C - T3I;
							    Tgs = T9z + T9B;
							    T9C = T9z - T9B;
							    {
								 E T9w, T9O, T9D, T9N;
								 T9w = T9q + T9v;
								 T9O = T9v - T9q;
								 T3K = T3u + T3J;
								 Tgo = T3J - T3u;
								 T9D = T9x - T9C;
								 T9N = T9x + T9C;
								 Tgt = Tgr - Tgs;
								 TiO = Tgr + Tgs;
								 T9P = T9N - T9O;
								 Te6 = T9O + T9N;
								 T9E = T9w - T9D;
								 Te9 = T9w + T9D;
								 T4n = ii[WS(rs, 6)];
							    }
						       }
						  }
						  T4F = ri[WS(rs, 22)];
						  T4I = ii[WS(rs, 22)];
						  T4q = ri[WS(rs, 38)];
						  T4o = FMA(T3i, T4n, T4m);
						  Ta0 = T3g * T4n;
						  T4G = T4E * T4F;
						  Ta9 = T4E * T4I;
						  T4r = T4p * T4q;
						  Ta1 = FNMS(T3i, T4l, Ta0);
						  T4J = FMA(T4H, T4I, T4G);
						  Taa = FNMS(T4H, T4F, Ta9);
						  T4t = ii[WS(rs, 38)];
						  T4y = ri[WS(rs, 54)];
						  T4C = ii[WS(rs, 54)];
					     }
					}
					{
					     E T5k, T5h, T5l, TaC, T5G, TaL, T5o, T5t, T5x;
					     {
						  E T5e, T5f, T5g, T5B, T5F, TaB, T5C, TaK;
						  {
						       E T4v, T9Z, Ta3, T4D, Ta8, TgC, Ta4;
						       T5e = ri[WS(rs, 9)];
						       {
							    E T4u, Ta2, T4z, Ta7;
							    T4u = FMA(T4s, T4t, T4r);
							    Ta2 = T4p * T4t;
							    T4z = T4x * T4y;
							    Ta7 = T4x * T4C;
							    T4v = T4o + T4u;
							    T9Z = T4o - T4u;
							    Ta3 = FNMS(T4s, T4q, Ta2);
							    T4D = FMA(T4B, T4C, T4z);
							    Ta8 = FNMS(T4B, T4y, Ta7);
							    T5f = T8 * T5e;
						       }
						       TgC = Ta1 + Ta3;
						       Ta4 = Ta1 - Ta3;
						       {
							    E T4K, Ta6, TgD, Tab;
							    T4K = T4D + T4J;
							    Ta6 = T4D - T4J;
							    TgD = Ta8 + Taa;
							    Tab = Ta8 - Taa;
							    {
								 E Ta5, Tan, Tac, Tam;
								 Ta5 = T9Z + Ta4;
								 Tan = Ta4 - T9Z;
								 T4L = T4v + T4K;
								 Tgz = T4K - T4v;
								 Tac = Ta6 - Tab;
								 Tam = Ta6 + Tab;
								 TgE = TgC - TgD;
								 TiU = TgC + TgD;
								 Tao = Tam - Tan;
								 Ted = Tan + Tam;
								 Tad = Ta5 - Tac;
								 Teg = Ta5 + Tac;
								 T5g = ii[WS(rs, 9)];
							    }
						       }
						  }
						  T5B = ri[WS(rs, 25)];
						  T5F = ii[WS(rs, 25)];
						  T5k = ri[WS(rs, 41)];
						  T5h = FMA(Tc, T5g, T5f);
						  TaB = T8 * T5g;
						  T5C = T5A * T5B;
						  TaK = T5A * T5F;
						  T5l = T5j * T5k;
						  TaC = FNMS(Tc, T5e, TaB);
						  T5G = FMA(T5E, T5F, T5C);
						  TaL = FNMS(T5E, T5B, TaK);
						  T5o = ii[WS(rs, 41)];
						  T5t = ri[WS(rs, 57)];
						  T5x = ii[WS(rs, 57)];
					     }
					     {
						  E T75, T76, T77, T7p, T7s, TbK, T7q, TbT;
						  {
						       E T5q, TaA, TaE, T5y, TaJ, Th1, TaF;
						       T75 = ri[WS(rs, 7)];
						       {
							    E T5p, TaD, T5u, TaI;
							    T5p = FMA(T5n, T5o, T5l);
							    TaD = T5j * T5o;
							    T5u = T5s * T5t;
							    TaI = T5s * T5x;
							    T5q = T5h + T5p;
							    TaA = T5h - T5p;
							    TaE = FNMS(T5n, T5k, TaD);
							    T5y = FMA(T5w, T5x, T5u);
							    TaJ = FNMS(T5w, T5t, TaI);
							    T76 = T1i * T75;
						       }
						       Th1 = TaC + TaE;
						       TaF = TaC - TaE;
						       {
							    E T5H, TaH, Th2, TaM;
							    T5H = T5y + T5G;
							    TaH = T5y - T5G;
							    Th2 = TaJ + TaL;
							    TaM = TaJ - TaL;
							    {
								 E TaG, Tbu, TaN, Tbt;
								 TaG = TaA + TaF;
								 Tbu = TaF - TaA;
								 T5I = T5q + T5H;
								 TgM = T5H - T5q;
								 TaN = TaH - TaM;
								 Tbt = TaH + TaM;
								 Th3 = Th1 - Th2;
								 Tj0 = Th1 + Th2;
								 Tbv = Tbt - Tbu;
								 Tem = Tbu + Tbt;
								 TaO = TaG - TaN;
								 Tex = TaG + TaN;
								 T77 = ii[WS(rs, 7)];
							    }
						       }
						  }
						  T7p = ri[WS(rs, 23)];
						  T7s = ii[WS(rs, 23)];
						  T7a = ri[WS(rs, 39)];
						  T78 = FMA(T1k, T77, T76);
						  TbK = T1i * T77;
						  T7q = T7o * T7p;
						  TbT = T7o * T7s;
						  T7b = T79 * T7a;
						  TbL = FNMS(T1k, T75, TbK);
						  T7t = FMA(T7r, T7s, T7q);
						  TbU = FNMS(T7r, T7p, TbT);
						  T7d = ii[WS(rs, 39)];
						  T7i = ri[WS(rs, 55)];
						  T7m = ii[WS(rs, 55)];
					     }
					}
				   }
				   {
					E T6i, T6g, T6j, TaY, T6z, TaU, T6l, T6o, T6q;
					{
					     E T5P, T5N, T5Q, Tbd, T66, Tb9, T5S, T5V, T5X;
					     {
						  E T5K, T5L, T5M, T61, T65, Tbc, T62, Tb8;
						  {
						       E T7f, TbJ, TbN, T7n, TbS, Ths, TbO;
						       T5K = ri[WS(rs, 5)];
						       {
							    E T7e, TbM, T7j, TbR;
							    T7e = FMA(T7c, T7d, T7b);
							    TbM = T79 * T7d;
							    T7j = T7h * T7i;
							    TbR = T7h * T7m;
							    T7f = T78 + T7e;
							    TbJ = T78 - T7e;
							    TbN = FNMS(T7c, T7a, TbM);
							    T7n = FMA(T7l, T7m, T7j);
							    TbS = FNMS(T7l, T7i, TbR);
							    T5L = Td * T5K;
						       }
						       Ths = TbL + TbN;
						       TbO = TbL - TbN;
						       {
							    E T7u, TbQ, Tht, TbV;
							    T7u = T7n + T7t;
							    TbQ = T7n - T7t;
							    Tht = TbS + TbU;
							    TbV = TbS - TbU;
							    {
								 E TbP, TcD, TbW, TcC;
								 TbP = TbJ + TbO;
								 TcD = TbO - TbJ;
								 T7v = T7f + T7u;
								 Thd = T7u - T7f;
								 TbW = TbQ - TbV;
								 TcC = TbQ + TbV;
								 Thu = Ths - Tht;
								 Tjb = Ths + Tht;
								 TcE = TcC - TcD;
								 TeF = TcD + TcC;
								 TbX = TbP - TbW;
								 TeQ = TbP + TbW;
								 T5M = ii[WS(rs, 5)];
							    }
						       }
						  }
						  T61 = ri[WS(rs, 53)];
						  T65 = ii[WS(rs, 53)];
						  T5P = ri[WS(rs, 37)];
						  T5N = FMA(Th, T5M, T5L);
						  Tbc = Td * T5M;
						  T62 = T60 * T61;
						  Tb8 = T60 * T65;
						  T5Q = T5O * T5P;
						  Tbd = FNMS(Th, T5K, Tbc);
						  T66 = FMA(T64, T65, T62);
						  Tb9 = FNMS(T64, T61, Tb8);
						  T5S = ii[WS(rs, 37)];
						  T5V = ri[WS(rs, 21)];
						  T5X = ii[WS(rs, 21)];
					     }
					     {
						  E T6b, T6c, T6f, T6u, T6y, TaX, T6v, TaT;
						  {
						       E T5U, Tb5, Tbf, T5Y, Tb7;
						       T6b = ri[WS(rs, 61)];
						       {
							    E T5T, Tbe, T5W, Tb6;
							    T5T = FMA(T5R, T5S, T5Q);
							    Tbe = T5O * T5S;
							    T5W = T3j * T5V;
							    Tb6 = T3j * T5X;
							    T5U = T5N + T5T;
							    Tb5 = T5N - T5T;
							    Tbf = FNMS(T5R, T5P, Tbe);
							    T5Y = FMA(T3m, T5X, T5W);
							    Tb7 = FNMS(T3m, T5V, Tb6);
							    T6c = T6a * T6b;
						       }
						       {
							    E TgO, Tbg, T67, Tbh;
							    TgO = Tbd + Tbf;
							    Tbg = Tbd - Tbf;
							    T67 = T5Y + T66;
							    Tbh = T5Y - T66;
							    {
								 E TgP, Tba, Tbi, Teo;
								 TgP = Tb7 + Tb9;
								 Tba = Tb7 - Tb9;
								 Tbi = Tbg + Tbh;
								 Teo = Tbg - Tbh;
								 {
								      E TgR, Tbb, Tep, TgQ;
								      TgR = T5U - T67;
								      T68 = T5U + T67;
								      Tbb = Tb5 - Tba;
								      Tep = Tb5 + Tba;
								      TgQ = TgO - TgP;
								      Tj5 = TgO + TgP;
								      Tez = FMA(KP414213562, Teo, Tep);
								      Teq = FNMS(KP414213562, Tep, Teo);
								      Tbj = FNMS(KP414213562, Tbi, Tbb);
								      Tbx = FMA(KP414213562, Tbb, Tbi);
								      TgS = TgQ - TgR;
								      Th5 = TgR + TgQ;
								      T6f = ii[WS(rs, 61)];
								 }
							    }
						       }
						  }
						  T6u = ri[WS(rs, 45)];
						  T6y = ii[WS(rs, 45)];
						  T6i = ri[WS(rs, 29)];
						  T6g = FMA(T6e, T6f, T6c);
						  TaX = T6a * T6f;
						  T6v = T6t * T6u;
						  TaT = T6t * T6y;
						  T6j = T6h * T6i;
						  TaY = FNMS(T6e, T6b, TaX);
						  T6z = FMA(T6x, T6y, T6v);
						  TaU = FNMS(T6x, T6u, TaT);
						  T6l = ii[WS(rs, 29)];
						  T6o = ri[WS(rs, 13)];
						  T6q = ii[WS(rs, 13)];
					     }
					}
					{
					     E T7C, T7A, T7D, Tcm, T7T, Tci, T7F, T7I, T7K;
					     {
						  E T7x, T7y, T7z, T7O, T7S, Tcl, T7P, Tch;
						  {
						       E T6n, TaQ, Tb0, T6r, TaS;
						       T7x = ri[WS(rs, 3)];
						       {
							    E T6m, TaZ, T6p, TaR;
							    T6m = FMA(T6k, T6l, T6j);
							    TaZ = T6h * T6l;
							    T6p = T17 * T6o;
							    TaR = T17 * T6q;
							    T6n = T6g + T6m;
							    TaQ = T6g - T6m;
							    Tb0 = FNMS(T6k, T6i, TaZ);
							    T6r = FMA(T19, T6q, T6p);
							    TaS = FNMS(T19, T6o, TaR);
							    T7y = T3 * T7x;
						       }
						       {
							    E TgU, Tb1, T6A, Tb2;
							    TgU = TaY + Tb0;
							    Tb1 = TaY - Tb0;
							    T6A = T6r + T6z;
							    Tb2 = T6r - T6z;
							    {
								 E TgV, TaV, Tb3, Ter;
								 TgV = TaS + TaU;
								 TaV = TaS - TaU;
								 Tb3 = Tb1 + Tb2;
								 Ter = Tb1 - Tb2;
								 {
								      E TgT, TaW, Tes, TgW;
								      TgT = T6n - T6A;
								      T6B = T6n + T6A;
								      TaW = TaQ - TaV;
								      Tes = TaQ + TaV;
								      TgW = TgU - TgV;
								      Tj6 = TgU + TgV;
								      TeA = FNMS(KP414213562, Ter, Tes);
								      Tet = FMA(KP414213562, Tes, Ter);
								      Tb4 = FMA(KP414213562, Tb3, TaW);
								      Tby = FNMS(KP414213562, TaW, Tb3);
								      TgX = TgT + TgW;
								      Th6 = TgT - TgW;
								      T7z = ii[WS(rs, 3)];
								 }
							    }
						       }
						  }
						  T7O = ri[WS(rs, 51)];
						  T7S = ii[WS(rs, 51)];
						  T7C = ri[WS(rs, 35)];
						  T7A = FMA(T6, T7z, T7y);
						  Tcl = T3 * T7z;
						  T7P = T7N * T7O;
						  Tch = T7N * T7S;
						  T7D = T7B * T7C;
						  Tcm = FNMS(T6, T7x, Tcl);
						  T7T = FMA(T7R, T7S, T7P);
						  Tci = FNMS(T7R, T7O, Tch);
						  T7F = ii[WS(rs, 35)];
						  T7I = ri[WS(rs, 19)];
						  T7K = ii[WS(rs, 19)];
					     }
					     {
						  E T7Y, T7Z, T82, T8f, T8j, Tc6, T8g, Tc2;
						  {
						       E T7H, Tce, Tco, T7L, Tcg;
						       T7Y = ri[WS(rs, 59)];
						       {
							    E T7G, Tcn, T7J, Tcf;
							    T7G = FMA(T7E, T7F, T7D);
							    Tcn = T7B * T7F;
							    T7J = T2u * T7I;
							    Tcf = T2u * T7K;
							    T7H = T7A + T7G;
							    Tce = T7A - T7G;
							    Tco = FNMS(T7E, T7C, Tcn);
							    T7L = FMA(T2x, T7K, T7J);
							    Tcg = FNMS(T2x, T7I, Tcf);
							    T7Z = T7X * T7Y;
						       }
						       {
							    E Thf, Tcp, T7U, Tcq;
							    Thf = Tcm + Tco;
							    Tcp = Tcm - Tco;
							    T7U = T7L + T7T;
							    Tcq = T7L - T7T;
							    {
								 E Thg, Tcj, Tcr, TeH;
								 Thg = Tcg + Tci;
								 Tcj = Tcg - Tci;
								 Tcr = Tcp + Tcq;
								 TeH = Tcp - Tcq;
								 {
								      E Thi, Tck, TeI, Thh;
								      Thi = T7H - T7U;
								      T7V = T7H + T7U;
								      Tck = Tce - Tcj;
								      TeI = Tce + Tcj;
								      Thh = Thf - Thg;
								      Tjg = Thf + Thg;
								      TeS = FMA(KP414213562, TeH, TeI);
								      TeJ = FNMS(KP414213562, TeI, TeH);
								      Tcs = FNMS(KP414213562, Tcr, Tck);
								      TcG = FMA(KP414213562, Tck, Tcr);
								      Thj = Thh - Thi;
								      Thw = Thi + Thh;
								      T82 = ii[WS(rs, 59)];
								 }
							    }
						       }
						  }
						  T8f = ri[WS(rs, 43)];
						  T8j = ii[WS(rs, 43)];
						  T84 = ri[WS(rs, 27)];
						  T83 = FMA(T81, T82, T7Z);
						  Tc6 = T7X * T82;
						  T8g = T8e * T8f;
						  Tc2 = T8e * T8j;
						  T85 = Te * T84;
						  Tc7 = FNMS(T81, T7Y, Tc6);
						  T8k = FMA(T8i, T8j, T8g);
						  Tc3 = FNMS(T8i, T8f, Tc2);
						  T86 = ii[WS(rs, 27)];
						  T89 = ri[WS(rs, 11)];
						  T8b = ii[WS(rs, 11)];
					     }
					}
				   }
			      }
			 }
			 {
			      E TeT, TeM, Tcd, TcH, Tho, Thx, Tkw, Tkv, Tl6, Tl5;
			      {
				   E TiI, Tkp, TiQ, TiS, TiL, Tkq, TiP, TiV, Tjf, Tjd, Tjc, Tji, Tj4, Tj2, Tj1;
				   E Tj7, Tkh, Tki;
				   {
					E TjG, T2I, Tkj, T4N, Tkk, Tkf, Tk5, TjJ, T8o, Tk2, TjL, T6D, TjY, TjU, Tk1;
					E TjO;
					{
					     E T8m, Tjh, T3L, T4M, Tk6, Tke, TjH, TjI;
					     {
						  E T1C, T88, TbZ, Tc9, T8c, Tc1, T2H;
						  T1C = TY + T1B;
						  TiI = TY - T1B;
						  {
						       E T87, Tc8, T8a, Tc0;
						       T87 = FMA(Ti, T86, T85);
						       Tc8 = Te * T86;
						       T8a = Tu * T89;
						       Tc0 = Tu * T8b;
						       T88 = T83 + T87;
						       TbZ = T83 - T87;
						       Tc9 = FNMS(Ti, T84, Tc8);
						       T8c = FMA(Tx, T8b, T8a);
						       Tc1 = FNMS(Tx, T89, Tc0);
						       T2H = T27 + T2G;
						       Tkp = T2G - T27;
						  }
						  {
						       E Thl, Tca, T8l, Tcb;
						       Thl = Tc7 + Tc9;
						       Tca = Tc7 - Tc9;
						       T8l = T8c + T8k;
						       Tcb = T8c - T8k;
						       {
							    E Thm, Tc4, Tcc, TeK;
							    Thm = Tc1 + Tc3;
							    Tc4 = Tc1 - Tc3;
							    Tcc = Tca + Tcb;
							    TeK = Tca - Tcb;
							    {
								 E Thk, Tc5, TeL, Thn;
								 Thk = T88 - T8l;
								 T8m = T88 + T8l;
								 Tc5 = TbZ - Tc4;
								 TeL = TbZ + Tc4;
								 Thn = Thl - Thm;
								 Tjh = Thl + Thm;
								 TeT = FNMS(KP414213562, TeK, TeL);
								 TeM = FMA(KP414213562, TeL, TeK);
								 Tcd = FMA(KP414213562, Tcc, Tc5);
								 TcH = FNMS(KP414213562, Tc5, Tcc);
								 Tho = Thk + Thn;
								 Thx = Thk - Thn;
								 TjG = T1C - T2H;
								 T2I = T1C + T2H;
							    }
						       }
						  }
					     }
					     TiQ = T39 - T3K;
					     T3L = T39 + T3K;
					     T4M = T4k + T4L;
					     TiS = T4k - T4L;
					     TiL = TiJ - TiK;
					     Tk6 = TiJ + TiK;
					     Tke = Tk7 + Tkd;
					     Tkq = Tkd - Tk7;
					     TiP = TiN - TiO;
					     TjH = TiN + TiO;
					     Tkj = T4M - T3L;
					     T4N = T3L + T4M;
					     Tkk = Tke - Tk6;
					     Tkf = Tk6 + Tke;
					     TjI = TiT + TiU;
					     TiV = TiT - TiU;
					     {
						  E TjR, TjQ, TjS, T7w, T8n;
						  Tjf = T74 - T7v;
						  T7w = T74 + T7v;
						  T8n = T7V + T8m;
						  Tjd = T8m - T7V;
						  Tjc = Tja - Tjb;
						  TjR = Tja + Tjb;
						  Tk5 = TjH + TjI;
						  TjJ = TjH - TjI;
						  TjQ = T7w - T8n;
						  T8o = T7w + T8n;
						  Tji = Tjg - Tjh;
						  TjS = Tjg + Tjh;
						  {
						       E TjM, TjN, T5J, T6C, TjT;
						       Tj4 = T5d - T5I;
						       T5J = T5d + T5I;
						       T6C = T68 + T6B;
						       Tj2 = T6B - T68;
						       TjT = TjR - TjS;
						       Tk2 = TjR + TjS;
						       Tj1 = TiZ - Tj0;
						       TjM = TiZ + Tj0;
						       TjL = T5J - T6C;
						       T6D = T5J + T6C;
						       Tj7 = Tj5 - Tj6;
						       TjN = Tj5 + Tj6;
						       TjY = TjQ + TjT;
						       TjU = TjQ - TjT;
						       Tk1 = TjM + TjN;
						       TjO = TjM - TjN;
						  }
					     }
					}
					{
					     E Tk0, Tk3, TjW, Tko, Tkn, Tkl, Tkm, TjZ;
					     {
						  E TjP, TjX, Tk4, Tkg, T4O, T8p, TjK, TjV;
						  Tk0 = T2I - T4N;
						  T4O = T2I + T4N;
						  T8p = T6D + T8o;
						  Tkh = T8o - T6D;
						  TjP = TjL + TjO;
						  TjX = TjO - TjL;
						  Tk3 = Tk1 - Tk2;
						  Tk4 = Tk1 + Tk2;
						  ri[0] = T4O + T8p;
						  ri[WS(rs, 32)] = T4O - T8p;
						  Tkg = Tk5 + Tkf;
						  Tki = Tkf - Tk5;
						  TjW = TjG - TjJ;
						  TjK = TjG + TjJ;
						  TjV = TjP + TjU;
						  Tko = TjU - TjP;
						  Tkn = Tkk - Tkj;
						  Tkl = Tkj + Tkk;
						  ii[WS(rs, 32)] = Tkg - Tk4;
						  ii[0] = Tk4 + Tkg;
						  ri[WS(rs, 8)] = FMA(KP707106781, TjV, TjK);
						  ri[WS(rs, 40)] = FNMS(KP707106781, TjV, TjK);
						  Tkm = TjX + TjY;
						  TjZ = TjX - TjY;
					     }
					     ii[WS(rs, 40)] = FNMS(KP707106781, Tkm, Tkl);
					     ii[WS(rs, 8)] = FMA(KP707106781, Tkm, Tkl);
					     ri[WS(rs, 24)] = FMA(KP707106781, TjZ, TjW);
					     ri[WS(rs, 56)] = FNMS(KP707106781, TjZ, TjW);
					     ii[WS(rs, 56)] = FNMS(KP707106781, Tko, Tkn);
					     ii[WS(rs, 24)] = FMA(KP707106781, Tko, Tkn);
					     ri[WS(rs, 16)] = Tk0 + Tk3;
					     ri[WS(rs, 48)] = Tk0 - Tk3;
					}
				   }
				   {
					E Tjq, TiM, Tkx, Tkr, Tjt, Tky, Tks, TiX, Tjz, Tje, Tjx, TjD, Tjn, Tj9, Tjr;
					E TiR;
					ii[WS(rs, 48)] = Tki - Tkh;
					ii[WS(rs, 16)] = Tkh + Tki;
					Tjq = TiI + TiL;
					TiM = TiI - TiL;
					Tkx = Tkq - Tkp;
					Tkr = Tkp + Tkq;
					Tjr = TiQ + TiP;
					TiR = TiP - TiQ;
					{
					     E Tjw, Tj3, Tjs, TiW, Tjv, Tj8;
					     Tjs = TiS - TiV;
					     TiW = TiS + TiV;
					     Tjw = Tj1 + Tj2;
					     Tj3 = Tj1 - Tj2;
					     Tjt = Tjr + Tjs;
					     Tky = Tjs - Tjr;
					     Tks = TiR + TiW;
					     TiX = TiR - TiW;
					     Tjv = Tj4 + Tj7;
					     Tj8 = Tj4 - Tj7;
					     Tjz = Tjc + Tjd;
					     Tje = Tjc - Tjd;
					     Tjx = FMA(KP414213562, Tjw, Tjv);
					     TjD = FNMS(KP414213562, Tjv, Tjw);
					     Tjn = FNMS(KP414213562, Tj3, Tj8);
					     Tj9 = FMA(KP414213562, Tj8, Tj3);
					}
					{
					     E Tjm, TiY, Tkz, TkB, Tjy, Tjj;
					     Tjm = FNMS(KP707106781, TiX, TiM);
					     TiY = FMA(KP707106781, TiX, TiM);
					     Tkz = FMA(KP707106781, Tky, Tkx);
					     TkB = FNMS(KP707106781, Tky, Tkx);
					     Tjy = Tjf + Tji;
					     Tjj = Tjf - Tji;
					     {
						  E TjC, Tkt, Tku, TjF;
						  {
						       E Tju, TjE, Tjo, Tjk, TjB, TjA;
						       TjC = FNMS(KP707106781, Tjt, Tjq);
						       Tju = FMA(KP707106781, Tjt, Tjq);
						       TjA = FNMS(KP414213562, Tjz, Tjy);
						       TjE = FMA(KP414213562, Tjy, Tjz);
						       Tjo = FMA(KP414213562, Tje, Tjj);
						       Tjk = FNMS(KP414213562, Tjj, Tje);
						       TjB = Tjx + TjA;
						       Tkw = TjA - Tjx;
						       Tkv = FNMS(KP707106781, Tks, Tkr);
						       Tkt = FMA(KP707106781, Tks, Tkr);
						       {
							    E Tjp, TkA, TkC, Tjl;
							    Tjp = Tjn + Tjo;
							    TkA = Tjo - Tjn;
							    TkC = Tj9 + Tjk;
							    Tjl = Tj9 - Tjk;
							    ri[WS(rs, 4)] = FMA(KP923879532, TjB, Tju);
							    ri[WS(rs, 36)] = FNMS(KP923879532, TjB, Tju);
							    ri[WS(rs, 60)] = FMA(KP923879532, Tjp, Tjm);
							    ri[WS(rs, 28)] = FNMS(KP923879532, Tjp, Tjm);
							    ii[WS(rs, 44)] = FNMS(KP923879532, TkA, Tkz);
							    ii[WS(rs, 12)] = FMA(KP923879532, TkA, Tkz);
							    ii[WS(rs, 60)] = FMA(KP923879532, TkC, TkB);
							    ii[WS(rs, 28)] = FNMS(KP923879532, TkC, TkB);
							    ri[WS(rs, 12)] = FMA(KP923879532, Tjl, TiY);
							    ri[WS(rs, 44)] = FNMS(KP923879532, Tjl, TiY);
							    Tku = TjD + TjE;
							    TjF = TjD - TjE;
						       }
						  }
						  ii[WS(rs, 36)] = FNMS(KP923879532, Tku, Tkt);
						  ii[WS(rs, 4)] = FMA(KP923879532, Tku, Tkt);
						  ri[WS(rs, 20)] = FMA(KP923879532, TjF, TjC);
						  ri[WS(rs, 52)] = FNMS(KP923879532, TjF, TjC);
					     }
					}
				   }
			      }
			      {
				   E TkV, Tl1, ThG, Tgk, TkH, TkN, Tis, Ti0, Thv, ThJ, TkO, TkI, TgH, Thy, TiC;
				   E TiG, Tiq, Tim, ThN, ThT, ThD, Th9, TkW, Tiv, Tl2, Ti7, ThP, Thq, Tiz, TiF;
				   E Tip, Tif;
				   {
					E Ti1, Ti2, Ti4, Ti5, Thp, The, Tij, TiB, Tii, Tik;
					{
					     E ThW, Tg8, TkT, TkF, ThX, ThY, TkU, Tgj, Tgd, Tgi;
					     ThW = Tg4 - Tg7;
					     Tg8 = Tg4 + Tg7;
					     TkT = TkE - TkD;
					     TkF = TkD + TkE;
					     ThX = Tgc - Tg9;
					     Tgd = Tg9 + Tgc;
					     ii[WS(rs, 52)] = FNMS(KP923879532, Tkw, Tkv);
					     ii[WS(rs, 20)] = FMA(KP923879532, Tkw, Tkv);
					     Tgi = Tge - Tgh;
					     ThY = Tge + Tgh;
					     TkU = Tgi - Tgd;
					     Tgj = Tgd + Tgi;
					     {
						  E TgA, ThH, Tgv, TgF;
						  {
						       E Tgp, TkG, ThZ, Tgu;
						       Ti1 = Tgn - Tgo;
						       Tgp = Tgn + Tgo;
						       TkV = FMA(KP707106781, TkU, TkT);
						       Tl1 = FNMS(KP707106781, TkU, TkT);
						       ThG = FMA(KP707106781, Tgj, Tg8);
						       Tgk = FNMS(KP707106781, Tgj, Tg8);
						       TkG = ThX + ThY;
						       ThZ = ThX - ThY;
						       Tgu = Tgq + Tgt;
						       Ti2 = Tgq - Tgt;
						       Ti4 = Tgy - Tgz;
						       TgA = Tgy + Tgz;
						       TkH = FMA(KP707106781, TkG, TkF);
						       TkN = FNMS(KP707106781, TkG, TkF);
						       Tis = FNMS(KP707106781, ThZ, ThW);
						       Ti0 = FMA(KP707106781, ThZ, ThW);
						       ThH = FMA(KP414213562, Tgp, Tgu);
						       Tgv = FNMS(KP414213562, Tgu, Tgp);
						       TgF = TgB + TgE;
						       Ti5 = TgB - TgE;
						  }
						  {
						       E Tig, Tih, ThI, TgG;
						       Thv = Thr + Thu;
						       Tig = Thr - Thu;
						       Tih = Tho - Thj;
						       Thp = Thj + Tho;
						       The = Thc + Thd;
						       Tij = Thc - Thd;
						       ThI = FNMS(KP414213562, TgA, TgF);
						       TgG = FMA(KP414213562, TgF, TgA);
						       TiB = FMA(KP707106781, Tih, Tig);
						       Tii = FNMS(KP707106781, Tih, Tig);
						       ThJ = ThH + ThI;
						       TkO = ThI - ThH;
						       TkI = Tgv + TgG;
						       TgH = Tgv - TgG;
						       Tik = Thw - Thx;
						       Thy = Thw + Thx;
						  }
					     }
					}
					{
					     E Tic, Tia, Ti9, Tid, Tit, Ti3;
					     {
						  E Th4, ThM, TgZ, Th7, ThL, Th8;
						  {
						       E TgN, TgY, TiA, Til;
						       Tic = TgL - TgM;
						       TgN = TgL + TgM;
						       TgY = TgS + TgX;
						       Tia = TgX - TgS;
						       Ti9 = Th0 - Th3;
						       Th4 = Th0 + Th3;
						       TiA = FMA(KP707106781, Tik, Tij);
						       Til = FNMS(KP707106781, Tik, Tij);
						       ThM = FMA(KP707106781, TgY, TgN);
						       TgZ = FNMS(KP707106781, TgY, TgN);
						       TiC = FNMS(KP198912367, TiB, TiA);
						       TiG = FMA(KP198912367, TiA, TiB);
						       Tiq = FMA(KP668178637, Tii, Til);
						       Tim = FNMS(KP668178637, Til, Tii);
						       Th7 = Th5 + Th6;
						       Tid = Th5 - Th6;
						  }
						  ThL = FMA(KP707106781, Th7, Th4);
						  Th8 = FNMS(KP707106781, Th7, Th4);
						  Tit = FNMS(KP414213562, Ti1, Ti2);
						  Ti3 = FMA(KP414213562, Ti2, Ti1);
						  ThN = FMA(KP198912367, ThM, ThL);
						  ThT = FNMS(KP198912367, ThL, ThM);
						  ThD = FNMS(KP668178637, TgZ, Th8);
						  Th9 = FMA(KP668178637, Th8, TgZ);
					     }
					     {
						  E Tiy, Tib, Tiu, Ti6, Tix, Tie;
						  Tiu = FMA(KP414213562, Ti4, Ti5);
						  Ti6 = FNMS(KP414213562, Ti5, Ti4);
						  Tiy = FMA(KP707106781, Tia, Ti9);
						  Tib = FNMS(KP707106781, Tia, Ti9);
						  TkW = Tiu - Tit;
						  Tiv = Tit + Tiu;
						  Tl2 = Ti3 + Ti6;
						  Ti7 = Ti3 - Ti6;
						  Tix = FMA(KP707106781, Tid, Tic);
						  Tie = FNMS(KP707106781, Tid, Tic);
						  ThP = FMA(KP707106781, Thp, The);
						  Thq = FNMS(KP707106781, Thp, The);
						  Tiz = FMA(KP198912367, Tiy, Tix);
						  TiF = FNMS(KP198912367, Tix, Tiy);
						  Tip = FNMS(KP668178637, Tib, Tie);
						  Tif = FMA(KP668178637, Tie, Tib);
					     }
					}
				   }
				   {
					E TkM, TkL, Tl0, TkZ;
					{
					     E ThC, TgI, TkP, TkR, ThO, Thz;
					     ThC = FNMS(KP923879532, TgH, Tgk);
					     TgI = FMA(KP923879532, TgH, Tgk);
					     TkP = FMA(KP923879532, TkO, TkN);
					     TkR = FNMS(KP923879532, TkO, TkN);
					     ThO = FMA(KP707106781, Thy, Thv);
					     Thz = FNMS(KP707106781, Thy, Thv);
					     {
						  E ThS, TkJ, TkK, ThV;
						  {
						       E ThK, ThU, ThE, ThA, ThR, ThQ;
						       ThS = FNMS(KP923879532, ThJ, ThG);
						       ThK = FMA(KP923879532, ThJ, ThG);
						       ThQ = FNMS(KP198912367, ThP, ThO);
						       ThU = FMA(KP198912367, ThO, ThP);
						       ThE = FMA(KP668178637, Thq, Thz);
						       ThA = FNMS(KP668178637, Thz, Thq);
						       ThR = ThN + ThQ;
						       TkM = ThQ - ThN;
						       TkL = FNMS(KP923879532, TkI, TkH);
						       TkJ = FMA(KP923879532, TkI, TkH);
						       {
							    E ThF, TkQ, TkS, ThB;
							    ThF = ThD + ThE;
							    TkQ = ThE - ThD;
							    TkS = Th9 + ThA;
							    ThB = Th9 - ThA;
							    ri[WS(rs, 2)] = FMA(KP980785280, ThR, ThK);
							    ri[WS(rs, 34)] = FNMS(KP980785280, ThR, ThK);
							    ri[WS(rs, 58)] = FMA(KP831469612, ThF, ThC);
							    ri[WS(rs, 26)] = FNMS(KP831469612, ThF, ThC);
							    ii[WS(rs, 42)] = FNMS(KP831469612, TkQ, TkP);
							    ii[WS(rs, 10)] = FMA(KP831469612, TkQ, TkP);
							    ii[WS(rs, 58)] = FMA(KP831469612, TkS, TkR);
							    ii[WS(rs, 26)] = FNMS(KP831469612, TkS, TkR);
							    ri[WS(rs, 10)] = FMA(KP831469612, ThB, TgI);
							    ri[WS(rs, 42)] = FNMS(KP831469612, ThB, TgI);
							    TkK = ThT + ThU;
							    ThV = ThT - ThU;
						       }
						  }
						  ii[WS(rs, 34)] = FNMS(KP980785280, TkK, TkJ);
						  ii[WS(rs, 2)] = FMA(KP980785280, TkK, TkJ);
						  ri[WS(rs, 18)] = FMA(KP980785280, ThV, ThS);
						  ri[WS(rs, 50)] = FNMS(KP980785280, ThV, ThS);
					     }
					}
					{
					     E Tio, TkX, TkY, Tir, Ti8, Tin;
					     Tio = FNMS(KP923879532, Ti7, Ti0);
					     Ti8 = FMA(KP923879532, Ti7, Ti0);
					     Tin = Tif + Tim;
					     Tl0 = Tim - Tif;
					     TkZ = FNMS(KP923879532, TkW, TkV);
					     TkX = FMA(KP923879532, TkW, TkV);
					     ii[WS(rs, 50)] = FNMS(KP980785280, TkM, TkL);
					     ii[WS(rs, 18)] = FMA(KP980785280, TkM, TkL);
					     ri[WS(rs, 6)] = FMA(KP831469612, Tin, Ti8);
					     ri[WS(rs, 38)] = FNMS(KP831469612, Tin, Ti8);
					     TkY = Tip + Tiq;
					     Tir = Tip - Tiq;
					     ii[WS(rs, 38)] = FNMS(KP831469612, TkY, TkX);
					     ii[WS(rs, 6)] = FMA(KP831469612, TkY, TkX);
					     ri[WS(rs, 22)] = FMA(KP831469612, Tir, Tio);
					     ri[WS(rs, 54)] = FNMS(KP831469612, Tir, Tio);
					}
					{
					     E TiE, Tl3, Tl4, TiH, Tiw, TiD;
					     TiE = FMA(KP923879532, Tiv, Tis);
					     Tiw = FNMS(KP923879532, Tiv, Tis);
					     TiD = Tiz - TiC;
					     Tl6 = Tiz + TiC;
					     Tl5 = FMA(KP923879532, Tl2, Tl1);
					     Tl3 = FNMS(KP923879532, Tl2, Tl1);
					     ii[WS(rs, 54)] = FNMS(KP831469612, Tl0, TkZ);
					     ii[WS(rs, 22)] = FMA(KP831469612, Tl0, TkZ);
					     ri[WS(rs, 14)] = FMA(KP980785280, TiD, Tiw);
					     ri[WS(rs, 46)] = FNMS(KP980785280, TiD, Tiw);
					     Tl4 = TiG - TiF;
					     TiH = TiF + TiG;
					     ii[WS(rs, 46)] = FNMS(KP980785280, Tl4, Tl3);
					     ii[WS(rs, 14)] = FMA(KP980785280, Tl4, Tl3);
					     ri[WS(rs, 62)] = FMA(KP980785280, TiH, TiE);
					     ri[WS(rs, 30)] = FNMS(KP980785280, TiH, TiE);
					}
				   }
			      }
			      {
				   E Tla, TdV, TdO, Tm6, Tm5, TdR;
				   {
					E TcT, TlO, TlI, Tar, TcX, Td3, TcN, TbB, TdM, TdQ, TdA, Tdw, TdJ, TdP, Tdz;
					E Tdp, TlW, TdF, Tm2, Tdh, Td7, T91, Td6, T8M, TlT, TlF, Td0, Td4, TcO, TcK;
					E T9g, Td8;
					{
					     E Tdb, Tdc, Tde, Tdf, Tdm, Tdk, Tdj, Tdn, TcF, Tct, TbY, Tdt, TdL, Tds, Tdu;
					     E TcI, TdD, Tdd;
					     {
						  E Tae, TcR, T9R, Tap, T9F, T9Q;
						  Tdb = FMA(KP707106781, T9E, T9p);
						  T9F = FNMS(KP707106781, T9E, T9p);
						  T9Q = FNMS(KP707106781, T9P, T9M);
						  Tdc = FMA(KP707106781, T9P, T9M);
						  Tde = FMA(KP707106781, Tad, T9Y);
						  Tae = FNMS(KP707106781, Tad, T9Y);
						  ii[WS(rs, 62)] = FMA(KP980785280, Tl6, Tl5);
						  ii[WS(rs, 30)] = FNMS(KP980785280, Tl6, Tl5);
						  TcR = FMA(KP668178637, T9F, T9Q);
						  T9R = FNMS(KP668178637, T9Q, T9F);
						  Tap = FNMS(KP707106781, Tao, Tal);
						  Tdf = FMA(KP707106781, Tao, Tal);
						  {
						       E Tbw, TcW, Tbl, Tbz;
						       {
							    E TaP, Tbk, TcS, Taq;
							    Tdm = FMA(KP707106781, TaO, Taz);
							    TaP = FNMS(KP707106781, TaO, Taz);
							    Tbk = Tb4 - Tbj;
							    Tdk = Tbj + Tb4;
							    Tdj = FMA(KP707106781, Tbv, Tbs);
							    Tbw = FNMS(KP707106781, Tbv, Tbs);
							    TcS = FNMS(KP668178637, Tae, Tap);
							    Taq = FMA(KP668178637, Tap, Tae);
							    TcW = FMA(KP923879532, Tbk, TaP);
							    Tbl = FNMS(KP923879532, Tbk, TaP);
							    TcT = TcR + TcS;
							    TlO = TcS - TcR;
							    TlI = T9R + Taq;
							    Tar = T9R - Taq;
							    Tbz = Tbx - Tby;
							    Tdn = Tbx + Tby;
						       }
						       {
							    E Tdq, Tdr, TcV, TbA;
							    TcF = FNMS(KP707106781, TcE, TcB);
							    Tdq = FMA(KP707106781, TcE, TcB);
							    Tdr = Tcs + Tcd;
							    Tct = Tcd - Tcs;
							    TbY = FNMS(KP707106781, TbX, TbI);
							    Tdt = FMA(KP707106781, TbX, TbI);
							    TcV = FMA(KP923879532, Tbz, Tbw);
							    TbA = FNMS(KP923879532, Tbz, Tbw);
							    TdL = FMA(KP923879532, Tdr, Tdq);
							    Tds = FNMS(KP923879532, Tdr, Tdq);
							    TcX = FMA(KP303346683, TcW, TcV);
							    Td3 = FNMS(KP303346683, TcV, TcW);
							    TcN = FNMS(KP534511135, Tbl, TbA);
							    TbB = FMA(KP534511135, TbA, Tbl);
							    Tdu = TcG + TcH;
							    TcI = TcG - TcH;
						       }
						  }
					     }
					     {
						  E TdI, Tdl, TdK, Tdv, TdH, Tdo;
						  TdK = FMA(KP923879532, Tdu, Tdt);
						  Tdv = FNMS(KP923879532, Tdu, Tdt);
						  TdI = FMA(KP923879532, Tdk, Tdj);
						  Tdl = FNMS(KP923879532, Tdk, Tdj);
						  TdM = FNMS(KP098491403, TdL, TdK);
						  TdQ = FMA(KP098491403, TdK, TdL);
						  TdA = FMA(KP820678790, Tds, Tdv);
						  Tdw = FNMS(KP820678790, Tdv, Tds);
						  TdH = FMA(KP923879532, Tdn, Tdm);
						  Tdo = FNMS(KP923879532, Tdn, Tdm);
						  TdD = FNMS(KP198912367, Tdb, Tdc);
						  Tdd = FMA(KP198912367, Tdc, Tdb);
						  TdJ = FMA(KP098491403, TdI, TdH);
						  TdP = FNMS(KP098491403, TdH, TdI);
						  Tdz = FNMS(KP820678790, Tdl, Tdo);
						  Tdp = FMA(KP820678790, Tdo, Tdl);
					     }
					     {
						  E TcZ, Tcu, TdE, Tdg;
						  TdE = FMA(KP198912367, Tde, Tdf);
						  Tdg = FNMS(KP198912367, Tdf, Tde);
						  TcZ = FMA(KP923879532, Tct, TbY);
						  Tcu = FNMS(KP923879532, Tct, TbY);
						  TlW = TdE - TdD;
						  TdF = TdD + TdE;
						  Tm2 = Tdd + Tdg;
						  Tdh = Tdd - Tdg;
						  {
						       E T8L, TlE, TcY, TcJ;
						       Tla = T8D + T8K;
						       T8L = T8D - T8K;
						       TlE = TdU - TdT;
						       TdV = TdT + TdU;
						       Td7 = FNMS(KP414213562, T8T, T90);
						       T91 = FMA(KP414213562, T90, T8T);
						       TcY = FMA(KP923879532, TcI, TcF);
						       TcJ = FNMS(KP923879532, TcI, TcF);
						       Td6 = FNMS(KP707106781, T8L, T8w);
						       T8M = FMA(KP707106781, T8L, T8w);
						       TlT = FNMS(KP707106781, TlE, TlD);
						       TlF = FMA(KP707106781, TlE, TlD);
						       Td0 = FNMS(KP303346683, TcZ, TcY);
						       Td4 = FMA(KP303346683, TcY, TcZ);
						       TcO = FMA(KP534511135, Tcu, TcJ);
						       TcK = FNMS(KP534511135, TcJ, Tcu);
						       T9g = FNMS(KP414213562, T9f, T98);
						       Td8 = FMA(KP414213562, T98, T9f);
						  }
					     }
					}
					{
					     E Tm1, TlV, TdC, Tda, Td2, TlM, TlL, Td5;
					     {
						  E TlS, TcQ, TlH, TcM, TlR, TcP;
						  {
						       E TcL, Tas, TlP, TlQ, TlN;
						       TlS = TbB + TcK;
						       TcL = TbB - TcK;
						       {
							    E TlU, T9h, TlG, Td9, T9i;
							    TlU = T91 + T9g;
							    T9h = T91 - T9g;
							    TlG = Td8 - Td7;
							    Td9 = Td7 + Td8;
							    Tm1 = FMA(KP923879532, TlU, TlT);
							    TlV = FNMS(KP923879532, TlU, TlT);
							    TcQ = FMA(KP923879532, T9h, T8M);
							    T9i = FNMS(KP923879532, T9h, T8M);
							    TlN = FNMS(KP923879532, TlG, TlF);
							    TlH = FMA(KP923879532, TlG, TlF);
							    TdC = FMA(KP923879532, Td9, Td6);
							    Tda = FNMS(KP923879532, Td9, Td6);
							    Tas = FMA(KP831469612, Tar, T9i);
							    TcM = FNMS(KP831469612, Tar, T9i);
						       }
						       TlR = FNMS(KP831469612, TlO, TlN);
						       TlP = FMA(KP831469612, TlO, TlN);
						       TlQ = TcO - TcN;
						       TcP = TcN + TcO;
						       ri[WS(rs, 11)] = FMA(KP881921264, TcL, Tas);
						       ri[WS(rs, 43)] = FNMS(KP881921264, TcL, Tas);
						       ii[WS(rs, 43)] = FNMS(KP881921264, TlQ, TlP);
						       ii[WS(rs, 11)] = FMA(KP881921264, TlQ, TlP);
						  }
						  {
						       E TcU, Td1, TlJ, TlK;
						       Td2 = FNMS(KP831469612, TcT, TcQ);
						       TcU = FMA(KP831469612, TcT, TcQ);
						       ri[WS(rs, 59)] = FMA(KP881921264, TcP, TcM);
						       ri[WS(rs, 27)] = FNMS(KP881921264, TcP, TcM);
						       ii[WS(rs, 59)] = FMA(KP881921264, TlS, TlR);
						       ii[WS(rs, 27)] = FNMS(KP881921264, TlS, TlR);
						       Td1 = TcX + Td0;
						       TlM = Td0 - TcX;
						       TlL = FNMS(KP831469612, TlI, TlH);
						       TlJ = FMA(KP831469612, TlI, TlH);
						       TlK = Td3 + Td4;
						       Td5 = Td3 - Td4;
						       ri[WS(rs, 3)] = FMA(KP956940335, Td1, TcU);
						       ri[WS(rs, 35)] = FNMS(KP956940335, Td1, TcU);
						       ii[WS(rs, 35)] = FNMS(KP956940335, TlK, TlJ);
						       ii[WS(rs, 3)] = FMA(KP956940335, TlK, TlJ);
						  }
					     }
					     {
						  E Tdy, Tm0, TlZ, TdB;
						  {
						       E Tdi, Tdx, TlX, TlY;
						       Tdy = FNMS(KP980785280, Tdh, Tda);
						       Tdi = FMA(KP980785280, Tdh, Tda);
						       ri[WS(rs, 19)] = FMA(KP956940335, Td5, Td2);
						       ri[WS(rs, 51)] = FNMS(KP956940335, Td5, Td2);
						       ii[WS(rs, 51)] = FNMS(KP956940335, TlM, TlL);
						       ii[WS(rs, 19)] = FMA(KP956940335, TlM, TlL);
						       Tdx = Tdp + Tdw;
						       Tm0 = Tdw - Tdp;
						       TlZ = FNMS(KP980785280, TlW, TlV);
						       TlX = FMA(KP980785280, TlW, TlV);
						       TlY = Tdz + TdA;
						       TdB = Tdz - TdA;
						       ri[WS(rs, 7)] = FMA(KP773010453, Tdx, Tdi);
						       ri[WS(rs, 39)] = FNMS(KP773010453, Tdx, Tdi);
						       ii[WS(rs, 39)] = FNMS(KP773010453, TlY, TlX);
						       ii[WS(rs, 7)] = FMA(KP773010453, TlY, TlX);
						  }
						  {
						       E TdG, TdN, Tm3, Tm4;
						       TdO = FMA(KP980785280, TdF, TdC);
						       TdG = FNMS(KP980785280, TdF, TdC);
						       ri[WS(rs, 23)] = FMA(KP773010453, TdB, Tdy);
						       ri[WS(rs, 55)] = FNMS(KP773010453, TdB, Tdy);
						       ii[WS(rs, 55)] = FNMS(KP773010453, Tm0, TlZ);
						       ii[WS(rs, 23)] = FMA(KP773010453, Tm0, TlZ);
						       TdN = TdJ - TdM;
						       Tm6 = TdJ + TdM;
						       Tm5 = FMA(KP980785280, Tm2, Tm1);
						       Tm3 = FNMS(KP980785280, Tm2, Tm1);
						       Tm4 = TdQ - TdP;
						       TdR = TdP + TdQ;
						       ri[WS(rs, 15)] = FMA(KP995184726, TdN, TdG);
						       ri[WS(rs, 47)] = FNMS(KP995184726, TdN, TdG);
						       ii[WS(rs, 47)] = FNMS(KP995184726, Tm4, Tm3);
						       ii[WS(rs, 15)] = FMA(KP995184726, Tm4, Tm3);
						  }
					     }
					}
				   }
				   {
					E Tf5, Tlk, Tle, Tej, Tf9, Tff, TeZ, TeD, TfY, Tg2, TfM, TfI, TfV, Tg1, TfL;
					E TfB, Tls, TfR, Tly, Tft, Tfj, TdZ, Tfi, TdW, Tlp, Tlb, Tfc, Tfg, Tf0, TeW;
					E Te2, Tfk;
					{
					     E Tfn, Tfo, Tfq, Tfr, Tfy, Tfw, Tfv, Tfz, TeR, TeN, TeG, TfF, TfX, TfE, TfG;
					     E TeU, TfP, Tfp;
					     {
						  E Te7, Tea, Tee, Teh;
						  Tfn = FNMS(KP707106781, Te6, Te5);
						  Te7 = FMA(KP707106781, Te6, Te5);
						  ri[WS(rs, 63)] = FMA(KP995184726, TdR, TdO);
						  ri[WS(rs, 31)] = FNMS(KP995184726, TdR, TdO);
						  ii[WS(rs, 63)] = FMA(KP995184726, Tm6, Tm5);
						  ii[WS(rs, 31)] = FNMS(KP995184726, Tm6, Tm5);
						  Tea = FMA(KP707106781, Te9, Te8);
						  Tfo = FNMS(KP707106781, Te9, Te8);
						  Tfq = FNMS(KP707106781, Ted, Tec);
						  Tee = FMA(KP707106781, Ted, Tec);
						  Teh = FMA(KP707106781, Teg, Tef);
						  Tfr = FNMS(KP707106781, Teg, Tef);
						  {
						       E Tey, Tf8, Tev, TeB;
						       {
							    E Ten, Tf3, Teb, Tf4, Tei, Teu;
							    Tfy = FNMS(KP707106781, Tem, Tel);
							    Ten = FMA(KP707106781, Tem, Tel);
							    Tf3 = FMA(KP198912367, Te7, Tea);
							    Teb = FNMS(KP198912367, Tea, Te7);
							    Tf4 = FNMS(KP198912367, Tee, Teh);
							    Tei = FMA(KP198912367, Teh, Tee);
							    Teu = Teq + Tet;
							    Tfw = Tet - Teq;
							    Tfv = FNMS(KP707106781, Tex, Tew);
							    Tey = FMA(KP707106781, Tex, Tew);
							    Tf5 = Tf3 + Tf4;
							    Tlk = Tf4 - Tf3;
							    Tle = Teb + Tei;
							    Tej = Teb - Tei;
							    Tf8 = FMA(KP923879532, Teu, Ten);
							    Tev = FNMS(KP923879532, Teu, Ten);
							    TeB = Tez + TeA;
							    Tfz = Tez - TeA;
						       }
						       {
							    E TfC, TfD, Tf7, TeC;
							    TeR = FMA(KP707106781, TeQ, TeP);
							    TfC = FNMS(KP707106781, TeQ, TeP);
							    TfD = TeM - TeJ;
							    TeN = TeJ + TeM;
							    TeG = FMA(KP707106781, TeF, TeE);
							    TfF = FNMS(KP707106781, TeF, TeE);
							    Tf7 = FMA(KP923879532, TeB, Tey);
							    TeC = FNMS(KP923879532, TeB, Tey);
							    TfX = FMA(KP923879532, TfD, TfC);
							    TfE = FNMS(KP923879532, TfD, TfC);
							    Tf9 = FMA(KP098491403, Tf8, Tf7);
							    Tff = FNMS(KP098491403, Tf7, Tf8);
							    TeZ = FNMS(KP820678790, Tev, TeC);
							    TeD = FMA(KP820678790, TeC, Tev);
							    TfG = TeS - TeT;
							    TeU = TeS + TeT;
						       }
						  }
					     }
					     {
						  E TfU, Tfx, TfW, TfH, TfT, TfA;
						  TfW = FMA(KP923879532, TfG, TfF);
						  TfH = FNMS(KP923879532, TfG, TfF);
						  TfU = FMA(KP923879532, Tfw, Tfv);
						  Tfx = FNMS(KP923879532, Tfw, Tfv);
						  TfY = FNMS(KP303346683, TfX, TfW);
						  Tg2 = FMA(KP303346683, TfW, TfX);
						  TfM = FMA(KP534511135, TfE, TfH);
						  TfI = FNMS(KP534511135, TfH, TfE);
						  TfT = FMA(KP923879532, Tfz, Tfy);
						  TfA = FNMS(KP923879532, Tfz, Tfy);
						  TfP = FNMS(KP668178637, Tfn, Tfo);
						  Tfp = FMA(KP668178637, Tfo, Tfn);
						  TfV = FMA(KP303346683, TfU, TfT);
						  Tg1 = FNMS(KP303346683, TfT, TfU);
						  TfL = FNMS(KP534511135, Tfx, TfA);
						  TfB = FMA(KP534511135, TfA, Tfx);
					     }
					     {
						  E Tfb, TeO, TfQ, Tfs, Tfa, TeV;
						  TfQ = FMA(KP668178637, Tfq, Tfr);
						  Tfs = FNMS(KP668178637, Tfr, Tfq);
						  Tfb = FMA(KP923879532, TeN, TeG);
						  TeO = FNMS(KP923879532, TeN, TeG);
						  Tls = TfQ - TfP;
						  TfR = TfP + TfQ;
						  Tly = Tfp + Tfs;
						  Tft = Tfp - Tfs;
						  Tfj = FNMS(KP414213562, TdX, TdY);
						  TdZ = FMA(KP414213562, TdY, TdX);
						  Tfa = FMA(KP923879532, TeU, TeR);
						  TeV = FNMS(KP923879532, TeU, TeR);
						  Tfi = FNMS(KP707106781, TdV, TdS);
						  TdW = FMA(KP707106781, TdV, TdS);
						  Tlp = FNMS(KP707106781, Tla, Tl9);
						  Tlb = FMA(KP707106781, Tla, Tl9);
						  Tfc = FNMS(KP098491403, Tfb, Tfa);
						  Tfg = FMA(KP098491403, Tfa, Tfb);
						  Tf0 = FMA(KP820678790, TeO, TeV);
						  TeW = FNMS(KP820678790, TeV, TeO);
						  Te2 = FNMS(KP414213562, Te1, Te0);
						  Tfk = FMA(KP414213562, Te0, Te1);
					     }
					}
					{
					     E Tlx, Tlr, TfO, Tfm, Tfe, Tli, Tlh, Tfh;
					     {
						  E Tlo, Tf2, Tld, TeY, Tln, Tf1;
						  {
						       E TeX, Tek, Tll, Tlm, Tlj;
						       Tlo = TeD + TeW;
						       TeX = TeD - TeW;
						       {
							    E Tlq, Te3, Tlc, Tfl, Te4;
							    Tlq = Te2 - TdZ;
							    Te3 = TdZ + Te2;
							    Tlc = Tfj + Tfk;
							    Tfl = Tfj - Tfk;
							    Tlx = FNMS(KP923879532, Tlq, Tlp);
							    Tlr = FMA(KP923879532, Tlq, Tlp);
							    Tf2 = FMA(KP923879532, Te3, TdW);
							    Te4 = FNMS(KP923879532, Te3, TdW);
							    Tlj = FNMS(KP923879532, Tlc, Tlb);
							    Tld = FMA(KP923879532, Tlc, Tlb);
							    TfO = FNMS(KP923879532, Tfl, Tfi);
							    Tfm = FMA(KP923879532, Tfl, Tfi);
							    Tek = FMA(KP980785280, Tej, Te4);
							    TeY = FNMS(KP980785280, Tej, Te4);
						       }
						       Tln = FNMS(KP980785280, Tlk, Tlj);
						       Tll = FMA(KP980785280, Tlk, Tlj);
						       Tlm = Tf0 - TeZ;
						       Tf1 = TeZ + Tf0;
						       ri[WS(rs, 9)] = FMA(KP773010453, TeX, Tek);
						       ri[WS(rs, 41)] = FNMS(KP773010453, TeX, Tek);
						       ii[WS(rs, 41)] = FNMS(KP773010453, Tlm, Tll);
						       ii[WS(rs, 9)] = FMA(KP773010453, Tlm, Tll);
						  }
						  {
						       E Tf6, Tfd, Tlf, Tlg;
						       Tfe = FNMS(KP980785280, Tf5, Tf2);
						       Tf6 = FMA(KP980785280, Tf5, Tf2);
						       ri[WS(rs, 57)] = FMA(KP773010453, Tf1, TeY);
						       ri[WS(rs, 25)] = FNMS(KP773010453, Tf1, TeY);
						       ii[WS(rs, 57)] = FMA(KP773010453, Tlo, Tln);
						       ii[WS(rs, 25)] = FNMS(KP773010453, Tlo, Tln);
						       Tfd = Tf9 + Tfc;
						       Tli = Tfc - Tf9;
						       Tlh = FNMS(KP980785280, Tle, Tld);
						       Tlf = FMA(KP980785280, Tle, Tld);
						       Tlg = Tff + Tfg;
						       Tfh = Tff - Tfg;
						       ri[WS(rs, 1)] = FMA(KP995184726, Tfd, Tf6);
						       ri[WS(rs, 33)] = FNMS(KP995184726, Tfd, Tf6);
						       ii[WS(rs, 33)] = FNMS(KP995184726, Tlg, Tlf);
						       ii[WS(rs, 1)] = FMA(KP995184726, Tlg, Tlf);
						  }
					     }
					     {
						  E TfK, Tlw, Tlv, TfN;
						  {
						       E Tfu, TfJ, Tlt, Tlu;
						       TfK = FNMS(KP831469612, Tft, Tfm);
						       Tfu = FMA(KP831469612, Tft, Tfm);
						       ri[WS(rs, 17)] = FMA(KP995184726, Tfh, Tfe);
						       ri[WS(rs, 49)] = FNMS(KP995184726, Tfh, Tfe);
						       ii[WS(rs, 49)] = FNMS(KP995184726, Tli, Tlh);
						       ii[WS(rs, 17)] = FMA(KP995184726, Tli, Tlh);
						       TfJ = TfB + TfI;
						       Tlw = TfI - TfB;
						       Tlv = FNMS(KP831469612, Tls, Tlr);
						       Tlt = FMA(KP831469612, Tls, Tlr);
						       Tlu = TfL + TfM;
						       TfN = TfL - TfM;
						       ri[WS(rs, 5)] = FMA(KP881921264, TfJ, Tfu);
						       ri[WS(rs, 37)] = FNMS(KP881921264, TfJ, Tfu);
						       ii[WS(rs, 37)] = FNMS(KP881921264, Tlu, Tlt);
						       ii[WS(rs, 5)] = FMA(KP881921264, Tlu, Tlt);
						  }
						  {
						       E TfS, TfZ, Tlz, TlA;
						       Tg0 = FMA(KP831469612, TfR, TfO);
						       TfS = FNMS(KP831469612, TfR, TfO);
						       ri[WS(rs, 21)] = FMA(KP881921264, TfN, TfK);
						       ri[WS(rs, 53)] = FNMS(KP881921264, TfN, TfK);
						       ii[WS(rs, 53)] = FNMS(KP881921264, Tlw, Tlv);
						       ii[WS(rs, 21)] = FMA(KP881921264, Tlw, Tlv);
						       TfZ = TfV - TfY;
						       TlC = TfV + TfY;
						       TlB = FMA(KP831469612, Tly, Tlx);
						       Tlz = FNMS(KP831469612, Tly, Tlx);
						       TlA = Tg2 - Tg1;
						       Tg3 = Tg1 + Tg2;
						       ri[WS(rs, 13)] = FMA(KP956940335, TfZ, TfS);
						       ri[WS(rs, 45)] = FNMS(KP956940335, TfZ, TfS);
						       ii[WS(rs, 45)] = FNMS(KP956940335, TlA, Tlz);
						       ii[WS(rs, 13)] = FMA(KP956940335, TlA, Tlz);
						  }
					     }
					}
				   }
			      }
			 }
		    }
	       }
	       ri[WS(rs, 61)] = FMA(KP956940335, Tg3, Tg0);
	       ri[WS(rs, 29)] = FNMS(KP956940335, Tg3, Tg0);
	       ii[WS(rs, 61)] = FMA(KP956940335, TlC, TlB);
	       ii[WS(rs, 29)] = FNMS(KP956940335, TlC, TlB);
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_CEXP, 0, 9},
     {TW_CEXP, 0, 27},
     {TW_CEXP, 0, 63},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 64, "t2_64", twinstr, &GENUS, {520, 206, 634, 0}, 0, 0, 0 };

void X(codelet_t2_64) (planner *p) {
     X(kdft_dit_register) (p, t2_64, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_twiddle.native -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 64 -name t2_64 -include t.h */

/*
 * This function contains 1154 FP additions, 660 FP multiplications,
 * (or, 880 additions, 386 multiplications, 274 fused multiply/add),
 * 302 stack variables, 15 constants, and 256 memory accesses
 */
#include "t.h"

static void t2_64(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + (mb * 10); m < me; m = m + 1, ri = ri + ms, ii = ii + ms, W = W + 10, MAKE_VOLATILE_STRIDE(128, rs)) {
	       E T2, T5, T3, T6, Te, T9, TP, T3e, T1e, T39, T3c, TT, T1a, T37, T8;
	       E Tw, Td, Ty, Tm, Th, T1C, T3K, T1V, T3x, T3I, T1G, T1R, T3v, T2m, T2q;
	       E T5Y, T6u, T53, T5B, T62, T6w, T57, T5D, T2V, T2X, Tg, TE, T3Y, T3V, T3j;
	       E Tl, TA, T3g, T1j, T1t, TV, T2C, T2z, T1u, TZ, T1h, To, T1p, T6j, T6H;
	       E Ts, T1l, T6l, T6F, T2P, T4b, T4x, T5i, T2R, T49, T4z, T5g, TG, T4k, T4m;
	       E TK, T21, T3O, T3Q, T25, TW, T10, T11, T79, T6X, T5M, T6b, T1v, T30, T69;
	       E T77, T13, T2F, T2D, T6p, T6O, T1x, T2a, T2f, T6V, T28, T6r, T2h, T6Q, T32;
	       E T5K, T5w, T4G, T4Q, T3m, T4h, T4I, T5y, T3k, T4f, T41, T4S, T4Y, T3q, T3D;
	       E T3F, T5r, T3s, T4W, T3Z, T5p;
	       {
		    E Ta, Tj, Tx, TC, Tf, Tk, Tz, TD, T1B, T1E, T2o, T2l, T1T, T1Q, T1A;
		    E T1F, T2p, T2k, T1U, T1P;
		    {
			 E T4, T1d, T19, Tb, T1c, T7, Tc, T18, TR, TO, TS, TN;
			 T2 = W[0];
			 T5 = W[1];
			 T3 = W[2];
			 T6 = W[3];
			 Te = W[5];
			 T9 = W[4];
			 T4 = T2 * T3;
			 T1d = T5 * T9;
			 T19 = T5 * Te;
			 Tb = T2 * T6;
			 T1c = T2 * Te;
			 T7 = T5 * T6;
			 Tc = T5 * T3;
			 T18 = T2 * T9;
			 TR = T3 * Te;
			 TO = T6 * Te;
			 TS = T6 * T9;
			 TN = T3 * T9;
			 TP = TN - TO;
			 T3e = TR - TS;
			 T1e = T1c - T1d;
			 T39 = T1c + T1d;
			 T3c = TN + TO;
			 TT = TR + TS;
			 T1a = T18 + T19;
			 T37 = T18 - T19;
			 T8 = T4 - T7;
			 Ta = T8 * T9;
			 Tj = T8 * Te;
			 Tw = T4 + T7;
			 Tx = Tw * T9;
			 TC = Tw * Te;
			 Td = Tb + Tc;
			 Tf = Td * Te;
			 Tk = Td * T9;
			 Ty = Tb - Tc;
			 Tz = Ty * Te;
			 TD = Ty * T9;
			 Tm = W[7];
			 T1B = T6 * Tm;
			 T1E = T3 * Tm;
			 T2o = T2 * Tm;
			 T2l = T5 * Tm;
			 T1T = T9 * Tm;
			 T1Q = Te * Tm;
			 Th = W[6];
			 T1A = T3 * Th;
			 T1F = T6 * Th;
			 T2p = T5 * Th;
			 T2k = T2 * Th;
			 T1U = Te * Th;
			 T1P = T9 * Th;
		    }
		    T1C = T1A + T1B;
		    T3K = T1E + T1F;
		    T1V = T1T + T1U;
		    T3x = T2o - T2p;
		    T3I = T1A - T1B;
		    T1G = T1E - T1F;
		    T1R = T1P - T1Q;
		    {
			 E T5W, T5X, T55, T56;
			 T3v = T2k + T2l;
			 T2m = T2k - T2l;
			 T2q = T2o + T2p;
			 T5W = T8 * Th;
			 T5X = Td * Tm;
			 T5Y = T5W - T5X;
			 T6u = T5W + T5X;
			 {
			      E T51, T52, T60, T61;
			      T51 = Tw * Th;
			      T52 = Ty * Tm;
			      T53 = T51 + T52;
			      T5B = T51 - T52;
			      T60 = T8 * Tm;
			      T61 = Td * Th;
			      T62 = T60 + T61;
			      T6w = T60 - T61;
			 }
			 T55 = Tw * Tm;
			 T56 = Ty * Th;
			 T57 = T55 - T56;
			 T5D = T55 + T56;
			 {
			      E Ti, Tq, TF, TJ, T3W, T3X, T3T, T3U, T3h, T3i, Tn, Tr, TB, TI, T3d;
			      E T3f, T1k, T1o, T1Z, T23, TQ, TU, T2A, T2B, T2x, T2y, T20, T24, TX, TY;
			      E T1i, T1n;
			      T2V = T1P + T1Q;
			      T2X = T1T - T1U;
			      Tg = Ta + Tf;
			      Ti = Tg * Th;
			      Tq = Tg * Tm;
			      TE = TC + TD;
			      TF = TE * Tm;
			      TJ = TE * Th;
			      T3W = T37 * Tm;
			      T3X = T39 * Th;
			      T3Y = T3W - T3X;
			      T3T = T37 * Th;
			      T3U = T39 * Tm;
			      T3V = T3T + T3U;
			      T3h = T3c * Tm;
			      T3i = T3e * Th;
			      T3j = T3h - T3i;
			      Tl = Tj - Tk;
			      Tn = Tl * Tm;
			      Tr = Tl * Th;
			      TA = Tx - Tz;
			      TB = TA * Th;
			      TI = TA * Tm;
			      T3d = T3c * Th;
			      T3f = T3e * Tm;
			      T3g = T3d + T3f;
			      T1j = Tj + Tk;
			      T1k = T1j * Tm;
			      T1o = T1j * Th;
			      T1t = Tx + Tz;
			      T1Z = T1t * Th;
			      T23 = T1t * Tm;
			      TQ = TP * Th;
			      TU = TT * Tm;
			      TV = TQ + TU;
			      T2A = T1a * Tm;
			      T2B = T1e * Th;
			      T2C = T2A - T2B;
			      T2x = T1a * Th;
			      T2y = T1e * Tm;
			      T2z = T2x + T2y;
			      T1u = TC - TD;
			      T20 = T1u * Tm;
			      T24 = T1u * Th;
			      TX = TP * Tm;
			      TY = TT * Th;
			      TZ = TX - TY;
			      T1h = Ta - Tf;
			      T1i = T1h * Th;
			      T1n = T1h * Tm;
			      To = Ti - Tn;
			      T1p = T1n + T1o;
			      T6j = TQ - TU;
			      T6H = T2A + T2B;
			      Ts = Tq + Tr;
			      T1l = T1i - T1k;
			      T6l = TX + TY;
			      T6F = T2x - T2y;
			      T2P = T1Z - T20;
			      T4b = TI + TJ;
			      T4x = T3d - T3f;
			      T5i = T3W + T3X;
			      T2R = T23 + T24;
			      T49 = TB - TF;
			      T4z = T3h + T3i;
			      T5g = T3T - T3U;
			      TG = TB + TF;
			      T4k = Ti + Tn;
			      T4m = Tq - Tr;
			      TK = TI - TJ;
			      T21 = T1Z + T20;
			      T3O = T1i + T1k;
			      T3Q = T1n - T1o;
			      T25 = T23 - T24;
			      TW = W[8];
			      T10 = W[9];
			      T11 = FMA(TV, TW, TZ * T10);
			      T79 = FNMS(T25, TW, T21 * T10);
			      T6X = FNMS(Td, TW, T8 * T10);
			      T5M = FNMS(T2X, TW, T2V * T10);
			      T6b = FNMS(TK, TW, TG * T10);
			      T1v = FMA(T1t, TW, T1u * T10);
			      T30 = FMA(T1h, TW, T1j * T10);
			      T69 = FMA(TG, TW, TK * T10);
			      T77 = FMA(T21, TW, T25 * T10);
			      T13 = FNMS(TZ, TW, TV * T10);
			      T2F = FNMS(T2C, TW, T2z * T10);
			      T2D = FMA(T2z, TW, T2C * T10);
			      T6p = FMA(T1a, TW, T1e * T10);
			      T6O = FMA(TP, TW, TT * T10);
			      T1x = FNMS(T1u, TW, T1t * T10);
			      T2a = FNMS(TE, TW, TA * T10);
			      T2f = FMA(T3, TW, T6 * T10);
			      T6V = FMA(T8, TW, Td * T10);
			      T28 = FMA(TA, TW, TE * T10);
			      T6r = FNMS(T1e, TW, T1a * T10);
			      T2h = FNMS(T6, TW, T3 * T10);
			      T6Q = FNMS(TT, TW, TP * T10);
			      T32 = FNMS(T1j, TW, T1h * T10);
			      T5K = FMA(T2V, TW, T2X * T10);
			      T5w = FMA(Tw, TW, Ty * T10);
			      T4G = FMA(T3O, TW, T3Q * T10);
			      T4Q = FMA(T4k, TW, T4m * T10);
			      T3m = FNMS(T3j, TW, T3g * T10);
			      T4h = FNMS(Te, TW, T9 * T10);
			      T4I = FNMS(T3Q, TW, T3O * T10);
			      T5y = FNMS(Ty, TW, Tw * T10);
			      T3k = FMA(T3g, TW, T3j * T10);
			      T4f = FMA(T9, TW, Te * T10);
			      T41 = FNMS(T3Y, TW, T3V * T10);
			      T4S = FNMS(T4m, TW, T4k * T10);
			      T4Y = FNMS(T3e, TW, T3c * T10);
			      T3q = FMA(Tg, TW, Tl * T10);
			      T3D = FMA(T2, TW, T5 * T10);
			      T3F = FNMS(T5, TW, T2 * T10);
			      T5r = FNMS(T39, TW, T37 * T10);
			      T3s = FNMS(Tl, TW, Tg * T10);
			      T4W = FMA(T3c, TW, T3e * T10);
			      T3Z = FMA(T3V, TW, T3Y * T10);
			      T5p = FMA(T37, TW, T39 * T10);
			 }
		    }
	       }
	       {
		    E T17, TdV, Tj3, Tjx, T7l, TbJ, Ti3, Tix, T1K, Tiw, TdY, ThY, T7w, Tj0, TbM;
		    E Tjw, T2e, TgA, T7I, TaY, TbQ, Tda, Te4, TfO, T2J, TgB, T7T, TaZ, TbT, Tdb;
		    E Te9, TfP, T36, T3B, TgH, TgE, TgF, TgG, T80, TbW, Tel, TfT, T8b, Tc0, T8k;
		    E TbX, Teg, TfS, T8h, TbZ, T45, T4q, TgJ, TgK, TgL, TgM, T8r, Tc6, Tew, TfW;
		    E T8C, Tc4, T8L, Tc7, Ter, TfV, T8I, Tc3, T6B, Th1, Tfm, Tga, Th8, ThI, T9N;
		    E Tcv, T9Y, TcH, Tav, Tcw, Tf5, Tg7, Tas, TcG, T5c, TgV, TeV, Tg0, TgS, ThD;
		    E T8U, Tcc, T95, Tco, T9C, Tcd, TeE, Tg3, T9z, Tcn, T5R, TgT, TeO, TeW, TgY;
		    E ThE, T9h, T9F, T9s, T9E, Tck, Tcq, TeJ, TeX, Tch, Tcr, T7e, Th9, Tff, Tfn;
		    E Th4, ThJ, Taa, Tay, Tal, Tax, TcD, TcJ, Tfa, Tfo, TcA, TcK;
		    {
			 E T1, Ti1, Tu, Ti0, TM, T7i, T15, T7j, Tp, Tt;
			 T1 = ri[0];
			 Ti1 = ii[0];
			 Tp = ri[WS(rs, 32)];
			 Tt = ii[WS(rs, 32)];
			 Tu = FMA(To, Tp, Ts * Tt);
			 Ti0 = FNMS(Ts, Tp, To * Tt);
			 {
			      E TH, TL, T12, T14;
			      TH = ri[WS(rs, 16)];
			      TL = ii[WS(rs, 16)];
			      TM = FMA(TG, TH, TK * TL);
			      T7i = FNMS(TK, TH, TG * TL);
			      T12 = ri[WS(rs, 48)];
			      T14 = ii[WS(rs, 48)];
			      T15 = FMA(T11, T12, T13 * T14);
			      T7j = FNMS(T13, T12, T11 * T14);
			 }
			 {
			      E Tv, T16, Tj1, Tj2;
			      Tv = T1 + Tu;
			      T16 = TM + T15;
			      T17 = Tv + T16;
			      TdV = Tv - T16;
			      Tj1 = Ti1 - Ti0;
			      Tj2 = TM - T15;
			      Tj3 = Tj1 - Tj2;
			      Tjx = Tj2 + Tj1;
			 }
			 {
			      E T7h, T7k, ThZ, Ti2;
			      T7h = T1 - Tu;
			      T7k = T7i - T7j;
			      T7l = T7h - T7k;
			      TbJ = T7h + T7k;
			      ThZ = T7i + T7j;
			      Ti2 = Ti0 + Ti1;
			      Ti3 = ThZ + Ti2;
			      Tix = Ti2 - ThZ;
			 }
		    }
		    {
			 E T1g, T7m, T1r, T7n, T7o, T7p, T1z, T7s, T1I, T7t, T7r, T7u;
			 {
			      E T1b, T1f, T1m, T1q;
			      T1b = ri[WS(rs, 8)];
			      T1f = ii[WS(rs, 8)];
			      T1g = FMA(T1a, T1b, T1e * T1f);
			      T7m = FNMS(T1e, T1b, T1a * T1f);
			      T1m = ri[WS(rs, 40)];
			      T1q = ii[WS(rs, 40)];
			      T1r = FMA(T1l, T1m, T1p * T1q);
			      T7n = FNMS(T1p, T1m, T1l * T1q);
			 }
			 T7o = T7m - T7n;
			 T7p = T1g - T1r;
			 {
			      E T1w, T1y, T1D, T1H;
			      T1w = ri[WS(rs, 56)];
			      T1y = ii[WS(rs, 56)];
			      T1z = FMA(T1v, T1w, T1x * T1y);
			      T7s = FNMS(T1x, T1w, T1v * T1y);
			      T1D = ri[WS(rs, 24)];
			      T1H = ii[WS(rs, 24)];
			      T1I = FMA(T1C, T1D, T1G * T1H);
			      T7t = FNMS(T1G, T1D, T1C * T1H);
			 }
			 T7r = T1z - T1I;
			 T7u = T7s - T7t;
			 {
			      E T1s, T1J, TdW, TdX;
			      T1s = T1g + T1r;
			      T1J = T1z + T1I;
			      T1K = T1s + T1J;
			      Tiw = T1J - T1s;
			      TdW = T7m + T7n;
			      TdX = T7s + T7t;
			      TdY = TdW - TdX;
			      ThY = TdW + TdX;
			 }
			 {
			      E T7q, T7v, TbK, TbL;
			      T7q = T7o - T7p;
			      T7v = T7r + T7u;
			      T7w = KP707106781 * (T7q - T7v);
			      Tj0 = KP707106781 * (T7q + T7v);
			      TbK = T7p + T7o;
			      TbL = T7r - T7u;
			      TbM = KP707106781 * (TbK + TbL);
			      Tjw = KP707106781 * (TbL - TbK);
			 }
		    }
		    {
			 E T1Y, Te0, T7A, T7D, T2d, Te1, T7B, T7G, T7C, T7H;
			 {
			      E T1O, T7y, T1X, T7z;
			      {
				   E T1M, T1N, T1S, T1W;
				   T1M = ri[WS(rs, 4)];
				   T1N = ii[WS(rs, 4)];
				   T1O = FMA(T8, T1M, Td * T1N);
				   T7y = FNMS(Td, T1M, T8 * T1N);
				   T1S = ri[WS(rs, 36)];
				   T1W = ii[WS(rs, 36)];
				   T1X = FMA(T1R, T1S, T1V * T1W);
				   T7z = FNMS(T1V, T1S, T1R * T1W);
			      }
			      T1Y = T1O + T1X;
			      Te0 = T7y + T7z;
			      T7A = T7y - T7z;
			      T7D = T1O - T1X;
			 }
			 {
			      E T27, T7E, T2c, T7F;
			      {
				   E T22, T26, T29, T2b;
				   T22 = ri[WS(rs, 20)];
				   T26 = ii[WS(rs, 20)];
				   T27 = FMA(T21, T22, T25 * T26);
				   T7E = FNMS(T25, T22, T21 * T26);
				   T29 = ri[WS(rs, 52)];
				   T2b = ii[WS(rs, 52)];
				   T2c = FMA(T28, T29, T2a * T2b);
				   T7F = FNMS(T2a, T29, T28 * T2b);
			      }
			      T2d = T27 + T2c;
			      Te1 = T7E + T7F;
			      T7B = T27 - T2c;
			      T7G = T7E - T7F;
			 }
			 T2e = T1Y + T2d;
			 TgA = Te0 + Te1;
			 T7C = T7A + T7B;
			 T7H = T7D - T7G;
			 T7I = FNMS(KP923879532, T7H, KP382683432 * T7C);
			 TaY = FMA(KP923879532, T7C, KP382683432 * T7H);
			 {
			      E TbO, TbP, Te2, Te3;
			      TbO = T7A - T7B;
			      TbP = T7D + T7G;
			      TbQ = FNMS(KP382683432, TbP, KP923879532 * TbO);
			      Tda = FMA(KP382683432, TbO, KP923879532 * TbP);
			      Te2 = Te0 - Te1;
			      Te3 = T1Y - T2d;
			      Te4 = Te2 - Te3;
			      TfO = Te3 + Te2;
			 }
		    }
		    {
			 E T2t, Te6, T7L, T7O, T2I, Te7, T7M, T7R, T7N, T7S;
			 {
			      E T2j, T7J, T2s, T7K;
			      {
				   E T2g, T2i, T2n, T2r;
				   T2g = ri[WS(rs, 60)];
				   T2i = ii[WS(rs, 60)];
				   T2j = FMA(T2f, T2g, T2h * T2i);
				   T7J = FNMS(T2h, T2g, T2f * T2i);
				   T2n = ri[WS(rs, 28)];
				   T2r = ii[WS(rs, 28)];
				   T2s = FMA(T2m, T2n, T2q * T2r);
				   T7K = FNMS(T2q, T2n, T2m * T2r);
			      }
			      T2t = T2j + T2s;
			      Te6 = T7J + T7K;
			      T7L = T7J - T7K;
			      T7O = T2j - T2s;
			 }
			 {
			      E T2w, T7P, T2H, T7Q;
			      {
				   E T2u, T2v, T2E, T2G;
				   T2u = ri[WS(rs, 12)];
				   T2v = ii[WS(rs, 12)];
				   T2w = FMA(TP, T2u, TT * T2v);
				   T7P = FNMS(TT, T2u, TP * T2v);
				   T2E = ri[WS(rs, 44)];
				   T2G = ii[WS(rs, 44)];
				   T2H = FMA(T2D, T2E, T2F * T2G);
				   T7Q = FNMS(T2F, T2E, T2D * T2G);
			      }
			      T2I = T2w + T2H;
			      Te7 = T7P + T7Q;
			      T7M = T2w - T2H;
			      T7R = T7P - T7Q;
			 }
			 T2J = T2t + T2I;
			 TgB = Te6 + Te7;
			 T7N = T7L + T7M;
			 T7S = T7O - T7R;
			 T7T = FMA(KP382683432, T7N, KP923879532 * T7S);
			 TaZ = FNMS(KP923879532, T7N, KP382683432 * T7S);
			 {
			      E TbR, TbS, Te5, Te8;
			      TbR = T7L - T7M;
			      TbS = T7O + T7R;
			      TbT = FMA(KP923879532, TbR, KP382683432 * TbS);
			      Tdb = FNMS(KP382683432, TbR, KP923879532 * TbS);
			      Te5 = T2t - T2I;
			      Te8 = Te6 - Te7;
			      Te9 = Te5 + Te8;
			      TfP = Te5 - Te8;
			 }
		    }
		    {
			 E T2O, T7W, T2T, T7X, T2U, Tec, T2Z, T8e, T34, T8f, T35, Ted, T3p, Tei, T86;
			 E T89, T3A, Tej, T81, T84;
			 {
			      E T2M, T2N, T2Q, T2S;
			      T2M = ri[WS(rs, 2)];
			      T2N = ii[WS(rs, 2)];
			      T2O = FMA(Tw, T2M, Ty * T2N);
			      T7W = FNMS(Ty, T2M, Tw * T2N);
			      T2Q = ri[WS(rs, 34)];
			      T2S = ii[WS(rs, 34)];
			      T2T = FMA(T2P, T2Q, T2R * T2S);
			      T7X = FNMS(T2R, T2Q, T2P * T2S);
			 }
			 T2U = T2O + T2T;
			 Tec = T7W + T7X;
			 {
			      E T2W, T2Y, T31, T33;
			      T2W = ri[WS(rs, 18)];
			      T2Y = ii[WS(rs, 18)];
			      T2Z = FMA(T2V, T2W, T2X * T2Y);
			      T8e = FNMS(T2X, T2W, T2V * T2Y);
			      T31 = ri[WS(rs, 50)];
			      T33 = ii[WS(rs, 50)];
			      T34 = FMA(T30, T31, T32 * T33);
			      T8f = FNMS(T32, T31, T30 * T33);
			 }
			 T35 = T2Z + T34;
			 Ted = T8e + T8f;
			 {
			      E T3b, T87, T3o, T88;
			      {
				   E T38, T3a, T3l, T3n;
				   T38 = ri[WS(rs, 10)];
				   T3a = ii[WS(rs, 10)];
				   T3b = FMA(T37, T38, T39 * T3a);
				   T87 = FNMS(T39, T38, T37 * T3a);
				   T3l = ri[WS(rs, 42)];
				   T3n = ii[WS(rs, 42)];
				   T3o = FMA(T3k, T3l, T3m * T3n);
				   T88 = FNMS(T3m, T3l, T3k * T3n);
			      }
			      T3p = T3b + T3o;
			      Tei = T87 + T88;
			      T86 = T3b - T3o;
			      T89 = T87 - T88;
			 }
			 {
			      E T3u, T82, T3z, T83;
			      {
				   E T3r, T3t, T3w, T3y;
				   T3r = ri[WS(rs, 58)];
				   T3t = ii[WS(rs, 58)];
				   T3u = FMA(T3q, T3r, T3s * T3t);
				   T82 = FNMS(T3s, T3r, T3q * T3t);
				   T3w = ri[WS(rs, 26)];
				   T3y = ii[WS(rs, 26)];
				   T3z = FMA(T3v, T3w, T3x * T3y);
				   T83 = FNMS(T3x, T3w, T3v * T3y);
			      }
			      T3A = T3u + T3z;
			      Tej = T82 + T83;
			      T81 = T3u - T3z;
			      T84 = T82 - T83;
			 }
			 T36 = T2U + T35;
			 T3B = T3p + T3A;
			 TgH = T36 - T3B;
			 TgE = Tec + Ted;
			 TgF = Tei + Tej;
			 TgG = TgE - TgF;
			 {
			      E T7Y, T7Z, Teh, Tek;
			      T7Y = T7W - T7X;
			      T7Z = T2Z - T34;
			      T80 = T7Y + T7Z;
			      TbW = T7Y - T7Z;
			      Teh = T2U - T35;
			      Tek = Tei - Tej;
			      Tel = Teh - Tek;
			      TfT = Teh + Tek;
			 }
			 {
			      E T85, T8a, T8i, T8j;
			      T85 = T81 - T84;
			      T8a = T86 + T89;
			      T8b = KP707106781 * (T85 - T8a);
			      Tc0 = KP707106781 * (T8a + T85);
			      T8i = T89 - T86;
			      T8j = T81 + T84;
			      T8k = KP707106781 * (T8i - T8j);
			      TbX = KP707106781 * (T8i + T8j);
			 }
			 {
			      E Tee, Tef, T8d, T8g;
			      Tee = Tec - Ted;
			      Tef = T3A - T3p;
			      Teg = Tee - Tef;
			      TfS = Tee + Tef;
			      T8d = T2O - T2T;
			      T8g = T8e - T8f;
			      T8h = T8d - T8g;
			      TbZ = T8d + T8g;
			 }
		    }
		    {
			 E T3H, T8n, T3M, T8o, T3N, Ten, T3S, T8F, T43, T8G, T44, Teo, T4e, Tet, T8x;
			 E T8A, T4p, Teu, T8s, T8v;
			 {
			      E T3E, T3G, T3J, T3L;
			      T3E = ri[WS(rs, 62)];
			      T3G = ii[WS(rs, 62)];
			      T3H = FMA(T3D, T3E, T3F * T3G);
			      T8n = FNMS(T3F, T3E, T3D * T3G);
			      T3J = ri[WS(rs, 30)];
			      T3L = ii[WS(rs, 30)];
			      T3M = FMA(T3I, T3J, T3K * T3L);
			      T8o = FNMS(T3K, T3J, T3I * T3L);
			 }
			 T3N = T3H + T3M;
			 Ten = T8n + T8o;
			 {
			      E T3P, T3R, T40, T42;
			      T3P = ri[WS(rs, 14)];
			      T3R = ii[WS(rs, 14)];
			      T3S = FMA(T3O, T3P, T3Q * T3R);
			      T8F = FNMS(T3Q, T3P, T3O * T3R);
			      T40 = ri[WS(rs, 46)];
			      T42 = ii[WS(rs, 46)];
			      T43 = FMA(T3Z, T40, T41 * T42);
			      T8G = FNMS(T41, T40, T3Z * T42);
			 }
			 T44 = T3S + T43;
			 Teo = T8F + T8G;
			 {
			      E T48, T8y, T4d, T8z;
			      {
				   E T46, T47, T4a, T4c;
				   T46 = ri[WS(rs, 6)];
				   T47 = ii[WS(rs, 6)];
				   T48 = FMA(T3c, T46, T3e * T47);
				   T8y = FNMS(T3e, T46, T3c * T47);
				   T4a = ri[WS(rs, 38)];
				   T4c = ii[WS(rs, 38)];
				   T4d = FMA(T49, T4a, T4b * T4c);
				   T8z = FNMS(T4b, T4a, T49 * T4c);
			      }
			      T4e = T48 + T4d;
			      Tet = T8y + T8z;
			      T8x = T48 - T4d;
			      T8A = T8y - T8z;
			 }
			 {
			      E T4j, T8t, T4o, T8u;
			      {
				   E T4g, T4i, T4l, T4n;
				   T4g = ri[WS(rs, 54)];
				   T4i = ii[WS(rs, 54)];
				   T4j = FMA(T4f, T4g, T4h * T4i);
				   T8t = FNMS(T4h, T4g, T4f * T4i);
				   T4l = ri[WS(rs, 22)];
				   T4n = ii[WS(rs, 22)];
				   T4o = FMA(T4k, T4l, T4m * T4n);
				   T8u = FNMS(T4m, T4l, T4k * T4n);
			      }
			      T4p = T4j + T4o;
			      Teu = T8t + T8u;
			      T8s = T4j - T4o;
			      T8v = T8t - T8u;
			 }
			 T45 = T3N + T44;
			 T4q = T4e + T4p;
			 TgJ = T45 - T4q;
			 TgK = Ten + Teo;
			 TgL = Tet + Teu;
			 TgM = TgK - TgL;
			 {
			      E T8p, T8q, Tes, Tev;
			      T8p = T8n - T8o;
			      T8q = T3S - T43;
			      T8r = T8p + T8q;
			      Tc6 = T8p - T8q;
			      Tes = T3N - T44;
			      Tev = Tet - Teu;
			      Tew = Tes - Tev;
			      TfW = Tes + Tev;
			 }
			 {
			      E T8w, T8B, T8J, T8K;
			      T8w = T8s - T8v;
			      T8B = T8x + T8A;
			      T8C = KP707106781 * (T8w - T8B);
			      Tc4 = KP707106781 * (T8B + T8w);
			      T8J = T8A - T8x;
			      T8K = T8s + T8v;
			      T8L = KP707106781 * (T8J - T8K);
			      Tc7 = KP707106781 * (T8J + T8K);
			 }
			 {
			      E Tep, Teq, T8E, T8H;
			      Tep = Ten - Teo;
			      Teq = T4p - T4e;
			      Ter = Tep - Teq;
			      TfV = Tep + Teq;
			      T8E = T3H - T3M;
			      T8H = T8F - T8G;
			      T8I = T8E - T8H;
			      Tc3 = T8E + T8H;
			 }
		    }
		    {
			 E T5V, Tao, T64, Tap, T65, Tfi, T68, T9K, T6d, T9L, T6e, Tfj, T6o, Tf2, T9Q;
			 E T9R, T6z, Tf3, T9T, T9W;
			 {
			      E T5T, T5U, T5Z, T63;
			      T5T = ri[WS(rs, 63)];
			      T5U = ii[WS(rs, 63)];
			      T5V = FMA(TW, T5T, T10 * T5U);
			      Tao = FNMS(T10, T5T, TW * T5U);
			      T5Z = ri[WS(rs, 31)];
			      T63 = ii[WS(rs, 31)];
			      T64 = FMA(T5Y, T5Z, T62 * T63);
			      Tap = FNMS(T62, T5Z, T5Y * T63);
			 }
			 T65 = T5V + T64;
			 Tfi = Tao + Tap;
			 {
			      E T66, T67, T6a, T6c;
			      T66 = ri[WS(rs, 15)];
			      T67 = ii[WS(rs, 15)];
			      T68 = FMA(TV, T66, TZ * T67);
			      T9K = FNMS(TZ, T66, TV * T67);
			      T6a = ri[WS(rs, 47)];
			      T6c = ii[WS(rs, 47)];
			      T6d = FMA(T69, T6a, T6b * T6c);
			      T9L = FNMS(T6b, T6a, T69 * T6c);
			 }
			 T6e = T68 + T6d;
			 Tfj = T9K + T9L;
			 {
			      E T6i, T9O, T6n, T9P;
			      {
				   E T6g, T6h, T6k, T6m;
				   T6g = ri[WS(rs, 7)];
				   T6h = ii[WS(rs, 7)];
				   T6i = FMA(T1t, T6g, T1u * T6h);
				   T9O = FNMS(T1u, T6g, T1t * T6h);
				   T6k = ri[WS(rs, 39)];
				   T6m = ii[WS(rs, 39)];
				   T6n = FMA(T6j, T6k, T6l * T6m);
				   T9P = FNMS(T6l, T6k, T6j * T6m);
			      }
			      T6o = T6i + T6n;
			      Tf2 = T9O + T9P;
			      T9Q = T9O - T9P;
			      T9R = T6i - T6n;
			 }
			 {
			      E T6t, T9U, T6y, T9V;
			      {
				   E T6q, T6s, T6v, T6x;
				   T6q = ri[WS(rs, 55)];
				   T6s = ii[WS(rs, 55)];
				   T6t = FMA(T6p, T6q, T6r * T6s);
				   T9U = FNMS(T6r, T6q, T6p * T6s);
				   T6v = ri[WS(rs, 23)];
				   T6x = ii[WS(rs, 23)];
				   T6y = FMA(T6u, T6v, T6w * T6x);
				   T9V = FNMS(T6w, T6v, T6u * T6x);
			      }
			      T6z = T6t + T6y;
			      Tf3 = T9U + T9V;
			      T9T = T6t - T6y;
			      T9W = T9U - T9V;
			 }
			 {
			      E T6f, T6A, Tfk, Tfl;
			      T6f = T65 + T6e;
			      T6A = T6o + T6z;
			      T6B = T6f + T6A;
			      Th1 = T6f - T6A;
			      Tfk = Tfi - Tfj;
			      Tfl = T6z - T6o;
			      Tfm = Tfk - Tfl;
			      Tga = Tfk + Tfl;
			 }
			 {
			      E Th6, Th7, T9J, T9M;
			      Th6 = Tfi + Tfj;
			      Th7 = Tf2 + Tf3;
			      Th8 = Th6 - Th7;
			      ThI = Th6 + Th7;
			      T9J = T5V - T64;
			      T9M = T9K - T9L;
			      T9N = T9J - T9M;
			      Tcv = T9J + T9M;
			 }
			 {
			      E T9S, T9X, Tat, Tau;
			      T9S = T9Q - T9R;
			      T9X = T9T + T9W;
			      T9Y = KP707106781 * (T9S - T9X);
			      TcH = KP707106781 * (T9S + T9X);
			      Tat = T9T - T9W;
			      Tau = T9R + T9Q;
			      Tav = KP707106781 * (Tat - Tau);
			      Tcw = KP707106781 * (Tau + Tat);
			 }
			 {
			      E Tf1, Tf4, Taq, Tar;
			      Tf1 = T65 - T6e;
			      Tf4 = Tf2 - Tf3;
			      Tf5 = Tf1 - Tf4;
			      Tg7 = Tf1 + Tf4;
			      Taq = Tao - Tap;
			      Tar = T68 - T6d;
			      Tas = Taq + Tar;
			      TcG = Taq - Tar;
			 }
		    }
		    {
			 E T4w, T8Q, T4B, T8R, T4C, TeA, T4F, T9w, T4K, T9x, T4L, TeB, T4V, TeS, T90;
			 E T93, T5a, TeT, T8V, T8Y;
			 {
			      E T4u, T4v, T4y, T4A;
			      T4u = ri[WS(rs, 1)];
			      T4v = ii[WS(rs, 1)];
			      T4w = FMA(T2, T4u, T5 * T4v);
			      T8Q = FNMS(T5, T4u, T2 * T4v);
			      T4y = ri[WS(rs, 33)];
			      T4A = ii[WS(rs, 33)];
			      T4B = FMA(T4x, T4y, T4z * T4A);
			      T8R = FNMS(T4z, T4y, T4x * T4A);
			 }
			 T4C = T4w + T4B;
			 TeA = T8Q + T8R;
			 {
			      E T4D, T4E, T4H, T4J;
			      T4D = ri[WS(rs, 17)];
			      T4E = ii[WS(rs, 17)];
			      T4F = FMA(T3V, T4D, T3Y * T4E);
			      T9w = FNMS(T3Y, T4D, T3V * T4E);
			      T4H = ri[WS(rs, 49)];
			      T4J = ii[WS(rs, 49)];
			      T4K = FMA(T4G, T4H, T4I * T4J);
			      T9x = FNMS(T4I, T4H, T4G * T4J);
			 }
			 T4L = T4F + T4K;
			 TeB = T9w + T9x;
			 {
			      E T4P, T91, T4U, T92;
			      {
				   E T4N, T4O, T4R, T4T;
				   T4N = ri[WS(rs, 9)];
				   T4O = ii[WS(rs, 9)];
				   T4P = FMA(T9, T4N, Te * T4O);
				   T91 = FNMS(Te, T4N, T9 * T4O);
				   T4R = ri[WS(rs, 41)];
				   T4T = ii[WS(rs, 41)];
				   T4U = FMA(T4Q, T4R, T4S * T4T);
				   T92 = FNMS(T4S, T4R, T4Q * T4T);
			      }
			      T4V = T4P + T4U;
			      TeS = T91 + T92;
			      T90 = T4P - T4U;
			      T93 = T91 - T92;
			 }
			 {
			      E T50, T8W, T59, T8X;
			      {
				   E T4X, T4Z, T54, T58;
				   T4X = ri[WS(rs, 57)];
				   T4Z = ii[WS(rs, 57)];
				   T50 = FMA(T4W, T4X, T4Y * T4Z);
				   T8W = FNMS(T4Y, T4X, T4W * T4Z);
				   T54 = ri[WS(rs, 25)];
				   T58 = ii[WS(rs, 25)];
				   T59 = FMA(T53, T54, T57 * T58);
				   T8X = FNMS(T57, T54, T53 * T58);
			      }
			      T5a = T50 + T59;
			      TeT = T8W + T8X;
			      T8V = T50 - T59;
			      T8Y = T8W - T8X;
			 }
			 {
			      E T4M, T5b, TeR, TeU;
			      T4M = T4C + T4L;
			      T5b = T4V + T5a;
			      T5c = T4M + T5b;
			      TgV = T4M - T5b;
			      TeR = T4C - T4L;
			      TeU = TeS - TeT;
			      TeV = TeR - TeU;
			      Tg0 = TeR + TeU;
			 }
			 {
			      E TgQ, TgR, T8S, T8T;
			      TgQ = TeA + TeB;
			      TgR = TeS + TeT;
			      TgS = TgQ - TgR;
			      ThD = TgQ + TgR;
			      T8S = T8Q - T8R;
			      T8T = T4F - T4K;
			      T8U = T8S + T8T;
			      Tcc = T8S - T8T;
			 }
			 {
			      E T8Z, T94, T9A, T9B;
			      T8Z = T8V - T8Y;
			      T94 = T90 + T93;
			      T95 = KP707106781 * (T8Z - T94);
			      Tco = KP707106781 * (T94 + T8Z);
			      T9A = T93 - T90;
			      T9B = T8V + T8Y;
			      T9C = KP707106781 * (T9A - T9B);
			      Tcd = KP707106781 * (T9A + T9B);
			 }
			 {
			      E TeC, TeD, T9v, T9y;
			      TeC = TeA - TeB;
			      TeD = T5a - T4V;
			      TeE = TeC - TeD;
			      Tg3 = TeC + TeD;
			      T9v = T4w - T4B;
			      T9y = T9w - T9x;
			      T9z = T9v - T9y;
			      Tcn = T9v + T9y;
			 }
		    }
		    {
			 E T5l, TeL, T9k, T9n, T5P, TeH, T9a, T9f, T5u, TeM, T9l, T9q, T5G, TeG, T97;
			 E T9e;
			 {
			      E T5f, T9i, T5k, T9j;
			      {
				   E T5d, T5e, T5h, T5j;
				   T5d = ri[WS(rs, 5)];
				   T5e = ii[WS(rs, 5)];
				   T5f = FMA(Tg, T5d, Tl * T5e);
				   T9i = FNMS(Tl, T5d, Tg * T5e);
				   T5h = ri[WS(rs, 37)];
				   T5j = ii[WS(rs, 37)];
				   T5k = FMA(T5g, T5h, T5i * T5j);
				   T9j = FNMS(T5i, T5h, T5g * T5j);
			      }
			      T5l = T5f + T5k;
			      TeL = T9i + T9j;
			      T9k = T9i - T9j;
			      T9n = T5f - T5k;
			 }
			 {
			      E T5J, T98, T5O, T99;
			      {
				   E T5H, T5I, T5L, T5N;
				   T5H = ri[WS(rs, 13)];
				   T5I = ii[WS(rs, 13)];
				   T5J = FMA(T1h, T5H, T1j * T5I);
				   T98 = FNMS(T1j, T5H, T1h * T5I);
				   T5L = ri[WS(rs, 45)];
				   T5N = ii[WS(rs, 45)];
				   T5O = FMA(T5K, T5L, T5M * T5N);
				   T99 = FNMS(T5M, T5L, T5K * T5N);
			      }
			      T5P = T5J + T5O;
			      TeH = T98 + T99;
			      T9a = T98 - T99;
			      T9f = T5J - T5O;
			 }
			 {
			      E T5o, T9o, T5t, T9p;
			      {
				   E T5m, T5n, T5q, T5s;
				   T5m = ri[WS(rs, 21)];
				   T5n = ii[WS(rs, 21)];
				   T5o = FMA(T3g, T5m, T3j * T5n);
				   T9o = FNMS(T3j, T5m, T3g * T5n);
				   T5q = ri[WS(rs, 53)];
				   T5s = ii[WS(rs, 53)];
				   T5t = FMA(T5p, T5q, T5r * T5s);
				   T9p = FNMS(T5r, T5q, T5p * T5s);
			      }
			      T5u = T5o + T5t;
			      TeM = T9o + T9p;
			      T9l = T5o - T5t;
			      T9q = T9o - T9p;
			 }
			 {
			      E T5A, T9c, T5F, T9d;
			      {
				   E T5x, T5z, T5C, T5E;
				   T5x = ri[WS(rs, 61)];
				   T5z = ii[WS(rs, 61)];
				   T5A = FMA(T5w, T5x, T5y * T5z);
				   T9c = FNMS(T5y, T5x, T5w * T5z);
				   T5C = ri[WS(rs, 29)];
				   T5E = ii[WS(rs, 29)];
				   T5F = FMA(T5B, T5C, T5D * T5E);
				   T9d = FNMS(T5D, T5C, T5B * T5E);
			      }
			      T5G = T5A + T5F;
			      TeG = T9c + T9d;
			      T97 = T5A - T5F;
			      T9e = T9c - T9d;
			 }
			 {
			      E T5v, T5Q, TeK, TeN;
			      T5v = T5l + T5u;
			      T5Q = T5G + T5P;
			      T5R = T5v + T5Q;
			      TgT = T5Q - T5v;
			      TeK = T5l - T5u;
			      TeN = TeL - TeM;
			      TeO = TeK + TeN;
			      TeW = TeN - TeK;
			 }
			 {
			      E TgW, TgX, T9b, T9g;
			      TgW = TeL + TeM;
			      TgX = TeG + TeH;
			      TgY = TgW - TgX;
			      ThE = TgW + TgX;
			      T9b = T97 - T9a;
			      T9g = T9e + T9f;
			      T9h = FNMS(KP923879532, T9g, KP382683432 * T9b);
			      T9F = FMA(KP382683432, T9g, KP923879532 * T9b);
			 }
			 {
			      E T9m, T9r, Tci, Tcj;
			      T9m = T9k + T9l;
			      T9r = T9n - T9q;
			      T9s = FMA(KP923879532, T9m, KP382683432 * T9r);
			      T9E = FNMS(KP923879532, T9r, KP382683432 * T9m);
			      Tci = T9k - T9l;
			      Tcj = T9n + T9q;
			      Tck = FMA(KP382683432, Tci, KP923879532 * Tcj);
			      Tcq = FNMS(KP382683432, Tcj, KP923879532 * Tci);
			 }
			 {
			      E TeF, TeI, Tcf, Tcg;
			      TeF = T5G - T5P;
			      TeI = TeG - TeH;
			      TeJ = TeF - TeI;
			      TeX = TeF + TeI;
			      Tcf = T97 + T9a;
			      Tcg = T9e - T9f;
			      Tch = FNMS(KP382683432, Tcg, KP923879532 * Tcf);
			      Tcr = FMA(KP923879532, Tcg, KP382683432 * Tcf);
			 }
		    }
		    {
			 E T6K, Tf6, Ta2, Ta5, T7c, Tfd, Tae, Taj, T6T, Tf7, Ta3, Ta8, T73, Tfc, Tad;
			 E Tag;
			 {
			      E T6E, Ta0, T6J, Ta1;
			      {
				   E T6C, T6D, T6G, T6I;
				   T6C = ri[WS(rs, 3)];
				   T6D = ii[WS(rs, 3)];
				   T6E = FMA(T3, T6C, T6 * T6D);
				   Ta0 = FNMS(T6, T6C, T3 * T6D);
				   T6G = ri[WS(rs, 35)];
				   T6I = ii[WS(rs, 35)];
				   T6J = FMA(T6F, T6G, T6H * T6I);
				   Ta1 = FNMS(T6H, T6G, T6F * T6I);
			      }
			      T6K = T6E + T6J;
			      Tf6 = Ta0 + Ta1;
			      Ta2 = Ta0 - Ta1;
			      Ta5 = T6E - T6J;
			 }
			 {
			      E T76, Tah, T7b, Tai;
			      {
				   E T74, T75, T78, T7a;
				   T74 = ri[WS(rs, 11)];
				   T75 = ii[WS(rs, 11)];
				   T76 = FMA(TA, T74, TE * T75);
				   Tah = FNMS(TE, T74, TA * T75);
				   T78 = ri[WS(rs, 43)];
				   T7a = ii[WS(rs, 43)];
				   T7b = FMA(T77, T78, T79 * T7a);
				   Tai = FNMS(T79, T78, T77 * T7a);
			      }
			      T7c = T76 + T7b;
			      Tfd = Tah + Tai;
			      Tae = T76 - T7b;
			      Taj = Tah - Tai;
			 }
			 {
			      E T6N, Ta6, T6S, Ta7;
			      {
				   E T6L, T6M, T6P, T6R;
				   T6L = ri[WS(rs, 19)];
				   T6M = ii[WS(rs, 19)];
				   T6N = FMA(T2z, T6L, T2C * T6M);
				   Ta6 = FNMS(T2C, T6L, T2z * T6M);
				   T6P = ri[WS(rs, 51)];
				   T6R = ii[WS(rs, 51)];
				   T6S = FMA(T6O, T6P, T6Q * T6R);
				   Ta7 = FNMS(T6Q, T6P, T6O * T6R);
			      }
			      T6T = T6N + T6S;
			      Tf7 = Ta6 + Ta7;
			      Ta3 = T6N - T6S;
			      Ta8 = Ta6 - Ta7;
			 }
			 {
			      E T6Z, Tab, T72, Tac;
			      {
				   E T6W, T6Y, T70, T71;
				   T6W = ri[WS(rs, 59)];
				   T6Y = ii[WS(rs, 59)];
				   T6Z = FMA(T6V, T6W, T6X * T6Y);
				   Tab = FNMS(T6X, T6W, T6V * T6Y);
				   T70 = ri[WS(rs, 27)];
				   T71 = ii[WS(rs, 27)];
				   T72 = FMA(Th, T70, Tm * T71);
				   Tac = FNMS(Tm, T70, Th * T71);
			      }
			      T73 = T6Z + T72;
			      Tfc = Tab + Tac;
			      Tad = Tab - Tac;
			      Tag = T6Z - T72;
			 }
			 {
			      E T6U, T7d, Tfb, Tfe;
			      T6U = T6K + T6T;
			      T7d = T73 + T7c;
			      T7e = T6U + T7d;
			      Th9 = T7d - T6U;
			      Tfb = T73 - T7c;
			      Tfe = Tfc - Tfd;
			      Tff = Tfb + Tfe;
			      Tfn = Tfb - Tfe;
			 }
			 {
			      E Th2, Th3, Ta4, Ta9;
			      Th2 = Tf6 + Tf7;
			      Th3 = Tfc + Tfd;
			      Th4 = Th2 - Th3;
			      ThJ = Th2 + Th3;
			      Ta4 = Ta2 + Ta3;
			      Ta9 = Ta5 - Ta8;
			      Taa = FNMS(KP923879532, Ta9, KP382683432 * Ta4);
			      Tay = FMA(KP923879532, Ta4, KP382683432 * Ta9);
			 }
			 {
			      E Taf, Tak, TcB, TcC;
			      Taf = Tad + Tae;
			      Tak = Tag - Taj;
			      Tal = FMA(KP382683432, Taf, KP923879532 * Tak);
			      Tax = FNMS(KP923879532, Taf, KP382683432 * Tak);
			      TcB = Tad - Tae;
			      TcC = Tag + Taj;
			      TcD = FMA(KP923879532, TcB, KP382683432 * TcC);
			      TcJ = FNMS(KP382683432, TcB, KP923879532 * TcC);
			 }
			 {
			      E Tf8, Tf9, Tcy, Tcz;
			      Tf8 = Tf6 - Tf7;
			      Tf9 = T6K - T6T;
			      Tfa = Tf8 - Tf9;
			      Tfo = Tf9 + Tf8;
			      Tcy = Ta2 - Ta3;
			      Tcz = Ta5 + Ta8;
			      TcA = FNMS(KP382683432, Tcz, KP923879532 * Tcy);
			      TcK = FMA(KP382683432, Tcy, KP923879532 * Tcz);
			 }
		    }
		    {
			 E T2L, Thx, ThU, ThV, Ti5, Tib, T4s, Tia, T7g, Ti7, ThG, ThO, ThL, ThP, ThA;
			 E ThW;
			 {
			      E T1L, T2K, ThS, ThT;
			      T1L = T17 + T1K;
			      T2K = T2e + T2J;
			      T2L = T1L + T2K;
			      Thx = T1L - T2K;
			      ThS = ThD + ThE;
			      ThT = ThI + ThJ;
			      ThU = ThS - ThT;
			      ThV = ThS + ThT;
			 }
			 {
			      E ThX, Ti4, T3C, T4r;
			      ThX = TgA + TgB;
			      Ti4 = ThY + Ti3;
			      Ti5 = ThX + Ti4;
			      Tib = Ti4 - ThX;
			      T3C = T36 + T3B;
			      T4r = T45 + T4q;
			      T4s = T3C + T4r;
			      Tia = T4r - T3C;
			 }
			 {
			      E T5S, T7f, ThC, ThF;
			      T5S = T5c + T5R;
			      T7f = T6B + T7e;
			      T7g = T5S + T7f;
			      Ti7 = T7f - T5S;
			      ThC = T5c - T5R;
			      ThF = ThD - ThE;
			      ThG = ThC + ThF;
			      ThO = ThF - ThC;
			 }
			 {
			      E ThH, ThK, Thy, Thz;
			      ThH = T6B - T7e;
			      ThK = ThI - ThJ;
			      ThL = ThH - ThK;
			      ThP = ThH + ThK;
			      Thy = TgE + TgF;
			      Thz = TgK + TgL;
			      ThA = Thy - Thz;
			      ThW = Thy + Thz;
			 }
			 {
			      E T4t, Ti6, ThR, Ti8;
			      T4t = T2L + T4s;
			      ri[WS(rs, 32)] = T4t - T7g;
			      ri[0] = T4t + T7g;
			      Ti6 = ThW + Ti5;
			      ii[0] = ThV + Ti6;
			      ii[WS(rs, 32)] = Ti6 - ThV;
			      ThR = T2L - T4s;
			      ri[WS(rs, 48)] = ThR - ThU;
			      ri[WS(rs, 16)] = ThR + ThU;
			      Ti8 = Ti5 - ThW;
			      ii[WS(rs, 16)] = Ti7 + Ti8;
			      ii[WS(rs, 48)] = Ti8 - Ti7;
			 }
			 {
			      E ThB, ThM, Ti9, Tic;
			      ThB = Thx + ThA;
			      ThM = KP707106781 * (ThG + ThL);
			      ri[WS(rs, 40)] = ThB - ThM;
			      ri[WS(rs, 8)] = ThB + ThM;
			      Ti9 = KP707106781 * (ThO + ThP);
			      Tic = Tia + Tib;
			      ii[WS(rs, 8)] = Ti9 + Tic;
			      ii[WS(rs, 40)] = Tic - Ti9;
			 }
			 {
			      E ThN, ThQ, Tid, Tie;
			      ThN = Thx - ThA;
			      ThQ = KP707106781 * (ThO - ThP);
			      ri[WS(rs, 56)] = ThN - ThQ;
			      ri[WS(rs, 24)] = ThN + ThQ;
			      Tid = KP707106781 * (ThL - ThG);
			      Tie = Tib - Tia;
			      ii[WS(rs, 24)] = Tid + Tie;
			      ii[WS(rs, 56)] = Tie - Tid;
			 }
		    }
		    {
			 E TgD, Thh, Thr, Thv, Tij, Tip, TgO, Tig, Th0, The, Thk, Tio, Tho, Thu, Thb;
			 E Thf;
			 {
			      E Tgz, TgC, Thp, Thq;
			      Tgz = T17 - T1K;
			      TgC = TgA - TgB;
			      TgD = Tgz - TgC;
			      Thh = Tgz + TgC;
			      Thp = Th1 + Th4;
			      Thq = Th8 + Th9;
			      Thr = FNMS(KP382683432, Thq, KP923879532 * Thp);
			      Thv = FMA(KP923879532, Thq, KP382683432 * Thp);
			 }
			 {
			      E Tih, Tii, TgI, TgN;
			      Tih = T2J - T2e;
			      Tii = Ti3 - ThY;
			      Tij = Tih + Tii;
			      Tip = Tii - Tih;
			      TgI = TgG - TgH;
			      TgN = TgJ + TgM;
			      TgO = KP707106781 * (TgI - TgN);
			      Tig = KP707106781 * (TgI + TgN);
			 }
			 {
			      E TgU, TgZ, Thi, Thj;
			      TgU = TgS - TgT;
			      TgZ = TgV - TgY;
			      Th0 = FMA(KP923879532, TgU, KP382683432 * TgZ);
			      The = FNMS(KP923879532, TgZ, KP382683432 * TgU);
			      Thi = TgH + TgG;
			      Thj = TgJ - TgM;
			      Thk = KP707106781 * (Thi + Thj);
			      Tio = KP707106781 * (Thj - Thi);
			 }
			 {
			      E Thm, Thn, Th5, Tha;
			      Thm = TgS + TgT;
			      Thn = TgV + TgY;
			      Tho = FMA(KP382683432, Thm, KP923879532 * Thn);
			      Thu = FNMS(KP382683432, Thn, KP923879532 * Thm);
			      Th5 = Th1 - Th4;
			      Tha = Th8 - Th9;
			      Thb = FNMS(KP923879532, Tha, KP382683432 * Th5);
			      Thf = FMA(KP382683432, Tha, KP923879532 * Th5);
			 }
			 {
			      E TgP, Thc, Tin, Tiq;
			      TgP = TgD + TgO;
			      Thc = Th0 + Thb;
			      ri[WS(rs, 44)] = TgP - Thc;
			      ri[WS(rs, 12)] = TgP + Thc;
			      Tin = The + Thf;
			      Tiq = Tio + Tip;
			      ii[WS(rs, 12)] = Tin + Tiq;
			      ii[WS(rs, 44)] = Tiq - Tin;
			 }
			 {
			      E Thd, Thg, Tir, Tis;
			      Thd = TgD - TgO;
			      Thg = The - Thf;
			      ri[WS(rs, 60)] = Thd - Thg;
			      ri[WS(rs, 28)] = Thd + Thg;
			      Tir = Thb - Th0;
			      Tis = Tip - Tio;
			      ii[WS(rs, 28)] = Tir + Tis;
			      ii[WS(rs, 60)] = Tis - Tir;
			 }
			 {
			      E Thl, Ths, Tif, Tik;
			      Thl = Thh + Thk;
			      Ths = Tho + Thr;
			      ri[WS(rs, 36)] = Thl - Ths;
			      ri[WS(rs, 4)] = Thl + Ths;
			      Tif = Thu + Thv;
			      Tik = Tig + Tij;
			      ii[WS(rs, 4)] = Tif + Tik;
			      ii[WS(rs, 36)] = Tik - Tif;
			 }
			 {
			      E Tht, Thw, Til, Tim;
			      Tht = Thh - Thk;
			      Thw = Thu - Thv;
			      ri[WS(rs, 52)] = Tht - Thw;
			      ri[WS(rs, 20)] = Tht + Thw;
			      Til = Thr - Tho;
			      Tim = Tij - Tig;
			      ii[WS(rs, 20)] = Til + Tim;
			      ii[WS(rs, 52)] = Tim - Til;
			 }
		    }
		    {
			 E Teb, Tfx, Tey, TiK, TiN, TiT, TfA, TiS, Tfr, TfL, Tfv, TfH, Tf0, TfK, Tfu;
			 E TfE;
			 {
			      E TdZ, Tea, Tfy, Tfz;
			      TdZ = TdV - TdY;
			      Tea = KP707106781 * (Te4 - Te9);
			      Teb = TdZ - Tea;
			      Tfx = TdZ + Tea;
			      {
				   E Tem, Tex, TiL, TiM;
				   Tem = FNMS(KP923879532, Tel, KP382683432 * Teg);
				   Tex = FMA(KP382683432, Ter, KP923879532 * Tew);
				   Tey = Tem - Tex;
				   TiK = Tem + Tex;
				   TiL = KP707106781 * (TfP - TfO);
				   TiM = Tix - Tiw;
				   TiN = TiL + TiM;
				   TiT = TiM - TiL;
			      }
			      Tfy = FMA(KP923879532, Teg, KP382683432 * Tel);
			      Tfz = FNMS(KP923879532, Ter, KP382683432 * Tew);
			      TfA = Tfy + Tfz;
			      TiS = Tfz - Tfy;
			      {
				   E Tfh, TfF, Tfq, TfG, Tfg, Tfp;
				   Tfg = KP707106781 * (Tfa - Tff);
				   Tfh = Tf5 - Tfg;
				   TfF = Tf5 + Tfg;
				   Tfp = KP707106781 * (Tfn - Tfo);
				   Tfq = Tfm - Tfp;
				   TfG = Tfm + Tfp;
				   Tfr = FNMS(KP980785280, Tfq, KP195090322 * Tfh);
				   TfL = FMA(KP831469612, TfG, KP555570233 * TfF);
				   Tfv = FMA(KP195090322, Tfq, KP980785280 * Tfh);
				   TfH = FNMS(KP555570233, TfG, KP831469612 * TfF);
			      }
			      {
				   E TeQ, TfC, TeZ, TfD, TeP, TeY;
				   TeP = KP707106781 * (TeJ - TeO);
				   TeQ = TeE - TeP;
				   TfC = TeE + TeP;
				   TeY = KP707106781 * (TeW - TeX);
				   TeZ = TeV - TeY;
				   TfD = TeV + TeY;
				   Tf0 = FMA(KP980785280, TeQ, KP195090322 * TeZ);
				   TfK = FNMS(KP555570233, TfD, KP831469612 * TfC);
				   Tfu = FNMS(KP980785280, TeZ, KP195090322 * TeQ);
				   TfE = FMA(KP555570233, TfC, KP831469612 * TfD);
			      }
			 }
			 {
			      E Tez, Tfs, TiR, TiU;
			      Tez = Teb + Tey;
			      Tfs = Tf0 + Tfr;
			      ri[WS(rs, 46)] = Tez - Tfs;
			      ri[WS(rs, 14)] = Tez + Tfs;
			      TiR = Tfu + Tfv;
			      TiU = TiS + TiT;
			      ii[WS(rs, 14)] = TiR + TiU;
			      ii[WS(rs, 46)] = TiU - TiR;
			 }
			 {
			      E Tft, Tfw, TiV, TiW;
			      Tft = Teb - Tey;
			      Tfw = Tfu - Tfv;
			      ri[WS(rs, 62)] = Tft - Tfw;
			      ri[WS(rs, 30)] = Tft + Tfw;
			      TiV = Tfr - Tf0;
			      TiW = TiT - TiS;
			      ii[WS(rs, 30)] = TiV + TiW;
			      ii[WS(rs, 62)] = TiW - TiV;
			 }
			 {
			      E TfB, TfI, TiJ, TiO;
			      TfB = Tfx + TfA;
			      TfI = TfE + TfH;
			      ri[WS(rs, 38)] = TfB - TfI;
			      ri[WS(rs, 6)] = TfB + TfI;
			      TiJ = TfK + TfL;
			      TiO = TiK + TiN;
			      ii[WS(rs, 6)] = TiJ + TiO;
			      ii[WS(rs, 38)] = TiO - TiJ;
			 }
			 {
			      E TfJ, TfM, TiP, TiQ;
			      TfJ = Tfx - TfA;
			      TfM = TfK - TfL;
			      ri[WS(rs, 54)] = TfJ - TfM;
			      ri[WS(rs, 22)] = TfJ + TfM;
			      TiP = TfH - TfE;
			      TiQ = TiN - TiK;
			      ii[WS(rs, 22)] = TiP + TiQ;
			      ii[WS(rs, 54)] = TiQ - TiP;
			 }
		    }
		    {
			 E TfR, Tgj, TfY, Tiu, Tiz, TiF, Tgm, TiE, Tgd, Tgx, Tgh, Tgt, Tg6, Tgw, Tgg;
			 E Tgq;
			 {
			      E TfN, TfQ, Tgk, Tgl;
			      TfN = TdV + TdY;
			      TfQ = KP707106781 * (TfO + TfP);
			      TfR = TfN - TfQ;
			      Tgj = TfN + TfQ;
			      {
				   E TfU, TfX, Tiv, Tiy;
				   TfU = FNMS(KP382683432, TfT, KP923879532 * TfS);
				   TfX = FMA(KP923879532, TfV, KP382683432 * TfW);
				   TfY = TfU - TfX;
				   Tiu = TfU + TfX;
				   Tiv = KP707106781 * (Te4 + Te9);
				   Tiy = Tiw + Tix;
				   Tiz = Tiv + Tiy;
				   TiF = Tiy - Tiv;
			      }
			      Tgk = FMA(KP382683432, TfS, KP923879532 * TfT);
			      Tgl = FNMS(KP382683432, TfV, KP923879532 * TfW);
			      Tgm = Tgk + Tgl;
			      TiE = Tgl - Tgk;
			      {
				   E Tg9, Tgr, Tgc, Tgs, Tg8, Tgb;
				   Tg8 = KP707106781 * (Tfo + Tfn);
				   Tg9 = Tg7 - Tg8;
				   Tgr = Tg7 + Tg8;
				   Tgb = KP707106781 * (Tfa + Tff);
				   Tgc = Tga - Tgb;
				   Tgs = Tga + Tgb;
				   Tgd = FNMS(KP831469612, Tgc, KP555570233 * Tg9);
				   Tgx = FMA(KP195090322, Tgr, KP980785280 * Tgs);
				   Tgh = FMA(KP831469612, Tg9, KP555570233 * Tgc);
				   Tgt = FNMS(KP195090322, Tgs, KP980785280 * Tgr);
			      }
			      {
				   E Tg2, Tgo, Tg5, Tgp, Tg1, Tg4;
				   Tg1 = KP707106781 * (TeO + TeJ);
				   Tg2 = Tg0 - Tg1;
				   Tgo = Tg0 + Tg1;
				   Tg4 = KP707106781 * (TeW + TeX);
				   Tg5 = Tg3 - Tg4;
				   Tgp = Tg3 + Tg4;
				   Tg6 = FMA(KP555570233, Tg2, KP831469612 * Tg5);
				   Tgw = FNMS(KP195090322, Tgo, KP980785280 * Tgp);
				   Tgg = FNMS(KP831469612, Tg2, KP555570233 * Tg5);
				   Tgq = FMA(KP980785280, Tgo, KP195090322 * Tgp);
			      }
			 }
			 {
			      E TfZ, Tge, TiD, TiG;
			      TfZ = TfR + TfY;
			      Tge = Tg6 + Tgd;
			      ri[WS(rs, 42)] = TfZ - Tge;
			      ri[WS(rs, 10)] = TfZ + Tge;
			      TiD = Tgg + Tgh;
			      TiG = TiE + TiF;
			      ii[WS(rs, 10)] = TiD + TiG;
			      ii[WS(rs, 42)] = TiG - TiD;
			 }
			 {
			      E Tgf, Tgi, TiH, TiI;
			      Tgf = TfR - TfY;
			      Tgi = Tgg - Tgh;
			      ri[WS(rs, 58)] = Tgf - Tgi;
			      ri[WS(rs, 26)] = Tgf + Tgi;
			      TiH = Tgd - Tg6;
			      TiI = TiF - TiE;
			      ii[WS(rs, 26)] = TiH + TiI;
			      ii[WS(rs, 58)] = TiI - TiH;
			 }
			 {
			      E Tgn, Tgu, Tit, TiA;
			      Tgn = Tgj + Tgm;
			      Tgu = Tgq + Tgt;
			      ri[WS(rs, 34)] = Tgn - Tgu;
			      ri[WS(rs, 2)] = Tgn + Tgu;
			      Tit = Tgw + Tgx;
			      TiA = Tiu + Tiz;
			      ii[WS(rs, 2)] = Tit + TiA;
			      ii[WS(rs, 34)] = TiA - Tit;
			 }
			 {
			      E Tgv, Tgy, TiB, TiC;
			      Tgv = Tgj - Tgm;
			      Tgy = Tgw - Tgx;
			      ri[WS(rs, 50)] = Tgv - Tgy;
			      ri[WS(rs, 18)] = Tgv + Tgy;
			      TiB = Tgt - Tgq;
			      TiC = Tiz - Tiu;
			      ii[WS(rs, 18)] = TiB + TiC;
			      ii[WS(rs, 50)] = TiC - TiB;
			 }
		    }
		    {
			 E T7V, TaH, TjN, TjT, T8O, TjS, TaK, TjK, T9I, TaU, TaE, TaO, TaB, TaV, TaF;
			 E TaR;
			 {
			      E T7x, T7U, TjL, TjM;
			      T7x = T7l - T7w;
			      T7U = T7I - T7T;
			      T7V = T7x - T7U;
			      TaH = T7x + T7U;
			      TjL = TaZ - TaY;
			      TjM = Tjx - Tjw;
			      TjN = TjL + TjM;
			      TjT = TjM - TjL;
			 }
			 {
			      E T8m, TaI, T8N, TaJ;
			      {
				   E T8c, T8l, T8D, T8M;
				   T8c = T80 - T8b;
				   T8l = T8h - T8k;
				   T8m = FNMS(KP980785280, T8l, KP195090322 * T8c);
				   TaI = FMA(KP980785280, T8c, KP195090322 * T8l);
				   T8D = T8r - T8C;
				   T8M = T8I - T8L;
				   T8N = FMA(KP195090322, T8D, KP980785280 * T8M);
				   TaJ = FNMS(KP980785280, T8D, KP195090322 * T8M);
			      }
			      T8O = T8m - T8N;
			      TjS = TaJ - TaI;
			      TaK = TaI + TaJ;
			      TjK = T8m + T8N;
			 }
			 {
			      E T9u, TaM, T9H, TaN;
			      {
				   E T96, T9t, T9D, T9G;
				   T96 = T8U - T95;
				   T9t = T9h - T9s;
				   T9u = T96 - T9t;
				   TaM = T96 + T9t;
				   T9D = T9z - T9C;
				   T9G = T9E - T9F;
				   T9H = T9D - T9G;
				   TaN = T9D + T9G;
			      }
			      T9I = FMA(KP995184726, T9u, KP098017140 * T9H);
			      TaU = FNMS(KP634393284, TaN, KP773010453 * TaM);
			      TaE = FNMS(KP995184726, T9H, KP098017140 * T9u);
			      TaO = FMA(KP634393284, TaM, KP773010453 * TaN);
			 }
			 {
			      E Tan, TaP, TaA, TaQ;
			      {
				   E T9Z, Tam, Taw, Taz;
				   T9Z = T9N - T9Y;
				   Tam = Taa - Tal;
				   Tan = T9Z - Tam;
				   TaP = T9Z + Tam;
				   Taw = Tas - Tav;
				   Taz = Tax - Tay;
				   TaA = Taw - Taz;
				   TaQ = Taw + Taz;
			      }
			      TaB = FNMS(KP995184726, TaA, KP098017140 * Tan);
			      TaV = FMA(KP773010453, TaQ, KP634393284 * TaP);
			      TaF = FMA(KP098017140, TaA, KP995184726 * Tan);
			      TaR = FNMS(KP634393284, TaQ, KP773010453 * TaP);
			 }
			 {
			      E T8P, TaC, TjR, TjU;
			      T8P = T7V + T8O;
			      TaC = T9I + TaB;
			      ri[WS(rs, 47)] = T8P - TaC;
			      ri[WS(rs, 15)] = T8P + TaC;
			      TjR = TaE + TaF;
			      TjU = TjS + TjT;
			      ii[WS(rs, 15)] = TjR + TjU;
			      ii[WS(rs, 47)] = TjU - TjR;
			 }
			 {
			      E TaD, TaG, TjV, TjW;
			      TaD = T7V - T8O;
			      TaG = TaE - TaF;
			      ri[WS(rs, 63)] = TaD - TaG;
			      ri[WS(rs, 31)] = TaD + TaG;
			      TjV = TaB - T9I;
			      TjW = TjT - TjS;
			      ii[WS(rs, 31)] = TjV + TjW;
			      ii[WS(rs, 63)] = TjW - TjV;
			 }
			 {
			      E TaL, TaS, TjJ, TjO;
			      TaL = TaH + TaK;
			      TaS = TaO + TaR;
			      ri[WS(rs, 39)] = TaL - TaS;
			      ri[WS(rs, 7)] = TaL + TaS;
			      TjJ = TaU + TaV;
			      TjO = TjK + TjN;
			      ii[WS(rs, 7)] = TjJ + TjO;
			      ii[WS(rs, 39)] = TjO - TjJ;
			 }
			 {
			      E TaT, TaW, TjP, TjQ;
			      TaT = TaH - TaK;
			      TaW = TaU - TaV;
			      ri[WS(rs, 55)] = TaT - TaW;
			      ri[WS(rs, 23)] = TaT + TaW;
			      TjP = TaR - TaO;
			      TjQ = TjN - TjK;
			      ii[WS(rs, 23)] = TjP + TjQ;
			      ii[WS(rs, 55)] = TjQ - TjP;
			 }
		    }
		    {
			 E TbV, TcT, Tjj, Tjp, Tca, Tjo, TcW, Tjg, Tcu, Td6, TcQ, Td0, TcN, Td7, TcR;
			 E Td3;
			 {
			      E TbN, TbU, Tjh, Tji;
			      TbN = TbJ - TbM;
			      TbU = TbQ - TbT;
			      TbV = TbN - TbU;
			      TcT = TbN + TbU;
			      Tjh = Tdb - Tda;
			      Tji = Tj3 - Tj0;
			      Tjj = Tjh + Tji;
			      Tjp = Tji - Tjh;
			 }
			 {
			      E Tc2, TcU, Tc9, TcV;
			      {
				   E TbY, Tc1, Tc5, Tc8;
				   TbY = TbW - TbX;
				   Tc1 = TbZ - Tc0;
				   Tc2 = FNMS(KP831469612, Tc1, KP555570233 * TbY);
				   TcU = FMA(KP555570233, Tc1, KP831469612 * TbY);
				   Tc5 = Tc3 - Tc4;
				   Tc8 = Tc6 - Tc7;
				   Tc9 = FMA(KP831469612, Tc5, KP555570233 * Tc8);
				   TcV = FNMS(KP831469612, Tc8, KP555570233 * Tc5);
			      }
			      Tca = Tc2 - Tc9;
			      Tjo = TcV - TcU;
			      TcW = TcU + TcV;
			      Tjg = Tc2 + Tc9;
			 }
			 {
			      E Tcm, TcY, Tct, TcZ;
			      {
				   E Tce, Tcl, Tcp, Tcs;
				   Tce = Tcc - Tcd;
				   Tcl = Tch - Tck;
				   Tcm = Tce - Tcl;
				   TcY = Tce + Tcl;
				   Tcp = Tcn - Tco;
				   Tcs = Tcq - Tcr;
				   Tct = Tcp - Tcs;
				   TcZ = Tcp + Tcs;
			      }
			      Tcu = FMA(KP956940335, Tcm, KP290284677 * Tct);
			      Td6 = FNMS(KP471396736, TcZ, KP881921264 * TcY);
			      TcQ = FNMS(KP956940335, Tct, KP290284677 * Tcm);
			      Td0 = FMA(KP471396736, TcY, KP881921264 * TcZ);
			 }
			 {
			      E TcF, Td1, TcM, Td2;
			      {
				   E Tcx, TcE, TcI, TcL;
				   Tcx = Tcv - Tcw;
				   TcE = TcA - TcD;
				   TcF = Tcx - TcE;
				   Td1 = Tcx + TcE;
				   TcI = TcG - TcH;
				   TcL = TcJ - TcK;
				   TcM = TcI - TcL;
				   Td2 = TcI + TcL;
			      }
			      TcN = FNMS(KP956940335, TcM, KP290284677 * TcF);
			      Td7 = FMA(KP881921264, Td2, KP471396736 * Td1);
			      TcR = FMA(KP290284677, TcM, KP956940335 * TcF);
			      Td3 = FNMS(KP471396736, Td2, KP881921264 * Td1);
			 }
			 {
			      E Tcb, TcO, Tjn, Tjq;
			      Tcb = TbV + Tca;
			      TcO = Tcu + TcN;
			      ri[WS(rs, 45)] = Tcb - TcO;
			      ri[WS(rs, 13)] = Tcb + TcO;
			      Tjn = TcQ + TcR;
			      Tjq = Tjo + Tjp;
			      ii[WS(rs, 13)] = Tjn + Tjq;
			      ii[WS(rs, 45)] = Tjq - Tjn;
			 }
			 {
			      E TcP, TcS, Tjr, Tjs;
			      TcP = TbV - Tca;
			      TcS = TcQ - TcR;
			      ri[WS(rs, 61)] = TcP - TcS;
			      ri[WS(rs, 29)] = TcP + TcS;
			      Tjr = TcN - Tcu;
			      Tjs = Tjp - Tjo;
			      ii[WS(rs, 29)] = Tjr + Tjs;
			      ii[WS(rs, 61)] = Tjs - Tjr;
			 }
			 {
			      E TcX, Td4, Tjf, Tjk;
			      TcX = TcT + TcW;
			      Td4 = Td0 + Td3;
			      ri[WS(rs, 37)] = TcX - Td4;
			      ri[WS(rs, 5)] = TcX + Td4;
			      Tjf = Td6 + Td7;
			      Tjk = Tjg + Tjj;
			      ii[WS(rs, 5)] = Tjf + Tjk;
			      ii[WS(rs, 37)] = Tjk - Tjf;
			 }
			 {
			      E Td5, Td8, Tjl, Tjm;
			      Td5 = TcT - TcW;
			      Td8 = Td6 - Td7;
			      ri[WS(rs, 53)] = Td5 - Td8;
			      ri[WS(rs, 21)] = Td5 + Td8;
			      Tjl = Td3 - Td0;
			      Tjm = Tjj - Tjg;
			      ii[WS(rs, 21)] = Tjl + Tjm;
			      ii[WS(rs, 53)] = Tjm - Tjl;
			 }
		    }
		    {
			 E Tdd, TdF, Tj5, Tjb, Tdk, Tja, TdI, TiY, Tds, TdS, TdC, TdM, Tdz, TdT, TdD;
			 E TdP;
			 {
			      E Td9, Tdc, TiZ, Tj4;
			      Td9 = TbJ + TbM;
			      Tdc = Tda + Tdb;
			      Tdd = Td9 - Tdc;
			      TdF = Td9 + Tdc;
			      TiZ = TbQ + TbT;
			      Tj4 = Tj0 + Tj3;
			      Tj5 = TiZ + Tj4;
			      Tjb = Tj4 - TiZ;
			 }
			 {
			      E Tdg, TdG, Tdj, TdH;
			      {
				   E Tde, Tdf, Tdh, Tdi;
				   Tde = TbW + TbX;
				   Tdf = TbZ + Tc0;
				   Tdg = FNMS(KP195090322, Tdf, KP980785280 * Tde);
				   TdG = FMA(KP980785280, Tdf, KP195090322 * Tde);
				   Tdh = Tc3 + Tc4;
				   Tdi = Tc6 + Tc7;
				   Tdj = FMA(KP195090322, Tdh, KP980785280 * Tdi);
				   TdH = FNMS(KP195090322, Tdi, KP980785280 * Tdh);
			      }
			      Tdk = Tdg - Tdj;
			      Tja = TdH - TdG;
			      TdI = TdG + TdH;
			      TiY = Tdg + Tdj;
			 }
			 {
			      E Tdo, TdK, Tdr, TdL;
			      {
				   E Tdm, Tdn, Tdp, Tdq;
				   Tdm = Tcn + Tco;
				   Tdn = Tck + Tch;
				   Tdo = Tdm - Tdn;
				   TdK = Tdm + Tdn;
				   Tdp = Tcc + Tcd;
				   Tdq = Tcq + Tcr;
				   Tdr = Tdp - Tdq;
				   TdL = Tdp + Tdq;
			      }
			      Tds = FMA(KP634393284, Tdo, KP773010453 * Tdr);
			      TdS = FNMS(KP098017140, TdK, KP995184726 * TdL);
			      TdC = FNMS(KP773010453, Tdo, KP634393284 * Tdr);
			      TdM = FMA(KP995184726, TdK, KP098017140 * TdL);
			 }
			 {
			      E Tdv, TdN, Tdy, TdO;
			      {
				   E Tdt, Tdu, Tdw, Tdx;
				   Tdt = Tcv + Tcw;
				   Tdu = TcK + TcJ;
				   Tdv = Tdt - Tdu;
				   TdN = Tdt + Tdu;
				   Tdw = TcG + TcH;
				   Tdx = TcA + TcD;
				   Tdy = Tdw - Tdx;
				   TdO = Tdw + Tdx;
			      }
			      Tdz = FNMS(KP773010453, Tdy, KP634393284 * Tdv);
			      TdT = FMA(KP098017140, TdN, KP995184726 * TdO);
			      TdD = FMA(KP773010453, Tdv, KP634393284 * Tdy);
			      TdP = FNMS(KP098017140, TdO, KP995184726 * TdN);
			 }
			 {
			      E Tdl, TdA, Tj9, Tjc;
			      Tdl = Tdd + Tdk;
			      TdA = Tds + Tdz;
			      ri[WS(rs, 41)] = Tdl - TdA;
			      ri[WS(rs, 9)] = Tdl + TdA;
			      Tj9 = TdC + TdD;
			      Tjc = Tja + Tjb;
			      ii[WS(rs, 9)] = Tj9 + Tjc;
			      ii[WS(rs, 41)] = Tjc - Tj9;
			 }
			 {
			      E TdB, TdE, Tjd, Tje;
			      TdB = Tdd - Tdk;
			      TdE = TdC - TdD;
			      ri[WS(rs, 57)] = TdB - TdE;
			      ri[WS(rs, 25)] = TdB + TdE;
			      Tjd = Tdz - Tds;
			      Tje = Tjb - Tja;
			      ii[WS(rs, 25)] = Tjd + Tje;
			      ii[WS(rs, 57)] = Tje - Tjd;
			 }
			 {
			      E TdJ, TdQ, TiX, Tj6;
			      TdJ = TdF + TdI;
			      TdQ = TdM + TdP;
			      ri[WS(rs, 33)] = TdJ - TdQ;
			      ri[WS(rs, 1)] = TdJ + TdQ;
			      TiX = TdS + TdT;
			      Tj6 = TiY + Tj5;
			      ii[WS(rs, 1)] = TiX + Tj6;
			      ii[WS(rs, 33)] = Tj6 - TiX;
			 }
			 {
			      E TdR, TdU, Tj7, Tj8;
			      TdR = TdF - TdI;
			      TdU = TdS - TdT;
			      ri[WS(rs, 49)] = TdR - TdU;
			      ri[WS(rs, 17)] = TdR + TdU;
			      Tj7 = TdP - TdM;
			      Tj8 = Tj5 - TiY;
			      ii[WS(rs, 17)] = Tj7 + Tj8;
			      ii[WS(rs, 49)] = Tj8 - Tj7;
			 }
		    }
		    {
			 E Tb1, Tbt, Tjz, TjF, Tb8, TjE, Tbw, Tju, Tbg, TbG, Tbq, TbA, Tbn, TbH, Tbr;
			 E TbD;
			 {
			      E TaX, Tb0, Tjv, Tjy;
			      TaX = T7l + T7w;
			      Tb0 = TaY + TaZ;
			      Tb1 = TaX - Tb0;
			      Tbt = TaX + Tb0;
			      Tjv = T7I + T7T;
			      Tjy = Tjw + Tjx;
			      Tjz = Tjv + Tjy;
			      TjF = Tjy - Tjv;
			 }
			 {
			      E Tb4, Tbu, Tb7, Tbv;
			      {
				   E Tb2, Tb3, Tb5, Tb6;
				   Tb2 = T80 + T8b;
				   Tb3 = T8h + T8k;
				   Tb4 = FNMS(KP555570233, Tb3, KP831469612 * Tb2);
				   Tbu = FMA(KP555570233, Tb2, KP831469612 * Tb3);
				   Tb5 = T8r + T8C;
				   Tb6 = T8I + T8L;
				   Tb7 = FMA(KP831469612, Tb5, KP555570233 * Tb6);
				   Tbv = FNMS(KP555570233, Tb5, KP831469612 * Tb6);
			      }
			      Tb8 = Tb4 - Tb7;
			      TjE = Tbv - Tbu;
			      Tbw = Tbu + Tbv;
			      Tju = Tb4 + Tb7;
			 }
			 {
			      E Tbc, Tby, Tbf, Tbz;
			      {
				   E Tba, Tbb, Tbd, Tbe;
				   Tba = T9z + T9C;
				   Tbb = T9s + T9h;
				   Tbc = Tba - Tbb;
				   Tby = Tba + Tbb;
				   Tbd = T8U + T95;
				   Tbe = T9E + T9F;
				   Tbf = Tbd - Tbe;
				   Tbz = Tbd + Tbe;
			      }
			      Tbg = FMA(KP471396736, Tbc, KP881921264 * Tbf);
			      TbG = FNMS(KP290284677, Tby, KP956940335 * Tbz);
			      Tbq = FNMS(KP881921264, Tbc, KP471396736 * Tbf);
			      TbA = FMA(KP956940335, Tby, KP290284677 * Tbz);
			 }
			 {
			      E Tbj, TbB, Tbm, TbC;
			      {
				   E Tbh, Tbi, Tbk, Tbl;
				   Tbh = T9N + T9Y;
				   Tbi = Tay + Tax;
				   Tbj = Tbh - Tbi;
				   TbB = Tbh + Tbi;
				   Tbk = Tas + Tav;
				   Tbl = Taa + Tal;
				   Tbm = Tbk - Tbl;
				   TbC = Tbk + Tbl;
			      }
			      Tbn = FNMS(KP881921264, Tbm, KP471396736 * Tbj);
			      TbH = FMA(KP290284677, TbB, KP956940335 * TbC);
			      Tbr = FMA(KP881921264, Tbj, KP471396736 * Tbm);
			      TbD = FNMS(KP290284677, TbC, KP956940335 * TbB);
			 }
			 {
			      E Tb9, Tbo, TjD, TjG;
			      Tb9 = Tb1 + Tb8;
			      Tbo = Tbg + Tbn;
			      ri[WS(rs, 43)] = Tb9 - Tbo;
			      ri[WS(rs, 11)] = Tb9 + Tbo;
			      TjD = Tbq + Tbr;
			      TjG = TjE + TjF;
			      ii[WS(rs, 11)] = TjD + TjG;
			      ii[WS(rs, 43)] = TjG - TjD;
			 }
			 {
			      E Tbp, Tbs, TjH, TjI;
			      Tbp = Tb1 - Tb8;
			      Tbs = Tbq - Tbr;
			      ri[WS(rs, 59)] = Tbp - Tbs;
			      ri[WS(rs, 27)] = Tbp + Tbs;
			      TjH = Tbn - Tbg;
			      TjI = TjF - TjE;
			      ii[WS(rs, 27)] = TjH + TjI;
			      ii[WS(rs, 59)] = TjI - TjH;
			 }
			 {
			      E Tbx, TbE, Tjt, TjA;
			      Tbx = Tbt + Tbw;
			      TbE = TbA + TbD;
			      ri[WS(rs, 35)] = Tbx - TbE;
			      ri[WS(rs, 3)] = Tbx + TbE;
			      Tjt = TbG + TbH;
			      TjA = Tju + Tjz;
			      ii[WS(rs, 3)] = Tjt + TjA;
			      ii[WS(rs, 35)] = TjA - Tjt;
			 }
			 {
			      E TbF, TbI, TjB, TjC;
			      TbF = Tbt - Tbw;
			      TbI = TbG - TbH;
			      ri[WS(rs, 51)] = TbF - TbI;
			      ri[WS(rs, 19)] = TbF + TbI;
			      TjB = TbD - TbA;
			      TjC = Tjz - Tju;
			      ii[WS(rs, 19)] = TjB + TjC;
			      ii[WS(rs, 51)] = TjC - TjB;
			 }
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 0, 1},
     {TW_CEXP, 0, 3},
     {TW_CEXP, 0, 9},
     {TW_CEXP, 0, 27},
     {TW_CEXP, 0, 63},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 64, "t2_64", twinstr, &GENUS, {880, 386, 274, 0}, 0, 0, 0 };

void X(codelet_t2_64) (planner *p) {
     X(kdft_dit_register) (p, t2_64, &desc);
}
#endif				/* HAVE_FMA */
