dnl vim: set filetype=sysctl.conf.m4 syntax=sysctl.conf.m4:
;-------------------------------------------------------------------------------
;----        P R O V I D E D   A P I S                                      ----
;-------------------------------------------------------------------------------

{{#provided-api}}
{{#value=ws|auto}}

;-------------------------------------------------------------------------------
;----        T H E   S E R V I C E   O F   T H E   A P I                    ----
;-------------------------------------------------------------------------------
%begin systemd-unit

# auto generated by wgtpkg-unit for {{:id}} version {{:version}} target {{:#target}} of {{:idaver}}

%systemd-unit system
%systemd-unit service UNIT_NAME_API_BASE({{name}})@

[Unit]
Description=Provides api {{name}} for user %i
X-AFM-API-TYPE={{value}}

Requires=afm-user-setup@%i.service
After=afm-user-setup@%i.service

{{#value=ws|auto}}
Requires=UNIT_NAME_API_BASE({{name}})@%i.socket
After=UNIT_NAME_API_BASE({{name}})@%i.socket
{{/value=ws|auto}}

[Service]
Type=oneshot
RemainAfterExit=yes
{{#value=ws|auto}}
ExecStart=/bin/true
{{/value=ws|auto}}

%end systemd-unit


;-------------------------------------------------------------------------------
;----        T H E   S O C K E T   O F   T H E   A P I                      ----
;-------------------------------------------------------------------------------

%begin systemd-unit

# auto generated by wgtpkg-unit for {{:id}} version {{:version}} target {{:#target}} of {{:idaver}}

%systemd-unit system
%systemd-unit socket UNIT_NAME_API_BASE({{name}})@
[Unit]
Description=Provides websocket api {{name}} for user %i
Requires=afm-user-setup@%i.service
After=afm-user-setup@%i.service
DefaultDependencies=no

[Socket]
SmackLabel=*
SmackLabelIPIn=System
SmackLabelIPOut=System
ListenStream=API_PATH_WS/{{name}}
FileDescriptorName={{name}}
Service=UNIT_NAME_SERVICE

%end systemd-unit


{{/value=ws|auto}}

{{/provided-api}}


