--[[
   Copyright (C) 2018 "IoT.bzh"
   Author Frédéric Marec <frederic.marec@iot.bzh>

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
--]]

local i=1 j=1

function _infoget (request, args, json_object)
  AFB:success(request, {devid="hw:"..i, devpath = json_object.devpath})
  i=i+1
end

function _ctlget (request, args, json_object)
  AFB:success(request,
  {
     id  = j,
     name  = "DVC Out Playback Volume",
     iface  = "MIXER",
     actif  = true,
     val  = {6710886,6710886},
     ctl  = {
      type  = 2,
      count  = 2,
      min  = 0,
      max  = 8388607,
      step  = 0
   },
     acl  = {
       read  = true,
       write  = true,
       inact  = false,
       volat  = false,
       lock  = false,
       tlv  = {
         read  = false,
         write  = false,
         command  = false
      }
    }
  }
)
end

function _ctlset (request)
  j=j+1
  AFB:success(request, {
    id  = j,
    name  = "DVC Out Playback Volume",
    iface  = "MIXER",
    actif  = true,
    val  = {6710886,6710886},
    ctl  = {
      type  = 2,
      count  = 2,
      min  = 0,
      max  = 8388607,
      step  = 0
   },
    acl  = {
      read  = true,
      write  = true,
      inact  = false,
      volat  = false,
      lock  = false,
      tlv  = {
        read  = false,
        write  = false,
        command  = false
     }
   }
 })
end

function _subscribe (request)
  AFB:success(request)
end

function _addcustomctl (request, args, json_object)
  AFB:success(request, {id = i; devid = json_object.devid, ctl = json_object.ctl})
end
