# 4a-tools

4a-tools is a set of simple scripts that can be used to test and troubleshoot
4a framework.

## 4a-status

4a-status gives a diagnostic whether 4a-framework is supposed to be working or
not.

```bash
user@machine$ 4a-status
---- Audio cards detected ----
card 0: Loopback
card 1: Intel

---- snd-aloop driver availability ----
SUCCESS: Built into the kernel

---- 4a service status ----
SUCCESS: Service is currently running!
```

If any error is shown then there is no way that 4a-framework can work.
Not running services do trigger only a warning because you may have started the
service's binding manually and the script cannot detect this.
If you don't, this must be considered as an error, because 4a-framework
obviously cannot work when bindings are not running.

```bash
---- Audio cards detected ----
card 0: Loopback
card 1: Intel

---- snd-aloop driver availability ----
SUCCESS: Built into the kernel

---- 4a service status ----
WARNING: Service is not currently running!
It can be started using the following command:
systemctl restart *agl-service-audio-4a*.service
```

## 4a-api

This script lets you call 4a's APIs to test bindings and get some infos.

### Ping API

Pinging an API let you know that the binding providing this API is running and
ready.

```bash
user@machine$ 4a-api api smixer ping
Detected systemd unit file!
Port detected: 1025
ON-REPLY 1:smixer/ping: OK
{
    "response":3,
    "jtype":"afb-reply",
    "request":{
        "status":"success"
    }
}
```

### List HALs

You can list availables HALs using the following command:

```bash
user@machine$ 4a-api hals
Detected systemd unit file!
Port detected: 1025
ON-REPLY 1:4a-hal-manager/loaded: OK
{
    "response":[
        "4a-hal-intel-qemu"
    ],
    "jtype":"afb-reply",
    "request":{
        "status":"success",
        "info":"Requested data"
    }
}
```

If the returned list is empty, this means that no HAL is loaded and ready. In
such a case you won't be able to use 4a-framework because this means that there
is no device to play audio on.

To get more information about a HAL, you can call its **info** verb:

```bash
user@machine$ 4a-api api 4a-hal-intel-qemu info
Detected systemd unit file!
Port detected: 1025
ON-REPLY 1:4a-hal-intel-qemu/info: OK
{
    "response":{
        "streams":[
            {
                "name":"multimedia",
                "cardId":"hw:0,0,2"
            },
            {
                "name":"navigation",
                "cardId":"hw:0,0,3"
            },
            {
                "name":"emergency",
                "cardId":"hw:0,0,4"
            }
        ],
        "playbacks":[
            {
                "name":"playback",
                "mixer-name":"INTEL-QEMU:playback"
            }
        ],
        "captures":[
            {
                "name":"capture",
                "mixer-name":"INTEL-QEMU:capture"
            }
        ]
    },
    "jtype":"afb-reply",
    "request":{
        "status":"success",
        "info":"Requested data"
    }
}
```

This allows you to get which device is bound to which stream.
Please note these are stream names, not roles names.
In addition, multiples HALs can provide the same stream.
In the current implementation, it results in a race condition: 4a-framework
will be using the first HAL providing the stream.

### List roles

This lets you get the list of available audio roles.
Only roles with a bound device are listed here, because roles without a device
are pretty much unusable.

```bash
user@machine$ 4a-api roles
Detected systemd unit file!
Port detected: 1025
ON-REPLY 1:ahl-4a/get_roles: OK
{
    "response":[
        "radio",
        "multimedia",
        "emergency",
        "navigation"
    ],
    "jtype":"afb-reply",
    "request": {
        "status":"success"
    }
}
```

## 4a-play

4a-play lets you play some audio file on a specified device, with an optional
audio role.

```bash
4a-play <file> [<device> [<role>]]
```

Where *file* is the path to the file to play, *device* is the device to play on
and and *role* is the 4a audio role to open (multimedia for example).

The specified role should be the one that is bound to the specified device,
however the script is not able to detect it so there is no control about this.
The role is opened before playing the audio file, and closed after playing is
over.

So for example:

```bash
4a-play Happy_MBB_75.ogg hw:2,0,0 multimedia
```

>**NOTE**: For now you have to specify the device and the role. Future versions
>of this script may detect devices and roles relations so that you will be able
>to omit either role or device.
>
>The device that usually matches "multimedia" is "hw:0,0,2" (for more details
>please read the [HALs](HALs.md) section).

>**NOTE**: Some media files (WAV, MP3 and OGG) are provided with 4a-tools for
>testing purpose and can be used as reference assets. 
