/*************************************************************************/ /*!
@Title          Test Chip Framework register definitions	
@Copyright      Copyright (c) Imagination Technologies Ltd. All Rights Reserved
@License        Dual MIT/GPLv2

The contents of this file are subject to the MIT license as set out below.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

Alternatively, the contents of this file may be used under the terms of
the GNU General Public License Version 2 ("GPL") in which case the provisions
of GPL are applicable instead of those above.

If you wish to allow use of your version of this file only under the terms of
GPL, and not to allow others to use your version of this file under the terms
of the MIT license, indicate your decision by deleting the provisions above
and replace them with the notice and other provisions required by GPL as set
out in the file called "GPL-COPYING" included in this distribution. If you do
not delete the provisions above, a recipient may use your version of this file
under the terms of either the MIT license or GPL.

This License is also included in this distribution in the file called
"MIT-COPYING".

EXCEPT AS OTHERWISE STATED IN A NEGOTIATED AGREEMENT: (A) THE SOFTWARE IS
PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT; AND (B) IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

                        Autogenerated C -- do not edit

*/ /**************************************************************************/

#ifndef _APOLLO_TCFDEFS_H_
#define _APOLLO_TCFDEFS_H_


/******************************************************************************
 Defines
******************************************************************************/

/* Register group's offsets */
#define TCF_CR_CLOCK_CONTROL_OFFSET									(0x0000UL)
#define TCF_CR_DDR2_OFFSET											(0x0800UL)
#define TCF_CR_PLL_OFFSET											(0x1000UL)
#define TCF_CR_PDP_OFFSET											(0xC000UL)

/* CLOCK_CONTROL registers */
/* Register TCF_CR_FPGA_ID_REG */
#define TCF_CR_FPGA_ID_REG											(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0000UL)
#define TCF_CR_FPGA_ID_REG_DEFAULT									(0x12010000UL)

#define TCF_CR_FPGA_ID_REG_FPGA_ID_REG_CORE_ID_MASK					(0xFFFF0000UL)
#define TCF_CR_FPGA_ID_REG_FPGA_ID_REG_CORE_ID_SHIFT				(16)

#define TCF_CR_FPGA_ID_REG_FPGA_ID_REG_CORE_CFG_MASK				(0x0000FFFFUL)
#define TCF_CR_FPGA_ID_REG_FPGA_ID_REG_CORE_CFG_SHIFT				(0)

/* Register TCF_CR_FPGA_REV_REG */
#define TCF_CR_FPGA_REV_REG											(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0008UL)
#define TCF_CR_FPGA_REV_REG_DEFAULT									(0x00010100UL)

#define TCF_CR_FPGA_REV_REG_FPGA_REV_REG_DESIGNER_MASK				(0xFF000000UL)
#define TCF_CR_FPGA_REV_REG_FPGA_REV_REG_DESIGNER_SHIFT				(24)

#define TCF_CR_FPGA_REV_REG_FPGA_REV_REG_MAJOR_MASK					(0x00FF0000UL)
#define TCF_CR_FPGA_REV_REG_FPGA_REV_REG_MAJOR_SHIFT				(16)

#define TCF_CR_FPGA_REV_REG_FPGA_REV_REG_MINOR_MASK					(0x0000FF00UL)
#define TCF_CR_FPGA_REV_REG_FPGA_REV_REG_MINOR_SHIFT				(8)

#define TCF_CR_FPGA_REV_REG_FPGA_REV_REG_MAINT_MASK					(0x000000FFUL)
#define TCF_CR_FPGA_REV_REG_FPGA_REV_REG_MAINT_SHIFT				(0)

/* Register TCF_CR_FPGA_DES_REV_1 */
#define TCF_CR_FPGA_DES_REV_1										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0010UL)
#define TCF_CR_FPGA_DES_REV_1_DEFAULT								(0x00000000UL)

#define TCF_CR_FPGA_DES_REV_1_FPGA_DES_REV_1_MASK					(0xFFFFFFFFUL)
#define TCF_CR_FPGA_DES_REV_1_FPGA_DES_REV_1_SHIFT					(0)

/* Register TCF_CR_FPGA_DES_REV_2 */
#define TCF_CR_FPGA_DES_REV_2										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0018UL)
#define TCF_CR_FPGA_DES_REV_2_DEFAULT								(0x00000000UL)

#define TCF_CR_FPGA_DES_REV_2_FPGA_DES_REV_2_MASK					(0xFFFFFFFFUL)
#define TCF_CR_FPGA_DES_REV_2_FPGA_DES_REV_2_SHIFT					(0)

/* Register TCF_CR_TCF_CORE_ID_REG */
#define TCF_CR_TCF_CORE_ID_REG										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0020UL)
#define TCF_CR_TCF_CORE_ID_REG_DEFAULT								(0x00000000UL)

#define TCF_CR_TCF_CORE_ID_REG_TCF_CORE_ID_REG_CORE_ID_MASK			(0xFFFF0000UL)
#define TCF_CR_TCF_CORE_ID_REG_TCF_CORE_ID_REG_CORE_ID_SHIFT		(16)

#define TCF_CR_TCF_CORE_ID_REG_TCF_CORE_ID_REG_CORE_CFG_MASK		(0x0000FFFFUL)
#define TCF_CR_TCF_CORE_ID_REG_TCF_CORE_ID_REG_CORE_CFG_SHIFT		(0)

/* Register TCF_CR_TCF_CORE_REV_REG */
#define TCF_CR_TCF_CORE_REV_REG										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0028UL)
#define TCF_CR_TCF_CORE_REV_REG_DEFAULT								(0x00000000UL)

#define TCF_CR_TCF_CORE_REV_REG_TCF_CORE_REV_REG_DESIGNER_MASK		(0xFF000000UL)
#define TCF_CR_TCF_CORE_REV_REG_TCF_CORE_REV_REG_DESIGNER_SHIFT		(24)

#define TCF_CR_TCF_CORE_REV_REG_TCF_CORE_REV_REG_MAJOR_MASK			(0x00FF0000UL)
#define TCF_CR_TCF_CORE_REV_REG_TCF_CORE_REV_REG_MAJOR_SHIFT		(16)

#define TCF_CR_TCF_CORE_REV_REG_TCF_CORE_REV_REG_MINOR_MASK			(0x0000FF00UL)
#define TCF_CR_TCF_CORE_REV_REG_TCF_CORE_REV_REG_MINOR_SHIFT		(8)

#define TCF_CR_TCF_CORE_REV_REG_TCF_CORE_REV_REG_MAINT_MASK			(0x000000FFUL)
#define TCF_CR_TCF_CORE_REV_REG_TCF_CORE_REV_REG_MAINT_SHIFT		(0)

/* Register TCF_CR_TCF_CORE_DES_REV_1 */
#define TCF_CR_TCF_CORE_DES_REV_1									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0030UL)
#define TCF_CR_TCF_CORE_DES_REV_1_DEFAULT							(0x00000000UL)

#define TCF_CR_TCF_CORE_DES_REV_1_TCF_CORE_DES_REV_1_MASK			(0xFFFFFFFFUL)
#define TCF_CR_TCF_CORE_DES_REV_1_TCF_CORE_DES_REV_1_SHIFT			(0)

/* Register TCF_CR_TCF_CORE_DES_REV_2 */
#define TCF_CR_TCF_CORE_DES_REV_2									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0038UL)
#define TCF_CR_TCF_CORE_DES_REV_2_DEFAULT							(0x00000000UL)

#define TCF_CR_TCF_CORE_DES_REV_2_TCF_CORE_DES_REV_2_MASK			(0xFFFFFFFFUL)
#define TCF_CR_TCF_CORE_DES_REV_2_TCF_CORE_DES_REV_2_SHIFT			(0)

/* Register TCF_CR_SCB_GENERAL_CONTROL */
#define TCF_CR_SCB_GENERAL_CONTROL									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0040UL)
#define TCF_CR_SCB_GENERAL_CONTROL_DEFAULT							(0x00000000UL)

#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_TRANS_HALT_MASK			(0x00000200UL)
#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_TRANS_HALT_SHIFT			(9)

#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_CKD_REGS_MASK				(0x00000100UL)
#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_CKD_REGS_SHIFT			(8)

#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_CKD_SLAVE_MASK			(0x00000080UL)
#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_CKD_SLAVE_SHIFT			(7)

#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_CKD_MASTER_MASK			(0x00000040UL)
#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_CKD_MASTER_SHIFT			(6)

#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_CKD_XDATA_MASK			(0x00000020UL)
#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_CKD_XDATA_SHIFT			(5)

#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_SFR_REG_MASK				(0x00000010UL)
#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_SFR_REG_SHIFT				(4)

#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_SFR_SLAVE_MASK			(0x00000008UL)
#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_SFR_SLAVE_SHIFT			(3)

#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_SFR_MASTER_MASK			(0x00000004UL)
#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_SFR_MASTER_SHIFT			(2)

#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_SFR_DET_DATA_MASK			(0x00000002UL)
#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_SFR_DET_DATA_SHIFT		(1)

#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_SFR_GEN_DATA_MASK			(0x00000001UL)
#define TCF_CR_SCB_GENERAL_CONTROL_SCB_GC_SFR_GEN_DATA_SHIFT		(0)

/* Register TCF_CR_SCB_MASTER_READ_COUNT */
#define TCF_CR_SCB_MASTER_READ_COUNT								(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0048UL)
#define TCF_CR_SCB_MASTER_READ_COUNT_DEFAULT						(0x00000000UL)

#define TCF_CR_SCB_MASTER_READ_COUNT_MASTER_READ_COUNT_MASK			(0x0000FFFFUL)
#define TCF_CR_SCB_MASTER_READ_COUNT_MASTER_READ_COUNT_SHIFT		(0)

/* Register TCF_CR_SCB_MASTER_READ_DATA */
#define TCF_CR_SCB_MASTER_READ_DATA									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0050UL)
#define TCF_CR_SCB_MASTER_READ_DATA_DEFAULT							(0x00000000UL)

#define TCF_CR_SCB_MASTER_READ_DATA_MASTER_READ_DATA_MASK			(0x000000FFUL)
#define TCF_CR_SCB_MASTER_READ_DATA_MASTER_READ_DATA_SHIFT			(0)

/* Register TCF_CR_SCB_MASTER_WRITE_ADDRESS */
#define TCF_CR_SCB_MASTER_WRITE_ADDRESS								(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0058UL)
#define TCF_CR_SCB_MASTER_WRITE_ADDRESS_DEFAULT						(0x00000000UL)

#define TCF_CR_SCB_MASTER_WRITE_ADDRESS_SCB_MASTER_ADDRESS_MASK		(0x000003FFUL)
#define TCF_CR_SCB_MASTER_WRITE_ADDRESS_SCB_MASTER_ADDRESS_SHIFT	(0)

/* Register TCF_CR_SCB_MASTER_WRITE_DATA */
#define TCF_CR_SCB_MASTER_WRITE_DATA								(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0060UL)
#define TCF_CR_SCB_MASTER_WRITE_DATA_DEFAULT						(0x00000000UL)

#define TCF_CR_SCB_MASTER_WRITE_DATA_MASTER_WRITE_DATA_MASK			(0x000000FFUL)
#define TCF_CR_SCB_MASTER_WRITE_DATA_MASTER_WRITE_DATA_SHIFT		(0)

/* Register TCF_CR_SCB_MASTER_WRITE_COUNT */
#define TCF_CR_SCB_MASTER_WRITE_COUNT								(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0068UL)
#define TCF_CR_SCB_MASTER_WRITE_COUNT_DEFAULT						(0x00000000UL)

#define TCF_CR_SCB_MASTER_WRITE_COUNT_MASTER_WRITE_COUNT_MASK		(0x0000FFFFUL)
#define TCF_CR_SCB_MASTER_WRITE_COUNT_MASTER_WRITE_COUNT_SHIFT		(0)

/* Register TCF_CR_SCB_BUS_SELECT */
#define TCF_CR_SCB_BUS_SELECT										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0070UL)
#define TCF_CR_SCB_BUS_SELECT_DEFAULT								(0x00000000UL)

#define TCF_CR_SCB_BUS_SELECT_BUS_SELECT_MASK						(0x00000003UL)
#define TCF_CR_SCB_BUS_SELECT_BUS_SELECT_SHIFT						(0)

/* Register TCF_CR_SCB_MASTER_FILL_STATUS */
#define TCF_CR_SCB_MASTER_FILL_STATUS								(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0078UL)
#define TCF_CR_SCB_MASTER_FILL_STATUS_DEFAULT						(0x00000000UL)

#define TCF_CR_SCB_MASTER_FILL_STATUS_MASTER_WRITE_FIFO_EMPTY_MASK	(0x00000008UL)
#define TCF_CR_SCB_MASTER_FILL_STATUS_MASTER_WRITE_FIFO_EMPTY_SHIFT	(3)

#define TCF_CR_SCB_MASTER_FILL_STATUS_MASTER_WRITE_FIFO_FULL_MASK	(0x00000004UL)
#define TCF_CR_SCB_MASTER_FILL_STATUS_MASTER_WRITE_FIFO_FULL_SHIFT	(2)

#define TCF_CR_SCB_MASTER_FILL_STATUS_MASTER_READ_FIFO_EMPTY_MASK	(0x00000002UL)
#define TCF_CR_SCB_MASTER_FILL_STATUS_MASTER_READ_FIFO_EMPTY_SHIFT	(1)

#define TCF_CR_SCB_MASTER_FILL_STATUS_MASTER_READ_FIFO_FULL_MASK	(0x00000001UL)
#define TCF_CR_SCB_MASTER_FILL_STATUS_MASTER_READ_FIFO_FULL_SHIFT	(0)

/* Register TCF_CR_CLK_AND_RST_CTRL */
#define TCF_CR_CLK_AND_RST_CTRL										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0080UL)
#define TCF_CR_CLK_AND_RST_CTRL_DEFAULT								(0x0002041FUL)

#define TCF_CR_CLK_AND_RST_CTRL_GLB_CLKG_EN_MASK					(0x00020000UL)
#define TCF_CR_CLK_AND_RST_CTRL_GLB_CLKG_EN_SHIFT					(17)

#define TCF_CR_CLK_AND_RST_CTRL_CLK_GATE_CNTL_MASK					(0x00010000UL)
#define TCF_CR_CLK_AND_RST_CTRL_CLK_GATE_CNTL_SHIFT					(16)

#define TCF_CR_CLK_AND_RST_CTRL_DUT_DCM_RESETN_MASK					(0x00000400UL)
#define TCF_CR_CLK_AND_RST_CTRL_DUT_DCM_RESETN_SHIFT				(10)

#define TCF_CR_CLK_AND_RST_CTRL_MEM_RESYNC_BYPASS_MASK				(0x00000200UL)
#define TCF_CR_CLK_AND_RST_CTRL_MEM_RESYNC_BYPASS_SHIFT				(9)

#define TCF_CR_CLK_AND_RST_CTRL_SYS_RESYNC_BYPASS_MASK				(0x00000100UL)
#define TCF_CR_CLK_AND_RST_CTRL_SYS_RESYNC_BYPASS_SHIFT				(8)

#define TCF_CR_CLK_AND_RST_CTRL_SCB_RESETN_MASK						(0x00000010UL)
#define TCF_CR_CLK_AND_RST_CTRL_SCB_RESETN_SHIFT					(4)

#define TCF_CR_CLK_AND_RST_CTRL_PDP2_RESETN_MASK					(0x00000008UL)
#define TCF_CR_CLK_AND_RST_CTRL_PDP2_RESETN_SHIFT					(3)

#define TCF_CR_CLK_AND_RST_CTRL_PDP1_RESETN_MASK					(0x00000004UL)
#define TCF_CR_CLK_AND_RST_CTRL_PDP1_RESETN_SHIFT					(2)

#define TCF_CR_CLK_AND_RST_CTRL_DDR_RESETN_MASK						(0x00000002UL)
#define TCF_CR_CLK_AND_RST_CTRL_DDR_RESETN_SHIFT					(1)

#define TCF_CR_CLK_AND_RST_CTRL_DUT_RESETN_MASK						(0x00000001UL)
#define TCF_CR_CLK_AND_RST_CTRL_DUT_RESETN_SHIFT					(0)

/* Register TCF_CR_TEST_REG_OUT */
#define TCF_CR_TEST_REG_OUT											(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0088UL)
#define TCF_CR_TEST_REG_OUT_DEFAULT									(0x00000000UL)

#define TCF_CR_TEST_REG_OUT_TEST_REG_OUT_MASK						(0xFFFFFFFFUL)
#define TCF_CR_TEST_REG_OUT_TEST_REG_OUT_SHIFT						(0)

/* Register TCF_CR_TEST_REG_IN */
#define TCF_CR_TEST_REG_IN											(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0090UL)
#define TCF_CR_TEST_REG_IN_DEFAULT									(0x00000000UL)

#define TCF_CR_TEST_REG_IN_TEST_REG_IN_MASK							(0xFFFFFFFFUL)
#define TCF_CR_TEST_REG_IN_TEST_REG_IN_SHIFT						(0)

/* Register TCF_CR_TEST_CTRL */
#define TCF_CR_TEST_CTRL											(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0098UL)
#define TCF_CR_TEST_CTRL_DEFAULT									(0x00000001UL)

#define TCF_CR_TEST_CTRL_PCI_TEST_OFFSET_MASK						(0xF8000000UL)
#define TCF_CR_TEST_CTRL_PCI_TEST_OFFSET_SHIFT						(27)

#define TCF_CR_TEST_CTRL_PCI_TEST_MODE_MASK							(0x00000040UL)
#define TCF_CR_TEST_CTRL_PCI_TEST_MODE_SHIFT						(6)

#define TCF_CR_TEST_CTRL_TURN_OFF_DDR_MASK							(0x00000020UL)
#define TCF_CR_TEST_CTRL_TURN_OFF_DDR_SHIFT							(5)

#define TCF_CR_TEST_CTRL_SYS_RD_CLK_INV_MASK						(0x00000010UL)
#define TCF_CR_TEST_CTRL_SYS_RD_CLK_INV_SHIFT						(4)

#define TCF_CR_TEST_CTRL_MEM_REQ_CLK_INV_MASK						(0x00000008UL)
#define TCF_CR_TEST_CTRL_MEM_REQ_CLK_INV_SHIFT						(3)

#define TCF_CR_TEST_CTRL_BURST_SPLIT_MASK							(0x00000004UL)
#define TCF_CR_TEST_CTRL_BURST_SPLIT_SHIFT							(2)

#define TCF_CR_TEST_CTRL_CLK_INVERSION_MASK							(0x00000002UL)
#define TCF_CR_TEST_CTRL_CLK_INVERSION_SHIFT						(1)

#define TCF_CR_TEST_CTRL_ADDRESS_FORCE_MASK							(0x00000001UL)
#define TCF_CR_TEST_CTRL_ADDRESS_FORCE_SHIFT						(0)

/* Register TCF_CR_CLEAR_HOST_MEM_SIG */
#define TCF_CR_CLEAR_HOST_MEM_SIG									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x00A0UL)
#define TCF_CR_CLEAR_HOST_MEM_SIG_DEFAULT							(0x00000000UL)

#define TCF_CR_CLEAR_HOST_MEM_SIG_SIGNATURE_TAG_ID_MASK				(0x00000F00UL)
#define TCF_CR_CLEAR_HOST_MEM_SIG_SIGNATURE_TAG_ID_SHIFT			(8)

#define TCF_CR_CLEAR_HOST_MEM_SIG_CLEAR_HOST_MEM_SIGNATURE_MASK		(0x00000001UL)
#define TCF_CR_CLEAR_HOST_MEM_SIG_CLEAR_HOST_MEM_SIGNATURE_SHIFT	(0)

/* Register TCF_CR_HOST_MEM_SIGNATURE */
#define TCF_CR_HOST_MEM_SIGNATURE									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x00A8UL)
#define TCF_CR_HOST_MEM_SIGNATURE_DEFAULT							(0x00000000UL)

#define TCF_CR_HOST_MEM_SIGNATURE_HOST_MEM_SIGNATURE_MASK			(0xFFFFFFFFUL)
#define TCF_CR_HOST_MEM_SIGNATURE_HOST_MEM_SIGNATURE_SHIFT			(0)

/* Register TCF_CR_TC_MEM_SIGNATURE1 */
#define TCF_CR_TC_MEM_SIGNATURE1									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x00B0UL)
#define TCF_CR_TC_MEM_SIGNATURE1_DEFAULT							(0x00000000UL)

#define TCF_CR_TC_MEM_SIGNATURE1_TC_MEM_SIGNATURE1_MASK				(0xFFFFFFFFUL)
#define TCF_CR_TC_MEM_SIGNATURE1_TC_MEM_SIGNATURE1_SHIFT			(0)

/* Register TCF_CR_TC_MEM_SIGNATURE2 */
#define TCF_CR_TC_MEM_SIGNATURE2									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x00B8UL)
#define TCF_CR_TC_MEM_SIGNATURE2_DEFAULT							(0x00000000UL)

#define TCF_CR_TC_MEM_SIGNATURE2_TC_MEM_SIGNATURE2_MASK				(0xFFFFFFFFUL)
#define TCF_CR_TC_MEM_SIGNATURE2_TC_MEM_SIGNATURE2_SHIFT			(0)

/* Register TCF_CR_TC_MEM_SIGNATURE3 */
#define TCF_CR_TC_MEM_SIGNATURE3									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x00C0UL)
#define TCF_CR_TC_MEM_SIGNATURE3_DEFAULT							(0x00000000UL)

#define TCF_CR_TC_MEM_SIGNATURE3_TC_MEM_SIGNATURE3_MASK				(0xFFFFFFFFUL)
#define TCF_CR_TC_MEM_SIGNATURE3_TC_MEM_SIGNATURE3_SHIFT			(0)

/* Register TCF_CR_INTERRUPT_STATUS */
#define TCF_CR_INTERRUPT_STATUS										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x00C8UL)
#define TCF_CR_INTERRUPT_STATUS_DEFAULT								(0x00000000UL)

#define TCF_CR_INTERRUPT_STATUS_INTERRUPT_MASTER_STATUS_MASK		(0x80000000UL)
#define TCF_CR_INTERRUPT_STATUS_INTERRUPT_MASTER_STATUS_SHIFT		(31)

#define TCF_CR_INTERRUPT_STATUS_OTHER_INTS_MASK						(0x7FFE0000UL)
#define TCF_CR_INTERRUPT_STATUS_OTHER_INTS_SHIFT					(17)

#define TCF_CR_INTERRUPT_STATUS_HOST_MST_NORESPONSE_MASK			(0x00010000UL)
#define TCF_CR_INTERRUPT_STATUS_HOST_MST_NORESPONSE_SHIFT			(16)

#define TCF_CR_INTERRUPT_STATUS_PDP2_INT_MASK						(0x00008000UL)
#define TCF_CR_INTERRUPT_STATUS_PDP2_INT_SHIFT						(15)

#define TCF_CR_INTERRUPT_STATUS_PDP1_INT_MASK						(0x00004000UL)
#define TCF_CR_INTERRUPT_STATUS_PDP1_INT_SHIFT						(14)

#define TCF_CR_INTERRUPT_STATUS_EXT_INT_MASK						(0x00002000UL)
#define TCF_CR_INTERRUPT_STATUS_EXT_INT_SHIFT						(13)

#define TCF_CR_INTERRUPT_STATUS_SCB_MST_HLT_BIT_MASK				(0x00001000UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_MST_HLT_BIT_SHIFT				(12)

#define TCF_CR_INTERRUPT_STATUS_SCB_SLV_EVENT_MASK					(0x00000800UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_SLV_EVENT_SHIFT					(11)

#define TCF_CR_INTERRUPT_STATUS_SCB_TDONE_RX_MASK					(0x00000400UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_TDONE_RX_SHIFT					(10)

#define TCF_CR_INTERRUPT_STATUS_SCB_SLV_WT_RD_DAT_MASK				(0x00000200UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_SLV_WT_RD_DAT_SHIFT				(9)

#define TCF_CR_INTERRUPT_STATUS_SCB_SLV_WT_PRV_RD_MASK				(0x00000100UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_SLV_WT_PRV_RD_SHIFT				(8)

#define TCF_CR_INTERRUPT_STATUS_SCB_SLV_WT_WR_DAT_MASK				(0x00000080UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_SLV_WT_WR_DAT_SHIFT				(7)

#define TCF_CR_INTERRUPT_STATUS_SCB_MST_WT_RD_DAT_MASK				(0x00000040UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_MST_WT_RD_DAT_SHIFT				(6)

#define TCF_CR_INTERRUPT_STATUS_SCB_ADD_ACK_ERR_MASK				(0x00000020UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_ADD_ACK_ERR_SHIFT				(5)

#define TCF_CR_INTERRUPT_STATUS_SCB_WR_ACK_ERR_MASK					(0x00000010UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_WR_ACK_ERR_SHIFT				(4)

#define TCF_CR_INTERRUPT_STATUS_SCB_SDAT_LO_TIM_MASK				(0x00000008UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_SDAT_LO_TIM_SHIFT				(3)

#define TCF_CR_INTERRUPT_STATUS_SCB_SCLK_LO_TIM_MASK				(0x00000004UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_SCLK_LO_TIM_SHIFT				(2)

#define TCF_CR_INTERRUPT_STATUS_SCB_UNEX_START_BIT_MASK				(0x00000002UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_UNEX_START_BIT_SHIFT			(1)

#define TCF_CR_INTERRUPT_STATUS_SCB_BUS_INACTIVE_MASK				(0x00000001UL)
#define TCF_CR_INTERRUPT_STATUS_SCB_BUS_INACTIVE_SHIFT				(0)

/* Register TCF_CR_INTERRUPT_OP_CFG */
#define TCF_CR_INTERRUPT_OP_CFG										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x00D0UL)
#define TCF_CR_INTERRUPT_OP_CFG_DEFAULT								(0x40000000UL)

#define TCF_CR_INTERRUPT_OP_CFG_PULSE_NLEVEL_MASK					(0x80000000UL)
#define TCF_CR_INTERRUPT_OP_CFG_PULSE_NLEVEL_SHIFT					(31)

#define TCF_CR_INTERRUPT_OP_CFG_INT_SENSE_MASK						(0x40000000UL)
#define TCF_CR_INTERRUPT_OP_CFG_INT_SENSE_SHIFT						(30)

#define TCF_CR_INTERRUPT_OP_CFG_INTERRUPT_DEST_MASK					(0x0000000FUL)
#define TCF_CR_INTERRUPT_OP_CFG_INTERRUPT_DEST_SHIFT				(0)

/* Register TCF_CR_INTERRUPT_ENABLE */
#define TCF_CR_INTERRUPT_ENABLE										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x00D8UL)
#define TCF_CR_INTERRUPT_ENABLE_DEFAULT								(0x00000000UL)

#define TCF_CR_INTERRUPT_ENABLE_INTERRUPT_MASTER_ENABLE_MASK		(0x80000000UL)
#define TCF_CR_INTERRUPT_ENABLE_INTERRUPT_MASTER_ENABLE_SHIFT		(31)

#define TCF_CR_INTERRUPT_ENABLE_INTERRUPT_MASTER_STATUS_MASK		(0x80000000UL)
#define TCF_CR_INTERRUPT_ENABLE_INTERRUPT_MASTER_STATUS_SHIFT		(31)

#define TCF_CR_INTERRUPT_ENABLE_OTHER_INTS_MASK						(0x7FFE0000UL)
#define TCF_CR_INTERRUPT_ENABLE_OTHER_INTS_SHIFT					(17)

#define TCF_CR_INTERRUPT_ENABLE_HOST_MST_NORESPONSE_MASK			(0x00010000UL)
#define TCF_CR_INTERRUPT_ENABLE_HOST_MST_NORESPONSE_SHIFT			(16)

#define TCF_CR_INTERRUPT_ENABLE_PDP2_INT_MASK						(0x00008000UL)
#define TCF_CR_INTERRUPT_ENABLE_PDP2_INT_SHIFT						(15)

#define TCF_CR_INTERRUPT_ENABLE_PDP1_INT_MASK						(0x00004000UL)
#define TCF_CR_INTERRUPT_ENABLE_PDP1_INT_SHIFT						(14)

#define TCF_CR_INTERRUPT_ENABLE_EXT_INT_MASK						(0x00002000UL)
#define TCF_CR_INTERRUPT_ENABLE_EXT_INT_SHIFT						(13)

#define TCF_CR_INTERRUPT_ENABLE_SCB_MST_HLT_BIT_MASK				(0x00001000UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_MST_HLT_BIT_SHIFT				(12)

#define TCF_CR_INTERRUPT_ENABLE_SCB_SLV_EVENT_MASK					(0x00000800UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_SLV_EVENT_SHIFT					(11)

#define TCF_CR_INTERRUPT_ENABLE_SCB_TDONE_RX_MASK					(0x00000400UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_TDONE_RX_SHIFT					(10)

#define TCF_CR_INTERRUPT_ENABLE_SCB_SLV_WT_RD_DAT_MASK				(0x00000200UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_SLV_WT_RD_DAT_SHIFT				(9)

#define TCF_CR_INTERRUPT_ENABLE_SCB_SLV_WT_PRV_RD_MASK				(0x00000100UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_SLV_WT_PRV_RD_SHIFT				(8)

#define TCF_CR_INTERRUPT_ENABLE_SCB_SLV_WT_WR_DAT_MASK				(0x00000080UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_SLV_WT_WR_DAT_SHIFT				(7)

#define TCF_CR_INTERRUPT_ENABLE_SCB_MST_WT_RD_DAT_MASK				(0x00000040UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_MST_WT_RD_DAT_SHIFT				(6)

#define TCF_CR_INTERRUPT_ENABLE_SCB_ADD_ACK_ERR_MASK				(0x00000020UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_ADD_ACK_ERR_SHIFT				(5)

#define TCF_CR_INTERRUPT_ENABLE_SCB_WR_ACK_ERR_MASK					(0x00000010UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_WR_ACK_ERR_SHIFT				(4)

#define TCF_CR_INTERRUPT_ENABLE_SCB_SDAT_LO_TIM_MASK				(0x00000008UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_SDAT_LO_TIM_SHIFT				(3)

#define TCF_CR_INTERRUPT_ENABLE_SCB_SCLK_LO_TIM_MASK				(0x00000004UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_SCLK_LO_TIM_SHIFT				(2)

#define TCF_CR_INTERRUPT_ENABLE_SCB_UNEX_START_BIT_MASK				(0x00000002UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_UNEX_START_BIT_SHIFT			(1)

#define TCF_CR_INTERRUPT_ENABLE_SCB_BUS_INACTIVE_MASK				(0x00000001UL)
#define TCF_CR_INTERRUPT_ENABLE_SCB_BUS_INACTIVE_SHIFT				(0)

/* Register TCF_CR_INTERRUPT_CLEAR */
#define TCF_CR_INTERRUPT_CLEAR										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x00E0UL)
#define TCF_CR_INTERRUPT_CLEAR_DEFAULT								(0x00000000UL)

#define TCF_CR_INTERRUPT_CLEAR_INTERRUPT_MASTER_CLEAR_MASK			(0x80000000UL)
#define TCF_CR_INTERRUPT_CLEAR_INTERRUPT_MASTER_CLEAR_SHIFT			(31)

#define TCF_CR_INTERRUPT_CLEAR_INTERRUPT_MASTER_STATUS_MASK			(0x80000000UL)
#define TCF_CR_INTERRUPT_CLEAR_INTERRUPT_MASTER_STATUS_SHIFT		(31)

#define TCF_CR_INTERRUPT_CLEAR_OTHER_INTS_MASK						(0x7FFE0000UL)
#define TCF_CR_INTERRUPT_CLEAR_OTHER_INTS_SHIFT						(17)

#define TCF_CR_INTERRUPT_CLEAR_HOST_MST_NORESPONSE_MASK				(0x00010000UL)
#define TCF_CR_INTERRUPT_CLEAR_HOST_MST_NORESPONSE_SHIFT			(16)

#define TCF_CR_INTERRUPT_CLEAR_PDP2_INT_MASK						(0x00008000UL)
#define TCF_CR_INTERRUPT_CLEAR_PDP2_INT_SHIFT						(15)

#define TCF_CR_INTERRUPT_CLEAR_PDP1_INT_MASK						(0x00004000UL)
#define TCF_CR_INTERRUPT_CLEAR_PDP1_INT_SHIFT						(14)

#define TCF_CR_INTERRUPT_CLEAR_EXT_INT_MASK							(0x00002000UL)
#define TCF_CR_INTERRUPT_CLEAR_EXT_INT_SHIFT						(13)

#define TCF_CR_INTERRUPT_CLEAR_SCB_MST_HLT_BIT_MASK					(0x00001000UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_MST_HLT_BIT_SHIFT				(12)

#define TCF_CR_INTERRUPT_CLEAR_SCB_SLV_EVENT_MASK					(0x00000800UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_SLV_EVENT_SHIFT					(11)

#define TCF_CR_INTERRUPT_CLEAR_SCB_TDONE_RX_MASK					(0x00000400UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_TDONE_RX_SHIFT					(10)

#define TCF_CR_INTERRUPT_CLEAR_SCB_SLV_WT_RD_DAT_MASK				(0x00000200UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_SLV_WT_RD_DAT_SHIFT				(9)

#define TCF_CR_INTERRUPT_CLEAR_SCB_SLV_WT_PRV_RD_MASK				(0x00000100UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_SLV_WT_PRV_RD_SHIFT				(8)

#define TCF_CR_INTERRUPT_CLEAR_SCB_SLV_WT_WR_DAT_MASK				(0x00000080UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_SLV_WT_WR_DAT_SHIFT				(7)

#define TCF_CR_INTERRUPT_CLEAR_SCB_MST_WT_RD_DAT_MASK				(0x00000040UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_MST_WT_RD_DAT_SHIFT				(6)

#define TCF_CR_INTERRUPT_CLEAR_SCB_ADD_ACK_ERR_MASK					(0x00000020UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_ADD_ACK_ERR_SHIFT				(5)

#define TCF_CR_INTERRUPT_CLEAR_SCB_WR_ACK_ERR_MASK					(0x00000010UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_WR_ACK_ERR_SHIFT					(4)

#define TCF_CR_INTERRUPT_CLEAR_SCB_SDAT_LO_TIM_MASK					(0x00000008UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_SDAT_LO_TIM_SHIFT				(3)

#define TCF_CR_INTERRUPT_CLEAR_SCB_SCLK_LO_TIM_MASK					(0x00000004UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_SCLK_LO_TIM_SHIFT				(2)

#define TCF_CR_INTERRUPT_CLEAR_SCB_UNEX_START_BIT_MASK				(0x00000002UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_UNEX_START_BIT_SHIFT				(1)

#define TCF_CR_INTERRUPT_CLEAR_SCB_BUS_INACTIVE_MASK				(0x00000001UL)
#define TCF_CR_INTERRUPT_CLEAR_SCB_BUS_INACTIVE_SHIFT				(0)

/* Register TCF_CR_YCC_RGB_CTRL */
#define TCF_CR_YCC_RGB_CTRL											(TCF_CR_CLOCK_CONTROL_OFFSET + 0x00E8UL)
#define TCF_CR_YCC_RGB_CTRL_DEFAULT									(0x00000000UL)

#define TCF_CR_YCC_RGB_CTRL_RGB_CTRL2_MASK							(0x01FF0000UL)
#define TCF_CR_YCC_RGB_CTRL_RGB_CTRL2_SHIFT							(16)

#define TCF_CR_YCC_RGB_CTRL_RGB_CTRL1_MASK							(0x000001FFUL)
#define TCF_CR_YCC_RGB_CTRL_RGB_CTRL1_SHIFT							(0)

/* Register TCF_CR_EXP_BRD_STATUS */
#define TCF_CR_EXP_BRD_STATUS										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x00F0UL)
#define TCF_CR_EXP_BRD_STATUS_DEFAULT								(0x00000007UL)

#define TCF_CR_EXP_BRD_STATUS_EXP_BRD_INPUT_MASK					(0x01FF0000UL)
#define TCF_CR_EXP_BRD_STATUS_EXP_BRD_INPUT_SHIFT					(16)

#define TCF_CR_EXP_BRD_STATUS_EXP_BRD_TYPE_MASK						(0x00000007UL)
#define TCF_CR_EXP_BRD_STATUS_EXP_BRD_TYPE_SHIFT					(0)

/* Register TCF_CR_EXP_BRD_CTRL */
#define TCF_CR_EXP_BRD_CTRL											(TCF_CR_CLOCK_CONTROL_OFFSET + 0x00F8UL)
#define TCF_CR_EXP_BRD_CTRL_DEFAULT									(0x00000700UL)

#define TCF_CR_EXP_BRD_CTRL_EXP_BRD_OUTPUT_MASK						(0xFFFFFF00UL)
#define TCF_CR_EXP_BRD_CTRL_EXP_BRD_OUTPUT_SHIFT					(8)

#define TCF_CR_EXP_BRD_CTRL_PDP2_DATA_EN_MASK						(0x00000030UL)
#define TCF_CR_EXP_BRD_CTRL_PDP2_DATA_EN_SHIFT						(4)

#define TCF_CR_EXP_BRD_CTRL_PDP1_DATA_EN_MASK						(0x00000003UL)
#define TCF_CR_EXP_BRD_CTRL_PDP1_DATA_EN_SHIFT						(0)

/* Register TCF_CR_HOSTIF_CONTROL */
#define TCF_CR_HOSTIF_CONTROL										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0100UL)
#define TCF_CR_HOSTIF_CONTROL_DEFAULT								(0x00000000UL)

#define TCF_CR_HOSTIF_CONTROL_HOSTIF_CTRL_MASK						(0x000000FFUL)
#define TCF_CR_HOSTIF_CONTROL_HOSTIF_CTRL_SHIFT						(0)

/* Register TCF_CR_DUT_CONTROL_1 */
#define TCF_CR_DUT_CONTROL_1										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0108UL)
#define TCF_CR_DUT_CONTROL_1_DEFAULT								(0x000003C0UL)

#define TCF_CR_DUT_CONTROL_1_DUT_CTRL_1_MASK						(0xFFFFFFFFUL)
#define TCF_CR_DUT_CONTROL_1_DUT_CTRL_1_SHIFT						(0)

/* Register TCF_CR_DUT_STATUS_1 */
#define TCF_CR_DUT_STATUS_1											(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0110UL)
#define TCF_CR_DUT_STATUS_1_DEFAULT									(0x00000000UL)

#define TCF_CR_DUT_STATUS_1_DUT_STATUS_1_MASK						(0xFFFFFFFFUL)
#define TCF_CR_DUT_STATUS_1_DUT_STATUS_1_SHIFT						(0)

/* Register TCF_CR_DUT_CTRL_NOT_STAT_1 */
#define TCF_CR_DUT_CTRL_NOT_STAT_1									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0118UL)
#define TCF_CR_DUT_CTRL_NOT_STAT_1_DEFAULT							(0x0000003FFUL)

#define TCF_CR_DUT_CTRL_NOT_STAT_1_DUT_STAT_NOT_CTRL_1_MASK			(0xFFFFFFFFUL)
#define TCF_CR_DUT_CTRL_NOT_STAT_1_DUT_STAT_NOT_CTRL_1_SHIFT		(0)

/* Register TCF_CR_DUT_CONTROL_2 */
#define TCF_CR_DUT_CONTROL_2										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0120UL)
#define TCF_CR_DUT_CONTROL_2_DEFAULT								(0x00000000UL)

#define TCF_CR_DUT_CONTROL_2_DUT_CTRL_2_MASK						(0xFFFFFFFFUL)
#define TCF_CR_DUT_CONTROL_2_DUT_CTRL_2_SHIFT						(0)

/* Register TCF_CR_DUT_STATUS_2 */
#define TCF_CR_DUT_STATUS_2											(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0128UL)
#define TCF_CR_DUT_STATUS_2_DEFAULT									(0x00000000UL)

#define TCF_CR_DUT_STATUS_2_DUT_STATUS_2_MASK						(0xFFFFFFFFUL)
#define TCF_CR_DUT_STATUS_2_DUT_STATUS_2_SHIFT						(0)

/* Register TCF_CR_DUT_CTRL_NOT_STAT_2 */
#define TCF_CR_DUT_CTRL_NOT_STAT_2									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0130UL)
#define TCF_CR_DUT_CTRL_NOT_STAT_2_DEFAULT							(0x00000000UL)

#define TCF_CR_DUT_CTRL_NOT_STAT_2_DUT_CTRL_NOT_STAT_2_MASK			(0xFFFFFFFFUL)
#define TCF_CR_DUT_CTRL_NOT_STAT_2_DUT_CTRL_NOT_STAT_2_SHIFT		(0)

/* Register TCF_CR_BUS_CAP_BASE_ADDR */
#define TCF_CR_BUS_CAP_BASE_ADDR									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0138UL)
#define TCF_CR_BUS_CAP_BASE_ADDR_DEFAULT							(0x00000000UL)

#define TCF_CR_BUS_CAP_BASE_ADDR_BUS_CAP_BASE_ADDR_MASK				(0xFFFFFFFFUL)
#define TCF_CR_BUS_CAP_BASE_ADDR_BUS_CAP_BASE_ADDR_SHIFT			(0)

/* Register TCF_CR_BUS_CAP_ENABLE */
#define TCF_CR_BUS_CAP_ENABLE										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0140UL)
#define TCF_CR_BUS_CAP_ENABLE_DEFAULT								(0x00000000UL)

#define TCF_CR_BUS_CAP_ENABLE_BUS_CAP_ENABLE_MASK					(0x00000001UL)
#define TCF_CR_BUS_CAP_ENABLE_BUS_CAP_ENABLE_SHIFT					(0)

/* Register TCF_CR_BUS_CAP_COUNT */
#define TCF_CR_BUS_CAP_COUNT										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0148UL)
#define TCF_CR_BUS_CAP_COUNT_DEFAULT								(0x00000000UL)

#define TCF_CR_BUS_CAP_COUNT_BUS_CAP_COUNT_MASK						(0xFFFFFFFFUL)
#define TCF_CR_BUS_CAP_COUNT_BUS_CAP_COUNT_SHIFT					(0)

/* Register TCF_CR_DCM_LOCK_STATUS */
#define TCF_CR_DCM_LOCK_STATUS										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0150UL)
#define TCF_CR_DCM_LOCK_STATUS_DEFAULT								(0x00000000UL)

#define TCF_CR_DCM_LOCK_STATUS_DCM_LOCK_STATUS_MASK					(0xFFFFFFFFUL)
#define TCF_CR_DCM_LOCK_STATUS_DCM_LOCK_STATUS_SHIFT				(0)

/* Register TCF_CR_AUX_DUT_RESETNS */
#define TCF_CR_AUX_DUT_RESETNS										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0158UL)
#define TCF_CR_AUX_DUT_RESETNS_DEFAULT								(0x0000000FUL)

#define TCF_CR_AUX_DUT_RESETNS_AUX_DUT_RESETNS_MASK					(0x0000000FUL)
#define TCF_CR_AUX_DUT_RESETNS_AUX_DUT_RESETNS_SHIFT				(0)

/* Register TCF_CR_TCF_SPI_MST_ADDR_RDNWR */
#define TCF_CR_TCF_SPI_MST_ADDR_RDNWR								(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0160UL)
#define TCF_CR_TCF_SPI_MST_ADDR_RDNWR_DEFAULT						(0x00000000UL)

#define TCF_CR_TCF_SPI_MST_ADDR_RDNWR_TCF_SPI_MST_SLAVE_ID_MASK		(0x00010000UL)
#define TCF_CR_TCF_SPI_MST_ADDR_RDNWR_TCF_SPI_MST_SLAVE_ID_SHIFT	(16)

#define TCF_CR_TCF_SPI_MST_ADDR_RDNWR_TCF_SPI_MST_RDNWR_MASK		(0x00001000UL)
#define TCF_CR_TCF_SPI_MST_ADDR_RDNWR_TCF_SPI_MST_RDNWR_SHIFT		(12)

#define TCF_CR_TCF_SPI_MST_ADDR_RDNWR_TCF_SPI_MST_ADDR_MASK			(0x00000FFFUL)
#define TCF_CR_TCF_SPI_MST_ADDR_RDNWR_TCF_SPI_MST_ADDR_SHIFT		(0)

/* Register TCF_CR_TCF_SPI_MST_WDATA */
#define TCF_CR_TCF_SPI_MST_WDATA									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0168UL)
#define TCF_CR_TCF_SPI_MST_WDATA_DEFAULT							(0x00000000UL)

#define TCF_CR_TCF_SPI_MST_WDATA_TCF_SPI_MST_WDATA_MASK				(0xFFFFFFFFUL)
#define TCF_CR_TCF_SPI_MST_WDATA_TCF_SPI_MST_WDATA_SHIFT			(0)

/* Register TCF_CR_TCF_SPI_MST_RDATA */
#define TCF_CR_TCF_SPI_MST_RDATA									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0170UL)
#define TCF_CR_TCF_SPI_MST_RDATA_DEFAULT							(0x00000000UL)

#define TCF_CR_TCF_SPI_MST_RDATA_TCF_SPI_MST_RDATA_MASK				(0xFFFFFFFFUL)
#define TCF_CR_TCF_SPI_MST_RDATA_TCF_SPI_MST_RDATA_SHIFT			(0)

/* Register TCF_CR_TCF_SPI_MST_STATUS */
#define TCF_CR_TCF_SPI_MST_STATUS									(TCF_CR_CLOCK_CONTORL_OFFSET + 0x0178UL)
#define TCF_CR_TCF_SPI_MST_STATUS_DEFAULT							(0x00000000UL)

#define TCF_CR_TCF_SPI_MST_STATUS_TCF_SPI_MST_STATUS_MASK			(0x0000000FUL)
#define TCF_CR_TCF_SPI_MST_STATUS_TCF_SPI_MST_STATUS_SHIFT			(0)

/* Register TCF_CR_TCF_SPI_MST_GO */
#define TCF_CR_TCF_SPI_MST_GO										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0180UL)
#define TCF_CR_TCF_SPI_MST_GO_DEFAULT								(0x00000000UL)

#define TCF_CR_TCF_SPI_MST_GO_TCF_SPI_MST_GO_MASK					(0x00000001UL)
#define TCF_CR_TCF_SPI_MST_GO_TCF_SPI_MST_GO_SHIFT					(0)

/* Register TCF_CR_EXT_SIG_CTRL */
#define TCF_CR_EXT_SIG_CTRL											(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0188UL)
#define TCF_CR_EXT_SIG_CTRL_DEFAULT									(0x00000000UL)

#define TCF_CR_EXT_SIG_CTRL_EXT_MEM_RD_SIG_START_MASK				(0x00000008UL)
#define TCF_CR_EXT_SIG_CTRL_EXT_MEM_RD_SIG_START_SHIFT				(3)

#define TCF_CR_EXT_SIG_CTRL_EXT_MEM_REQ_SIG_START_MASK				(0x00000004UL)
#define TCF_CR_EXT_SIG_CTRL_EXT_MEM_REQ_SIG_START_SHIFT				(2)

#define TCF_CR_EXT_SIG_CTRL_EXT_SYS_RD_SIG_START_MASK				(0x00000002UL)
#define TCF_CR_EXT_SIG_CTRL_EXT_SYS_RD_SIG_START_SHIFT				(1)

#define TCF_CR_EXT_SIG_CTRL_EXT_SYS_REQ_SIG_START_MASK				(0x00000001UL)
#define TCF_CR_EXT_SIG_CTRL_EXT_SYS_REQ_SIG_START_SHIFT				(0)

/* Register TCF_CR_EXT_SYS_REQ_SIG */
#define TCF_CR_EXT_SYS_REQ_SIG										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0190UL)
#define TCF_CR_EXT_SYS_REQ_SIG_DEFAULT								(0x00000000UL)

#define TCF_CR_EXT_SYS_REQ_SIG_EXT_SYS_REQ_SIG_MASK					(0xFFFFFFFFUL)
#define TCF_CR_EXT_SYS_REQ_SIG_EXT_SYS_REQ_SIG_SHIFT				(0)

/* Register TCF_CR_EXT_SYS_RD_SIG */
#define TCF_CR_EXT_SYS_RD_SIG										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x0198UL)
#define TCF_CR_EXT_SYS_RD_SIG_DEFAULT								(0x00000000UL)

#define TCF_CR_EXT_SYS_RD_SIG_EXT_SYS_RD_SIG_MASK					(0xFFFFFFFFUL)
#define TCF_CR_EXT_SYS_RD_SIG_EXT_SYS_RD_SIG_SHIFT					(0)

/* Register TCF_CR_EXT_MEM_REQ_SIG */
#define TCF_CR_EXT_MEM_REQ_SIG										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x01A0UL)
#define TCF_CR_EXT_MEM_REQ_SIG_DEFAULT								(0x00000000UL)

#define TCF_CR_EXT_MEM_REQ_SIG_EXT_MEM_REQ_SIG_MASK					(0xFFFFFFFFUL)
#define TCF_CR_EXT_MEM_REQ_SIG_EXT_MEM_REQ_SIG_SHIFT				(0)

/* Register TCF_CR_EXT_MEM_RD_SIG */
#define TCF_CR_EXT_MEM_RD_SIG										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x01A8UL)
#define TCF_CR_EXT_MEM_RD_SIG_DEFAULT								(0x00000000UL)

#define TCF_CR_EXT_MEM_RD_SIG_EXT_MEM_RD_SIG_MASK					(0xFFFFFFFFUL)
#define TCF_CR_EXT_MEM_RD_SIG_EXT_MEM_RD_SIG_SHIFT					(0)

/* Register TCF_CR_EXT_SYS_REQ_WR_CNT */
#define TCF_CR_EXT_SYS_REQ_WR_CNT									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x01B0UL)
#define TCF_CR_EXT_SYS_REQ_WR_CNT_DEFAULT							(0x00000000UL)

#define TCF_CR_EXT_SYS_REQ_WR_CNT_EXT_SYS_REQ_WR_CNT_MASK			(0xFFFFFFFFUL)
#define TCF_CR_EXT_SYS_REQ_WR_CNT_EXT_SYS_REQ_WR_CNT_SHIFT			(0)

/* Register TCF_CR_EXT_SYS_REQ_RD_CNT */
#define TCF_CR_EXT_SYS_REQ_RD_CNT									(TCF_CR_CLOCK_CONTROL_OFFSET + 0x01B8UL)
#define TCF_CR_EXT_SYS_REQ_RD_CNT_DEFAULT							(0x00000000UL)

#define TCF_CR_EXT_SYS_REQ_RD_CNT_EXT_SYS_REQ_RD_CNT_MASK			(0xFFFFFFFFUL)
#define TCF_CR_EXT_SYS_REQ_RD_CNT_EXT_SYS_REQ_RD_CNT_SHIFT			(0)

/* Register TCF_CR_EXT_SYS_RD_CNT */
#define TCF_CR_EXT_SYS_RD_CNT										(TCF_CR_CLOCK_CONTROL + 0x01C0UL)
#define TCF_CR_EXT_SYS_RD_CNT_DEFAULT								(0x00000000UL)

#define TCF_CR_EXT_SYS_RD_CNT_EXT_SYS_RD_CNT_MASK					(0xFFFFFFFFUL)
#define TCF_CR_EXT_SYS_RD_CNT_EXT_SYS_RD_CNT_SHIFT					(0)

/* Register TCF_CR_EXT_MEM_REQ_WR_CNT */
#define TCF_CR_EXT_MEM_REQ_WR_CNT									(TCF_CR_CLOCK_CONTROL + 0x01C8UL)
#define TCF_CR_EXT_MEM_REQ_WR_CNT_DEFAULT							(0x00000000UL)

#define TCF_CR_EXT_MEM_REQ_WR_CNT_EXT_MEM_REQ_WR_CNT_MASK			(0xFFFFFFFFUL)
#define TCF_CR_EXT_MEM_REQ_WR_CNT_EXT_MEM_REQ_WR_CNT_SHIFT			(0)

/* Register TCF_CR_EXT_MEM_REQ_RD_CNT */
#define TCF_CR_EXT_MEM_REQ_RD_CNT									(TCF_CR_CLOCK_CONTROL + 0x01D0UL)
#define TCF_CR_EXT_MEM_REQ_RD_CNT_DEFAULT							(0x00000000UL)

#define TCF_CR_EXT_MEM_REQ_RD_CNT_EXT_MEM_REQ_RD_CNT_MASK			(0xFFFFFFFFUL)
#define TCF_CR_EXT_MEM_REQ_RD_CNT_EXT_MEM_REQ_RD_CNT_SHIFT			(0)

/* Register TCF_CR_EXT_MEM_RD_CNT */
#define TCF_CR_EXT_MEM_RD_CNT										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x01D8UL)
#define TCF_CR_EXT_MEM_RD_CNT_DEFAULT								(0x00000000UL)

#define TCF_CR_EXT_MEM_RD_CNT_EXT_MEM_RD_CNT_MASK					(0xFFFFFFFFUL)
#define TCF_CR_EXT_MEM_RD_CNT_EXT_MEM_RD_CNT_SHIFT					(0)

/* Register TCF_CR_EXT_MEM_RD_CNT */
#define TCF_CR_EXT_MEM_RD_CNT										(TCF_CR_CLOCK_CONTROL_OFFSET + 0x01D8UL)
#define TCF_CR_EXT_MEM_RD_CNT_DEFAULT								(0x00000000UL)


/* DDR2 registers */
/* Register TCF_CR_DDR2_MEM_CONTROL_INIT */
#define TCF_CR_DDR2_MEM_CONTROL_INIT								(TCF_CR_DDR2_OFFSET + 0x0000UL)
#define TCF_CR_DDR2_MEM_CONTROL_INIT_DEFAULT						(0x00004010UL)

#define TCF_CR_DDR2_MEM_CONTROL_INIT_DDR2_CFG_STARTUP_DELAY_MASK	(0x003FFFE0UL)
#define TCF_CR_DDR2_MEM_CONTROL_INIT_DDR2_CFG_STARTUP_DELAY_SHIFT	(5)

#define TCF_CR_DDR2_MEM_CONTROL_INIT_DDR2_CFG_AUTO_REF_EN_MASK		(0x00000010UL)
#define TCF_CR_DDR2_MEM_CONTROL_INIT_DDR2_CFG_AUTO_REF_EN_SHIFT		(4)

#define TCF_CR_DDR2_MEM_CONTROL_INIT_DDR2_CFG_LOOKAHEAD_ACT_MASK	(0x00000008UL)
#define TCF_CR_DDR2_MEM_CONTROL_INIT_DDR2_CFG_LOOKAHEAD_ACT_SHIFT	(3)

#define TCF_CR_DDR2_MEM_CONTROL_INIT_DDR2_CFG_LOOKAHEAD_PCH_MASK	(0x00000004UL)
#define TCF_CR_DDR2_MEM_CONTROL_INIT_DDR2_CFG_LOOKAHEAD_PCH_SHIFT	(2)

#define TCF_CR_DDR2_MEM_CONTROL_INIT_DDR2_CFG_PCH_POWER_DOWN_MASK	(0x00000002UL)
#define TCF_CR_DDR2_MEM_CONTROL_INIT_DDR2_CFG_PCH_POWER_DOWN_SHIFT	(1)

#define TCF_CR_DDR2_MEM_CONTROL_INIT_DDR2_CTRLR_INIT_MASK			(0x00000001UL)
#define TCF_CR_DDR2_MEM_CONTROL_INIT_DDR2_CTRLR_INIT_SHIFT			(0)

/* Register TCF_CR_DDR2_MEM_CONTROL_REF_PERIOD */
#define TCF_CR_DDR2_MEM_CONTROL_REF_PERIOD							(TCF_CR_DDR2_OFFSET + 0x0008UL)
#define TCF_CR_DDR2_MEM_CONTROL_REF_PERIOD_DEFAULT					(0x0000041AUL)

#define TCF_CR_DDR2_MEM_CONTROL_REF_PERIOD_DDR2_CFG_REF_PER_MASK	(0x0000FFFFUL)
#define TCF_CR_DDR2_MEM_CONTROL_REF_PERIOD_DDR2_CFG_REF_PER_SHIFT	(0)

/* Register TCF_CR_DDR2_MEM_CONTROL */
#define TCF_CR_DDR2_MEM_CONTROL										(TCF_CR_DDR2_OFFSET + 0x0010UL)
#define TCF_CR_DDR2_MEM_CONTROL_DEFAULT								(0x1A73E28BUL)

#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_RFC_MASK					(0xFF000000UL)
#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_RFC_SHIFT					(24)

#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_FAW_MASK					(0x00F80000UL)
#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_FAW_SHIFT					(19)

#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_RC_MASK					(0x0007C000UL)
#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_RC_SHIFT					(14)

#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_RP_MASK					(0x00003800UL)
#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_RP_SHIFT					(11)

#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_RRD_MASK					(0x00000700UL)
#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_RRD_SHIFT					(8)

#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_RCD_MASK					(0x000000E0UL)
#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_RCD_SHIFT					(5)

#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_RAS_MASK					(0x0000001FUL)
#define TCF_CR_DDR2_MEM_CONTROL_DDR2_CFG_RAS_SHIFT					(0)

/* Register TCF_CR_DDR2_MEM_CONTROL2 */
#define TCF_CR_DDR2_MEM_CONTROL2									(TCF_CR_DDR2_OFFSET + 0x0018UL)
#define TCF_CR_DDR2_MEM_CONTROL2_DEFAULT							(0x03ED2922UL)

#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_XSNR_MASK					(0x1FE00000UL)
#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_XSNR_SHIFT				(21)

#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_MRD_MASK					(0x001C0000UL)
#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_MRD_SHIFT					(18)

#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_READ_TO_READ_MASK			(0x00038000UL)
#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_READ_TO_READ_SHIFT		(15)

#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_WRITE_TO_WRITE_MASK		(0x00007000UL)
#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_WRITE_TO_WRITE_SHIFT		(12)

#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_READ_TO_WRITE_MASK		(0x00000C00UL)
#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_READ_TO_WRITE_SHIFT		(10)

#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_WTR_MASK					(0x00000380UL)
#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_WTR_SHIFT					(7)

#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_WR_MASK					(0x00000078UL)
#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_WR_SHIFT					(3)

#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_RTP_MASK					(0x00000007UL)
#define TCF_CR_DDR2_MEM_CONTROL2_DDR2_CFG_RTP_SHIFT					(0)

/* Register TCF_CR_DDR2_MEM_CONTROL3 */
#define TCF_CR_DDR2_MEM_CONTROL3									(TCF_CR_DDR2_OFFSET + 0x0020UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DEFAULT							(0x00553060UL)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_TWO_T_SEL_CYCLE_MASK		(0x02000000UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_TWO_T_SEL_CYCLE_SHIFT		(25)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_TWO_T_MASK				(0x01000000UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_TWO_T_SHIFT				(24)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_REGDIMM_MASK				(0x00800000UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_REGDIMM_SHIFT				(23)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_BANKBITS_MASK				(0x00400000UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_BANKBITS_SHIFT			(22)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_ROWBITS_MASK				(0x00380000UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_ROWBITS_SHIFT				(19)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_COLBITS_MASK				(0x00070000UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_COLBITS_SHIFT				(16)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_DLL_DISABLE_MASK			(0x00008000UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_DLL_DISABLE_SHIFT			(15)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_RTT_MASK					(0x00006000UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_RTT_SHIFT					(13)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_DIFF_DQS_MASK				(0x00001000UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_DIFF_DQS_SHIFT			(12)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_RDQS_MASK					(0x00000800UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_RDQS_SHIFT				(11)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_QOFF_MASK					(0x00000400UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_QOFF_SHIFT				(10)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_DS_MASK					(0x00000200UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_DS_SHIFT					(9)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_BT_MASK					(0x00000100UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_BT_SHIFT					(8)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_BL_MASK					(0x000000C0UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_BL_SHIFT					(6)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_CL_MASK					(0x00000038UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_CL_SHIFT					(3)

#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_AL_MASK					(0x00000007UL)
#define TCF_CR_DDR2_MEM_CONTROL3_DDR2_CFG_AL_SHIFT					(0)

/* Register TCF_CR_DDR2_ODT_RD_MAP1 */
#define TCF_CR_DDR2_ODT_RD_MAP1										(TCF_CR_DDR2_OFFSET + 0x0028UL)
#define TCF_CR_DDR2_ODT_RD_MAP1_DEFAULT								(0x00000000UL)

#define TCF_CR_DDR2_ODT_RD_MAP1_DDR2_CFG_ODT_RD_MAP_CS3_MASK		(0xFF000000UL)
#define TCF_CR_DDR2_ODT_RD_MAP1_DDR2_CFG_ODT_RD_MAP_CS3_SHIFT		(24)

#define TCF_CR_DDR2_ODT_RD_MAP1_DDR2_CFG_ODT_RD_MAP_CS2_MASK		(0x00FF0000UL)
#define TCF_CR_DDR2_ODT_RD_MAP1_DDR2_CFG_ODT_RD_MAP_CS2_SHIFT		(16)

#define TCF_CR_DDR2_ODT_RD_MAP1_DDR2_CFG_ODT_RD_MAP_CS1_MASK		(0x0000FF00UL)
#define TCF_CR_DDR2_ODT_RD_MAP1_DDR2_CFG_ODT_RD_MAP_CS1_SHIFT		(8)

#define TCF_CR_DDR2_ODT_RD_MAP1_DDR2_CFG_ODT_RD_MAP_CS0_MASK		(0x000000FFUL)
#define TCF_CR_DDR2_ODT_RD_MAP1_DDR2_CFG_ODT_RD_MAP_CS0_SHIFT		(0)

/* Register TCF_CR_DDR2_ODT_RD_MAP2 */
#define TCF_CR_DDR2_ODT_RD_MAP2										(TCF_CR_DDR2_OFFSET + 0x0030UL)
#define TCF_CR_DDR2_ODT_RD_MAP2_DEFAULT								(0x00000000UL)

#define TCF_CR_DDR2_ODT_RD_MAP2_DDR2_CFG_ODT_RD_MAP_CS7_MASK		(0xFF000000UL)
#define TCF_CR_DDR2_ODT_RD_MAP2_DDR2_CFG_ODT_RD_MAP_CS7_SHIFT		(24)

#define TCF_CR_DDR2_ODT_RD_MAP2_DDR2_CFG_ODT_RD_MAP_CS6_MASK		(0x00FF0000UL)
#define TCF_CR_DDR2_ODT_RD_MAP2_DDR2_CFG_ODT_RD_MAP_CS6_SHIFT		(16)

#define TCF_CR_DDR2_ODT_RD_MAP2_DDR2_CFG_ODT_RD_MAP_CS5_MASK		(0x0000FF00UL)
#define TCF_CR_DDR2_ODT_RD_MAP2_DDR2_CFG_ODT_RD_MAP_CS5_SHIFT		(8)

#define TCF_CR_DDR2_ODT_RD_MAP2_DDR2_CFG_ODT_RD_MAP_CS4_MASK		(0x000000FFUL)
#define TCF_CR_DDR2_ODT_RD_MAP2_DDR2_CFG_ODT_RD_MAP_CS4_SHIFT		(0)

/* Register TCF_CR_DDR2_ODT_WR_MAP1 */
#define TCF_CR_DDR2_ODT_WR_MAP1										(TCF_CR_DDR2_OFFSET + 0x0038UL)
#define TCF_CR_DDR2_ODT_WR_MAP1_DEFAULT								(0x00000201UL)

#define TCF_CR_DDR2_ODT_WR_MAP1_DDR2_CFG_ODT_WR_MAP_CS3_MASK		(0xFF000000UL)
#define TCF_CR_DDR2_ODT_WR_MAP1_DDR2_CFG_ODT_WR_MAP_CS3_SHIFT		(24)

#define TCF_CR_DDR2_ODT_WR_MAP1_DDR2_CFG_ODT_WR_MAP_CS2_MASK		(0x00FF0000UL)
#define TCF_CR_DDR2_ODT_WR_MAP1_DDR2_CFG_ODT_WR_MAP_CS2_SHIFT		(16)

#define TCF_CR_DDR2_ODT_WR_MAP1_DDR2_CFG_ODT_WR_MAP_CS1_MASK		(0x0000FF00UL)
#define TCF_CR_DDR2_ODT_WR_MAP1_DDR2_CFG_ODT_WR_MAP_CS1_SHIFT		(8)

#define TCF_CR_DDR2_ODT_WR_MAP1_DDR2_CFG_ODT_WR_MAP_CS0_MASK		(0x000000FFUL)
#define TCF_CR_DDR2_ODT_WR_MAP1_DDR2_CFG_ODT_WR_MAP_CS0_SHIFT		(0)

/* Register TCF_CR_DDR2_ODT_WR_MAP2 */
#define TCF_CR_DDR2_ODT_WR_MAP2										(TCF_CR_DDR2_OFFSET + 0x0040UL)
#define TCF_CR_DDR2_ODT_WR_MAP2_DEFAULT								(0x00000000UL)

#define TCF_CR_DDR2_ODT_WR_MAP2_DDR2_CFG_ODT_WR_MAP_CS7_MASK		(0xFF000000UL)
#define TCF_CR_DDR2_ODT_WR_MAP2_DDR2_CFG_ODT_WR_MAP_CS7_SHIFT		(24)

#define TCF_CR_DDR2_ODT_WR_MAP2_DDR2_CFG_ODT_WR_MAP_CS6_MASK		(0x00FF0000UL)
#define TCF_CR_DDR2_ODT_WR_MAP2_DDR2_CFG_ODT_WR_MAP_CS6_SHIFT		(16)

#define TCF_CR_DDR2_ODT_WR_MAP2_DDR2_CFG_ODT_WR_MAP_CS5_MASK		(0x0000FF00UL)
#define TCF_CR_DDR2_ODT_WR_MAP2_DDR2_CFG_ODT_WR_MAP_CS5_SHIFT		(8)

#define TCF_CR_DDR2_ODT_WR_MAP2_DDR2_CFG_ODT_WR_MAP_CS4_MASK		(0x000000FFUL)
#define TCF_CR_DDR2_ODT_WR_MAP2_DDR2_CFG_ODT_WR_MAP_CS4_SHIFT		(0)

/* Register TCF_CR_DDR2_EMR */
#define TCF_CR_DDR2_EMR												(TCF_CR_DDR2_OFFSET + 0x0048UL)
#define TCF_CR_DDR2_EMR_DEFAULT										(0x00000000UL)

#define TCF_CR_DDR2_EMR_DDR2_CFG_EMR3_MASK							(0xFFFF0000UL)
#define TCF_CR_DDR2_EMR_DDR2_CFG_EMR3_SHIFT							(16)

#define TCF_CR_DDR2_EMR_DDR2_CFG_EMR2_MASK							(0x0000FFFFUL)
#define TCF_CR_DDR2_EMR_DDR2_CFG_EMR2_SHIFT							(0)

/* PLL registers */
/* Register TCF_CR_PLL_DDR2_CLK0 */
#define TCF_CR_PLL_DDR2_CLK0										(TCF_CR_PLL_OFFSET + 0x0000UL)
#define TCF_CR_PLL_DDR2_CLK0_DEFAULT								(0x00000064UL)

#define TCF_CR_PLL_DDR2_CLK0_DDR2_PLL_CLK0_PHS_MASK					(0x00300000UL)
#define TCF_CR_PLL_DDR2_CLK0_DDR2_PLL_CLK0_PHS_SHIFT				(20)

#define TCF_CR_PLL_DDR2_CLK0_DDR2_PLL_CLK0_MS_MASK					(0x00030000UL)
#define TCF_CR_PLL_DDR2_CLK0_DDR2_PLL_CLK0_MS_SHIFT					(16)

#define TCF_CR_PLL_DDR2_CLK0_DDR2_PLL_CLK0_FREQ_MASK				(0x000000FFUL)
#define TCF_CR_PLL_DDR2_CLK0_DDR2_PLL_CLK0_FREQ_SHIFT				(0)

/* Register TCF_CR_PLL_DDR2_CLK1TO5 */
#define TCF_CR_PLL_DDR2_CLK1TO5										(TCF_CR_PLL_OFFSET + 0x0008UL)
#define TCF_CR_PLL_DDR2_CLK1TO5_DEFAULT								(0x00100004UL)

#define TCF_CR_PLL_DDR2_CLK1TO5_DDR2_PLL_CLK1TO5_PHS_MASK			(0x3FF00000UL)
#define TCF_CR_PLL_DDR2_CLK1TO5_DDR2_PLL_CLK1TO5_PHS_SHIFT			(20)

#define TCF_CR_PLL_DDR2_CLK1TO5_DDR2_PLL_CLK1TO5_MS_MASK			(0x000FFC00UL)
#define TCF_CR_PLL_DDR2_CLK1TO5_DDR2_PLL_CLK1TO5_MS_SHIFT			(10)

#define TCF_CR_PLL_DDR2_CLK1TO5_DDR2_PLL_CLK1TO5_FREQ_MASK			(0x000003FFUL)
#define TCF_CR_PLL_DDR2_CLK1TO5_DDR2_PLL_CLK1TO5_FREQ_SHIFT			(0)

/* Register TCF_CR_PLL_DDR2_DRP_GO */
#define TCF_CR_PLL_DDR2_DRP_GO										(TCF_CR_PLL_OFFSET + 0x0010UL)
#define TCF_CR_PLL_DDR2_DRP_GO_DEFAULT								(0x00000000UL)

#define TCF_CR_PLL_DDR2_DRP_GO_PLL_DDR2_DRP_GO_MASK					(0x00000001UL)
#define TCF_CR_PLL_DDR2_DRP_GO_PLL_DDR2_DRP_GO_SHIFT				(0)

/* Register TCF_CR_PLL_PDP_CLK0 */
#define TCF_CR_PLL_PDP_CLK0											(TCF_CR_PLL_OFFSET + 0x0018UL)
#define TCF_CR_PLL_PDP_CLK0_DEFAULT									(0x00000019UL)

#define TCF_CR_PLL_PDP_CLK0_PDP_PLL_CLK0_PHS_MASK					(0x00300000UL)
#define TCF_CR_PLL_PDP_CLK0_PDP_PLL_CLK0_PHS_SHIFT					(20)

#define TCF_CR_PLL_PDP_CLK0_PDP_PLL_CLK0_MS_MASK					(0x00030000UL)
#define TCF_CR_PLL_PDP_CLK0_PDP_PLL_CLK0_MS_SHIFT					(16)

#define TCF_CR_PLL_PDP_CLK0_PDP_PLL_CLK0_FREQ_MASK					(0x000000FFUL)
#define TCF_CR_PLL_PDP_CLK0_PDP_PLL_CLK0_FREQ_SHIFT					(0)

/* Register TCF_CR_PLL_PDP_CLK1TO5 */
#define TCF_CR_PLL_PDP_CLK1TO5										(TCF_CR_PLL_OFFSET + 0x0020UL)
#define TCF_CR_PLL_PDP_CLK1TO5_DEFAULT								(0x00000000UL)

#define TCF_CR_PLL_PDP_CLK1TO5_PDP_PLL_CLK1TO5_PHS_MASK				(0x3FF00000UL)
#define TCF_CR_PLL_PDP_CLK1TO5_PDP_PLL_CLK1TO5_PHS_SHIFT			(20)

#define TCF_CR_PLL_PDP_CLK1TO5_PDP_PLL_CLK1TO5_MS_MASK				(0x000FFC00UL)
#define TCF_CR_PLL_PDP_CLK1TO5_PDP_PLL_CLK1TO5_MS_SHIFT				(10)

#define TCF_CR_PLL_PDP_CLK1TO5_PDP_PLL_CLK1TO5_FREQ_MASK			(0x000003FFUL)
#define TCF_CR_PLL_PDP_CLK1TO5_PDP_PLL_CLK1TO5_FREQ_SHIFT			(0)

/* Register TCF_CR_PLL_PDP_DRP_GO */
#define TCF_CR_PLL_PDP_DRP_GO										(TCF_CR_PLL_OFFSET + 0x0028UL)
#define TCF_CR_PLL_PDP_DRP_GO_DEFAULT								(0x00000000UL)

#define TCF_CR_PLL_PDP_DRP_GO_PLL_PDP_DRP_GO_MASK					(0x00000001UL)
#define TCF_CR_PLL_PDP_DRP_GO_PLL_PDP_DRP_GO_SHIFT					(0)

/* Register TCF_CR_PLL_PDP2_CLK0 */
#define TCF_CR_PLL_PDP2_CLK0										(TCF_CR_PLL_OFFSET + 0x0030UL)
#define TCF_CR_PLL_PDP2_CLK0_DEFAULT								(0x00000019UL)

#define TCF_CR_PLL_PDP2_CLK0_PDP2_PLL_CLK0_PHS_MASK					(0x00300000UL)
#define TCF_CR_PLL_PDP2_CLK0_PDP2_PLL_CLK0_PHS_SHIFT				(20)

#define TCF_CR_PLL_PDP2_CLK0_PDP2_PLL_CLK0_MS_MASK					(0x00030000UL)
#define TCF_CR_PLL_PDP2_CLK0_PDP2_PLL_CLK0_MS_SHIFT					(16)

#define TCF_CR_PLL_PDP2_CLK0_PDP2_PLL_CLK0_FREQ_MASK				(0x000000FFUL)
#define TCF_CR_PLL_PDP2_CLK0_PDP2_PLL_CLK0_FREQ_SHIFT				(0)

/* Register TCF_CR_PLL_PDP2_CLK1TO5 */
#define TCF_CR_PLL_PDP2_CLK1TO5										(TCF_CR_PLL_OFFSET + 0x0038UL)
#define TCF_CR_PLL_PDP2_CLK1TO5_DEFAULT								(0x00000000UL)

#define TCF_CR_PLL_PDP2_CLK1TO5_PDP2_PLL_CLK1TO5_PHS_MASK			(0x3FF00000UL)
#define TCF_CR_PLL_PDP2_CLK1TO5_PDP2_PLL_CLK1TO5_PHS_SHIFT			(20)

#define TCF_CR_PLL_PDP2_CLK1TO5_PDP2_PLL_CLK1TO5_MS_MASK			(0x000FFC00UL)
#define TCF_CR_PLL_PDP2_CLK1TO5_PDP2_PLL_CLK1TO5_MS_SHIFT			(10)

#define TCF_CR_PLL_PDP2_CLK1TO5_PDP2_PLL_CLK1TO5_FREQ_MASK			(0x000003FFUL)
#define TCF_CR_PLL_PDP2_CLK1TO5_PDP2_PLL_CLK1TO5_FREQ_SHIFT			(0)

/* Register TCF_CR_PLL_PDP2_DRP_GO */
#define TCF_CR_PLL_PDP2_DRP_GO										(TCF_CR_PLL_OFFSET + 0x0040UL)
#define TCF_CR_PLL_PDP2_DRP_GO_DEFAULT								(0x00000000UL)

#define TCF_CR_PLL_PDP2_DRP_GO_PLL_PDP2_DRP_GO_MASK					(0x00000001UL)
#define TCF_CR_PLL_PDP2_DRP_GO_PLL_PDP2_DRP_GO_SHIFT				(0)

/* Register TCF_CR_PLL_CORE_CLK0 */
#define TCF_CR_PLL_CORE_CLK0										(TCF_CR_PLL_OFFSET + 0x0048UL)
#define TCF_CR_PLL_CORE_CLK0_DEFAULT								(0x00000032UL)

#define TCF_CR_PLL_CORE_CLK0_CORE_PLL_CLK0_PHS_MASK					(0x00300000UL)
#define TCF_CR_PLL_CORE_CLK0_CORE_PLL_CLK0_PHS_SHIFT				(20)

#define TCF_CR_PLL_CORE_CLK0_CORE_PLL_CLK0_MS_MASK					(0x00030000UL)
#define TCF_CR_PLL_CORE_CLK0_CORE_PLL_CLK0_MS_SHIFT					(16)

#define TCF_CR_PLL_CORE_CLK0_CORE_PLL_CLK0_FREQ_MASK				(0x000000FFUL)
#define TCF_CR_PLL_CORE_CLK0_CORE_PLL_CLK0_FREQ_SHIFT				(0)

/* Register TCF_CR_PLL_CORE_CLK1TO5 */
#define TCF_CR_PLL_CORE_CLK1TO5										(TCF_CR_PLL_OFFSET + 0x0050UL)
#define TCF_CR_PLL_CORE_CLK1TO5_DEFAULT								(0x00000000UL)

#define TCF_CR_PLL_CORE_CLK1TO5_CORE_PLL_CLK1TO5_PHS_MASK			(0x3FF00000UL)
#define TCF_CR_PLL_CORE_CLK1TO5_CORE_PLL_CLK1TO5_PHS_SHIFT			(20)

#define TCF_CR_PLL_CORE_CLK1TO5_CORE_PLL_CLK1TO5_MS_MASK			(0x000FFC00UL)
#define TCF_CR_PLL_CORE_CLK1TO5_CORE_PLL_CLK1TO5_MS_SHIFT			(10)

#define TCF_CR_PLL_CORE_CLK1TO5_CORE_PLL_CLK1TO5_FREQ_MASK			(0x000003FFUL)
#define TCF_CR_PLL_CORE_CLK1TO5_CORE_PLL_CLK1TO5_FREQ_SHIFT			(0)

/* Register TCF_CR_PLL_CORE_DRP_GO */
#define TCF_CR_PLL_CORE_DRP_GO										(TCF_CR_PLL_OFFSET + 0x0058UL)
#define TCF_CR_PLL_CORE_DRP_GO_DEFAULT								(0x00000000UL)

#define TCF_CR_PLL_CORE_DRP_GO_PLL_CORE_DRP_GO_MASK					(0x00000001UL)
#define TCF_CR_PLL_CORE_DRP_GO_PLL_CORE_DRP_GO_SHIFT				(0)

/* Register TCF_CR_PLL_SYSIF_CLK0 */
#define TCF_CR_PLL_SYSIF_CLK0										(TCF_CR_PLL_OFFSET + 0x0060UL)
#define TCF_CR_PLL_SYSIF_CLK0_DEFAULT								(0x00000032UL)

#define TCF_CR_PLL_SYSIF_CLK0_SYSIF_PLL_CLK0_PHS_MASK				(0x00300000UL)
#define TCF_CR_PLL_SYSIF_CLK0_SYSIF_PLL_CLK0_PHS_SHIFT				(20)

#define TCF_CR_PLL_SYSIF_CLK0_SYSIF_PLL_CLK0_MS_MASK				(0x00030000UL)
#define TCF_CR_PLL_SYSIF_CLK0_SYSIF_PLL_CLK0_MS_SHIFT				(16)

#define TCF_CR_PLL_SYSIF_CLK0_SYSIF_PLL_CLK0_FREQ_MASK				(0x000000FFUL)
#define TCF_CR_PLL_SYSIF_CLK0_SYSIF_PLL_CLK0_FREQ_SHIFT				(0)

/* Register TCF_CR_PLL_SYSIF_CLK1TO5 */
#define TCF_CR_PLL_SYSIF_CLK1TO5									(TCF_CR_PLL_OFFSET + 0x0068UL)
#define TCF_CR_PLL_SYSIF_CLK1TO5_DEFAULT							(0x00000000UL)

#define TCF_CR_PLL_SYSIF_CLK1TO5_SYSIF_PLL_CLK1TO5_PHS_MASK			(0x3FF00000UL)
#define TCF_CR_PLL_SYSIF_CLK1TO5_SYSIF_PLL_CLK1TO5_PHS_SHIFT		(20)

#define TCF_CR_PLL_SYSIF_CLK1TO5_SYSIF_PLL_CLK1TO5_MS_MASK			(0x000FFC00UL)
#define TCF_CR_PLL_SYSIF_CLK1TO5_SYSIF_PLL_CLK1TO5_MS_SHIFT			(10)

#define TCF_CR_PLL_SYSIF_CLK1TO5_SYSIF_PLL_CLK1TO5_FREQ_MASK		(0x000003FFUL)
#define TCF_CR_PLL_SYSIF_CLK1TO5_SYSIF_PLL_CLK1TO5_FREQ_SHIFT		(0)

/* Register TCF_CR_PLL_SYS_DRP_GO */
#define TCF_CR_PLL_SYS_DRP_GO										(TCF_CR_PLL_OFFSET + 0x0070UL)
#define TCF_CR_PLL_SYS_DRP_GO_DEFAULT								(0x00000000UL)

#define TCF_CR_PLL_SYS_DRP_GO_PLL_SYS_DRP_GO_MASK					(0x00000001UL)
#define TCF_CR_PLL_SYS_DRP_GO_PLL_SYS_DRP_GO_SHIFT					(0)

/* Register TCF_CR_PLL_MEMIF_CLK0 */
#define TCF_CR_PLL_MEMIF_CLK0										(TCF_CR_PLL_OFFSET + 0x0078UL)
#define TCF_CR_PLL_MEMIF_CLK0_DEFAULT								(0x00000032UL)

#define TCF_CR_PLL_MEMIF_CLK0_MEMIF_PLL_CLK0_PHS_MASK				(0x00300000UL)
#define TCF_CR_PLL_MEMIF_CLK0_MEMIF_PLL_CLK0_PHS_SHIFT				(20)

#define TCF_CR_PLL_MEMIF_CLK0_MEMIF_PLL_CLK0_MS_MASK				(0x00030000UL)
#define TCF_CR_PLL_MEMIF_CLK0_MEMIF_PLL_CLK0_MS_SHIFT				(16)

#define TCF_CR_PLL_MEMIF_CLK0_MEMIF_PLL_CLK0_FREQ_MASK				(0x000000FFUL)
#define TCF_CR_PLL_MEMIF_CLK0_MEMIF_PLL_CLK0_FREQ_SHIFT				(0)

/* Register TCF_CR_PLL_MEMIF_CLK1TO5 */
#define TCF_CR_PLL_MEMIF_CLK1TO5									(TCF_CR_PLL_OFFSET + 0x0080UL)
#define TCF_CR_PLL_MEMIF_CLK1TO5_DEFAULT							(0x00000000UL)

#define TCF_CR_PLL_MEMIF_CLK1TO5_MEMIF_PLL_CLK1TO5_PHS_MASK			(0x3FF00000UL)
#define TCF_CR_PLL_MEMIF_CLK1TO5_MEMIF_PLL_CLK1TO5_PHS_SHIFT		(20)

#define TCF_CR_PLL_MEMIF_CLK1TO5_MEMIF_PLL_CLK1TO5_MS_MASK			(0x000FFC00UL)
#define TCF_CR_PLL_MEMIF_CLK1TO5_MEMIF_PLL_CLK1TO5_MS_SHIFT			(10)

#define TCF_CR_PLL_MEMIF_CLK1TO5_MEMIF_PLL_CLK1TO5_FREQ_MASK		(0x000003FFUL)
#define TCF_CR_PLL_MEMIF_CLK1TO5_MEMIF_PLL_CLK1TO5_FREQ_SHIFT		(0)

/* Register TCF_CR_PLL_MEM_DRP_GO */
#define TCF_CR_PLL_MEM_DRP_GO										(TCF_CR_PLL_OFFSET + 0x0088UL)
#define TCF_CR_PLL_MEM_DRP_GO_DEFAULT								(0x00000000UL)

#define TCF_CR_PLL_MEM_DRP_GO_PLL_MEM_DRP_GO_MASK					(0x00000001UL)
#define TCF_CR_PLL_MEM_DRP_GO_PLL_MEM_DRP_GO_SHIFT					(0)

/* Register TCF_CR_PLL_ALL_DRP_GO */
#define TCF_CR_PLL_ALL_DRP_GO										(TCF_CR_PLL_OFFSET + 0x0090UL)
#define TCF_CR_PLL_ALL_DRP_GO_DEFAULT								(0x00000000UL)

#define TCF_CR_PLL_ALL_DRP_GO_PLL_ALL_DRP_GO_MASK					(0x00000001UL)
#define TCF_CR_PLL_ALL_DRP_GO_PLL_ALL_DRP_GO_SHIFT					(0)

/* Register TCF_CR_PLL_DRP_STATUS */
#define TCF_CR_PLL_DRP_STATUS										(TCF_CR_PLL_OFFSET + 0x0098UL)
#define TCF_CR_PLL_DRP_STATUS_DEFAULT								(0x00000000UL)

#define TCF_CR_PLL_DRP_STATUS_PLL_LOCKS_MASK						(0x00003F00UL)
#define TCF_CR_PLL_DRP_STATUS_PLL_LOCKS_SHIFT						(8)

#define TCF_CR_PLL_DRP_STATUS_PLL_DRP_GOOD_MASK						(0x0000003FUL)
#define TCF_CR_PLL_DRP_STATUS_PLL_DRP_GOOD_SHIFT					(0)

/* Register TCF_CR_PLL_DRP_STATUS */
#define TCF_CR_PLL_DRP_STATUS										(TCF_CR_PLL_OFFSET + 0x0098UL)
#define TCF_CR_PLL_DRP_STATUS_DEFAULT								(0x00000000UL)


/* PDP registers */
/* Register TCF_CR_PVR_TCF_RGBPDP_STR1SURF */
#define TCF_CR_PVR_TCF_RGBPDP_STR1SURF								(TCF_CR_PDP_OFFSET + 0x0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_STR1SURF_DEFAULT						(0x0E13F9DFUL)

#define TCF_CR_PVR_TCF_RGBPDP_STR1SURF_STR1PIXFMT_MASK				(0x0F000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_STR1SURF_STR1PIXFMT_SHIFT				(24)

#define TCF_CR_PVR_TCF_RGBPDP_STR1SURF_STR1WIDTH_MASK				(0x003FF800UL)
#define TCF_CR_PVR_TCF_RGBPDP_STR1SURF_STR1WIDTH_SHIFT				(11)

#define TCF_CR_PVR_TCF_RGBPDP_STR1SURF_STR1HEIGHT_MASK				(0x000007FFUL)
#define TCF_CR_PVR_TCF_RGBPDP_STR1SURF_STR1HEIGHT_SHIFT				(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_STR1ADDRCTRL */
#define TCF_CR_PVR_TCF_RGBPDP_STR1ADDRCTRL							(TCF_CR_PDP_OFFSET + 0x0004UL)
#define TCF_CR_PVR_TCF_RGBPDP_STR1ADDRCTRL_DEFAULT					(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_STR1ADDRCTRL_STR1STREN_MASK			(0x80000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_STR1ADDRCTRL_STR1STREN_SHIFT			(31)

#define TCF_CR_PVR_TCF_RGBPDP_STR1ADDRCTRL_STR1INTFIELD_MASK		(0x40000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_STR1ADDRCTRL_STR1INTFIELD_SHIFT		(30)

#define TCF_CR_PVR_TCF_RGBPDP_STR1ADDRCTRL_STR1BASE_MASK			(0x03FFFFFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_STR1ADDRCTRL_STR1BASE_SHIFT			(0)

/* Register TCF_CR_PVR_PDP_STR1POSN */
#define TCF_CR_PVR_PDP_STR1POSN										(TCF_CR_PDP_OFFSET + 0x0008UL)
#define TCF_CR_PVR_PDP_STR1POSN_DEFAULT								(0x0000009FUL)

#define TCF_CR_PVR_PDP_STR1POSN_STR1STRIDE_MASK						(0x000003FFUL)
#define TCF_CR_PVR_PDP_STR1POSN_STR1STRIDE_SHIFT					(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_MEMCTRL */
#define TCF_CR_PVR_TCF_RGBPDP_MEMCTRL								(TCF_CR_PDP_OFFSET + 0x000CUL)
#define TCF_CR_PVR_TCF_RGBPDP_MEMCTRL_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_MEMCTRL_MEMREFRESH_MASK				(0xC0000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_MEMCTRL_MEMREFRESH_SHIFT				(30)

/* Register TCF_CR_PVR_TCF_RGBPDP_STRCTRL */
#define TCF_CR_PVR_TCF_RGBPDP_STRCTRL								(TCF_CR_PDP_OFFSET + 0x0010UL)
#define TCF_CR_PVR_TCF_RGBPDP_STRCTRL_DEFAULT						(0x0000C010UL)

#define TCF_CR_PVR_TCF_RGBPDP_STRCTRL_THRESHOLD_GFX_MASK			(0x0000FF00UL)
#define TCF_CR_PVR_TCF_RGBPDP_STRCTRL_THRESHOLD_GFX_SHIFT			(8)

#define TCF_CR_PVR_TCF_RGBPDP_STRCTRL_BURSTLEN_GFX_MASK				(0x000000FFUL)
#define TCF_CR_PVR_TCF_RGBPDP_STRCTRL_BURSTLEN_GFX_SHIFT			(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL */
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL								(TCF_CR_PDP_OFFSET + 0x0014UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_DEFAULT						(0x00000A2AUL)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_SYNCACTIVE_MASK				(0x80000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_SYNCACTIVE_SHIFT				(31)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_DISP_RST_MASK				(0x20000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_DISP_RST_SHIFT				(29)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_POWERDN_MASK					(0x10000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_POWERDN_SHIFT				(28)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_UPDSYNCTRL_MASK				(0x04000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_UPDSYNCTRL_SHIFT				(26)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_UPDINTCTRL_MASK				(0x02000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_UPDINTCTRL_SHIFT				(25)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_UPDCTRL_MASK					(0x01000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_UPDCTRL_SHIFT				(24)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_UPDWAIT_MASK					(0x000F0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_UPDWAIT_SHIFT				(16)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_FIELD_EN_MASK				(0x00002000UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_FIELD_EN_SHIFT				(13)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_CSYNC_EN_MASK				(0x00001000UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_CSYNC_EN_SHIFT				(12)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_CLKPOL_MASK					(0x00000800UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_CLKPOL_SHIFT					(11)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_FIELDPOL_MASK				(0x00000200UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_FIELDPOL_SHIFT				(9)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_INTERLACE_MASK				(0x00000100UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_INTERLACE_SHIFT				(8)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_VS_SLAVE_MASK				(0x00000080UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_VS_SLAVE_SHIFT				(7)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_HS_SLAVE_MASK				(0x00000040UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_HS_SLAVE_SHIFT				(6)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_BLNKPOL_MASK					(0x00000020UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_BLNKPOL_SHIFT				(5)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_BLNKDIS_MASK					(0x00000010UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_BLNKDIS_SHIFT				(4)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_VSPOL_MASK					(0x00000008UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_VSPOL_SHIFT					(3)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_VSDIS_MASK					(0x00000004UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_VSDIS_SHIFT					(2)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_HSPOL_MASK					(0x00000002UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_HSPOL_SHIFT					(1)

#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_HSDIS_MASK					(0x00000001UL)
#define TCF_CR_PVR_TCF_RGBPDP_SYNCCTRL_HSDIS_SHIFT					(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_BORDCOL */
#define TCF_CR_PVR_TCF_RGBPDP_BORDCOL								(TCF_CR_PDP_OFFSET + 0x0018UL)
#define TCF_CR_PVR_TCF_RGBPDP_BORDCOL_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_BORDCOL_BORDCOL_MASK					(0x00FFFFFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_BORDCOL_BORDCOL_SHIFT					(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_UPDCTRL */
#define TCF_CR_PVR_TCF_RGBPDP_UPDCTRL								(TCF_CR_PDP_OFFSET + 0x001CUL)
#define TCF_CR_PVR_TCF_RGBPDP_UPDCTRL_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_UPDCTRL_UPDFIELD_MASK					(0x00000001UL)
#define TCF_CR_PVR_TCF_RGBPDP_UPDCTRL_UPDFIELD_SHIFT				(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_HSYNC1 */
#define TCF_CR_PVR_TCF_RGBPDP_HSYNC1								(TCF_CR_PDP_OFFSET + 0x0020UL)
#define TCF_CR_PVR_TCF_RGBPDP_HSYNC1_DEFAULT						(0x00400330UL)

#define TCF_CR_PVR_TCF_RGBPDP_HSYNC1_HBPS_MASK						(0x0FFF0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_HSYNC1_HBPS_SHIFT						(16)

#define TCF_CR_PVR_TCF_RGBPDP_HSYNC1_HT_MASK						(0x00000FFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_HSYNC1_HT_SHIFT						(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_HSYNC2 */
#define TCF_CR_PVR_TCF_RGBPDP_HSYNC2								(TCF_CR_PDP_OFFSET + 0x0024UL)
#define TCF_CR_PVR_TCF_RGBPDP_HSYNC2_DEFAULT						(0x00980098UL)

#define TCF_CR_PVR_TCF_RGBPDP_HSYNC2_HAS_MASK						(0x0FFF0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_HSYNC2_HAS_SHIFT						(16)

#define TCF_CR_PVR_TCF_RGBPDP_HSYNC2_HLBS_MASK						(0x00000FFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_HSYNC2_HLBS_SHIFT						(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_HSYNC3 */
#define TCF_CR_PVR_TCF_RGBPDP_HSYNC3								(TCF_CR_PDP_OFFSET + 0x0028UL)
#define TCF_CR_PVR_TCF_RGBPDP_HSYNC3_DEFAULT						(0x03180318UL)

#define TCF_CR_PVR_TCF_RGBPDP_HSYNC3_HFPS_MASK						(0x0FFF0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_HSYNC3_HFPS_SHIFT						(16)

#define TCF_CR_PVR_TCF_RGBPDP_HSYNC3_HRBS_MASK						(0x00000FFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_HSYNC3_HRBS_SHIFT						(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_VSYNC1 */
#define TCF_CR_PVR_TCF_RGBPDP_VSYNC1								(TCF_CR_PDP_OFFSET + 0x002CUL)
#define TCF_CR_PVR_TCF_RGBPDP_VSYNC1_DEFAULT						(0x000301F3UL)

#define TCF_CR_PVR_TCF_RGBPDP_VSYNC1_VBPS_MASK						(0x0FFF0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_VSYNC1_VBPS_SHIFT						(16)

#define TCF_CR_PVR_TCF_RGBPDP_VSYNC1_VT_MASK						(0x00000FFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_VSYNC1_VT_SHIFT						(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_VSYNC2 */
#define TCF_CR_PVR_TCF_RGBPDP_VSYNC2								(TCF_CR_PDP_OFFSET + 0x0030UL)
#define TCF_CR_PVR_TCF_RGBPDP_VSYNC2_DEFAULT						(0x00120012UL)

#define TCF_CR_PVR_TCF_RGBPDP_VSYNC2_VAS_MASK						(0x0FFF0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_VSYNC2_VAS_SHIFT						(16)

#define TCF_CR_PVR_TCF_RGBPDP_VSYNC2_VTBS_MASK						(0x00000FFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_VSYNC2_VTBS_SHIFT						(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_VSYNC3 */
#define TCF_CR_PVR_TCF_RGBPDP_VSYNC3								(TCF_CR_PDP_OFFSET + 0x0034UL)
#define TCF_CR_PVR_TCF_RGBPDP_VSYNC3_DEFAULT						(0x01F201F2UL)

#define TCF_CR_PVR_TCF_RGBPDP_VSYNC3_VFPS_MASK						(0x0FFF0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_VSYNC3_VFPS_SHIFT						(16)

#define TCF_CR_PVR_TCF_RGBPDP_VSYNC3_VBBS_MASK						(0x00000FFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_VSYNC3_VBBS_SHIFT						(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_HDECTRL */
#define TCF_CR_PVR_TCF_RGBPDP_HDECTRL								(TCF_CR_PDP_OFFSET + 0x0038UL)
#define TCF_CR_PVR_TCF_RGBPDP_HDECTRL_DEFAULT						(0x00980318UL)

#define TCF_CR_PVR_TCF_RGBPDP_HDECTRL_HDES_MASK						(0x0FFF0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_HDECTRL_HDES_SHIFT					(16)

#define TCF_CR_PVR_TCF_RGBPDP_HDECTRL_HDEF_MASK						(0x00000FFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_HDECTRL_HDEF_SHIFT					(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_VDECTRL */
#define TCF_CR_PVR_TCF_RGBPDP_VDECTRL								(TCF_CR_PDP_OFFSET + 0x003CUL)
#define TCF_CR_PVR_TCF_RGBPDP_VDECTRL_DEFAULT						(0x001201F2UL)

#define TCF_CR_PVR_TCF_RGBPDP_VDECTRL_VDES_MASK						(0x0FFF0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_VDECTRL_VDES_SHIFT					(16)

#define TCF_CR_PVR_TCF_RGBPDP_VDECTRL_VDEF_MASK						(0x00000FFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_VDECTRL_VDEF_SHIFT					(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_VEVENT */
#define TCF_CR_PVR_TCF_RGBPDP_VEVENT								(TCF_CR_PDP_OFFSET + 0x0040UL)
#define TCF_CR_PVR_TCF_RGBPDP_VEVENT_DEFAULT						(0x01F80006UL)

#define TCF_CR_PVR_TCF_RGBPDP_VEVENT_VEVENT_MASK					(0x0FFF0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_VEVENT_VEVENT_SHIFT					(16)

#define TCF_CR_PVR_TCF_RGBPDP_VEVENT_VFETCH_MASK					(0x00000FFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_VEVENT_VFETCH_SHIFT					(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_OPMASK */
#define TCF_CR_PVR_TCF_RGBPDP_OPMASK								(TCF_CR_PDP_OFFSET + 0x0044UL)
#define TCF_CR_PVR_TCF_RGBPDP_OPMASK_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_OPMASK_MASKLEVEL_MASK					(0x80000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_OPMASK_MASKLEVEL_SHIFT				(31)

#define TCF_CR_PVR_TCF_RGBPDP_OPMASK_BLANKLEVEL_MASK				(0x40000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_OPMASK_BLANKLEVEL_SHIFT				(30)

#define TCF_CR_PVR_TCF_RGBPDP_OPMASK_MASKB_MASK						(0x00FF0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_OPMASK_MASKB_SHIFT					(16)

#define TCF_CR_PVR_TCF_RGBPDP_OPMASK_MASKG_MASK						(0x0000FF00UL)
#define TCF_CR_PVR_TCF_RGBPDP_OPMASK_MASKG_SHIFT					(8)

#define TCF_CR_PVR_TCF_RGBPDP_OPMASK_MASKR_MASK						(0x000000FFUL)
#define TCF_CR_PVR_TCF_RGBPDP_OPMASK_MASKR_SHIFT					(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_INTSTAT */
#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT								(TCF_CR_PDP_OFFSET + 0x0048UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_DISPURUN_MASK			(0x00000040UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_DISPURUN_SHIFT			(6)

#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_STR1ORUN_MASK			(0x00000020UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_STR1ORUN_SHIFT			(5)

#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_STR1URUN_MASK			(0x00000010UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_STR1URUN_SHIFT			(4)

#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_VBLNK1_MASK				(0x00000008UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_VBLNK1_SHIFT				(3)

#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_VBLNK0_MASK				(0x00000004UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_VBLNK0_SHIFT				(2)

#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_HBLNK1_MASK				(0x00000002UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_HBLNK1_SHIFT				(1)

#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_HBLNK0_MASK				(0x00000001UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTSTAT_INTS_HBLNK0_SHIFT				(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_INTENAB */
#define TCF_CR_PVR_TCF_RGBPDP_INTENAB								(TCF_CR_PDP_OFFSET + 0x004CUL)
#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_DISPURUN_MASK			(0x00000040UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_DISPURUN_SHIFT			(6)

#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_STR1ORUN_MASK			(0x00000020UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_STR1ORUN_SHIFT			(5)

#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_STR1URUN_MASK			(0x00000010UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_STR1URUN_SHIFT			(4)

#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_VBLNK1_MASK				(0x00000008UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_VBLNK1_SHIFT			(3)

#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_VBLNK0_MASK				(0x00000004UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_VBLNK0_SHIFT			(2)

#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_HBLNK1_MASK				(0x00000002UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_HBLNK1_SHIFT			(1)

#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_HBLNK0_MASK				(0x00000001UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTENAB_INTEN_HBLNK0_SHIFT			(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_INTCLEAR */
#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR								(TCF_CR_PDP_OFFSET + 0x0050UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_DISPURUN_MASK			(0x00000040UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_DISPURUN_SHIFT		(6)

#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_STR1ORUN_MASK			(0x00000020UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_STR1ORUN_SHIFT		(5)

#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_STR1URUN_MASK			(0x00000010UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_STR1URUN_SHIFT		(4)

#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_VBLNK1_MASK			(0x00000008UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_VBLNK1_SHIFT			(3)

#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_VBLNK0_MASK			(0x00000004UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_VBLNK0_SHIFT			(2)

#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_HBLNK1_MASK			(0x00000002UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_HBLNK1_SHIFT			(1)

#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_HBLNK0_MASK			(0x00000001UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTCLEAR_INTCLR_HBLNK0_SHIFT			(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_INTCTRL */
#define TCF_CR_PVR_TCF_RGBPDP_INTCTRL								(TCF_CR_PDP_OFFSET + 0x0054UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTCTRL_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_INTCTRL_HBLNK_LINE_MASK				(0x00010000UL)
#define TCF_CR_PVR_TCF_RGBPDP_INTCTRL_HBLNK_LINE_SHIFT				(16)

#define TCF_CR_PVR_TCF_RGBPDP_INTCTRL_HBLNK_LINENO_MASK				(0x00000FFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_INTCTRL_HBLNK_LINENO_SHIFT			(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_SIGNAT */
#define TCF_CR_PVR_TCF_RGBPDP_SIGNAT								(TCF_CR_PDP_OFFSET + 0x0058UL)
#define TCF_CR_PVR_TCF_RGBPDP_SIGNAT_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_SIGNAT_SIGNATURE_MASK					(0xFFFFFFFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_SIGNAT_SIGNATURE_SHIFT				(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_LINESTAT */
#define TCF_CR_PVR_TCF_RGBPDP_LINESTAT								(TCF_CR_PDP_OFFSET + 0x005CUL)
#define TCF_CR_PVR_TCF_RGBPDP_LINESTAT_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_LINESTAT_LINENO_MASK					(0x00000FFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_LINESTAT_LINENO_SHIFT					(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_DBGCTRL */
#define TCF_CR_PVR_TCF_RGBPDP_DBGCTRL								(TCF_CR_PDP_OFFSET + 0x0060UL)
#define TCF_CR_PVR_TCF_RGBPDP_DBGCTRL_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_DBGCTRL_DBG_READ_MASK					(0x00000002UL)
#define TCF_CR_PVR_TCF_RGBPDP_DBGCTRL_DBG_READ_SHIFT				(1)

#define TCF_CR_PVR_TCF_RGBPDP_DBGCTRL_DBG_ENAB_MASK					(0x00000001UL)
#define TCF_CR_PVR_TCF_RGBPDP_DBGCTRL_DBG_ENAB_SHIFT				(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_DBGDATA */
#define TCF_CR_PVR_TCF_RGBPDP_DBGDATA								(TCF_CR_PDP_OFFSET + 0x0064UL)
#define TCF_CR_PVR_TCF_RGBPDP_DBGDATA_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_DBGDATA_DBG_DATA_MASK					(0x00FFFFFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_DBGDATA_DBG_DATA_SHIFT				(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_DBGSIDE */
#define TCF_CR_PVR_TCF_RGBPDP_DBGSIDE								(TCF_CR_PDP_OFFSET + 0x0068UL)
#define TCF_CR_PVR_TCF_RGBPDP_DBGSIDE_DEFAULT						(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_DBGSIDE_DBG_VAL_MASK					(0x00000008UL)
#define TCF_CR_PVR_TCF_RGBPDP_DBGSIDE_DBG_VAL_SHIFT					(3)

#define TCF_CR_PVR_TCF_RGBPDP_DBGSIDE_DBG_SIDE_MASK					(0x00000007UL)
#define TCF_CR_PVR_TCF_RGBPDP_DBGSIDE_DBG_SIDE_SHIFT				(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_REGLD_STAT */
#define TCF_CR_PVR_TCF_RGBPDP_REGLD_STAT							(TCF_CR_PDP_OFFSET + 0x0070UL)
#define TCF_CR_PVR_TCF_RGBPDP_REGLD_STAT_DEFAULT					(0x80000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_REGLD_STAT_REGLD_ADDREN_MASK			(0x80000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_REGLD_STAT_REGLD_ADDREN_SHIFT			(31)

#define TCF_CR_PVR_TCF_RGBPDP_REGLD_STAT_REGLD_ADDROUT_MASK			(0x00FFFFFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_REGLD_STAT_REGLD_ADDROUT_SHIFT		(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_REGLD_CTRL */
#define TCF_CR_PVR_TCF_RGBPDP_REGLD_CTRL							(TCF_CR_PDP_OFFSET + 0x0074UL)
#define TCF_CR_PVR_TCF_RGBPDP_REGLD_CTRL_DEFAULT					(0x00000000UL)

#define TCF_CR_PVR_TCF_RGBPDP_REGLD_CTRL_REGLD_ADDRLEN_MASK			(0xFE000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_REGLD_CTRL_REGLD_ADDRLEN_SHIFT		(25)

#define TCF_CR_PVR_TCF_RGBPDP_REGLD_CTRL_REGLD_VAL_MASK				(0x01000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_REGLD_CTRL_REGLD_VAL_SHIFT			(24)

#define TCF_CR_PVR_TCF_RGBPDP_REGLD_CTRL_REGLD_ADDRIN_MASK			(0x00FFFFFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_REGLD_CTRL_REGLD_ADDRIN_SHIFT			(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_CORE_ID */
#define TCF_CR_PVR_TCF_RGBPDP_CORE_ID								(TCF_CR_PDP_OFFSET + 0x0078UL)
#define TCF_CR_PVR_TCF_RGBPDP_CORE_ID_DEFAULT						(0x07010009UL)

#define TCF_CR_PVR_TCF_RGBPDP_CORE_ID_GROUP_ID_MASK					(0xFF000000UL)
#define TCF_CR_PVR_TCF_RGBPDP_CORE_ID_GROUP_ID_SHIFT				(24)

#define TCF_CR_PVR_TCF_RGBPDP_CORE_ID_CORE_ID_MASK					(0x00FF0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_CORE_ID_CORE_ID_SHIFT					(16)

#define TCF_CR_PVR_TCF_RGBPDP_CORE_ID_CONFIG_ID_MASK				(0x0000FFFFUL)
#define TCF_CR_PVR_TCF_RGBPDP_CORE_ID_CONFIG_ID_SHIFT				(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_CORE_REV */
#define TCF_CR_PVR_TCF_RGBPDP_CORE_REV								(TCF_CR_PDP_OFFSET + 0x007CUL)
#define TCF_CR_PVR_TCF_RGBPDP_CORE_REV_DEFAULT						(0x00010000UL)

#define TCF_CR_PVR_TCF_RGBPDP_CORE_REV_MAJOR_REV_MASK				(0x00FF0000UL)
#define TCF_CR_PVR_TCF_RGBPDP_CORE_REV_MAJOR_REV_SHIFT				(16)

#define TCF_CR_PVR_TCF_RGBPDP_CORE_REV_MINOR_REV_MASK				(0x0000FF00UL)
#define TCF_CR_PVR_TCF_RGBPDP_CORE_REV_MINOR_REV_SHIFT				(8)

#define TCF_CR_PVR_TCF_RGBPDP_CORE_REV_MAINT_REV_MASK				(0x000000FFUL)
#define TCF_CR_PVR_TCF_RGBPDP_CORE_REV_MAINT_REV_SHIFT				(0)

/* Register TCF_CR_PVR_TCF_RGBPDP_CORE_REV */
#define TCF_CR_PVR_TCF_RGBPDP_CORE_REV								(TCF_CR_PDP_OFFSET + 0x007CUL)
#define TCF_CR_PVR_TCF_RGBPDP_CORE_REV_DEFAULT						(0x00010000UL)


#endif /* _APOLLO_TCFDEFS_H_ */

/******************************************************************************
 End of file (tcfdefs.h)
******************************************************************************/

