/*
 * Copyright (C) 2018 "IoT.bzh"
 * Author Jonathan Aillet <jonathan.aillet@iot.bzh>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _HAL_UTILITIES_DATA_INCLUDE_
#define _HAL_UTILITIES_DATA_INCLUDE_

#include <stdio.h>

#include <wrap-json.h>

#include <afb/afb-binding.h>

#include <ctl-config.h>

#include "4a-hal-utilities-alsa-data.h"

#define HAL_STREAM_UPDATES_EVENT_NAME		"stream-updates"

// Enum for sharing hal (controller or external) status
enum HalStatus {
	HAL_STATUS_UNAVAILABLE=0,
	HAL_STATUS_AVAILABLE=1,
	HAL_STATUS_READY=2
};

// Structure to store stream data
struct CtlHalMixerData {
	char *verb;
	char *verbToCall;
	char *streamCardId;
	afb_event_t event;

	struct CtlHalMixerData *next;
};

// Structure to store specific controller hal data
struct CtlHalSpecificData {
	char *mixerApiName;
	char *prefix;
	json_object *halMixerJ;

	struct CtlHalMixerData *ctlHalStreamsData;
	afb_event_t streamUpdates;

	struct CtlHalMixerData *ctlHalPlaybacksData;
	struct CtlHalMixerData *ctlHalCapturesData;

	struct CtlHalAlsaMapT *ctlHalAlsaMapT;

	afb_api_t apiHandle;
	CtlConfigT *ctrlConfig;
};

// Structure to store specific hal (controller or external) data
struct SpecificHalData {
	char *apiName;
	enum HalStatus status;
	char *sndCardPath;
	int sndCardId;
	char *info;
	unsigned int internal;

	char *author;
	char *version;
	char *date;
	// Can be beefed up if needed

	struct CtlHalSpecificData *ctlHalSpecificData;		// Can be NULL if external api

	struct SpecificHalData *next;
};

// Structure to store hal manager data
struct HalMgrData {
	char *apiName;
	char *info;

	afb_api_t apiHandle;

	struct SpecificHalData *first;
};

// Specfic Hal controller streams data handling functions
struct CtlHalMixerData *HalUtlAddMixerDataToMixerDataList(struct CtlHalMixerData **firstMixerData);
int8_t HalUtlRemoveSelectedMixerData(struct CtlHalMixerData **firstMixerData, struct CtlHalMixerData *mixerDataToRemove);
int64_t HalUtlRemoveAllMixerData(struct CtlHalMixerData **firstMixerData);
int64_t HalUtlGetNumberOfMixerDataInList(struct CtlHalMixerData **firstMixerData);
struct CtlHalMixerData *HalUtlSearchMixerDataByProperties(struct CtlHalMixerData **firstMixerData, char *verb, char *verbToCall, char *streamCardId);

// Exported verbs for 'struct SpecificHalData' handling
struct SpecificHalData *HalUtlAddHalApiToHalList(struct SpecificHalData **firstHalData);
int8_t HalUtlRemoveSelectedHalFromList(struct SpecificHalData **firstHalData, struct SpecificHalData *ApiToRemove);
int64_t HalUtlRemoveAllHalFromList(struct SpecificHalData **firstHalData);
int64_t HalUtlGetNumberOfHalInList(struct SpecificHalData **firstHalData);
struct SpecificHalData *HalUtlSearchHalDataByApiName(struct SpecificHalData **firstHalData, char *apiName);
struct SpecificHalData *HalUtlSearchReadyHalDataByCarId(struct SpecificHalData **firstHalData, int cardId);

// Exported verbs for 'struct HalMgrData' handling
uint8_t HalUtlInitializeHalMgrData(afb_api_t apiHandle, struct HalMgrData *HalMgrGlobalData, char *apiName, char *info);
void HalUtlRemoveHalMgrData(struct HalMgrData *HalMgrGlobalData);

#endif /* _HAL_UTILITIES_DATA_INCLUDE_ */