#ifndef __INC_ALSA_TRANSACTION_H
#define __INC_ALSA_TRANSACTION_H

#include <urcu/list.h>
#include <stdbool.h>

#include "afb-definitions.h"

struct SoftMixerT_;

typedef void (*AlsaTransactionDestructor) (struct SoftMixerT_ *, void*);

typedef struct {
	const char * uid;
	struct SoftMixerT_*  mixer;
	struct cds_list_head item_list; // list of items
	struct cds_list_head transaction_node; // node in a list of transactions
} AlsaMixerTransaction;

typedef struct {
	struct cds_list_head list_entry;
	void * object;
	AlsaTransactionDestructor destructor;
} AlsaMixerTransactionDataItem;

extern AlsaMixerTransaction * AlsaMixerTransactionNew(struct SoftMixerT_ * api, const char*);

extern void AlsaMixerTransactionDelete(AlsaMixerTransaction * transaction);

extern void AlsaMixerTransactionDataListDestroy(AlsaMixerTransaction*);

extern bool AlsaMixerTransactionObjectAdd(AlsaMixerTransaction*, void * object, AlsaTransactionDestructor destructor);
extern bool AlsaMixerTransactionObjectAddTail(AlsaMixerTransaction* list, void* object, AlsaTransactionDestructor destructor);

extern void AlsaMixerTransactionObjectDelete(AlsaMixerTransaction* list, void * object, bool destructor);

extern bool AlsaMixerTransactionVerbCreate(AlsaMixerTransaction*);

extern void AlsaMixerTransactionVerbCB(AFB_ReqT request);

#endif /* __INC_ALSA_TRANSACTION_H */
