# Test Framework functions

* **_AFT.addEventToMonitor(eventName, callback)**

    Add a binding event in the test framework to be able to assert its reception
    . You'll need to add as much as events you expect to receive. You could also
    specify a callback to test deeper that the event is as you want to. The
    callback will happens after the assertion that it has been received so you
    can work on data that the event eventually carry.

* **_AFT.setJunitFile(filePath)**

    Set the *JUnit* file path. When *JUnit* is set as the output type for the
    test framework.

* **_AFT.setBeforeEach(function)**

    Set the **_AFT.beforeEach()** function which is used to run the *function*
    before each tests.

* **_AFT.setAfterEach(function)**

    Set the **_AFT.afterEach()** function which is used to run the *function*
    after each tests.

* **_AFT.setBeforeAll(function)**

    Set the **_AFT.beforeAll()** function which is used to run the *function*
    before all tests. If the given function is successful it has to return 0
    else it will return an error.

* **_AFT.setAfterAll(function)**

    Set the **_AFT.afterAll()** function which is used to run the *function*
    after all tests. If the given function is successful it has to return 0
    else it will return an error.

* **_AFT.describe(testName, testFunction, setUp, tearDown)**

    Give a context to a custom test. *testFunction* will be given the name
    provided by *testName* and will be tested.

    *setUp* and *tearDown* are functions that can be added to your context,
    it works just like  **_AFT.beforeEach()** and **_AFT.afterEach()**,
    *setUp* will be ran before your *testFunction* and **_AFT.beforeEach()**
    (if set) functions, *tearDown* will be ran after your *testFunction* and
    **_AFT.afterEach()**  (if set) functions.

* **_AFT.setBefore(testName, beforeTestFunction)**
    Set a function to be ran at the beginning of the given *testName* function.

    ```lua
    _AFT.testVerbStatusSuccess('testPingSuccess','hello', 'ping', {})
    _AFT.setBefore("testPingSuccess",function() print("~~~~~ Begin testPingSuccess ~~~~~") end)
    _AFT.setAfter("testPingSuccess",function() print("~~~~~ End testPingSuccess ~~~~~") end)
    ```

* **_AFT.setBefore(testName, beforeTestFunction)**
    Set a function to be ran at the end of the given *testName* function.