# HALs

HALs are known as json files in 4a, they are stored in
**/usr/libexec/agl/4a-hal**.

Enabled HALs can be found in the **etc** subfolder, and disabled HALs in
**etc.available**.

You can enable and disable HALs just by moving the corresponding json file from
one folder to the other.

Example:

```bash
user@machine$ ls etc etc.available/
etc:
hal-4a-csl-cm106-8ch-usb.json

etc.available/:
hal-4a-2ch-generic-usb.json  hal-4a-intel.json
hal-4a-ensoniq.json          hal-4a-jabra.json
hal-4a-intel-minnow.json     hal-4a-rcar-m3.json
hal-4a-intel-qemu.json       hal-4a-rcar-m3kf.json

user@machine$ mv etc/hal-4a-csl-cm106-8ch-usb.json  etc.available
user@machine$ mv etc.available/hal-4a-2ch-generic-usb.json etc

user@machine$ ls etc etc.available/
etc:
hal-4a-2ch-generic-usb.json

etc.available/:
hal-4a-csl-cm106-8ch-usb.json  hal-4a-intel.json
hal-4a-ensoniq.json            hal-4a-jabra.json
hal-4a-intel-minnow.json       hal-4a-rcar-m3.json
hal-4a-intel-qemu.json         hal-4a-rcar-m3kf.json

user@machine$ sync
user@machine$ reboot
```

>NOTE: Even if multiple HAL are allowed, you have to make sure that they don't
>provide the same streams, because it will cause a race condition in the high
>level API. The first HAL providing the stream is used, any other are ignored.
>
>Also, the hardware used by enabled HALs should be available.
