; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 -print-schedule      | FileCheck %s --check-prefix=CHECK --check-prefix=SSE --check-prefix=SSE-RECIP
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx -print-schedule       | FileCheck %s --check-prefix=CHECK --check-prefix=AVX --check-prefix=AVX-RECIP
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx,+fma -print-schedule  | FileCheck %s --check-prefix=CHECK --check-prefix=AVX --check-prefix=FMA-RECIP
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=btver2 -print-schedule      | FileCheck %s --check-prefix=CHECK --check-prefix=AVX --check-prefix=BTVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=sandybridge -print-schedule | FileCheck %s --check-prefix=CHECK --check-prefix=AVX --check-prefix=SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=haswell -print-schedule     | FileCheck %s --check-prefix=CHECK --check-prefix=AVX --check-prefix=HASWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=haswell -print-schedule -mattr=-fma | FileCheck %s --check-prefix=CHECK --check-prefix=AVX --check-prefix=HASWELL-NO-FMA
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=knl -print-schedule         | FileCheck %s --check-prefix=CHECK --check-prefix=AVX --check-prefix=AVX512 --check-prefix=KNL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=skx -print-schedule         | FileCheck %s --check-prefix=CHECK --check-prefix=AVX --check-prefix=AVX512 --check-prefix=SKX

; It's the extra tests coverage for recip as discussed on D26855.

define float @f32_no_step_2(float %x) #3 {
; SSE-LABEL: f32_no_step_2:
; SSE:       # BB#0:
; SSE-NEXT:    rcpss %xmm0, %xmm0
; SSE-NEXT:    mulss {{.*}}(%rip), %xmm0
; SSE-NEXT:    retq
;
; AVX-RECIP-LABEL: f32_no_step_2:
; AVX-RECIP:       # BB#0:
; AVX-RECIP-NEXT:    vrcpss %xmm0, %xmm0, %xmm0
; AVX-RECIP-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0
; AVX-RECIP-NEXT:    retq
;
; FMA-RECIP-LABEL: f32_no_step_2:
; FMA-RECIP:       # BB#0:
; FMA-RECIP-NEXT:    vrcpss %xmm0, %xmm0, %xmm0
; FMA-RECIP-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0
; FMA-RECIP-NEXT:    retq
;
; BTVER2-LABEL: f32_no_step_2:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: f32_no_step_2:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: f32_no_step_2:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-NO-FMA-LABEL: f32_no_step_2:
; HASWELL-NO-FMA:       # BB#0:
; HASWELL-NO-FMA-NEXT:    vrcpss %xmm0, %xmm0, %xmm0 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; HASWELL-NO-FMA-NEXT:    retq # sched: [1:1.00]
;
; AVX512-LABEL: f32_no_step_2:
; AVX512:       # BB#0:
; AVX512-NEXT:    vrcp14ss %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; AVX512-NEXT:    retq # sched: [1:1.00]
  %div = fdiv fast float 1234.0, %x
  ret float %div
}

define float @f32_one_step_2(float %x) #1 {
; SSE-LABEL: f32_one_step_2:
; SSE:       # BB#0:
; SSE-NEXT:    rcpss %xmm0, %xmm2
; SSE-NEXT:    mulss %xmm2, %xmm0
; SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    subss %xmm0, %xmm1
; SSE-NEXT:    mulss %xmm2, %xmm1
; SSE-NEXT:    addss %xmm2, %xmm1
; SSE-NEXT:    mulss {{.*}}(%rip), %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-RECIP-LABEL: f32_one_step_2:
; AVX-RECIP:       # BB#0:
; AVX-RECIP-NEXT:    vrcpss %xmm0, %xmm0, %xmm1
; AVX-RECIP-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; AVX-RECIP-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX-RECIP-NEXT:    vsubss %xmm0, %xmm2, %xmm0
; AVX-RECIP-NEXT:    vmulss %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    vaddss %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0
; AVX-RECIP-NEXT:    retq
;
; FMA-RECIP-LABEL: f32_one_step_2:
; FMA-RECIP:       # BB#0:
; FMA-RECIP-NEXT:    vrcpss %xmm0, %xmm0, %xmm1
; FMA-RECIP-NEXT:    vfnmadd213ss {{.*}}(%rip), %xmm1, %xmm0
; FMA-RECIP-NEXT:    vfmadd132ss %xmm1, %xmm1, %xmm0
; FMA-RECIP-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0
; FMA-RECIP-NEXT:    retq
;
; BTVER2-LABEL: f32_one_step_2:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-NEXT:    vrcpss %xmm0, %xmm0, %xmm1 # sched: [2:1.00]
; BTVER2-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vsubss %xmm0, %xmm2, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vaddss %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: f32_one_step_2:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpss %xmm0, %xmm0, %xmm1 # sched: [5:1.00]
; SANDY-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-NEXT:    vsubss %xmm0, %xmm2, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vaddss %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: f32_one_step_2:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpss %xmm0, %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-NEXT:    vfnmadd213ss {{.*}}(%rip), %xmm1, %xmm0
; HASWELL-NEXT:    vfmadd132ss %xmm1, %xmm1, %xmm0
; HASWELL-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-NO-FMA-LABEL: f32_one_step_2:
; HASWELL-NO-FMA:       # BB#0:
; HASWELL-NO-FMA-NEXT:    vrcpss %xmm0, %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero sched: [4:0.50]
; HASWELL-NO-FMA-NEXT:    vsubss %xmm0, %xmm2, %xmm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vaddss %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; HASWELL-NO-FMA-NEXT:    retq # sched: [1:1.00]
;
; AVX512-LABEL: f32_one_step_2:
; AVX512:       # BB#0:
; AVX512-NEXT:    vrcp14ss %xmm0, %xmm0, %xmm1
; AVX512-NEXT:    vfnmadd213ss {{.*}}(%rip), %xmm1, %xmm0
; AVX512-NEXT:    vfmadd132ss %xmm1, %xmm1, %xmm0
; AVX512-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; AVX512-NEXT:    retq # sched: [1:1.00]
  %div = fdiv fast float 3456.0, %x
  ret float %div
}

define float @f32_one_step_2_divs(float %x) #1 {
; SSE-LABEL: f32_one_step_2_divs:
; SSE:       # BB#0:
; SSE-NEXT:    rcpss %xmm0, %xmm1
; SSE-NEXT:    mulss %xmm1, %xmm0
; SSE-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE-NEXT:    subss %xmm0, %xmm2
; SSE-NEXT:    mulss %xmm1, %xmm2
; SSE-NEXT:    addss %xmm1, %xmm2
; SSE-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE-NEXT:    mulss %xmm2, %xmm0
; SSE-NEXT:    mulss %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-RECIP-LABEL: f32_one_step_2_divs:
; AVX-RECIP:       # BB#0:
; AVX-RECIP-NEXT:    vrcpss %xmm0, %xmm0, %xmm1
; AVX-RECIP-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; AVX-RECIP-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX-RECIP-NEXT:    vsubss %xmm0, %xmm2, %xmm0
; AVX-RECIP-NEXT:    vmulss %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    vaddss %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm1
; AVX-RECIP-NEXT:    vmulss %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    retq
;
; FMA-RECIP-LABEL: f32_one_step_2_divs:
; FMA-RECIP:       # BB#0:
; FMA-RECIP-NEXT:    vrcpss %xmm0, %xmm0, %xmm1
; FMA-RECIP-NEXT:    vfnmadd213ss {{.*}}(%rip), %xmm1, %xmm0
; FMA-RECIP-NEXT:    vfmadd132ss %xmm1, %xmm1, %xmm0
; FMA-RECIP-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm1
; FMA-RECIP-NEXT:    vmulss %xmm0, %xmm1, %xmm0
; FMA-RECIP-NEXT:    retq
;
; BTVER2-LABEL: f32_one_step_2_divs:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-NEXT:    vrcpss %xmm0, %xmm0, %xmm1 # sched: [2:1.00]
; BTVER2-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vsubss %xmm0, %xmm2, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vaddss %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm1 # sched: [7:1.00]
; BTVER2-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: f32_one_step_2_divs:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpss %xmm0, %xmm0, %xmm1 # sched: [5:1.00]
; SANDY-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-NEXT:    vsubss %xmm0, %xmm2, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vaddss %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm1 # sched: [11:1.00]
; SANDY-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: f32_one_step_2_divs:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpss %xmm0, %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-NEXT:    vfnmadd213ss {{.*}}(%rip), %xmm1, %xmm0
; HASWELL-NEXT:    vfmadd132ss %xmm1, %xmm1, %xmm0
; HASWELL-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm1 # sched: [9:0.50]
; HASWELL-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-NO-FMA-LABEL: f32_one_step_2_divs:
; HASWELL-NO-FMA:       # BB#0:
; HASWELL-NO-FMA-NEXT:    vrcpss %xmm0, %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero sched: [4:0.50]
; HASWELL-NO-FMA-NEXT:    vsubss %xmm0, %xmm2, %xmm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vaddss %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm1 # sched: [9:0.50]
; HASWELL-NO-FMA-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    retq # sched: [1:1.00]
;
; AVX512-LABEL: f32_one_step_2_divs:
; AVX512:       # BB#0:
; AVX512-NEXT:    vrcp14ss %xmm0, %xmm0, %xmm1
; AVX512-NEXT:    vfnmadd213ss {{.*}}(%rip), %xmm1, %xmm0
; AVX512-NEXT:    vfmadd132ss %xmm1, %xmm1, %xmm0
; AVX512-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm1 # sched: [9:0.50]
; AVX512-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; AVX512-NEXT:    retq # sched: [1:1.00]
  %div = fdiv fast float 3456.0, %x
  %div2 = fdiv fast float %div, %x
  ret float %div2
}

define float @f32_two_step_2(float %x) #2 {
; SSE-LABEL: f32_two_step_2:
; SSE:       # BB#0:
; SSE-NEXT:    rcpss %xmm0, %xmm2
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    mulss %xmm2, %xmm3
; SSE-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    subss %xmm3, %xmm4
; SSE-NEXT:    mulss %xmm2, %xmm4
; SSE-NEXT:    addss %xmm2, %xmm4
; SSE-NEXT:    mulss %xmm4, %xmm0
; SSE-NEXT:    subss %xmm0, %xmm1
; SSE-NEXT:    mulss %xmm4, %xmm1
; SSE-NEXT:    addss %xmm4, %xmm1
; SSE-NEXT:    mulss {{.*}}(%rip), %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-RECIP-LABEL: f32_two_step_2:
; AVX-RECIP:       # BB#0:
; AVX-RECIP-NEXT:    vrcpss %xmm0, %xmm0, %xmm1
; AVX-RECIP-NEXT:    vmulss %xmm1, %xmm0, %xmm2
; AVX-RECIP-NEXT:    vmovss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; AVX-RECIP-NEXT:    vsubss %xmm2, %xmm3, %xmm2
; AVX-RECIP-NEXT:    vmulss %xmm2, %xmm1, %xmm2
; AVX-RECIP-NEXT:    vaddss %xmm2, %xmm1, %xmm1
; AVX-RECIP-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; AVX-RECIP-NEXT:    vsubss %xmm0, %xmm3, %xmm0
; AVX-RECIP-NEXT:    vmulss %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    vaddss %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0
; AVX-RECIP-NEXT:    retq
;
; FMA-RECIP-LABEL: f32_two_step_2:
; FMA-RECIP:       # BB#0:
; FMA-RECIP-NEXT:    vrcpss %xmm0, %xmm0, %xmm1
; FMA-RECIP-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; FMA-RECIP-NEXT:    vmovaps %xmm1, %xmm3
; FMA-RECIP-NEXT:    vfnmadd213ss %xmm2, %xmm0, %xmm3
; FMA-RECIP-NEXT:    vfmadd132ss %xmm1, %xmm1, %xmm3
; FMA-RECIP-NEXT:    vfnmadd213ss %xmm2, %xmm3, %xmm0
; FMA-RECIP-NEXT:    vfmadd132ss %xmm3, %xmm3, %xmm0
; FMA-RECIP-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0
; FMA-RECIP-NEXT:    retq
;
; BTVER2-LABEL: f32_two_step_2:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovss {{.*#+}} xmm3 = mem[0],zero,zero,zero sched: [5:1.00]
; BTVER2-NEXT:    vrcpss %xmm0, %xmm0, %xmm1 # sched: [2:1.00]
; BTVER2-NEXT:    vmulss %xmm1, %xmm0, %xmm2 # sched: [2:1.00]
; BTVER2-NEXT:    vsubss %xmm2, %xmm3, %xmm2 # sched: [3:1.00]
; BTVER2-NEXT:    vmulss %xmm2, %xmm1, %xmm2 # sched: [2:1.00]
; BTVER2-NEXT:    vaddss %xmm2, %xmm1, %xmm1 # sched: [3:1.00]
; BTVER2-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vsubss %xmm0, %xmm3, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vaddss %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: f32_two_step_2:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpss %xmm0, %xmm0, %xmm1 # sched: [5:1.00]
; SANDY-NEXT:    vmulss %xmm1, %xmm0, %xmm2 # sched: [5:1.00]
; SANDY-NEXT:    vmovss {{.*#+}} xmm3 = mem[0],zero,zero,zero sched: [6:0.50]
; SANDY-NEXT:    vsubss %xmm2, %xmm3, %xmm2 # sched: [3:1.00]
; SANDY-NEXT:    vmulss %xmm2, %xmm1, %xmm2 # sched: [5:1.00]
; SANDY-NEXT:    vaddss %xmm2, %xmm1, %xmm1 # sched: [3:1.00]
; SANDY-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vsubss %xmm0, %xmm3, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vaddss %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: f32_two_step_2:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpss %xmm0, %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero sched: [4:0.50]
; HASWELL-NEXT:    vmovaps %xmm1, %xmm3 # sched: [1:1.00]
; HASWELL-NEXT:    vfnmadd213ss %xmm2, %xmm0, %xmm3
; HASWELL-NEXT:    vfmadd132ss %xmm1, %xmm1, %xmm3
; HASWELL-NEXT:    vfnmadd213ss %xmm2, %xmm3, %xmm0
; HASWELL-NEXT:    vfmadd132ss %xmm3, %xmm3, %xmm0
; HASWELL-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-NO-FMA-LABEL: f32_two_step_2:
; HASWELL-NO-FMA:       # BB#0:
; HASWELL-NO-FMA-NEXT:    vrcpss %xmm0, %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vmulss %xmm1, %xmm0, %xmm2 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vmovss {{.*#+}} xmm3 = mem[0],zero,zero,zero sched: [4:0.50]
; HASWELL-NO-FMA-NEXT:    vsubss %xmm2, %xmm3, %xmm2 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulss %xmm2, %xmm1, %xmm2 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vaddss %xmm2, %xmm1, %xmm1 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulss %xmm1, %xmm0, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vsubss %xmm0, %xmm3, %xmm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulss %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vaddss %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; HASWELL-NO-FMA-NEXT:    retq # sched: [1:1.00]
;
; AVX512-LABEL: f32_two_step_2:
; AVX512:       # BB#0:
; AVX512-NEXT:    vrcp14ss %xmm0, %xmm0, %xmm1
; AVX512-NEXT:    vmovss {{.*#+}} xmm2 = mem[0],zero,zero,zero sched: [4:0.50]
; AVX512-NEXT:    vmovaps %xmm1, %xmm3 # sched: [1:1.00]
; AVX512-NEXT:    vfnmadd213ss %xmm2, %xmm0, %xmm3
; AVX512-NEXT:    vfmadd132ss %xmm1, %xmm1, %xmm3
; AVX512-NEXT:    vfnmadd213ss %xmm2, %xmm3, %xmm0
; AVX512-NEXT:    vfmadd132ss %xmm3, %xmm3, %xmm0
; AVX512-NEXT:    vmulss {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; AVX512-NEXT:    retq # sched: [1:1.00]
  %div = fdiv fast float 6789.0, %x
  ret float %div
}

define <4 x float> @v4f32_one_step2(<4 x float> %x) #1 {
; SSE-LABEL: v4f32_one_step2:
; SSE:       # BB#0:
; SSE-NEXT:    rcpps %xmm0, %xmm2
; SSE-NEXT:    mulps %xmm2, %xmm0
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; SSE-NEXT:    subps %xmm0, %xmm1
; SSE-NEXT:    mulps %xmm2, %xmm1
; SSE-NEXT:    addps %xmm2, %xmm1
; SSE-NEXT:    mulps {{.*}}(%rip), %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-RECIP-LABEL: v4f32_one_step2:
; AVX-RECIP:       # BB#0:
; AVX-RECIP-NEXT:    vrcpps %xmm0, %xmm1
; AVX-RECIP-NEXT:    vmulps %xmm1, %xmm0, %xmm0
; AVX-RECIP-NEXT:    vmovaps {{.*#+}} xmm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; AVX-RECIP-NEXT:    vsubps %xmm0, %xmm2, %xmm0
; AVX-RECIP-NEXT:    vmulps %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0
; AVX-RECIP-NEXT:    retq
;
; FMA-RECIP-LABEL: v4f32_one_step2:
; FMA-RECIP:       # BB#0:
; FMA-RECIP-NEXT:    vrcpps %xmm0, %xmm1
; FMA-RECIP-NEXT:    vfnmadd213ps {{.*}}(%rip), %xmm1, %xmm0
; FMA-RECIP-NEXT:    vfmadd132ps %xmm1, %xmm1, %xmm0
; FMA-RECIP-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0
; FMA-RECIP-NEXT:    retq
;
; BTVER2-LABEL: v4f32_one_step2:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovaps {{.*#+}} xmm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00] sched: [5:1.00]
; BTVER2-NEXT:    vrcpps %xmm0, %xmm1 # sched: [2:1.00]
; BTVER2-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vsubps %xmm0, %xmm2, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: v4f32_one_step2:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpps %xmm0, %xmm1 # sched: [7:3.00]
; SANDY-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmovaps {{.*#+}} xmm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00] sched: [6:0.50]
; SANDY-NEXT:    vsubps %xmm0, %xmm2, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: v4f32_one_step2:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpps %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-NEXT:    vbroadcastss {{.*#+}} xmm2 = [1,1,1,1] sched: [4:0.50]
; HASWELL-NEXT:    vfnmadd213ps %xmm2, %xmm1, %xmm0
; HASWELL-NEXT:    vfmadd132ps %xmm1, %xmm1, %xmm0
; HASWELL-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-NO-FMA-LABEL: v4f32_one_step2:
; HASWELL-NO-FMA:       # BB#0:
; HASWELL-NO-FMA-NEXT:    vrcpps %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vbroadcastss {{.*#+}} xmm2 = [1,1,1,1] sched: [4:0.50]
; HASWELL-NO-FMA-NEXT:    vsubps %xmm0, %xmm2, %xmm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; HASWELL-NO-FMA-NEXT:    retq # sched: [1:1.00]
;
; KNL-LABEL: v4f32_one_step2:
; KNL:       # BB#0:
; KNL-NEXT:    vrcpps %xmm0, %xmm1 # sched: [5:1.00]
; KNL-NEXT:    vbroadcastss {{.*#+}} xmm2 = [1,1,1,1] sched: [4:0.50]
; KNL-NEXT:    vfnmadd213ps %xmm2, %xmm1, %xmm0
; KNL-NEXT:    vfmadd132ps %xmm1, %xmm1, %xmm0
; KNL-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; KNL-NEXT:    retq # sched: [1:1.00]
;
; SKX-LABEL: v4f32_one_step2:
; SKX:       # BB#0:
; SKX-NEXT:    vrcp14ps %xmm0, %xmm1
; SKX-NEXT:    vfnmadd213ps {{.*}}(%rip){1to4}, %xmm1, %xmm0
; SKX-NEXT:    vfmadd132ps %xmm1, %xmm1, %xmm0
; SKX-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; SKX-NEXT:    retq # sched: [1:1.00]
  %div = fdiv fast <4 x float> <float 1.0, float 2.0, float 3.0, float 4.0>, %x
  ret <4 x float> %div
}

define <4 x float> @v4f32_one_step_2_divs(<4 x float> %x) #1 {
; SSE-LABEL: v4f32_one_step_2_divs:
; SSE:       # BB#0:
; SSE-NEXT:    rcpps %xmm0, %xmm1
; SSE-NEXT:    mulps %xmm1, %xmm0
; SSE-NEXT:    movaps {{.*#+}} xmm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; SSE-NEXT:    subps %xmm0, %xmm2
; SSE-NEXT:    mulps %xmm1, %xmm2
; SSE-NEXT:    addps %xmm1, %xmm2
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [1.000000e+00,2.000000e+00,3.000000e+00,4.000000e+00]
; SSE-NEXT:    mulps %xmm2, %xmm0
; SSE-NEXT:    mulps %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-RECIP-LABEL: v4f32_one_step_2_divs:
; AVX-RECIP:       # BB#0:
; AVX-RECIP-NEXT:    vrcpps %xmm0, %xmm1
; AVX-RECIP-NEXT:    vmulps %xmm1, %xmm0, %xmm0
; AVX-RECIP-NEXT:    vmovaps {{.*#+}} xmm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; AVX-RECIP-NEXT:    vsubps %xmm0, %xmm2, %xmm0
; AVX-RECIP-NEXT:    vmulps %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm1
; AVX-RECIP-NEXT:    vmulps %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    retq
;
; FMA-RECIP-LABEL: v4f32_one_step_2_divs:
; FMA-RECIP:       # BB#0:
; FMA-RECIP-NEXT:    vrcpps %xmm0, %xmm1
; FMA-RECIP-NEXT:    vfnmadd213ps {{.*}}(%rip), %xmm1, %xmm0
; FMA-RECIP-NEXT:    vfmadd132ps %xmm1, %xmm1, %xmm0
; FMA-RECIP-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm1
; FMA-RECIP-NEXT:    vmulps %xmm0, %xmm1, %xmm0
; FMA-RECIP-NEXT:    retq
;
; BTVER2-LABEL: v4f32_one_step_2_divs:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovaps {{.*#+}} xmm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00] sched: [5:1.00]
; BTVER2-NEXT:    vrcpps %xmm0, %xmm1 # sched: [2:1.00]
; BTVER2-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vsubps %xmm0, %xmm2, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm1 # sched: [7:1.00]
; BTVER2-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: v4f32_one_step_2_divs:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpps %xmm0, %xmm1 # sched: [7:3.00]
; SANDY-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vmovaps {{.*#+}} xmm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00] sched: [6:0.50]
; SANDY-NEXT:    vsubps %xmm0, %xmm2, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm1 # sched: [11:1.00]
; SANDY-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: v4f32_one_step_2_divs:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpps %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-NEXT:    vbroadcastss {{.*#+}} xmm2 = [1,1,1,1] sched: [4:0.50]
; HASWELL-NEXT:    vfnmadd213ps %xmm2, %xmm1, %xmm0
; HASWELL-NEXT:    vfmadd132ps %xmm1, %xmm1, %xmm0
; HASWELL-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm1 # sched: [9:0.50]
; HASWELL-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-NO-FMA-LABEL: v4f32_one_step_2_divs:
; HASWELL-NO-FMA:       # BB#0:
; HASWELL-NO-FMA-NEXT:    vrcpps %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vbroadcastss {{.*#+}} xmm2 = [1,1,1,1] sched: [4:0.50]
; HASWELL-NO-FMA-NEXT:    vsubps %xmm0, %xmm2, %xmm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm1 # sched: [9:0.50]
; HASWELL-NO-FMA-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    retq # sched: [1:1.00]
;
; KNL-LABEL: v4f32_one_step_2_divs:
; KNL:       # BB#0:
; KNL-NEXT:    vrcpps %xmm0, %xmm1 # sched: [5:1.00]
; KNL-NEXT:    vbroadcastss {{.*#+}} xmm2 = [1,1,1,1] sched: [4:0.50]
; KNL-NEXT:    vfnmadd213ps %xmm2, %xmm1, %xmm0
; KNL-NEXT:    vfmadd132ps %xmm1, %xmm1, %xmm0
; KNL-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm1 # sched: [9:0.50]
; KNL-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; KNL-NEXT:    retq # sched: [1:1.00]
;
; SKX-LABEL: v4f32_one_step_2_divs:
; SKX:       # BB#0:
; SKX-NEXT:    vrcp14ps %xmm0, %xmm1
; SKX-NEXT:    vfnmadd213ps {{.*}}(%rip){1to4}, %xmm1, %xmm0
; SKX-NEXT:    vfmadd132ps %xmm1, %xmm1, %xmm0
; SKX-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm1 # sched: [9:0.50]
; SKX-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; SKX-NEXT:    retq # sched: [1:1.00]
  %div = fdiv fast <4 x float> <float 1.0, float 2.0, float 3.0, float 4.0>, %x
  %div2 = fdiv fast <4 x float> %div, %x
  ret <4 x float> %div2
}

define <4 x float> @v4f32_two_step2(<4 x float> %x) #2 {
; SSE-LABEL: v4f32_two_step2:
; SSE:       # BB#0:
; SSE-NEXT:    rcpps %xmm0, %xmm2
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    mulps %xmm2, %xmm3
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    subps %xmm3, %xmm4
; SSE-NEXT:    mulps %xmm2, %xmm4
; SSE-NEXT:    addps %xmm2, %xmm4
; SSE-NEXT:    mulps %xmm4, %xmm0
; SSE-NEXT:    subps %xmm0, %xmm1
; SSE-NEXT:    mulps %xmm4, %xmm1
; SSE-NEXT:    addps %xmm4, %xmm1
; SSE-NEXT:    mulps {{.*}}(%rip), %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-RECIP-LABEL: v4f32_two_step2:
; AVX-RECIP:       # BB#0:
; AVX-RECIP-NEXT:    vrcpps %xmm0, %xmm1
; AVX-RECIP-NEXT:    vmulps %xmm1, %xmm0, %xmm2
; AVX-RECIP-NEXT:    vmovaps {{.*#+}} xmm3 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; AVX-RECIP-NEXT:    vsubps %xmm2, %xmm3, %xmm2
; AVX-RECIP-NEXT:    vmulps %xmm2, %xmm1, %xmm2
; AVX-RECIP-NEXT:    vaddps %xmm2, %xmm1, %xmm1
; AVX-RECIP-NEXT:    vmulps %xmm1, %xmm0, %xmm0
; AVX-RECIP-NEXT:    vsubps %xmm0, %xmm3, %xmm0
; AVX-RECIP-NEXT:    vmulps %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    vaddps %xmm0, %xmm1, %xmm0
; AVX-RECIP-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0
; AVX-RECIP-NEXT:    retq
;
; FMA-RECIP-LABEL: v4f32_two_step2:
; FMA-RECIP:       # BB#0:
; FMA-RECIP-NEXT:    vrcpps %xmm0, %xmm1
; FMA-RECIP-NEXT:    vmovaps {{.*#+}} xmm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; FMA-RECIP-NEXT:    vmovaps %xmm1, %xmm3
; FMA-RECIP-NEXT:    vfnmadd213ps %xmm2, %xmm0, %xmm3
; FMA-RECIP-NEXT:    vfmadd132ps %xmm1, %xmm1, %xmm3
; FMA-RECIP-NEXT:    vfnmadd213ps %xmm2, %xmm3, %xmm0
; FMA-RECIP-NEXT:    vfmadd132ps %xmm3, %xmm3, %xmm0
; FMA-RECIP-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0
; FMA-RECIP-NEXT:    retq
;
; BTVER2-LABEL: v4f32_two_step2:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovaps {{.*#+}} xmm3 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00] sched: [5:1.00]
; BTVER2-NEXT:    vrcpps %xmm0, %xmm1 # sched: [2:1.00]
; BTVER2-NEXT:    vmulps %xmm1, %xmm0, %xmm2 # sched: [2:1.00]
; BTVER2-NEXT:    vsubps %xmm2, %xmm3, %xmm2 # sched: [3:1.00]
; BTVER2-NEXT:    vmulps %xmm2, %xmm1, %xmm2 # sched: [2:1.00]
; BTVER2-NEXT:    vaddps %xmm2, %xmm1, %xmm1 # sched: [3:1.00]
; BTVER2-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vsubps %xmm0, %xmm3, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [2:1.00]
; BTVER2-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; BTVER2-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0 # sched: [7:1.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: v4f32_two_step2:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpps %xmm0, %xmm1 # sched: [7:3.00]
; SANDY-NEXT:    vmulps %xmm1, %xmm0, %xmm2 # sched: [5:1.00]
; SANDY-NEXT:    vmovaps {{.*#+}} xmm3 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00] sched: [6:0.50]
; SANDY-NEXT:    vsubps %xmm2, %xmm3, %xmm2 # sched: [3:1.00]
; SANDY-NEXT:    vmulps %xmm2, %xmm1, %xmm2 # sched: [5:1.00]
; SANDY-NEXT:    vaddps %xmm2, %xmm1, %xmm1 # sched: [3:1.00]
; SANDY-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vsubps %xmm0, %xmm3, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [5:1.00]
; SANDY-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0 # sched: [11:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: v4f32_two_step2:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpps %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-NEXT:    vbroadcastss {{.*#+}} xmm2 = [1,1,1,1] sched: [4:0.50]
; HASWELL-NEXT:    vmovaps %xmm1, %xmm3 # sched: [1:1.00]
; HASWELL-NEXT:    vfnmadd213ps %xmm2, %xmm0, %xmm3
; HASWELL-NEXT:    vfmadd132ps %xmm1, %xmm1, %xmm3
; HASWELL-NEXT:    vfnmadd213ps %xmm2, %xmm3, %xmm0
; HASWELL-NEXT:    vfmadd132ps %xmm3, %xmm3, %xmm0
; HASWELL-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-NO-FMA-LABEL: v4f32_two_step2:
; HASWELL-NO-FMA:       # BB#0:
; HASWELL-NO-FMA-NEXT:    vrcpps %xmm0, %xmm1 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %xmm1, %xmm0, %xmm2 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vbroadcastss {{.*#+}} xmm3 = [1,1,1,1] sched: [4:0.50]
; HASWELL-NO-FMA-NEXT:    vsubps %xmm2, %xmm3, %xmm2 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %xmm2, %xmm1, %xmm2 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vaddps %xmm2, %xmm1, %xmm1 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %xmm1, %xmm0, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vsubps %xmm0, %xmm3, %xmm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %xmm0, %xmm1, %xmm0 # sched: [5:0.50]
; HASWELL-NO-FMA-NEXT:    vaddps %xmm0, %xmm1, %xmm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; HASWELL-NO-FMA-NEXT:    retq # sched: [1:1.00]
;
; KNL-LABEL: v4f32_two_step2:
; KNL:       # BB#0:
; KNL-NEXT:    vrcpps %xmm0, %xmm1 # sched: [5:1.00]
; KNL-NEXT:    vbroadcastss {{.*#+}} xmm2 = [1,1,1,1] sched: [4:0.50]
; KNL-NEXT:    vmovaps %xmm1, %xmm3 # sched: [1:1.00]
; KNL-NEXT:    vfnmadd213ps %xmm2, %xmm0, %xmm3
; KNL-NEXT:    vfmadd132ps %xmm1, %xmm1, %xmm3
; KNL-NEXT:    vfnmadd213ps %xmm2, %xmm3, %xmm0
; KNL-NEXT:    vfmadd132ps %xmm3, %xmm3, %xmm0
; KNL-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; KNL-NEXT:    retq # sched: [1:1.00]
;
; SKX-LABEL: v4f32_two_step2:
; SKX:       # BB#0:
; SKX-NEXT:    vrcp14ps %xmm0, %xmm1
; SKX-NEXT:    vbroadcastss {{.*#+}} xmm2 = [1,1,1,1] sched: [4:0.50]
; SKX-NEXT:    vmovaps %xmm1, %xmm3 # sched: [1:1.00]
; SKX-NEXT:    vfnmadd213ps %xmm2, %xmm0, %xmm3
; SKX-NEXT:    vfmadd132ps %xmm1, %xmm1, %xmm3
; SKX-NEXT:    vfnmadd213ps %xmm2, %xmm3, %xmm0
; SKX-NEXT:    vfmadd132ps %xmm3, %xmm3, %xmm0
; SKX-NEXT:    vmulps {{.*}}(%rip), %xmm0, %xmm0 # sched: [9:0.50]
; SKX-NEXT:    retq # sched: [1:1.00]
  %div = fdiv fast <4 x float> <float 1.0, float 2.0, float 3.0, float 4.0>, %x
  ret <4 x float> %div
}

define <8 x float> @v8f32_one_step2(<8 x float> %x) #1 {
; SSE-LABEL: v8f32_one_step2:
; SSE:       # BB#0:
; SSE-NEXT:    rcpps %xmm1, %xmm4
; SSE-NEXT:    mulps %xmm4, %xmm1
; SSE-NEXT:    movaps {{.*#+}} xmm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; SSE-NEXT:    movaps %xmm2, %xmm3
; SSE-NEXT:    subps %xmm1, %xmm3
; SSE-NEXT:    mulps %xmm4, %xmm3
; SSE-NEXT:    addps %xmm4, %xmm3
; SSE-NEXT:    rcpps %xmm0, %xmm1
; SSE-NEXT:    mulps %xmm1, %xmm0
; SSE-NEXT:    subps %xmm0, %xmm2
; SSE-NEXT:    mulps %xmm1, %xmm2
; SSE-NEXT:    addps %xmm1, %xmm2
; SSE-NEXT:    mulps {{.*}}(%rip), %xmm2
; SSE-NEXT:    mulps {{.*}}(%rip), %xmm3
; SSE-NEXT:    movaps %xmm2, %xmm0
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX-RECIP-LABEL: v8f32_one_step2:
; AVX-RECIP:       # BB#0:
; AVX-RECIP-NEXT:    vrcpps %ymm0, %ymm1
; AVX-RECIP-NEXT:    vmulps %ymm1, %ymm0, %ymm0
; AVX-RECIP-NEXT:    vmovaps {{.*#+}} ymm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; AVX-RECIP-NEXT:    vsubps %ymm0, %ymm2, %ymm0
; AVX-RECIP-NEXT:    vmulps %ymm0, %ymm1, %ymm0
; AVX-RECIP-NEXT:    vaddps %ymm0, %ymm1, %ymm0
; AVX-RECIP-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0
; AVX-RECIP-NEXT:    retq
;
; FMA-RECIP-LABEL: v8f32_one_step2:
; FMA-RECIP:       # BB#0:
; FMA-RECIP-NEXT:    vrcpps %ymm0, %ymm1
; FMA-RECIP-NEXT:    vfnmadd213ps {{.*}}(%rip), %ymm1, %ymm0
; FMA-RECIP-NEXT:    vfmadd132ps %ymm1, %ymm1, %ymm0
; FMA-RECIP-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0
; FMA-RECIP-NEXT:    retq
;
; BTVER2-LABEL: v8f32_one_step2:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovaps {{.*#+}} ymm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00] sched: [5:1.00]
; BTVER2-NEXT:    vrcpps %ymm0, %ymm1 # sched: [2:2.00]
; BTVER2-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vsubps %ymm0, %ymm2, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: v8f32_one_step2:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpps %ymm0, %ymm1 # sched: [5:1.00]
; SANDY-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [5:1.00]
; SANDY-NEXT:    vmovaps {{.*#+}} ymm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00] sched: [7:0.50]
; SANDY-NEXT:    vsubps %ymm0, %ymm2, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [5:1.00]
; SANDY-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [12:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: v8f32_one_step2:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpps %ymm0, %ymm1 # sched: [7:2.00]
; HASWELL-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1,1,1,1,1,1,1,1] sched: [5:1.00]
; HASWELL-NEXT:    vfnmadd213ps %ymm2, %ymm1, %ymm0
; HASWELL-NEXT:    vfmadd132ps %ymm1, %ymm1, %ymm0
; HASWELL-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [9:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-NO-FMA-LABEL: v8f32_one_step2:
; HASWELL-NO-FMA:       # BB#0:
; HASWELL-NO-FMA-NEXT:    vrcpps %ymm0, %ymm1 # sched: [7:2.00]
; HASWELL-NO-FMA-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1,1,1,1,1,1,1,1] sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vsubps %ymm0, %ymm2, %ymm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [9:1.00]
; HASWELL-NO-FMA-NEXT:    retq # sched: [1:1.00]
;
; KNL-LABEL: v8f32_one_step2:
; KNL:       # BB#0:
; KNL-NEXT:    vrcpps %ymm0, %ymm1 # sched: [7:2.00]
; KNL-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1,1,1,1,1,1,1,1] sched: [5:1.00]
; KNL-NEXT:    vfnmadd213ps %ymm2, %ymm1, %ymm0
; KNL-NEXT:    vfmadd132ps %ymm1, %ymm1, %ymm0
; KNL-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [9:1.00]
; KNL-NEXT:    retq # sched: [1:1.00]
;
; SKX-LABEL: v8f32_one_step2:
; SKX:       # BB#0:
; SKX-NEXT:    vrcp14ps %ymm0, %ymm1
; SKX-NEXT:    vfnmadd213ps {{.*}}(%rip){1to8}, %ymm1, %ymm0
; SKX-NEXT:    vfmadd132ps %ymm1, %ymm1, %ymm0
; SKX-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [9:1.00]
; SKX-NEXT:    retq # sched: [1:1.00]
  %div = fdiv fast <8 x float> <float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0, float 7.0, float 8.0>, %x
  ret <8 x float> %div
}

define <8 x float> @v8f32_one_step_2_divs(<8 x float> %x) #1 {
; SSE-LABEL: v8f32_one_step_2_divs:
; SSE:       # BB#0:
; SSE-NEXT:    rcpps %xmm0, %xmm2
; SSE-NEXT:    mulps %xmm2, %xmm0
; SSE-NEXT:    movaps {{.*#+}} xmm3 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; SSE-NEXT:    movaps %xmm3, %xmm4
; SSE-NEXT:    subps %xmm0, %xmm4
; SSE-NEXT:    mulps %xmm2, %xmm4
; SSE-NEXT:    addps %xmm2, %xmm4
; SSE-NEXT:    rcpps %xmm1, %xmm0
; SSE-NEXT:    mulps %xmm0, %xmm1
; SSE-NEXT:    subps %xmm1, %xmm3
; SSE-NEXT:    mulps %xmm0, %xmm3
; SSE-NEXT:    addps %xmm0, %xmm3
; SSE-NEXT:    movaps {{.*#+}} xmm1 = [5.000000e+00,6.000000e+00,7.000000e+00,8.000000e+00]
; SSE-NEXT:    mulps %xmm3, %xmm1
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [1.000000e+00,2.000000e+00,3.000000e+00,4.000000e+00]
; SSE-NEXT:    mulps %xmm4, %xmm0
; SSE-NEXT:    mulps %xmm4, %xmm0
; SSE-NEXT:    mulps %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX-RECIP-LABEL: v8f32_one_step_2_divs:
; AVX-RECIP:       # BB#0:
; AVX-RECIP-NEXT:    vrcpps %ymm0, %ymm1
; AVX-RECIP-NEXT:    vmulps %ymm1, %ymm0, %ymm0
; AVX-RECIP-NEXT:    vmovaps {{.*#+}} ymm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; AVX-RECIP-NEXT:    vsubps %ymm0, %ymm2, %ymm0
; AVX-RECIP-NEXT:    vmulps %ymm0, %ymm1, %ymm0
; AVX-RECIP-NEXT:    vaddps %ymm0, %ymm1, %ymm0
; AVX-RECIP-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm1
; AVX-RECIP-NEXT:    vmulps %ymm0, %ymm1, %ymm0
; AVX-RECIP-NEXT:    retq
;
; FMA-RECIP-LABEL: v8f32_one_step_2_divs:
; FMA-RECIP:       # BB#0:
; FMA-RECIP-NEXT:    vrcpps %ymm0, %ymm1
; FMA-RECIP-NEXT:    vfnmadd213ps {{.*}}(%rip), %ymm1, %ymm0
; FMA-RECIP-NEXT:    vfmadd132ps %ymm1, %ymm1, %ymm0
; FMA-RECIP-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm1
; FMA-RECIP-NEXT:    vmulps %ymm0, %ymm1, %ymm0
; FMA-RECIP-NEXT:    retq
;
; BTVER2-LABEL: v8f32_one_step_2_divs:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovaps {{.*#+}} ymm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00] sched: [5:1.00]
; BTVER2-NEXT:    vrcpps %ymm0, %ymm1 # sched: [2:2.00]
; BTVER2-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vsubps %ymm0, %ymm2, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm1 # sched: [7:2.00]
; BTVER2-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: v8f32_one_step_2_divs:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpps %ymm0, %ymm1 # sched: [5:1.00]
; SANDY-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [5:1.00]
; SANDY-NEXT:    vmovaps {{.*#+}} ymm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00] sched: [7:0.50]
; SANDY-NEXT:    vsubps %ymm0, %ymm2, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [5:1.00]
; SANDY-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm1 # sched: [12:1.00]
; SANDY-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: v8f32_one_step_2_divs:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpps %ymm0, %ymm1 # sched: [7:2.00]
; HASWELL-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1,1,1,1,1,1,1,1] sched: [5:1.00]
; HASWELL-NEXT:    vfnmadd213ps %ymm2, %ymm1, %ymm0
; HASWELL-NEXT:    vfmadd132ps %ymm1, %ymm1, %ymm0
; HASWELL-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm1 # sched: [9:1.00]
; HASWELL-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [5:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-NO-FMA-LABEL: v8f32_one_step_2_divs:
; HASWELL-NO-FMA:       # BB#0:
; HASWELL-NO-FMA-NEXT:    vrcpps %ymm0, %ymm1 # sched: [7:2.00]
; HASWELL-NO-FMA-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1,1,1,1,1,1,1,1] sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vsubps %ymm0, %ymm2, %ymm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm1 # sched: [9:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    retq # sched: [1:1.00]
;
; KNL-LABEL: v8f32_one_step_2_divs:
; KNL:       # BB#0:
; KNL-NEXT:    vrcpps %ymm0, %ymm1 # sched: [7:2.00]
; KNL-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1,1,1,1,1,1,1,1] sched: [5:1.00]
; KNL-NEXT:    vfnmadd213ps %ymm2, %ymm1, %ymm0
; KNL-NEXT:    vfmadd132ps %ymm1, %ymm1, %ymm0
; KNL-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm1 # sched: [9:1.00]
; KNL-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [5:1.00]
; KNL-NEXT:    retq # sched: [1:1.00]
;
; SKX-LABEL: v8f32_one_step_2_divs:
; SKX:       # BB#0:
; SKX-NEXT:    vrcp14ps %ymm0, %ymm1
; SKX-NEXT:    vfnmadd213ps {{.*}}(%rip){1to8}, %ymm1, %ymm0
; SKX-NEXT:    vfmadd132ps %ymm1, %ymm1, %ymm0
; SKX-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm1 # sched: [9:1.00]
; SKX-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [5:1.00]
; SKX-NEXT:    retq # sched: [1:1.00]
  %div = fdiv fast <8 x float> <float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0, float 7.0, float 8.0>, %x
  %div2 = fdiv fast <8 x float> %div, %x
  ret <8 x float> %div2
}

define <8 x float> @v8f32_two_step2(<8 x float> %x) #2 {
; SSE-LABEL: v8f32_two_step2:
; SSE:       # BB#0:
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    rcpps %xmm1, %xmm3
; SSE-NEXT:    movaps %xmm1, %xmm4
; SSE-NEXT:    mulps %xmm3, %xmm4
; SSE-NEXT:    movaps {{.*#+}} xmm0 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; SSE-NEXT:    movaps %xmm0, %xmm5
; SSE-NEXT:    subps %xmm4, %xmm5
; SSE-NEXT:    mulps %xmm3, %xmm5
; SSE-NEXT:    addps %xmm3, %xmm5
; SSE-NEXT:    mulps %xmm5, %xmm1
; SSE-NEXT:    movaps %xmm0, %xmm3
; SSE-NEXT:    subps %xmm1, %xmm3
; SSE-NEXT:    mulps %xmm5, %xmm3
; SSE-NEXT:    addps %xmm5, %xmm3
; SSE-NEXT:    rcpps %xmm2, %xmm1
; SSE-NEXT:    movaps %xmm2, %xmm4
; SSE-NEXT:    mulps %xmm1, %xmm4
; SSE-NEXT:    movaps %xmm0, %xmm5
; SSE-NEXT:    subps %xmm4, %xmm5
; SSE-NEXT:    mulps %xmm1, %xmm5
; SSE-NEXT:    addps %xmm1, %xmm5
; SSE-NEXT:    mulps %xmm5, %xmm2
; SSE-NEXT:    subps %xmm2, %xmm0
; SSE-NEXT:    mulps %xmm5, %xmm0
; SSE-NEXT:    addps %xmm5, %xmm0
; SSE-NEXT:    mulps {{.*}}(%rip), %xmm0
; SSE-NEXT:    mulps {{.*}}(%rip), %xmm3
; SSE-NEXT:    movaps %xmm3, %xmm1
; SSE-NEXT:    retq
;
; AVX-RECIP-LABEL: v8f32_two_step2:
; AVX-RECIP:       # BB#0:
; AVX-RECIP-NEXT:    vrcpps %ymm0, %ymm1
; AVX-RECIP-NEXT:    vmulps %ymm1, %ymm0, %ymm2
; AVX-RECIP-NEXT:    vmovaps {{.*#+}} ymm3 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; AVX-RECIP-NEXT:    vsubps %ymm2, %ymm3, %ymm2
; AVX-RECIP-NEXT:    vmulps %ymm2, %ymm1, %ymm2
; AVX-RECIP-NEXT:    vaddps %ymm2, %ymm1, %ymm1
; AVX-RECIP-NEXT:    vmulps %ymm1, %ymm0, %ymm0
; AVX-RECIP-NEXT:    vsubps %ymm0, %ymm3, %ymm0
; AVX-RECIP-NEXT:    vmulps %ymm0, %ymm1, %ymm0
; AVX-RECIP-NEXT:    vaddps %ymm0, %ymm1, %ymm0
; AVX-RECIP-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0
; AVX-RECIP-NEXT:    retq
;
; FMA-RECIP-LABEL: v8f32_two_step2:
; FMA-RECIP:       # BB#0:
; FMA-RECIP-NEXT:    vrcpps %ymm0, %ymm1
; FMA-RECIP-NEXT:    vmovaps {{.*#+}} ymm2 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00]
; FMA-RECIP-NEXT:    vmovaps %ymm1, %ymm3
; FMA-RECIP-NEXT:    vfnmadd213ps %ymm2, %ymm0, %ymm3
; FMA-RECIP-NEXT:    vfmadd132ps %ymm1, %ymm1, %ymm3
; FMA-RECIP-NEXT:    vfnmadd213ps %ymm2, %ymm3, %ymm0
; FMA-RECIP-NEXT:    vfmadd132ps %ymm3, %ymm3, %ymm0
; FMA-RECIP-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0
; FMA-RECIP-NEXT:    retq
;
; BTVER2-LABEL: v8f32_two_step2:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vmovaps {{.*#+}} ymm3 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00] sched: [5:1.00]
; BTVER2-NEXT:    vrcpps %ymm0, %ymm1 # sched: [2:2.00]
; BTVER2-NEXT:    vmulps %ymm1, %ymm0, %ymm2 # sched: [2:2.00]
; BTVER2-NEXT:    vsubps %ymm2, %ymm3, %ymm2 # sched: [3:2.00]
; BTVER2-NEXT:    vmulps %ymm2, %ymm1, %ymm2 # sched: [2:2.00]
; BTVER2-NEXT:    vaddps %ymm2, %ymm1, %ymm1 # sched: [3:2.00]
; BTVER2-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vsubps %ymm0, %ymm3, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:2.00]
; BTVER2-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: v8f32_two_step2:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpps %ymm0, %ymm1 # sched: [5:1.00]
; SANDY-NEXT:    vmulps %ymm1, %ymm0, %ymm2 # sched: [5:1.00]
; SANDY-NEXT:    vmovaps {{.*#+}} ymm3 = [1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00,1.000000e+00] sched: [7:0.50]
; SANDY-NEXT:    vsubps %ymm2, %ymm3, %ymm2 # sched: [3:1.00]
; SANDY-NEXT:    vmulps %ymm2, %ymm1, %ymm2 # sched: [5:1.00]
; SANDY-NEXT:    vaddps %ymm2, %ymm1, %ymm1 # sched: [3:1.00]
; SANDY-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [5:1.00]
; SANDY-NEXT:    vsubps %ymm0, %ymm3, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [5:1.00]
; SANDY-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; SANDY-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [12:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: v8f32_two_step2:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpps %ymm0, %ymm1 # sched: [7:2.00]
; HASWELL-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1,1,1,1,1,1,1,1] sched: [5:1.00]
; HASWELL-NEXT:    vmovaps %ymm1, %ymm3 # sched: [1:1.00]
; HASWELL-NEXT:    vfnmadd213ps %ymm2, %ymm0, %ymm3
; HASWELL-NEXT:    vfmadd132ps %ymm1, %ymm1, %ymm3
; HASWELL-NEXT:    vfnmadd213ps %ymm2, %ymm3, %ymm0
; HASWELL-NEXT:    vfmadd132ps %ymm3, %ymm3, %ymm0
; HASWELL-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [9:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-NO-FMA-LABEL: v8f32_two_step2:
; HASWELL-NO-FMA:       # BB#0:
; HASWELL-NO-FMA-NEXT:    vrcpps %ymm0, %ymm1 # sched: [7:2.00]
; HASWELL-NO-FMA-NEXT:    vmulps %ymm1, %ymm0, %ymm2 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vbroadcastss {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1] sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vsubps %ymm2, %ymm3, %ymm2 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %ymm2, %ymm1, %ymm2 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vaddps %ymm2, %ymm1, %ymm1 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %ymm1, %ymm0, %ymm0 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vsubps %ymm0, %ymm3, %ymm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps %ymm0, %ymm1, %ymm0 # sched: [5:1.00]
; HASWELL-NO-FMA-NEXT:    vaddps %ymm0, %ymm1, %ymm0 # sched: [3:1.00]
; HASWELL-NO-FMA-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [9:1.00]
; HASWELL-NO-FMA-NEXT:    retq # sched: [1:1.00]
;
; KNL-LABEL: v8f32_two_step2:
; KNL:       # BB#0:
; KNL-NEXT:    vrcpps %ymm0, %ymm1 # sched: [7:2.00]
; KNL-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1,1,1,1,1,1,1,1] sched: [5:1.00]
; KNL-NEXT:    vmovaps %ymm1, %ymm3 # sched: [1:1.00]
; KNL-NEXT:    vfnmadd213ps %ymm2, %ymm0, %ymm3
; KNL-NEXT:    vfmadd132ps %ymm1, %ymm1, %ymm3
; KNL-NEXT:    vfnmadd213ps %ymm2, %ymm3, %ymm0
; KNL-NEXT:    vfmadd132ps %ymm3, %ymm3, %ymm0
; KNL-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [9:1.00]
; KNL-NEXT:    retq # sched: [1:1.00]
;
; SKX-LABEL: v8f32_two_step2:
; SKX:       # BB#0:
; SKX-NEXT:    vrcp14ps %ymm0, %ymm1
; SKX-NEXT:    vbroadcastss {{.*#+}} ymm2 = [1,1,1,1,1,1,1,1] sched: [5:1.00]
; SKX-NEXT:    vmovaps %ymm1, %ymm3 # sched: [1:1.00]
; SKX-NEXT:    vfnmadd213ps %ymm2, %ymm0, %ymm3
; SKX-NEXT:    vfmadd132ps %ymm1, %ymm1, %ymm3
; SKX-NEXT:    vfnmadd213ps %ymm2, %ymm3, %ymm0
; SKX-NEXT:    vfmadd132ps %ymm3, %ymm3, %ymm0
; SKX-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [9:1.00]
; SKX-NEXT:    retq # sched: [1:1.00]
  %div = fdiv fast <8 x float> <float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0, float 7.0, float 8.0>, %x
  ret <8 x float> %div
}

define <8 x float> @v8f32_no_step(<8 x float> %x) #3 {
; SSE-LABEL: v8f32_no_step:
; SSE:       # BB#0:
; SSE-NEXT:    rcpps %xmm0, %xmm0
; SSE-NEXT:    rcpps %xmm1, %xmm1
; SSE-NEXT:    retq
;
; AVX-RECIP-LABEL: v8f32_no_step:
; AVX-RECIP:       # BB#0:
; AVX-RECIP-NEXT:    vrcpps %ymm0, %ymm0
; AVX-RECIP-NEXT:    retq
;
; FMA-RECIP-LABEL: v8f32_no_step:
; FMA-RECIP:       # BB#0:
; FMA-RECIP-NEXT:    vrcpps %ymm0, %ymm0
; FMA-RECIP-NEXT:    retq
;
; BTVER2-LABEL: v8f32_no_step:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vrcpps %ymm0, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: v8f32_no_step:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpps %ymm0, %ymm0 # sched: [5:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: v8f32_no_step:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpps %ymm0, %ymm0 # sched: [7:2.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-NO-FMA-LABEL: v8f32_no_step:
; HASWELL-NO-FMA:       # BB#0:
; HASWELL-NO-FMA-NEXT:    vrcpps %ymm0, %ymm0 # sched: [7:2.00]
; HASWELL-NO-FMA-NEXT:    retq # sched: [1:1.00]
;
; KNL-LABEL: v8f32_no_step:
; KNL:       # BB#0:
; KNL-NEXT:    vrcpps %ymm0, %ymm0 # sched: [7:2.00]
; KNL-NEXT:    retq # sched: [1:1.00]
;
; SKX-LABEL: v8f32_no_step:
; SKX:       # BB#0:
; SKX-NEXT:    vrcp14ps %ymm0, %ymm0
; SKX-NEXT:    retq # sched: [1:1.00]
  %div = fdiv fast <8 x float> <float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0, float 1.0>, %x
  ret <8 x float> %div
}

define <8 x float> @v8f32_no_step2(<8 x float> %x) #3 {
; SSE-LABEL: v8f32_no_step2:
; SSE:       # BB#0:
; SSE-NEXT:    rcpps %xmm1, %xmm1
; SSE-NEXT:    rcpps %xmm0, %xmm0
; SSE-NEXT:    mulps {{.*}}(%rip), %xmm0
; SSE-NEXT:    mulps {{.*}}(%rip), %xmm1
; SSE-NEXT:    retq
;
; AVX-RECIP-LABEL: v8f32_no_step2:
; AVX-RECIP:       # BB#0:
; AVX-RECIP-NEXT:    vrcpps %ymm0, %ymm0
; AVX-RECIP-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0
; AVX-RECIP-NEXT:    retq
;
; FMA-RECIP-LABEL: v8f32_no_step2:
; FMA-RECIP:       # BB#0:
; FMA-RECIP-NEXT:    vrcpps %ymm0, %ymm0
; FMA-RECIP-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0
; FMA-RECIP-NEXT:    retq
;
; BTVER2-LABEL: v8f32_no_step2:
; BTVER2:       # BB#0:
; BTVER2-NEXT:    vrcpps %ymm0, %ymm0 # sched: [2:2.00]
; BTVER2-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [7:2.00]
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: v8f32_no_step2:
; SANDY:       # BB#0:
; SANDY-NEXT:    vrcpps %ymm0, %ymm0 # sched: [5:1.00]
; SANDY-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [12:1.00]
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: v8f32_no_step2:
; HASWELL:       # BB#0:
; HASWELL-NEXT:    vrcpps %ymm0, %ymm0 # sched: [7:2.00]
; HASWELL-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [9:1.00]
; HASWELL-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-NO-FMA-LABEL: v8f32_no_step2:
; HASWELL-NO-FMA:       # BB#0:
; HASWELL-NO-FMA-NEXT:    vrcpps %ymm0, %ymm0 # sched: [7:2.00]
; HASWELL-NO-FMA-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [9:1.00]
; HASWELL-NO-FMA-NEXT:    retq # sched: [1:1.00]
;
; KNL-LABEL: v8f32_no_step2:
; KNL:       # BB#0:
; KNL-NEXT:    vrcpps %ymm0, %ymm0 # sched: [7:2.00]
; KNL-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [9:1.00]
; KNL-NEXT:    retq # sched: [1:1.00]
;
; SKX-LABEL: v8f32_no_step2:
; SKX:       # BB#0:
; SKX-NEXT:    vrcp14ps %ymm0, %ymm0
; SKX-NEXT:    vmulps {{.*}}(%rip), %ymm0, %ymm0 # sched: [9:1.00]
; SKX-NEXT:    retq # sched: [1:1.00]
  %div = fdiv fast <8 x float> <float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0, float 7.0, float 8.0>, %x
  ret <8 x float> %div
}

attributes #0 = { "unsafe-fp-math"="true" "reciprocal-estimates"="!divf,!vec-divf" }
attributes #1 = { "unsafe-fp-math"="true" "reciprocal-estimates"="divf,vec-divf" }
attributes #2 = { "unsafe-fp-math"="true" "reciprocal-estimates"="divf:2,vec-divf:2" }
attributes #3 = { "unsafe-fp-math"="true" "reciprocal-estimates"="divf:0,vec-divf:0" }

