/*
* Copyright (C) 2019 "IoT.bzh"
* Author Jonathan Aillet <jonathan.aillet@iot.bzh>
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#ifndef _HAL_UTILITIES_HAL_STREAMS_CREATION_INCLUDE_
#define _HAL_UTILITIES_HAL_STREAMS_CREATION_INCLUDE_

#include <stdio.h>

#include <afb/afb-binding.h>

#include <ctl-config.h>

// Enum for the type of action on mixer
enum ActionOnMixerType {
	ACTION_ON_MIXER_STREAM = 1,
	ACTION_ON_MIXER_PLAYBACK = 2,
	ACTION_ON_MIXER_CAPTURE = 3,
	ACTION_ON_MIXER_ALL_STREAM = 4
};

// Actions to be call when a stream verb is called
void HalUtlActionOnStream(afb_req_t request);
void HalUtlActionOnPlayback(afb_req_t request);
void HalUtlActionOnCapture(afb_req_t request);
void HalUtlActionOnAllStream(afb_req_t request);

// Add/Remove stream data and verb functions
struct CtlHalMixerData *HalUtlAddStreamDataAndCreateStreamVerb(afb_api_t apiHandle,
							       char *verb,
							       char *verbToCall,
							       char *streamCardId);
int8_t HalUtlRemoveStreamDataAndDeleteStreamVerb(afb_api_t apiHandle,
						 char *verb,
						 char *verbToCall,
						 char *streamCardId);

#endif /* _HAL_UTILITIES_HAL_STREAMS_CREATION_INCLUDE_ */