--[[
   Copyright (C) 2018 "IoT.bzh"
   Author Frédéric Marec <frederic.marec@iot.bzh>

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
--]]

--function _ping(request)
--    AFB:success(request, {1})
--end

function _attach (request)
    AFB:success(request, {
         metadata = {
             uid = "/dev/snd/by-path/pci-0000=00=1b.0",
             version = "0.9",
             api = "4a-hal-intel",
             require = { "alsacore", "smixer" },
             info = "4a hal for Intel device",
             author = "Jonathan Aillet",
             date = "2018-06-13"
        },
         resources = {
            {
                 uid = "hal-bt",
                 info = "Bluetooth hal plugin to get A2DP bluetooth device as an input by tweaking softmixer configuration",
                 params = {
                     channels = 2,
                     zone = "front-seats"
                },
                 libs = {"hal-bt.ctlso"}
            }
        },
         controls = {
            {
                 uid = "ping",
                 info = "Ping hal",
                 action = "api=//4a-hal-manager#ping"
            }
        },
         halmap = {
            {
                 uid = "agl-master-playback-volume",
                 alsa = {
                     name = "Master Playback Volume",
                     value = 100
                }
            },
            {
                 uid = "agl-pcm-playback-volume",
                 alsa = {
                     name = "PCM Playback Volume",
                     value = 100
                }
            },
            {
                 uid = "agl-master-playback-switch",
                 alsa = {
                     name = "Master Playback Switch",
                     value = 1
                }
            },
            {
                 uid = "agl-capture-volume",
                 alsa = {
                     name = "Capture Volume"
                }
            }
        },
         halmixer = {
             uid = "intel",
             mixerapi = "smixer",
             prefix = "intel-generic",
             ramps = {
                {
                     uid = "ramp-very-fast",
                     delay = 50,
                     up = 6,
                     down = 10
                },
                {
                     uid = "ramp-fast",
                     delay = 50,
                     up = 2,
                     down = 10
                },
                {
                     uid = "ramp-normal",
                     delay = 50,
                     up = 2,
                     down = 4
                },
                {
                     uid = "ramp-slow",
                     delay = 50,
                     up = 2,
                     down = 2
                },
                {
                     uid = "ramp-very-slow",
                     delay = 100,
                     up = 1,
                     down = 1
                }
            },
             playbacks  = {
                 uid = "INTEL",
                 path = "/dev/snd/by-path/pci-0000=00=1b.0",
                 params = {
                     rate = 48000
                },
                 sink = {
                     controls = {
                         volume = {
                             name = "Master Playback Volume",
                             value = 80
                        },
                         mute = {
                             name = "Master Playback Switch"
                        }
                    },
                     channels = {
                        {
                             uid = "front-right",
                             port = 0
                        },
                        {
                             uid = "front-left",
                             port = 1
                        }
                    }
                }
            },
             captures = {
                 uid = "INTEL",
                 path = "/dev/snd/by-path/pci-0000=00=1b.0",
                 params = {
                     rate = 48000
                },
                 source = {
                     controls = {
                         volume = {
                             name = "Capture Volume"
                        },
                         mute = {
                             name = "Capture Switch"
                        }
                    },
                     channels = {
                        {
                             uid = "mic-right",
                             port = 0
                        },
                        {
                             uid = "mic-left",
                             port = 1
                        }
                    }
                }
            },
             zones = {
                {
                     uid = "full-stereo",
                     sink = {
                        {
                             target = "front-right",
                             channel = 0
                        },
                        {
                             target = "front-left",
                             channel = 1
                        }
                    }
                },
                {
                     uid = "front-seats",
                     sink = {
                        {
                             target = "front-right",
                             channel = 0
                        },
                        {
                             target = "front-left",
                             channel = 1
                        }
                    }
                }
            },
             streams = {
                {
                     uid = "multimedia",
                     verb = "multimedia",
                     zone = "full-stereo",
                     volume = 60,
                     mute = false,
                     params = {
                         rate = 48000
                    }
                },
                {
                     uid = "navigation",
                     verb = "navigation",
                     zone = "front-seats",
                     volume = 70,
                     mute = false,
                     params = {
                         rate = 48000
                    }
                },
                {
                     uid = "emergency",
                     verb = "emergency",
                     zone = "front-seats",
                     volume = 60,
                     mute = false,
                     params = {
                         rate = 48000
                    }
                },
                {
                     uid = "radio_stream",
                     verb = "radio_stream",
                     zone = "full-stereo",
                     volume = 70,
                     mute = true,
                     params = {
                         rate  = 48000
                    }
                }
            }
        }
   })
  end

  function _remove (request)
    AFB:success(request, {2})
  end

  function _info (request)
    AFB:success(request, {2})
  end

  function _bluezalsa_dev (request)
    AFB:success(request, {2})
  end