#pragma once

/*
 * Copyright (C) 2018 "IoT.bzh"
 * Author Loïc Collignon <loic.collignon@iot.bzh>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <exception>
#include <functional>
#include <sstream>
#include <vector>
#include <list>
#include <map>
#include <cassert>

#include "config_entry.hpp"
#include "role.hpp"

#define HL_API_NAME "ahl-4a"
#define HL_API_INFO "Audio high level API for AGL applications"
#define HAL_MGR_API "4a-hal-manager"

#include "afb-binding-common.h"

class ahl_binding_t
{
	using role_action = std::function<void(afb_req_t, std::string, std::string, json_object*)>;

private:
	afb_api_t handle_;
	afb_event_t volume_changed_;
	std::vector<role_t> roles_;

	explicit ahl_binding_t();

	void load_static_verbs();
	void load_controller_configs();
	int load_controller_config(const std::string& path);
	int update_streams();
	void update_stream(std::string hal, std::string stream, std::string deviceuri);
	int create_api_verb(role_t* r);
	role_t* get_active_role();

public:
	static ahl_binding_t& instance();
	afb_api_t handle() const;
	const std::vector<role_t> roles() const;

	int preinit(afb_api_t handle);
	int init();
	void event(std::string name, json_object* arg);
	int emit_volume_changed(const std::string& role, int volume);
	int parse_roles_config(json_object* o);

	void get_roles(afb_req_t req) const;
	void activerole(afb_req_t req);
	void subscribe(afb_req_t req) const;
	void unsubscribe(afb_req_t req) const;
};


