--[[
   Copyright (C) 2018 "IoT.bzh"
   Author Frédéric Marec <frederic.marec@iot.bzh>

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
--]]

function _info(request)
  AFB:success(request,
  {streams= {
      {
        name= "multimedia",
        cardId = "hw:0,0,0"
      },
      {
        name = "emergency",
        cardId = "hw:0,1,0"
      },
      {
        name = "navigation",
        cardId = "hw:0,1,1"
      },
      {
        name = "radio_stream",
        cardId = "hw:1,0,0"
      },
      {
        name = "radio_stream",
        cardId = "hw:1,0,0"
      }
    }
  }
)
end

function _multimedia(request, args, json_object)
  if json_object["volume"] then AFB:success(request, json_object["volume"])
  elseif json_object["mute"]  then AFB:success(request, true)
  elseif not json_object["mute"] then AFB:success(request, true)
  else AFB:fail(request, false)
  end
end

function _emergency(request, args, json_object)
  if json_object["volume"] then AFB:success(request, json_object["volume"])
  elseif json_object["mute"]  then AFB:success(request, true)
  elseif not json_object["mute"] then AFB:success(request, true)
  else AFB:fail(request, false)
  end
end

function _radio(request, args, json_object)
  if json_object["volume"] then AFB:error(request, "Test error")
  elseif json_object["mute"]  then AFB:error(request, "Test error")
  elseif not json_object["mute"] then AFB:error(request, "Test error")
  else AFB:error(request, false)
  end
end

function _navigation(request, args, json_object)
  if json_object["volume"] then AFB:error(request, "Test error")
  elseif json_object["mute"]  then AFB:error(request, "Test error")
  elseif not json_object["mute"] then AFB:error(request, "Test error")
  else AFB:error(request, false)
  end
end