/*
 * aloader.c
 * Copyright (c) 2016-2019 Arkadiusz Bokowy
 *
 * This file is a part of bluez-alsa.
 *
 * This project is licensed under the terms of the MIT license.
 *
 */

#define _GNU_SOURCE
#include <dlfcn.h>
#include <string.h>

typedef void *(*dlopen_t)(const char *filename, int flags);

dlopen_t dlopen_orig = NULL;

void *dlopen(const char *filename, int flags) {
	if (dlopen_orig == NULL)
		dlopen_orig = (dlopen_t)dlsym(RTLD_NEXT, __func__);
	if (strstr(filename, "libasound_module_ctl_bluealsa.so") != NULL)
		filename = "../src/asound/.libs/libasound_module_ctl_bluealsa.so";
	if (strstr(filename, "libasound_module_pcm_bluealsa.so") != NULL)
		filename = "../src/asound/.libs/libasound_module_pcm_bluealsa.so";
	return dlopen_orig(filename, flags);
}
