/*
 * Copyright (C) 2019 "IoT.bzh"
 * Author Jonathan Aillet <jonathan.aillet@iot.bzh>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#define _GNU_SOURCE

#include <stdio.h>

#include <afb/afb-binding.h>

#include "4a-hal-utilities-alsa-data.h"

/*******************************************************************************
 *		Free contents of 'CtlHalAlsaMapT' data structure	       *
 ******************************************************************************/

uint8_t HalUtlFreeAlsaCtlsMap(struct CtlHalAlsaMapT *alsaCtlsMap)
{
	int idx;

	if(! alsaCtlsMap)
		return -1;

	if(alsaCtlsMap->ctlsCount > 0 && ! alsaCtlsMap->ctls)
		return -2;

	for(idx = 0; idx < alsaCtlsMap->ctlsCount; idx++) {
		free(alsaCtlsMap->ctls[idx].action);
		free(alsaCtlsMap->ctls[idx].ctl.alsaCtlProperties.enums);
		free(alsaCtlsMap->ctls[idx].ctl.alsaCtlProperties.dbscale);
	}

	free(alsaCtlsMap->ctls);

	free(alsaCtlsMap);

	return 0;
}