/*
 * Copyright (C) 2018 "IoT.bzh"
 * Author : Thierry Bultel <thierry.bultel@iot.bzh>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __INC_HAL_BLUEALSA_TRANSPORT_H
#define __INC_HAL_BLUEALSA_TRANSPORT_H

#include <bluealsa/bluealsa.h>
#include <stdbool.h>
#include <urcu/list.h>

#include <afb/afb-binding.h>
#include "hal-bluealsa-watch.h"

typedef struct {
	struct cds_list_head	list;
	const bluealsa_watch *	watch;	/* owner */
	struct ba_msg_transport transport;
	char * 					transactionUidS;
} bluealsa_transport_t;

extern int  halBlueAlsaTransportsInit(bluealsa_transport_t  * list);

extern bluealsa_transport_t * halBlueAlsaTransportsAdd(const bluealsa_watch * watch, bluealsa_transport_t * list, const struct ba_msg_transport * transport);
extern bool                   halBlueAlsaTransportFind(const bluealsa_watch * watch, bluealsa_transport_t * list, const struct ba_msg_transport * transport);

typedef int (*transport_destructor)(bluealsa_transport_t *);

extern int  halBlueAlsaTransportUpdate(
	const bluealsa_watch * watch,
	bluealsa_transport_t * list,
	const struct ba_msg_transport *transports,
	size_t nb,
	transport_destructor);

#define HAL_BLUEALSA_TRANSPORT_LEN_MAX	64

extern char * halBlueAlsaTransportAsString(char * s, size_t len, const struct ba_msg_transport * );

#endif /* __INC_HAL_BLUEALSA_TRANSPORT_H */
