# Components

4a framework is made of several components which provide features to each other.
The High Level API component is the only one that exports a public API. This
means that, as an application developer you only need to care about the High
Level API.

## High level API

This is the publicly exported API. It exposes one verb for each audio roles,
plus **get_roles** to get the list of audio roles.

This component manages audio roles and applies permissions, signaling and
policies. Because each role is a unique verb, it means that each role can have
its own smack label.

It makes use of the **4a-hal-manager** to list all HALs and their
configurations. Then it uses directly the enabled HALs.

## 4a-hal-manager

This component is responsible for HALs detection, initialization and state
management.

## 4a-hal-*

This block represents all the different HALs. You can load multiple HALs
provided that they don't interfere with each other.
HALs can be provided by two means:

* Built directly by the **4a-hal-manager** using it's controller and json files.
* External HAL (like the unicens one), that have to register themselves to the
  **4a-hal-manager**.

HALs manage audio streams and zones. The streams are bound to audio roles.

## 4a-softmixer

This component abstracts the real devices to virtual ones and provides some
basic mixing capabilities for devices that don't have this feature builtin.
It exposes streams named like the audio roles.

This component can be used by HALs, but this is not mandatory.

HALs can either :

* use 4a-softmixer (for example when hardware doesn't provide mixing feature),
  or
* take advantage from the hardware to provide the mixing capabilities.
