# Reference

## Verbs

### ahl-4a/get_roles

Get the list of available audio roles. By default it returns the list of roles
that are bound to a stream. To get a list of all defined roles, regardless if
they are bound to a stream or not, you can pass the following parameter.

```json
{
    "verbose": true
}
```

### ahl-4a/[role]

Replace [role] by the role's name. For example **ahl-4a/multimedia**.

This verb allows the control of the audio role. The action executed depends on
the parameter.

#### Open

```json
{ "action": "open" }
```

Request to open the role.

On success it returns the device URI to open. This action fails if the role is
already opened.

When a role is opened, it triggers the first interruption, if any, of the policy
engine.

The policy engine executes the interruption for each opened audio role with a
lower priority.

#### Close

```json
{ "action": "close" }
```

Request to close the role.

On success it closes the role. You can only close roles that you opened before.
An error will occur if you try to close a role that an other application has
opened.

#### Volume

```json
{
    "action": "volume",
    "value": 80
}
```

Request to get or set the volume.

Value can be absolute or relative. Use a string as value to use relative, like
**"+10"** or **"-20"**. To get the volume you can use **"+0"** as value.

#### Mute

```json
{
    "action": "mute"
}
```

Mute the volume of this.

#### Unmute

```json
{
    "action": "unmute"
}
```

Unmute the volume of this role.

#### Interrupt

```json
{
    "action": "interrupt"
}
```

Ask the policy engine to execute an interruption.