--[[
   Copyright (C) 2018 "IoT.bzh"
   Author Frédéric Marec <frederic.marec@iot.bzh>

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.


   NOTE: strict mode: every global variables should be prefixed by '_'
--]]

local testPrefix ="ahl_BasicAPITest_"
local roles = {"multimedia", "emergency", "navigation", "radio"}

-- This tests the 'get_roles' verb of the 4a-hal-mutimedia API
_AFT.testVerbStatusSuccess(testPrefix.."get_roles","ahl-4a", "get_roles", {verbose = true}, nil, nil)

for _, role in pairs(roles)
do

  -- This tests the 'open' verb of the 4a-hal-mutimedia API
  _AFT.testVerbStatusSuccess(testPrefix.."open_"..role,"ahl-4a", role, {action =  "open"}, nil,
  function()
    _AFT.callVerb("ahl-4a", role, {action =  "close"})
  end
  )

  -- This tests the 'volume' verb of the 4a-hal-mutimedia API
  _AFT.describe(testPrefix.."volume_"..role, function()
    _AFT.callVerb("ahl-4a", role, {action =  "open"})

    _AFT.callVerb("ahl-4a", role, {action = "volume", value = 80})
    _AFT.callVerb("ahl-4a", role, {action = "volume", value = 60})
    _AFT.callVerb("ahl-4a", role, {action = "volume", value = 40})
    _AFT.callVerb("ahl-4a", role, {action = "volume", value = 20})
    _AFT.callVerb("ahl-4a", role, {action = "volume", value = 0})
    _AFT.callVerb("ahl-4a", role, {action = "volume", value = 100})

    _AFT.callVerb("ahl-4a", role, {action =  "close"})
  end,
  nil, nil)

  -- This tests the 'mute' and 'unmute' verb of the 4a-hal-mutimedia API
  _AFT.describe(testPrefix.."mute-unmute_"..role, function()
    _AFT.callVerb("ahl-4a", role, {action =  "open"})

    _AFT.callVerb("ahl-4a", role, {action = "mute"})
    _AFT.callVerb("ahl-4a", role, {action = "unmute"})
    _AFT.callVerb("ahl-4a", role, {action = "mute"})
    _AFT.callVerb("ahl-4a", role, {action = "unmute"})
    _AFT.callVerb("ahl-4a", role, {action = "unmute"})
    _AFT.callVerb("ahl-4a", role, {action = "mute"})
    _AFT.callVerb("ahl-4a", role, {action = "mute"})
    _AFT.callVerb("ahl-4a", role, {action = "unmute"})

    _AFT.callVerb("ahl-4a", role, {action =  "close"})
  end,
  nil, nil)

  -- This tests the 'close' verb of the 4a-hal-mutimedia API
  _AFT.testVerbStatusSuccess(testPrefix.."close_"..role,"ahl-4a", role, {action =  "close"},
  function()
    _AFT.callVerb("ahl-4a", role, {action =  "open"})
  end
  , nil)

  _AFT.testVerbStatusError(testPrefix.."unknown_action_"..role,"ahl-4a", role, {action =  "test_fail_unknown_action"}, nil , nil)

  -- This tests the 'open' verb of the 4a-hal-mutimedia API
  _AFT.testVerbStatusSuccess(testPrefix.."open_"..role,"ahl-4a", role, {action =  "open"}, nil, nil)

end

_AFT.exitAtEnd()
