/*
 * GPS Navigation ---An open source GPS navigation core software
 *
 *
 * Copyright (c) 2016  Hitachi, Ltd.
 *
 * This program is dual licensed under GPL version 2 or a commercial license.
 * See the LICENSE file distributed with this source file.
 */

/*
 * SMDALQuery.h
 *
 *  Created on: 2014/08/04
 *      Author: masutani
 */

#ifndef SMDAL_QUERY_H_
#define SMDAL_QUERY_H_


//パーセルテーブル(PARCEL)
#define SC_DA_SQL_GET_PARCEL_GUIDE_SIZE "SELECT length(GUIDE) FROM PARCEL WHERE PARCEL_ID=%u"
#define SC_DA_SQL_GET_PARCEL_ROAD_SIZE "SELECT length(ROAD_NETWORK) FROM PARCEL WHERE PARCEL_ID=%u"
#define SC_DA_SQL_GET_PARCEL_BKGD_SIZE "SELECT length(BKGD) FROM PARCEL WHERE PARCEL_ID=%u"
#define SC_DA_SQL_GET_PARCEL_SHAPE_SIZE "SELECT length(ROAD_SHAPE) FROM PARCEL WHERE PARCEL_ID=%u"
#define SC_DA_SQL_GET_PARCEL_NAME_SIZE "SELECT length(NAME) FROM PARCEL WHERE PARCEL_ID=%u"
#define SC_DA_SQL_GET_PARCEL_DENSITY_SIZE "SELECT length(ROAD_DENSITY) FROM PARCEL WHERE PARCEL_ID=%u"
#define SC_DA_SQL_GET_PARCEL_MARK_SIZE "SELECT length(MARK) FROM PARCEL WHERE PARCEL_ID=%u"
#define SC_DA_SQL_GET_PARCEL_ROAD_NAME_SIZE "SELECT length(ROAD_NAME) FROM PARCEL WHERE PARCEL_ID=%u"
#define SC_DA_SQL_GET_PARCEL_BASIS_SIZE "SELECT length(PARCEL_BASIS) FROM PARCEL WHERE PARCEL_ID=%u"
#define SC_DA_SQL_GET_PARCEL_BKGD_AREA_CLS_SIZE "SELECT length(BKGD_AREA_CLS) FROM PARCEL WHERE PARCEL_ID=%u"
#define SC_DA_SQL_GET_PARCEL_DATA "SELECT %s FROM PARCEL WHERE PARCEL_ID=%u"
#define SC_DA_COL_PARCEL_ROAD "ROAD_NETWORK,"
#define SC_DA_COL_PARCEL_SHAPE "ROAD_SHAPE,"
#define SC_DA_COL_PARCEL_GUIDE "GUIDE,"
#define SC_DA_COL_PARCEL_BKGD "BKGD,"
#define SC_DA_COL_PARCEL_NAME "NAME,"
#define SC_DA_COL_PARCEL_ROAD_NAME "ROAD_NAME,"
#define SC_DA_COL_PARCEL_DENSITY "ROAD_DENSITY,"
#define SC_DA_COL_PARCEL_MARK "MARK,"
#define SC_DA_COL_PARCEL_BASIS "PARCEL_BASIS,"
#define SC_DA_COL_PARCEL_ROAD_BASE_VERSION "ROAD_BASE_VERSION,"
#define SC_DA_COL_PARCEL_BKGD_AREA_CLS "BKGD_AREA_CLS,"
#define SC_DA_COL_PARCEL_ID "PARCEL_ID"
#define SC_DA_SQL_GET_TILE_SIZE "SELECT length(image_data) FROM Image_TBL WHERE key_level=%d AND key_x=%d AND key_y=%d"
#define SC_DA_SQL_GET_TILE_DATA "SELECT image_data FROM Image_TBL WHERE key_level=%d AND key_x=%d AND key_y=%d"

//地図情報管理テーブル(SYSTEM_INFORMATION)
#define SC_DA_SQL_GET_SYSTEM_INFORMATION_SIZE "SELECT length(INFO) FROM SYSTEM_INFORMATION WHERE TYPE_CODE='%s'"
#define SC_DA_SQL_GET_SYSTEM_INFORMATION_DATA "SELECT INFO FROM SYSTEM_INFORMATION WHERE TYPE_CODE='%s'"
#define SC_DA_SQL_SYSTEM_FORMAT_VERSION "SYSTEM_FORMAT_VERSION"
#define SC_DA_SQL_SYSTEM_MACHINE_TYPE "SYSTEM_MACHINE_TYPE"
#define SC_DA_SQL_SYSTEM_APP_VERSION "SYSTEM_APP_VERSION"
#define SC_DA_SQL_SYSTEM_AREA "SYSTEM_AREA"
#define SC_DA_SQL_SYSTEM_LANG "SYSTEM_LANG"
#define SC_DA_SQL_SYSTEM_LEVEL_01 "SYSTEM_LEVEL_01"
#define SC_DA_SQL_SYSTEM_LEVEL_02 "SYSTEM_LEVEL_02"
#define SC_DA_SQL_SYSTEM_LEVEL_03 "SYSTEM_LEVEL_03"
#define SC_DA_SQL_SYSTEM_LEVEL_04 "SYSTEM_LEVEL_04"
#define SC_DA_SQL_SYSTEM_LEVEL_05 "SYSTEM_LEVEL_05"
#define SC_DA_SQL_SYSTEM_LEVEL_06 "SYSTEM_LEVEL_06"
#define SC_DA_SQL_SYSTEM_LEVEL_07 "SYSTEM_LEVEL_07"
#define SC_DA_SQL_SYSTEM_LEVEL_08 "SYSTEM_LEVEL_08"
#define SC_DA_SQL_SYSTEM_DATA_PROVIDER "SYSTEM_DATA_PROVIDER"
#define SC_DA_SQL_SYSTEM_CHARACTER_CODE "SYSTEM_CHARACTER_CODE"
#define SC_DA_SQL_SYSTEM_MAP_RANGE "SYSTEM_MAP_RANGE"
#define SC_DA_SQL_SYSTEM_INITIAL_POSI "SYSTEM_INITIAL_POSI"
#define SC_DA_SQL_SYSTEM_MAP_COORDINATE "SYSTEM_MAP_COORDINATE"
#define SC_DA_SQL_SYSTEM_MAP_VER "SYSTEM_MAP_VER"
#define SC_DA_SQL_SYSTEM_MAP_VER_NO "SYSTEM_MAP_VER_NO"
#define SC_DA_SQL_SYSTEM_MAP_BUILD_NO "SYSTEM_MAP_BUILD_NO"
#define SC_DA_SQL_OSM_ORIGINAL_TIMESTAMP "OSM_ORIGINAL_TIMESTAMP"
#define SC_DA_SQL_SYSTEM_SEA_FLAG "SYSTEM_SEA_FLAG"

// エリア地図データダウンロード管理テーブル(DOWNLOAD_AREA_MAP)
#define SC_DA_SQL_GET_DL_MAP_AREA_DATA "SELECT ID, KIND, COUNTRY_CODE, DISPLAY_NUM, COUNTRY_NAME, AREA_GROUP, AREA_NAME, DOWNLOAD_FLAG, BASE_VERSION, NOTE FROM DOWNLOAD_AREA_MAP WHERE KIND=?"

// (SYSTEM_INFO)
#define SC_DA_SQL_GET_SYSTEM_INFO_DATA "SELECT TYPE_CODE, INFO FROM SYSTEM_INFORMATION"

// (AREA_CLS)
#define SC_DA_SQL_GET_AREA_CLS_DATA "SELECT AREA_CLS_NAME, AREA_CLS_YOMI FROM AREA_CLS WHERE AREA_CLS3_CODE=%d AND AREA_CLS4_CODE=%d AND AREA_CLS5_CODE=%d AND AREA_CLS6_CODE=%d AND AREA_CLS2_CODE=%d AND AREA_CLS1_CODE=%d AND LAN_CD=%d"

#endif /* SMDAL_QUERY_H_ */
