#pragma once
#include <vector>
#include <string>
#include <tuple>
#include "afb-binding-common.h"
#include "jsonc_utils.hpp"

// Forward declaration
class role_t;

class interrupt_t
{
private:
	std::string type_;
	json_object* args_;
	std::vector<std::tuple<std::string, uint32_t>> applied_on_;

public:
	explicit interrupt_t() = default;
	explicit interrupt_t(const interrupt_t&) = default;
	explicit interrupt_t(interrupt_t&&) = default;
	~interrupt_t() = default;

	interrupt_t& operator=(const interrupt_t&) = default;
	interrupt_t& operator=(interrupt_t&&) = default;

	explicit interrupt_t(json_object* o);
	interrupt_t& operator<<(json_object* o);

	std::string type() const;
	json_object* args() const;

	void type(std::string v);
	void args(json_object* v);
	int apply(afb_req_t req, const role_t& role);
	void clear();
};
