/*
 * Copyright (c) 2011 Samsung Electronics Co., Ltd All Rights Reserved
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
/*
 * @file        abstract_log_provider.h
 * @author      Przemyslaw Dobrowolski (p.dobrowolsk@samsung.com)
 * @version     1.0
 * @brief       This file is the implementation file of abstract log provider
 */
#ifndef SECURITYMANAGER_ABSTRACT_LOG_PROVIDER_H
#define SECURITYMANAGER_ABSTRACT_LOG_PROVIDER_H

namespace SecurityManager {
namespace Log {
class AbstractLogProvider
{
  public:
    virtual ~AbstractLogProvider() {}

    virtual void SetTag(const char *tag);

    virtual void Debug(const char *message,
                       const char *fileName,
                       int line,
                       const char *function) = 0;
    virtual void Info(const char *message,
                      const char *fileName,
                      int line,
                      const char *function) = 0;
    virtual void Warning(const char *message,
                         const char *fileName,
                         int line,
                         const char *function) = 0;
    virtual void Error(const char *message,
                       const char *fileName,
                       int line,
                       const char *function) = 0;
    virtual void Pedantic(const char *message,
                          const char *fileName,
                          int line,
                          const char *function) = 0;

  protected:
    static const char *LocateSourceFileName(const char *filename);
};
}
} // namespace SecurityManager

#endif // SECURITYMANAGER_ABSTRACT_LOG_PROVIDER_H
