/*
 * FreeSec: libcrypt for NetBSD
 *
 * Copyright (c) 1994 David Burren
 * All rights reserved.
 *
 * Adapted for FreeBSD-2.0 by Geoffrey M. Rehmet
 *      this file should now *only* export crypt(), in order to make
 *      binaries of libcrypt exportable from the USA
 *
 * Adapted for FreeBSD-4.0 by Mark R V Murray
 *      this file should now *only* export crypt_des(), in order to make
 *      a module that can be optionally included in libcrypt.
 *
 * Adapted for libxcrypt by Zack Weinberg, 2017
 *      see notes in des.c
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This is an original implementation of the DES and the crypt(3) interfaces
 * by David Burren <davidb@werj.com.au>.
 */

#ifndef _CRYPT_ALG_DES_H
#define _CRYPT_ALG_DES_H 1

/* des.c */

struct des_ctx
{
  uint32_t keysl[16];
  uint32_t keysr[16];
  uint32_t saltbits;
};

extern void des_set_key (struct des_ctx *restrict ctx,
                         const unsigned char *key);
extern void des_set_salt (struct des_ctx *restrict ctx,
                          uint32_t salt);
extern void des_crypt_block (struct des_ctx *restrict ctx,
                             unsigned char *out, const unsigned char *in,
                             unsigned int count, bool decrypt);

/* des-tables.c (generated by des-mktables) */
extern const uint8_t m_sbox[4][4096];
extern const uint32_t ip_maskl[8][256], ip_maskr[8][256];
extern const uint32_t fp_maskl[8][256], fp_maskr[8][256];
extern const uint32_t key_perm_maskl[8][128], key_perm_maskr[8][128];
extern const uint32_t comp_maskl[8][128], comp_maskr[8][128];
extern const uint32_t psbox[4][256];

#endif /* alg-des.h */
