#!/bin/sh -efu
# Copyright (c) 2018 Dmitry V. Levin <ldv@altlinux.org>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

input="$1"
shift

cat <<EOF
/* Generated by $0 from $input; do not edit. */
#include "defs.h"
#ifdef HAVE_LINUX_BPF_H
# include <linux/bpf.h>
# include "bpf_attr.h"
# include "static_assert.h"

# define SoM(type_, member_) (sizeof(((type_ *)0)->member_))
EOF

for struct in $(sed -n 's/^struct \([^[:space:]]\+_struct\) .*/\1/p' < "$input"); do
	case "$struct" in
		BPF_*) type_name='union bpf_attr' ;;
		*) type_name="struct ${struct%_struct}" ;;
	esac
	TYPE_NAME="$(printf %s "$type_name" |tr '[:lower:] ' '[:upper:]_')"

	enum="$(sed -n 's/^struct '"$struct"' \/\* \([^[:space:]]\+\) \*\/ {.*/\1/p' < "$input")"
	ENUM="$(printf %s "$enum" |tr '[:lower:]' '[:upper:]')"
	enum="$enum${enum:+.}"
	ENUM="$ENUM${ENUM:+_}"
	sed -n '/^struct '"$struct"' [^{]*{/,/^};$/p' < "$input" |
	sed -n 's/^[[:space:]]\+[^][;]*[[:space:]]\([^][[:space:];]\+\)\(\[[^;]*\]\)\?;$/\1/p' |
	while read field; do
		FIELD="$(printf %s "$field" |tr '[:lower:]' '[:upper:]')"
		cat <<EOF

# ifdef HAVE_${TYPE_NAME}_$ENUM$FIELD
	static_assert(SoM(struct $struct, $field) == SoM($type_name, $enum$field),
		      "$struct.$field size mismatch");
	static_assert(offsetof(struct $struct, $field) == offsetof($type_name, $enum$field),
		      "$struct.$field offset mismatch");
# endif /* HAVE_${TYPE_NAME}_$ENUM$FIELD */
EOF
	done
		cat <<EOF

static_assert(${struct}_size == expected_${struct}_size,
	      "${struct}_size mismatch");
EOF

done

cat <<'EOF'

#endif /* HAVE_LINUX_BPF_H */
EOF
