/*
 * Copyright 2011-2012 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef _ASM_MPC85xx_CONFIG_H_
#define _ASM_MPC85xx_CONFIG_H_

/* SoC specific defines for Freescale MPC85xx (PQ3) and QorIQ processors */

/*
 * This macro should be removed when we no longer care about backwards
 * compatibility with older operating systems.
 */
#define CONFIG_PPC_SPINTABLE_COMPATIBLE

#include <fsl_ddrc_version.h>

/* IP endianness */
#define CONFIG_SYS_FSL_IFC_BE
#define CONFIG_SYS_FSL_SFP_BE
#define CONFIG_SYS_FSL_SEC_MON_BE

#if defined(CONFIG_ARCH_MPC8548)
#define CONFIG_SYS_FSL_SRIO_MAX_PORTS	1
#define CONFIG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CONFIG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CONFIG_SYS_FSL_RMU
#define CONFIG_SYS_FSL_SRIO_MSG_UNIT_NUM	2

#elif defined(CONFIG_ARCH_MPC8568)
#define QE_MURAM_SIZE			0x10000UL
#define MAX_QE_RISC			2
#define QE_NUM_OF_SNUM			28
#define CONFIG_SYS_FSL_SRIO_MAX_PORTS	1
#define CONFIG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CONFIG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CONFIG_SYS_FSL_RMU
#define CONFIG_SYS_FSL_SRIO_MSG_UNIT_NUM	2

#elif defined(CONFIG_ARCH_MPC8569)
#define QE_MURAM_SIZE			0x20000UL
#define MAX_QE_RISC			4
#define QE_NUM_OF_SNUM			46
#define CONFIG_SYS_FSL_SRIO_MAX_PORTS	1
#define CONFIG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CONFIG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CONFIG_SYS_FSL_RMU
#define CONFIG_SYS_FSL_SRIO_MSG_UNIT_NUM	2

#elif defined(CONFIG_ARCH_P1010)
#define CONFIG_FSL_SDHC_V2_3
#define CONFIG_TSECV2
#define CONFIG_USB_MAX_CONTROLLER_COUNT	1
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	4
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,qoriq-pcie-v2.2"
#define CONFIG_SYS_FSL_USB_INTERNAL_UTMI_PHY
#define CONFIG_SYS_FSL_USB1_PHY_ENABLE
#define CONFIG_ESDHC_HC_BLK_ADDR

/* P1011 is single core version of P1020 */
#elif defined(CONFIG_ARCH_P1011)
#define CONFIG_TSECV2
#define CONFIG_FSL_PCIE_DISABLE_ASPM
#define CONFIG_USB_MAX_CONTROLLER_COUNT	2

#elif defined(CONFIG_ARCH_P1020)
#define CONFIG_TSECV2
#define CONFIG_FSL_PCIE_DISABLE_ASPM
#ifndef CONFIG_USB_MAX_CONTROLLER_COUNT
#define CONFIG_USB_MAX_CONTROLLER_COUNT	2
#endif

#elif defined(CONFIG_ARCH_P1021)
#define CONFIG_TSECV2
#define CONFIG_FSL_PCIE_DISABLE_ASPM
#define QE_MURAM_SIZE			0x6000UL
#define MAX_QE_RISC			1
#define QE_NUM_OF_SNUM			28
#define CONFIG_USB_MAX_CONTROLLER_COUNT	1

#elif defined(CONFIG_ARCH_P1022)
#define CONFIG_TSECV2
#define CONFIG_USB_MAX_CONTROLLER_COUNT	1

#elif defined(CONFIG_ARCH_P1023)
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_NUM_FM1_DTSEC	2
#define CONFIG_USB_MAX_CONTROLLER_COUNT	1
#define CONFIG_SYS_QMAN_NUM_PORTALS	3
#define CONFIG_SYS_BMAN_NUM_PORTALS	3
#define CONFIG_SYS_FM_MURAM_SIZE	0x10000
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,qoriq-pcie-v2.2"

/* P1024 is lower end variant of P1020 */
#elif defined(CONFIG_ARCH_P1024)
#define CONFIG_TSECV2
#define CONFIG_FSL_PCIE_DISABLE_ASPM
#define CONFIG_USB_MAX_CONTROLLER_COUNT	2

/* P1025 is lower end variant of P1021 */
#elif defined(CONFIG_ARCH_P1025)
#define CONFIG_USB_MAX_CONTROLLER_COUNT	1
#define CONFIG_TSECV2
#define CONFIG_FSL_PCIE_DISABLE_ASPM
#define QE_MURAM_SIZE			0x6000UL
#define MAX_QE_RISC			1
#define QE_NUM_OF_SNUM			28

#elif defined(CONFIG_ARCH_P2020)
#define CONFIG_SYS_FSL_SRIO_MAX_PORTS	2
#define CONFIG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CONFIG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CONFIG_SYS_FSL_RMU
#define CONFIG_SYS_FSL_SRIO_MSG_UNIT_NUM	2
#define CONFIG_USB_MAX_CONTROLLER_COUNT	1

#elif defined(CONFIG_ARCH_P2041) /* also supports P2040 */
#define CONFIG_FSL_CORENET		/* Freescale CoreNet platform */
#define CONFIG_SYS_FSL_NUM_CC_PLLS	2
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_NUM_FM1_DTSEC	5
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_USB_MAX_CONTROLLER_COUNT	2
#define CONFIG_SYS_FM_MURAM_SIZE	0x28000
#define CONFIG_SYS_FSL_TBCLK_DIV	32
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,qoriq-pcie-v2.2"
#define CONFIG_SYS_FSL_USB1_PHY_ENABLE
#define CONFIG_SYS_FSL_USB2_PHY_ENABLE
#define CONFIG_SYS_FSL_USB_INTERNAL_UTMI_PHY
#define CONFIG_SYS_FSL_SRIO_MAX_PORTS	2
#define CONFIG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CONFIG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CONFIG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xf0000000

#elif defined(CONFIG_ARCH_P3041)
#define CONFIG_FSL_CORENET		/* Freescale CoreNet platform */
#define CONFIG_SYS_FSL_NUM_CC_PLLS	2
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_NUM_FM1_DTSEC	5
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_SYS_FM_MURAM_SIZE	0x28000
#define CONFIG_SYS_FSL_TBCLK_DIV	32
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,qoriq-pcie-v2.2"
#define CONFIG_SYS_FSL_USB1_PHY_ENABLE
#define CONFIG_SYS_FSL_USB2_PHY_ENABLE
#define CONFIG_SYS_FSL_USB_INTERNAL_UTMI_PHY
#define CONFIG_USB_MAX_CONTROLLER_COUNT	2
#define CONFIG_SYS_FSL_SRIO_MAX_PORTS	2
#define CONFIG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CONFIG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CONFIG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xf0000000

#elif defined(CONFIG_ARCH_P4080) /* also supports P4040 */
#define CONFIG_FSL_CORENET		/* Freescale CoreNet platform */
#define CONFIG_SYS_FSL_NUM_CC_PLLS	4
#define CONFIG_SYS_NUM_FMAN		2
#define CONFIG_SYS_NUM_FM1_DTSEC	4
#define CONFIG_SYS_NUM_FM2_DTSEC	4
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_SYS_NUM_FM2_10GEC	1
#define CONFIG_USB_MAX_CONTROLLER_COUNT	2
#define CONFIG_SYS_FM_MURAM_SIZE	0x28000
#define CONFIG_SYS_FSL_TBCLK_DIV	16
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,p4080-pcie"
#define CONFIG_SYS_FSL_SRIO_MAX_PORTS	2
#define CONFIG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CONFIG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CONFIG_SYS_FSL_RMU
#define CONFIG_SYS_FSL_SRIO_MSG_UNIT_NUM	2
#define CONFIG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xff000000

#elif defined(CONFIG_ARCH_P5020) /* also supports P5010 */
#define CONFIG_FSL_CORENET		/* Freescale CoreNet platform */
#define CONFIG_SYS_FSL_NUM_CC_PLLS	2
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_NUM_FM1_DTSEC	5
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_USB_MAX_CONTROLLER_COUNT	2
#define CONFIG_SYS_FM_MURAM_SIZE	0x28000
#define CONFIG_SYS_FSL_TBCLK_DIV	32
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,qoriq-pcie-v2.2"
#define CONFIG_SYS_FSL_USB1_PHY_ENABLE
#define CONFIG_SYS_FSL_USB2_PHY_ENABLE
#define CONFIG_SYS_FSL_USB_INTERNAL_UTMI_PHY
#define CONFIG_SYS_FSL_SRIO_MAX_PORTS	2
#define CONFIG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CONFIG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CONFIG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xc0000000

#elif defined(CONFIG_ARCH_P5040)
#define CONFIG_FSL_CORENET		/* Freescale CoreNet platform */
#define CONFIG_SYS_FSL_NUM_CC_PLLS	3
#define CONFIG_SYS_NUM_FMAN		2
#define CONFIG_SYS_NUM_FM1_DTSEC	5
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_SYS_NUM_FM2_DTSEC	5
#define CONFIG_SYS_NUM_FM2_10GEC	1
#define CONFIG_USB_MAX_CONTROLLER_COUNT	2
#define CONFIG_SYS_FM_MURAM_SIZE	0x28000
#define CONFIG_SYS_FSL_TBCLK_DIV	16
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,qoriq-pcie-v2.4"
#define CONFIG_SYS_FSL_USB1_PHY_ENABLE
#define CONFIG_SYS_FSL_USB2_PHY_ENABLE
#define CONFIG_SYS_FSL_USB_INTERNAL_UTMI_PHY
#define CONFIG_SYS_FSL_CORENET_SNOOPVEC_COREONLY 0xf0000000

#elif defined(CONFIG_ARCH_BSC9131)
#define CONFIG_FSL_SDHC_V2_3
#define CONFIG_TSECV2
#define CONFIG_USB_MAX_CONTROLLER_COUNT	1
#define CONFIG_SYS_FSL_DSP_M2_RAM_ADDR	0xb0000000
#define CONFIG_SYS_FSL_DSP_CCSRBAR_DEFAULT	0xff600000
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	3
#define CONFIG_NAND_FSL_IFC
#define CONFIG_ESDHC_HC_BLK_ADDR

#elif defined(CONFIG_ARCH_BSC9132)
#define CONFIG_FSL_SDHC_V2_3
#define CONFIG_TSECV2
#define CONFIG_USB_MAX_CONTROLLER_COUNT	1
#define CONFIG_SYS_FSL_DSP_DDR_ADDR	0x40000000
#define CONFIG_SYS_FSL_DSP_M2_RAM_ADDR	0xb0000000
#define CONFIG_SYS_FSL_DSP_M3_RAM_ADDR	0xc0000000
#define CONFIG_SYS_FSL_DSP_CCSRBAR_DEFAULT	0xff600000
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	3
#define CONFIG_NAND_FSL_IFC
#define CONFIG_SYS_FSL_ESDHC_P1010_BROKEN_SDCLK
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,qoriq-pcie-v2.2"
#define CONFIG_ESDHC_HC_BLK_ADDR

#elif defined(CONFIG_ARCH_T4240) || defined(CONFIG_ARCH_T4160)
#define CONFIG_FSL_CORENET		/* Freescale CoreNet platform */
#define CONFIG_SYS_FSL_CORES_PER_CLUSTER 4
#define CONFIG_SYS_FSL_QMAN_V3		/* QMAN version 3 */
#ifdef CONFIG_ARCH_T4240
#define CONFIG_SYS_FSL_CLUSTER_CLOCKS   { 1, 1, 4 }
#define CONFIG_SYS_NUM_FM1_DTSEC	8
#define CONFIG_SYS_NUM_FM1_10GEC	2
#define CONFIG_SYS_NUM_FM2_DTSEC	8
#define CONFIG_SYS_NUM_FM2_10GEC	2
#else
#define CONFIG_SYS_NUM_FM1_DTSEC	6
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_SYS_NUM_FM2_DTSEC	8
#define CONFIG_SYS_NUM_FM2_10GEC	1
#if defined(CONFIG_ARCH_T4160)
#define CONFIG_SYS_FSL_CLUSTER_CLOCKS	{ 1, 1 }
#endif
#endif
#define CONFIG_SYS_FSL_NUM_CC_PLLS	5
#define CONFIG_SYS_FSL_SRDS_1
#define CONFIG_SYS_FSL_SRDS_2
#define CONFIG_SYS_FSL_SRDS_3
#define CONFIG_SYS_FSL_SRDS_4
#define CONFIG_SYS_NUM_FMAN		2
#define CONFIG_USB_MAX_CONTROLLER_COUNT	2
#define CONFIG_SYS_PME_CLK		0
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	8
#define CONFIG_SYS_FMAN_V3
#define CONFIG_SYS_FM1_CLK		3
#define CONFIG_SYS_FM2_CLK		3
#define CONFIG_SYS_FM_MURAM_SIZE	0x60000
#define CONFIG_SYS_FSL_TBCLK_DIV	16
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,qoriq-pcie-v3.0"
#define CONFIG_SYS_FSL_SRIO_MAX_PORTS	2
#define CONFIG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CONFIG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CONFIG_SYS_FSL_SRIO_LIODN
#define CONFIG_SYS_FSL_USB_DUAL_PHY_ENABLE
#define CONFIG_SYS_FSL_USB_INTERNAL_UTMI_PHY
#define CONFIG_SYS_FSL_SFP_VER_3_0
#define CONFIG_SYS_FSL_PCI_VER_3_X

#elif defined(CONFIG_ARCH_B4860) || defined(CONFIG_ARCH_B4420)
#define CONFIG_FSL_CORENET		/* Freescale CoreNet platform */
#define CONFIG_SYS_FSL_QMAN_V3		/* QMAN version 3 */
#define CONFIG_HETROGENOUS_CLUSTERS     /* DSP/SC3900 core clusters */
#define CONFIG_PPC_CLUSTER_START	0 /*Start index of ppc clusters*/
#define CONFIG_DSP_CLUSTER_START	1 /*Start index of dsp clusters*/
#define CONFIG_SYS_FSL_SRDS_1
#define CONFIG_SYS_FSL_SRDS_2
#define CONFIG_SYS_MAPLE
#define CONFIG_SYS_CPRI
#define CONFIG_SYS_FSL_NUM_CC_PLLS	5
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_USB_MAX_CONTROLLER_COUNT	1
#define CONFIG_SYS_FM1_CLK		0
#define CONFIG_SYS_CPRI_CLK		3
#define CONFIG_SYS_ULB_CLK		4
#define CONFIG_SYS_ETVPE_CLK		1
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	4
#define CONFIG_SYS_FMAN_V3
#define CONFIG_SYS_FM_MURAM_SIZE	0x60000
#define CONFIG_SYS_FSL_TBCLK_DIV	16
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,qoriq-pcie-v2.4"
#define CONFIG_SYS_FSL_USB1_PHY_ENABLE
#define CONFIG_SYS_FSL_SFP_VER_3_0

#ifdef CONFIG_ARCH_B4860
#define CONFIG_SYS_FSL_CORES_PER_CLUSTER 4
#define CONFIG_MAX_DSP_CPUS		12
#define CONFIG_NUM_DSP_CPUS		6
#define CONFIG_SYS_FSL_SRDS_NUM_PLLS	2
#define CONFIG_SYS_FSL_CLUSTER_CLOCKS	{ 1, 4, 4, 4 }
#define CONFIG_SYS_NUM_FM1_DTSEC	6
#define CONFIG_SYS_NUM_FM1_10GEC	2
#define CONFIG_USB_MAX_CONTROLLER_COUNT	1
#define CONFIG_SYS_FSL_SRIO_MAX_PORTS	2
#define CONFIG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CONFIG_SYS_FSL_SRIO_IB_WIN_NUM	5
#define CONFIG_SYS_FSL_SRIO_LIODN
#else
#define CONFIG_MAX_DSP_CPUS		2
#define CONFIG_SYS_FSL_SRDS_NUM_PLLS	1
#define CONFIG_SYS_FSL_CORES_PER_CLUSTER 2
#define CONFIG_SYS_FSL_CLUSTER_CLOCKS	{ 1, 4 }
#define CONFIG_SYS_NUM_FM1_DTSEC	4
#define CONFIG_SYS_NUM_FM1_10GEC	0
#endif

#elif defined(CONFIG_ARCH_T1040) || defined(CONFIG_ARCH_T1042)
#define CONFIG_E5500
#define CONFIG_FSL_CORENET		/* Freescale CoreNet platform */
#define CONFIG_SYS_FSL_CORES_PER_CLUSTER 1
#define CONFIG_SYS_FSL_QMAN_V3		/* QMAN version 3 */
#define CONFIG_SYS_FSL_NUM_CC_PLLS	2
#define CONFIG_SYS_FSL_CLUSTER_CLOCKS   { 1, 1, 1, 1 }
#define CONFIG_SYS_FSL_SRDS_1
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_NUM_FM1_DTSEC	5
#define CONFIG_USB_MAX_CONTROLLER_COUNT	2
#define CONFIG_PME_PLAT_CLK_DIV		2
#define CONFIG_SYS_PME_CLK		CONFIG_PME_PLAT_CLK_DIV
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	8
#define CONFIG_SYS_FMAN_V3
#define CONFIG_FM_PLAT_CLK_DIV	1
#define CONFIG_SYS_FM1_CLK		CONFIG_FM_PLAT_CLK_DIV
#define CONFIG_SYS_SDHC_CLK		0/* Select SDHC CLK begining from PLL1
					    per rcw field value */
#define CONFIG_SYS_SDHC_CLK_2_PLL	/* Select SDHC CLK from 2 PLLs */
#define CONFIG_SYS_FM_MURAM_SIZE	0x30000
#define CONFIG_SYS_FSL_SINGLE_SOURCE_CLK
#define CONFIG_SYS_FSL_TBCLK_DIV	16
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,qoriq-pcie-v2.4"
#define CONFIG_SYS_FSL_USB_DUAL_PHY_ENABLE
#define CONFIG_SYS_FSL_USB_INTERNAL_UTMI_PHY
#define ESDHCI_QUIRK_BROKEN_TIMEOUT_VALUE
#define QE_MURAM_SIZE			0x6000UL
#define MAX_QE_RISC			1
#define QE_NUM_OF_SNUM			28
#define CONFIG_SYS_FSL_SFP_VER_3_0

#elif defined(CONFIG_ARCH_T1024) || defined(CONFIG_ARCH_T1023)
#define CONFIG_E5500
#define CONFIG_FSL_CORENET	     /* Freescale CoreNet platform */
#define CONFIG_SYS_FSL_CORES_PER_CLUSTER 1
#define CONFIG_SYS_FSL_QMAN_V3	 /* QMAN version 3 */
#define CONFIG_SYS_FMAN_V3
#define CONFIG_SYS_FSL_NUM_CC_PLL	2
#define CONFIG_SYS_FSL_CLUSTER_CLOCKS  { 1, 1, 1, 1 }
#define CONFIG_SYS_FSL_SRDS_1
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_NUM_FM1_DTSEC	4
#define CONFIG_SYS_NUM_FM1_10GEC	1
#define CONFIG_FSL_FM_10GEC_REGULAR_NOTATION
#define CONFIG_USB_MAX_CONTROLLER_COUNT	2
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	8
#define CONFIG_SYS_FM1_CLK		0
#define CONFIG_SYS_SDHC_CLK		0/* Select SDHC CLK begining from PLL1
					    per rcw field value */
#define CONFIG_QBMAN_CLK_DIV		1
#define CONFIG_SYS_FM_MURAM_SIZE	0x30000
#define CONFIG_SYS_FSL_SINGLE_SOURCE_CLK
#define CONFIG_SYS_FSL_TBCLK_DIV	16
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,qoriq-pcie-v2.4"
#define CONFIG_SYS_FSL_USB_DUAL_PHY_ENABLE
#define CONFIG_SYS_FSL_USB_INTERNAL_UTMI_PHY
#define ESDHCI_QUIRK_BROKEN_TIMEOUT_VALUE
#define QE_MURAM_SIZE			0x6000UL
#define MAX_QE_RISC			1
#define QE_NUM_OF_SNUM			28
#define CONFIG_SYS_FSL_SFP_VER_3_0

#elif defined(CONFIG_ARCH_T2080) || defined(CONFIG_ARCH_T2081)
#define CONFIG_FSL_CORENET		/* Freescale CoreNet platform */
#define CONFIG_SYS_FSL_CORES_PER_CLUSTER 4
#define CONFIG_SYS_FSL_NUM_CC_PLLS	2
#define CONFIG_SYS_FSL_QMAN_V3
#define CONFIG_SYS_NUM_FMAN		1
#define CONFIG_SYS_FSL_CLUSTER_CLOCKS	{ 1, 4, 4, 4 }
#define CONFIG_SYS_FSL_SRDS_1
#define CONFIG_SYS_FSL_PCI_VER_3_X
#if defined(CONFIG_ARCH_T2080)
#define CONFIG_SYS_NUM_FM1_DTSEC	8
#define CONFIG_SYS_NUM_FM1_10GEC	4
#define CONFIG_SYS_FSL_SRDS_2
#define CONFIG_SYS_FSL_SRIO_LIODN
#define CONFIG_SYS_FSL_SRIO_MAX_PORTS	2
#define CONFIG_SYS_FSL_SRIO_OB_WIN_NUM	9
#define CONFIG_SYS_FSL_SRIO_IB_WIN_NUM	5
#elif defined(CONFIG_ARCH_T2081)
#define CONFIG_SYS_NUM_FM1_DTSEC	6
#define CONFIG_SYS_NUM_FM1_10GEC	2
#endif
#define CONFIG_USB_MAX_CONTROLLER_COUNT 2
#define CONFIG_PME_PLAT_CLK_DIV		1
#define CONFIG_SYS_PME_CLK		CONFIG_PME_PLAT_CLK_DIV
#define CONFIG_SYS_FM1_CLK		0
#define CONFIG_SYS_SDHC_CLK		1/* Select SDHC CLK begining from PLL2
					    per rcw field value */
#define CONFIG_SYS_SDHC_CLK_2_PLL	/* Select SDHC CLK from 2 PLLs */
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	8
#define CONFIG_SYS_FMAN_V3
#define CONFIG_SYS_FM_MURAM_SIZE	0x28000
#define CONFIG_SYS_FSL_TBCLK_DIV	16
#define CONFIG_SYS_FSL_PCIE_COMPAT	"fsl,qoriq-pcie-v3.0"
#define CONFIG_SYS_FSL_USB_DUAL_PHY_ENABLE
#define CONFIG_SYS_FSL_USB_INTERNAL_UTMI_PHY
#define CONFIG_SYS_FSL_SFP_VER_3_0
#define CONFIG_SYS_FSL_ISBC_VER		2
#define ESDHCI_QUIRK_BROKEN_TIMEOUT_VALUE
#define CONFIG_SYS_FSL_SFP_VER_3_0


#elif defined(CONFIG_ARCH_C29X)
#define CONFIG_FSL_SDHC_V2_3
#define CONFIG_TSECV2_1
#define CONFIG_SYS_FSL_IFC_BANK_COUNT	8
#define CONFIG_SYS_FSL_MAX_NUM_OF_SEC	3
#define CONFIG_SYS_FSL_SEC_IDX_OFFSET	0x20000

#endif

#if !defined(CONFIG_ARCH_C29X)
#define CONFIG_SYS_FSL_MAX_NUM_OF_SEC	1
#endif

#endif /* _ASM_MPC85xx_CONFIG_H_ */
