/*
 * Freescale i.MX23/i.MX28 Peripheral Base Addresses
 *
 * Copyright (C) 2011 Marek Vasut <marek.vasut@gmail.com>
 * on behalf of DENX Software Engineering GmbH
 *
 * Based on code from LTIB:
 * Copyright (C) 2008 Embedded Alley Solutions Inc.
 *
 * (C) Copyright 2009-2010 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef __MXS_REGS_BASE_H__
#define __MXS_REGS_BASE_H__

/*
 * Register base addresses for i.MX23
 */
#if defined(CONFIG_MX23)
#define	MXS_ICOLL_BASE		0x80000000
#define	MXS_APBH_BASE		0x80004000
#define	MXS_ECC8_BASE		0x80008000
#define	MXS_BCH_BASE		0x8000A000
#define	MXS_GPMI_BASE		0x8000C000
#define	MXS_SSP0_BASE		0x80010000
#define	MXS_SSP1_BASE		0x80034000
#define	MXS_ETM_BASE		0x80014000
#define	MXS_PINCTRL_BASE	0x80018000
#define	MXS_DIGCTL_BASE		0x8001C000
#define	MXS_EMI_BASE		0x80020000
#define	MXS_APBX_BASE		0x80024000
#define	MXS_DCP_BASE		0x80028000
#define	MXS_PXP_BASE		0x8002A000
#define	MXS_OCOTP_BASE		0x8002C000
#define	MXS_AXI_BASE		0x8002E000
#define	MXS_LCDIF_BASE		0x80030000
#define	MXS_SSP1_BASE		0x80034000
#define	MXS_TVENC_BASE		0x80038000
#define	MXS_CLKCTRL_BASE	0x80040000
#define	MXS_SAIF0_BASE		0x80042000
#define	MXS_POWER_BASE		0x80044000
#define	MXS_SAIF1_BASE		0x80046000
#define	MXS_AUDIOOUT_BASE	0x80048000
#define	MXS_AUDIOIN_BASE	0x8004C000
#define	MXS_LRADC_BASE		0x80050000
#define	MXS_SPDIF_BASE		0x80054000
#define	MXS_I2C0_BASE		0x80058000
#define	MXS_RTC_BASE		0x8005C000
#define	MXS_PWM_BASE		0x80064000
#define	MXS_TIMROT_BASE		0x80068000
#define	MXS_UARTAPP0_BASE	0x8006C000
#define	MXS_UARTAPP1_BASE	0x8006E000
#define	MXS_UARTDBG_BASE	0x80070000
#define	MXS_USBPHY0_BASE	0x8007C000
#define	MXS_USBCTRL0_BASE	0x80080000
#define	MXS_DRAM_BASE		0x800E0000

/*
 * Register base addresses for i.MX28
 */
#elif defined(CONFIG_MX28)
#define	MXS_ICOL_BASE		0x80000000
#define	MXS_HSADC_BASE		0x80002000
#define	MXS_APBH_BASE		0x80004000
#define	MXS_PERFMON_BASE	0x80006000
#define	MXS_BCH_BASE		0x8000A000
#define	MXS_GPMI_BASE		0x8000C000
#define	MXS_SSP0_BASE		0x80010000
#define	MXS_SSP1_BASE		0x80012000
#define	MXS_SSP2_BASE		0x80014000
#define	MXS_SSP3_BASE		0x80016000
#define	MXS_PINCTRL_BASE	0x80018000
#define	MXS_DIGCTL_BASE		0x8001C000
#define	MXS_ETM_BASE		0x80022000
#define	MXS_APBX_BASE		0x80024000
#define	MXS_DCP_BASE		0x80028000
#define	MXS_PXP_BASE		0x8002A000
#define	MXS_OCOTP_BASE		0x8002C000
#define	MXS_AXI_AHB0_BASE	0x8002E000
#define	MXS_LCDIF_BASE		0x80030000
#define	MXS_CAN0_BASE		0x80032000
#define	MXS_CAN1_BASE		0x80034000
#define	MXS_SIMDBG_BASE		0x8003C000
#define	MXS_SIMGPMISEL_BASE	0x8003C200
#define	MXS_SIMSSPSEL_BASE	0x8003C300
#define	MXS_SIMMEMSEL_BASE	0x8003C400
#define	MXS_GPIOMON_BASE	0x8003C500
#define	MXS_SIMENET_BASE	0x8003C700
#define	MXS_ARMJTAG_BASE	0x8003C800
#define	MXS_CLKCTRL_BASE	0x80040000
#define	MXS_SAIF0_BASE		0x80042000
#define	MXS_POWER_BASE		0x80044000
#define	MXS_SAIF1_BASE		0x80046000
#define	MXS_LRADC_BASE		0x80050000
#define	MXS_SPDIF_BASE		0x80054000
#define	MXS_RTC_BASE		0x80056000
#define	MXS_I2C0_BASE		0x80058000
#define	MXS_I2C1_BASE		0x8005A000
#define	MXS_PWM_BASE		0x80064000
#define	MXS_TIMROT_BASE		0x80068000
#define	MXS_UARTAPP0_BASE	0x8006A000
#define	MXS_UARTAPP1_BASE	0x8006C000
#define	MXS_UARTAPP2_BASE	0x8006E000
#define	MXS_UARTAPP3_BASE	0x80070000
#define	MXS_UARTAPP4_BASE	0x80072000
#define	MXS_UARTDBG_BASE	0x80074000
#define	MXS_USBPHY0_BASE	0x8007C000
#define	MXS_USBPHY1_BASE	0x8007E000
#define	MXS_USBCTRL0_BASE	0x80080000
#define	MXS_USBCTRL1_BASE	0x80090000
#define	MXS_DFLPT_BASE		0x800C0000
#define	MXS_DRAM_BASE		0x800E0000
#define	MXS_ENET0_BASE		0x800F0000
#define	MXS_ENET1_BASE		0x800F4000
#else
#error Unkown SoC. Please set CONFIG_MX23 or CONFIG_MX28
#endif

#endif /* __MXS_REGS_BASE_H__ */
