/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2015  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD_SET_PRONUNCIATION_RULE_H
#define NJD_SET_PRONUNCIATION_RULE_H

#ifdef __cplusplus
#define NJD_SET_PRONUNCIATION_RULE_H_START extern "C" {
#define NJD_SET_PRONUNCIATION_RULE_H_END   }
#else
#define NJD_SET_PRONUNCIATION_RULE_H_START
#define NJD_SET_PRONUNCIATION_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD_SET_PRONUNCIATION_RULE_H_START;

static const char *njd_set_pronunciation_list[] = {
   "\xa5\xf4\xa5\xe7", "\xa5\xf4\xa5\xe7", "1",
   "\xa5\xf4\xa5\xe5", "\xa5\xf4\xa5\xe5", "1",
   "\xa5\xf4\xa5\xe3", "\xa5\xf4\xa5\xe3", "1",
   "\xa5\xf4\xa5\xa9", "\xa5\xf4\xa5\xa9", "1",
   "\xa5\xf4\xa5\xa7", "\xa5\xf4\xa5\xa7", "1",
   "\xa5\xf4\xa5\xa3", "\xa5\xf4\xa5\xa3", "1",
   "\xa5\xf4\xa5\xa1", "\xa5\xf4\xa5\xa1", "1",
   "\xa5\xf4", "\xa5\xf4", "1",
   "\xa5\xf3", "\xa5\xf3", "1",
   "\xa5\xf2", "\xa5\xf2", "1",
   "\xa5\xf1", "\xa5\xf1", "1",
   "\xa5\xf0", "\xa5\xf0", "1",
   "\xa5\xef", "\xa5\xef", "1",
   "\xa5\xed", "\xa5\xed", "1",
   "\xa5\xec", "\xa5\xec", "1",
   "\xa5\xeb", "\xa5\xeb", "1",
   "\xa5\xea\xa5\xe7", "\xa5\xea\xa5\xe7", "1",
   "\xa5\xea\xa5\xe5", "\xa5\xea\xa5\xe5", "1",
   "\xa5\xea\xa5\xe3", "\xa5\xea\xa5\xe3", "1",
   "\xa5\xea\xa5\xa7", "\xa5\xea\xa5\xa7", "1",
   "\xa5\xea", "\xa5\xea", "1",
   "\xa5\xe9", "\xa5\xe9", "1",
   "\xa5\xe8", "\xa5\xe8", "1",
   "\xa5\xe7", "\xa5\xe7", "1",
   "\xa5\xe6", "\xa5\xe6", "1",
   "\xa5\xe5", "\xa5\xe5", "1",
   "\xa5\xe4", "\xa5\xe4", "1",
   "\xa5\xe3", "\xa5\xe3", "1",
   "\xa5\xe2", "\xa5\xe2", "1",
   "\xa5\xe1", "\xa5\xe1", "1",
   "\xa5\xe0", "\xa5\xe0", "1",
   "\xa5\xdf\xa5\xe7", "\xa5\xdf\xa5\xe7", "1",
   "\xa5\xdf\xa5\xe5", "\xa5\xdf\xa5\xe5", "1",
   "\xa5\xdf\xa5\xe3", "\xa5\xdf\xa5\xe3", "1",
   "\xa5\xdf\xa5\xa7", "\xa5\xdf\xa5\xa7", "1",
   "\xa5\xdf", "\xa5\xdf", "1",
   "\xa5\xde", "\xa5\xde", "1",
   "\xa5\xdd", "\xa5\xdd", "1",
   "\xa5\xdc", "\xa5\xdc", "1",
   "\xa5\xdb", "\xa5\xdb", "1",
   "\xa5\xda", "\xa5\xda", "1",
   "\xa5\xd9", "\xa5\xd9", "1",
   "\xa5\xd8", "\xa5\xd8", "1",
   "\xa5\xd7", "\xa5\xd7", "1",
   "\xa5\xd6", "\xa5\xd6", "1",
   "\xa5\xd5\xa5\xa9", "\xa5\xd5\xa5\xa9", "1",
   "\xa5\xd5\xa5\xa7", "\xa5\xd5\xa5\xa7", "1",
   "\xa5\xd5\xa5\xa3", "\xa5\xd5\xa5\xa3", "1",
   "\xa5\xd5\xa5\xa1", "\xa5\xd5\xa5\xa1", "1",
   "\xa5\xd5", "\xa5\xd5", "1",
   "\xa5\xd4\xa5\xe7", "\xa5\xd4\xa5\xe7", "1",
   "\xa5\xd4\xa5\xe5", "\xa5\xd4\xa5\xe5", "1",
   "\xa5\xd4\xa5\xe3", "\xa5\xd4\xa5\xe3", "1",
   "\xa5\xd4\xa5\xa7", "\xa5\xd4\xa5\xa7", "1",
   "\xa5\xd4", "\xa5\xd4", "1",
   "\xa5\xd3\xa5\xe7", "\xa5\xd3\xa5\xe7", "1",
   "\xa5\xd3\xa5\xe5", "\xa5\xd3\xa5\xe5", "1",
   "\xa5\xd3\xa5\xe3", "\xa5\xd3\xa5\xe3", "1",
   "\xa5\xd3\xa5\xa7", "\xa5\xd3\xa5\xa7", "1",
   "\xa5\xd3", "\xa5\xd3", "1",
   "\xa5\xd2\xa5\xe7", "\xa5\xd2\xa5\xe7", "1",
   "\xa5\xd2\xa5\xe5", "\xa5\xd2\xa5\xe5", "1",
   "\xa5\xd2\xa5\xe3", "\xa5\xd2\xa5\xe3", "1",
   "\xa5\xd2\xa5\xa7", "\xa5\xd2\xa5\xa7", "1",
   "\xa5\xd2", "\xa5\xd2", "1",
   "\xa5\xd1", "\xa5\xd1", "1",
   "\xa5\xd0", "\xa5\xd0", "1",
   "\xa5\xcf", "\xa5\xcf", "1",
   "\xa5\xce", "\xa5\xce", "1",
   "\xa5\xcd", "\xa5\xcd", "1",
   "\xa5\xcc", "\xa5\xcc", "1",
   "\xa5\xcb\xa5\xe7", "\xa5\xcb\xa5\xe7", "1",
   "\xa5\xcb\xa5\xe5", "\xa5\xcb\xa5\xe5", "1",
   "\xa5\xcb\xa5\xe3", "\xa5\xcb\xa5\xe3", "1",
   "\xa5\xcb\xa5\xa7", "\xa5\xcb\xa5\xa7", "1",
   "\xa5\xcb", "\xa5\xcb", "1",
   "\xa5\xca", "\xa5\xca", "1",
   "\xa5\xc9\xa5\xa5", "\xa5\xc9\xa5\xa5", "1",
   "\xa5\xc9", "\xa5\xc9", "1",
   "\xa5\xc8\xa5\xa5", "\xa5\xc8\xa5\xa5", "1",
   "\xa5\xc8", "\xa5\xc8", "1",
   "\xa5\xc7\xa5\xe7", "\xa5\xc7\xa5\xe7", "1",
   "\xa5\xc7\xa5\xe5", "\xa5\xc7\xa5\xe5", "1",
   "\xa5\xc7\xa5\xe3", "\xa5\xc7\xa5\xe3", "1",
   "\xa5\xc7\xa5\xa3", "\xa5\xc7\xa5\xa3", "1",
   "\xa5\xc7", "\xa5\xc7", "1",
   "\xa5\xc6\xa5\xe7", "\xa5\xc6\xa5\xe7", "1",
   "\xa5\xc6\xa5\xe5", "\xa5\xc6\xa5\xe5", "1",
   "\xa5\xc6\xa5\xe3", "\xa5\xc6\xa5\xe3", "1",
   "\xa5\xc6\xa5\xa3", "\xa5\xc6\xa5\xa3", "1",
   "\xa5\xc6", "\xa5\xc6", "1",
   "\xa5\xc5", "\xa5\xc5", "1",
   "\xa5\xc4\xa5\xa9", "\xa5\xc4\xa5\xa9", "1",
   "\xa5\xc4\xa5\xa7", "\xa5\xc4\xa5\xa7", "1",
   "\xa5\xc4\xa5\xa3", "\xa5\xc4\xa5\xa3", "1",
   "\xa5\xc4\xa5\xa1", "\xa5\xc4\xa5\xa1", "1",
   "\xa5\xc4", "\xa5\xc4", "1",
   "\xa5\xc3", "\xa5\xc3", "1",
   "\xa5\xc2", "\xa5\xc2", "1",
   "\xa5\xc1\xa5\xe7", "\xa5\xc1\xa5\xe7", "1",
   "\xa5\xc1\xa5\xe5", "\xa5\xc1\xa5\xe5", "1",
   "\xa5\xc1\xa5\xe3", "\xa5\xc1\xa5\xe3", "1",
   "\xa5\xc1\xa5\xa7", "\xa5\xc1\xa5\xa7", "1",
   "\xa5\xc1", "\xa5\xc1", "1",
   "\xa5\xc0", "\xa5\xc0", "1",
   "\xa5\xbf", "\xa5\xbf", "1",
   "\xa5\xbe", "\xa5\xbe", "1",
   "\xa5\xbd", "\xa5\xbd", "1",
   "\xa5\xbc", "\xa5\xbc", "1",
   "\xa5\xbb", "\xa5\xbb", "1",
   "\xa5\xba\xa5\xa3", "\xa5\xba\xa5\xa3", "1",
   "\xa5\xba", "\xa5\xba", "1",
   "\xa5\xb9\xa5\xa3", "\xa5\xb9\xa5\xa3", "1",
   "\xa5\xb9", "\xa5\xb9", "1",
   "\xa5\xb8\xa5\xe7", "\xa5\xb8\xa5\xe7", "1",
   "\xa5\xb8\xa5\xe5", "\xa5\xb8\xa5\xe5", "1",
   "\xa5\xb8\xa5\xe3", "\xa5\xb8\xa5\xe3", "1",
   "\xa5\xb8\xa5\xa7", "\xa5\xb8\xa5\xa7", "1",
   "\xa5\xb8", "\xa5\xb8", "1",
   "\xa5\xb7\xa5\xe7", "\xa5\xb7\xa5\xe7", "1",
   "\xa5\xb7\xa5\xe5", "\xa5\xb7\xa5\xe5", "1",
   "\xa5\xb7\xa5\xe3", "\xa5\xb7\xa5\xe3", "1",
   "\xa5\xb7\xa5\xa7", "\xa5\xb7\xa5\xa7", "1",
   "\xa5\xb7", "\xa5\xb7", "1",
   "\xa5\xb6", "\xa5\xb6", "1",
   "\xa5\xb5", "\xa5\xb5", "1",
   "\xa5\xb4", "\xa5\xb4", "1",
   "\xa5\xb3", "\xa5\xb3", "1",
   "\xa5\xb2", "\xa5\xb2", "1",
   "\xa5\xb1", "\xa5\xb1", "1",
   "\xa5\xb0", "\xa5\xb0", "1",
   "\xa5\xaf", "\xa5\xaf", "1",
   "\xa5\xae\xa5\xe7", "\xa5\xae\xa5\xe7", "1",
   "\xa5\xae\xa5\xe5", "\xa5\xae\xa5\xe5", "1",
   "\xa5\xae\xa5\xe3", "\xa5\xae\xa5\xe3", "1",
   "\xa5\xae\xa5\xa7", "\xa5\xae\xa5\xa7", "1",
   "\xa5\xae", "\xa5\xae", "1",
   "\xa5\xad\xa5\xe7", "\xa5\xad\xa5\xe7", "1",
   "\xa5\xad\xa5\xe5", "\xa5\xad\xa5\xe5", "1",
   "\xa5\xad\xa5\xe3", "\xa5\xad\xa5\xe3", "1",
   "\xa5\xad\xa5\xa7", "\xa5\xad\xa5\xa7", "1",
   "\xa5\xad", "\xa5\xad", "1",
   "\xa5\xac", "\xa5\xac", "1",
   "\xa5\xab", "\xa5\xab", "1",
   "\xa5\xaa", "\xa5\xaa", "1",
   "\xa5\xa9", "\xa5\xa9", "1",
   "\xa5\xa8", "\xa5\xa8", "1",
   "\xa5\xa7", "\xa5\xa7", "1",
   "\xa5\xa6\xa5\xa9", "\xa5\xa6\xa5\xa9", "1",
   "\xa5\xa6\xa5\xa7", "\xa5\xa6\xa5\xa7", "1",
   "\xa5\xa6\xa5\xa3", "\xa5\xa6\xa5\xa3", "1",
   "\xa5\xa6", "\xa5\xa6", "1",
   "\xa5\xa5", "\xa5\xa5", "1",
   "\xa5\xa4\xa5\xa7", "\xa5\xa4\xa5\xa7", "1",
   "\xa5\xa4", "\xa5\xa4", "1",
   "\xa5\xa3", "\xa5\xa3", "1",
   "\xa5\xa2", "\xa5\xa2", "1",
   "\xa5\xa1", "\xa5\xa1", "1",
   "\xa5\xf4\xa4\xe7", "\xa5\xf4\xa5\xe7", "1", /* none in this charcode */
   "\xa5\xf4\xa4\xe5", "\xa5\xf4\xa5\xe5", "1", /* none in this charcode */
   "\xa5\xf4\xa4\xe3", "\xa5\xf4\xa5\xe3", "1", /* none in this charcode */
   "\xa5\xf4\xa4\xa9", "\xa5\xf4\xa5\xa9", "1", /* none in this charcode */
   "\xa5\xf4\xa4\xa7", "\xa5\xf4\xa5\xa7", "1", /* none in this charcode */
   "\xa5\xf4\xa4\xa3", "\xa5\xf4\xa5\xa3", "1", /* none in this charcode */
   "\xa5\xf4\xa4\xa1", "\xa5\xf4\xa5\xa1", "1", /* none in this charcode */
   "\xa5\xf4", "\xa5\xf4", "1", /* none in this charcode */
   "\xa4\xf3", "\xa5\xf3", "1",
   "\xa4\xf2", "\xa5\xf2", "1",
   "\xa4\xf1", "\xa5\xf1", "1",
   "\xa4\xf0", "\xa5\xf0", "1",
   "\xa4\xef", "\xa5\xef", "1",
   "\xa4\xed", "\xa5\xed", "1",
   "\xa4\xec", "\xa5\xec", "1",
   "\xa4\xeb", "\xa5\xeb", "1",
   "\xa4\xea\xa4\xe7", "\xa5\xea\xa5\xe7", "1",
   "\xa4\xea\xa4\xe5", "\xa5\xea\xa5\xe5", "1",
   "\xa4\xea\xa4\xe3", "\xa5\xea\xa5\xe3", "1",
   "\xa4\xea\xa4\xa7", "\xa5\xea\xa5\xa7", "1",
   "\xa4\xea", "\xa5\xea", "1",
   "\xa4\xe9", "\xa5\xe9", "1",
   "\xa4\xe8", "\xa5\xe8", "1",
   "\xa4\xe7", "\xa5\xe7", "1",
   "\xa4\xe6", "\xa5\xe6", "1",
   "\xa4\xe5", "\xa5\xe5", "1",
   "\xa4\xe4", "\xa5\xe4", "1",
   "\xa4\xe3", "\xa5\xe3", "1",
   "\xa4\xe2", "\xa5\xe2", "1",
   "\xa4\xe1", "\xa5\xe1", "1",
   "\xa4\xe0", "\xa5\xe0", "1",
   "\xa4\xdf\xa4\xe7", "\xa5\xdf\xa5\xe7", "1",
   "\xa4\xdf\xa4\xe5", "\xa5\xdf\xa5\xe5", "1",
   "\xa4\xdf\xa4\xe3", "\xa5\xdf\xa5\xe3", "1",
   "\xa4\xdf\xa4\xa7", "\xa5\xdf\xa5\xa7", "1",
   "\xa4\xdf", "\xa5\xdf", "1",
   "\xa4\xde", "\xa5\xde", "1",
   "\xa4\xdd", "\xa5\xdd", "1",
   "\xa4\xdc", "\xa5\xdc", "1",
   "\xa4\xdb", "\xa5\xdb", "1",
   "\xa4\xda", "\xa5\xda", "1",
   "\xa4\xd9", "\xa5\xd9", "1",
   "\xa4\xd8", "\xa5\xd8", "1",
   "\xa4\xd7", "\xa5\xd7", "1",
   "\xa4\xd6", "\xa5\xd6", "1",
   "\xa4\xd5\xa4\xa9", "\xa5\xd5\xa5\xa9", "1",
   "\xa4\xd5\xa4\xa7", "\xa5\xd5\xa5\xa7", "1",
   "\xa4\xd5\xa4\xa3", "\xa5\xd5\xa5\xa3", "1",
   "\xa4\xd5\xa4\xa1", "\xa5\xd5\xa5\xa1", "1",
   "\xa4\xd5", "\xa5\xd5", "1",
   "\xa4\xd4\xa4\xe7", "\xa5\xd4\xa5\xe7", "1",
   "\xa4\xd4\xa4\xe5", "\xa5\xd4\xa5\xe5", "1",
   "\xa4\xd4\xa4\xe3", "\xa5\xd4\xa5\xe3", "1",
   "\xa4\xd4\xa4\xa7", "\xa5\xd4\xa5\xa7", "1",
   "\xa4\xd4", "\xa5\xd4", "1",
   "\xa4\xd3\xa4\xe7", "\xa5\xd3\xa5\xe7", "1",
   "\xa4\xd3\xa4\xe5", "\xa5\xd3\xa5\xe5", "1",
   "\xa4\xd3\xa4\xe3", "\xa5\xd3\xa5\xe3", "1",
   "\xa4\xd3\xa4\xa7", "\xa5\xd3\xa5\xa7", "1",
   "\xa4\xd3", "\xa5\xd3", "1",
   "\xa4\xd2\xa4\xe7", "\xa5\xd2\xa5\xe7", "1",
   "\xa4\xd2\xa4\xe5", "\xa5\xd2\xa5\xe5", "1",
   "\xa4\xd2\xa4\xe3", "\xa5\xd2\xa5\xe3", "1",
   "\xa4\xd2\xa4\xa7", "\xa5\xd2\xa5\xa7", "1",
   "\xa4\xd2", "\xa5\xd2", "1",
   "\xa4\xd1", "\xa5\xd1", "1",
   "\xa4\xd0", "\xa5\xd0", "1",
   "\xa4\xcf", "\xa5\xcf", "1",
   "\xa4\xce", "\xa5\xce", "1",
   "\xa4\xcd", "\xa5\xcd", "1",
   "\xa4\xcc", "\xa5\xcc", "1",
   "\xa4\xcb\xa4\xe7", "\xa5\xcb\xa5\xe7", "1",
   "\xa4\xcb\xa4\xe5", "\xa5\xcb\xa5\xe5", "1",
   "\xa4\xcb\xa4\xe3", "\xa5\xcb\xa5\xe3", "1",
   "\xa4\xcb\xa4\xa7", "\xa5\xcb\xa5\xa7", "1",
   "\xa4\xcb", "\xa5\xcb", "1",
   "\xa4\xca", "\xa5\xca", "1",
   "\xa4\xc9\xa4\xa5", "\xa5\xc9\xa5\xa5", "1",
   "\xa4\xc9", "\xa5\xc9", "1",
   "\xa4\xc8\xa4\xa5", "\xa5\xc8\xa5\xa5", "1",
   "\xa4\xc8", "\xa5\xc8", "1",
   "\xa4\xc7\xa4\xe7", "\xa5\xc7\xa5\xe7", "1",
   "\xa4\xc7\xa4\xe5", "\xa5\xc7\xa5\xe5", "1",
   "\xa4\xc7\xa4\xe3", "\xa5\xc7\xa5\xe3", "1",
   "\xa4\xc7\xa4\xa3", "\xa5\xc7\xa5\xa3", "1",
   "\xa4\xc7", "\xa5\xc7", "1",
   "\xa4\xc6\xa4\xe7", "\xa5\xc6\xa5\xe7", "1",
   "\xa4\xc6\xa4\xe5", "\xa5\xc6\xa5\xe5", "1",
   "\xa4\xc6\xa4\xe3", "\xa5\xc6\xa5\xe3", "1",
   "\xa4\xc6\xa4\xa3", "\xa5\xc6\xa5\xa3", "1",
   "\xa4\xc6", "\xa5\xc6", "1",
   "\xa4\xc5", "\xa5\xc5", "1",
   "\xa4\xc4\xa4\xa9", "\xa5\xc4\xa5\xa9", "1",
   "\xa4\xc4\xa4\xa7", "\xa5\xc4\xa5\xa7", "1",
   "\xa4\xc4\xa4\xa3", "\xa5\xc4\xa5\xa3", "1",
   "\xa4\xc4\xa4\xa1", "\xa5\xc4\xa5\xa1", "1",
   "\xa4\xc4", "\xa5\xc4", "1",
   "\xa4\xc3", "\xa5\xc3", "1",
   "\xa4\xc2", "\xa5\xc2", "1",
   "\xa4\xc1\xa4\xe7", "\xa5\xc1\xa5\xe7", "1",
   "\xa4\xc1\xa4\xe5", "\xa5\xc1\xa5\xe5", "1",
   "\xa4\xc1\xa4\xe3", "\xa5\xc1\xa5\xe3", "1",
   "\xa4\xc1\xa4\xa7", "\xa5\xc1\xa5\xa7", "1",
   "\xa4\xc1", "\xa5\xc1", "1",
   "\xa4\xc0", "\xa5\xc0", "1",
   "\xa4\xbf", "\xa5\xbf", "1",
   "\xa4\xbe", "\xa5\xbe", "1",
   "\xa4\xbd", "\xa5\xbd", "1",
   "\xa4\xbc", "\xa5\xbc", "1",
   "\xa4\xbb", "\xa5\xbb", "1",
   "\xa4\xba\xa4\xa3", "\xa5\xba\xa5\xa3", "1",
   "\xa4\xba", "\xa5\xba", "1",
   "\xa4\xb9\xa4\xa3", "\xa5\xb9\xa5\xa3", "1",
   "\xa4\xb9", "\xa5\xb9", "1",
   "\xa4\xb8\xa4\xe7", "\xa5\xb8\xa5\xe7", "1",
   "\xa4\xb8\xa4\xe5", "\xa5\xb8\xa5\xe5", "1",
   "\xa4\xb8\xa4\xe3", "\xa5\xb8\xa5\xe3", "1",
   "\xa4\xb8\xa4\xa7", "\xa5\xb8\xa5\xa7", "1",
   "\xa4\xb8", "\xa5\xb8", "1",
   "\xa4\xb7\xa4\xe7", "\xa5\xb7\xa5\xe7", "1",
   "\xa4\xb7\xa4\xe5", "\xa5\xb7\xa5\xe5", "1",
   "\xa4\xb7\xa4\xe3", "\xa5\xb7\xa5\xe3", "1",
   "\xa4\xb7\xa4\xa7", "\xa5\xb7\xa5\xa7", "1",
   "\xa4\xb7", "\xa5\xb7", "1",
   "\xa4\xb6", "\xa5\xb6", "1",
   "\xa4\xb5", "\xa5\xb5", "1",
   "\xa4\xb4", "\xa5\xb4", "1",
   "\xa4\xb3", "\xa5\xb3", "1",
   "\xa4\xb2", "\xa5\xb2", "1",
   "\xa4\xb1", "\xa5\xb1", "1",
   "\xa4\xb0", "\xa5\xb0", "1",
   "\xa4\xaf", "\xa5\xaf", "1",
   "\xa4\xae\xa4\xe7", "\xa5\xae\xa5\xe7", "1",
   "\xa4\xae\xa4\xe5", "\xa5\xae\xa5\xe5", "1",
   "\xa4\xae\xa4\xe3", "\xa5\xae\xa5\xe3", "1",
   "\xa4\xae\xa4\xa7", "\xa5\xae\xa5\xa7", "1",
   "\xa4\xae", "\xa5\xae", "1",
   "\xa4\xad\xa4\xe7", "\xa5\xad\xa5\xe7", "1",
   "\xa4\xad\xa4\xe5", "\xa5\xad\xa5\xe5", "1",
   "\xa4\xad\xa4\xe3", "\xa5\xad\xa5\xe3", "1",
   "\xa4\xad\xa4\xa7", "\xa5\xad\xa5\xa7", "1",
   "\xa4\xad", "\xa5\xad", "1",
   "\xa4\xac", "\xa5\xac", "1",
   "\xa4\xab", "\xa5\xab", "1",
   "\xa4\xaa", "\xa5\xaa", "1",
   "\xa4\xa9", "\xa5\xa9", "1",
   "\xa4\xa8", "\xa5\xa8", "1",
   "\xa4\xa7", "\xa5\xa7", "1",
   "\xa4\xa6\xa4\xa9", "\xa5\xa6\xa5\xa9", "1",
   "\xa4\xa6\xa4\xa7", "\xa5\xa6\xa5\xa7", "1",
   "\xa4\xa6\xa4\xa3", "\xa5\xa6\xa5\xa3", "1",
   "\xa4\xa6", "\xa5\xa6", "1",
   "\xa4\xa5", "\xa5\xa5", "1",
   "\xa4\xa4\xa4\xa7", "\xa5\xa4\xa5\xa7", "1",
   "\xa4\xa4", "\xa5\xa4", "1",
   "\xa4\xa3", "\xa5\xa3", "1",
   "\xa4\xa2", "\xa5\xa2", "1",
   "\xa4\xa1", "\xa5\xa1", "1",
   "\xa3\xfa", "\xa5\xba\xa5\xa3\xa1\xbc", "2",
   "\xa3\xf9", "\xa5\xef\xa5\xa4", "2",
   "\xa3\xf8", "\xa5\xa8\xa5\xc3\xa5\xaf\xa5\xb9", "4",
   "\xa3\xf7", "\xa5\xc0\xa5\xd6\xa5\xea\xa5\xe5\xa1\xbc", "4",
   "\xa3\xf6", "\xa5\xd6\xa5\xa4", "2",
   "\xa3\xf5", "\xa5\xe6\xa1\xbc", "2",
   "\xa3\xf4", "\xa5\xc6\xa5\xa3\xa1\xbc", "2",
   "\xa3\xf3", "\xa5\xa8\xa5\xb9", "2",
   "\xa3\xf2", "\xa5\xa2\xa1\xbc\xa5\xeb", "3",
   "\xa3\xf1", "\xa5\xad\xa5\xe5\xa1\xbc", "2",
   "\xa3\xf0", "\xa5\xd4\xa1\xbc", "2",
   "\xa3\xef", "\xa5\xaa\xa1\xbc", "2",
   "\xa3\xee", "\xa5\xa8\xa5\xcc", "2",
   "\xa3\xed", "\xa5\xa8\xa5\xe0", "2",
   "\xa3\xec", "\xa5\xa8\xa5\xeb", "2",
   "\xa3\xeb", "\xa5\xb1\xa1\xbc", "2",
   "\xa3\xea", "\xa5\xb8\xa5\xa7\xa1\xbc", "2",
   "\xa3\xe9", "\xa5\xa2\xa5\xa4", "2",
   "\xa3\xe8", "\xa5\xa8\xa5\xa4\xa5\xc1", "3",
   "\xa3\xe7", "\xa5\xb8\xa1\xbc", "2",
   "\xa3\xe6", "\xa5\xa8\xa5\xd5", "2",
   "\xa3\xe5", "\xa5\xa4\xa1\xbc", "2",
   "\xa3\xe4", "\xa5\xc7\xa5\xa3\xa1\xbc", "2",
   "\xa3\xe3", "\xa5\xb7\xa1\xbc", "2",
   "\xa3\xe2", "\xa5\xd3\xa1\xbc", "2",
   "\xa3\xe1", "\xa5\xa8\xa1\xbc", "2",
   "\xa3\xda", "\xa5\xba\xa5\xa3\xa1\xbc", "2",
   "\xa3\xd9", "\xa5\xef\xa5\xa4", "2",
   "\xa3\xd8", "\xa5\xa8\xa5\xc3\xa5\xaf\xa5\xb9", "4",
   "\xa3\xd7", "\xa5\xc0\xa5\xd6\xa5\xea\xa5\xe5\xa1\xbc", "4",
   "\xa3\xd6", "\xa5\xd6\xa5\xa4", "2",
   "\xa3\xd5", "\xa5\xe6\xa1\xbc", "2",
   "\xa3\xd4", "\xa5\xc6\xa5\xa3\xa1\xbc", "2",
   "\xa3\xd3", "\xa5\xa8\xa5\xb9", "2",
   "\xa3\xd2", "\xa5\xa2\xa1\xbc\xa5\xeb", "3",
   "\xa3\xd1", "\xa5\xad\xa5\xe5\xa1\xbc", "2",
   "\xa3\xd0", "\xa5\xd4\xa1\xbc", "2",
   "\xa3\xcf", "\xa5\xaa\xa1\xbc", "2",
   "\xa3\xce", "\xa5\xa8\xa5\xcc", "2",
   "\xa3\xcd", "\xa5\xa8\xa5\xe0", "2",
   "\xa3\xcc", "\xa5\xa8\xa5\xeb", "2",
   "\xa3\xcb", "\xa5\xb1\xa1\xbc", "2",
   "\xa3\xca", "\xa5\xb8\xa5\xa7\xa1\xbc", "2",
   "\xa3\xc9", "\xa5\xa2\xa5\xa4", "2",
   "\xa3\xc8", "\xa5\xa8\xa5\xa4\xa5\xc1", "3",
   "\xa3\xc7", "\xa5\xb8\xa1\xbc", "2",
   "\xa3\xc6", "\xa5\xa8\xa5\xd5", "2",
   "\xa3\xc5", "\xa5\xa4\xa1\xbc", "2",
   "\xa3\xc4", "\xa5\xc7\xa5\xa3\xa1\xbc", "2",
   "\xa3\xc3", "\xa5\xb7\xa1\xbc", "2",
   "\xa3\xc2", "\xa5\xd3\xa1\xbc", "2",
   "\xa3\xc1", "\xa5\xa8\xa1\xbc", "2",
   "\xa1\xbc", "\xa1\xbc", "1",
   NULL, NULL, NULL
};

#define NJD_SET_PRONUNCIATION_KIGOU "\xb5\xad\xb9\xe6"
#define NJD_SET_PRONUNCIATION_KAZU "\xbf\xf4"

static const char *njd_set_pronunciation_symbol_list[] = {
   "\xa1\xa9", "\xa1\xa9",
   NULL, NULL
};

#define NJD_SET_PRONUNCIATION_FILLER "\xa5\xd5\xa5\xa3\xa5\xe9\xa1\xbc"

#define NJD_SET_PRONUNCIATION_U        "\xa5\xa6"
#define NJD_SET_PRONUNCIATION_DOUSHI   "\xc6\xb0\xbb\xec"
#define NJD_SET_PRONUNCIATION_JODOUSHI "\xbd\xf5\xc6\xb0\xbb\xec"
#define NJD_SET_PRONUNCIATION_CHOUON   "\xa1\xbc"

#define NJD_SET_PRONUNCIATION_QUESTION  "\xa1\xa9"
#define NJD_SET_PRONUNCIATION_DESU_STR  "\xa4\xc7\xa4\xb9"
#define NJD_SET_PRONUNCIATION_MASU_STR  "\xa4\xde\xa4\xb9"
#define NJD_SET_PRONUNCIATION_DESU_PRON "\xa5\xc7\xa5\xb9"
#define NJD_SET_PRONUNCIATION_MASU_PRON "\xa5\xde\xa5\xb9"

#define NJD_SET_PRONUNCIATION_TOUTEN "\xa1\xa2"

NJD_SET_PRONUNCIATION_RULE_H_END;

#endif                          /* !NJD_SET_PRONUNCIATION_RULE_H */
